/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/


#ifndef _SD_VECTDLG_HXX
#define _SD_VECTDLG_HXX

#include <vcl/button.hxx>
#include <vcl/group.hxx>
#include <vcl/fixed.hxx>
#include <vcl/field.hxx>
#include <vcl/dialog.hxx>
#include <vcl/gdimtf.hxx>
#include <svx/graphctl.hxx>
#include <svtools/prgsbar.hxx>

namespace sd {
class DrawDocShell;
}

/******************************************************************************
|*
|* SdVectorizeDlg
|*
\******************************************************************************/

class SdVectorizeDlg : public ModalDialog
{
    ::sd::DrawDocShell *	mpDocSh;
    FixedLine			aGrpSettings;
    FixedText			aFtLayers;
    NumericField		aNmLayers;
    FixedText			aFtReduce;
    MetricField			aMtReduce;
    FixedText			aFtFillHoles;
    MetricField			aMtFillHoles;
    CheckBox			aCbFillHoles;

    FixedText			aFtOriginal;
    GraphCtrl			aBmpWin;

    FixedText			aFtVectorized;
    GraphCtrl			aMtfWin;

    FixedText			aGrpPrgs;
    ProgressBar			aPrgs;

    OKButton			aBtnOK;
    CancelButton		aBtnCancel;
    HelpButton			aBtnHelp;
    PushButton			aBtnPreview;

    Bitmap				aBmp;
    Bitmap				aPreviewBmp;
    GDIMetaFile			aMtf;

    void				LoadSettings();
    void				SaveSettings() const;
    void				InitPreviewBmp();
    void				UpdatePreviewMtf();

    Rectangle			GetRect( const Size& rDispSize, const Size& rBmpSize ) const;
    Bitmap				GetPreparedBitmap( Bitmap& rBmp, Fraction& rScale );
    void				Calculate( Bitmap& rBmp, GDIMetaFile& rMtf );
    void				AddTile( BitmapReadAccess* pRAcc, GDIMetaFile& rMtf,
                                 long nPosX, long nPosY, long nWidth, long nHeight );

                        DECL_LINK( ProgressHdl, void* );
                        DECL_LINK( ClickPreviewHdl, PushButton* );
                        DECL_LINK( ClickOKHdl, OKButton* );
                        DECL_LINK( ToggleHdl, CheckBox* );
                        DECL_LINK( ModifyHdl, void* );

public:

                        SdVectorizeDlg( Window* pParent, const Bitmap& rBmp, ::sd::DrawDocShell* pDocShell );
                        ~SdVectorizeDlg();

    const GDIMetaFile&	GetGDIMetaFile() const { return aMtf; }
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
