/***************************************************************************
                          contactlistviewitem.h  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTLISTVIEWITEM_H
#define CONTACTLISTVIEWITEM_H

#include "kmesslistviewitem.h"
#include <qobject.h>

// Forward declarations
class Contact;
class EmoticonCollection;
class QString;
class QListView;
class QListViewItem;

/**
 * @author Mike K. Bennett
 */
class ContactListViewItem : public QObject, public KMessListViewItem
{
  Q_OBJECT

  public:
    // The constructor
                         ContactListViewItem(QListView *parent, Contact *contact);
    // The constructor
                         ContactListViewItem(QListViewItem *parent, Contact *contact);
    // Compare
//    virtual int          compare( QListViewItem *item, int column, bool ascending ) const;
    // Return the contact
    Contact *            getContact() const;
    // Return the identifier (primarily used for sorting)
    const QString &      getIdentifier() const;
    // Get whether the contact is online or not
    unsigned int         getOnlineStatus() const;

  protected:
    // Return the type of the item
    int                  getType() const;

  private: // Private methods
    // Do general construction
    void                 construct();
    // Update the item's text
    void                 updateItemText();

  private slots:
    // Update the friendly name of the contact
    void                 slotUpdateFriendlyName();
    // Update the status icon of the contact
    void                 slotUpdateStatus();
    // Update the visibility of the contact
    void                 slotUpdateVisiblity();

  private: // Private attributes

    // The contact to embed.
    Contact             *contact_;
    // The meoticon parser
    EmoticonCollection  *emoticons_;
    // The url tag t othe contact or group's icon
    QString              iconTag_;
    // The contact or group's identifier
    QString              identifier_;
    // Whether the identifier is italicised
    bool                 italicIdentifier_;
    // Whether the contact is online or offline
    unsigned int         onlineStatus_;
    // The contact or group's status identifier
    QString              statusIdentifier_;
};

#endif
