/***************************************************************************
                          contactdrag.cpp  -  description
                             -------------------
    begin                : Sat 22 Mar 2003
    copyright            : (C) 2003 by Michael Curtis.
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactdrag.h"

#include <qdragobject.h>
#include <qpixmap.h>

#include <kstandarddirs.h>

// the constructor
ContactDragObject::ContactDragObject( QWidget *dragSource, const char * name )
 : QDragObject( dragSource, name )
{
  KStandardDirs *dirs   = KGlobal::dirs();
  QPixmap        pixmap;
  QString        path;

  path = dirs->findResource( "data", "kmess/pics/online.png" );
  pixmap.load( path );

  setPixmap( pixmap );
}



// the destructor
ContactDragObject::~ContactDragObject()
{
}



// return the mimetype provided by its index number
const char * ContactDragObject::format( int index ) const
{
  if ( index == 0)
  {
    return ContactDragInfo::mimeType;
  }
  
  return 0;
}



// return a boolean value indicating whether we can return this mimetype
bool ContactDragObject::provides( const char * mimeType ) const
{
  if ( strcmp( mimeType, ContactDragInfo::mimeType) == 0 )
  {
    return true;
  }
  
  return false;
}



// decodes the mime data in the format given
QByteArray ContactDragObject::encodedData ( const char * /*mimeType*/ ) const
{
  QByteArray byte;
  
  return byte;
}
