/*
    This file is part of ksync.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef CALENDARSYNCEE_H
#define CALENDARSYNCEE_H

#include <calendarlocal.h>
#include <kdepimmacros.h>
#include "ksyncer.h"

using namespace KCal;

class KDE_EXPORT CalendarSyncEntry : public KSyncEntry
{
  public:
    CalendarSyncEntry(Incidence *);

    QString name();
    QString id();
    QString timestamp();

    bool equals(KSyncEntry *entry);

    Incidence *incidence() { return mIncidence; }

  private:
    Incidence *mIncidence;
};

/**
  This class provides an implementation of the KSyncee interface for KSync.
  It provides syncing of iCalendar files.
*/
class KDE_EXPORT CalendarSyncee : public KSyncee
{
  public:
    CalendarSyncee();
    ~CalendarSyncee();

    CalendarSyncEntry *firstEntry();
    CalendarSyncEntry *nextEntry();

//    CalendarSyncEntry *findEntry(const QString &id);

    void addEntry(KSyncEntry *);
    void removeEntry(KSyncEntry *);

    bool read();
    bool write();

  private:
    CalendarSyncEntry *createEntry(Incidence *);

    CalendarLocal *mCalendar;
    Event::List mEvents;
    Event::List::ConstIterator mCurrentEvent;

    QPtrList<CalendarSyncEntry> mEntries;
};

#endif
