/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "i_hide_from_u_list.h"
#include "powerkadu.h"

#include "userlist.h"
#include "config_dialog.h"
#include "debug.h"

IHideFromUList::IHideFromUList(QObject *parent, const char *name)
: QObject(parent, name)
{
	kdebugf();
	readCfg();
	for(UserList::iterator it = userlist->begin(); it != userlist->end(); ++it)
		if((*it).protocolList().contains("Gadu"))
			if( (!avoidedUins.contains((*it).ID("Gadu"))) && ((*it).ID("Gadu") != "") )
				availableUins += (*it).ID("Gadu");
	kdebugf2();
}

IHideFromUList::~IHideFromUList()
{
	kdebugf();
	writeCfg();
	kdebugf2();
}

QStringList IHideFromUList::getAvailableContacts()
{
	kdebugf();
	QStringList result;
	for(QStringList::ConstIterator it = availableUins.begin(); it != availableUins.end(); ++it)
		result += userlist->byID("Gadu", (*it)).altNick();
	return result;
}

QStringList IHideFromUList::getAvoidedContacts()
{
	kdebugf();
	QStringList result;
	for(QStringList::ConstIterator it = avoidedUins.begin(); it != avoidedUins.end(); ++it)
		result += userlist->byID("Gadu", (*it)).altNick();
	return result;
}

void IHideFromUList::set(QStringList list)
{
	kdebugf();
	availableUins.clear();
	avoidedUins.clear();
	for(QStringList::ConstIterator it = list.begin(); it != list.end(); ++it)
		if(userlist->byAltNick(*it).protocolList().contains("Gadu"))
			avoidedUins += userlist->byAltNick(*it).ID("Gadu");
	for(UserList::const_iterator it = userlist->begin(); it != userlist->end(); ++it)
		if((*it).protocolList().contains("Gadu"))
			if(!avoidedUins.contains((*it).ID("Gadu")))
				availableUins += (*it).ID("Gadu");
	kdebugf2();
}

	
void IHideFromUList::readCfg()
{
	kdebugf();
	QString uins = powerKadu->cfg()->readEntry("PowerKadu", "powerkadu_i_hide_from_u_list");
	if(uins != "")
		avoidedUins = QStringList::split(',', uins);
	kdebugm(KDEBUG_INFO, "%s\n", uins.data());
	kdebugf2();
}

void IHideFromUList::writeCfg()
{
	kdebugf();
	QString uins;
	for(QStringList::Iterator it = avoidedUins.begin(); it != avoidedUins.end(); ++it)
	{
		kdebugm(KDEBUG_INFO, "%s\n", (*it).data());
		uins += "," + (*it);
	}
	uins = uins.right(uins.length() - 1);
	powerKadu->cfg()->writeEntry("PowerKadu", "powerkadu_i_hide_from_u_list", uins);
	kdebugf2();
}

