#include "cenzor.h"
#include "powerkadu.h"

#include "chat.h"
#include "protocol.h"
#include "debug.h"
#include "misc.h"
#include "config_dialog.h"
#include "config_file.h"
#include "modules/notify/notify.h"
#include "icons_manager.h"

#include <qregexp.h>
#include <qspinbox.h>
#include <qstringlist.h>

Cenzor::Cenzor(PowerKadu *pk)
{
	kdebugf();

	connect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)),
		this,   SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));

	ConfigDialog::registerSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));

	create_gui();

	words_read();

	kdebugf2();
}

Cenzor::~Cenzor()
{
	kdebugf();

	words_save();

	ConfigDialog::unregisterSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));

	kill_gui();
    
	disconnect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)), this, SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));

	kdebugf2();
}

void Cenzor::messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop)
{
	kdebugf();

	if (config_file.readEntry("PowerKadu", "enable_cenzor") == "true")
	{
		if ( check(msg) >= 1 )
    	{
			admonition(senders);

		if (config_file.readEntry("PowerKadu", "enable_hint_cenzor") == "true")
		{
			QMap<QString,QVariant> parms;
				parms["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/powerkadu/powerkadu_32x32.png"));
				parms["ShowSource"] = bool(FALSE);
				parms["Foreground color"] = config_file.readEntry("PowerKadu", "cenzor_hint_text_color");
				parms["Background color"] = config_file.readEntry("PowerKadu", "cenzor_hint_bg_color");
				parms["Timeout"] = config_file.readEntry("PowerKadu", "cenzor_hint_time");

				notify->emitMessage(QString::null, QString::null, config_file.readEntry("PowerKadu", "hint_content_cenzor"), &parms);
		}

		}

	kdebugf2();
}
}

int Cenzor::check(QCString& msg)
{
	kdebugf();
	int il_w = 0;

	QStringList list = QStringList::split(" ", msg);

	for( QStringList::Iterator it = list.begin(); it != list.end(); it++)
	{
		for ( QStringList::Iterator itw = listWords.begin(); itw != listWords.end(); itw++)
			if( ((*it).find(QRegExp((*itw),true)) >= 0) && (!checkOkWords((*it))) )	{ il_w+=1; }
	}

	return il_w;
	kdebugf2();
}

void Cenzor::admonition(UserListElements senders)
{
	gadu->sendMessage(senders, unicode2cp(config_file.readEntry("PowerKadu", "admonition_content_cenzor")));
}

int Cenzor::checkOkWords(QString txt)
{
	kdebugf();

	for(QStringList::Iterator p = okList.begin(); p != okList.end(); p++)
		if (txt.find(QRegExp((*p),true)) >= 0)
			return 1;

	return 0;
	kdebugf2();
}

void Cenzor::words_read()
{
	kdebugf();

	QString data = config_file.readEntry("PowerKadu", "cenzor swearwords");
		listWords = QStringList::split("\t", data);

		if (!listWords.count())
		{

			QFile file(dataPath("kadu/modules/data/powerkadu/cenzor_words.conf"));

			if (file.open(IO_ReadOnly))
			{
				QTextStream stream(&file);

				while (!stream.atEnd())
				{
					listWords += stream.readLine();
				}
			}
			else
			{
				kdebug(QString("Can't open file: %1").arg(file.name()));
			}

			file.close();
		}


	QFile file_ok(dataPath("kadu/modules/data/powerkadu/cenzor_words_ok.conf"));

	if (file_ok.open(IO_ReadOnly))
	{
		QTextStream stream_ok(&file_ok);

		while (!stream_ok.atEnd())
		{
			okList += stream_ok.readLine();
		}
	}
	else
	{
		kdebug(QString("Can't open file: %1").arg(file_ok.name()));
	}

	file_ok.close();

	kdebugf2();
}

void Cenzor::words_save()
{
	kdebugf();

	QStringList swearwords_list;
    
	for ( QStringList::Iterator it = listWords.begin(); it != listWords.end(); it++)
	{
		swearwords_list.append(*it);
	}
	
	config_file.writeEntry("PowerKadu", "cenzor swearwords", swearwords_list.join("\t"));

	kdebugf2();
}

void Cenzor::AddListbox()
{                                                                                                               
	kdebugf();

	QListBox *badList = ConfigDialog::getListBox("PowerKadu", "swearwords_listbox", "name");
              badList->clear();

	for ( QStringList::Iterator it = listWords.begin(); it != listWords.end(); it++ )
	{
		badList->insertItem(*it);
	}

	kdebugf2();
}

void Cenzor::onCreateTab()
{
	kdebugf();

	QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "swearwords_listbox", "name");
	QPushButton *change = ConfigDialog::getPushButton("PowerKadu", "Change selected", "Change selected");
	QPushButton *addNew = ConfigDialog::getPushButton("PowerKadu", "Add new swearword", "Add new swearword");
	QPushButton *del = ConfigDialog::getPushButton("PowerKadu", "Delete selected", "Delete selected");

	connect(listbox, SIGNAL(highlighted(int)), this, SLOT(swearwordSelected(int)));
	connect(change, SIGNAL(clicked()), this, SLOT(changeSwearword()));
	connect(addNew, SIGNAL(clicked()), this, SLOT(addNew()));
	connect(del, SIGNAL(clicked()), this, SLOT(deleteSwear()));

	ConfigDialog::getSpinBox("PowerKadu", "Hint time: ")->setSuffix(" s");

	AddListbox();

	kdebugf2();
}

void Cenzor::swearwordSelected(int index)
{
	kdebugf();

	QLineEdit* Swear = ConfigDialog::getLineEdit("PowerKadu", "Swearword: ");

	Swear->setText(listWords[index]);

	kdebugf2();
}


void Cenzor::changeSwearword()
{
	kdebugf();

	QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "swearwords_listbox", "name");
	QLineEdit* Swear = ConfigDialog::getLineEdit("PowerKadu", "Swearword: ");

	int index = listbox->currentItem();

	if(listbox->currentItem() == -1)
	return;

	QString swear = Swear->text();

	if (swear.isEmpty())
	return;

	listbox->changeItem(swear, index);

	listWords[index]=swear;

	Swear->setText("");

	kdebugf2();
}

void Cenzor::addNew()
{
	kdebugf();

	QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "swearwords_listbox", "name");
	QLineEdit* newSwear = ConfigDialog::getLineEdit("PowerKadu", "New swearword: ");

	QString Newswear = newSwear->text();

	if(Newswear.isEmpty())
	return;

	listbox->insertItem(Newswear);

	listWords+=Newswear;

	newSwear->setText("");

	kdebugf2();
}

void Cenzor::deleteSwear()
{
	kdebugf();

	QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "swearwords_listbox", "name");

	int index = listbox->currentItem();

	for (uint i = index; i < listWords.count()-1; i++)
		listWords[i]=listWords[i+1];

	listWords.pop_back();

	AddListbox();

	kdebugf2();
}

void Cenzor::create_gui()
{
	kdebugf();

	ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu", "Cenzor");

	ConfigDialog::addCheckBox("PowerKadu", "Cenzor", QT_TRANSLATE_NOOP("@default", "Enable Cenzor"), 
					"enable_cenzor", false, QString::null);

    ConfigDialog::addLineEdit("PowerKadu", "Cenzor", QT_TRANSLATE_NOOP("@default", "Admonition:"), "admonition_content_cenzor", 
					QT_TRANSLATE_NOOP("@default", "Cenzor: Watch your mouth!! <nonono>"));

	ConfigDialog::addVGroupBox("PowerKadu", "Cenzor", QT_TRANSLATE_NOOP("@default", "Config hint"));
	ConfigDialog::addCheckBox("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"), QT_TRANSLATE_NOOP("@default", "Enable hint"), 
					"enable_hint_cenzor", false, QString::null);
	ConfigDialog::addColorButton("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"), QT_TRANSLATE_NOOP("@default", "Hint color:"), "cenzor_hint_bg_color",
					QColor(255, 255, 0));
	ConfigDialog::addColorButton("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"), QT_TRANSLATE_NOOP("@default", "Hint text color:"), "cenzor_hint_text_color", 
					QColor(0, 0, 128));
	ConfigDialog::addLineEdit("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"), QT_TRANSLATE_NOOP("@default", "Message in hint:"), "hint_content_cenzor",
					QT_TRANSLATE_NOOP("@default", "<b>Cenzor</b><br>Your interlocutor used obscene word<br>and became admonished"), QString::null);
	ConfigDialog::addSpinBox("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"), QT_TRANSLATE_NOOP("@default","Hint time: "), "cenzor_hint_time", 0, 3500, 1, 8, 
					QString::null);

	ConfigDialog::addHBox("PowerKadu", "Cenzor", "config swearwords");

	ConfigDialog::addListBox("PowerKadu", "config swearwords",
					"swearwords_listbox", QT_TRANSLATE_NOOP("@default", "swearwords list"), "name");

	ConfigDialog::addVBox("PowerKadu", "config swearwords", "config swearwords2");

	ConfigDialog::addHBox("PowerKadu", "config swearwords2", "config swearwords3");

	ConfigDialog::addLineEdit2("PowerKadu", "config swearwords3", QT_TRANSLATE_NOOP("@default", "New swearword: "), QString::null, QString::null);

	ConfigDialog::addPushButton("PowerKadu", "config swearwords3", QT_TRANSLATE_NOOP("@default", "Add new swearword"),
					"add new swearword", NULL, "Add new swearword");

	ConfigDialog::addVBox("PowerKadu", "config swearwords2", "config swearwords4");

	ConfigDialog::addPushButton("PowerKadu", "config swearwords4", QT_TRANSLATE_NOOP("@default", "Delete selected"),
					"delete selected", NULL, "Delete selected");

	ConfigDialog::addHBox("PowerKadu", "config swearwords4", "config swearwords5");

	ConfigDialog::addLineEdit2("PowerKadu", "config swearwords5", QT_TRANSLATE_NOOP("@default", "Swearword: "), QString::null, QString::null);

	ConfigDialog::addPushButton("PowerKadu", "config swearwords5", QT_TRANSLATE_NOOP("@default", "Change selected"),
					"change selected", NULL, "Change selected");

	kdebugf2();
}

void Cenzor::kill_gui()
{
	kdebugf();

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Change selected"), "Change selected");

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Swearword: "));

	ConfigDialog::removeControl("PowerKadu", "config swearwords5");

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Delete selected"), "Delete selected");

	ConfigDialog::removeControl("PowerKadu", "config swearwords4");

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Add new swearword"), "Add new swearword");

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "New swearword: "));

	ConfigDialog::removeControl("PowerKadu", "config swearwords3");

	ConfigDialog::removeControl("PowerKadu", "config swearwords2");

	ConfigDialog::removeControl("PowerKadu", "swearwords_listbox", "name");

	ConfigDialog::removeControl("PowerKadu", "config swearwords");

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Hint time: "));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Message in hint:"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Hint text color:"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Hint color:"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Enable hint"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Config hint"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Admonition:"));

	ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("@default", "Enable Cenzor"));

	ConfigDialog::removeControl("PowerKadu", "Cenzor");

	kdebugf2();
}
