/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "antistring.h"
#include "powerkadu.h"

#include "chat.h"
#include "chat_manager.h"
#include "config_dialog.h"
#include "misc.h"
#include "debug.h"
#include "modules/notify/notify.h"
#include "protocol.h"
#include "icons_manager.h"

//#include "message_box.h"
#include <qlistbox.h>
#include <qprocess.h>
#include <qregexp.h>
#include <qspinbox.h>
#include <qmap.h>


Antistring::Antistring(PowerKadu *pk)
{
    connect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)),
	this,   SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));

    create_gui();
    conditions_read();
}

Antistring::~Antistring()
{
    kill_gui();
    conditions_save();
    disconnect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)),
	       this, SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));
}

void Antistring::messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop)
{
    kdebugf();
    
//    ConfigDialog::addCheckBox("PowerKadu", "Antistring", "enable Antistring", "enable_antistring", false, "enable_antistring");

    if (config_file.readEntry("PowerKadu", "enable_antistring") == "true") {
	if ( punkty(msg) >= 3 ) {

	    if (config_file.readEntry("PowerKadu", "hint_en_config") == "true") {
		QMap<QString,QVariant> parms;
        	    parms["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/powerkadu/.png"));
	    	    parms["ShowSource"] = bool(FALSE);
		    parms["Foreground color"] = config_file.readEntry("PowerKadu", "hint_text_color");
    		    parms["Background color"] = config_file.readEntry("PowerKadu", "hint_bg_color");
		    parms["Timeout"] = config_file.readEntry("PowerKadu", "time");

        	    notify->emitMessage(QString::null, QString::null, config_file.readEntry("PowerKadu", "hint_tresc_config"), &parms);
	    }

	    pouczenie(senders);

	    if (config_file.readEntry("PowerKadu", "message stop") == "true") {
    		stop = true;
	    }

	    if (config_file.readEntry("PowerKadu", "log message") == "true") {
		writeLog(senders, msg);
	    }

	    if (config_file.readEntry("PowerKadu", "msg_en_config") == "true") {
		msg = QCString(unicode2cp(config_file.readEntry("PowerKadu", "msg_tresc_config1"))) +
				"\n\n" + msg + "\n\n" + QCString(unicode2cp(config_file.readEntry("PowerKadu",
				"msg_tresc_config2")));//"\n\n ================================\n||           kolejne chujowstwo\n================================";
	    }
	}
    }
    kdebugf2();
}

void Antistring::writeLog(UserListElements uin, QString msg)
{
        kdebugf();

        QFile log_file(config_file.readEntry("PowerKadu", "log file", ggPath("antistring.log")));

        if (!log_file.exists())
        {
                log_file.open(IO_WriteOnly);
                QTextStream stream( &log_file );
                stream << tr("     DATA AND TIME      ::   UIN   ::    MESSAGE\n") << "====================================================\n";
                log_file.close();
        }

        log_file.open(IO_WriteOnly | IO_Append);
        QTextStream stream( &log_file );
        stream << QDateTime::currentDateTime(Qt::LocalTime).toString() << " :: " << uin[0].ID("Gadu") << " :: " << msg << "\n";
        log_file.close();

        kdebugf2();
}


int Antistring::punkty(QCString& msg)
{
    kdebugf();
    int il_p = 0;
    
    if (msg.length() > 600 )	{ il_p +=1; }
    
    for ( uint i = 0; i < conditions1.keys().count(); i++ )
    {
	if (msg.find(QRegExp(conditions1[i],true)) >= 0 )	{il_p += conditions[i]; }
    }

/*    QMap<QString,QVariant> parms;
        parms["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/powerkadu/!!.png"));
        parms["ShowSource"] = bool(FALSE);
	parms["Foreground color"] = config_file.readEntry("PowerKadu", "hint_text_color");
    	parms["Background color"] = config_file.readEntry("PowerKadu", "hint_bg_color");
	parms["Timeout"] = "5";

        notify->emitMessage(QString::null, QString::null, QString::number(il_p), &parms);*/

    return il_p;
    kdebugf2();
}

void Antistring::pouczenie(UserListElements senders)
{
    gadu->sendMessage(senders, unicode2cp(config_file.readEntry("PowerKadu", "pouczenie_tresc_config")));
}

/*void Antistring::toggled_log(bool toggled)
{
    kdebugf();
    ConfigDialog::getLineEdit("PowerKadu", "", "log file path")->setEnabled(toggled);

	    QMap<QString,QVariant> parms;
        	parms["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/powerkadu/!!.png"));
	        parms["ShowSource"] = bool(FALSE);
		parms["Foreground color"] = config_file.readEntry("PowerKadu", "hint_text_color");
    		parms["Background color"] = config_file.readEntry("PowerKadu", "hint_bg_color");
		parms["Timeout"] = config_file.readEntry("PowerKadu", "time");

        	notify->emitMessage(QString::null, QString::null, "dobra, no to mamy zalatwione ze se kliknalem :P", &parms);

    kdebugf2();
}*/


void Antistring::conditions_save()
{
        QStringList conditions_list;
        for ( uint i = 0; i < conditions.keys().count(); i++ )
        {
                conditions_list.append(QString::number(conditions[i])+"\t"+conditions1[i]);
        }
        config_file.writeEntry("PowerKadu", "antisting conditions", conditions_list.join("\t\t"));
}


void Antistring::conditions_read()
{
    kdebugf();
	int i=0;
	bool ok;
        QString data = config_file.readEntry("PowerKadu", "antisting conditions");
        QStringList list = QStringList::split("\t\t", data);
        if (!list.count())
        {
		QFile defList(dataPath("kadu/modules/data/powerkadu/ant_conditions.conf"));
                if (defList.open(IO_ReadOnly))
                {
                        QTextStream s(&defList);
                        QStringList pair;
                        while (!s.atEnd())
                        {
                                pair = QStringList::split('\t', s.readLine());
                                if (pair.count() <= 0)
                                        continue;
	                            conditions[i]  = pair[0].toInt( &ok, 10);
                    		    conditions1[i] = pair[1];
				    i++;
                        }
                        defList.close();
                }
                else
                {
            	    kdebug(QString("Can't open file: %1").arg(defList.name()));
                }
//	MessageBox::msg("zaladowalem z pliku z dysku");
        }
        else
        {
//	MessageBox::msg("zaladowalem z konfiguracji");

                for ( uint i = 0; i < list.count(); i++ )
                {
                    QStringList sp = QStringList::split('\t', list[i]);
                    conditions[i]  = sp[0].toInt( &ok, 10);
                    conditions1[i] = sp[1];
                }
        }
	


    kdebugf2();
}

void Antistring::create_gui()
{
    kdebugf();
    ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu", QT_TRANSLATE_NOOP("AntTranslate", "Antistring"));
        ConfigDialog::addCheckBox("PowerKadu", "Antistring", QT_TRANSLATE_NOOP("@default", "enable Antistring"),
			"enable_antistring", false, "enable_antistring");
	ConfigDialog::addVGroupBox("PowerKadu", "Antistring", QT_TRANSLATE_NOOP("@default", "conditions antistring"));
	    ConfigDialog::addHBox("PowerKadu", QT_TRANSLATE_NOOP("@default", "conditions antistring"), "conditions config");
		ConfigDialog::addListBox("PowerKadu", QT_TRANSLATE_NOOP("@default", "conditions config"),
				"conditions_listbox", QT_TRANSLATE_NOOP("@default", "conditions list"), "name");
		ConfigDialog::addVBox("PowerKadu", "conditions config", "conditions edit");
		    ConfigDialog::addHBox("PowerKadu", "conditions edit", "conditions config edit");
			ConfigDialog::addSpinBox("PowerKadu", "conditions config edit", QT_TRANSLATE_NOOP("AntTranslate","value condition"),
					"integer", 0, 5, 1, 1, QT_TRANSLATE_NOOP("AntTranslate","value condition"));
			ConfigDialog::addLineEdit2("PowerKadu", "conditions config edit", QT_TRANSLATE_NOOP("@default", "condition: "),
					QString::null, QT_TRANSLATE_NOOP("@default", "condition"));
		    ConfigDialog::addHBox("PowerKadu", "conditions edit", QT_TRANSLATE_NOOP("@default", "conditions edit button"));
			ConfigDialog::addPushButton("PowerKadu", "conditions edit button", QT_TRANSLATE_NOOP("@default", "Delete selected"),
					"Delete selected", NULL, "Delete");
			ConfigDialog::addPushButton("PowerKadu", "conditions edit button", QT_TRANSLATE_NOOP("@default", "Change selected"),
					"Change selected", NULL, "Change");
		    // dodawanie nowego warunku do listy
		    ConfigDialog::addHBox("PowerKadu", "conditions edit", QT_TRANSLATE_NOOP("@default", "conditions config add new"));
			ConfigDialog::addSpinBox("PowerKadu", "conditions config add new", QT_TRANSLATE_NOOP("@default", "new condition (value)"),
					"integer", 0, 5, 1, 1, QT_TRANSLATE_NOOP("@default", "value: 1-5"));
			ConfigDialog::addLineEdit2("PowerKadu", "conditions config add new", QT_TRANSLATE_NOOP("@default", "new condition: "),
					QString::null, QT_TRANSLATE_NOOP("@default", "new condition"));
		    ConfigDialog::addHBox("PowerKadu", "conditions edit", QT_TRANSLATE_NOOP("@default", "conditions edit add new - button"));
			ConfigDialog::addPushButton("PowerKadu", "conditions edit add new - button", QT_TRANSLATE_NOOP("@default", "Add new condition"),
				"add new condition", NULL, "Add new condition");


//	    ConfigDialog::addLineEdit("PowerKadu", "conditions config", "conditions file", "conditions file", ggPath("ant_conditions.conf"), "", "plik w ktorym sa zapisane warunki (wyrazenia regularne) na podstawie ktoryc jest oceniana wypowiedz jako lancuszek szczescia");
	ConfigDialog::addVGroupBox("PowerKadu", "Antistring", QT_TRANSLATE_NOOP("AntTranslate", "instruction config"));
            ConfigDialog::addTextEdit("PowerKadu", "instruction config", QT_TRANSLATE_NOOP("AntTranslate", "admonition: "), "pouczenie_tresc_config", QT_TRANSLATE_NOOP("AntTranslate", "pouczenie text"), QT_TRANSLATE_NOOP("AntTranslate", "pouczenie_tresc"));

	ConfigDialog::addVGroupBox("PowerKadu", "Antistring", QT_TRANSLATE_NOOP("AntTranslate", "hint config"));
	    ConfigDialog::addHBox("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate", "hint config"), "hint config");
		ConfigDialog::addCheckBox("PowerKadu", "hint config", QT_TRANSLATE_NOOP("AntTranslate", "enable the hint"), "hint_en_config", true,
				QT_TRANSLATE_NOOP("AntTranslate", "enable_the_hint"));
		ConfigDialog::addColorButton("PowerKadu", "hint config", QT_TRANSLATE_NOOP("AntTranslate", "hint color: "), "hint_bg_color",
				QColor(255, 0, 153));
		ConfigDialog::addColorButton("PowerKadu", "hint config", QT_TRANSLATE_NOOP("AntTranslate", "hint text color: "), "hint_text_color",
				QColor(0, 0, 128));
        	ConfigDialog::addLineEdit("PowerKadu", "hint config", QT_TRANSLATE_NOOP("AntTranslate", "message in hint: "), "hint_tresc_config",
				QT_TRANSLATE_NOOP("AntTranslate", "message lancuszek szczescia"), QT_TRANSLATE_NOOP("@default", "hint_tresc"));
		ConfigDialog::addSpinBox("PowerKadu", "hint config", QT_TRANSLATE_NOOP("AntTranslate","delay (s/10): "), "time", 0, 3500, 5, 10,
				QT_TRANSLATE_NOOP("AntTranslate","time"));

	ConfigDialog::addVGroupBox("PowerKadu", "Antistring", "msg config");
	    ConfigDialog::addCheckBox("PowerKadu", "msg config", QT_TRANSLATE_NOOP("AntTranslate", "stop message if the message is the 'love string'"),
			    "message stop", false, QT_TRANSLATE_NOOP("@default", "Don\'t display the message if it contains the love string."));
	    ConfigDialog::addVBox("PowerKadu", "msg config", "msg conf");
		ConfigDialog::addHBox("PowerKadu", "msg conf", "msg log file");
		    ConfigDialog::addCheckBox("PowerKadu", "msg log file", QT_TRANSLATE_NOOP("@default", "log all strings"),
			    "log message", false, QT_TRANSLATE_NOOP("@default", "Toggle message logging."));
		    ConfigDialog::addLineEdit("PowerKadu", "msg log file", QT_TRANSLATE_NOOP("@default", "log file:"), "log file",
				    ggPath("antistring.log"), "", "log file path");
		ConfigDialog::addHBox("PowerKadu", "msg conf", "msg config text");
		    ConfigDialog::addCheckBox("PowerKadu", "msg config text", QT_TRANSLATE_NOOP("AntTranslate", "message in the chat window:   "),
				    "msg_en_config", true, QT_TRANSLATE_NOOP("AntTranslate", "enable_the_msg"));
        	    ConfigDialog::addLineEdit("PowerKadu", "msg config text", QT_TRANSLATE_NOOP("AntTranslate", "prefix message: "),
				    "msg_tresc_config1", QT_TRANSLATE_NOOP("AntTranslate", "text prefix"),
				    QT_TRANSLATE_NOOP("@default", "This text is written at the beggining of the love string to let you know where "
					    "does it start."));
        	    ConfigDialog::addLineEdit("PowerKadu", "msg config text", QT_TRANSLATE_NOOP("AntTranslate", "sufix message: "),
				    "msg_tresc_config2", QT_TRANSLATE_NOOP("AntTranslate", "text sufix"),
				    QT_TRANSLATE_NOOP("@default",
					    "This text is written at the end of the string to let you know where does it end."));

//    ConfigDialog::connectSlot("PowerKadu", "log all string", SIGNAL(toggled(bool)), this, SLOT(toggled_log(bool)), "log message");
//    toggled_log(true);
    kdebugf2();
}

void Antistring::kill_gui()
{

    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","admonition: "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","enable the hint"));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","hint color: "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","hint text color: "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","delay (s/10): "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","message in hint: "));

    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","prefix message: "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","sufix message: "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","message in the chat window:   "));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate", "stop message if the message is the 'love string'"));

    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate","enable Antistring"));

    ConfigDialog::removeControl("PowerKadu", "log file:", "log file path");
    ConfigDialog::removeControl("PowerKadu", "log all strings");
    ConfigDialog::removeControl("PowerKadu", "msg config text");
    ConfigDialog::removeControl("PowerKadu", "msg log file");
    ConfigDialog::removeControl("PowerKadu", "msg conf");

    ConfigDialog::removeControl("PowerKadu", "hint config");
    ConfigDialog::removeControl("PowerKadu", "msg config");


    //konfigurowanie warunkow
    ConfigDialog::removeControl("PowerKadu", "Add new condition", "Add new condition");
    ConfigDialog::removeControl("PowerKadu", "Delete selected", "Delete");
    ConfigDialog::removeControl("PowerKadu", "Change selected", "Change");
    //koniec przyciskow
    ConfigDialog::removeControl("PowerKadu", "value condition");
    ConfigDialog::removeControl("PowerKadu", "condition: ");
    ConfigDialog::removeControl("PowerKadu", "conditions config edit");
    ConfigDialog::removeControl("PowerKadu", "conditions edit button");

    ConfigDialog::removeControl("PowerKadu", "new condition (value)");
    ConfigDialog::removeControl("PowerKadu", "new condition: ");
    ConfigDialog::removeControl("PowerKadu", "conditions config add new");
    ConfigDialog::removeControl("PowerKadu", "conditions edit add new - button");

    ConfigDialog::removeControl("PowerKadu", "conditions_listbox", "name");
    ConfigDialog::removeControl("PowerKadu", "conditions edit");

    ConfigDialog::removeControl("PowerKadu", "conditions config");
    ConfigDialog::removeControl("PowerKadu", "conditions antistring");
    //koniec konfigurowalnosci warunkow

    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate", "instruction config"));
    ConfigDialog::removeControl("PowerKadu", QT_TRANSLATE_NOOP("AntTranslate", "Antistring"));

}

void Antistring::WpiszListbox()
{
    QListBox *warunkiLista = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");
              warunkiLista->clear();
    for ( uint i = 0; i < conditions.keys().count(); i++ )
    {
	warunkiLista->insertItem("("+QString::number(conditions[i])+") "+conditions1[i]);
    }
}

void Antistring::onCreateConfig()
{
    QPushButton *addNew = ConfigDialog::getPushButton("PowerKadu", "Add new condition", "Add new condition");
    QPushButton *change = ConfigDialog::getPushButton("PowerKadu", "Change selected", "Change");
    QPushButton *del = ConfigDialog::getPushButton("PowerKadu", "Delete selected", "Delete");
    QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");
    
    connect(addNew, SIGNAL(clicked()), this, SLOT(addNew()));
    connect(change, SIGNAL(clicked()), this, SLOT(changeCondition()));
    connect(del, SIGNAL(clicked()), this, SLOT(deleteCondition()));
    connect(listbox, SIGNAL(highlighted(int)), this, SLOT(wordSelected(int)));
    
    WpiszListbox();
}

void Antistring::onDestroyConfig()
{
    QPushButton *addNew = ConfigDialog::getPushButton("PowerKadu", "Add new condition", "Add new condition");
    QPushButton *change = ConfigDialog::getPushButton("PowerKadu", "Change selected", "Change");
    QPushButton *del = ConfigDialog::getPushButton("PowerKadu", "Delete selected", "Delete");
    QListBox *listbox = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");
    
    disconnect(addNew, SIGNAL(clicked()), this, SLOT(addNew()));
    disconnect(change, SIGNAL(clicked()), this, SLOT(changeCondition()));
    disconnect(del, SIGNAL(clicked()), this, SLOT(deleteCondition()));
    disconnect(listbox, SIGNAL(highlighted(int)), this, SLOT(wordSelected(int)));
}

void Antistring::wordSelected(int index)
{
    QSpinBox* IntCond = ConfigDialog::getSpinBox("PowerKadu", "value condition");
    QLineEdit* Condition = ConfigDialog::getLineEdit("PowerKadu", "condition: ");

    IntCond->setValue(conditions[index]);
    Condition->setText(conditions1[index]);

}

void Antistring::changeCondition()
{
    QListBox *warunkiLista = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");
    QSpinBox* IntCond = ConfigDialog::getSpinBox("PowerKadu", "value condition");
    QLineEdit* Cond = ConfigDialog::getLineEdit("PowerKadu", "condition: ");

    int index = warunkiLista->currentItem();
    bool ok;
    QString Condition = Cond->text();
    QString wartosc = IntCond->text();

    if (Condition.isEmpty())
        return;
    
    warunkiLista->changeItem("("+wartosc+") "+Condition, index);
    
     conditions[index]=wartosc.toInt( &ok, 10);
    conditions1[index]=Condition;
    
    IntCond->setValue(0);
    Cond->setText("");
}


void Antistring::deleteCondition()
{
    QListBox *warunkiLista = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");

    int index = warunkiLista->currentItem();

    for (uint i = index ; i < conditions.keys().count()-1 ; i++ )
    {
        conditions[i]=conditions[i+1];
        conditions1[i]=conditions1[i+1];
    }
    
    conditions1.remove(conditions.keys().count()-1);
    conditions.remove(conditions.keys().count()-1);
    
    WpiszListbox();

}

void Antistring::addNew()
{
    kdebugf();

    QListBox *warunkiLista = ConfigDialog::getListBox("PowerKadu", "conditions_listbox", "name");
    QSpinBox* newInt = ConfigDialog::getSpinBox("PowerKadu", "new condition (value)");
    QLineEdit* newCond = ConfigDialog::getLineEdit("PowerKadu", "new condition: ");

    QString Condition = newCond->text();
    QString wartosc = newInt->text();

    if (Condition.isEmpty())
        return;

    warunkiLista->insertItem("("+wartosc+") "+Condition);
    
    int ilosc = conditions.keys().count();
    bool ok;
    conditions[ilosc]=wartosc.toInt( &ok, 10);
    conditions1[ilosc]=Condition;

    newInt->setValue(0);
    newCond->setText("");

    kdebugf2();
}


