/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SHOW_FORECAST_DIALOG_H
#define SHOW_FORECAST_DIALOG_H

#include <qdialog.h>
#include <qptrlist.h>
#include <qlayout.h>
#include "userlistelement.h"

#include "citysearchresult.h"
#include "showforecastframe.h"

class QFrame;
class QTabWidget;

/**
	\class ShowForecastDialog
	Wywietla w okienku prognoz pogody
	pobran za pomoc klasy GetForecast
**/
class ShowForecastDialog : public QDialog
{
	Q_OBJECT
	
	public:
		ShowForecastDialog( const CitySearchResult& city );
		
		virtual ~ShowForecastDialog() {}
		void show();
		
	private:
		CitySearchResult city_;
		QTabWidget* tabs_;
		
	private slots:
		void tabChanged( QWidget* page );
		virtual void changeCity();
};


/**
	\class ShowUserForecastDialog
	Wywietla prognoz kontaktu na licie
**/

class ShowUserForecastDialog : public ShowForecastDialog
{
	Q_OBJECT
	
	public:
		ShowUserForecastDialog( const CitySearchResult& city, UserListElement user )
		:
			ShowForecastDialog( city ),
			user_( user )
		{}
		
	private:
		UserListElement user_;
		
	private slots:
		virtual void changeCity();
	
};

/**
	\class ShowMyForecastDialog
	Wywietla prognoz dla gwnego uytkownika
**/

class ShowMyForecastDialog : public ShowForecastDialog
{
	Q_OBJECT
	
	public:
		ShowMyForecastDialog( const CitySearchResult& city )
		:
			ShowForecastDialog( city )
		{}
		
	private slots:
		virtual void changeCity();
	
};

#endif // SHOW_FORECAST_DIALOG_H
