/*
 * side_bar_widget.cpp - implementation of user-list for side-bar
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qpainter.h>
#include <qfontmetrics.h>
#include <qvbox.h>

#include "side_bar_widget.h"

#include "side_bar_widget.moc"


sideBarWidget::sideBarWidget( const QString & _title, const QPixmap & _icon, QWidget * _parent ) :
	QWidget( _parent ),
	m_title( _title ),
	m_icon( _icon )
{
	m_contents = new QVBox( this );
	m_contents->setSpacing( 5 );
	setPaletteBackgroundColor( QColor( 0xFF,0xFF,0xFF ) );
}




sideBarWidget::~sideBarWidget()
{
}




void sideBarWidget::paintEvent( QPaintEvent * )
{
	const Q_UINT16 TITLE_FONT_HEIGHT = 16;

	QPixmap draw_pm( this->rect().size() );
	draw_pm.fill( QColor( 255, 255, 255 ) );

	QPainter p( &draw_pm, this );
	p.fillRect( 0, 0, width(), 27, QColor( 0x00, 0x55, 0xDD ) );

	QFont f;
	f.setBold( TRUE );
	f.setPixelSize( TITLE_FONT_HEIGHT );

	p.setFont( f );
	p.setPen( QColor( 255, 216,32 ) );
	const Q_UINT16 tx = m_icon.width()+4;
	const Q_UINT16 ty = 2+TITLE_FONT_HEIGHT;
	p.drawText( tx, ty, m_title );
	p.drawLine( tx, ty+4, width()-4, ty+4 );

	p.drawPixmap( 2, 2, m_icon );

	// and blit all drawn stuff on the screen...
	bitBlt( this, rect().topLeft(), &draw_pm );

}




void sideBarWidget::resizeEvent( QResizeEvent * )
{
	const Q_UINT16 MARGIN = 6;
	m_contents->setGeometry( MARGIN, 40+MARGIN, width()-MARGIN*2, height()-MARGIN*2-40 );
}
