-- -----------------------------------------
-- upgrade path for Icinga IDOUtils 1.4.0
--
-- -----------------------------------------
-- Copyright (c) 2010-2011 Icinga Development Team (http://www.icinga.org)
--
-- Please check http://docs.icinga.org for upgrading information!
-- -----------------------------------------

-- -----------------------------------------
-- remove number limitations, change serial to bigserial type
-- fixes Bug #1173: int(11) to small for some of ido tables https://dev.icinga.org/issues/1173
--       Bug #1401: integer not big enough for bytes_processed https://dev.icinga.org/issues/1401
-- remove NOT NULL constraints
-- Feature #1355 drop unnessary constraints and rename remaining https://dev.icinga.org/issues/1355
-- -----------------------------------------

Alter table icinga_acknowledgements  alter column acknowledgement_id type bigint;
Alter table icinga_acknowledgements  alter column instance_id type bigint;
Alter table icinga_acknowledgements  alter column instance_id drop not null;
Alter table icinga_acknowledgements  alter column entry_time drop not null;
Alter table icinga_acknowledgements  alter column entry_time_usec drop not null;
Alter table icinga_acknowledgements  alter column acknowledgement_type drop not null;
Alter table icinga_acknowledgements  alter column object_id type bigint;
Alter table icinga_acknowledgements  alter column object_id drop not null;
Alter table icinga_acknowledgements  alter column state drop not null;
Alter table icinga_acknowledgements  alter column author_name drop not null;
Alter table icinga_acknowledgements  alter column comment_data drop not null;
Alter table icinga_acknowledgements  alter column is_sticky drop not null;
Alter table icinga_acknowledgements  alter column persistent_comment drop not null;
Alter table icinga_acknowledgements  alter column notify_contacts drop not null;
Alter table icinga_commands  alter column command_id type bigint;
Alter table icinga_commands  alter column instance_id type bigint;
Alter table icinga_commands  alter column instance_id drop not null;
Alter table icinga_commands  alter column config_type drop not null;
Alter table icinga_commands  alter column object_id type bigint;
Alter table icinga_commands  alter column object_id drop not null;
Alter table icinga_commands  alter column command_line drop not null;
Alter table icinga_commenthistory  alter column commenthistory_id type bigint;
Alter table icinga_commenthistory  alter column instance_id type bigint;
Alter table icinga_commenthistory  alter column instance_id drop not null;
Alter table icinga_commenthistory  alter column entry_time drop not null;
Alter table icinga_commenthistory  alter column entry_time_usec drop not null;
Alter table icinga_commenthistory  alter column comment_type drop not null;
Alter table icinga_commenthistory  alter column entry_type drop not null;
Alter table icinga_commenthistory  alter column object_id type bigint;
Alter table icinga_commenthistory  alter column object_id drop not null;
Alter table icinga_commenthistory  alter column comment_time drop not null;
Alter table icinga_commenthistory  alter column internal_comment_id type bigint;
Alter table icinga_commenthistory  alter column internal_comment_id drop not null;
Alter table icinga_commenthistory  alter column author_name drop not null;
Alter table icinga_commenthistory  alter column comment_data drop not null;
Alter table icinga_commenthistory  alter column is_persistent drop not null;
Alter table icinga_commenthistory  alter column comment_source drop not null;
Alter table icinga_commenthistory  alter column expires drop not null;
Alter table icinga_commenthistory  alter column expiration_time drop not null;
Alter table icinga_commenthistory  alter column deletion_time drop not null;
Alter table icinga_commenthistory  alter column deletion_time_usec drop not null;
Alter table icinga_comments  alter column comment_id type bigint;
Alter table icinga_comments  alter column instance_id type bigint;
Alter table icinga_comments  alter column instance_id drop not null;
Alter table icinga_comments  alter column entry_time drop not null;
Alter table icinga_comments  alter column entry_time_usec drop not null;
Alter table icinga_comments  alter column comment_type drop not null;
Alter table icinga_comments  alter column entry_type drop not null;
Alter table icinga_comments  alter column object_id type bigint;
Alter table icinga_comments  alter column object_id drop not null;
Alter table icinga_comments  alter column comment_time drop not null;
Alter table icinga_comments  alter column internal_comment_id type bigint;
Alter table icinga_comments  alter column internal_comment_id drop not null;
Alter table icinga_comments  alter column author_name drop not null;
Alter table icinga_comments  alter column comment_data drop not null;
Alter table icinga_comments  alter column is_persistent drop not null;
Alter table icinga_comments  alter column comment_source drop not null;
Alter table icinga_comments  alter column expires drop not null;
Alter table icinga_comments  alter column expiration_time drop not null;
Alter table icinga_configfiles  alter column configfile_id type bigint;
Alter table icinga_configfiles  alter column instance_id type bigint;
Alter table icinga_configfiles  alter column instance_id drop not null;
Alter table icinga_configfiles  alter column configfile_type drop not null;
Alter table icinga_configfiles  alter column configfile_path drop not null;
Alter table icinga_configfilevariables  alter column configfilevariable_id type bigint;
Alter table icinga_configfilevariables  alter column instance_id type bigint;
Alter table icinga_configfilevariables  alter column instance_id drop not null;
Alter table icinga_configfilevariables  alter column configfile_id type bigint;
Alter table icinga_configfilevariables  alter column configfile_id drop not null;
Alter table icinga_configfilevariables  alter column varname drop not null;
Alter table icinga_configfilevariables  alter column varvalue drop not null;
Alter table icinga_conninfo  alter column conninfo_id type bigint;
Alter table icinga_conninfo  alter column instance_id type bigint;
Alter table icinga_conninfo  alter column instance_id drop not null;
Alter table icinga_conninfo  alter column agent_name drop not null;
Alter table icinga_conninfo  alter column agent_version drop not null;
Alter table icinga_conninfo  alter column disposition drop not null;
Alter table icinga_conninfo  alter column connect_source drop not null;
Alter table icinga_conninfo  alter column connect_type drop not null;
Alter table icinga_conninfo  alter column connect_time drop not null;
Alter table icinga_conninfo  alter column disconnect_time drop not null;
Alter table icinga_conninfo  alter column last_checkin_time drop not null;
Alter table icinga_conninfo  alter column data_start_time drop not null;
Alter table icinga_conninfo  alter column data_end_time drop not null;
Alter table icinga_conninfo  alter column bytes_processed drop not null;
Alter table icinga_conninfo  alter column lines_processed drop not null;
Alter table icinga_conninfo  alter column entries_processed drop not null;
Alter table icinga_contactgroups  alter column contactgroup_id type bigint;
Alter table icinga_contactgroups  alter column instance_id type bigint;
Alter table icinga_contactgroups  alter column instance_id drop not null;
Alter table icinga_contactgroups  alter column config_type drop not null;
Alter table icinga_contactgroups  alter column contactgroup_object_id type bigint;
Alter table icinga_contactgroups  alter column contactgroup_object_id drop not null;
Alter table icinga_contactgroups  alter column alias drop not null;
Alter table icinga_contactgroup_members  alter column contactgroup_member_id type bigint;
Alter table icinga_contactgroup_members  alter column instance_id type bigint;
Alter table icinga_contactgroup_members  alter column instance_id drop not null;
Alter table icinga_contactgroup_members  alter column contactgroup_id type bigint;
Alter table icinga_contactgroup_members  alter column contactgroup_id drop not null;
Alter table icinga_contactgroup_members  alter column contact_object_id type bigint;
Alter table icinga_contactgroup_members  alter column contact_object_id drop not null;
Alter table icinga_contactnotificationmethods  alter column contactnotificationmethod_id type bigint;
Alter table icinga_contactnotificationmethods  alter column instance_id type bigint;
Alter table icinga_contactnotificationmethods  alter column instance_id drop not null;
Alter table icinga_contactnotificationmethods  alter column contactnotification_id type bigint;
Alter table icinga_contactnotificationmethods  alter column contactnotification_id drop not null;
Alter table icinga_contactnotificationmethods  alter column start_time drop not null;
Alter table icinga_contactnotificationmethods  alter column start_time_usec drop not null;
Alter table icinga_contactnotificationmethods  alter column end_time drop not null;
Alter table icinga_contactnotificationmethods  alter column end_time_usec drop not null;
Alter table icinga_contactnotificationmethods  alter column command_object_id type bigint;
Alter table icinga_contactnotificationmethods  alter column command_object_id drop not null;
Alter table icinga_contactnotificationmethods  alter column command_args drop not null;
Alter table icinga_contactnotifications  alter column contactnotification_id type bigint;
Alter table icinga_contactnotifications  alter column instance_id type bigint;
Alter table icinga_contactnotifications  alter column instance_id drop not null;
Alter table icinga_contactnotifications  alter column notification_id type bigint;
Alter table icinga_contactnotifications  alter column notification_id drop not null;
Alter table icinga_contactnotifications  alter column contact_object_id type bigint;
Alter table icinga_contactnotifications  alter column contact_object_id drop not null;
Alter table icinga_contactnotifications  alter column start_time drop not null;
Alter table icinga_contactnotifications  alter column start_time_usec drop not null;
Alter table icinga_contactnotifications  alter column end_time drop not null;
Alter table icinga_contactnotifications  alter column end_time_usec drop not null;
Alter table icinga_contacts  alter column contact_id type bigint;
Alter table icinga_contacts  alter column instance_id type bigint;
Alter table icinga_contacts  alter column instance_id drop not null;
Alter table icinga_contacts  alter column config_type drop not null;
Alter table icinga_contacts  alter column contact_object_id type bigint;
Alter table icinga_contacts  alter column contact_object_id drop not null;
Alter table icinga_contacts  alter column alias drop not null;
Alter table icinga_contacts  alter column email_address drop not null;
Alter table icinga_contacts  alter column pager_address drop not null;
Alter table icinga_contacts  alter column host_timeperiod_object_id type bigint;
Alter table icinga_contacts  alter column host_timeperiod_object_id drop not null;
Alter table icinga_contacts  alter column service_timeperiod_object_id type bigint;
Alter table icinga_contacts  alter column service_timeperiod_object_id drop not null;
Alter table icinga_contacts  alter column host_notifications_enabled drop not null;
Alter table icinga_contacts  alter column service_notifications_enabled drop not null;
Alter table icinga_contacts  alter column can_submit_commands drop not null;
Alter table icinga_contacts  alter column notify_service_recovery drop not null;
Alter table icinga_contacts  alter column notify_service_warning drop not null;
Alter table icinga_contacts  alter column notify_service_unknown drop not null;
Alter table icinga_contacts  alter column notify_service_critical drop not null;
Alter table icinga_contacts  alter column notify_service_flapping drop not null;
Alter table icinga_contacts  alter column notify_service_downtime drop not null;
Alter table icinga_contacts  alter column notify_host_recovery drop not null;
Alter table icinga_contacts  alter column notify_host_down drop not null;
Alter table icinga_contacts  alter column notify_host_unreachable drop not null;
Alter table icinga_contacts  alter column notify_host_flapping drop not null;
Alter table icinga_contacts  alter column notify_host_downtime drop not null;
Alter table icinga_contactstatus  alter column contactstatus_id type bigint;
Alter table icinga_contactstatus  alter column instance_id type bigint;
Alter table icinga_contactstatus  alter column instance_id drop not null;
Alter table icinga_contactstatus  alter column contact_object_id type bigint;
Alter table icinga_contactstatus  alter column contact_object_id drop not null;
Alter table icinga_contactstatus  alter column status_update_time drop not null;
Alter table icinga_contactstatus  alter column host_notifications_enabled drop not null;
Alter table icinga_contactstatus  alter column service_notifications_enabled drop not null;
Alter table icinga_contactstatus  alter column last_host_notification drop not null;
Alter table icinga_contactstatus  alter column last_service_notification drop not null;
Alter table icinga_contactstatus  alter column modified_attributes drop not null;
Alter table icinga_contactstatus  alter column modified_host_attributes drop not null;
Alter table icinga_contactstatus  alter column modified_service_attributes drop not null;
Alter table icinga_contact_addresses  alter column contact_address_id type bigint;
Alter table icinga_contact_addresses  alter column instance_id type bigint;
Alter table icinga_contact_addresses  alter column instance_id drop not null;
Alter table icinga_contact_addresses  alter column contact_id type bigint;
Alter table icinga_contact_addresses  alter column contact_id drop not null;
Alter table icinga_contact_addresses  alter column address_number drop not null;
Alter table icinga_contact_addresses  alter column address drop not null;
Alter table icinga_contact_notificationcommands  alter column contact_notificationcommand_id type bigint;
Alter table icinga_contact_notificationcommands  alter column instance_id type bigint;
Alter table icinga_contact_notificationcommands  alter column instance_id drop not null;
Alter table icinga_contact_notificationcommands  alter column contact_id type bigint;
Alter table icinga_contact_notificationcommands  alter column contact_id drop not null;
Alter table icinga_contact_notificationcommands  alter column notification_type drop not null;
Alter table icinga_contact_notificationcommands  alter column command_object_id type bigint;
Alter table icinga_contact_notificationcommands  alter column command_object_id drop not null;
Alter table icinga_contact_notificationcommands  alter column command_args drop not null;
Alter table icinga_customvariables  alter column customvariable_id type bigint;
Alter table icinga_customvariables  alter column instance_id type bigint;
Alter table icinga_customvariables  alter column instance_id drop not null;
Alter table icinga_customvariables  alter column object_id type bigint;
Alter table icinga_customvariables  alter column object_id drop not null;
Alter table icinga_customvariables  alter column config_type drop not null;
Alter table icinga_customvariables  alter column has_been_modified drop not null;
Alter table icinga_customvariables  alter column varname drop not null;
Alter table icinga_customvariables  alter column varvalue drop not null;
Alter table icinga_customvariablestatus  alter column customvariablestatus_id type bigint;
Alter table icinga_customvariablestatus  alter column instance_id type bigint;
Alter table icinga_customvariablestatus  alter column instance_id drop not null;
Alter table icinga_customvariablestatus  alter column object_id type bigint;
Alter table icinga_customvariablestatus  alter column object_id drop not null;
Alter table icinga_customvariablestatus  alter column status_update_time drop not null;
Alter table icinga_customvariablestatus  alter column has_been_modified drop not null;
Alter table icinga_customvariablestatus  alter column varname drop not null;
Alter table icinga_customvariablestatus  alter column varvalue drop not null;
Alter table icinga_dbversion  alter column dbversion_id type bigint;
Alter table icinga_dbversion  alter column name drop not null;
Alter table icinga_dbversion  alter column version drop not null;
Alter table icinga_downtimehistory  alter column downtimehistory_id type bigint;
Alter table icinga_downtimehistory  alter column instance_id type bigint;
Alter table icinga_downtimehistory  alter column instance_id drop not null;
Alter table icinga_downtimehistory  alter column downtime_type drop not null;
Alter table icinga_downtimehistory  alter column object_id type bigint;
Alter table icinga_downtimehistory  alter column object_id drop not null;
Alter table icinga_downtimehistory  alter column entry_time drop not null;
Alter table icinga_downtimehistory  alter column author_name drop not null;
Alter table icinga_downtimehistory  alter column comment_data drop not null;
Alter table icinga_downtimehistory  alter column internal_downtime_id type bigint;
Alter table icinga_downtimehistory  alter column internal_downtime_id drop not null;
Alter table icinga_downtimehistory  alter column triggered_by_id type bigint;
Alter table icinga_downtimehistory  alter column triggered_by_id drop not null;
Alter table icinga_downtimehistory  alter column is_fixed drop not null;
Alter table icinga_downtimehistory  alter column duration drop not null;
Alter table icinga_downtimehistory  alter column scheduled_start_time drop not null;
Alter table icinga_downtimehistory  alter column scheduled_end_time drop not null;
Alter table icinga_downtimehistory  alter column was_started drop not null;
Alter table icinga_downtimehistory  alter column actual_start_time drop not null;
Alter table icinga_downtimehistory  alter column actual_start_time_usec drop not null;
Alter table icinga_downtimehistory  alter column actual_end_time drop not null;
Alter table icinga_downtimehistory  alter column actual_end_time_usec drop not null;
Alter table icinga_downtimehistory  alter column was_cancelled drop not null;
Alter table icinga_eventhandlers  alter column eventhandler_id type bigint;
Alter table icinga_eventhandlers  alter column instance_id type bigint;
Alter table icinga_eventhandlers  alter column instance_id drop not null;
Alter table icinga_eventhandlers  alter column eventhandler_type drop not null;
Alter table icinga_eventhandlers  alter column object_id type bigint;
Alter table icinga_eventhandlers  alter column object_id drop not null;
Alter table icinga_eventhandlers  alter column state drop not null;
Alter table icinga_eventhandlers  alter column state_type drop not null;
Alter table icinga_eventhandlers  alter column start_time drop not null;
Alter table icinga_eventhandlers  alter column start_time_usec drop not null;
Alter table icinga_eventhandlers  alter column end_time drop not null;
Alter table icinga_eventhandlers  alter column end_time_usec drop not null;
Alter table icinga_eventhandlers  alter column command_object_id type bigint;
Alter table icinga_eventhandlers  alter column command_object_id drop not null;
Alter table icinga_eventhandlers  alter column command_args drop not null;
Alter table icinga_eventhandlers  alter column command_line drop not null;
Alter table icinga_eventhandlers  alter column timeout drop not null;
Alter table icinga_eventhandlers  alter column early_timeout drop not null;
Alter table icinga_eventhandlers  alter column execution_time drop not null;
Alter table icinga_eventhandlers  alter column return_code drop not null;
Alter table icinga_eventhandlers  alter column output drop not null;
Alter table icinga_eventhandlers  alter column long_output drop not null;
Alter table icinga_externalcommands  alter column externalcommand_id type bigint;
Alter table icinga_externalcommands  alter column instance_id type bigint;
Alter table icinga_externalcommands  alter column instance_id drop not null;
Alter table icinga_externalcommands  alter column entry_time drop not null;
Alter table icinga_externalcommands  alter column command_type drop not null;
Alter table icinga_externalcommands  alter column command_name drop not null;
Alter table icinga_externalcommands  alter column command_args drop not null;
Alter table icinga_flappinghistory  alter column flappinghistory_id type bigint;
Alter table icinga_flappinghistory  alter column instance_id type bigint;
Alter table icinga_flappinghistory  alter column instance_id drop not null;
Alter table icinga_flappinghistory  alter column event_time drop not null;
Alter table icinga_flappinghistory  alter column event_time_usec drop not null;
Alter table icinga_flappinghistory  alter column event_type drop not null;
Alter table icinga_flappinghistory  alter column reason_type drop not null;
Alter table icinga_flappinghistory  alter column flapping_type drop not null;
Alter table icinga_flappinghistory  alter column object_id type bigint;
Alter table icinga_flappinghistory  alter column object_id drop not null;
Alter table icinga_flappinghistory  alter column percent_state_change drop not null;
Alter table icinga_flappinghistory  alter column low_threshold drop not null;
Alter table icinga_flappinghistory  alter column high_threshold drop not null;
Alter table icinga_flappinghistory  alter column comment_time drop not null;
Alter table icinga_flappinghistory  alter column internal_comment_id type bigint;
Alter table icinga_flappinghistory  alter column internal_comment_id drop not null;
Alter table icinga_hostchecks  alter column hostcheck_id type bigint;
Alter table icinga_hostchecks  alter column instance_id type bigint;
Alter table icinga_hostchecks  alter column instance_id drop not null;
Alter table icinga_hostchecks  alter column host_object_id type bigint;
Alter table icinga_hostchecks  alter column host_object_id drop not null;
Alter table icinga_hostchecks  alter column check_type drop not null;
Alter table icinga_hostchecks  alter column is_raw_check drop not null;
Alter table icinga_hostchecks  alter column current_check_attempt drop not null;
Alter table icinga_hostchecks  alter column max_check_attempts drop not null;
Alter table icinga_hostchecks  alter column state drop not null;
Alter table icinga_hostchecks  alter column state_type drop not null;
Alter table icinga_hostchecks  alter column start_time drop not null;
Alter table icinga_hostchecks  alter column start_time_usec drop not null;
Alter table icinga_hostchecks  alter column end_time drop not null;
Alter table icinga_hostchecks  alter column end_time_usec drop not null;
Alter table icinga_hostchecks  alter column command_object_id type bigint;
Alter table icinga_hostchecks  alter column command_object_id drop not null;
Alter table icinga_hostchecks  alter column command_args drop not null;
Alter table icinga_hostchecks  alter column command_line drop not null;
Alter table icinga_hostchecks  alter column timeout drop not null;
Alter table icinga_hostchecks  alter column early_timeout drop not null;
Alter table icinga_hostchecks  alter column execution_time drop not null;
Alter table icinga_hostchecks  alter column latency drop not null;
Alter table icinga_hostchecks  alter column return_code drop not null;
Alter table icinga_hostchecks  alter column output drop not null;
Alter table icinga_hostchecks  alter column long_output drop not null;
Alter table icinga_hostchecks  alter column perfdata drop not null;
Alter table icinga_hostdependencies  alter column hostdependency_id type bigint;
Alter table icinga_hostdependencies  alter column instance_id type bigint;
Alter table icinga_hostdependencies  alter column instance_id drop not null;
Alter table icinga_hostdependencies  alter column config_type drop not null;
Alter table icinga_hostdependencies  alter column host_object_id type bigint;
Alter table icinga_hostdependencies  alter column host_object_id drop not null;
Alter table icinga_hostdependencies  alter column dependent_host_object_id type bigint;
Alter table icinga_hostdependencies  alter column dependent_host_object_id drop not null;
Alter table icinga_hostdependencies  alter column dependency_type drop not null;
Alter table icinga_hostdependencies  alter column inherits_parent drop not null;
Alter table icinga_hostdependencies  alter column timeperiod_object_id type bigint;
Alter table icinga_hostdependencies  alter column timeperiod_object_id drop not null;
Alter table icinga_hostdependencies  alter column fail_on_up drop not null;
Alter table icinga_hostdependencies  alter column fail_on_down drop not null;
Alter table icinga_hostdependencies  alter column fail_on_unreachable drop not null;
Alter table icinga_hostescalations  alter column hostescalation_id type bigint;
Alter table icinga_hostescalations  alter column instance_id type bigint;
Alter table icinga_hostescalations  alter column instance_id drop not null;
Alter table icinga_hostescalations  alter column config_type drop not null;
Alter table icinga_hostescalations  alter column host_object_id type bigint;
Alter table icinga_hostescalations  alter column host_object_id drop not null;
Alter table icinga_hostescalations  alter column timeperiod_object_id type bigint;
Alter table icinga_hostescalations  alter column timeperiod_object_id drop not null;
Alter table icinga_hostescalations  alter column first_notification drop not null;
Alter table icinga_hostescalations  alter column last_notification drop not null;
Alter table icinga_hostescalations  alter column notification_interval drop not null;
Alter table icinga_hostescalations  alter column escalate_on_recovery drop not null;
Alter table icinga_hostescalations  alter column escalate_on_down drop not null;
Alter table icinga_hostescalations  alter column escalate_on_unreachable drop not null;
Alter table icinga_hostescalation_contactgroups  alter column hostescalation_contactgroup_id type bigint;
Alter table icinga_hostescalation_contactgroups  alter column instance_id type bigint;
Alter table icinga_hostescalation_contactgroups  alter column instance_id drop not null;
Alter table icinga_hostescalation_contactgroups  alter column hostescalation_id type bigint;
Alter table icinga_hostescalation_contactgroups  alter column hostescalation_id drop not null;
Alter table icinga_hostescalation_contactgroups  alter column contactgroup_object_id type bigint;
Alter table icinga_hostescalation_contactgroups  alter column contactgroup_object_id drop not null;
Alter table icinga_hostescalation_contacts  alter column hostescalation_contact_id type bigint;
Alter table icinga_hostescalation_contacts  alter column instance_id type bigint;
Alter table icinga_hostescalation_contacts  alter column instance_id drop not null;
Alter table icinga_hostescalation_contacts  alter column hostescalation_id type bigint;
Alter table icinga_hostescalation_contacts  alter column hostescalation_id drop not null;
Alter table icinga_hostescalation_contacts  alter column contact_object_id type bigint;
Alter table icinga_hostescalation_contacts  alter column contact_object_id drop not null;
Alter table icinga_hostgroups  alter column hostgroup_id type bigint;
Alter table icinga_hostgroups  alter column instance_id type bigint;
Alter table icinga_hostgroups  alter column instance_id drop not null;
Alter table icinga_hostgroups  alter column config_type drop not null;
Alter table icinga_hostgroups  alter column hostgroup_object_id type bigint;
Alter table icinga_hostgroups  alter column hostgroup_object_id drop not null;
Alter table icinga_hostgroups  alter column alias drop not null;
Alter table icinga_hostgroup_members  alter column hostgroup_member_id type bigint;
Alter table icinga_hostgroup_members  alter column instance_id type bigint;
Alter table icinga_hostgroup_members  alter column instance_id drop not null;
Alter table icinga_hostgroup_members  alter column hostgroup_id type bigint;
Alter table icinga_hostgroup_members  alter column hostgroup_id drop not null;
Alter table icinga_hostgroup_members  alter column host_object_id type bigint;
Alter table icinga_hostgroup_members  alter column host_object_id drop not null;
Alter table icinga_hosts  alter column host_id type bigint;
Alter table icinga_hosts  alter column instance_id type bigint;
Alter table icinga_hosts  alter column instance_id drop not null;
Alter table icinga_hosts  alter column config_type drop not null;
Alter table icinga_hosts  alter column host_object_id type bigint;
Alter table icinga_hosts  alter column host_object_id drop not null;
Alter table icinga_hosts  alter column alias drop not null;
Alter table icinga_hosts  alter column display_name drop not null;
Alter table icinga_hosts  alter column address drop not null;
Alter table icinga_hosts  alter column address6 drop not null;
Alter table icinga_hosts  alter column check_command_object_id type bigint;
Alter table icinga_hosts  alter column check_command_object_id drop not null;
Alter table icinga_hosts  alter column check_command_args drop not null;
Alter table icinga_hosts  alter column eventhandler_command_object_id type bigint;
Alter table icinga_hosts  alter column eventhandler_command_object_id drop not null;
Alter table icinga_hosts  alter column eventhandler_command_args drop not null;
Alter table icinga_hosts  alter column notification_timeperiod_object_id type bigint;
Alter table icinga_hosts  alter column notification_timeperiod_object_id drop not null;
Alter table icinga_hosts  alter column check_timeperiod_object_id type bigint;
Alter table icinga_hosts  alter column check_timeperiod_object_id drop not null;
Alter table icinga_hosts  alter column failure_prediction_options drop not null;
Alter table icinga_hosts  alter column check_interval drop not null;
Alter table icinga_hosts  alter column retry_interval drop not null;
Alter table icinga_hosts  alter column max_check_attempts drop not null;
Alter table icinga_hosts  alter column first_notification_delay drop not null;
Alter table icinga_hosts  alter column notification_interval drop not null;
Alter table icinga_hosts  alter column notify_on_down drop not null;
Alter table icinga_hosts  alter column notify_on_unreachable drop not null;
Alter table icinga_hosts  alter column notify_on_recovery drop not null;
Alter table icinga_hosts  alter column notify_on_flapping drop not null;
Alter table icinga_hosts  alter column notify_on_downtime drop not null;
Alter table icinga_hosts  alter column stalk_on_up drop not null;
Alter table icinga_hosts  alter column stalk_on_down drop not null;
Alter table icinga_hosts  alter column stalk_on_unreachable drop not null;
Alter table icinga_hosts  alter column flap_detection_enabled drop not null;
Alter table icinga_hosts  alter column flap_detection_on_up drop not null;
Alter table icinga_hosts  alter column flap_detection_on_down drop not null;
Alter table icinga_hosts  alter column flap_detection_on_unreachable drop not null;
Alter table icinga_hosts  alter column low_flap_threshold drop not null;
Alter table icinga_hosts  alter column high_flap_threshold drop not null;
Alter table icinga_hosts  alter column process_performance_data drop not null;
Alter table icinga_hosts  alter column freshness_checks_enabled drop not null;
Alter table icinga_hosts  alter column freshness_threshold drop not null;
Alter table icinga_hosts  alter column passive_checks_enabled drop not null;
Alter table icinga_hosts  alter column event_handler_enabled drop not null;
Alter table icinga_hosts  alter column active_checks_enabled drop not null;
Alter table icinga_hosts  alter column retain_status_information drop not null;
Alter table icinga_hosts  alter column retain_nonstatus_information drop not null;
Alter table icinga_hosts  alter column notifications_enabled drop not null;
Alter table icinga_hosts  alter column obsess_over_host drop not null;
Alter table icinga_hosts  alter column failure_prediction_enabled drop not null;
Alter table icinga_hosts  alter column notes drop not null;
Alter table icinga_hosts  alter column notes_url drop not null;
Alter table icinga_hosts  alter column action_url drop not null;
Alter table icinga_hosts  alter column icon_image drop not null;
Alter table icinga_hosts  alter column icon_image_alt drop not null;
Alter table icinga_hosts  alter column vrml_image drop not null;
Alter table icinga_hosts  alter column statusmap_image drop not null;
Alter table icinga_hosts  alter column have_2d_coords drop not null;
Alter table icinga_hosts  alter column x_2d drop not null;
Alter table icinga_hosts  alter column y_2d drop not null;
Alter table icinga_hosts  alter column have_3d_coords drop not null;
Alter table icinga_hosts  alter column x_3d drop not null;
Alter table icinga_hosts  alter column y_3d drop not null;
Alter table icinga_hosts  alter column z_3d drop not null;
Alter table icinga_hoststatus  alter column hoststatus_id type bigint;
Alter table icinga_hoststatus  alter column instance_id type bigint;
Alter table icinga_hoststatus  alter column instance_id drop not null;
Alter table icinga_hoststatus  alter column host_object_id type bigint;
Alter table icinga_hoststatus  alter column host_object_id drop not null;
Alter table icinga_hoststatus  alter column status_update_time drop not null;
Alter table icinga_hoststatus  alter column output drop not null;
Alter table icinga_hoststatus  alter column long_output drop not null;
Alter table icinga_hoststatus  alter column perfdata drop not null;
Alter table icinga_hoststatus  alter column current_state drop not null;
Alter table icinga_hoststatus  alter column has_been_checked drop not null;
Alter table icinga_hoststatus  alter column should_be_scheduled drop not null;
Alter table icinga_hoststatus  alter column current_check_attempt drop not null;
Alter table icinga_hoststatus  alter column max_check_attempts drop not null;
Alter table icinga_hoststatus  alter column last_check drop not null;
Alter table icinga_hoststatus  alter column next_check drop not null;
Alter table icinga_hoststatus  alter column check_type drop not null;
Alter table icinga_hoststatus  alter column last_state_change drop not null;
Alter table icinga_hoststatus  alter column last_hard_state_change drop not null;
Alter table icinga_hoststatus  alter column last_hard_state drop not null;
Alter table icinga_hoststatus  alter column last_time_up drop not null;
Alter table icinga_hoststatus  alter column last_time_down drop not null;
Alter table icinga_hoststatus  alter column last_time_unreachable drop not null;
Alter table icinga_hoststatus  alter column state_type drop not null;
Alter table icinga_hoststatus  alter column last_notification drop not null;
Alter table icinga_hoststatus  alter column next_notification drop not null;
Alter table icinga_hoststatus  alter column no_more_notifications drop not null;
Alter table icinga_hoststatus  alter column notifications_enabled drop not null;
Alter table icinga_hoststatus  alter column problem_has_been_acknowledged drop not null;
Alter table icinga_hoststatus  alter column acknowledgement_type drop not null;
Alter table icinga_hoststatus  alter column current_notification_number drop not null;
Alter table icinga_hoststatus  alter column passive_checks_enabled drop not null;
Alter table icinga_hoststatus  alter column active_checks_enabled drop not null;
Alter table icinga_hoststatus  alter column event_handler_enabled drop not null;
Alter table icinga_hoststatus  alter column flap_detection_enabled drop not null;
Alter table icinga_hoststatus  alter column is_flapping drop not null;
Alter table icinga_hoststatus  alter column percent_state_change drop not null;
Alter table icinga_hoststatus  alter column latency drop not null;
Alter table icinga_hoststatus  alter column execution_time drop not null;
Alter table icinga_hoststatus  alter column scheduled_downtime_depth drop not null;
Alter table icinga_hoststatus  alter column failure_prediction_enabled drop not null;
Alter table icinga_hoststatus  alter column process_performance_data drop not null;
Alter table icinga_hoststatus  alter column obsess_over_host drop not null;
Alter table icinga_hoststatus  alter column modified_host_attributes drop not null;
Alter table icinga_hoststatus  alter column event_handler drop not null;
Alter table icinga_hoststatus  alter column check_command drop not null;
Alter table icinga_hoststatus  alter column normal_check_interval drop not null;
Alter table icinga_hoststatus  alter column retry_check_interval drop not null;
Alter table icinga_hoststatus  alter column check_timeperiod_object_id type bigint;
Alter table icinga_hoststatus  alter column check_timeperiod_object_id drop not null;
Alter table icinga_host_contactgroups  alter column host_contactgroup_id type bigint;
Alter table icinga_host_contactgroups  alter column instance_id type bigint;
Alter table icinga_host_contactgroups  alter column instance_id drop not null;
Alter table icinga_host_contactgroups  alter column host_id type bigint;
Alter table icinga_host_contactgroups  alter column host_id drop not null;
Alter table icinga_host_contactgroups  alter column contactgroup_object_id type bigint;
Alter table icinga_host_contactgroups  alter column contactgroup_object_id drop not null;
Alter table icinga_host_contacts  alter column host_contact_id type bigint;
Alter table icinga_host_contacts  alter column instance_id type bigint;
Alter table icinga_host_contacts  alter column instance_id drop not null;
Alter table icinga_host_contacts  alter column host_id type bigint;
Alter table icinga_host_contacts  alter column host_id drop not null;
Alter table icinga_host_contacts  alter column contact_object_id type bigint;
Alter table icinga_host_contacts  alter column contact_object_id drop not null;
Alter table icinga_host_parenthosts  alter column host_parenthost_id type bigint;
Alter table icinga_host_parenthosts  alter column instance_id type bigint;
Alter table icinga_host_parenthosts  alter column instance_id drop not null;
Alter table icinga_host_parenthosts  alter column host_id type bigint;
Alter table icinga_host_parenthosts  alter column host_id drop not null;
Alter table icinga_host_parenthosts  alter column parent_host_object_id type bigint;
Alter table icinga_host_parenthosts  alter column parent_host_object_id drop not null;
Alter table icinga_instances  alter column instance_id type bigint;
Alter table icinga_instances  alter column instance_name drop not null;
Alter table icinga_instances  alter column instance_description drop not null;
Alter table icinga_logentries  alter column logentry_id type bigint;
Alter table icinga_logentries  alter column instance_id type bigint;
Alter table icinga_logentries  alter column instance_id drop not null;
Alter table icinga_logentries  alter column logentry_time drop not null;
Alter table icinga_logentries  alter column entry_time drop not null;
Alter table icinga_logentries  alter column entry_time_usec drop not null;
Alter table icinga_logentries  alter column logentry_type drop not null;
Alter table icinga_logentries  alter column logentry_data drop not null;
Alter table icinga_logentries  alter column realtime_data drop not null;
Alter table icinga_logentries  alter column inferred_data_extracted drop not null;
Alter table icinga_notifications  alter column notification_id type bigint;
Alter table icinga_notifications  alter column instance_id type bigint;
Alter table icinga_notifications  alter column instance_id drop not null;
Alter table icinga_notifications  alter column notification_type drop not null;
Alter table icinga_notifications  alter column notification_reason drop not null;
Alter table icinga_notifications  alter column object_id type bigint;
Alter table icinga_notifications  alter column object_id drop not null;
Alter table icinga_notifications  alter column start_time drop not null;
Alter table icinga_notifications  alter column start_time_usec drop not null;
Alter table icinga_notifications  alter column end_time drop not null;
Alter table icinga_notifications  alter column end_time_usec drop not null;
Alter table icinga_notifications  alter column state drop not null;
Alter table icinga_notifications  alter column output drop not null;
Alter table icinga_notifications  alter column long_output drop not null;
Alter table icinga_notifications  alter column escalated drop not null;
Alter table icinga_notifications  alter column contacts_notified drop not null;
Alter table icinga_objects  alter column object_id type bigint;
Alter table icinga_objects  alter column instance_id type bigint;
Alter table icinga_objects  alter column instance_id drop not null;
Alter table icinga_objects  alter column objecttype_id type bigint;
Alter table icinga_objects  alter column objecttype_id drop not null;
Alter table icinga_objects  alter column is_active drop not null;
Alter table icinga_processevents  alter column processevent_id type bigint;
Alter table icinga_processevents  alter column instance_id type bigint;
Alter table icinga_processevents  alter column instance_id drop not null;
Alter table icinga_processevents  alter column event_type drop not null;
Alter table icinga_processevents  alter column event_time drop not null;
Alter table icinga_processevents  alter column event_time_usec drop not null;
Alter table icinga_processevents  alter column process_id type bigint;
Alter table icinga_processevents  alter column process_id drop not null;
Alter table icinga_processevents  alter column program_name drop not null;
Alter table icinga_processevents  alter column program_version drop not null;
Alter table icinga_processevents  alter column program_date drop not null;
Alter table icinga_programstatus  alter column programstatus_id type bigint;
Alter table icinga_programstatus  alter column instance_id type bigint;
Alter table icinga_programstatus  alter column instance_id drop not null;
Alter table icinga_programstatus  alter column status_update_time drop not null;
Alter table icinga_programstatus  alter column program_start_time drop not null;
Alter table icinga_programstatus  alter column program_end_time drop not null;
Alter table icinga_programstatus  alter column is_currently_running drop not null;
Alter table icinga_programstatus  alter column process_id type bigint;
Alter table icinga_programstatus  alter column process_id drop not null;
Alter table icinga_programstatus  alter column daemon_mode drop not null;
Alter table icinga_programstatus  alter column last_command_check drop not null;
Alter table icinga_programstatus  alter column last_log_rotation drop not null;
Alter table icinga_programstatus  alter column notifications_enabled drop not null;
Alter table icinga_programstatus  alter column active_service_checks_enabled drop not null;
Alter table icinga_programstatus  alter column passive_service_checks_enabled drop not null;
Alter table icinga_programstatus  alter column active_host_checks_enabled drop not null;
Alter table icinga_programstatus  alter column passive_host_checks_enabled drop not null;
Alter table icinga_programstatus  alter column event_handlers_enabled drop not null;
Alter table icinga_programstatus  alter column flap_detection_enabled drop not null;
Alter table icinga_programstatus  alter column failure_prediction_enabled drop not null;
Alter table icinga_programstatus  alter column process_performance_data drop not null;
Alter table icinga_programstatus  alter column obsess_over_hosts drop not null;
Alter table icinga_programstatus  alter column obsess_over_services drop not null;
Alter table icinga_programstatus  alter column modified_host_attributes drop not null;
Alter table icinga_programstatus  alter column modified_service_attributes drop not null;
Alter table icinga_programstatus  alter column global_host_event_handler drop not null;
Alter table icinga_programstatus  alter column global_service_event_handler drop not null;
Alter table icinga_runtimevariables  alter column runtimevariable_id type bigint;
Alter table icinga_runtimevariables  alter column instance_id type bigint;
Alter table icinga_runtimevariables  alter column instance_id drop not null;
Alter table icinga_runtimevariables  alter column varname drop not null;
Alter table icinga_runtimevariables  alter column varvalue drop not null;
Alter table icinga_scheduleddowntime  alter column scheduleddowntime_id type bigint;
Alter table icinga_scheduleddowntime  alter column instance_id type bigint;
Alter table icinga_scheduleddowntime  alter column instance_id drop not null;
Alter table icinga_scheduleddowntime  alter column downtime_type drop not null;
Alter table icinga_scheduleddowntime  alter column object_id type bigint;
Alter table icinga_scheduleddowntime  alter column object_id drop not null;
Alter table icinga_scheduleddowntime  alter column entry_time drop not null;
Alter table icinga_scheduleddowntime  alter column author_name drop not null;
Alter table icinga_scheduleddowntime  alter column comment_data drop not null;
Alter table icinga_scheduleddowntime  alter column internal_downtime_id type bigint;
Alter table icinga_scheduleddowntime  alter column internal_downtime_id drop not null;
Alter table icinga_scheduleddowntime  alter column triggered_by_id type bigint;
Alter table icinga_scheduleddowntime  alter column triggered_by_id drop not null;
Alter table icinga_scheduleddowntime  alter column is_fixed drop not null;
Alter table icinga_scheduleddowntime  alter column duration drop not null;
Alter table icinga_scheduleddowntime  alter column scheduled_start_time drop not null;
Alter table icinga_scheduleddowntime  alter column scheduled_end_time drop not null;
Alter table icinga_scheduleddowntime  alter column was_started drop not null;
Alter table icinga_scheduleddowntime  alter column actual_start_time drop not null;
Alter table icinga_scheduleddowntime  alter column actual_start_time_usec drop not null;
Alter table icinga_servicechecks  alter column servicecheck_id type bigint;
Alter table icinga_servicechecks  alter column instance_id type bigint;
Alter table icinga_servicechecks  alter column instance_id drop not null;
Alter table icinga_servicechecks  alter column service_object_id type bigint;
Alter table icinga_servicechecks  alter column service_object_id drop not null;
Alter table icinga_servicechecks  alter column check_type drop not null;
Alter table icinga_servicechecks  alter column current_check_attempt drop not null;
Alter table icinga_servicechecks  alter column max_check_attempts drop not null;
Alter table icinga_servicechecks  alter column state drop not null;
Alter table icinga_servicechecks  alter column state_type drop not null;
Alter table icinga_servicechecks  alter column start_time drop not null;
Alter table icinga_servicechecks  alter column start_time_usec drop not null;
Alter table icinga_servicechecks  alter column end_time drop not null;
Alter table icinga_servicechecks  alter column end_time_usec drop not null;
Alter table icinga_servicechecks  alter column command_object_id type bigint;
Alter table icinga_servicechecks  alter column command_object_id drop not null;
Alter table icinga_servicechecks  alter column command_args drop not null;
Alter table icinga_servicechecks  alter column command_line drop not null;
Alter table icinga_servicechecks  alter column timeout drop not null;
Alter table icinga_servicechecks  alter column early_timeout drop not null;
Alter table icinga_servicechecks  alter column execution_time drop not null;
Alter table icinga_servicechecks  alter column latency drop not null;
Alter table icinga_servicechecks  alter column return_code drop not null;
Alter table icinga_servicechecks  alter column output drop not null;
Alter table icinga_servicechecks  alter column long_output drop not null;
Alter table icinga_servicechecks  alter column perfdata drop not null;
Alter table icinga_servicedependencies  alter column servicedependency_id type bigint;
Alter table icinga_servicedependencies  alter column instance_id type bigint;
Alter table icinga_servicedependencies  alter column instance_id drop not null;
Alter table icinga_servicedependencies  alter column config_type drop not null;
Alter table icinga_servicedependencies  alter column service_object_id type bigint;
Alter table icinga_servicedependencies  alter column service_object_id drop not null;
Alter table icinga_servicedependencies  alter column dependent_service_object_id type bigint;
Alter table icinga_servicedependencies  alter column dependent_service_object_id drop not null;
Alter table icinga_servicedependencies  alter column dependency_type drop not null;
Alter table icinga_servicedependencies  alter column inherits_parent drop not null;
Alter table icinga_servicedependencies  alter column timeperiod_object_id type bigint;
Alter table icinga_servicedependencies  alter column timeperiod_object_id drop not null;
Alter table icinga_servicedependencies  alter column fail_on_ok drop not null;
Alter table icinga_servicedependencies  alter column fail_on_warning drop not null;
Alter table icinga_servicedependencies  alter column fail_on_unknown drop not null;
Alter table icinga_servicedependencies  alter column fail_on_critical drop not null;
Alter table icinga_serviceescalations  alter column serviceescalation_id type bigint;
Alter table icinga_serviceescalations  alter column instance_id type bigint;
Alter table icinga_serviceescalations  alter column instance_id drop not null;
Alter table icinga_serviceescalations  alter column config_type drop not null;
Alter table icinga_serviceescalations  alter column service_object_id type bigint;
Alter table icinga_serviceescalations  alter column service_object_id drop not null;
Alter table icinga_serviceescalations  alter column timeperiod_object_id type bigint;
Alter table icinga_serviceescalations  alter column timeperiod_object_id drop not null;
Alter table icinga_serviceescalations  alter column first_notification drop not null;
Alter table icinga_serviceescalations  alter column last_notification drop not null;
Alter table icinga_serviceescalations  alter column notification_interval drop not null;
Alter table icinga_serviceescalations  alter column escalate_on_recovery drop not null;
Alter table icinga_serviceescalations  alter column escalate_on_warning drop not null;
Alter table icinga_serviceescalations  alter column escalate_on_unknown drop not null;
Alter table icinga_serviceescalations  alter column escalate_on_critical drop not null;
Alter table icinga_serviceescalation_contactgroups  alter column serviceescalation_contactgroup_id type bigint;
Alter table icinga_serviceescalation_contactgroups  alter column instance_id type bigint;
Alter table icinga_serviceescalation_contactgroups  alter column instance_id drop not null;
Alter table icinga_serviceescalation_contactgroups  alter column serviceescalation_id type bigint;
Alter table icinga_serviceescalation_contactgroups  alter column serviceescalation_id drop not null;
Alter table icinga_serviceescalation_contactgroups  alter column contactgroup_object_id type bigint;
Alter table icinga_serviceescalation_contactgroups  alter column contactgroup_object_id drop not null;
Alter table icinga_serviceescalation_contacts  alter column serviceescalation_contact_id type bigint;
Alter table icinga_serviceescalation_contacts  alter column instance_id type bigint;
Alter table icinga_serviceescalation_contacts  alter column instance_id drop not null;
Alter table icinga_serviceescalation_contacts  alter column serviceescalation_id type bigint;
Alter table icinga_serviceescalation_contacts  alter column serviceescalation_id drop not null;
Alter table icinga_serviceescalation_contacts  alter column contact_object_id type bigint;
Alter table icinga_serviceescalation_contacts  alter column contact_object_id drop not null;
Alter table icinga_servicegroups  alter column servicegroup_id type bigint;
Alter table icinga_servicegroups  alter column instance_id type bigint;
Alter table icinga_servicegroups  alter column instance_id drop not null;
Alter table icinga_servicegroups  alter column config_type drop not null;
Alter table icinga_servicegroups  alter column servicegroup_object_id type bigint;
Alter table icinga_servicegroups  alter column servicegroup_object_id drop not null;
Alter table icinga_servicegroups  alter column alias drop not null;
Alter table icinga_servicegroup_members  alter column servicegroup_member_id type bigint;
Alter table icinga_servicegroup_members  alter column instance_id type bigint;
Alter table icinga_servicegroup_members  alter column instance_id drop not null;
Alter table icinga_servicegroup_members  alter column servicegroup_id type bigint;
Alter table icinga_servicegroup_members  alter column servicegroup_id drop not null;
Alter table icinga_servicegroup_members  alter column service_object_id type bigint;
Alter table icinga_servicegroup_members  alter column service_object_id drop not null;
Alter table icinga_services  alter column service_id type bigint;
Alter table icinga_services  alter column instance_id type bigint;
Alter table icinga_services  alter column instance_id drop not null;
Alter table icinga_services  alter column config_type drop not null;
Alter table icinga_services  alter column host_object_id type bigint;
Alter table icinga_services  alter column host_object_id drop not null;
Alter table icinga_services  alter column service_object_id type bigint;
Alter table icinga_services  alter column service_object_id drop not null;
Alter table icinga_services  alter column display_name drop not null;
Alter table icinga_services  alter column check_command_object_id type bigint;
Alter table icinga_services  alter column check_command_object_id drop not null;
Alter table icinga_services  alter column check_command_args drop not null;
Alter table icinga_services  alter column eventhandler_command_object_id type bigint;
Alter table icinga_services  alter column eventhandler_command_object_id drop not null;
Alter table icinga_services  alter column eventhandler_command_args drop not null;
Alter table icinga_services  alter column notification_timeperiod_object_id type bigint;
Alter table icinga_services  alter column notification_timeperiod_object_id drop not null;
Alter table icinga_services  alter column check_timeperiod_object_id type bigint;
Alter table icinga_services  alter column check_timeperiod_object_id drop not null;
Alter table icinga_services  alter column failure_prediction_options drop not null;
Alter table icinga_services  alter column check_interval drop not null;
Alter table icinga_services  alter column retry_interval drop not null;
Alter table icinga_services  alter column max_check_attempts drop not null;
Alter table icinga_services  alter column first_notification_delay drop not null;
Alter table icinga_services  alter column notification_interval drop not null;
Alter table icinga_services  alter column notify_on_warning drop not null;
Alter table icinga_services  alter column notify_on_unknown drop not null;
Alter table icinga_services  alter column notify_on_critical drop not null;
Alter table icinga_services  alter column notify_on_recovery drop not null;
Alter table icinga_services  alter column notify_on_flapping drop not null;
Alter table icinga_services  alter column notify_on_downtime drop not null;
Alter table icinga_services  alter column stalk_on_ok drop not null;
Alter table icinga_services  alter column stalk_on_warning drop not null;
Alter table icinga_services  alter column stalk_on_unknown drop not null;
Alter table icinga_services  alter column stalk_on_critical drop not null;
Alter table icinga_services  alter column is_volatile drop not null;
Alter table icinga_services  alter column flap_detection_enabled drop not null;
Alter table icinga_services  alter column flap_detection_on_ok drop not null;
Alter table icinga_services  alter column flap_detection_on_warning drop not null;
Alter table icinga_services  alter column flap_detection_on_unknown drop not null;
Alter table icinga_services  alter column flap_detection_on_critical drop not null;
Alter table icinga_services  alter column low_flap_threshold drop not null;
Alter table icinga_services  alter column high_flap_threshold drop not null;
Alter table icinga_services  alter column process_performance_data drop not null;
Alter table icinga_services  alter column freshness_checks_enabled drop not null;
Alter table icinga_services  alter column freshness_threshold drop not null;
Alter table icinga_services  alter column passive_checks_enabled drop not null;
Alter table icinga_services  alter column event_handler_enabled drop not null;
Alter table icinga_services  alter column active_checks_enabled drop not null;
Alter table icinga_services  alter column retain_status_information drop not null;
Alter table icinga_services  alter column retain_nonstatus_information drop not null;
Alter table icinga_services  alter column notifications_enabled drop not null;
Alter table icinga_services  alter column obsess_over_service drop not null;
Alter table icinga_services  alter column failure_prediction_enabled drop not null;
Alter table icinga_services  alter column notes drop not null;
Alter table icinga_services  alter column notes_url drop not null;
Alter table icinga_services  alter column action_url drop not null;
Alter table icinga_services  alter column icon_image drop not null;
Alter table icinga_services  alter column icon_image_alt drop not null;
Alter table icinga_servicestatus  alter column servicestatus_id type bigint;
Alter table icinga_servicestatus  alter column instance_id type bigint;
Alter table icinga_servicestatus  alter column instance_id drop not null;
Alter table icinga_servicestatus  alter column service_object_id type bigint;
Alter table icinga_servicestatus  alter column service_object_id drop not null;
Alter table icinga_servicestatus  alter column status_update_time drop not null;
Alter table icinga_servicestatus  alter column output drop not null;
Alter table icinga_servicestatus  alter column long_output drop not null;
Alter table icinga_servicestatus  alter column perfdata drop not null;
Alter table icinga_servicestatus  alter column current_state drop not null;
Alter table icinga_servicestatus  alter column has_been_checked drop not null;
Alter table icinga_servicestatus  alter column should_be_scheduled drop not null;
Alter table icinga_servicestatus  alter column current_check_attempt drop not null;
Alter table icinga_servicestatus  alter column max_check_attempts drop not null;
Alter table icinga_servicestatus  alter column last_check drop not null;
Alter table icinga_servicestatus  alter column next_check drop not null;
Alter table icinga_servicestatus  alter column check_type drop not null;
Alter table icinga_servicestatus  alter column last_state_change drop not null;
Alter table icinga_servicestatus  alter column last_hard_state_change drop not null;
Alter table icinga_servicestatus  alter column last_hard_state drop not null;
Alter table icinga_servicestatus  alter column last_time_ok drop not null;
Alter table icinga_servicestatus  alter column last_time_warning drop not null;
Alter table icinga_servicestatus  alter column last_time_unknown drop not null;
Alter table icinga_servicestatus  alter column last_time_critical drop not null;
Alter table icinga_servicestatus  alter column state_type drop not null;
Alter table icinga_servicestatus  alter column last_notification drop not null;
Alter table icinga_servicestatus  alter column next_notification drop not null;
Alter table icinga_servicestatus  alter column no_more_notifications drop not null;
Alter table icinga_servicestatus  alter column notifications_enabled drop not null;
Alter table icinga_servicestatus  alter column problem_has_been_acknowledged drop not null;
Alter table icinga_servicestatus  alter column acknowledgement_type drop not null;
Alter table icinga_servicestatus  alter column current_notification_number drop not null;
Alter table icinga_servicestatus  alter column passive_checks_enabled drop not null;
Alter table icinga_servicestatus  alter column active_checks_enabled drop not null;
Alter table icinga_servicestatus  alter column event_handler_enabled drop not null;
Alter table icinga_servicestatus  alter column flap_detection_enabled drop not null;
Alter table icinga_servicestatus  alter column is_flapping drop not null;
Alter table icinga_servicestatus  alter column percent_state_change drop not null;
Alter table icinga_servicestatus  alter column latency drop not null;
Alter table icinga_servicestatus  alter column execution_time drop not null;
Alter table icinga_servicestatus  alter column scheduled_downtime_depth drop not null;
Alter table icinga_servicestatus  alter column failure_prediction_enabled drop not null;
Alter table icinga_servicestatus  alter column process_performance_data drop not null;
Alter table icinga_servicestatus  alter column obsess_over_service drop not null;
Alter table icinga_servicestatus  alter column modified_service_attributes drop not null;
Alter table icinga_servicestatus  alter column event_handler drop not null;
Alter table icinga_servicestatus  alter column check_command drop not null;
Alter table icinga_servicestatus  alter column normal_check_interval drop not null;
Alter table icinga_servicestatus  alter column retry_check_interval drop not null;
Alter table icinga_servicestatus  alter column check_timeperiod_object_id type bigint;
Alter table icinga_servicestatus  alter column check_timeperiod_object_id drop not null;
Alter table icinga_service_contactgroups  alter column service_contactgroup_id type bigint;
Alter table icinga_service_contactgroups  alter column instance_id type bigint;
Alter table icinga_service_contactgroups  alter column instance_id drop not null;
Alter table icinga_service_contactgroups  alter column service_id type bigint;
Alter table icinga_service_contactgroups  alter column service_id drop not null;
Alter table icinga_service_contactgroups  alter column contactgroup_object_id type bigint;
Alter table icinga_service_contactgroups  alter column contactgroup_object_id drop not null;
Alter table icinga_service_contacts  alter column service_contact_id type bigint;
Alter table icinga_service_contacts  alter column instance_id type bigint;
Alter table icinga_service_contacts  alter column instance_id drop not null;
Alter table icinga_service_contacts  alter column service_id type bigint;
Alter table icinga_service_contacts  alter column service_id drop not null;
Alter table icinga_service_contacts  alter column contact_object_id type bigint;
Alter table icinga_service_contacts  alter column contact_object_id drop not null;
Alter table icinga_statehistory  alter column statehistory_id type bigint;
Alter table icinga_statehistory  alter column instance_id type bigint;
Alter table icinga_statehistory  alter column instance_id drop not null;
Alter table icinga_statehistory  alter column state_time drop not null;
Alter table icinga_statehistory  alter column state_time_usec drop not null;
Alter table icinga_statehistory  alter column object_id type bigint;
Alter table icinga_statehistory  alter column object_id drop not null;
Alter table icinga_statehistory  alter column state_change drop not null;
Alter table icinga_statehistory  alter column state drop not null;
Alter table icinga_statehistory  alter column state_type drop not null;
Alter table icinga_statehistory  alter column current_check_attempt drop not null;
Alter table icinga_statehistory  alter column max_check_attempts drop not null;
Alter table icinga_statehistory  alter column last_state drop not null;
Alter table icinga_statehistory  alter column last_hard_state drop not null;
Alter table icinga_statehistory  alter column output drop not null;
Alter table icinga_statehistory  alter column long_output drop not null;
Alter table icinga_systemcommands  alter column systemcommand_id type bigint;
Alter table icinga_systemcommands  alter column instance_id type bigint;
Alter table icinga_systemcommands  alter column instance_id drop not null;
Alter table icinga_systemcommands  alter column start_time drop not null;
Alter table icinga_systemcommands  alter column start_time_usec drop not null;
Alter table icinga_systemcommands  alter column end_time drop not null;
Alter table icinga_systemcommands  alter column end_time_usec drop not null;
Alter table icinga_systemcommands  alter column command_line drop not null;
Alter table icinga_systemcommands  alter column timeout drop not null;
Alter table icinga_systemcommands  alter column early_timeout drop not null;
Alter table icinga_systemcommands  alter column execution_time drop not null;
Alter table icinga_systemcommands  alter column return_code drop not null;
Alter table icinga_systemcommands  alter column output drop not null;
Alter table icinga_systemcommands  alter column long_output drop not null;
Alter table icinga_timedeventqueue  alter column timedeventqueue_id type bigint;
Alter table icinga_timedeventqueue  alter column instance_id type bigint;
Alter table icinga_timedeventqueue  alter column instance_id drop not null;
Alter table icinga_timedeventqueue  alter column event_type drop not null;
Alter table icinga_timedeventqueue  alter column queued_time drop not null;
Alter table icinga_timedeventqueue  alter column queued_time_usec drop not null;
Alter table icinga_timedeventqueue  alter column scheduled_time drop not null;
Alter table icinga_timedeventqueue  alter column recurring_event drop not null;
Alter table icinga_timedeventqueue  alter column object_id type bigint;
Alter table icinga_timedeventqueue  alter column object_id drop not null;
Alter table icinga_timedevents  alter column timedevent_id type bigint;
Alter table icinga_timedevents  alter column instance_id type bigint;
Alter table icinga_timedevents  alter column instance_id drop not null;
Alter table icinga_timedevents  alter column event_type drop not null;
Alter table icinga_timedevents  alter column queued_time drop not null;
Alter table icinga_timedevents  alter column queued_time_usec drop not null;
Alter table icinga_timedevents  alter column event_time drop not null;
Alter table icinga_timedevents  alter column event_time_usec drop not null;
Alter table icinga_timedevents  alter column scheduled_time drop not null;
Alter table icinga_timedevents  alter column recurring_event drop not null;
Alter table icinga_timedevents  alter column object_id type bigint;
Alter table icinga_timedevents  alter column object_id drop not null;
Alter table icinga_timedevents  alter column deletion_time drop not null;
Alter table icinga_timedevents  alter column deletion_time_usec drop not null;
Alter table icinga_timeperiods  alter column timeperiod_id type bigint;
Alter table icinga_timeperiods  alter column instance_id type bigint;
Alter table icinga_timeperiods  alter column instance_id drop not null;
Alter table icinga_timeperiods  alter column config_type drop not null;
Alter table icinga_timeperiods  alter column timeperiod_object_id type bigint;
Alter table icinga_timeperiods  alter column timeperiod_object_id drop not null;
Alter table icinga_timeperiods  alter column alias drop not null;
Alter table icinga_timeperiod_timeranges  alter column timeperiod_timerange_id type bigint;
Alter table icinga_timeperiod_timeranges  alter column instance_id type bigint;
Alter table icinga_timeperiod_timeranges  alter column instance_id drop not null;
Alter table icinga_timeperiod_timeranges  alter column timeperiod_id type bigint;
Alter table icinga_timeperiod_timeranges  alter column timeperiod_id drop not null;
Alter table icinga_timeperiod_timeranges  alter column day drop not null;
Alter table icinga_timeperiod_timeranges  alter column start_sec drop not null;
Alter table icinga_timeperiod_timeranges  alter column end_sec drop not null;

-- -----------------------------------------
-- update dbversion
-- -----------------------------------------

SELECT updatedbversion('1.4.0');  

