# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-Art.
#
# Gnome-Art is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-Art is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-Art; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


module GnomeArt
  module GetArt

    def self.find_backgrounds_entry(filename)

      file_backgrounds = File.new(Config::Gnome_backgrounds, "r")

      if (file_backgrounds == nil)
        return nil
      end

      doc = REXML::Document.new file_backgrounds

      root = doc.root
      backgrounds = root

      found = false

      backgrounds.elements.each("wallpaper") { |element|
  
        found_filename = ""

        element.elements.each("filename") { |attribute|
          found_filename = attribute.text
        }        

        if (found_filename == filename)
          found = true
        end
      }

      return found

    end

    def self.update_backgrounds_entry(name, filename)
      file_backgrounds = File.new(Config::Gnome_backgrounds, "r+")

      if (file_backgrounds == nil)
        return nil
      end

      doc = REXML::Document.new file_backgrounds

      root = doc.root
      backgrounds = root


      backgrounds.elements.each("wallpaper") { |element|
  
        found_filename = ""

        element.elements.each("filename") { |attribute|
          found_filename = attribute.text
        }        


        if (found_filename == filename)
          #Update backgrounds entry
          element.attributes["deleted"] = "false"

          element.elements.each("name") { |attribute|
            attribute.text = name
          }
        end
      }

      output = ""
      doc.write(output, 0)

      file_backgrounds.truncate(0)
      file_backgrounds.rewind
      file_backgrounds.write(output)
      file_backgrounds.close
    

    end

    def self.add_backgrounds_entry(name, filename)

      file_backgrounds = File.new(Config::Gnome_backgrounds, "r+")

      if (file_backgrounds == nil)
        return nil
      end

      doc = REXML::Document.new file_backgrounds

      root = doc.root
      backgrounds = root
      new_background = backgrounds.add_element("wallpaper")
      new_background.attributes["deleted"] = "false"
      
      name_element = new_background.add_element("name")
      name_element.text = name

      filename_element = new_background.add_element("filename")
      filename_element.text = filename

      options_element = new_background.add_element("options")
      options_element.text = "wallpaper"

      shade_type_element = new_background.add_element("shade_type")
      shade_type_element.text = "solid"

      pcolor_element = new_background.add_element("pcolor")
      pcolor_element.text = "#76868F"

      scolor_element = new_background.add_element("scolor")
      scolor_element.text = "#7F7F7F"


      output = ""
      doc.write(output, 0)

      file_backgrounds.truncate(0)
      file_backgrounds.rewind
      file_backgrounds.write(output)
      file_backgrounds.close

    end


  	def self.download(source, target)
  	
      #puts "Source: #{source}\nTarget: #{target}"

      begin 
        io = File.open(target, "wb") 

        open(source, "rb") { |f|
            io.write f.read
        }

        io.close
      rescue OpenURI::HTTPError
        io.close
      
        #HTTP Error - delete target
        puts "HTTP Error with URL: #{source} - #{target} deleted"

        File.delete(target)

        return 1
      end

      return 0
    end


    def self.search_element(root, name)
      root.elements.each(name) { |element| 
        yield element 
        
        search_element(element, name) { |element|
          yield element
        }
      }
    end

    def self.get_filename_by_location(location)
      if (location != nil)
        filename = File.basename(location, "")
      else
        return ""
      end
    end


    def self.get_default_pixbuf

      filename = Config::No_thumbnail_image

      if (!File.exists?(filename))
        #No image to load
        return nil
      end

      begin
      	loader = Gdk::PixbufLoader.new
      	open(filename) { |f|
        	loader.last_write(f.read)
      	}
      rescue Gdk::PixbufError
        return nil
      end

      pixbuf = loader.pixbuf

    end


    def self.download_pixbuf(url) 

      if (url == "")
        puts "Invalid URL"

        return get_default_pixbuf
      end


      basename = File.basename(url)


      filename = Config::Thumbnail_dir + "/" + basename

      status = false

      url.gsub!(" ", "%20")

      if (!File.exists?(filename))
        if (download(url, filename) == 1)
          #Download Error
          return get_default_pixbuf
        end
      end

      begin
      	loader = Gdk::PixbufLoader.new
      	open(filename) { |f|
        	loader.last_write(f.read)
      	}
      rescue Gdk::PixbufError
        #File Error - delete file
        puts "PixbufError with File: #{filename} - deleted"
        File.delete(filename)

      end
    	
      pixbuf = loader.pixbuf
    end


    def self.get_themes(art_id, count_only) 
		
      #Parsing the art.gnome.org - XML - File
      #puts "Downloading the XML - File"

      parameter = "art=#{art_id}"

      xml_filename = Config::XML_File  + "?" + parameter
      #puts xml_filename
      temp_filename = Config::Temp_dir + "/" + "xml?" + parameter

      if (!FileTest.exist?(temp_filename))  
        download(xml_filename, temp_filename)
      end

      themes = File.new(temp_filename, "r+")

      if (themes == nil)
        puts "Error"
        return nil
      end

      doc = REXML::Document.new themes

      art = doc.root

      count = 0

      search_element(art, "theme") { |element|

          count = count + 1

          name = ""
          description = ""
          category = ""
          author = ""
          license = ""
          vote_sum = 0
          vote_count = 0
          thumbnail = ""
          small_thumbnail = ""
          location = ""
          release_date = ""
          download_start_timestamp = 0
          download_count = 0
          

          element.elements.each("name") { |attribute|
            name = attribute.text
          }

          element.elements.each("description") { |attribute|
            description = attribute.text
          }

          element.elements.each("category") { |attribute|
            category = attribute.text
          }

          element.elements.each("author") { |attribute|
            author = attribute.text
          }

          element.elements.each("license") { |attribute|
            license = attribute.text
          }

          vote_sum = element.attributes["vote_sum"].to_i
          vote_count = element.attributes["vote_count"].to_i
          download_start_timestamp = element.attributes["download_start_timestamp"].to_i
          download_count = element.attributes["download_count"].to_i
          release_date = element.attributes["release_date"]

          element.elements.each("url") { |attribute|
            location = attribute.text
          }

          #This thumbnail is a preview of the theme
          element.elements.each("thumbnail") { |attribute|
            thumbnail = attribute.text
          }

          #This thumbnail is for the list
          element.elements.each("small_thumbnail") { |attribute|
            small_thumbnail = attribute.text
          }


          if (name == nil)
            name = ""
          end

          if (description == nil)
            description = ""
          end

          if (category == nil)
            category = ""
          end

          if (author == nil) 
            author = ""
          end

          if (license == nil)
            license = ""
          end

          if (vote_sum == nil)
            vote_sum = 0
          end

          if (vote_count == nil)
            vote_count = 0
          end

          if (release_date == nil)
            release_date = ""
          end

          if (download_start_timestamp == nil)
            download_start_timestamp = 0
          end

          if (download_count == nil)
            download_count = 0
          end

          if (thumbnail == nil) 
            thumbnail = ""
          end

          if (location == nil)  
            location = ""
          end

          if (small_thumbnail == nil)  
            small_thumbnail = ""
          end

          preview = ""

          if (art_id == Config::Other_themes_splash_screens)
            preview = location
          else 
            preview = thumbnail
          end

          if (count_only == false)
            pixbuf = download_pixbuf(small_thumbnail)
            yield(pixbuf, name, description, author, license, location, preview, release_date, download_start_timestamp, download_count, vote_sum, vote_count)
          end

      }        

      themes.close

      return count

    end

    def self.get_backgrounds(art, count_only) 
		
      #Parsing the art.gnome.org - XML - File

      parameter = "art=#{art}"

      xml_filename = Config::XML_File  + "?" + parameter
      temp_filename = Config::Temp_dir + "/" + "xml?" + parameter

      if (!FileTest.exist?(temp_filename))  
        download(xml_filename, temp_filename)
      end

      backgrounds = File.new(temp_filename, "r")

      if (backgrounds == nil)
        puts "Error"
        return nil
      end

      doc = REXML::Document.new backgrounds

      art = doc.root

      count = 0

      search_element(art, "background") { |element|

          name = ""
          description = ""
          category = ""
          author = ""
          thumbnail = ""
          license = ""
          release_date = ""
          vote_count = 0
          vote_sum = 0
          download_start_timestamp = 0
          download_count = 0
          

          element.elements.each("name") { |attribute|
            name = attribute.text
          }

          element.elements.each("description") { |attribute|
            description = attribute.text
          }

          element.elements.each("category") { |attribute|
            category = attribute.text
          }

          element.elements.each("author") { |attribute|
            author = attribute.text
          }

          element.elements.each("license") { |attribute|
            license = attribute.text
          }

          element.elements.each("thumbnail") { |attribute|
            thumbnail = attribute.text
          }


          vote_sum = element.attributes["vote_sum"].to_i
          vote_count = element.attributes["vote_count"].to_i
          download_start_timestamp = element.attributes["download_start_timestamp"].to_i
          download_count = element.attributes["download_count"].to_i
          release_date = element.attributes["release_date"]

          if (name == nil)
            name = ""
          end

          if (description == nil)
            description = ""
          end

          if (category == nil)
            category = ""
          end

          if (author == nil) 
            author = ""
          end

          if (license == nil)
            license = ""
          end

          if (vote_sum == nil)
            vote_sum = 0
          end

          if (vote_count == nil)
            vote_count = 0
          end

          if (release_date == nil)
            release_date = ""
          end

          if (download_start_timestamp == nil)
            download_start_timestamp = 0
          end

          if (download_count == nil)
            download_count = 0
          end

          if (thumbnail == nil) 
            thumbnail = ""
          end



          element.elements.each("background_resolution") { |element|

            count = count + 1

            type = ""
            resolution = ""
            location = ""

            element.elements.each("jpg") { |attribute|
              type = attribute.text
            }

            element.elements.each("url") { |attribute|
              location = attribute.text
            }
          
            element.elements.each("resolution") { |attribute|
              resolution = attribute.text
            }


            if (type == nil)
              type = ""
            end

            if (location == nil)  
              location = ""
            end

            if (resolution == nil)
              resolution = ""
            end


            if (count_only == false)
              
              pixbuf = download_pixbuf(thumbnail)
  
              yield(pixbuf, name, description, author, license, location, location, resolution, release_date, download_start_timestamp, download_count, vote_sum, vote_count)
            end
              
          }

      }        


      backgrounds.close

      return count

    end

  end
end
