/*
			    Endeavour MIME Type
 */

#ifndef EDV_MIME_TYPE_H
#define EDV_MIME_TYPE_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _edv_mime_type_command_struct	edv_mime_type_command_struct;
#define EDV_MIME_TYPE_COMMAND(p)	((edv_mime_type_command_struct *)(p))
typedef struct _edv_mime_type_struct	edv_mime_type_struct;
#define EDV_MIME_TYPE(p)			((edv_mime_type_struct *)(p))


/*
 *	MIME Type Icon States:
 */
typedef enum{
	EDV_MIME_TYPE_ICON_STATE_STANDARD,
	EDV_MIME_TYPE_ICON_STATE_SELECTED,	/* Directories=Expanded
						 * Other=Selected */
	EDV_MIME_TYPE_ICON_STATE_EXTENDED,	/* Links=Broken
						 * Other=Active/Opened/Reserved	 */
	EDV_MIME_TYPE_ICON_STATE_HIDDEN
} edv_mime_type_icon_state;
#define EDV_MIME_TYPE_TOTAL_ICON_STATES		4


/*
 *	Inode MIME Types:
 *
 *	Used for EDV_MIME_TYPE_CLASS_SYSTEM MIME Types.
 */
#define EDV_MIME_TYPE_TYPE_INODE_UNKNOWN	"inode/unknown"
#define EDV_MIME_TYPE_TYPE_INODE_ERROR		"inode/error"
#define EDV_MIME_TYPE_TYPE_INODE_FILE		"inode/file"
#define EDV_MIME_TYPE_TYPE_INODE_EXECUTABLE	"inode/executable"
#define EDV_MIME_TYPE_TYPE_INODE_DIRECTORY	"inode/directory"
#define EDV_MIME_TYPE_TYPE_INODE_LINK		"inode/link"
#define EDV_MIME_TYPE_TYPE_INODE_DEV_BLOCK	"inode/dev-block"
#define EDV_MIME_TYPE_TYPE_INODE_DEV_CHARACTER	"inode/dev-character"
#define EDV_MIME_TYPE_TYPE_INODE_FIFO		"inode/fifo"
#define EDV_MIME_TYPE_TYPE_INODE_SOCKET		"inode/socket"


/*
 *	MIME Type Command:
 */
struct _edv_mime_type_command_struct {
	gchar		*name,
			*command;
};


/*
 *	MIME Type:
 */
struct _edv_mime_type_struct {

	edv_mime_type_class	mt_class;

	/* The MIME Type's value, it is determined by the class:
	 *
	 * mt_class			value is a
	 * --------                     ----------
	 * EDV_MIME_TYPE_CLASS_SYSTEM	*Ignored*
	 * EDV_MIME_TYPE_CLASS_FORMAT	Space separated list of extensions
	 * EDV_MIME_TYPE_CLASS_PROGRAM	Path to the program object
	 * EDV_MIME_TYPE_CLASS_UNIQUE	Path to the unique object
	 */
	gchar		*value;

	/* The name of the MIME Type */
	gchar		*type;

	/* A one line verbose description of the MIME Type */
	gchar		*description;


	/* Indicates if this MIME Type has been realized, meaning that
	 * its icons and related resources have been initialized/loaded
	 */
	gboolean	realized;

	/* Indicates that this MIME Type is either created internally
	 * or loaded from a global configuration
	 *
	 * Either of which cannot be modified or removed if this is
	 * set TRUE
	 */
	gboolean	read_only;

	/* Small 20x20 icons */
	GdkPixmap	*small_pixmap[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	GdkBitmap	*small_mask[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*small_icon_file[EDV_MIME_TYPE_TOTAL_ICON_STATES];

	/* Medium 32x32 icons */
	GdkPixmap	*medium_pixmap[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	GdkBitmap	*medium_mask[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*medium_icon_file[EDV_MIME_TYPE_TOTAL_ICON_STATES];

	/* Large 48x48 icons */
	GdkPixmap	*large_pixmap[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	GdkBitmap	*large_mask[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*large_icon_file[EDV_MIME_TYPE_TOTAL_ICON_STATES];


	/* Handler, one of EDV_MIME_TYPE_HANDLER_*
	 *
	 * This is basically to determine if a command should be used
	 * to open the object associated with this MIME Type (in the
	 * case of EDV_MIME_TYPE_HANDLER_COMMAND) or to use one of
	 * Endeavour's windows to open the object
	 */
	edv_mime_type_handler	handler;

	/* Commands List
	 *
	 * Each item in the list points to a
	 * edv_mime_type_command_struct
	 *
	 * Command are only used if the handler is set to
	 * EDV_MIME_TYPE_HANDLER_COMMAND
	 *
	 * The first command is considered the default
	 *
	 * The intention of each command is related by the mt_class as
	 * follows:
	 *
	 * mt_class			value is a
	 * --------			----------
	 * EDV_MIME_TYPE_CLASS_SYSTEM	*Ignored*
	 * EDV_MIME_TYPE_CLASS_FORMAT	Program commands or program aliases
	 * EDV_MIME_TYPE_CLASS_PROGRAM	Program commands (no aliases)
	 * EDV_MIME_TYPE_CLASS_UNIQUE	Program commands or program aliases
	 */
	GList		*commands_list;

	/* Time stamps */
	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

};


extern const gchar *EDVMimeTypeGetCommandValueByName(
	edv_mime_type_struct *m, const gchar *name
);
extern edv_mime_type_command_struct *EDVMimeTypeGetCommandByName(
	edv_mime_type_struct *m, const gchar *name
);

extern edv_mime_type_command_struct *EDVMimeTypeCommandNew(void);
extern void EDVMimeTypeCommandDelete(edv_mime_type_command_struct *cmd);

extern edv_mime_type_struct *EDVMimeTypeNew(
	edv_mime_type_class mt_class,	/* One of EDV_MIME_TYPE_CLASS_* */
	const gchar *value,
	const gchar *type,		/* MIME Type name */
	const gchar *description	/* Short verbose description */
);

extern void EDVMimeTypeLoadSmallIconsData(
	edv_mime_type_struct *m, guint8 ***data
);
extern void EDVMimeTypeLoadMediumIconsData(
	edv_mime_type_struct *m, guint8 ***data
);
extern void EDVMimeTypeLoadLargeIconsData(
	edv_mime_type_struct *m, guint8 ***data
);

extern void EDVMimeTypeRealize(
	edv_mime_type_struct *m, gboolean force_rerealize
);

extern void EDVMimeTypeDelete(edv_mime_type_struct *m);


#endif	/* EDV_MIME_TYPE_H */
