/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.CaseMgr;
import com.stevesoft.pat.Prop;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.RegSyntaxError;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.ReplaceRule;
import com.stevesoft.pat.StringRule;

class parsePerl {
    parsePerl() {
    }

    static final char close(char c) {
        if (c == '<') {
            return '>';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '(') {
            return ')';
        }
        if (c == '{') {
            return '}';
        }
        return c;
    }

    public static final String codify(String s, boolean keepbs) {
        return parsePerl.codify(s, 0, s.length(), keepbs);
    }

    public static final String codify(String s, int i0, int iN, boolean keepbs) {
        StringBuffer sb = new StringBuffer();
        boolean ucmode = false;
        boolean lcmode = false;
        boolean litmode = false;
        boolean uc1 = false;
        boolean lc1 = false;
        boolean modified = false;
        for (int i = i0; i < iN; ++i) {
            char c = s.charAt(i);
            boolean mf = true;
            boolean app = true;
            if (c == '\\') {
                app = false;
                if (++i < s.length()) {
                    char c2 = s.charAt(i);
                    switch (c2) {
                        case 'Q': {
                            litmode = true;
                            break;
                        }
                        case 'U': {
                            ucmode = true;
                            break;
                        }
                        case 'L': {
                            lcmode = true;
                            break;
                        }
                        case 'u': {
                            uc1 = true;
                            break;
                        }
                        case 'l': {
                            lc1 = true;
                            break;
                        }
                        case 'E': {
                            litmode = false;
                            lcmode = false;
                            ucmode = false;
                            lc1 = false;
                            uc1 = false;
                            break;
                        }
                        default: {
                            if (keepbs) {
                                sb.append('\\');
                            }
                            c = c2;
                            if (keepbs) {
                                mf = false;
                            }
                            app = true;
                        }
                    }
                    modified |= mf;
                }
            }
            if (!app) continue;
            if (lc1) {
                c = parsePerl.lc(c);
                lc1 = false;
            } else if (uc1) {
                c = parsePerl.uc(c);
                uc1 = false;
            } else if (ucmode) {
                c = parsePerl.uc(c);
            } else if (lcmode) {
                c = parsePerl.lc(c);
            }
            if (litmode && parsePerl.needbs(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return modified ? sb.toString() : s;
    }

    static final char uc(char c) {
        return CaseMgr.toUpperCase(c);
    }

    static final char lc(char c) {
        return CaseMgr.toLowerCase(c);
    }

    static final boolean needbs(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        return c != '_';
    }

    static final Regex parse(String s) {
        char mode;
        boolean igncase = false;
        boolean optim = false;
        boolean gFlag = false;
        boolean sFlag = false;
        boolean mFlag = false;
        boolean xFlag = false;
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        int i = 0;
        int count = 0;
        char delim = '/';
        char cdelim = '/';
        if (s.length() >= 3 && s.charAt(0) == 's') {
            mode = 's';
            delim = s.charAt(1);
            cdelim = parsePerl.close(delim);
            i = 2;
        } else if (s.length() >= 2 && s.charAt(0) == 'm') {
            mode = 'm';
            delim = s.charAt(1);
            cdelim = parsePerl.close(delim);
            i = 2;
        } else if (s.length() >= 1 && s.charAt(0) == '/') {
            mode = 'm';
            i = 1;
        } else {
            try {
                RegSyntaxError.endItAll("Regex.perlCode should be of the form s/// or m// or //");
            }
            catch (RegSyntax rs) {
                // empty catch block
            }
            return null;
        }
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                s1.append('\\');
                ++i;
            } else {
                if (s.charAt(i) == cdelim && count == 0) {
                    ++i;
                    break;
                }
                if (s.charAt(i) == delim && cdelim != delim) {
                    ++count;
                } else if (s.charAt(i) == cdelim && cdelim != delim) {
                    --count;
                }
            }
            s1.append(s.charAt(i));
            ++i;
        }
        if (mode == 's' && cdelim != delim) {
            while (i < s.length() && Prop.isWhite(s.charAt(i))) {
                ++i;
            }
            if (i >= s.length()) {
                try {
                    RegSyntaxError.endItAll("" + mode + delim + " needs " + cdelim);
                }
                catch (RegSyntax rs) {
                    // empty catch block
                }
                return null;
            }
            delim = s.charAt(i);
            cdelim = parsePerl.close(delim);
            ++i;
        }
        count = 0;
        if (mode == 's') {
            while (i < s.length()) {
                if (s.charAt(i) == '\\') {
                    s2.append('\\');
                    ++i;
                } else {
                    if (s.charAt(i) == cdelim && count == 0) {
                        ++i;
                        break;
                    }
                    if (s.charAt(i) == delim && cdelim != delim) {
                        ++count;
                    } else if (s.charAt(i) == cdelim && cdelim != delim) {
                        --count;
                    }
                }
                s2.append(s.charAt(i));
                ++i;
            }
        }
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case 'x': {
                    xFlag = true;
                    break;
                }
                case 'i': {
                    igncase = true;
                    break;
                }
                case 'o': {
                    optim = true;
                    break;
                }
                case 's': {
                    sFlag = true;
                    break;
                }
                case 'm': {
                    mFlag = true;
                    break;
                }
                case 'g': {
                    gFlag = true;
                    break;
                }
                default: {
                    try {
                        RegSyntaxError.endItAll("Illegal flag to pattern: " + c);
                    }
                    catch (RegSyntax rs) {
                        // empty catch block
                    }
                    return null;
                }
            }
            ++i;
        }
        Regex r = new Regex();
        try {
            String pat = s1.toString();
            String reprul = s2.toString();
            if (xFlag) {
                pat = parsePerl.strip(pat);
                reprul = parsePerl.strip(reprul);
            }
            r.compile(pat);
            r.ignoreCase |= igncase;
            r.gFlag |= gFlag;
            r.sFlag |= sFlag;
            r.mFlag |= mFlag;
            if (optim) {
                r.optimize();
            }
            if (delim == '\'') {
                r.setReplaceRule(new StringRule(reprul));
            } else {
                r.setReplaceRule(ReplaceRule.perlCode(reprul));
            }
        }
        catch (RegSyntax rs) {
            r = null;
        }
        return r;
    }

    static String strip(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Prop.isWhite(c)) continue;
            if (c == '#') {
                ++i;
                while (i < s.length() && s.charAt(i) != '\n') {
                    ++i;
                }
                continue;
            }
            if (c == '\\') {
                sb.append(c);
                sb.append(s.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

