#ifndef APTITUDES_H
#define APTITUDES_H

#include "enum.h"

static inline species_skill_aptitude APT(species_type sp,
                                         skill_type sk,
                                         int aptitude)
{
    return species_skill_aptitude(sp, sk, aptitude);
}

static const species_skill_aptitude species_skill_aptitudes[] =
{
    // SP_HUMAN
    APT(SP_HUMAN,           SK_FIGHTING,        0),
    APT(SP_HUMAN,           SK_SHORT_BLADES,    0),
    APT(SP_HUMAN,           SK_LONG_BLADES,     0),
    APT(SP_HUMAN,           SK_AXES,            0),
    APT(SP_HUMAN,           SK_MACES_FLAILS,    0),
    APT(SP_HUMAN,           SK_POLEARMS,        0),
    APT(SP_HUMAN,           SK_STAVES,          0),
    APT(SP_HUMAN,           SK_SLINGS,          0),
    APT(SP_HUMAN,           SK_BOWS,            0),
    APT(SP_HUMAN,           SK_CROSSBOWS,       0),
    APT(SP_HUMAN,           SK_THROWING,        0),
    APT(SP_HUMAN,           SK_ARMOUR,          0),
    APT(SP_HUMAN,           SK_DODGING,         0),
    APT(SP_HUMAN,           SK_STEALTH,         0),
    APT(SP_HUMAN,           SK_STABBING,        0),
    APT(SP_HUMAN,           SK_SHIELDS,         0),
    APT(SP_HUMAN,           SK_TRAPS_DOORS,     0),
    APT(SP_HUMAN,           SK_UNARMED_COMBAT,  0),
    APT(SP_HUMAN,           SK_SPELLCASTING,    0),
    APT(SP_HUMAN,           SK_CONJURATIONS,    0),
    APT(SP_HUMAN,           SK_HEXES,           0),
    APT(SP_HUMAN,           SK_CHARMS,          0),
    APT(SP_HUMAN,           SK_SUMMONINGS,      0),
    APT(SP_HUMAN,           SK_NECROMANCY,      0),
    APT(SP_HUMAN,           SK_TRANSLOCATIONS,  0),
    APT(SP_HUMAN,           SK_TRANSMUTATIONS,  0),
    APT(SP_HUMAN,           SK_FIRE_MAGIC,      0),
    APT(SP_HUMAN,           SK_ICE_MAGIC,       0),
    APT(SP_HUMAN,           SK_AIR_MAGIC,       0),
    APT(SP_HUMAN,           SK_EARTH_MAGIC,     0),
    APT(SP_HUMAN,           SK_POISON_MAGIC,    0),
    APT(SP_HUMAN,           SK_INVOCATIONS,     0),
    APT(SP_HUMAN,           SK_EVOCATIONS,      0),

    // SP_HIGH_ELF
    APT(SP_HIGH_ELF,        SK_FIGHTING,        0),
    APT(SP_HIGH_ELF,        SK_SHORT_BLADES,    2),
    APT(SP_HIGH_ELF,        SK_LONG_BLADES,     2),
    APT(SP_HIGH_ELF,        SK_AXES,           -2),
    APT(SP_HIGH_ELF,        SK_MACES_FLAILS,   -2),
    APT(SP_HIGH_ELF,        SK_POLEARMS,       -2),
    APT(SP_HIGH_ELF,        SK_STAVES,          0),
    APT(SP_HIGH_ELF,        SK_SLINGS,         -2),
    APT(SP_HIGH_ELF,        SK_BOWS,            3),
    APT(SP_HIGH_ELF,        SK_CROSSBOWS,       0),
    APT(SP_HIGH_ELF,        SK_THROWING,        1),
    APT(SP_HIGH_ELF,        SK_ARMOUR,         -1),
    APT(SP_HIGH_ELF,        SK_DODGING,         1),
    APT(SP_HIGH_ELF,        SK_STEALTH,         1),
    APT(SP_HIGH_ELF,        SK_STABBING,       -1),
    APT(SP_HIGH_ELF,        SK_SHIELDS,        -1),
    APT(SP_HIGH_ELF,        SK_TRAPS_DOORS,     0),
    APT(SP_HIGH_ELF,        SK_UNARMED_COMBAT, -2),
    APT(SP_HIGH_ELF,        SK_SPELLCASTING,    2),
    APT(SP_HIGH_ELF,        SK_CONJURATIONS,    1),
    APT(SP_HIGH_ELF,        SK_HEXES,           0),
    APT(SP_HIGH_ELF,        SK_CHARMS,          2),
    APT(SP_HIGH_ELF,        SK_SUMMONINGS,     -1),
    APT(SP_HIGH_ELF,        SK_NECROMANCY,     -2),
    APT(SP_HIGH_ELF,        SK_TRANSLOCATIONS,  1),
    APT(SP_HIGH_ELF,        SK_TRANSMUTATIONS,  1),
    APT(SP_HIGH_ELF,        SK_FIRE_MAGIC,      0),
    APT(SP_HIGH_ELF,        SK_ICE_MAGIC,       0),
    APT(SP_HIGH_ELF,        SK_AIR_MAGIC,       2),
    APT(SP_HIGH_ELF,        SK_EARTH_MAGIC,    -2),
    APT(SP_HIGH_ELF,        SK_POISON_MAGIC,   -2),
    APT(SP_HIGH_ELF,        SK_INVOCATIONS,     0),
    APT(SP_HIGH_ELF,        SK_EVOCATIONS,      0),

    // SP_DEEP_ELF
    APT(SP_DEEP_ELF,        SK_FIGHTING,       -2),
    APT(SP_DEEP_ELF,        SK_SHORT_BLADES,    0),
    APT(SP_DEEP_ELF,        SK_LONG_BLADES,    -1),
    APT(SP_DEEP_ELF,        SK_AXES,           -2),
    APT(SP_DEEP_ELF,        SK_MACES_FLAILS,   -3),
    APT(SP_DEEP_ELF,        SK_POLEARMS,       -3),
    APT(SP_DEEP_ELF,        SK_STAVES,          0),
    APT(SP_DEEP_ELF,        SK_SLINGS,         -2),
    APT(SP_DEEP_ELF,        SK_BOWS,            1),
    APT(SP_DEEP_ELF,        SK_CROSSBOWS,      -1),
    APT(SP_DEEP_ELF,        SK_THROWING,        1),
    APT(SP_DEEP_ELF,        SK_ARMOUR,         -2),
    APT(SP_DEEP_ELF,        SK_DODGING,         2),
    APT(SP_DEEP_ELF,        SK_STEALTH,         2),
    APT(SP_DEEP_ELF,        SK_STABBING,        1),
    APT(SP_DEEP_ELF,        SK_SHIELDS,        -2),
    APT(SP_DEEP_ELF,        SK_TRAPS_DOORS,     0),
    APT(SP_DEEP_ELF,        SK_UNARMED_COMBAT, -2),
    APT(SP_DEEP_ELF,        SK_SPELLCASTING,    4),
    APT(SP_DEEP_ELF,        SK_CONJURATIONS,    1),
    APT(SP_DEEP_ELF,        SK_HEXES,           3),
    APT(SP_DEEP_ELF,        SK_CHARMS,          4),
    APT(SP_DEEP_ELF,        SK_SUMMONINGS,      1),
    APT(SP_DEEP_ELF,        SK_NECROMANCY,      2),
    APT(SP_DEEP_ELF,        SK_TRANSLOCATIONS,  1),
    APT(SP_DEEP_ELF,        SK_TRANSMUTATIONS,  1),
    APT(SP_DEEP_ELF,        SK_FIRE_MAGIC,      1),
    APT(SP_DEEP_ELF,        SK_ICE_MAGIC,       1),
    APT(SP_DEEP_ELF,        SK_AIR_MAGIC,       1),
    APT(SP_DEEP_ELF,        SK_EARTH_MAGIC,     0),
    APT(SP_DEEP_ELF,        SK_POISON_MAGIC,    1),
    APT(SP_DEEP_ELF,        SK_INVOCATIONS,     0),
    APT(SP_DEEP_ELF,        SK_EVOCATIONS,      1),

    // SP_SLUDGE_ELF
    APT(SP_SLUDGE_ELF,      SK_FIGHTING,        1),
    APT(SP_SLUDGE_ELF,      SK_SHORT_BLADES,   -1),
    APT(SP_SLUDGE_ELF,      SK_LONG_BLADES,    -1),
    APT(SP_SLUDGE_ELF,      SK_AXES,           -2),
    APT(SP_SLUDGE_ELF,      SK_MACES_FLAILS,   -2),
    APT(SP_SLUDGE_ELF,      SK_POLEARMS,       -2),
    APT(SP_SLUDGE_ELF,      SK_STAVES,          0),
    APT(SP_SLUDGE_ELF,      SK_SLINGS,          0),
    APT(SP_SLUDGE_ELF,      SK_BOWS,            0),
    APT(SP_SLUDGE_ELF,      SK_CROSSBOWS,       0),
    APT(SP_SLUDGE_ELF,      SK_THROWING,        2),
    APT(SP_SLUDGE_ELF,      SK_ARMOUR,         -2),
    APT(SP_SLUDGE_ELF,      SK_DODGING,         2),
    APT(SP_SLUDGE_ELF,      SK_STEALTH,         1),
    APT(SP_SLUDGE_ELF,      SK_STABBING,        0),
    APT(SP_SLUDGE_ELF,      SK_SHIELDS,        -2),
    APT(SP_SLUDGE_ELF,      SK_TRAPS_DOORS,     0),
    APT(SP_SLUDGE_ELF,      SK_UNARMED_COMBAT,  1),
    APT(SP_SLUDGE_ELF,      SK_SPELLCASTING,    2),
    APT(SP_SLUDGE_ELF,      SK_CONJURATIONS,   -2),
    APT(SP_SLUDGE_ELF,      SK_HEXES,           0),
    APT(SP_SLUDGE_ELF,      SK_CHARMS,         -2),
    APT(SP_SLUDGE_ELF,      SK_SUMMONINGS,      1),
    APT(SP_SLUDGE_ELF,      SK_NECROMANCY,      1),
    APT(SP_SLUDGE_ELF,      SK_TRANSLOCATIONS,  0),
    APT(SP_SLUDGE_ELF,      SK_TRANSMUTATIONS,  3),
    APT(SP_SLUDGE_ELF,      SK_FIRE_MAGIC,      1),
    APT(SP_SLUDGE_ELF,      SK_ICE_MAGIC,       1),
    APT(SP_SLUDGE_ELF,      SK_AIR_MAGIC,       1),
    APT(SP_SLUDGE_ELF,      SK_EARTH_MAGIC,     1),
    APT(SP_SLUDGE_ELF,      SK_POISON_MAGIC,    1),
    APT(SP_SLUDGE_ELF,      SK_INVOCATIONS,     0),
    APT(SP_SLUDGE_ELF,      SK_EVOCATIONS,      0),

    // SP_MOUNTAIN_DWARF
    APT(SP_MOUNTAIN_DWARF,  SK_FIGHTING,        2),
    APT(SP_MOUNTAIN_DWARF,  SK_SHORT_BLADES,    1),
    APT(SP_MOUNTAIN_DWARF,  SK_LONG_BLADES,     0),
    APT(SP_MOUNTAIN_DWARF,  SK_AXES,            2),
    APT(SP_MOUNTAIN_DWARF,  SK_MACES_FLAILS,    2),
    APT(SP_MOUNTAIN_DWARF,  SK_POLEARMS,       -1),
    APT(SP_MOUNTAIN_DWARF,  SK_STAVES,         -1),
    APT(SP_MOUNTAIN_DWARF,  SK_SLINGS,         -1),
    APT(SP_MOUNTAIN_DWARF,  SK_BOWS,           -2),
    APT(SP_MOUNTAIN_DWARF,  SK_CROSSBOWS,       1),
    APT(SP_MOUNTAIN_DWARF,  SK_THROWING,       -1),
    APT(SP_MOUNTAIN_DWARF,  SK_ARMOUR,          3),
    APT(SP_MOUNTAIN_DWARF,  SK_DODGING,        -1),
    APT(SP_MOUNTAIN_DWARF,  SK_STEALTH,        -3),
    APT(SP_MOUNTAIN_DWARF,  SK_STABBING,       -2),
    APT(SP_MOUNTAIN_DWARF,  SK_SHIELDS,         2),
    APT(SP_MOUNTAIN_DWARF,  SK_TRAPS_DOORS,     1),
    APT(SP_MOUNTAIN_DWARF,  SK_UNARMED_COMBAT,  0),
    APT(SP_MOUNTAIN_DWARF,  SK_SPELLCASTING,   -3),
    APT(SP_MOUNTAIN_DWARF,  SK_CONJURATIONS,   -1),
    APT(SP_MOUNTAIN_DWARF,  SK_HEXES,          -2),
    APT(SP_MOUNTAIN_DWARF,  SK_CHARMS,         -2),
    APT(SP_MOUNTAIN_DWARF,  SK_SUMMONINGS,     -2),
    APT(SP_MOUNTAIN_DWARF,  SK_NECROMANCY,     -3),
    APT(SP_MOUNTAIN_DWARF,  SK_TRANSLOCATIONS, -2),
    APT(SP_MOUNTAIN_DWARF,  SK_TRANSMUTATIONS, -1),
    APT(SP_MOUNTAIN_DWARF,  SK_FIRE_MAGIC,      2),
    APT(SP_MOUNTAIN_DWARF,  SK_ICE_MAGIC,      -2),
    APT(SP_MOUNTAIN_DWARF,  SK_AIR_MAGIC,      -2),
    APT(SP_MOUNTAIN_DWARF,  SK_EARTH_MAGIC,     2),
    APT(SP_MOUNTAIN_DWARF,  SK_POISON_MAGIC,   -2),
    APT(SP_MOUNTAIN_DWARF,  SK_INVOCATIONS,     0),
    APT(SP_MOUNTAIN_DWARF,  SK_EVOCATIONS,      1),

    // SP_HALFLING
    APT(SP_HALFLING,        SK_FIGHTING,       -1),
    APT(SP_HALFLING,        SK_SHORT_BLADES,    3),
    APT(SP_HALFLING,        SK_LONG_BLADES,     0),
    APT(SP_HALFLING,        SK_AXES,           -1),
    APT(SP_HALFLING,        SK_MACES_FLAILS,   -2),
    APT(SP_HALFLING,        SK_POLEARMS,       -3),
    APT(SP_HALFLING,        SK_STAVES,         -2),
    APT(SP_HALFLING,        SK_SLINGS,          4),
    APT(SP_HALFLING,        SK_BOWS,            2),
    APT(SP_HALFLING,        SK_CROSSBOWS,      -1),
    APT(SP_HALFLING,        SK_THROWING,        3),
    APT(SP_HALFLING,        SK_ARMOUR,         -2),
    APT(SP_HALFLING,        SK_DODGING,         2),
    APT(SP_HALFLING,        SK_STEALTH,         3),
    APT(SP_HALFLING,        SK_STABBING,        0),
    APT(SP_HALFLING,        SK_SHIELDS,         1),
    APT(SP_HALFLING,        SK_TRAPS_DOORS,     0),
    APT(SP_HALFLING,        SK_UNARMED_COMBAT, -2),
    APT(SP_HALFLING,        SK_SPELLCASTING,   -2),
    APT(SP_HALFLING,        SK_CONJURATIONS,   -2),
    APT(SP_HALFLING,        SK_HEXES,          -1),
    APT(SP_HALFLING,        SK_CHARMS,          1),
    APT(SP_HALFLING,        SK_SUMMONINGS,     -1),
    APT(SP_HALFLING,        SK_NECROMANCY,     -2),
    APT(SP_HALFLING,        SK_TRANSLOCATIONS,  1),
    APT(SP_HALFLING,        SK_TRANSMUTATIONS, -4),
    APT(SP_HALFLING,        SK_FIRE_MAGIC,      0),
    APT(SP_HALFLING,        SK_ICE_MAGIC,       0),
    APT(SP_HALFLING,        SK_AIR_MAGIC,       1),
    APT(SP_HALFLING,        SK_EARTH_MAGIC,     0),
    APT(SP_HALFLING,        SK_POISON_MAGIC,   -1),
    APT(SP_HALFLING,        SK_INVOCATIONS,     0),
    APT(SP_HALFLING,        SK_EVOCATIONS,      1),

    // SP_HILL_ORC
    APT(SP_HILL_ORC,        SK_FIGHTING,        2),
    APT(SP_HILL_ORC,        SK_SHORT_BLADES,    0),
    APT(SP_HILL_ORC,        SK_LONG_BLADES,     1),
    APT(SP_HILL_ORC,        SK_AXES,            2),
    APT(SP_HILL_ORC,        SK_MACES_FLAILS,    1),
    APT(SP_HILL_ORC,        SK_POLEARMS,        1),
    APT(SP_HILL_ORC,        SK_STAVES,         -1),
    APT(SP_HILL_ORC,        SK_SLINGS,         -1),
    APT(SP_HILL_ORC,        SK_BOWS,           -1),
    APT(SP_HILL_ORC,        SK_CROSSBOWS,      -1),
    APT(SP_HILL_ORC,        SK_THROWING,        0),
    APT(SP_HILL_ORC,        SK_ARMOUR,          1),
    APT(SP_HILL_ORC,        SK_DODGING,        -2),
    APT(SP_HILL_ORC,        SK_STEALTH,        -2),
    APT(SP_HILL_ORC,        SK_STABBING,        2),
    APT(SP_HILL_ORC,        SK_SHIELDS,         1),
    APT(SP_HILL_ORC,        SK_TRAPS_DOORS,     0),
    APT(SP_HILL_ORC,        SK_UNARMED_COMBAT,  1),
    APT(SP_HILL_ORC,        SK_SPELLCASTING,   -3),
    APT(SP_HILL_ORC,        SK_CONJURATIONS,    0),
    APT(SP_HILL_ORC,        SK_HEXES,           0),
    APT(SP_HILL_ORC,        SK_CHARMS,         -1),
    APT(SP_HILL_ORC,        SK_SUMMONINGS,      0),
    APT(SP_HILL_ORC,        SK_NECROMANCY,      0),
    APT(SP_HILL_ORC,        SK_TRANSLOCATIONS, -2),
    APT(SP_HILL_ORC,        SK_TRANSMUTATIONS, -3),
    APT(SP_HILL_ORC,        SK_FIRE_MAGIC,      0),
    APT(SP_HILL_ORC,        SK_ICE_MAGIC,       0),
    APT(SP_HILL_ORC,        SK_AIR_MAGIC,      -2),
    APT(SP_HILL_ORC,        SK_EARTH_MAGIC,     0),
    APT(SP_HILL_ORC,        SK_POISON_MAGIC,   -1),
    APT(SP_HILL_ORC,        SK_INVOCATIONS,     0),
    APT(SP_HILL_ORC,        SK_EVOCATIONS,      0),

    // SP_KOBOLD
    APT(SP_KOBOLD,          SK_FIGHTING,        1),
    APT(SP_KOBOLD,          SK_SHORT_BLADES,    3),
    APT(SP_KOBOLD,          SK_LONG_BLADES,    -2),
    APT(SP_KOBOLD,          SK_AXES,           -1),
    APT(SP_KOBOLD,          SK_MACES_FLAILS,    0),
    APT(SP_KOBOLD,          SK_POLEARMS,       -2),
    APT(SP_KOBOLD,          SK_STAVES,         -1),
    APT(SP_KOBOLD,          SK_SLINGS,          2),
    APT(SP_KOBOLD,          SK_BOWS,           -1),
    APT(SP_KOBOLD,          SK_CROSSBOWS,       2),
    APT(SP_KOBOLD,          SK_THROWING,        3),
    APT(SP_KOBOLD,          SK_ARMOUR,         -2),
    APT(SP_KOBOLD,          SK_DODGING,         2),
    APT(SP_KOBOLD,          SK_STEALTH,         3),
    APT(SP_KOBOLD,          SK_STABBING,        2),
    APT(SP_KOBOLD,          SK_SHIELDS,        -2),
    APT(SP_KOBOLD,          SK_TRAPS_DOORS,     0),
    APT(SP_KOBOLD,          SK_UNARMED_COMBAT,  0),
    APT(SP_KOBOLD,          SK_SPELLCASTING,    0),
    APT(SP_KOBOLD,          SK_CONJURATIONS,   -1),
    APT(SP_KOBOLD,          SK_HEXES,           0),
    APT(SP_KOBOLD,          SK_CHARMS,         -2),
    APT(SP_KOBOLD,          SK_SUMMONINGS,      0),
    APT(SP_KOBOLD,          SK_NECROMANCY,      0),
    APT(SP_KOBOLD,          SK_TRANSLOCATIONS,  0),
    APT(SP_KOBOLD,          SK_TRANSMUTATIONS, -1),
    APT(SP_KOBOLD,          SK_FIRE_MAGIC,      0),
    APT(SP_KOBOLD,          SK_ICE_MAGIC,       0),
    APT(SP_KOBOLD,          SK_AIR_MAGIC,       0),
    APT(SP_KOBOLD,          SK_EARTH_MAGIC,     0),
    APT(SP_KOBOLD,          SK_POISON_MAGIC,    0),
    APT(SP_KOBOLD,          SK_INVOCATIONS,     0),
    APT(SP_KOBOLD,          SK_EVOCATIONS,      2),

    // SP_MUMMY
    APT(SP_MUMMY,           SK_FIGHTING,        0),
    APT(SP_MUMMY,           SK_SHORT_BLADES,   -2),
    APT(SP_MUMMY,           SK_LONG_BLADES,    -2),
    APT(SP_MUMMY,           SK_AXES,           -2),
    APT(SP_MUMMY,           SK_MACES_FLAILS,   -2),
    APT(SP_MUMMY,           SK_POLEARMS,       -2),
    APT(SP_MUMMY,           SK_STAVES,         -2),
    APT(SP_MUMMY,           SK_SLINGS,         -2),
    APT(SP_MUMMY,           SK_BOWS,           -2),
    APT(SP_MUMMY,           SK_CROSSBOWS,      -2),
    APT(SP_MUMMY,           SK_THROWING,       -2),
    APT(SP_MUMMY,           SK_ARMOUR,         -2),
    APT(SP_MUMMY,           SK_DODGING,        -2),
    APT(SP_MUMMY,           SK_STEALTH,        -2),
    APT(SP_MUMMY,           SK_STABBING,       -2),
    APT(SP_MUMMY,           SK_SHIELDS,        -2),
    APT(SP_MUMMY,           SK_TRAPS_DOORS,    -2),
    APT(SP_MUMMY,           SK_UNARMED_COMBAT, -2),
    APT(SP_MUMMY,           SK_SPELLCASTING,    0),
    APT(SP_MUMMY,           SK_CONJURATIONS,   -2),
    APT(SP_MUMMY,           SK_HEXES,          -1),
    APT(SP_MUMMY,           SK_CHARMS,         -2),
    APT(SP_MUMMY,           SK_SUMMONINGS,     -2),
    APT(SP_MUMMY,           SK_NECROMANCY,      0),
    APT(SP_MUMMY,           SK_TRANSLOCATIONS, -2),
    APT(SP_MUMMY,           SK_TRANSMUTATIONS, -2),
    APT(SP_MUMMY,           SK_FIRE_MAGIC,     -2),
    APT(SP_MUMMY,           SK_ICE_MAGIC,      -2),
    APT(SP_MUMMY,           SK_AIR_MAGIC,      -2),
    APT(SP_MUMMY,           SK_EARTH_MAGIC,    -2),
    APT(SP_MUMMY,           SK_POISON_MAGIC,   -2),
    APT(SP_MUMMY,           SK_INVOCATIONS,    -2),
    APT(SP_MUMMY,           SK_EVOCATIONS,     -2),

    // SP_NAGA
    APT(SP_NAGA,            SK_FIGHTING,        0),
    APT(SP_NAGA,            SK_SHORT_BLADES,    0),
    APT(SP_NAGA,            SK_LONG_BLADES,     0),
    APT(SP_NAGA,            SK_AXES,            0),
    APT(SP_NAGA,            SK_MACES_FLAILS,    0),
    APT(SP_NAGA,            SK_POLEARMS,        0),
    APT(SP_NAGA,            SK_STAVES,         -1),
    APT(SP_NAGA,            SK_SLINGS,         -1),
    APT(SP_NAGA,            SK_BOWS,           -1),
    APT(SP_NAGA,            SK_CROSSBOWS,      -1),
    APT(SP_NAGA,            SK_THROWING,       -1),
    APT(SP_NAGA,            SK_ARMOUR,         -2),
    APT(SP_NAGA,            SK_DODGING,        -2),
    APT(SP_NAGA,            SK_STEALTH,         5),
    APT(SP_NAGA,            SK_STABBING,        0),
    APT(SP_NAGA,            SK_SHIELDS,        -2),
    APT(SP_NAGA,            SK_TRAPS_DOORS,     0),
    APT(SP_NAGA,            SK_UNARMED_COMBAT,  0),
    APT(SP_NAGA,            SK_SPELLCASTING,    0),
    APT(SP_NAGA,            SK_CONJURATIONS,    0),
    APT(SP_NAGA,            SK_HEXES,           0),
    APT(SP_NAGA,            SK_CHARMS,          0),
    APT(SP_NAGA,            SK_SUMMONINGS,      0),
    APT(SP_NAGA,            SK_NECROMANCY,      0),
    APT(SP_NAGA,            SK_TRANSLOCATIONS,  0),
    APT(SP_NAGA,            SK_TRANSMUTATIONS,  0),
    APT(SP_NAGA,            SK_FIRE_MAGIC,      0),
    APT(SP_NAGA,            SK_ICE_MAGIC,       0),
    APT(SP_NAGA,            SK_AIR_MAGIC,       0),
    APT(SP_NAGA,            SK_EARTH_MAGIC,     0),
    APT(SP_NAGA,            SK_POISON_MAGIC,    3),
    APT(SP_NAGA,            SK_INVOCATIONS,     0),
    APT(SP_NAGA,            SK_EVOCATIONS,      0),

    // SP_OGRE
    APT(SP_OGRE,            SK_FIGHTING,        3),
    APT(SP_OGRE,            SK_SHORT_BLADES,   -4),
    APT(SP_OGRE,            SK_LONG_BLADES,    -3),
    APT(SP_OGRE,            SK_AXES,           -3),
    APT(SP_OGRE,            SK_MACES_FLAILS,    3),
    APT(SP_OGRE,            SK_POLEARMS,        0),
    APT(SP_OGRE,            SK_STAVES,         -1),
    APT(SP_OGRE,            SK_SLINGS,         -3),
    APT(SP_OGRE,            SK_BOWS,           -3),
    APT(SP_OGRE,            SK_CROSSBOWS,      -3),
    APT(SP_OGRE,            SK_THROWING,        1),
    APT(SP_OGRE,            SK_ARMOUR,         -2),
    APT(SP_OGRE,            SK_DODGING,        -1),
    APT(SP_OGRE,            SK_STEALTH,        -2),
    APT(SP_OGRE,            SK_STABBING,       -2),
    APT(SP_OGRE,            SK_SHIELDS,        -1),
    APT(SP_OGRE,            SK_TRAPS_DOORS,    -2),
    APT(SP_OGRE,            SK_UNARMED_COMBAT, -1),
    APT(SP_OGRE,            SK_SPELLCASTING,    2),
    APT(SP_OGRE,            SK_CONJURATIONS,   -3),
    APT(SP_OGRE,            SK_HEXES,          -3),
    APT(SP_OGRE,            SK_CHARMS,         -3),
    APT(SP_OGRE,            SK_SUMMONINGS,     -3),
    APT(SP_OGRE,            SK_NECROMANCY,     -3),
    APT(SP_OGRE,            SK_TRANSLOCATIONS, -3),
    APT(SP_OGRE,            SK_TRANSMUTATIONS, -3),
    APT(SP_OGRE,            SK_FIRE_MAGIC,     -3),
    APT(SP_OGRE,            SK_ICE_MAGIC,      -3),
    APT(SP_OGRE,            SK_AIR_MAGIC,      -3),
    APT(SP_OGRE,            SK_EARTH_MAGIC,    -3),
    APT(SP_OGRE,            SK_POISON_MAGIC,   -3),
    APT(SP_OGRE,            SK_INVOCATIONS,     0),
    APT(SP_OGRE,            SK_EVOCATIONS,     -2),

    // SP_TROLL
    APT(SP_TROLL,           SK_FIGHTING,       -2),
    APT(SP_TROLL,           SK_SHORT_BLADES,   -2),
    APT(SP_TROLL,           SK_LONG_BLADES,    -2),
    APT(SP_TROLL,           SK_AXES,           -2),
    APT(SP_TROLL,           SK_MACES_FLAILS,   -1),
    APT(SP_TROLL,           SK_POLEARMS,       -2),
    APT(SP_TROLL,           SK_STAVES,         -2),
    APT(SP_TROLL,           SK_SLINGS,         -4),
    APT(SP_TROLL,           SK_BOWS,           -4),
    APT(SP_TROLL,           SK_CROSSBOWS,      -4),
    APT(SP_TROLL,           SK_THROWING,       -1),
    APT(SP_TROLL,           SK_ARMOUR,         -2),
    APT(SP_TROLL,           SK_DODGING,        -2),
    APT(SP_TROLL,           SK_STEALTH,        -5),
    APT(SP_TROLL,           SK_STABBING,       -2),
    APT(SP_TROLL,           SK_SHIELDS,        -2),
    APT(SP_TROLL,           SK_TRAPS_DOORS,    -4),
    APT(SP_TROLL,           SK_UNARMED_COMBAT,  0),
    APT(SP_TROLL,           SK_SPELLCASTING,   -4),
    APT(SP_TROLL,           SK_CONJURATIONS,   -3),
    APT(SP_TROLL,           SK_HEXES,          -4),
    APT(SP_TROLL,           SK_CHARMS,         -4),
    APT(SP_TROLL,           SK_SUMMONINGS,     -3),
    APT(SP_TROLL,           SK_NECROMANCY,     -2),
    APT(SP_TROLL,           SK_TRANSLOCATIONS, -3),
    APT(SP_TROLL,           SK_TRANSMUTATIONS, -3),
    APT(SP_TROLL,           SK_FIRE_MAGIC,     -3),
    APT(SP_TROLL,           SK_ICE_MAGIC,      -3),
    APT(SP_TROLL,           SK_AIR_MAGIC,      -4),
    APT(SP_TROLL,           SK_EARTH_MAGIC,    -1),
    APT(SP_TROLL,           SK_POISON_MAGIC,   -3),
    APT(SP_TROLL,           SK_INVOCATIONS,    -2),
    APT(SP_TROLL,           SK_EVOCATIONS,     -3),

    // SP_RED_DRACONIAN
    APT(SP_RED_DRACONIAN,   SK_FIGHTING,        1),
    APT(SP_RED_DRACONIAN,   SK_SHORT_BLADES,    0),
    APT(SP_RED_DRACONIAN,   SK_LONG_BLADES,     0),
    APT(SP_RED_DRACONIAN,   SK_AXES,            0),
    APT(SP_RED_DRACONIAN,   SK_MACES_FLAILS,    0),
    APT(SP_RED_DRACONIAN,   SK_POLEARMS,        0),
    APT(SP_RED_DRACONIAN,   SK_STAVES,          0),
    APT(SP_RED_DRACONIAN,   SK_SLINGS,         -1),
    APT(SP_RED_DRACONIAN,   SK_BOWS,           -1),
    APT(SP_RED_DRACONIAN,   SK_CROSSBOWS,      -1),
    APT(SP_RED_DRACONIAN,   SK_THROWING,       -1),
    APT(SP_RED_DRACONIAN,   SK_ARMOUR,         -4),
    APT(SP_RED_DRACONIAN,   SK_DODGING,        -1),
    APT(SP_RED_DRACONIAN,   SK_STEALTH,        -1),
    APT(SP_RED_DRACONIAN,   SK_STABBING,        0),
    APT(SP_RED_DRACONIAN,   SK_SHIELDS,         0),
    APT(SP_RED_DRACONIAN,   SK_TRAPS_DOORS,     0),
    APT(SP_RED_DRACONIAN,   SK_UNARMED_COMBAT,  0),
    APT(SP_RED_DRACONIAN,   SK_SPELLCASTING,    0),
    APT(SP_RED_DRACONIAN,   SK_CONJURATIONS,    0),
    APT(SP_RED_DRACONIAN,   SK_HEXES,          -1),
    APT(SP_RED_DRACONIAN,   SK_CHARMS,         -1),
    APT(SP_RED_DRACONIAN,   SK_SUMMONINGS,      0),
    APT(SP_RED_DRACONIAN,   SK_NECROMANCY,      0),
    APT(SP_RED_DRACONIAN,   SK_TRANSLOCATIONS,  0),
    APT(SP_RED_DRACONIAN,   SK_TRANSMUTATIONS,  0),
    APT(SP_RED_DRACONIAN,   SK_FIRE_MAGIC,      2),
    APT(SP_RED_DRACONIAN,   SK_ICE_MAGIC,      -2),
    APT(SP_RED_DRACONIAN,   SK_AIR_MAGIC,       0),
    APT(SP_RED_DRACONIAN,   SK_EARTH_MAGIC,     0),
    APT(SP_RED_DRACONIAN,   SK_POISON_MAGIC,    0),
    APT(SP_RED_DRACONIAN,   SK_INVOCATIONS,     0),
    APT(SP_RED_DRACONIAN,   SK_EVOCATIONS,      0),

    // SP_WHITE_DRACONIAN
    APT(SP_WHITE_DRACONIAN, SK_FIGHTING,        1),
    APT(SP_WHITE_DRACONIAN, SK_SHORT_BLADES,    0),
    APT(SP_WHITE_DRACONIAN, SK_LONG_BLADES,     0),
    APT(SP_WHITE_DRACONIAN, SK_AXES,            0),
    APT(SP_WHITE_DRACONIAN, SK_MACES_FLAILS,    0),
    APT(SP_WHITE_DRACONIAN, SK_POLEARMS,        0),
    APT(SP_WHITE_DRACONIAN, SK_STAVES,          0),
    APT(SP_WHITE_DRACONIAN, SK_SLINGS,         -1),
    APT(SP_WHITE_DRACONIAN, SK_BOWS,           -1),
    APT(SP_WHITE_DRACONIAN, SK_CROSSBOWS,      -1),
    APT(SP_WHITE_DRACONIAN, SK_THROWING,       -1),
    APT(SP_WHITE_DRACONIAN, SK_ARMOUR,         -4),
    APT(SP_WHITE_DRACONIAN, SK_DODGING,        -1),
    APT(SP_WHITE_DRACONIAN, SK_STEALTH,        -1),
    APT(SP_WHITE_DRACONIAN, SK_STABBING,        0),
    APT(SP_WHITE_DRACONIAN, SK_SHIELDS,         0),
    APT(SP_WHITE_DRACONIAN, SK_TRAPS_DOORS,     0),
    APT(SP_WHITE_DRACONIAN, SK_UNARMED_COMBAT,  0),
    APT(SP_WHITE_DRACONIAN, SK_SPELLCASTING,    0),
    APT(SP_WHITE_DRACONIAN, SK_CONJURATIONS,    0),
    APT(SP_WHITE_DRACONIAN, SK_HEXES,          -1),
    APT(SP_WHITE_DRACONIAN, SK_CHARMS,         -1),
    APT(SP_WHITE_DRACONIAN, SK_SUMMONINGS,      0),
    APT(SP_WHITE_DRACONIAN, SK_NECROMANCY,      0),
    APT(SP_WHITE_DRACONIAN, SK_TRANSLOCATIONS,  0),
    APT(SP_WHITE_DRACONIAN, SK_TRANSMUTATIONS,  0),
    APT(SP_WHITE_DRACONIAN, SK_FIRE_MAGIC,     -2),
    APT(SP_WHITE_DRACONIAN, SK_ICE_MAGIC,       2),
    APT(SP_WHITE_DRACONIAN, SK_AIR_MAGIC,       0),
    APT(SP_WHITE_DRACONIAN, SK_EARTH_MAGIC,     0),
    APT(SP_WHITE_DRACONIAN, SK_POISON_MAGIC,    0),
    APT(SP_WHITE_DRACONIAN, SK_INVOCATIONS,     0),
    APT(SP_WHITE_DRACONIAN, SK_EVOCATIONS,      0),

    // SP_GREEN_DRACONIAN
    APT(SP_GREEN_DRACONIAN, SK_FIGHTING,        1),
    APT(SP_GREEN_DRACONIAN, SK_SHORT_BLADES,    0),
    APT(SP_GREEN_DRACONIAN, SK_LONG_BLADES,     0),
    APT(SP_GREEN_DRACONIAN, SK_AXES,            0),
    APT(SP_GREEN_DRACONIAN, SK_MACES_FLAILS,    0),
    APT(SP_GREEN_DRACONIAN, SK_POLEARMS,        0),
    APT(SP_GREEN_DRACONIAN, SK_STAVES,          0),
    APT(SP_GREEN_DRACONIAN, SK_SLINGS,         -1),
    APT(SP_GREEN_DRACONIAN, SK_BOWS,           -1),
    APT(SP_GREEN_DRACONIAN, SK_CROSSBOWS,      -1),
    APT(SP_GREEN_DRACONIAN, SK_THROWING,       -1),
    APT(SP_GREEN_DRACONIAN, SK_ARMOUR,         -4),
    APT(SP_GREEN_DRACONIAN, SK_DODGING,        -1),
    APT(SP_GREEN_DRACONIAN, SK_STEALTH,        -1),
    APT(SP_GREEN_DRACONIAN, SK_STABBING,        0),
    APT(SP_GREEN_DRACONIAN, SK_SHIELDS,         0),
    APT(SP_GREEN_DRACONIAN, SK_TRAPS_DOORS,     0),
    APT(SP_GREEN_DRACONIAN, SK_UNARMED_COMBAT,  0),
    APT(SP_GREEN_DRACONIAN, SK_SPELLCASTING,    0),
    APT(SP_GREEN_DRACONIAN, SK_CONJURATIONS,    0),
    APT(SP_GREEN_DRACONIAN, SK_HEXES,          -1),
    APT(SP_GREEN_DRACONIAN, SK_CHARMS,         -1),
    APT(SP_GREEN_DRACONIAN, SK_SUMMONINGS,      0),
    APT(SP_GREEN_DRACONIAN, SK_NECROMANCY,      0),
    APT(SP_GREEN_DRACONIAN, SK_TRANSLOCATIONS,  0),
    APT(SP_GREEN_DRACONIAN, SK_TRANSMUTATIONS,  0),
    APT(SP_GREEN_DRACONIAN, SK_FIRE_MAGIC,      0),
    APT(SP_GREEN_DRACONIAN, SK_ICE_MAGIC,       0),
    APT(SP_GREEN_DRACONIAN, SK_AIR_MAGIC,       0),
    APT(SP_GREEN_DRACONIAN, SK_EARTH_MAGIC,     0),
    APT(SP_GREEN_DRACONIAN, SK_POISON_MAGIC,    2),
    APT(SP_GREEN_DRACONIAN, SK_INVOCATIONS,     0),
    APT(SP_GREEN_DRACONIAN, SK_EVOCATIONS,      0),

    // SP_YELLOW_DRACONIAN
    APT(SP_YELLOW_DRACONIAN,SK_FIGHTING,        1),
    APT(SP_YELLOW_DRACONIAN,SK_SHORT_BLADES,    0),
    APT(SP_YELLOW_DRACONIAN,SK_LONG_BLADES,     0),
    APT(SP_YELLOW_DRACONIAN,SK_AXES,            0),
    APT(SP_YELLOW_DRACONIAN,SK_MACES_FLAILS,    0),
    APT(SP_YELLOW_DRACONIAN,SK_POLEARMS,        0),
    APT(SP_YELLOW_DRACONIAN,SK_STAVES,          0),
    APT(SP_YELLOW_DRACONIAN,SK_SLINGS,         -1),
    APT(SP_YELLOW_DRACONIAN,SK_BOWS,           -1),
    APT(SP_YELLOW_DRACONIAN,SK_CROSSBOWS,      -1),
    APT(SP_YELLOW_DRACONIAN,SK_THROWING,       -1),
    APT(SP_YELLOW_DRACONIAN,SK_ARMOUR,         -4),
    APT(SP_YELLOW_DRACONIAN,SK_DODGING,        -1),
    APT(SP_YELLOW_DRACONIAN,SK_STEALTH,        -1),
    APT(SP_YELLOW_DRACONIAN,SK_STABBING,        0),
    APT(SP_YELLOW_DRACONIAN,SK_SHIELDS,         0),
    APT(SP_YELLOW_DRACONIAN,SK_TRAPS_DOORS,     0),
    APT(SP_YELLOW_DRACONIAN,SK_UNARMED_COMBAT,  0),
    APT(SP_YELLOW_DRACONIAN,SK_SPELLCASTING,    0),
    APT(SP_YELLOW_DRACONIAN,SK_CONJURATIONS,    0),
    APT(SP_YELLOW_DRACONIAN,SK_HEXES,          -1),
    APT(SP_YELLOW_DRACONIAN,SK_CHARMS,         -1),
    APT(SP_YELLOW_DRACONIAN,SK_SUMMONINGS,      0),
    APT(SP_YELLOW_DRACONIAN,SK_NECROMANCY,      0),
    APT(SP_YELLOW_DRACONIAN,SK_TRANSLOCATIONS,  0),
    APT(SP_YELLOW_DRACONIAN,SK_TRANSMUTATIONS,  0),
    APT(SP_YELLOW_DRACONIAN,SK_FIRE_MAGIC,      0),
    APT(SP_YELLOW_DRACONIAN,SK_ICE_MAGIC,       0),
    APT(SP_YELLOW_DRACONIAN,SK_AIR_MAGIC,       0),
    APT(SP_YELLOW_DRACONIAN,SK_EARTH_MAGIC,     0),
    APT(SP_YELLOW_DRACONIAN,SK_POISON_MAGIC,    0),
    APT(SP_YELLOW_DRACONIAN,SK_INVOCATIONS,     0),
    APT(SP_YELLOW_DRACONIAN,SK_EVOCATIONS,      0),

    // SP_GREY_DRACONIAN
    APT(SP_GREY_DRACONIAN,  SK_FIGHTING,        1),
    APT(SP_GREY_DRACONIAN,  SK_SHORT_BLADES,    0),
    APT(SP_GREY_DRACONIAN,  SK_LONG_BLADES,     0),
    APT(SP_GREY_DRACONIAN,  SK_AXES,            0),
    APT(SP_GREY_DRACONIAN,  SK_MACES_FLAILS,    0),
    APT(SP_GREY_DRACONIAN,  SK_POLEARMS,        0),
    APT(SP_GREY_DRACONIAN,  SK_STAVES,          0),
    APT(SP_GREY_DRACONIAN,  SK_SLINGS,         -1),
    APT(SP_GREY_DRACONIAN,  SK_BOWS,           -1),
    APT(SP_GREY_DRACONIAN,  SK_CROSSBOWS,      -1),
    APT(SP_GREY_DRACONIAN,  SK_THROWING,        0),
    APT(SP_GREY_DRACONIAN,  SK_ARMOUR,         -4),
    APT(SP_GREY_DRACONIAN,  SK_DODGING,        -1),
    APT(SP_GREY_DRACONIAN,  SK_STEALTH,         2),
    APT(SP_GREY_DRACONIAN,  SK_STABBING,        2),
    APT(SP_GREY_DRACONIAN,  SK_SHIELDS,         0),
    APT(SP_GREY_DRACONIAN,  SK_TRAPS_DOORS,     0),
    APT(SP_GREY_DRACONIAN,  SK_UNARMED_COMBAT,  0),
    APT(SP_GREY_DRACONIAN,  SK_SPELLCASTING,    0),
    APT(SP_GREY_DRACONIAN,  SK_CONJURATIONS,    0),
    APT(SP_GREY_DRACONIAN,  SK_HEXES,          -1),
    APT(SP_GREY_DRACONIAN,  SK_CHARMS,         -1),
    APT(SP_GREY_DRACONIAN,  SK_SUMMONINGS,      0),
    APT(SP_GREY_DRACONIAN,  SK_NECROMANCY,      0),
    APT(SP_GREY_DRACONIAN,  SK_TRANSLOCATIONS,  0),
    APT(SP_GREY_DRACONIAN,  SK_TRANSMUTATIONS,  0),
    APT(SP_GREY_DRACONIAN,  SK_FIRE_MAGIC,      0),
    APT(SP_GREY_DRACONIAN,  SK_ICE_MAGIC,       0),
    APT(SP_GREY_DRACONIAN,  SK_AIR_MAGIC,       0),
    APT(SP_GREY_DRACONIAN,  SK_EARTH_MAGIC,     0),
    APT(SP_GREY_DRACONIAN,  SK_POISON_MAGIC,    0),
    APT(SP_GREY_DRACONIAN,  SK_INVOCATIONS,     0),
    APT(SP_GREY_DRACONIAN,  SK_EVOCATIONS,      0),

    // SP_BLACK_DRACONIAN
    APT(SP_BLACK_DRACONIAN, SK_FIGHTING,        1),
    APT(SP_BLACK_DRACONIAN, SK_SHORT_BLADES,    0),
    APT(SP_BLACK_DRACONIAN, SK_LONG_BLADES,     0),
    APT(SP_BLACK_DRACONIAN, SK_AXES,            0),
    APT(SP_BLACK_DRACONIAN, SK_MACES_FLAILS,    0),
    APT(SP_BLACK_DRACONIAN, SK_POLEARMS,        0),
    APT(SP_BLACK_DRACONIAN, SK_STAVES,          0),
    APT(SP_BLACK_DRACONIAN, SK_SLINGS,         -1),
    APT(SP_BLACK_DRACONIAN, SK_BOWS,           -1),
    APT(SP_BLACK_DRACONIAN, SK_CROSSBOWS,      -1),
    APT(SP_BLACK_DRACONIAN, SK_THROWING,       -1),
    APT(SP_BLACK_DRACONIAN, SK_ARMOUR,         -4),
    APT(SP_BLACK_DRACONIAN, SK_DODGING,        -1),
    APT(SP_BLACK_DRACONIAN, SK_STEALTH,        -1),
    APT(SP_BLACK_DRACONIAN, SK_STABBING,        0),
    APT(SP_BLACK_DRACONIAN, SK_SHIELDS,         0),
    APT(SP_BLACK_DRACONIAN, SK_TRAPS_DOORS,     0),
    APT(SP_BLACK_DRACONIAN, SK_UNARMED_COMBAT,  0),
    APT(SP_BLACK_DRACONIAN, SK_SPELLCASTING,    0),
    APT(SP_BLACK_DRACONIAN, SK_CONJURATIONS,    0),
    APT(SP_BLACK_DRACONIAN, SK_HEXES,          -1),
    APT(SP_BLACK_DRACONIAN, SK_CHARMS,         -1),
    APT(SP_BLACK_DRACONIAN, SK_SUMMONINGS,      0),
    APT(SP_BLACK_DRACONIAN, SK_NECROMANCY,      0),
    APT(SP_BLACK_DRACONIAN, SK_TRANSLOCATIONS,  0),
    APT(SP_BLACK_DRACONIAN, SK_TRANSMUTATIONS,  0),
    APT(SP_BLACK_DRACONIAN, SK_FIRE_MAGIC,      0),
    APT(SP_BLACK_DRACONIAN, SK_ICE_MAGIC,       0),
    APT(SP_BLACK_DRACONIAN, SK_AIR_MAGIC,       2),
    APT(SP_BLACK_DRACONIAN, SK_EARTH_MAGIC,    -2),
    APT(SP_BLACK_DRACONIAN, SK_POISON_MAGIC,    0),
    APT(SP_BLACK_DRACONIAN, SK_INVOCATIONS,     0),
    APT(SP_BLACK_DRACONIAN, SK_EVOCATIONS,      0),

    // SP_PURPLE_DRACONIAN
    APT(SP_PURPLE_DRACONIAN,SK_FIGHTING,        1),
    APT(SP_PURPLE_DRACONIAN,SK_SHORT_BLADES,    0),
    APT(SP_PURPLE_DRACONIAN,SK_LONG_BLADES,     0),
    APT(SP_PURPLE_DRACONIAN,SK_AXES,            0),
    APT(SP_PURPLE_DRACONIAN,SK_MACES_FLAILS,    0),
    APT(SP_PURPLE_DRACONIAN,SK_POLEARMS,        0),
    APT(SP_PURPLE_DRACONIAN,SK_STAVES,          0),
    APT(SP_PURPLE_DRACONIAN,SK_SLINGS,         -1),
    APT(SP_PURPLE_DRACONIAN,SK_BOWS,           -1),
    APT(SP_PURPLE_DRACONIAN,SK_CROSSBOWS,      -1),
    APT(SP_PURPLE_DRACONIAN,SK_THROWING,       -1),
    APT(SP_PURPLE_DRACONIAN,SK_ARMOUR,         -4),
    APT(SP_PURPLE_DRACONIAN,SK_DODGING,        -1),
    APT(SP_PURPLE_DRACONIAN,SK_STEALTH,        -1),
    APT(SP_PURPLE_DRACONIAN,SK_STABBING,        0),
    APT(SP_PURPLE_DRACONIAN,SK_SHIELDS,         0),
    APT(SP_PURPLE_DRACONIAN,SK_TRAPS_DOORS,     0),
    APT(SP_PURPLE_DRACONIAN,SK_UNARMED_COMBAT,  0),
    APT(SP_PURPLE_DRACONIAN,SK_SPELLCASTING,    2),
    APT(SP_PURPLE_DRACONIAN,SK_CONJURATIONS,    0),
    APT(SP_PURPLE_DRACONIAN,SK_HEXES,           1),
    APT(SP_PURPLE_DRACONIAN,SK_CHARMS,          1),
    APT(SP_PURPLE_DRACONIAN,SK_SUMMONINGS,      0),
    APT(SP_PURPLE_DRACONIAN,SK_NECROMANCY,      0),
    APT(SP_PURPLE_DRACONIAN,SK_TRANSLOCATIONS,  0),
    APT(SP_PURPLE_DRACONIAN,SK_TRANSMUTATIONS,  0),
    APT(SP_PURPLE_DRACONIAN,SK_FIRE_MAGIC,      0),
    APT(SP_PURPLE_DRACONIAN,SK_ICE_MAGIC,       0),
    APT(SP_PURPLE_DRACONIAN,SK_AIR_MAGIC,       0),
    APT(SP_PURPLE_DRACONIAN,SK_EARTH_MAGIC,     0),
    APT(SP_PURPLE_DRACONIAN,SK_POISON_MAGIC,    0),
    APT(SP_PURPLE_DRACONIAN,SK_INVOCATIONS,     0),
    APT(SP_PURPLE_DRACONIAN,SK_EVOCATIONS,      1),

    // SP_MOTTLED_DRACONIAN
    APT(SP_MOTTLED_DRACONIAN,SK_FIGHTING,        1),
    APT(SP_MOTTLED_DRACONIAN,SK_SHORT_BLADES,    0),
    APT(SP_MOTTLED_DRACONIAN,SK_LONG_BLADES,     0),
    APT(SP_MOTTLED_DRACONIAN,SK_AXES,            0),
    APT(SP_MOTTLED_DRACONIAN,SK_MACES_FLAILS,    0),
    APT(SP_MOTTLED_DRACONIAN,SK_POLEARMS,        0),
    APT(SP_MOTTLED_DRACONIAN,SK_STAVES,          0),
    APT(SP_MOTTLED_DRACONIAN,SK_SLINGS,         -1),
    APT(SP_MOTTLED_DRACONIAN,SK_BOWS,           -1),
    APT(SP_MOTTLED_DRACONIAN,SK_CROSSBOWS,      -1),
    APT(SP_MOTTLED_DRACONIAN,SK_THROWING,       -1),
    APT(SP_MOTTLED_DRACONIAN,SK_ARMOUR,         -4),
    APT(SP_MOTTLED_DRACONIAN,SK_DODGING,        -1),
    APT(SP_MOTTLED_DRACONIAN,SK_STEALTH,        -1),
    APT(SP_MOTTLED_DRACONIAN,SK_STABBING,        0),
    APT(SP_MOTTLED_DRACONIAN,SK_SHIELDS,         0),
    APT(SP_MOTTLED_DRACONIAN,SK_TRAPS_DOORS,     0),
    APT(SP_MOTTLED_DRACONIAN,SK_UNARMED_COMBAT,  0),
    APT(SP_MOTTLED_DRACONIAN,SK_SPELLCASTING,    0),
    APT(SP_MOTTLED_DRACONIAN,SK_CONJURATIONS,    0),
    APT(SP_MOTTLED_DRACONIAN,SK_HEXES,          -1),
    APT(SP_MOTTLED_DRACONIAN,SK_CHARMS,         -1),
    APT(SP_MOTTLED_DRACONIAN,SK_SUMMONINGS,      0),
    APT(SP_MOTTLED_DRACONIAN,SK_NECROMANCY,      0),
    APT(SP_MOTTLED_DRACONIAN,SK_TRANSLOCATIONS,  0),
    APT(SP_MOTTLED_DRACONIAN,SK_TRANSMUTATIONS,  0),
    APT(SP_MOTTLED_DRACONIAN,SK_FIRE_MAGIC,      1),
    APT(SP_MOTTLED_DRACONIAN,SK_ICE_MAGIC,       0),
    APT(SP_MOTTLED_DRACONIAN,SK_AIR_MAGIC,       0),
    APT(SP_MOTTLED_DRACONIAN,SK_EARTH_MAGIC,     0),
    APT(SP_MOTTLED_DRACONIAN,SK_POISON_MAGIC,    0),
    APT(SP_MOTTLED_DRACONIAN,SK_INVOCATIONS,     0),
    APT(SP_MOTTLED_DRACONIAN,SK_EVOCATIONS,      0),

    // SP_PALE_DRACONIAN
    APT(SP_PALE_DRACONIAN,  SK_FIGHTING,        1),
    APT(SP_PALE_DRACONIAN,  SK_SHORT_BLADES,    0),
    APT(SP_PALE_DRACONIAN,  SK_LONG_BLADES,     0),
    APT(SP_PALE_DRACONIAN,  SK_AXES,            0),
    APT(SP_PALE_DRACONIAN,  SK_MACES_FLAILS,    0),
    APT(SP_PALE_DRACONIAN,  SK_POLEARMS,        0),
    APT(SP_PALE_DRACONIAN,  SK_STAVES,          0),
    APT(SP_PALE_DRACONIAN,  SK_SLINGS,         -1),
    APT(SP_PALE_DRACONIAN,  SK_BOWS,           -1),
    APT(SP_PALE_DRACONIAN,  SK_CROSSBOWS,      -1),
    APT(SP_PALE_DRACONIAN,  SK_THROWING,       -1),
    APT(SP_PALE_DRACONIAN,  SK_ARMOUR,         -4),
    APT(SP_PALE_DRACONIAN,  SK_DODGING,        -1),
    APT(SP_PALE_DRACONIAN,  SK_STEALTH,        -1),
    APT(SP_PALE_DRACONIAN,  SK_STABBING,        0),
    APT(SP_PALE_DRACONIAN,  SK_SHIELDS,         0),
    APT(SP_PALE_DRACONIAN,  SK_TRAPS_DOORS,     0),
    APT(SP_PALE_DRACONIAN,  SK_UNARMED_COMBAT,  0),
    APT(SP_PALE_DRACONIAN,  SK_SPELLCASTING,    0),
    APT(SP_PALE_DRACONIAN,  SK_CONJURATIONS,    0),
    APT(SP_PALE_DRACONIAN,  SK_HEXES,          -1),
    APT(SP_PALE_DRACONIAN,  SK_CHARMS,         -1),
    APT(SP_PALE_DRACONIAN,  SK_SUMMONINGS,      0),
    APT(SP_PALE_DRACONIAN,  SK_NECROMANCY,      0),
    APT(SP_PALE_DRACONIAN,  SK_TRANSLOCATIONS,  0),
    APT(SP_PALE_DRACONIAN,  SK_TRANSMUTATIONS,  0),
    APT(SP_PALE_DRACONIAN,  SK_FIRE_MAGIC,      1),
    APT(SP_PALE_DRACONIAN,  SK_ICE_MAGIC,       0),
    APT(SP_PALE_DRACONIAN,  SK_AIR_MAGIC,       1),
    APT(SP_PALE_DRACONIAN,  SK_EARTH_MAGIC,     0),
    APT(SP_PALE_DRACONIAN,  SK_POISON_MAGIC,    0),
    APT(SP_PALE_DRACONIAN,  SK_INVOCATIONS,     0),
    APT(SP_PALE_DRACONIAN,  SK_EVOCATIONS,      1),

    // SP_BASE_DRACONIAN
    APT(SP_BASE_DRACONIAN,  SK_FIGHTING,        1),
    APT(SP_BASE_DRACONIAN,  SK_SHORT_BLADES,    0),
    APT(SP_BASE_DRACONIAN,  SK_LONG_BLADES,     0),
    APT(SP_BASE_DRACONIAN,  SK_AXES,            0),
    APT(SP_BASE_DRACONIAN,  SK_MACES_FLAILS,    0),
    APT(SP_BASE_DRACONIAN,  SK_POLEARMS,        0),
    APT(SP_BASE_DRACONIAN,  SK_STAVES,          0),
    APT(SP_BASE_DRACONIAN,  SK_SLINGS,         -1),
    APT(SP_BASE_DRACONIAN,  SK_BOWS,           -1),
    APT(SP_BASE_DRACONIAN,  SK_CROSSBOWS,      -1),
    APT(SP_BASE_DRACONIAN,  SK_THROWING,       -1),
    APT(SP_BASE_DRACONIAN,  SK_ARMOUR,         -4),
    APT(SP_BASE_DRACONIAN,  SK_DODGING,        -1),
    APT(SP_BASE_DRACONIAN,  SK_STEALTH,        -1),
    APT(SP_BASE_DRACONIAN,  SK_STABBING,        0),
    APT(SP_BASE_DRACONIAN,  SK_SHIELDS,         0),
    APT(SP_BASE_DRACONIAN,  SK_TRAPS_DOORS,     0),
    APT(SP_BASE_DRACONIAN,  SK_UNARMED_COMBAT,  0),
    APT(SP_BASE_DRACONIAN,  SK_SPELLCASTING,    0),
    APT(SP_BASE_DRACONIAN,  SK_CONJURATIONS,    0),
    APT(SP_BASE_DRACONIAN,  SK_HEXES,          -1),
    APT(SP_BASE_DRACONIAN,  SK_CHARMS,         -1),
    APT(SP_BASE_DRACONIAN,  SK_SUMMONINGS,      0),
    APT(SP_BASE_DRACONIAN,  SK_NECROMANCY,      0),
    APT(SP_BASE_DRACONIAN,  SK_TRANSLOCATIONS,  0),
    APT(SP_BASE_DRACONIAN,  SK_TRANSMUTATIONS,  0),
    APT(SP_BASE_DRACONIAN,  SK_FIRE_MAGIC,      0),
    APT(SP_BASE_DRACONIAN,  SK_ICE_MAGIC,       0),
    APT(SP_BASE_DRACONIAN,  SK_AIR_MAGIC,       0),
    APT(SP_BASE_DRACONIAN,  SK_EARTH_MAGIC,     0),
    APT(SP_BASE_DRACONIAN,  SK_POISON_MAGIC,    0),
    APT(SP_BASE_DRACONIAN,  SK_INVOCATIONS,     0),
    APT(SP_BASE_DRACONIAN,  SK_EVOCATIONS,      0),

    // SP_CENTAUR
    APT(SP_CENTAUR,         SK_FIGHTING,        0),
    APT(SP_CENTAUR,         SK_SHORT_BLADES,   -1),
    APT(SP_CENTAUR,         SK_LONG_BLADES,    -1),
    APT(SP_CENTAUR,         SK_AXES,           -1),
    APT(SP_CENTAUR,         SK_MACES_FLAILS,   -1),
    APT(SP_CENTAUR,         SK_POLEARMS,       -1),
    APT(SP_CENTAUR,         SK_STAVES,         -1),
    APT(SP_CENTAUR,         SK_SLINGS,          1),
    APT(SP_CENTAUR,         SK_BOWS,            3),
    APT(SP_CENTAUR,         SK_CROSSBOWS,       1),
    APT(SP_CENTAUR,         SK_THROWING,        3),
    APT(SP_CENTAUR,         SK_ARMOUR,         -3),
    APT(SP_CENTAUR,         SK_DODGING,        -3),
    APT(SP_CENTAUR,         SK_STEALTH,        -4),
    APT(SP_CENTAUR,         SK_STABBING,       -3),
    APT(SP_CENTAUR,         SK_SHIELDS,        -3),
    APT(SP_CENTAUR,         SK_TRAPS_DOORS,    -2),
    APT(SP_CENTAUR,         SK_UNARMED_COMBAT,  0),
    APT(SP_CENTAUR,         SK_SPELLCASTING,   -2),
    APT(SP_CENTAUR,         SK_CONJURATIONS,   -1),
    APT(SP_CENTAUR,         SK_HEXES,          -1),
    APT(SP_CENTAUR,         SK_CHARMS,         -1),
    APT(SP_CENTAUR,         SK_SUMMONINGS,     -1),
    APT(SP_CENTAUR,         SK_NECROMANCY,     -1),
    APT(SP_CENTAUR,         SK_TRANSLOCATIONS, -1),
    APT(SP_CENTAUR,         SK_TRANSMUTATIONS, -1),
    APT(SP_CENTAUR,         SK_FIRE_MAGIC,     -1),
    APT(SP_CENTAUR,         SK_ICE_MAGIC,      -1),
    APT(SP_CENTAUR,         SK_AIR_MAGIC,      -1),
    APT(SP_CENTAUR,         SK_EARTH_MAGIC,    -1),
    APT(SP_CENTAUR,         SK_POISON_MAGIC,   -2),
    APT(SP_CENTAUR,         SK_INVOCATIONS,     0),
    APT(SP_CENTAUR,         SK_EVOCATIONS,     -1),

    // SP_DEMIGOD
    APT(SP_DEMIGOD,         SK_FIGHTING,       -1),
    APT(SP_DEMIGOD,         SK_SHORT_BLADES,   -1),
    APT(SP_DEMIGOD,         SK_LONG_BLADES,    -1),
    APT(SP_DEMIGOD,         SK_AXES,           -1),
    APT(SP_DEMIGOD,         SK_MACES_FLAILS,   -1),
    APT(SP_DEMIGOD,         SK_POLEARMS,       -1),
    APT(SP_DEMIGOD,         SK_STAVES,         -1),
    APT(SP_DEMIGOD,         SK_SLINGS,         -1),
    APT(SP_DEMIGOD,         SK_BOWS,           -1),
    APT(SP_DEMIGOD,         SK_CROSSBOWS,      -1),
    APT(SP_DEMIGOD,         SK_THROWING,       -1),
    APT(SP_DEMIGOD,         SK_ARMOUR,         -1),
    APT(SP_DEMIGOD,         SK_DODGING,        -1),
    APT(SP_DEMIGOD,         SK_STEALTH,        -1),
    APT(SP_DEMIGOD,         SK_STABBING,       -1),
    APT(SP_DEMIGOD,         SK_SHIELDS,        -1),
    APT(SP_DEMIGOD,         SK_TRAPS_DOORS,    -1),
    APT(SP_DEMIGOD,         SK_UNARMED_COMBAT, -1),
    APT(SP_DEMIGOD,         SK_SPELLCASTING,   -1),
    APT(SP_DEMIGOD,         SK_CONJURATIONS,   -1),
    APT(SP_DEMIGOD,         SK_HEXES,          -1),
    APT(SP_DEMIGOD,         SK_CHARMS,         -1),
    APT(SP_DEMIGOD,         SK_SUMMONINGS,     -1),
    APT(SP_DEMIGOD,         SK_NECROMANCY,     -1),
    APT(SP_DEMIGOD,         SK_TRANSLOCATIONS, -1),
    APT(SP_DEMIGOD,         SK_TRANSMUTATIONS, -1),
    APT(SP_DEMIGOD,         SK_FIRE_MAGIC,     -1),
    APT(SP_DEMIGOD,         SK_ICE_MAGIC,      -1),
    APT(SP_DEMIGOD,         SK_AIR_MAGIC,      -1),
    APT(SP_DEMIGOD,         SK_EARTH_MAGIC,    -1),
    APT(SP_DEMIGOD,         SK_POISON_MAGIC,   -1),
    APT(SP_DEMIGOD,         SK_INVOCATIONS,     0),
    APT(SP_DEMIGOD,         SK_EVOCATIONS,     -1),

    // SP_SPRIGGAN
    APT(SP_SPRIGGAN,        SK_FIGHTING,       -2),
    APT(SP_SPRIGGAN,        SK_SHORT_BLADES,    1),
    APT(SP_SPRIGGAN,        SK_LONG_BLADES,    -2),
    APT(SP_SPRIGGAN,        SK_AXES,           -2),
    APT(SP_SPRIGGAN,        SK_MACES_FLAILS,   -3),
    APT(SP_SPRIGGAN,        SK_POLEARMS,       -3),
    APT(SP_SPRIGGAN,        SK_STAVES,         -3),
    APT(SP_SPRIGGAN,        SK_SLINGS,          2),
    APT(SP_SPRIGGAN,        SK_BOWS,            2),
    APT(SP_SPRIGGAN,        SK_CROSSBOWS,       0),
    APT(SP_SPRIGGAN,        SK_THROWING,        1),
    APT(SP_SPRIGGAN,        SK_ARMOUR,         -3),
    APT(SP_SPRIGGAN,        SK_DODGING,         4),
    APT(SP_SPRIGGAN,        SK_STEALTH,         4),
    APT(SP_SPRIGGAN,        SK_STABBING,        4),
    APT(SP_SPRIGGAN,        SK_SHIELDS,        -3),
    APT(SP_SPRIGGAN,        SK_TRAPS_DOORS,     3),
    APT(SP_SPRIGGAN,        SK_UNARMED_COMBAT, -2),
    APT(SP_SPRIGGAN,        SK_SPELLCASTING,    3),
    APT(SP_SPRIGGAN,        SK_CONJURATIONS,   -3),
    APT(SP_SPRIGGAN,        SK_HEXES,           2),
    APT(SP_SPRIGGAN,        SK_CHARMS,          4),
    APT(SP_SPRIGGAN,        SK_SUMMONINGS,     -2),
    APT(SP_SPRIGGAN,        SK_NECROMANCY,     -1),
    APT(SP_SPRIGGAN,        SK_TRANSLOCATIONS,  4),
    APT(SP_SPRIGGAN,        SK_TRANSMUTATIONS,  3),
    APT(SP_SPRIGGAN,        SK_FIRE_MAGIC,     -2),
    APT(SP_SPRIGGAN,        SK_ICE_MAGIC,      -2),
    APT(SP_SPRIGGAN,        SK_AIR_MAGIC,      -1),
    APT(SP_SPRIGGAN,        SK_EARTH_MAGIC,    -1),
    APT(SP_SPRIGGAN,        SK_POISON_MAGIC,    0),
    APT(SP_SPRIGGAN,        SK_INVOCATIONS,    -1),
    APT(SP_SPRIGGAN,        SK_EVOCATIONS,      3),

    // SP_MINOTAUR
    APT(SP_MINOTAUR,        SK_FIGHTING,        2),
    APT(SP_MINOTAUR,        SK_SHORT_BLADES,    2),
    APT(SP_MINOTAUR,        SK_LONG_BLADES,     2),
    APT(SP_MINOTAUR,        SK_AXES,            2),
    APT(SP_MINOTAUR,        SK_MACES_FLAILS,    2),
    APT(SP_MINOTAUR,        SK_POLEARMS,        2),
    APT(SP_MINOTAUR,        SK_STAVES,          2),
    APT(SP_MINOTAUR,        SK_SLINGS,          1),
    APT(SP_MINOTAUR,        SK_BOWS,            1),
    APT(SP_MINOTAUR,        SK_CROSSBOWS,       1),
    APT(SP_MINOTAUR,        SK_THROWING,        1),
    APT(SP_MINOTAUR,        SK_ARMOUR,          1),
    APT(SP_MINOTAUR,        SK_DODGING,         1),
    APT(SP_MINOTAUR,        SK_STEALTH,        -2),
    APT(SP_MINOTAUR,        SK_STABBING,        0),
    APT(SP_MINOTAUR,        SK_SHIELDS,         1),
    APT(SP_MINOTAUR,        SK_TRAPS_DOORS,    -1),
    APT(SP_MINOTAUR,        SK_UNARMED_COMBAT,  1),
    APT(SP_MINOTAUR,        SK_SPELLCASTING,   -3),
    APT(SP_MINOTAUR,        SK_CONJURATIONS,   -3),
    APT(SP_MINOTAUR,        SK_HEXES,          -3),
    APT(SP_MINOTAUR,        SK_CHARMS,         -3),
    APT(SP_MINOTAUR,        SK_SUMMONINGS,     -3),
    APT(SP_MINOTAUR,        SK_NECROMANCY,     -3),
    APT(SP_MINOTAUR,        SK_TRANSLOCATIONS, -3),
    APT(SP_MINOTAUR,        SK_TRANSMUTATIONS, -3),
    APT(SP_MINOTAUR,        SK_FIRE_MAGIC,     -3),
    APT(SP_MINOTAUR,        SK_ICE_MAGIC,      -3),
    APT(SP_MINOTAUR,        SK_AIR_MAGIC,      -3),
    APT(SP_MINOTAUR,        SK_EARTH_MAGIC,    -3),
    APT(SP_MINOTAUR,        SK_POISON_MAGIC,   -3),
    APT(SP_MINOTAUR,        SK_INVOCATIONS,    -1),
    APT(SP_MINOTAUR,        SK_EVOCATIONS,     -3),

    // SP_DEMONSPAWN
    APT(SP_DEMONSPAWN,      SK_FIGHTING,        0),
    APT(SP_DEMONSPAWN,      SK_SHORT_BLADES,   -1),
    APT(SP_DEMONSPAWN,      SK_LONG_BLADES,    -1),
    APT(SP_DEMONSPAWN,      SK_AXES,           -1),
    APT(SP_DEMONSPAWN,      SK_MACES_FLAILS,   -1),
    APT(SP_DEMONSPAWN,      SK_POLEARMS,       -1),
    APT(SP_DEMONSPAWN,      SK_STAVES,         -1),
    APT(SP_DEMONSPAWN,      SK_SLINGS,         -1),
    APT(SP_DEMONSPAWN,      SK_BOWS,           -1),
    APT(SP_DEMONSPAWN,      SK_CROSSBOWS,      -1),
    APT(SP_DEMONSPAWN,      SK_THROWING,       -1),
    APT(SP_DEMONSPAWN,      SK_ARMOUR,         -1),
    APT(SP_DEMONSPAWN,      SK_DODGING,        -1),
    APT(SP_DEMONSPAWN,      SK_STEALTH,        -1),
    APT(SP_DEMONSPAWN,      SK_STABBING,       -1),
    APT(SP_DEMONSPAWN,      SK_SHIELDS,        -1),
    APT(SP_DEMONSPAWN,      SK_TRAPS_DOORS,    -1),
    APT(SP_DEMONSPAWN,      SK_UNARMED_COMBAT, -1),
    APT(SP_DEMONSPAWN,      SK_SPELLCASTING,    0),
    APT(SP_DEMONSPAWN,      SK_CONJURATIONS,    0),
    APT(SP_DEMONSPAWN,      SK_HEXES,           0),
    APT(SP_DEMONSPAWN,      SK_CHARMS,         -1),
    APT(SP_DEMONSPAWN,      SK_SUMMONINGS,      0),
    APT(SP_DEMONSPAWN,      SK_NECROMANCY,      1),
    APT(SP_DEMONSPAWN,      SK_TRANSLOCATIONS, -1),
    APT(SP_DEMONSPAWN,      SK_TRANSMUTATIONS, -1),
    APT(SP_DEMONSPAWN,      SK_FIRE_MAGIC,     -1),
    APT(SP_DEMONSPAWN,      SK_ICE_MAGIC,      -1),
    APT(SP_DEMONSPAWN,      SK_AIR_MAGIC,      -1),
    APT(SP_DEMONSPAWN,      SK_EARTH_MAGIC,    -1),
    APT(SP_DEMONSPAWN,      SK_POISON_MAGIC,    0),
    APT(SP_DEMONSPAWN,      SK_INVOCATIONS,     2),
    APT(SP_DEMONSPAWN,      SK_EVOCATIONS,      0),

    // SP_GHOUL
    APT(SP_GHOUL,           SK_FIGHTING,        1),
    APT(SP_GHOUL,           SK_SHORT_BLADES,   -1),
    APT(SP_GHOUL,           SK_LONG_BLADES,    -1),
    APT(SP_GHOUL,           SK_AXES,           -1),
    APT(SP_GHOUL,           SK_MACES_FLAILS,   -1),
    APT(SP_GHOUL,           SK_POLEARMS,       -1),
    APT(SP_GHOUL,           SK_STAVES,         -1),
    APT(SP_GHOUL,           SK_SLINGS,         -1),
    APT(SP_GHOUL,           SK_BOWS,           -1),
    APT(SP_GHOUL,           SK_CROSSBOWS,      -1),
    APT(SP_GHOUL,           SK_THROWING,       -1),
    APT(SP_GHOUL,           SK_ARMOUR,         -1),
    APT(SP_GHOUL,           SK_DODGING,        -1),
    APT(SP_GHOUL,           SK_STEALTH,         1),
    APT(SP_GHOUL,           SK_STABBING,        0),
    APT(SP_GHOUL,           SK_SHIELDS,        -1),
    APT(SP_GHOUL,           SK_TRAPS_DOORS,    -1),
    APT(SP_GHOUL,           SK_UNARMED_COMBAT,  1),
    APT(SP_GHOUL,           SK_SPELLCASTING,   -1),
    APT(SP_GHOUL,           SK_CONJURATIONS,   -2),
    APT(SP_GHOUL,           SK_HEXES,          -2),
    APT(SP_GHOUL,           SK_CHARMS,         -1),
    APT(SP_GHOUL,           SK_SUMMONINGS,     -1),
    APT(SP_GHOUL,           SK_NECROMANCY,      0),
    APT(SP_GHOUL,           SK_TRANSLOCATIONS, -1),
    APT(SP_GHOUL,           SK_TRANSMUTATIONS, -1),
    APT(SP_GHOUL,           SK_FIRE_MAGIC,     -2),
    APT(SP_GHOUL,           SK_ICE_MAGIC,       1),
    APT(SP_GHOUL,           SK_AIR_MAGIC,      -2),
    APT(SP_GHOUL,           SK_EARTH_MAGIC,     1),
    APT(SP_GHOUL,           SK_POISON_MAGIC,    0),
    APT(SP_GHOUL,           SK_INVOCATIONS,     0),
    APT(SP_GHOUL,           SK_EVOCATIONS,     -1),

    // SP_KENKU
    APT(SP_KENKU,           SK_FIGHTING,        0),
    APT(SP_KENKU,           SK_SHORT_BLADES,    1),
    APT(SP_KENKU,           SK_LONG_BLADES,     1),
    APT(SP_KENKU,           SK_AXES,            1),
    APT(SP_KENKU,           SK_MACES_FLAILS,    1),
    APT(SP_KENKU,           SK_POLEARMS,        1),
    APT(SP_KENKU,           SK_STAVES,          1),
    APT(SP_KENKU,           SK_SLINGS,          0),
    APT(SP_KENKU,           SK_BOWS,            1),
    APT(SP_KENKU,           SK_CROSSBOWS,       1),
    APT(SP_KENKU,           SK_THROWING,        1),
    APT(SP_KENKU,           SK_ARMOUR,          1),
    APT(SP_KENKU,           SK_DODGING,         1),
    APT(SP_KENKU,           SK_STEALTH,         0),
    APT(SP_KENKU,           SK_STABBING,        1),
    APT(SP_KENKU,           SK_SHIELDS,         0),
    APT(SP_KENKU,           SK_TRAPS_DOORS,     0),
    APT(SP_KENKU,           SK_UNARMED_COMBAT,  1),
    APT(SP_KENKU,           SK_SPELLCASTING,    0),
    APT(SP_KENKU,           SK_CONJURATIONS,    3),
    APT(SP_KENKU,           SK_HEXES,          -3),
    APT(SP_KENKU,           SK_CHARMS,         -2),
    APT(SP_KENKU,           SK_SUMMONINGS,      2),
    APT(SP_KENKU,           SK_NECROMANCY,      1),
    APT(SP_KENKU,           SK_TRANSLOCATIONS, -2),
    APT(SP_KENKU,           SK_TRANSMUTATIONS, -2),
    APT(SP_KENKU,           SK_FIRE_MAGIC,      1),
    APT(SP_KENKU,           SK_ICE_MAGIC,      -1),
    APT(SP_KENKU,           SK_AIR_MAGIC,       3),
    APT(SP_KENKU,           SK_EARTH_MAGIC,    -3),
    APT(SP_KENKU,           SK_POISON_MAGIC,    0),
    APT(SP_KENKU,           SK_INVOCATIONS,    -2),
    APT(SP_KENKU,           SK_EVOCATIONS,      0),

    // SP_MERFOLK
    APT(SP_MERFOLK,         SK_FIGHTING,        1),
    APT(SP_MERFOLK,         SK_SHORT_BLADES,    2),
    APT(SP_MERFOLK,         SK_LONG_BLADES,     1),
    APT(SP_MERFOLK,         SK_AXES,           -2),
    APT(SP_MERFOLK,         SK_MACES_FLAILS,   -2),
    APT(SP_MERFOLK,         SK_POLEARMS,        4),
    APT(SP_MERFOLK,         SK_STAVES,         -2),
    APT(SP_MERFOLK,         SK_SLINGS,         -2),
    APT(SP_MERFOLK,         SK_BOWS,           -2),
    APT(SP_MERFOLK,         SK_CROSSBOWS,      -2),
    APT(SP_MERFOLK,         SK_THROWING,        0),
    APT(SP_MERFOLK,         SK_ARMOUR,         -3),
    APT(SP_MERFOLK,         SK_DODGING,         3),
    APT(SP_MERFOLK,         SK_STEALTH,         1),
    APT(SP_MERFOLK,         SK_STABBING,        2),
    APT(SP_MERFOLK,         SK_SHIELDS,         0),
    APT(SP_MERFOLK,         SK_TRAPS_DOORS,    -1),
    APT(SP_MERFOLK,         SK_UNARMED_COMBAT,  1),
    APT(SP_MERFOLK,         SK_SPELLCASTING,    0),
    APT(SP_MERFOLK,         SK_CONJURATIONS,   -2),
    APT(SP_MERFOLK,         SK_HEXES,           0),
    APT(SP_MERFOLK,         SK_CHARMS,          1),
    APT(SP_MERFOLK,         SK_SUMMONINGS,      0),
    APT(SP_MERFOLK,         SK_NECROMANCY,     -2),
    APT(SP_MERFOLK,         SK_TRANSLOCATIONS, -2),
    APT(SP_MERFOLK,         SK_TRANSMUTATIONS,  3),
    APT(SP_MERFOLK,         SK_FIRE_MAGIC,     -3),
    APT(SP_MERFOLK,         SK_ICE_MAGIC,       1),
    APT(SP_MERFOLK,         SK_AIR_MAGIC,      -2),
    APT(SP_MERFOLK,         SK_EARTH_MAGIC,    -2),
    APT(SP_MERFOLK,         SK_POISON_MAGIC,    1),
    APT(SP_MERFOLK,         SK_INVOCATIONS,     0),
    APT(SP_MERFOLK,         SK_EVOCATIONS,      0),

    // SP_VAMPIRE
    APT(SP_VAMPIRE,         SK_FIGHTING,       -1),
    APT(SP_VAMPIRE,         SK_SHORT_BLADES,    1),
    APT(SP_VAMPIRE,         SK_LONG_BLADES,     0),
    APT(SP_VAMPIRE,         SK_AXES,           -1),
    APT(SP_VAMPIRE,         SK_MACES_FLAILS,   -2),
    APT(SP_VAMPIRE,         SK_POLEARMS,       -1),
    APT(SP_VAMPIRE,         SK_STAVES,         -2),
    APT(SP_VAMPIRE,         SK_SLINGS,         -2),
    APT(SP_VAMPIRE,         SK_BOWS,           -2),
    APT(SP_VAMPIRE,         SK_CROSSBOWS,      -2),
    APT(SP_VAMPIRE,         SK_THROWING,       -2),
    APT(SP_VAMPIRE,         SK_ARMOUR,         -2),
    APT(SP_VAMPIRE,         SK_DODGING,         1),
    APT(SP_VAMPIRE,         SK_STEALTH,         4),
    APT(SP_VAMPIRE,         SK_STABBING,        1),
    APT(SP_VAMPIRE,         SK_SHIELDS,        -1),
    APT(SP_VAMPIRE,         SK_TRAPS_DOORS,     0),
    APT(SP_VAMPIRE,         SK_UNARMED_COMBAT,  1),
    APT(SP_VAMPIRE,         SK_SPELLCASTING,    0),
    APT(SP_VAMPIRE,         SK_CONJURATIONS,   -3),
    APT(SP_VAMPIRE,         SK_HEXES,           4),
    APT(SP_VAMPIRE,         SK_CHARMS,          1),
    APT(SP_VAMPIRE,         SK_SUMMONINGS,      0),
    APT(SP_VAMPIRE,         SK_NECROMANCY,      1),
    APT(SP_VAMPIRE,         SK_TRANSLOCATIONS, -2),
    APT(SP_VAMPIRE,         SK_TRANSMUTATIONS,  1),
    APT(SP_VAMPIRE,         SK_FIRE_MAGIC,     -2),
    APT(SP_VAMPIRE,         SK_ICE_MAGIC,       0),
    APT(SP_VAMPIRE,         SK_AIR_MAGIC,       0),
    APT(SP_VAMPIRE,         SK_EARTH_MAGIC,    -1),
    APT(SP_VAMPIRE,         SK_POISON_MAGIC,   -1),
    APT(SP_VAMPIRE,         SK_INVOCATIONS,    -2),
    APT(SP_VAMPIRE,         SK_EVOCATIONS,     -1),

    // SP_DEEP_DWARF
    APT(SP_DEEP_DWARF,      SK_FIGHTING,       -1),
    APT(SP_DEEP_DWARF,      SK_SHORT_BLADES,   -1),
    APT(SP_DEEP_DWARF,      SK_LONG_BLADES,     0),
    APT(SP_DEEP_DWARF,      SK_AXES,            1),
    APT(SP_DEEP_DWARF,      SK_MACES_FLAILS,    0),
    APT(SP_DEEP_DWARF,      SK_POLEARMS,       -1),
    APT(SP_DEEP_DWARF,      SK_STAVES,         -1),
    APT(SP_DEEP_DWARF,      SK_SLINGS,          1),
    APT(SP_DEEP_DWARF,      SK_BOWS,           -3),
    APT(SP_DEEP_DWARF,      SK_CROSSBOWS,       1),
    APT(SP_DEEP_DWARF,      SK_THROWING,       -1),
    APT(SP_DEEP_DWARF,      SK_ARMOUR,          1),
    APT(SP_DEEP_DWARF,      SK_DODGING,         1),
    APT(SP_DEEP_DWARF,      SK_STEALTH,         2),
    APT(SP_DEEP_DWARF,      SK_STABBING,       -1),
    APT(SP_DEEP_DWARF,      SK_SHIELDS,         1),
    APT(SP_DEEP_DWARF,      SK_TRAPS_DOORS,     1),
    APT(SP_DEEP_DWARF,      SK_UNARMED_COMBAT, -1),
    APT(SP_DEEP_DWARF,      SK_SPELLCASTING,   -1),
    APT(SP_DEEP_DWARF,      SK_CONJURATIONS,   -1),
    APT(SP_DEEP_DWARF,      SK_HEXES,          -2),
    APT(SP_DEEP_DWARF,      SK_CHARMS,         -1),
    APT(SP_DEEP_DWARF,      SK_SUMMONINGS,     -1),
    APT(SP_DEEP_DWARF,      SK_NECROMANCY,      1),
    APT(SP_DEEP_DWARF,      SK_TRANSLOCATIONS,  1),
    APT(SP_DEEP_DWARF,      SK_TRANSMUTATIONS, -1),
    APT(SP_DEEP_DWARF,      SK_FIRE_MAGIC,     -1),
    APT(SP_DEEP_DWARF,      SK_ICE_MAGIC,      -1),
    APT(SP_DEEP_DWARF,      SK_AIR_MAGIC,      -3),
    APT(SP_DEEP_DWARF,      SK_EARTH_MAGIC,     3),
    APT(SP_DEEP_DWARF,      SK_POISON_MAGIC,   -2),
    APT(SP_DEEP_DWARF,      SK_INVOCATIONS,     2),
    APT(SP_DEEP_DWARF,      SK_EVOCATIONS,      3),

    // SP_CAT
    APT(SP_CAT,             SK_FIGHTING,       -2),
    APT(SP_CAT,             SK_SHORT_BLADES,    0),
    APT(SP_CAT,             SK_LONG_BLADES,     0),
    APT(SP_CAT,             SK_AXES,            0),
    APT(SP_CAT,             SK_MACES_FLAILS,    0),
    APT(SP_CAT,             SK_POLEARMS,        0),
    APT(SP_CAT,             SK_STAVES,          0),
    APT(SP_CAT,             SK_SLINGS,          0),
    APT(SP_CAT,             SK_BOWS,            0),
    APT(SP_CAT,             SK_CROSSBOWS,       0),
    APT(SP_CAT,             SK_THROWING,        0),
    APT(SP_CAT,             SK_ARMOUR,          0),
    APT(SP_CAT,             SK_DODGING,         2),
    APT(SP_CAT,             SK_STEALTH,         2),
    APT(SP_CAT,             SK_STABBING,        3),
    APT(SP_CAT,             SK_SHIELDS,         0),
    APT(SP_CAT,             SK_TRAPS_DOORS,     2),
    APT(SP_CAT,             SK_UNARMED_COMBAT, -2),
    APT(SP_CAT,             SK_SPELLCASTING,    0),
    APT(SP_CAT,             SK_CONJURATIONS,   -1),
    APT(SP_CAT,             SK_HEXES,           3),
    APT(SP_CAT,             SK_CHARMS,          2),
    APT(SP_CAT,             SK_SUMMONINGS,      1),
    APT(SP_CAT,             SK_NECROMANCY,      0),
    APT(SP_CAT,             SK_TRANSLOCATIONS,  2),
    APT(SP_CAT,             SK_TRANSMUTATIONS,  1),
    APT(SP_CAT,             SK_FIRE_MAGIC,     -1),
    APT(SP_CAT,             SK_ICE_MAGIC,      -2),
    APT(SP_CAT,             SK_AIR_MAGIC,      -1),
    APT(SP_CAT,             SK_EARTH_MAGIC,    -2),
    APT(SP_CAT,             SK_POISON_MAGIC,   -1),
    APT(SP_CAT,             SK_INVOCATIONS,    -1),
    APT(SP_CAT,             SK_EVOCATIONS,     -2),
};

#endif
