// vs_editline.h             -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  A simple line-editor widget.

#ifndef VS_EDITLINE_H
#define VS_EDITLINE_H

#include "vscreen_widget.h"

#include <vector>

class keybindings;

class vs_editline:public vscreen_widget
{
public:
  typedef std::vector<std::string> history_list;
private:

  std::string prompt;
  std::string text;

  std::string pre_history_text;
  // Used as a "virtual" history entry.

  std::string::size_type curloc, startloc;

  int desired_size;

  // The history of the edit-line.  (if NULL, there is no history)
  history_list *history;
  // The current location in the history
  history_list::size_type history_loc;
  // True if we're flipping through the history.  (to avoid signedness
  // problems)
  bool using_history;

  void normalize_cursor();
protected:
  bool handle_char(chtype ch);
public:
  vs_editline(std::string _prompt, std::string _text="",
	      history_list *history=NULL);
  vs_editline(int maxlength, const std::string &_prompt,
	      const std::string &_text="", history_list *history=NULL);

  bool focus_me();
  void paint();
  void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  SigC::Signal1<void, std::string> entered;
  // Called when the user presses Enter to confirm the text
  SigC::Signal1<void, std::string> text_changed;
  // Called when the text is altered.

  std::string get_text() {return text;}
  void set_text(std::string _text);

  bool get_cursorvisible();
  point get_cursorloc();

  // FIXME: do this better..
  size size_request()
  {
    if(desired_size==-1)
      return size(prompt.size()+text.size()+1, 1);
    else
      return size(desired_size, 1);
  }

  static void add_to_history(std::string s,
			     history_list *history);
  // Appends the string to the end of the history list (convenience routine)

  void add_to_history(std::string s);
  void reset_history();

  static keybindings *bindings;
  static void init_bindings();
};

#endif
