/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_inputwin.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:27:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _GEN_HXX //autogen
// auto strip #include <tools/gen.hxx>
// auto strip #endif
// auto strip #ifndef _SFXIMGMGR_HXX //autogen
// auto strip #include <bf_sfx2/imgmgr.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SVX_RULER_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
// auto strip #ifndef _ZFORLIST_HXX //autogen
// auto strip #include <svtools/zforlist.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif

// auto strip #include "swtypes.hxx"
#include "cmdid.h"
// auto strip #include "swmodule.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
#ifndef _VISCRS_HXX
#include <viscrs.hxx>
#endif
#include "wrtsh.hxx"
// auto strip #include "view.hxx"
// auto strip #include "calc.hxx"
#include "inputwin.hxx"
// auto strip #include "fldbas.hxx"
// auto strip #include "fldmgr.hxx"
// auto strip #include "frmfmt.hxx"
// auto strip #include "cellatr.hxx"
// auto strip #include "edtwin.hxx"
#include "helpid.h"

// nur fuers UpdateRange - Box in dem der gestackte Cursor sthet loeschen
// auto strip #include "pam.hxx"
// auto strip #include "doc.hxx"

// auto strip #include "swundo.hxx"
#include "ribbar.hrc"
#include "inputwin.hrc"
namespace binfilter {


/*N*/ SFX_IMPL_POS_CHILDWINDOW( SwInputChild, FN_EDIT_FORMULA, SFX_OBJECTBAR_OBJECT )

//==================================================================

//STRIP001 /*N*/ SwInputWindow::SwInputWindow( Window* pParent, SfxBindings* pBind )
//STRIP001 /*N*/ 	: ToolBox( 	pParent ,	SW_RES( RID_TBX_FORMULA )),
//STRIP001 /*N*/ 	aEdit(      this, WB_3DLOOK|WB_TABSTOP|WB_BORDER|WB_NOHIDESELECTION),
//STRIP001 /*N*/ 	aPos(		this,		SW_RES(ED_POS)),
//STRIP001 /*N*/ 	aPopMenu(	SW_RES(MN_CALC_POPUP)),
//STRIP001 /*N*/ 	pMgr(0),
//STRIP001 /*N*/ 	pView(0),
//STRIP001 /*N*/ 	pWrtShell(0),
//STRIP001 /*N*/     pBindings(pBind),
//STRIP001 /*N*/ 	aAktTableName(aEmptyStr)
//STRIP001 /*N*/ {
//STRIP001 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	bFirst = bDoesUndo = TRUE;
//STRIP001 	bActive = bIsTable = bDelSel = bResetUndo = bCallUndo = FALSE;
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     SfxImageManager* pManager = pBindings->GetImageManager();
//STRIP001     pManager->RegisterToolBox(this);
//STRIP001 
//STRIP001 	pView = ::GetActiveView();
//STRIP001 	pWrtShell = pView ? pView->GetWrtShellPtr() : 0;
//STRIP001 
//STRIP001 	InsertWindow( ED_POS, &aPos, 0, 0);
//STRIP001 	InsertSeparator ( 1 );
//STRIP001 	InsertSeparator ();
//STRIP001 	InsertWindow( ED_FORMULA, &aEdit);
//STRIP001 	SetHelpId(ED_FORMULA, HID_EDIT_FORMULA);
//STRIP001 
//STRIP001 	SetItemImage( FN_FORMULA_CALC, pManager->GetImage(FN_FORMULA_CALC ));
//STRIP001 	SetItemImage( FN_FORMULA_CANCEL, pManager->GetImage(FN_FORMULA_CANCEL ));
//STRIP001 	SetItemImage( FN_FORMULA_APPLY, pManager->GetImage(FN_FORMULA_APPLY ));
//STRIP001 
//STRIP001 	Size	aSizeTbx = CalcWindowSizePixel();
//STRIP001 	Size aSize = GetSizePixel();
//STRIP001 	aSize.Height() = aSizeTbx.Height();
//STRIP001 	SetSizePixel( aSize );
//STRIP001 	Size 	aPosSize = aPos.GetSizePixel();
//STRIP001 	Size 	aEditSize = aEdit.GetSizePixel();
//STRIP001 	aPosSize.Height() = aEditSize.Height() = GetItemRect(FN_FORMULA_CALC).GetHeight() - 2;
//STRIP001 
//STRIP001 	Point aPosPos = aPos.GetPosPixel();
//STRIP001 	Point aEditPos= aEdit.GetPosPixel();
//STRIP001 	aPosPos.Y() = aEditPos.Y() = GetItemRect( FN_FORMULA_CALC ).TopLeft().Y() + 1;
//STRIP001 	aPos.SetPosSizePixel( aPosPos, aPosSize );
//STRIP001 	aEdit.SetPosSizePixel( aEditPos, aEditSize );
//STRIP001 
//STRIP001 	aPopMenu.SetSelectHdl(LINK( this, SwInputWindow, MenuHdl ));
//STRIP001 /*N*/ }

//==================================================================

//STRIP001 /*N*/ __EXPORT SwInputWindow::~SwInputWindow()
//STRIP001 /*N*/ {
//STRIP001 DBG_BF_ASSERT(0, "STRIP"); //STRIP001     pBindings->GetImageManager()->ReleaseToolBox(this);
//STRIP001 
//STRIP001 	//Lineale aufwecken
//STRIP001 	if(pView)
//STRIP001 	{
//STRIP001         pView->GetHLineal().SetActive( TRUE );
//STRIP001         pView->GetVLineal().SetActive( TRUE );
//STRIP001 	}
//STRIP001 	if ( pMgr )
//STRIP001 		delete pMgr;
//STRIP001 	if(pWrtShell)
//STRIP001 		pWrtShell->EndSelTblCells();
//STRIP001 
//STRIP001 	if( bResetUndo )
//STRIP001 	{
//STRIP001 		DelBoxCntnt();
//STRIP001 		pWrtShell->DoUndo( bDoesUndo );
//STRIP001 		if(bCallUndo)
//STRIP001 			pWrtShell->Undo();
//STRIP001 		SwEditShell::SetUndoActionCount( nActionCnt );
//STRIP001 	}
//STRIP001 /*N*/ }

//==================================================================

//STRIP001 void __EXPORT SwInputWindow::Resize()
//STRIP001 {
//STRIP001 	ToolBox::Resize();
//STRIP001 
//STRIP001 	long	nWidth		= GetSizePixel().Width();
//STRIP001 	long	nLeft		= aEdit.GetPosPixel().X();
//STRIP001 	Size	aEditSize	= aEdit.GetSizePixel();
//STRIP001 
//STRIP001 	aEditSize.Width() = Max( ((long)(nWidth - nLeft - 5)), (long)0 );
//STRIP001 	aEdit.SetSizePixel( aEditSize );
//STRIP001 	aEdit.Invalidate();
//STRIP001 }

//==================================================================

//STRIP001 void SwInputWindow::Show()
//STRIP001 {
//STRIP001 	bIsTable = FALSE;
//STRIP001 	//Lineale anhalten
//STRIP001 	if(pView)
//STRIP001 	{
//STRIP001         pView->GetHLineal().SetActive( FALSE );
//STRIP001         pView->GetVLineal().SetActive( FALSE );
//STRIP001 
//STRIP001 		DBG_ASSERT(pWrtShell, "Keine WrtShell!")
//STRIP001 		// Cursor in Tabelle
//STRIP001 		bIsTable = pWrtShell->IsCrsrInTbl() ? TRUE : FALSE;
//STRIP001 
//STRIP001 		if( bFirst )
//STRIP001 			pWrtShell->SelTblCells( LINK( this, SwInputWindow,
//STRIP001 												SelTblCellsNotify) );
//STRIP001 		if( bIsTable )
//STRIP001 		{
//STRIP001 			const String& rPos = pWrtShell->GetBoxNms();
//STRIP001 			USHORT nPos = 0;
//STRIP001 			short nSrch = -1;
//STRIP001 			while( (nPos = rPos.Search( ':',nPos + 1 ) ) != STRING_NOTFOUND )
//STRIP001 				nSrch = (short) nPos;
//STRIP001 			aPos.SetText( rPos.Copy( ++nSrch ) );
//STRIP001 			aAktTableName = pWrtShell->GetTableFmt()->GetName();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aPos.SetText(SW_RESSTR(STR_FORMULA));
//STRIP001 
//STRIP001 		// Aktuelles Feld bearbeiten
//STRIP001 		ASSERT(pMgr == 0, FieldManager nicht geloescht.);
//STRIP001 		pMgr = new SwFldMgr;
//STRIP001 
//STRIP001 		// JP 13.01.97: Formel soll immer mit einem "=" beginnen, hier
//STRIP001 		//				also setzen
//STRIP001 		String sEdit( '=' );
//STRIP001 		if( pMgr->GetCurFld() && TYP_FORMELFLD == pMgr->GetCurTypeId() )
//STRIP001 		{
//STRIP001 			sEdit += pMgr->GetCurFldPar2();
//STRIP001 		}
//STRIP001 		else if( bFirst )
//STRIP001 		{
//STRIP001 			if( bIsTable )
//STRIP001 			{
//STRIP001 				bResetUndo = TRUE;
//STRIP001 				nActionCnt = SwEditShell::GetUndoActionCount();
//STRIP001 				SwEditShell::SetUndoActionCount( nActionCnt + 1 );
//STRIP001 
//STRIP001 				bDoesUndo = pWrtShell->DoesUndo();
//STRIP001 				if( !bDoesUndo )
//STRIP001 					pWrtShell->DoUndo( TRUE );
//STRIP001 
//STRIP001 				if( !pWrtShell->SwCrsrShell::HasSelection() )
//STRIP001 				{
//STRIP001 					pWrtShell->MoveSection( fnSectionCurr, fnSectionStart );
//STRIP001 					pWrtShell->SetMark();
//STRIP001 					pWrtShell->MoveSection( fnSectionCurr, fnSectionEnd );
//STRIP001 				}
//STRIP001 				if( pWrtShell->SwCrsrShell::HasSelection() )
//STRIP001 				{
//STRIP001 					pWrtShell->StartUndo( UNDO_DELETE );
//STRIP001 					pWrtShell->Delete();
//STRIP001 					if( 0 != pWrtShell->EndUndo( UNDO_DELETE ))
//STRIP001 						bCallUndo = TRUE;
//STRIP001 				}
//STRIP001 				pWrtShell->DoUndo( FALSE );
//STRIP001 
//STRIP001 				SfxItemSet aSet( pWrtShell->GetAttrPool(), RES_BOXATR_FORMULA, RES_BOXATR_FORMULA );
//STRIP001 				if( pWrtShell->GetTblBoxFormulaAttrs( aSet ))
//STRIP001 					sEdit += ((SwTblBoxFormula&)aSet.Get( RES_BOXATR_FORMULA )).GetFormula();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bFirst )
//STRIP001 		{
//STRIP001 			// WrtShell Flags richtig setzen
//STRIP001 			pWrtShell->SttSelect();
//STRIP001 			pWrtShell->EndSelect();
//STRIP001 		}
//STRIP001 
//STRIP001 		bFirst = FALSE;
//STRIP001 
//STRIP001 		aEdit.SetModifyHdl( LINK( this, SwInputWindow, ModifyHdl ));
//STRIP001 
//STRIP001 		aEdit.SetText( sEdit );
//STRIP001 		aEdit.SetSelection( Selection( sEdit.Len(), sEdit.Len() ) );
//STRIP001 		sOldFml = sEdit;
//STRIP001 
//STRIP001 		aEdit.Invalidate();
//STRIP001 		aEdit.Update();
//STRIP001 		aEdit.GrabFocus();
//STRIP001 		// UserInterface fuer die Eingabe abklemmen
//STRIP001 
//STRIP001 		pView->GetEditWin().LockKeyInput(TRUE);
//STRIP001 		pView->GetViewFrame()->GetDispatcher()->Lock(TRUE);
//STRIP001 		pWrtShell->Push();
//STRIP001 	}
//STRIP001 	ToolBox::Show();
//STRIP001 }
//==================================================================

//STRIP001 IMPL_LINK( SwInputWindow, MenuHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 static const char * __READONLY_DATA aStrArr[] = {
//STRIP001 	sCalc_Phd,
//STRIP001 	sCalc_Sqrt,
//STRIP001 	sCalc_Or,
//STRIP001 	sCalc_Xor,
//STRIP001 	sCalc_And,
//STRIP001 	sCalc_Not,
//STRIP001 	sCalc_Eq,
//STRIP001 	sCalc_Neq,
//STRIP001 	sCalc_Leq,
//STRIP001 	sCalc_Geq,
//STRIP001 	sCalc_L,
//STRIP001 	sCalc_G,
//STRIP001 	sCalc_Sum,
//STRIP001 	sCalc_Mean,
//STRIP001 	sCalc_Min,
//STRIP001 	sCalc_Max,
//STRIP001 	sCalc_Sin,
//STRIP001 	sCalc_Cos,
//STRIP001 	sCalc_Tan,
//STRIP001 	sCalc_Asin,
//STRIP001 	sCalc_Acos,
//STRIP001 	sCalc_Atan,
//STRIP001 	sCalc_Pow,
//STRIP001 	"|",
//STRIP001 	sCalc_Round
//STRIP001 };
//STRIP001 
//STRIP001 	USHORT nId = pMenu->GetCurItemId();
//STRIP001 	if ( nId <= MN_CALC_ROUND )
//STRIP001 	{
//STRIP001 		String aTmp( String::CreateFromAscii(aStrArr[nId - 1]) );
//STRIP001 		aTmp += ' ';
//STRIP001 		aEdit.ReplaceSelected( aTmp );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//==================================================================


//STRIP001 void __EXPORT SwInputWindow::Click( )
//STRIP001 {
//STRIP001 	USHORT nCurID = GetCurItemId();
//STRIP001 	EndSelection();	// setzt CurItemId zurueck !
//STRIP001 	switch ( nCurID )
//STRIP001 	{
//STRIP001 		case FN_FORMULA_CALC :
//STRIP001 		{
//STRIP001 			Point aBL = GetItemRect( FN_FORMULA_CALC ).BottomLeft();
//STRIP001 			Point aPt(aBL.X(), aBL.Y());
//STRIP001 			aPopMenu.Execute( this, aPt );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_FORMULA_CANCEL:
//STRIP001 		{
//STRIP001 			CancelFormula();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_FORMULA_APPLY:
//STRIP001 		{
//STRIP001 			ApplyFormula();
//STRIP001 		}
//STRIP001 		break;
//STRIP001    }
//STRIP001 }

//==================================================================

//STRIP001 void  SwInputWindow::ApplyFormula()
//STRIP001 {
//STRIP001 	pView->GetViewFrame()->GetDispatcher()->Lock(FALSE);
//STRIP001 	pView->GetEditWin().LockKeyInput(FALSE);
//STRIP001 	if( bResetUndo )
//STRIP001 	{
//STRIP001 		DelBoxCntnt();
//STRIP001 		pWrtShell->DoUndo( bDoesUndo );
//STRIP001 		SwEditShell::SetUndoActionCount( nActionCnt );
//STRIP001 		if( bCallUndo )
//STRIP001 			pWrtShell->Undo();
//STRIP001 		bResetUndo = FALSE;
//STRIP001 	}
//STRIP001 	pWrtShell->Pop( FALSE );
//STRIP001 
//STRIP001 	// JP 13.01.97: Formel soll immer mit einem "=" beginnen, hier
//STRIP001 	//				also wieder entfernen
//STRIP001 	String sEdit( aEdit.GetText() );
//STRIP001 	sEdit.EraseLeadingChars().EraseTrailingChars();
//STRIP001 	if( sEdit.Len() && '=' == sEdit.GetChar( 0 ) )
//STRIP001 		sEdit.Erase( 0, 1 );
//STRIP001     SfxStringItem aParam(FN_EDIT_FORMULA, sEdit);
//STRIP001 
//STRIP001 	pWrtShell->EndSelTblCells();
//STRIP001 	pView->GetEditWin().GrabFocus();
//STRIP001     const SfxPoolItem* aArgs[2];
//STRIP001     aArgs[0] = &aParam;
//STRIP001     aArgs[1] = 0;
//STRIP001     pView->GetViewFrame()->GetBindings().Execute( FN_EDIT_FORMULA, aArgs, 0, SFX_CALLMODE_ASYNCHRON );
//STRIP001 }

//==================================================================

//STRIP001 void  SwInputWindow::CancelFormula()
//STRIP001 {
//STRIP001 	if(pView)
//STRIP001 	{
//STRIP001 		pView->GetViewFrame()->GetDispatcher()->Lock( FALSE );
//STRIP001 		pView->GetEditWin().LockKeyInput(FALSE);
//STRIP001 		if( bResetUndo )
//STRIP001 		{
//STRIP001 			DelBoxCntnt();
//STRIP001 			pWrtShell->DoUndo( bDoesUndo );
//STRIP001 			SwEditShell::SetUndoActionCount( nActionCnt );
//STRIP001 			if( bCallUndo )
//STRIP001 				pWrtShell->Undo();
//STRIP001 			bResetUndo = FALSE;
//STRIP001 		}
//STRIP001 		pWrtShell->Pop( FALSE );
//STRIP001 
//STRIP001 		if( bDelSel )
//STRIP001 			pWrtShell->EnterStdMode();
//STRIP001 
//STRIP001 		pWrtShell->EndSelTblCells();
//STRIP001 
//STRIP001 		pView->GetEditWin().GrabFocus();
//STRIP001 	}
//STRIP001 	pView->GetViewFrame()->GetDispatcher()->Execute( FN_EDIT_FORMULA, SFX_CALLMODE_ASYNCHRON);
//STRIP001 }
//==================================================================

//STRIP001 const xub_Unicode CH_LRE = 0x202a;
//STRIP001 const xub_Unicode CH_PDF = 0x202c;
//STRIP001 
//STRIP001 IMPL_LINK( SwInputWindow, SelTblCellsNotify, SwWrtShell *, pCaller )
//STRIP001 {
//STRIP001 	if(bIsTable)
//STRIP001 	{
//STRIP001 		SwFrmFmt* pTblFmt = pCaller->GetTableFmt();
//STRIP001 		String sBoxNms( pCaller->GetBoxNms() );
//STRIP001 		String sTblNm;
//STRIP001 		if( pTblFmt && aAktTableName != pTblFmt->GetName() )
//STRIP001 			sTblNm = pTblFmt->GetName();
//STRIP001 
//STRIP001 		aEdit.UpdateRange( sBoxNms, sTblNm );
//STRIP001 
//STRIP001 		String sNew;
//STRIP001         sNew += CH_LRE;
//STRIP001         sNew += aEdit.GetText();
//STRIP001         sNew += CH_PDF;
//STRIP001 
//STRIP001         if( sNew != sOldFml )
//STRIP001 		{
//STRIP001 			// Die WrtShell ist in der Tabellen Selektion
//STRIP001 			// dann die Tabellen Selektion wieder aufheben, sonst steht der
//STRIP001 			// Cursor "im Wald" und das LiveUpdate funktioniert nicht!
//STRIP001 			pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 			SwPaM aPam( *pWrtShell->GetStkCrsr()->GetPoint() );
//STRIP001 			aPam.Move( fnMoveBackward, fnGoSection );
//STRIP001 			aPam.SetMark();
//STRIP001 			aPam.Move( fnMoveForward, fnGoSection );
//STRIP001 
//STRIP001 			pWrtShell->GetDoc()->Delete( aPam );
//STRIP001 			pWrtShell->GetDoc()->Insert( aPam, sNew );
//STRIP001 			pWrtShell->EndAllAction();
//STRIP001 			sOldFml = sNew;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aEdit.GrabFocus();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SwInputWindow::SetFormula( const String& rFormula, BOOL bDelFlag )
//STRIP001 {
//STRIP001 	String sEdit( '=' );
//STRIP001 	if( rFormula.Len() )
//STRIP001 	{
//STRIP001 		if( '=' == rFormula.GetChar( 0 ) )
//STRIP001 			sEdit = rFormula;
//STRIP001 		else
//STRIP001 			sEdit += rFormula;
//STRIP001 	}
//STRIP001 	aEdit.SetText( sEdit );
//STRIP001 	aEdit.SetSelection( Selection( sEdit.Len(), sEdit.Len() ) );
//STRIP001 	aEdit.Invalidate();
//STRIP001 	bDelSel = bDelFlag;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SwInputWindow, ModifyHdl, InputEdit*, EMPTYARG )
//STRIP001 {
//STRIP001     if( bIsTable && bResetUndo )
//STRIP001 	{
//STRIP001 		pWrtShell->StartAllAction();
//STRIP001 		DelBoxCntnt();
//STRIP001 		String sNew;
//STRIP001         sNew += CH_LRE;
//STRIP001         sNew += aEdit.GetText();
//STRIP001         sNew += CH_PDF;
//STRIP001 		pWrtShell->SwEditShell::Insert( sNew );
//STRIP001 		pWrtShell->EndAllAction();
//STRIP001 		sOldFml = sNew;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SwInputWindow::DelBoxCntnt()
//STRIP001 {
//STRIP001 	if( bIsTable )
//STRIP001 	{
//STRIP001 		pWrtShell->StartAllAction();
//STRIP001 		pWrtShell->ClearMark();
//STRIP001 		pWrtShell->Pop( FALSE );
//STRIP001 		pWrtShell->Push();
//STRIP001 		pWrtShell->MoveSection( fnSectionCurr, fnSectionStart );
//STRIP001 		pWrtShell->SetMark();
//STRIP001 		pWrtShell->MoveSection( fnSectionCurr, fnSectionEnd );
//STRIP001 		pWrtShell->SwEditShell::Delete();
//STRIP001 		pWrtShell->EndAllAction();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //==================================================================
//STRIP001 
//STRIP001 void __EXPORT InputEdit::KeyInput(const KeyEvent& rEvent)
//STRIP001 {
//STRIP001 	const KeyCode aCode = rEvent.GetKeyCode();
//STRIP001 	if(aCode == KEY_RETURN || aCode == KEY_F2 )
//STRIP001 		((SwInputWindow*)GetParent())->ApplyFormula();
//STRIP001 	else if(aCode == KEY_ESCAPE )
//STRIP001 		((SwInputWindow*)GetParent())->CancelFormula();
//STRIP001 	else
//STRIP001 		Edit::KeyInput(rEvent);
//STRIP001 }
//STRIP001 
//STRIP001 //==================================================================
//STRIP001 
//STRIP001 void __EXPORT InputEdit::UpdateRange(const String& rBoxes,
//STRIP001 									const String& rName )
//STRIP001 {
//STRIP001 	if( !rBoxes.Len() )
//STRIP001 	{
//STRIP001 		GrabFocus();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	const sal_Unicode	cOpen = '<', cClose = '>',
//STRIP001 				cOpenBracket = '(', cCloseBracket = ')';
//STRIP001 	String aPrefix = rName;
//STRIP001 	if(rName.Len())
//STRIP001 		aPrefix += '.';
//STRIP001 	String aBoxes = aPrefix;
//STRIP001 	aBoxes += rBoxes;
//STRIP001 	Selection aSelection(GetSelection());
//STRIP001 	USHORT nSel = (USHORT) aSelection.Len();
//STRIP001 	//OS: mit dem folgenden Ausdruck wird sichergestellt, dass im overwrite-Modus
//STRIP001 	//die selektierte schliessende Klammer nicht geloescht wird
//STRIP001 	if( nSel && ( nSel > 1 ||
//STRIP001 		GetText().GetChar( (USHORT)aSelection.Min() ) != cClose ) )
//STRIP001 		Cut();
//STRIP001 	else
//STRIP001 		aSelection.Max() = aSelection.Min();
//STRIP001 	String aActText(GetText());
//STRIP001 	const USHORT nLen = aActText.Len();
//STRIP001 	if( !nLen )
//STRIP001 	{
//STRIP001 		String aStr(cOpen);
//STRIP001 		aStr += aBoxes;
//STRIP001 		aStr += cClose;
//STRIP001 		SetText(aStr);
//STRIP001 		USHORT nPos = aStr.Search( cClose );
//STRIP001 		ASSERT(nPos < aStr.Len(), Delimiter nicht gefunden.);
//STRIP001 		++nPos;
//STRIP001 		SetSelection( Selection( nPos, nPos ));
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BOOL bFound = FALSE;
//STRIP001 		sal_Unicode cCh;
//STRIP001 		USHORT nPos, nEndPos, nStartPos = (USHORT) aSelection.Min();
//STRIP001 		if( nStartPos-- )
//STRIP001 		{
//STRIP001 			do {
//STRIP001 				if( cOpen  == (cCh = aActText.GetChar( nStartPos ) ) ||
//STRIP001 					cOpenBracket == cCh )
//STRIP001 				{
//STRIP001 					bFound = cCh == cOpen;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			} while( nStartPos-- > 0 );
//STRIP001 		}
//STRIP001 		if( bFound )
//STRIP001 		{
//STRIP001 			bFound = FALSE;
//STRIP001 			nEndPos = nStartPos;
//STRIP001 			while( nEndPos < nLen )
//STRIP001 			{
//STRIP001 				if( cClose == (cCh = aActText.GetChar( nEndPos )) /*||
//STRIP001 					cCh == cCloseBracket*/ )
//STRIP001 				{
//STRIP001 					bFound = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				++nEndPos;
//STRIP001 			}
//STRIP001 			// nur wenn akt. Pos im Breich oder direkt dahinter liegt
//STRIP001 			if( bFound && !( nStartPos < (USHORT)aSelection.Max() &&
//STRIP001 							 (USHORT)aSelection.Max() <= nEndPos + 1 ))
//STRIP001 				bFound = FALSE;
//STRIP001 		}
//STRIP001 		if( bFound )
//STRIP001 		{
//STRIP001 			nPos = ++nStartPos + 1; // wir wollen dahinter
//STRIP001 			aActText.Erase( nStartPos, nEndPos - nStartPos );
//STRIP001 			aActText.Insert( aBoxes, nStartPos );
//STRIP001 			nPos += aBoxes.Len();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			String aTmp( (char)cOpen );
//STRIP001 			aTmp += aBoxes;
//STRIP001 			aTmp += (char)cClose;
//STRIP001 			nPos = (USHORT)aSelection.Min();
//STRIP001 			aActText.Insert( aTmp, nPos );
//STRIP001 			nPos += aTmp.Len();
//STRIP001 		}
//STRIP001 		if( GetText() != aActText )
//STRIP001 		{
//STRIP001 			SetText( aActText );
//STRIP001 			SetSelection( Selection( nPos, nPos ) );
//STRIP001 //			GetModifyHdl().Call( this );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	GrabFocus();
//STRIP001 
//STRIP001 }
//==================================================================


/*N*/ SwInputChild::SwInputChild(Window* pParent,
/*N*/ 								USHORT nId,
/*N*/                                 SfxBindings* pBindings,
/*N*/ 								SfxChildWinInfo* ) :
/*N*/ 								SfxChildWindow( pParent, nId )
/*N*/ {
/*N*/     pDispatch = pBindings->GetDispatcher();
//STRIP001 /*N*/     pWindow = new SwInputWindow( pParent, pBindings );
//STRIP001 /*N*/ 	((SwInputWindow*)pWindow)->Show();
/*N*/ 	eChildAlignment = SFX_ALIGN_LOWESTTOP;
/*N*/ }


/*N*/ __EXPORT SwInputChild::~SwInputChild()
/*N*/ {
/*N*/ 	if(pDispatch)
/*N*/ 		pDispatch->Lock(FALSE);
/*N*/ }


/*?*/ SfxChildWinInfo __EXPORT SwInputChild::GetInfo() const
/*?*/ {
/*?*/ 	SfxChildWinInfo aInfo = SfxChildWindow::GetInfo();	   \
/*?*/ 	return aInfo;
/*?*/ }























}
