/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_paragrph.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:58:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SFXSTYLE_HXX
#include <svtools/style.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#define ITEMID_LINESPACING	0
#define ITEMID_ADJUST       0
#define ITEMID_ORPHANS      0
#define ITEMID_WIDOWS       0
#define ITEMID_TABSTOP      0
#define ITEMID_PAGEMODEL    0
#define ITEMID_FMTSPLIT     0
#define ITEMID_HYPHENZONE   0
#define ITEMID_ULSPACE      0
#define ITEMID_LRSPACE      0
#define ITEMID_FMTBREAK     0
#define ITEMID_FMTKEEP      0
#define ITEMID_PARAVERTALIGN 0
#define _SVX_PARAGRPH_CXX   0
#define ITEMID_PARAGRID     0
#define ITEMID_FRAMEDIR     0


#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#ifndef _SVX_PGRDITEM_HXX
#include <pgrditem.hxx>
#endif
#include "dialogs.hrc"
#include "paragrph.hrc"
#include "paragrph.hxx"
#include "frmdiritem.hxx"

#include "lspcitem.hxx"
#include "adjitem.hxx"
#include "orphitem.hxx"
#include "widwitem.hxx"
#include "tstpitem.hxx"
#include "pmdlitem.hxx"
#include "spltitem.hxx"
#include "hyznitem.hxx"
#include "ulspitem.hxx"
#include "lrspitem.hxx"
#include "brkitem.hxx"
#include "keepitem.hxx"
#include "paractrl.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "htmlmode.hxx"
#ifndef _SVX_PARAVERTALIGNITEM_HXX
#include <paravertalignitem.hxx>
#endif
namespace binfilter {

// static ----------------------------------------------------------------

//STRIP001 static USHORT pStdRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_PARA_LINESPACE,		// 10033
//STRIP001 	SID_ATTR_PARA_LINESPACE,
//STRIP001 	SID_ATTR_LRSPACE,				// 10048 -
//STRIP001 	SID_ATTR_ULSPACE,				// 10049
//STRIP001 	SID_ATTR_PARA_REGISTER,			// 10413
//STRIP001 	SID_ATTR_PARA_REGISTER,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pAlignRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_PARA_ADJUST,			// 10027
//STRIP001 	SID_ATTR_PARA_ADJUST,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pExtRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_PARA_PAGEBREAK,		// 10037 -
//STRIP001 	SID_ATTR_PARA_ORPHANS,			// 10041
//STRIP001 	SID_ATTR_PARA_MODEL,			// 10065 -
//STRIP001 	SID_ATTR_PARA_KEEP,				// 10066
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 // define ----------------------------------------------------------------
//STRIP001 
//STRIP001 #define MAX_DURCH 5670      // 10 cm ist sinnvoll als maximaler Durchschuss
//STRIP001 							// laut BP
//STRIP001 #define FIX_DIST_DEF 283    // Standard-Fix-Abstand 0,5cm
//STRIP001 
//STRIP001 // enum ------------------------------------------------------------------
//STRIP001 
//STRIP001 enum LineSpaceList
//STRIP001 {
//STRIP001 	LLINESPACE_1    = 0,
//STRIP001 	LLINESPACE_15   = 1,
//STRIP001 	LLINESPACE_2    = 2,
//STRIP001 	LLINESPACE_PROP = 3,
//STRIP001 	LLINESPACE_MIN  = 4,
//STRIP001 	LLINESPACE_DURCH= 5,
//STRIP001 	LLINESPACE_FIX 	= 6,
//STRIP001 	LLINESPACE_END
//STRIP001 };
//STRIP001 
//STRIP001 // C-Funktion ------------------------------------------------------------
//STRIP001 
//STRIP001 void SetLineSpace_Impl( SvxLineSpacingItem&, int, long lValue = 0 );
//STRIP001 
//STRIP001 void SetLineSpace_Impl( SvxLineSpacingItem& rLineSpace,
//STRIP001 						int eSpace, long lValue )
//STRIP001 {
//STRIP001 	switch ( eSpace )
//STRIP001 	{
//STRIP001 		case LLINESPACE_1:
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			rLineSpace.GetInterLineSpaceRule() = SVX_INTER_LINE_SPACE_OFF;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_15:
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			rLineSpace.SetPropLineSpace( 150 );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_2:
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			rLineSpace.SetPropLineSpace( 200 );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_PROP:
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			rLineSpace.SetPropLineSpace( (BYTE)lValue );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_MIN:
//STRIP001 			rLineSpace.SetLineHeight( (USHORT)lValue );
//STRIP001 			rLineSpace.GetInterLineSpaceRule() = SVX_INTER_LINE_SPACE_OFF;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_DURCH:
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			rLineSpace.SetInterLineSpace( (USHORT)lValue );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_FIX:
//STRIP001 			rLineSpace.SetLineHeight((USHORT)lValue);
//STRIP001 			rLineSpace.GetLineSpaceRule() = SVX_LINE_SPACE_FIX;
//STRIP001 			rLineSpace.GetInterLineSpaceRule() = SVX_INTER_LINE_SPACE_OFF;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 USHORT GetHtmlMode_Impl(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	USHORT nHtmlMode = 0;
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	SfxObjectShell* pShell;
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState(SID_HTML_MODE, FALSE, &pItem) ||
//STRIP001 		( 0 != (pShell = SfxObjectShell::Current()) &&
//STRIP001 					0 != (pItem = pShell->GetItem(SID_HTML_MODE))))
//STRIP001 	{
//STRIP001 		nHtmlMode = ((SfxUInt16Item*)pItem)->GetValue();
//STRIP001 	}
//STRIP001 	return nHtmlMode;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxStdParagraphTabPage ------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxStdParagraphTabPage, ELRLoseFocusHdl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 //! if ( aLeftIndent.IsRelativeMode() )
//STRIP001 //! 	return 0; //!!!
//STRIP001 
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit =
//STRIP001 		MapToFieldUnit( pPool->GetMetric( GetWhich( SID_ATTR_LRSPACE ) ) );
//STRIP001 
//STRIP001 	long nL = aLeftIndent.Denormalize( aLeftIndent.GetValue( eUnit ) );
//STRIP001 	long nR = aRightIndent.Denormalize( aRightIndent.GetValue( eUnit ) );
//STRIP001 	String aTmp = aFLineIndent.GetText();
//STRIP001 
//STRIP001 	// Erstzeilen Einzug
//STRIP001 	if( aLeftIndent.GetMin() < 0 )
//STRIP001 		aFLineIndent.SetMin( -99999, FUNIT_MM );
//STRIP001 	else
//STRIP001 		aFLineIndent.SetMin( aFLineIndent.Normalize( -nL ), eUnit );
//STRIP001 
//STRIP001 	// Check nur fuer konkrete Breite (Shell)
//STRIP001 	long nTmp = nWidth - nL - nR - MM50;
//STRIP001 	aFLineIndent.SetMax( aFLineIndent.Normalize( nTmp ), eUnit );
//STRIP001 
//STRIP001 	if ( !aTmp.Len() )
//STRIP001 		aFLineIndent.SetEmptyFieldValue();
//STRIP001 	// Maximum Links Rechts
//STRIP001 	aTmp = aLeftIndent.GetText();
//STRIP001 	nTmp = nWidth - nR - MM50;
//STRIP001 	aLeftIndent.SetMax( aLeftIndent.Normalize( nTmp ), eUnit );
//STRIP001 
//STRIP001 	if ( !aTmp.Len() )
//STRIP001 		aLeftIndent.SetEmptyFieldValue();
//STRIP001 	aTmp = aRightIndent.GetText();
//STRIP001 	nTmp = nWidth - nL - MM50;
//STRIP001 	aRightIndent.SetMax( aRightIndent.Normalize( nTmp ), eUnit );
//STRIP001 
//STRIP001 	if ( !aTmp.Len() )
//STRIP001 		aRightIndent.SetEmptyFieldValue();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxStdParagraphTabPage::Create( Window* pParent,
//STRIP001 											const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	return new SvxStdParagraphTabPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxStdParagraphTabPage::FillItemSet( SfxItemSet& rOutSet )
//STRIP001 {
//STRIP001 	SfxItemState eState = SFX_ITEM_UNKNOWN;
//STRIP001 	const SfxPoolItem* pOld = 0;
//STRIP001 	SfxItemPool* pPool = rOutSet.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	USHORT nWhich;
//STRIP001 	USHORT nPos = aLineDist.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( LISTBOX_ENTRY_NOTFOUND != nPos &&
//STRIP001 		 ( nPos != aLineDist.GetSavedValue() ||
//STRIP001 		   aLineDistAtPercentBox.IsValueModified() ||
//STRIP001 		   aLineDistAtMetricBox.IsValueModified() ) )
//STRIP001 	{
//STRIP001 		nWhich = GetWhich( SID_ATTR_PARA_LINESPACE );
//STRIP001 		SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 		SvxLineSpacingItem aSpacing(
//STRIP001 			(const SvxLineSpacingItem&)GetItemSet().Get( nWhich ) );
//STRIP001 
//STRIP001 		switch ( nPos )
//STRIP001 		{
//STRIP001 			case LLINESPACE_1:
//STRIP001 			case LLINESPACE_15:
//STRIP001 			case LLINESPACE_2:
//STRIP001 				SetLineSpace_Impl( aSpacing, nPos );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case LLINESPACE_PROP:
//STRIP001 				SetLineSpace_Impl( aSpacing, nPos,
//STRIP001 								   aLineDistAtPercentBox.Denormalize(
//STRIP001 								   aLineDistAtPercentBox.GetValue() ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case LLINESPACE_MIN:
//STRIP001 			case LLINESPACE_DURCH:
//STRIP001 			case LLINESPACE_FIX:
//STRIP001 				SetLineSpace_Impl( aSpacing, nPos,
//STRIP001 					GetCoreValue( aLineDistAtMetricBox, eUnit ) );
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "unbekannter Type fuer Zeilenabstand." );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		eState = GetItemSet().GetItemState( nWhich );
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_LINESPACE );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxLineSpacingItem*)pOld == aSpacing ) ||
//STRIP001 			 SFX_ITEM_DONTCARE == eState )
//STRIP001 		{
//STRIP001 			rOutSet.Put( aSpacing );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aTopDist.IsValueModified() || aBottomDist.IsValueModified() )
//STRIP001 	{
//STRIP001 		nWhich = GetWhich( SID_ATTR_ULSPACE );
//STRIP001 		SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_ULSPACE );
//STRIP001 		SvxULSpaceItem aMargin( nWhich );
//STRIP001 
//STRIP001 		if ( bRelativeMode )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( GetItemSet().GetParent(), "No ParentSet" );
//STRIP001 
//STRIP001 			const SvxULSpaceItem& rOldItem =
//STRIP001 				(const SvxULSpaceItem&)GetItemSet().GetParent()->Get( nWhich );
//STRIP001 
//STRIP001 			if ( aTopDist.IsRelative() )
//STRIP001 				aMargin.SetUpper( rOldItem.GetUpper(),
//STRIP001 								  (USHORT)aTopDist.GetValue() );
//STRIP001 			else
//STRIP001 				aMargin.SetUpper( (USHORT)GetCoreValue( aTopDist, eUnit ) );
//STRIP001 
//STRIP001 			if ( aBottomDist.IsRelative() )
//STRIP001 				aMargin.SetLower( rOldItem.GetLower(),
//STRIP001 								  (USHORT)aBottomDist.GetValue() );
//STRIP001 			else
//STRIP001 				aMargin.SetLower( (USHORT)GetCoreValue( aBottomDist, eUnit ) );
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aMargin.SetUpper( (USHORT)GetCoreValue( aTopDist, eUnit ) );
//STRIP001 			aMargin.SetLower( (USHORT)GetCoreValue( aBottomDist, eUnit ) );
//STRIP001 		}
//STRIP001 		eState = GetItemSet().GetItemState( nWhich );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxULSpaceItem*)pOld == aMargin ) ||
//STRIP001 			 SFX_ITEM_DONTCARE == eState )
//STRIP001 		{
//STRIP001 			rOutSet.Put( aMargin );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	FASTBOOL bNullTab = FALSE;
//STRIP001 
//STRIP001 	if ( aLeftIndent.IsValueModified() ||
//STRIP001 		 aFLineIndent.IsValueModified() ||
//STRIP001 		 aRightIndent.IsValueModified()
//STRIP001 		 ||	 aAutoCB.GetSavedValue() != aAutoCB.IsChecked() )
//STRIP001 	{
//STRIP001 		nWhich = GetWhich( SID_ATTR_LRSPACE );
//STRIP001 		SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 		SvxLRSpaceItem aMargin( nWhich );
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_LRSPACE );
//STRIP001 
//STRIP001 		if ( bRelativeMode )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( GetItemSet().GetParent(), "No ParentSet" );
//STRIP001 
//STRIP001 			const SvxLRSpaceItem& rOldItem =
//STRIP001 				(const SvxLRSpaceItem&)GetItemSet().GetParent()->Get( nWhich );
//STRIP001 
//STRIP001 			if ( aLeftIndent.IsRelative() )
//STRIP001 				aMargin.SetTxtLeft( rOldItem.GetTxtLeft(),
//STRIP001 									(USHORT)aLeftIndent.GetValue() );
//STRIP001 			else
//STRIP001 				aMargin.SetTxtLeft( GetCoreValue( aLeftIndent, eUnit ) );
//STRIP001 
//STRIP001 			if ( aRightIndent.IsRelative() )
//STRIP001 				aMargin.SetRight( rOldItem.GetRight(),
//STRIP001 								  (USHORT)aRightIndent.GetValue() );
//STRIP001 			else
//STRIP001 				aMargin.SetRight( GetCoreValue( aRightIndent, eUnit ) );
//STRIP001 
//STRIP001 			if ( aFLineIndent.IsRelative() )
//STRIP001 				aMargin.SetTxtFirstLineOfst( rOldItem.GetTxtFirstLineOfst(),
//STRIP001 											 (USHORT)aFLineIndent.GetValue() );
//STRIP001 			else
//STRIP001 				aMargin.SetTxtFirstLineOfst(
//STRIP001 					(USHORT)GetCoreValue( aFLineIndent, eUnit ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aMargin.SetTxtLeft( GetCoreValue( aLeftIndent, eUnit ) );
//STRIP001 			aMargin.SetRight( GetCoreValue( aRightIndent, eUnit ) );
//STRIP001 			aMargin.SetTxtFirstLineOfst(
//STRIP001 				(USHORT)GetCoreValue( aFLineIndent, eUnit ) );
//STRIP001 		}
//STRIP001 		aMargin.SetAutoFirst(aAutoCB.IsChecked());
//STRIP001 		if ( aMargin.GetTxtFirstLineOfst() < 0 )
//STRIP001 			bNullTab = TRUE;
//STRIP001 		eState = GetItemSet().GetItemState( nWhich );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxLRSpaceItem*)pOld == aMargin ) ||
//STRIP001 			 SFX_ITEM_DONTCARE == eState )
//STRIP001 		{
//STRIP001 			rOutSet.Put( aMargin );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bNullTab )
//STRIP001 	{
//STRIP001 		MapUnit eUnit = (MapUnit)pPool->GetMetric( GetWhich( SID_ATTR_TABSTOP ) );
//STRIP001 		if ( MAP_100TH_MM != eUnit )
//STRIP001 		{
//STRIP001 
//STRIP001 			// negativer Erstzeileneinzug -> ggf. Null Default-Tabstop setzen
//STRIP001 			USHORT nWhich = GetWhich( SID_ATTR_TABSTOP );
//STRIP001 			const SfxItemSet& rInSet = GetItemSet();
//STRIP001 
//STRIP001 			if ( rInSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 			{
//STRIP001 				const SvxTabStopItem& rTabItem =
//STRIP001 					(const SvxTabStopItem&)rInSet.Get( nWhich );
//STRIP001 				SvxTabStopItem aNullTab( rTabItem );
//STRIP001 				SvxTabStop aNull( 0, SVX_TAB_ADJUST_DEFAULT );
//STRIP001 				aNullTab.Insert( aNull );
//STRIP001 				rOutSet.Put( aNullTab );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( aRegisterCB.IsVisible())
//STRIP001 	{
//STRIP001 		const SfxBoolItem* pBoolItem = (SfxBoolItem*)GetOldItem(
//STRIP001 							rOutSet, SID_ATTR_PARA_REGISTER);
//STRIP001 		SfxBoolItem* pRegItem = (SfxBoolItem*)pBoolItem->Clone();
//STRIP001 		USHORT nWhich = GetWhich( SID_ATTR_PARA_REGISTER );
//STRIP001 		BOOL bSet = pRegItem->GetValue();
//STRIP001 
//STRIP001 		if(aRegisterCB.IsChecked() != bSet )
//STRIP001 		{
//STRIP001 			pRegItem->SetValue(!bSet);
//STRIP001 			rOutSet.Put(*pRegItem);
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 		else if ( SFX_ITEM_DEFAULT == GetItemSet().GetItemState( nWhich, FALSE ) )
//STRIP001 			rOutSet.ClearItem(nWhich);
//STRIP001 		delete pRegItem;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	String aEmpty;
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rSet );
//STRIP001 	SetFieldUnit( aLeftIndent, eFUnit );
//STRIP001 	SetFieldUnit( aRightIndent, eFUnit );
//STRIP001 	SetFieldUnit( aFLineIndent, eFUnit );
//STRIP001 	SetFieldUnit( aTopDist, eFUnit );
//STRIP001 	SetFieldUnit( aBottomDist, eFUnit );
//STRIP001 	SetFieldUnit( aLineDistAtMetricBox, eFUnit );
//STRIP001 
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_LRSPACE );
//STRIP001 	SfxItemState eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 
//STRIP001 		if ( bRelativeMode )
//STRIP001 		{
//STRIP001 			const SvxLRSpaceItem& rOldItem =
//STRIP001 				(const SvxLRSpaceItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 			if ( rOldItem.GetPropLeft() != 100 )
//STRIP001 			{
//STRIP001 				aLeftIndent.SetRelative( TRUE );
//STRIP001 				aLeftIndent.SetValue( rOldItem.GetPropLeft() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aLeftIndent.SetRelative();
//STRIP001 				SetFieldUnit( aLeftIndent, eFUnit );
//STRIP001 				SetMetricValue( aLeftIndent, rOldItem.GetTxtLeft(), eUnit );
//STRIP001             }
//STRIP001 
//STRIP001 			if ( rOldItem.GetPropRight() != 100 )
//STRIP001 			{
//STRIP001 				aRightIndent.SetRelative( TRUE );
//STRIP001 				aRightIndent.SetValue( rOldItem.GetPropRight() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aRightIndent.SetRelative();
//STRIP001 				SetFieldUnit( aRightIndent, eFUnit );
//STRIP001 				SetMetricValue( aRightIndent, rOldItem.GetRight(), eUnit );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( rOldItem.GetPropTxtFirstLineOfst() != 100 )
//STRIP001 			{
//STRIP001 				aFLineIndent.SetRelative( TRUE );
//STRIP001 				aFLineIndent.SetValue( rOldItem.GetPropTxtFirstLineOfst() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aFLineIndent.SetRelative();
//STRIP001 				aFLineIndent.SetMin(-9999);
//STRIP001 				SetFieldUnit( aFLineIndent, eFUnit );
//STRIP001 				SetMetricValue( aFLineIndent, rOldItem.GetTxtFirstLineOfst(),
//STRIP001 								eUnit );
//STRIP001 			}
//STRIP001 			aAutoCB.Check(rOldItem.IsAutoFirst());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SvxLRSpaceItem& rSpace =
//STRIP001 				(const SvxLRSpaceItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 			SetMetricValue( aLeftIndent, rSpace.GetTxtLeft(), eUnit );
//STRIP001 			SetMetricValue( aRightIndent, rSpace.GetRight(), eUnit );
//STRIP001 			SetMetricValue( aFLineIndent, rSpace.GetTxtFirstLineOfst(), eUnit );
//STRIP001 			aAutoCB.Check(rSpace.IsAutoFirst());
//STRIP001 		}
//STRIP001 		AutoHdl_Impl(&aAutoCB);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLeftIndent.SetEmptyFieldValue();
//STRIP001 		aRightIndent.SetEmptyFieldValue();
//STRIP001 		aFLineIndent.SetEmptyFieldValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_ULSPACE );
//STRIP001 	eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 
//STRIP001 		if ( bRelativeMode )
//STRIP001 		{
//STRIP001 			const SvxULSpaceItem& rOldItem =
//STRIP001 				(const SvxULSpaceItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 			if ( rOldItem.GetPropUpper() != 100 )
//STRIP001 			{
//STRIP001 				aTopDist.SetRelative( TRUE );
//STRIP001 				aTopDist.SetValue( rOldItem.GetPropUpper() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aTopDist.SetRelative();
//STRIP001 				SetFieldUnit( aTopDist, eFUnit );
//STRIP001 				SetMetricValue( aTopDist, rOldItem.GetUpper(), eUnit );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( rOldItem.GetPropLower() != 100 )
//STRIP001 			{
//STRIP001 				aBottomDist.SetRelative( TRUE );
//STRIP001 				aBottomDist.SetValue( rOldItem.GetPropLower() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aBottomDist.SetRelative();
//STRIP001 				SetFieldUnit( aBottomDist, eFUnit );
//STRIP001 				SetMetricValue( aBottomDist, rOldItem.GetLower(), eUnit );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SvxULSpaceItem& rTopMargin =
//STRIP001 				(const SvxULSpaceItem&)rSet.Get( nWhich );
//STRIP001 			SetMetricValue( aTopDist, rTopMargin.GetUpper(), eUnit );
//STRIP001 			SetMetricValue( aBottomDist, rTopMargin.GetLower(), eUnit );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTopDist.SetEmptyFieldValue();
//STRIP001 		aBottomDist.SetEmptyFieldValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_LINESPACE );
//STRIP001 	eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 		SetLineSpacing_Impl( (const SvxLineSpacingItem &)rSet.Get( nWhich ) );
//STRIP001 	else
//STRIP001 		aLineDist.SetNoSelection();
//STRIP001 
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_REGISTER );
//STRIP001 	eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 		aRegisterCB.Check( ((const SfxBoolItem &)rSet.Get( nWhich )).GetValue());
//STRIP001 	aRegisterCB.SaveValue();
//STRIP001 	USHORT nHtmlMode = GetHtmlMode_Impl(rSet);
//STRIP001 	if(nHtmlMode & HTMLMODE_ON)
//STRIP001 	{
//STRIP001 		aRegisterCB.Hide();
//STRIP001         aRegisterFL.Hide();
//STRIP001 		aAutoCB.Hide();
//STRIP001 		if(!(nHtmlMode & HTMLMODE_SOME_STYLES)) // IE oder SW
//STRIP001 		{
//STRIP001 			aRightLabel.Disable();
//STRIP001 			aRightIndent.Disable();
//STRIP001 			aTopDist.Disable();  //HTML3.2 und NS 3.0
//STRIP001 			aBottomDist.Disable();
//STRIP001 			if(!(nHtmlMode & HTMLMODE_FIRSTLINE)) //NS 3.0
//STRIP001 			{
//STRIP001 				aFLineIndent.Disable();
//STRIP001 				aFLineLabel.Disable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ELRLoseFocusHdl( NULL );
//STRIP001 	aAutoCB.SaveValue();
//STRIP001 	aLineDist.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::EnableRelativeMode()
//STRIP001 {
//STRIP001 	DBG_ASSERT( GetItemSet().GetParent(), "RelativeMode, but no parent-set!" );
//STRIP001 
//STRIP001 	aLeftIndent.EnableRelativeMode( 0, 999 );
//STRIP001 	aFLineIndent.EnableRelativeMode( 0, 999 );
//STRIP001 	aRightIndent.EnableRelativeMode( 0, 999 );
//STRIP001 	aTopDist.EnableRelativeMode( 0, 999 );
//STRIP001 	aBottomDist.EnableRelativeMode( 0, 999 );
//STRIP001 	bRelativeMode = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxStdParagraphTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	ELRLoseFocusHdl( NULL );
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxStdParagraphTabPage::SvxStdParagraphTabPage( Window* pParent,
//STRIP001 												const SfxItemSet& rAttr ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( RID_SVXPAGE_STD_PARAGRAPH, DIALOG_MGR() ), rAttr ),
//STRIP001 
//STRIP001 	aLeftLabel              ( this, ResId( FT_LEFTINDENT ) ),
//STRIP001 	aLeftIndent             ( this, ResId( ED_LEFTINDENT ) ),
//STRIP001 	aFLineLabel             ( this, ResId( FT_FLINEINDENT ) ),
//STRIP001 	aFLineIndent            ( this, ResId( ED_FLINEINDENT ) ),
//STRIP001 	aAutoCB                 ( this, ResId( CB_AUTO ) ),
//STRIP001 	aRightLabel             ( this, ResId( FT_RIGHTINDENT ) ),
//STRIP001 	aRightIndent            ( this, ResId( ED_RIGHTINDENT ) ),
//STRIP001     aIndentFrm              ( this, ResId( FL_INDENT ) ),
//STRIP001 	aTopLabel               ( this, ResId( FT_TOPDIST ) ),
//STRIP001 	aTopDist                ( this, ResId( ED_TOPDIST ) ),
//STRIP001 	aBottomLabel            ( this, ResId( FT_BOTTOMDIST ) ),
//STRIP001 	aBottomDist             ( this, ResId( ED_BOTTOMDIST ) ),
//STRIP001     aDistFrm                ( this, ResId( FL_DIST ) ),
//STRIP001 	aLineDist               ( this, ResId( LB_LINEDIST ) ),
//STRIP001 	aLineDistAtLabel        ( this, ResId( FT_LINEDIST ) ),
//STRIP001 	aLineDistAtPercentBox   ( this, ResId( ED_LINEDISTPERCENT ) ),
//STRIP001 	aLineDistAtMetricBox    ( this, ResId( ED_LINEDISTMETRIC ) ),
//STRIP001     aLineDistFrm            ( this, ResId( FL_LINEDIST ) ),
//STRIP001 	aExampleWin				( this, ResId( WN_EXAMPLE ) ),
//STRIP001 	aRegisterCB             ( this, ResId( CB_REGISTER ) ),
//STRIP001     aRegisterFL             ( this, ResId( FL_REGISTER ) ),
//STRIP001 	sAbsDist				( ResId(ST_LINEDIST_ABS) ),
//STRIP001 	nMinFixDist(0L),
//STRIP001 
//STRIP001 	nAbst           ( MAX_DURCH ),
//STRIP001 	nWidth          ( 11905 /*567 * 50*/ ),
//STRIP001 	pActLineDistFld ( &aLineDistAtPercentBox ),
//STRIP001     bRelativeMode   ( FALSE ),
//STRIP001     bNegativeIndents(FALSE)
//STRIP001 
//STRIP001 {
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	aLineDistAtMetricBox.Hide();
//STRIP001     FreeResource();
//STRIP001 	Init_Impl();
//STRIP001 	aFLineIndent.SetMin(-9999);	// wird default auf 0 gesetzt
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::EnableNegativeMode()
//STRIP001 {
//STRIP001  	aLeftIndent.SetMin(-9999);
//STRIP001 	aRightIndent.SetMin(-9999);
//STRIP001 #if SUPD>629
//STRIP001     aRightIndent.EnableNegativeMode();
//STRIP001     aLeftIndent.EnableNegativeMode();
//STRIP001 #endif
//STRIP001     bNegativeIndents = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxStdParagraphTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pStdRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::SetLineSpacing_Impl
//STRIP001 (
//STRIP001 	const SvxLineSpacingItem &rAttr
//STRIP001 )
//STRIP001 {
//STRIP001 	SfxMapUnit eUnit = GetItemSet().GetPool()->GetMetric( rAttr.Which() );
//STRIP001 
//STRIP001 	switch( rAttr.GetLineSpaceRule() )
//STRIP001 	{
//STRIP001 		case SVX_LINE_SPACE_AUTO:
//STRIP001 		{
//STRIP001 			SvxInterLineSpace eInter = rAttr.GetInterLineSpaceRule();
//STRIP001 
//STRIP001 			switch( eInter )
//STRIP001 			{
//STRIP001 				// Default einzeilig
//STRIP001 				case SVX_INTER_LINE_SPACE_OFF:
//STRIP001 					aLineDist.SelectEntryPos( LLINESPACE_1 );
//STRIP001 					break;
//STRIP001 
//STRIP001 				// Default einzeilig
//STRIP001 				case SVX_INTER_LINE_SPACE_PROP:
//STRIP001 					if ( 100 == rAttr.GetPropLineSpace() )
//STRIP001 					{
//STRIP001 						aLineDist.SelectEntryPos( LLINESPACE_1 );
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					// 1.5zeilig
//STRIP001 					if ( 150 == rAttr.GetPropLineSpace() )
//STRIP001 					{
//STRIP001 						aLineDist.SelectEntryPos( LLINESPACE_15 );
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					// 2zeilig
//STRIP001 					if ( 200 == rAttr.GetPropLineSpace() )
//STRIP001 					{
//STRIP001 						aLineDist.SelectEntryPos( LLINESPACE_2 );
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					// eingestellter Prozentwert
//STRIP001 					aLineDistAtPercentBox.
//STRIP001 						SetValue( aLineDistAtPercentBox.Normalize(
//STRIP001 										rAttr.GetPropLineSpace() ) );
//STRIP001 					aLineDist.SelectEntryPos( LLINESPACE_PROP );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SVX_INTER_LINE_SPACE_FIX:
//STRIP001 					SetMetricValue( aLineDistAtMetricBox,
//STRIP001 									rAttr.GetInterLineSpace(), eUnit );
//STRIP001 					aLineDist.SelectEntryPos( LLINESPACE_DURCH );
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SVX_LINE_SPACE_FIX:
//STRIP001 			SetMetricValue(aLineDistAtMetricBox, rAttr.GetLineHeight(), eUnit);
//STRIP001 			aLineDist.SelectEntryPos( LLINESPACE_FIX );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_LINE_SPACE_MIN:
//STRIP001 			SetMetricValue(aLineDistAtMetricBox, rAttr.GetLineHeight(), eUnit);
//STRIP001 			aLineDist.SelectEntryPos( LLINESPACE_MIN );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	LineDistHdl_Impl( &aLineDist );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxStdParagraphTabPage, LineDistHdl_Impl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	switch( pBox->GetSelectEntryPos() )
//STRIP001 	{
//STRIP001 		case LLINESPACE_1:
//STRIP001 		case LLINESPACE_15:
//STRIP001 		case LLINESPACE_2:
//STRIP001 			aLineDistAtLabel.Enable(FALSE);
//STRIP001 			pActLineDistFld->Enable(FALSE);
//STRIP001 			pActLineDistFld->SetText( String() );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_DURCH:
//STRIP001 			// Setzen eines sinnvollen Defaults?
//STRIP001 			// MS Begrenzen min(10, aPageSize)
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld = &aLineDistAtMetricBox;
//STRIP001 			aLineDistAtMetricBox.SetMin(0);
//STRIP001 
//STRIP001 
//STRIP001 			if ( !aLineDistAtMetricBox.GetText().Len() )
//STRIP001 				aLineDistAtMetricBox.SetValue(
//STRIP001 					aLineDistAtMetricBox.Normalize( 1 ) );
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld->Show();
//STRIP001 			pActLineDistFld->Enable();
//STRIP001 			aLineDistAtLabel.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_MIN:
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld = &aLineDistAtMetricBox;
//STRIP001 			aLineDistAtMetricBox.SetMin(0);
//STRIP001 
//STRIP001 			if ( !aLineDistAtMetricBox.GetText().Len() )
//STRIP001 				aLineDistAtMetricBox.SetValue(
//STRIP001 					aLineDistAtMetricBox.Normalize( 10 ), FUNIT_TWIP );
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld->Show();
//STRIP001 			pActLineDistFld->Enable();
//STRIP001 			aLineDistAtLabel.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_PROP:
//STRIP001 			aLineDistAtMetricBox.Hide();
//STRIP001 			pActLineDistFld = &aLineDistAtPercentBox;
//STRIP001 
//STRIP001 			if ( !aLineDistAtPercentBox.GetText().Len() )
//STRIP001 				aLineDistAtPercentBox.SetValue(
//STRIP001 					aLineDistAtPercentBox.Normalize( 100 ), FUNIT_TWIP );
//STRIP001 			aLineDistAtMetricBox.Hide();
//STRIP001 			pActLineDistFld->Show();
//STRIP001 			pActLineDistFld->Enable();
//STRIP001 			aLineDistAtLabel.Enable();
//STRIP001 			break;
//STRIP001 		case LLINESPACE_FIX:
//STRIP001 		{
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld = &aLineDistAtMetricBox;
//STRIP001 			long nTemp = aLineDistAtMetricBox.GetValue();
//STRIP001 			aLineDistAtMetricBox.SetMin(aLineDistAtMetricBox.Normalize(nMinFixDist), FUNIT_TWIP);
//STRIP001 
//STRIP001 			// wurde der Wert beim SetMin veraendert, dann ist es Zeit
//STRIP001 			// fuer den default
//STRIP001 			if ( aLineDistAtMetricBox.GetValue() != nTemp )
//STRIP001 				SetMetricValue( aLineDistAtMetricBox,
//STRIP001 									FIX_DIST_DEF, SFX_MAPUNIT_TWIP ); // fix gibt's nur im Writer
//STRIP001 			aLineDistAtPercentBox.Hide();
//STRIP001 			pActLineDistFld->Show();
//STRIP001 			pActLineDistFld->Enable();
//STRIP001 			aLineDistAtLabel.Enable();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	UpdateExample_Impl( TRUE );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxStdParagraphTabPage, ModifyHdl_Impl, SvxRelativeField *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdateExample_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxStdParagraphTabPage, ModifyHdl_Impl, SvxRelativeField *, EMPTYARG )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::Init_Impl()
//STRIP001 {
//STRIP001 	aLineDist.SetSelectHdl(
//STRIP001 		LINK( this, SvxStdParagraphTabPage, LineDistHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxStdParagraphTabPage, ELRLoseFocusHdl );
//STRIP001 	aFLineIndent.SetLoseFocusHdl( aLink );
//STRIP001 	aLeftIndent.SetLoseFocusHdl( aLink );
//STRIP001 	aRightIndent.SetLoseFocusHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxStdParagraphTabPage, ModifyHdl_Impl );
//STRIP001 	aFLineIndent.SetModifyHdl( aLink );
//STRIP001 	aLeftIndent.SetModifyHdl( aLink );
//STRIP001 	aRightIndent.SetModifyHdl( aLink );
//STRIP001 	aTopDist.SetModifyHdl( aLink );
//STRIP001 	aBottomDist.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	aAutoCB.SetClickHdl( LINK( this, SvxStdParagraphTabPage, AutoHdl_Impl ));
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit =
//STRIP001 		MapToFieldUnit( pPool->GetMetric( GetWhich( SID_ATTR_LRSPACE ) ) );
//STRIP001 
//STRIP001 	aTopDist.SetMax( aTopDist.Normalize( nAbst ), eUnit );
//STRIP001 	aBottomDist.SetMax( aBottomDist.Normalize( nAbst ), eUnit );
//STRIP001 	aLineDistAtMetricBox.SetMax(
//STRIP001 		aLineDistAtMetricBox.Normalize( nAbst ), eUnit );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::UpdateExample_Impl( BOOL bAll )
//STRIP001 {
//STRIP001 	aExampleWin.SetFirstLineOfst(
//STRIP001 		(short)aFLineIndent.Denormalize( aFLineIndent.GetValue( FUNIT_TWIP ) ) );
//STRIP001 	aExampleWin.SetLeftMargin(
//STRIP001 		aLeftIndent.Denormalize( aLeftIndent.GetValue( FUNIT_TWIP ) ) );
//STRIP001 	aExampleWin.SetRightMargin(
//STRIP001 		aRightIndent.Denormalize( aRightIndent.GetValue( FUNIT_TWIP ) ) );
//STRIP001 	aExampleWin.SetUpper(
//STRIP001 		(USHORT)aTopDist.Denormalize( aTopDist.GetValue( FUNIT_TWIP ) ) );
//STRIP001 	aExampleWin.SetLower(
//STRIP001 		(USHORT)aBottomDist.Denormalize( aBottomDist.GetValue( FUNIT_TWIP ) ) );
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	USHORT nPos = aLineDist.GetSelectEntryPos();
//STRIP001 
//STRIP001 	switch ( nPos )
//STRIP001 	{
//STRIP001 		case LLINESPACE_1:
//STRIP001 		case LLINESPACE_15:
//STRIP001 		case LLINESPACE_2:
//STRIP001 			aExampleWin.SetLineSpace( (SvxPrevLineSpace)nPos );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_PROP:
//STRIP001 			aExampleWin.SetLineSpace( (SvxPrevLineSpace)nPos,
//STRIP001 				(USHORT)aLineDistAtPercentBox.Denormalize(
//STRIP001 				aLineDistAtPercentBox.GetValue() ) );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LLINESPACE_MIN:
//STRIP001 		case LLINESPACE_DURCH:
//STRIP001 		case LLINESPACE_FIX:
//STRIP001 			aExampleWin.SetLineSpace( (SvxPrevLineSpace)nPos,
//STRIP001 				(USHORT)GetCoreValue( aLineDistAtMetricBox, SFX_MAPUNIT_TWIP ) );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	aExampleWin.Draw( bAll );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxStdParagraphTabPage::EnableRegisterMode()
//STRIP001 {
//STRIP001 	aRegisterCB.Show();
//STRIP001     aRegisterFL.Show();
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.54-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxStdParagraphTabPage, AutoHdl_Impl, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	BOOL bEnable = !pBox->IsChecked();
//STRIP001 	aFLineLabel .Enable(bEnable);
//STRIP001 	aFLineIndent.Enable(bEnable);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 18.00-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SvxStdParagraphTabPage::SetPageWidth( USHORT nPageWidth )
//STRIP001 {
//STRIP001 	nWidth = nPageWidth;
//STRIP001 }
//STRIP001 /*-----------------16.01.97 18.01-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SvxStdParagraphTabPage::SetMaxDistance( USHORT nMaxDist )
//STRIP001 {
//STRIP001 	nAbst = nMaxDist;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------17.01.97 08.11-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SvxStdParagraphTabPage::EnableAutoFirstLine()
//STRIP001 {
//STRIP001 	aAutoCB.Show();
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------11.06.97 11.48-------------------
//STRIP001 	absoluter Zeilenabstand
//STRIP001 --------------------------------------------------*/
//STRIP001 void	SvxStdParagraphTabPage::EnableAbsLineDist(long nMinTwip)
//STRIP001 {
//STRIP001 	aLineDist.InsertEntry(sAbsDist);
//STRIP001 	nMinFixDist = nMinTwip;
//STRIP001 }
//STRIP001 
//STRIP001 #define LASTLINEPOS_DEFAULT		0
//STRIP001 #define LASTLINEPOS_LEFT		1
//STRIP001 
//STRIP001 #define LASTLINECOUNT_OLD		3
//STRIP001 #define LASTLINECOUNT_NEW		4
//STRIP001 
//STRIP001 // class SvxParaAlignTabPage ------------------------------------------------
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.34-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 SvxParaAlignTabPage::SvxParaAlignTabPage( Window* pParent, const SfxItemSet& rSet )
//STRIP001 	: SfxTabPage(pParent, ResId( RID_SVXPAGE_ALIGN_PARAGRAPH, DIALOG_MGR() ),rSet),
//STRIP001 	aLeft				( this, ResId( BTN_LEFTALIGN ) ),
//STRIP001 	aRight				( this, ResId( BTN_RIGHTALIGN ) ),
//STRIP001 	aCenter				( this, ResId( BTN_CENTERALIGN ) ),
//STRIP001 	aJustify			( this, ResId( BTN_JUSTIFYALIGN ) ),
//STRIP001 	aAlignFrm			( this, ResId( FL_ALIGN ) ),
//STRIP001 	aLastLineFT			( this, ResId( FT_LASTLINE ) ),
//STRIP001 	aLastLineLB			( this, ResId( LB_LASTLINE ) ),
//STRIP001 	aExpandCB			( this, ResId( CB_EXPAND ) ),
//STRIP001 	aSnapToGridCB		( this, ResId( CB_SNAP ) ),
//STRIP001 	aExampleWin			( this, ResId( WN_EXAMPLE ) ),
//STRIP001 
//STRIP001 	aVertAlignFL		( this, ResId( FL_VERTALIGN ) ),
//STRIP001 	aVertAlignFT		( this, ResId( FT_VERTALIGN ) ),
//STRIP001 	aVertAlignLB		( this, ResId( LB_VERTALIGN ) ),
//STRIP001 
//STRIP001 	aPropertiesFL		( this, ResId( FL_PROPERTIES    )),
//STRIP001 	aTextDirectionFT	( this, ResId( FT_TEXTDIRECTION )),
//STRIP001 	aTextDirectionLB	( this, ResId( LB_TEXTDIRECTION ))
//STRIP001 {
//STRIP001 	SvtLanguageOptions aLangOptions;
//STRIP001 	USHORT nLastLinePos = LASTLINEPOS_DEFAULT;
//STRIP001 
//STRIP001 	if ( aLangOptions.IsAsianTypographyEnabled() || aLangOptions.IsCTLFontEnabled() )
//STRIP001 	{
//STRIP001 		String sLeft(ResId(ST_LEFTALIGN_ASIAN));
//STRIP001 		aLeft.SetText(sLeft);
//STRIP001 		aRight.SetText(String(ResId(ST_RIGHTALIGN_ASIAN)));
//STRIP001 		sLeft.EraseAllChars( '~' );
//STRIP001 
//STRIP001 		if ( aLastLineLB.GetEntryCount() == LASTLINECOUNT_OLD )
//STRIP001 		{
//STRIP001 			aLastLineLB.RemoveEntry( 0 );
//STRIP001 			aLastLineLB.InsertEntry( sLeft, 0 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nLastLinePos = LASTLINEPOS_LEFT;
//STRIP001 	}
//STRIP001 	// remove "Default" or "Left" entry, depends on CJKOptions
//STRIP001 	if ( aLastLineLB.GetEntryCount() == LASTLINECOUNT_NEW )
//STRIP001 		aLastLineLB.RemoveEntry( nLastLinePos );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 	Link aLink = LINK( this, SvxParaAlignTabPage, AlignHdl_Impl );
//STRIP001 	aLeft.SetClickHdl( aLink );
//STRIP001 	aRight.SetClickHdl( aLink );
//STRIP001 	aCenter.SetClickHdl( aLink );
//STRIP001 	aJustify.SetClickHdl( aLink );
//STRIP001 	aLastLineLB.SetSelectHdl( LINK( this, SvxParaAlignTabPage, LastLineHdl_Impl ) );
//STRIP001 	aTextDirectionLB.SetSelectHdl( LINK( this, SvxParaAlignTabPage, TextDirectionHdl_Impl ) );
//STRIP001 
//STRIP001     USHORT nHtmlMode = GetHtmlMode_Impl(rSet);
//STRIP001     if(!(nHtmlMode & HTMLMODE_ON) || (0 != (nHtmlMode & HTMLMODE_SOME_STYLES)) )
//STRIP001     {
//STRIP001         SvtLanguageOptions	aLangOptions;
//STRIP001         if( aLangOptions.IsCTLFontEnabled() )
//STRIP001         {
//STRIP001             aTextDirectionLB.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_LTR ), FRMDIR_HORI_LEFT_TOP );
//STRIP001             aTextDirectionLB.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_RTL ), FRMDIR_HORI_RIGHT_TOP );
//STRIP001             aTextDirectionLB.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_FRAMEDIR_SUPER ), FRMDIR_ENVIRONMENT );
//STRIP001 
//STRIP001             aPropertiesFL.Show();
//STRIP001             aTextDirectionFT.Show();
//STRIP001             aTextDirectionLB.Show();
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 SvxParaAlignTabPage::~SvxParaAlignTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 int	SvxParaAlignTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 SfxTabPage*	SvxParaAlignTabPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxParaAlignTabPage(pParent, rSet);
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 USHORT*	SvxParaAlignTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pAlignRanges;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 BOOL SvxParaAlignTabPage::FillItemSet( SfxItemSet& rOutSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	FASTBOOL bAdj = FALSE, bChecked = FALSE;
//STRIP001 	SvxAdjust eAdjust = SVX_ADJUST_LEFT;
//STRIP001 
//STRIP001 	if ( aLeft.IsChecked() )
//STRIP001 	{
//STRIP001 		eAdjust = SVX_ADJUST_LEFT;
//STRIP001 		bAdj = !aLeft.GetSavedValue();
//STRIP001 		bChecked = TRUE;
//STRIP001 	}
//STRIP001 	else if ( aRight.IsChecked() )
//STRIP001 	{
//STRIP001 		eAdjust = SVX_ADJUST_RIGHT;
//STRIP001 		bAdj = !aRight.GetSavedValue();
//STRIP001 		bChecked = TRUE;
//STRIP001 	}
//STRIP001 	else if ( aCenter.IsChecked() )
//STRIP001 	{
//STRIP001 		eAdjust = SVX_ADJUST_CENTER;
//STRIP001 		bAdj = !aCenter.GetSavedValue();
//STRIP001 		bChecked = TRUE;
//STRIP001 	}
//STRIP001 	else if ( aJustify.IsChecked() )
//STRIP001 	{
//STRIP001 		eAdjust = SVX_ADJUST_BLOCK;
//STRIP001 		bAdj = !aJustify.GetSavedValue() ||
//STRIP001 			aExpandCB.IsChecked() != aExpandCB.GetSavedValue() ||
//STRIP001 			aLastLineLB.GetSelectEntryPos() != aLastLineLB.GetSavedValue();
//STRIP001 		bChecked = TRUE;
//STRIP001 	}
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PARA_ADJUST );
//STRIP001 
//STRIP001 	if ( bAdj )
//STRIP001 	{
//STRIP001 		const SvxAdjustItem* pOld =
//STRIP001 			(const SvxAdjustItem*)GetOldItem( rOutSet, SID_ATTR_PARA_ADJUST );
//STRIP001 		SvxAdjust eOneWord = aExpandCB.IsChecked() ? SVX_ADJUST_BLOCK
//STRIP001 												   : SVX_ADJUST_LEFT;
//STRIP001 		USHORT nLBPos = aLastLineLB.GetSelectEntryPos();
//STRIP001 		SvxAdjust eLastBlock = SVX_ADJUST_LEFT;
//STRIP001 
//STRIP001 		if ( 1 == nLBPos )
//STRIP001 			eLastBlock = SVX_ADJUST_CENTER;
//STRIP001 		else if ( 2 == nLBPos )
//STRIP001 			eLastBlock = SVX_ADJUST_BLOCK;
//STRIP001 
//STRIP001 		FASTBOOL bNothingWasChecked =
//STRIP001 			!aLeft.GetSavedValue() && !aRight.GetSavedValue() &&
//STRIP001 			!aCenter.GetSavedValue() && !aJustify.GetSavedValue();
//STRIP001 
//STRIP001 		if ( !pOld || pOld->GetAdjust() != eAdjust ||
//STRIP001 			 pOld->GetOneWord() != eOneWord ||
//STRIP001 			 pOld->GetLastBlock() != eLastBlock ||
//STRIP001 			 ( bChecked && bNothingWasChecked ) )
//STRIP001 		{
//STRIP001 			bModified |= TRUE;
//STRIP001 			SvxAdjustItem aAdj(
//STRIP001 				(const SvxAdjustItem&)GetItemSet().Get( nWhich ) );
//STRIP001 			aAdj.SetAdjust( eAdjust );
//STRIP001 			aAdj.SetOneWord( eOneWord );
//STRIP001 			aAdj.SetLastBlock( eLastBlock );
//STRIP001 			rOutSet.Put( aAdj );
//STRIP001 		}
//STRIP001 	}
//STRIP001     if(aSnapToGridCB.IsChecked() != aSnapToGridCB.GetSavedValue())
//STRIP001     {
//STRIP001         USHORT nWhich = GetWhich( SID_ATTR_PARA_SNAPTOGRID );
//STRIP001         rOutSet.Put(SvxParaGridItem(aSnapToGridCB.IsChecked(), nWhich));
//STRIP001         bModified = TRUE;
//STRIP001     }
//STRIP001     if(aVertAlignLB.GetSavedValue() != aVertAlignLB.GetSelectEntryPos())
//STRIP001     {
//STRIP001         USHORT nWhich = GetWhich( SID_PARA_VERTALIGN );
//STRIP001         rOutSet.Put(SvxParaVertAlignItem(aVertAlignLB.GetSelectEntryPos(), nWhich));
//STRIP001         bModified = TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     if( aTextDirectionLB.IsVisible() )
//STRIP001 	{
//STRIP001         SvxFrameDirection eDir = aTextDirectionLB.GetSelectEntryValue();
//STRIP001         if( eDir != aTextDirectionLB.GetSavedValue() )
//STRIP001 		{
//STRIP001             rOutSet.Put( SvxFrameDirectionItem( eDir, GetWhich( SID_ATTR_FRAMEDIRECTION ) ) );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SvxParaAlignTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PARA_ADJUST );
//STRIP001 	SfxItemState eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	USHORT nLBSelect = 0;
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SvxAdjustItem& rAdj = (const SvxAdjustItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 		switch ( rAdj.GetAdjust() /*!!! VB fragen rAdj.GetLastBlock()*/ )
//STRIP001 		{
//STRIP001 			case SVX_ADJUST_LEFT: aLeft.Check(); break;
//STRIP001 
//STRIP001 			case SVX_ADJUST_RIGHT: aRight.Check(); break;
//STRIP001 
//STRIP001 			case SVX_ADJUST_CENTER: aCenter.Check(); break;
//STRIP001 
//STRIP001 			case SVX_ADJUST_BLOCK: aJustify.Check(); break;
//STRIP001 		}
//STRIP001 		BOOL bEnable = aJustify.IsChecked();
//STRIP001 		aLastLineFT.Enable(bEnable);
//STRIP001 		aLastLineLB.Enable(bEnable);
//STRIP001 		aExpandCB  .Enable(bEnable);
//STRIP001 
//STRIP001 		aExpandCB.Check(SVX_ADJUST_BLOCK == rAdj.GetOneWord());
//STRIP001 		switch(rAdj.GetLastBlock())
//STRIP001 		{
//STRIP001 			case SVX_ADJUST_LEFT:  nLBSelect = 0; break;
//STRIP001 
//STRIP001 			case SVX_ADJUST_CENTER: nLBSelect = 1;  break;
//STRIP001 
//STRIP001 			case SVX_ADJUST_BLOCK: nLBSelect = 2;  break;
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLeft.Check( FALSE );
//STRIP001 		aRight.Check( FALSE );
//STRIP001 		aCenter.Check( FALSE );
//STRIP001 		aJustify.Check( FALSE );
//STRIP001 	}
//STRIP001 	aLastLineLB.SelectEntryPos(nLBSelect);
//STRIP001 
//STRIP001 	USHORT nHtmlMode = GetHtmlMode_Impl(rSet);
//STRIP001 	if(nHtmlMode & HTMLMODE_ON)
//STRIP001 	{
//STRIP001 		aLastLineLB.Hide();
//STRIP001 		aLastLineFT.Hide();
//STRIP001 		aExpandCB.Hide();
//STRIP001 		if(!(nHtmlMode & HTMLMODE_FULL_STYLES|HTMLMODE_FIRSTLINE) )
//STRIP001 			aJustify.Disable();
//STRIP001         aSnapToGridCB.Show(FALSE);
//STRIP001 	}
//STRIP001     nWhich = GetWhich(SID_ATTR_PARA_SNAPTOGRID);
//STRIP001     eItemState = rSet.GetItemState( nWhich );
//STRIP001     if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001     {
//STRIP001         const SvxParaGridItem& rSnap = (const SvxParaGridItem&)rSet.Get( nWhich );
//STRIP001         aSnapToGridCB.Check(rSnap.GetValue());
//STRIP001     }
//STRIP001 
//STRIP001     nWhich = GetWhich( SID_PARA_VERTALIGN );
//STRIP001     eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001     {
//STRIP001         aVertAlignLB.Show();
//STRIP001         aVertAlignFL.Show();
//STRIP001         aVertAlignFT.Show();
//STRIP001 
//STRIP001         const SvxParaVertAlignItem& rAlign = (const SvxParaVertAlignItem&)rSet.Get( nWhich );
//STRIP001         aVertAlignLB.SelectEntryPos(rAlign.GetValue());
//STRIP001     }
//STRIP001 
//STRIP001     nWhich = GetWhich( SID_ATTR_FRAMEDIRECTION );
//STRIP001     //text direction
//STRIP001     if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( nWhich ) )
//STRIP001 	{
//STRIP001         const SvxFrameDirectionItem& rFrameDirItem = ( const SvxFrameDirectionItem& ) rSet.Get( nWhich );
//STRIP001         aTextDirectionLB.SelectEntryValue( (SvxFrameDirection)rFrameDirItem.GetValue() );
//STRIP001         aTextDirectionLB.SaveValue();
//STRIP001 	}
//STRIP001 
//STRIP001     aSnapToGridCB.SaveValue();
//STRIP001     aVertAlignLB.SaveValue();
//STRIP001     aLeft.SaveValue();
//STRIP001 	aRight.SaveValue();
//STRIP001 	aCenter.SaveValue();
//STRIP001 	aJustify.SaveValue();
//STRIP001 	aLastLineLB.SaveValue();
//STRIP001 	aExpandCB.SaveValue();
//STRIP001 
//STRIP001 	UpdateExample_Impl(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------17.01.97 08.06-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxParaAlignTabPage, AlignHdl_Impl, RadioButton*, pBtn )
//STRIP001 {
//STRIP001 	BOOL bJustify = aJustify.IsChecked();
//STRIP001 	aLastLineFT.Enable(bJustify);
//STRIP001 	aLastLineLB.Enable(bJustify);
//STRIP001 	aExpandCB.Enable(bJustify);
//STRIP001 	UpdateExample_Impl(FALSE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxParaAlignTabPage, LastLineHdl_Impl, ListBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdateExample_Impl(FALSE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxParaAlignTabPage, TextDirectionHdl_Impl, ListBox*, EMPTYARG )
//STRIP001 {
//STRIP001 	SvxFrameDirection eDir = aTextDirectionLB.GetSelectEntryValue();
//STRIP001 	switch ( eDir )
//STRIP001 	{
//STRIP001 		// check the default alignment for this text direction
//STRIP001 		case FRMDIR_HORI_LEFT_TOP :		aLeft.Check( TRUE ); break;
//STRIP001 		case FRMDIR_HORI_RIGHT_TOP :	aRight.Check( TRUE ); break;
//STRIP001 		case FRMDIR_ENVIRONMENT :		/* do nothing */ break;
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "SvxParaAlignTabPage::TextDirectionHdl_Impl(): other directions not supported" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------16.01.97 19.34-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void	SvxParaAlignTabPage::UpdateExample_Impl( BOOL bAll )
//STRIP001 {
//STRIP001 	if ( aLeft.IsChecked() )
//STRIP001 		aExampleWin.SetAdjust( SVX_ADJUST_LEFT );
//STRIP001 	else if ( aRight.IsChecked() )
//STRIP001 		aExampleWin.SetAdjust( SVX_ADJUST_RIGHT );
//STRIP001 	else if ( aCenter.IsChecked() )
//STRIP001 		aExampleWin.SetAdjust( SVX_ADJUST_CENTER );
//STRIP001 	else if ( aJustify.IsChecked() )
//STRIP001 	{
//STRIP001 		aExampleWin.SetAdjust( SVX_ADJUST_BLOCK );
//STRIP001 		SvxAdjust eLastBlock = SVX_ADJUST_LEFT;
//STRIP001 		USHORT nLBPos = aLastLineLB.GetSelectEntryPos();
//STRIP001 		if(nLBPos == 1)
//STRIP001 			eLastBlock = SVX_ADJUST_CENTER;
//STRIP001 		else if(nLBPos == 2)
//STRIP001 			eLastBlock = SVX_ADJUST_BLOCK;
//STRIP001 		aExampleWin.SetLastLine( eLastBlock );
//STRIP001 	}
//STRIP001 
//STRIP001 	aExampleWin.Draw( bAll );
//STRIP001 }
//STRIP001 /*-----------------17.01.97 08.04-------------------
//STRIP001 	Erweiterungen fuer den Blocksatz einschalten
//STRIP001 --------------------------------------------------*/
//STRIP001 void SvxParaAlignTabPage::EnableJustifyExt()
//STRIP001 {
//STRIP001 	aLastLineFT.Show();
//STRIP001 	aLastLineLB.Show();
//STRIP001 	aExpandCB  .Show();
//STRIP001     SvtLanguageOptions aCJKOptions;
//STRIP001     if(aCJKOptions.IsAsianTypographyEnabled())
//STRIP001         aSnapToGridCB.Show();
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // class SvxExtParagraphTabPage ------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxExtParagraphTabPage::Create( Window* pParent,
//STRIP001 											const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxExtParagraphTabPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxExtParagraphTabPage::FillItemSet( SfxItemSet& rOutSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PARA_HYPHENZONE );
//STRIP001 	const TriState eHyphenState = aHyphenBox.GetState();
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rOutSet, SID_ATTR_PARA_HYPHENZONE );
//STRIP001 
//STRIP001 	if ( eHyphenState != aHyphenBox.GetSavedValue() 	||
//STRIP001 		 aExtHyphenBeforeBox.IsValueModified() 	   		||
//STRIP001 		 aExtHyphenAfterBox.IsValueModified()			||
//STRIP001 		 aMaxHyphenEdit.IsValueModified() )
//STRIP001 	{
//STRIP001 		SvxHyphenZoneItem aHyphen(
//STRIP001 			(const SvxHyphenZoneItem&)GetItemSet().Get( nWhich ) );
//STRIP001 		aHyphen.SetHyphen( eHyphenState == STATE_CHECK );
//STRIP001 
//STRIP001 		if ( eHyphenState == STATE_CHECK )
//STRIP001 		{
//STRIP001 			aHyphen.GetMinLead() = (BYTE)aExtHyphenBeforeBox.GetValue();
//STRIP001 			aHyphen.GetMinTrail() = (BYTE)aExtHyphenAfterBox.GetValue();
//STRIP001 		}
//STRIP001 		aHyphen.GetMaxHyphens() = (BYTE)aMaxHyphenEdit.GetValue();
//STRIP001 
//STRIP001 		if ( !pOld ||
//STRIP001 			!( *(SvxHyphenZoneItem*)pOld == aHyphen ) ||
//STRIP001 				eHyphenState != aHyphenBox.GetSavedValue())
//STRIP001 		{
//STRIP001 			rOutSet.Put( aHyphen );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aPagenumEdit.IsEnabled() && aPagenumEdit.IsValueModified())
//STRIP001 	{
//STRIP001 		SfxUInt16Item aPageNum( SID_ATTR_PARA_PAGENUM,
//STRIP001 								(USHORT)aPagenumEdit.GetValue() );
//STRIP001 
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_PAGENUM );
//STRIP001 
//STRIP001 		if ( !pOld || ( (const SfxUInt16Item*)pOld )->GetValue() != aPageNum.GetValue() )
//STRIP001 		{
//STRIP001 			rOutSet.Put( aPageNum );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Seitenumbruch
//STRIP001 
//STRIP001 	TriState eState = aApplyCollBtn.GetState();
//STRIP001 	FASTBOOL bIsPageModel = FALSE;
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_MODEL );
//STRIP001 	String sPage;
//STRIP001 	if ( eState != aApplyCollBtn.GetSavedValue() ||
//STRIP001 		 ( STATE_CHECK == eState &&
//STRIP001 		   aApplyCollBox.GetSelectEntryPos() != aApplyCollBox.GetSavedValue() ) )
//STRIP001 	{
//STRIP001 		if ( eState == STATE_CHECK )
//STRIP001 		{
//STRIP001 			sPage = aApplyCollBox.GetSelectEntry();
//STRIP001 			bIsPageModel = 0 != sPage.Len();
//STRIP001 		}
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_MODEL );
//STRIP001 
//STRIP001 		if ( !pOld || ( (const SvxPageModelItem*)pOld )->GetValue() != sPage )
//STRIP001 		{
//STRIP001 			rOutSet.Put( SvxPageModelItem( sPage, FALSE, nWhich ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bIsPageModel = FALSE;
//STRIP001 	}
//STRIP001 	else if(STATE_CHECK == eState && aApplyCollBtn.IsEnabled())
//STRIP001 		bIsPageModel = TRUE;
//STRIP001 	else
//STRIP001 		rOutSet.Put( SvxPageModelItem( sPage, FALSE, nWhich ) );
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_PAGEBREAK );
//STRIP001 
//STRIP001 	if ( bIsPageModel )
//STRIP001 		// wird PageModel eingeschaltet, dann immer PageBreak ausschalten
//STRIP001 		rOutSet.Put( SvxFmtBreakItem( SVX_BREAK_NONE, nWhich ) );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		eState = aPageBreakBox.GetState();
//STRIP001 		SfxItemState eModelState = GetItemSet().GetItemState(SID_ATTR_PARA_MODEL, FALSE);
//STRIP001 
//STRIP001 		if ( (eModelState == SFX_ITEM_SET && STATE_CHECK == aPageBreakBox.GetState()) ||
//STRIP001 			 eState != aPageBreakBox.GetSavedValue()				||
//STRIP001              aBreakTypeLB.GetSelectEntryPos() != aBreakTypeLB.GetSavedValue()   ||
//STRIP001              aBreakPositionLB.GetSelectEntryPos() != aBreakPositionLB.GetSavedValue() )
//STRIP001 		{
//STRIP001 			const SvxFmtBreakItem rOldBreak(
//STRIP001 					(const SvxFmtBreakItem&)GetItemSet().Get( nWhich ));
//STRIP001 			SvxFmtBreakItem aBreak(rOldBreak.GetBreak(), rOldBreak.Which());
//STRIP001 
//STRIP001 			switch ( eState )
//STRIP001 			{
//STRIP001 				case STATE_CHECK:
//STRIP001 				{
//STRIP001                     BOOL bBefore = aBreakPositionLB.GetSelectEntryPos() == 0;
//STRIP001 
//STRIP001                     if ( aBreakTypeLB.GetSelectEntryPos() == 0 )
//STRIP001 					{
//STRIP001 						if ( bBefore )
//STRIP001 							aBreak.SetValue( SVX_BREAK_PAGE_BEFORE );
//STRIP001 						else
//STRIP001 							aBreak.SetValue( SVX_BREAK_PAGE_AFTER );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if ( bBefore )
//STRIP001 							aBreak.SetValue( SVX_BREAK_COLUMN_BEFORE );
//STRIP001 						else
//STRIP001 							aBreak.SetValue( SVX_BREAK_COLUMN_AFTER );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				case STATE_NOCHECK:
//STRIP001 					aBreak.SetValue( SVX_BREAK_NONE );
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			pOld = GetOldItem( rOutSet, SID_ATTR_PARA_PAGEBREAK );
//STRIP001 
//STRIP001 			if ( eState != aPageBreakBox.GetSavedValue()				||
//STRIP001 					!pOld || !( *(const SvxFmtBreakItem*)pOld == aBreak ) )
//STRIP001 			{
//STRIP001 				bModified |= TRUE;
//STRIP001 				rOutSet.Put( aBreak );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// Absatztrennung
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_SPLIT );
//STRIP001 	eState = aKeepTogetherBox.GetState();
//STRIP001 
//STRIP001 	if ( eState != aKeepTogetherBox.GetSavedValue() )
//STRIP001 	{
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_SPLIT );
//STRIP001 
//STRIP001 		if ( !pOld || ( (const SvxFmtSplitItem*)pOld )->GetValue() !=
//STRIP001 					  ( eState == STATE_NOCHECK ) )
//STRIP001 		{
//STRIP001 			rOutSet.Put( SvxFmtSplitItem( eState == STATE_NOCHECK, nWhich ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Absaetze zusammenhalten
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_KEEP );
//STRIP001 	eState = aKeepParaBox.GetState();
//STRIP001 
//STRIP001 	if ( eState != aKeepParaBox.GetSavedValue() )
//STRIP001 	{
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_KEEP );
//STRIP001 
//STRIP001 		// hat sich der Status geaendert, muss immer geputtet werden
//STRIP001 		rOutSet.Put( SvxFmtKeepItem( eState == STATE_CHECK, nWhich ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Witwen und Waisen
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_WIDOWS );
//STRIP001 	eState = aWidowBox.GetState();
//STRIP001 
//STRIP001 	if ( eState != aWidowBox.GetSavedValue() ||
//STRIP001 		 aWidowRowNo.IsValueModified() )
//STRIP001 	{
//STRIP001 		SvxWidowsItem rItem( eState == STATE_CHECK ?
//STRIP001 							 (BYTE)aWidowRowNo.GetValue() : 0, nWhich );
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_WIDOWS );
//STRIP001 
//STRIP001 		if ( eState != aWidowBox.GetSavedValue() || !pOld || !( *(const SvxWidowsItem*)pOld == rItem ) )
//STRIP001 		{
//STRIP001 			rOutSet.Put( rItem );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_ORPHANS );
//STRIP001 	eState = aOrphanBox.GetState();
//STRIP001 
//STRIP001 	if ( eState != aOrphanBox.GetSavedValue() ||
//STRIP001 		 aOrphanRowNo.IsValueModified() )
//STRIP001 	{
//STRIP001 		SvxOrphansItem rItem( eState == STATE_CHECK ?
//STRIP001 							 (BYTE)aOrphanRowNo.GetValue() : 0, nWhich );
//STRIP001 		pOld = GetOldItem( rOutSet, SID_ATTR_PARA_ORPHANS );
//STRIP001 
//STRIP001 		if ( eState != aOrphanBox.GetSavedValue() ||
//STRIP001 				!pOld ||
//STRIP001 					!( *(const SvxOrphansItem*)pOld == rItem ) )
//STRIP001 		{
//STRIP001 			rOutSet.Put( rItem );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxExtParagraphTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PARA_HYPHENZONE );
//STRIP001 	SfxItemState eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	BOOL bItemAvailable = eItemState >= SFX_ITEM_AVAILABLE;
//STRIP001 	BOOL bIsHyphen = FALSE;
//STRIP001 	if( !bHtmlMode && bItemAvailable )
//STRIP001 	{
//STRIP001 		const SvxHyphenZoneItem& rHyphen =
//STRIP001 			(const SvxHyphenZoneItem&)rSet.Get( nWhich );
//STRIP001 		aHyphenBox.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		bIsHyphen = rHyphen.IsHyphen();
//STRIP001 		aHyphenBox.SetState( bIsHyphen ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 
//STRIP001 		aExtHyphenBeforeBox.SetValue( rHyphen.GetMinLead() );
//STRIP001 		aExtHyphenAfterBox.SetValue( rHyphen.GetMinTrail() );
//STRIP001 		aMaxHyphenEdit.SetValue( rHyphen.GetMaxHyphens() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aHyphenBox.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	BOOL bEnable = bItemAvailable && bIsHyphen;
//STRIP001 	aExtHyphenBeforeBox.Enable(bEnable);
//STRIP001 	aExtHyphenAfterBox.Enable(bEnable);
//STRIP001 	aBeforeText.Enable(bEnable);
//STRIP001 	aAfterText.Enable(bEnable);
//STRIP001 	aMaxHyphenLabel.Enable(bEnable);
//STRIP001 	aMaxHyphenEdit.Enable(bEnable);
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_PAGENUM );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState(nWhich) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const USHORT nPageNum =
//STRIP001 			( (const SfxUInt16Item&)rSet.Get( nWhich ) ).GetValue();
//STRIP001 		aPagenumEdit.SetValue( nPageNum );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bPageBreak )
//STRIP001 	{
//STRIP001 		// zuerst PageModel behandeln
//STRIP001 		nWhich = GetWhich( SID_ATTR_PARA_MODEL );
//STRIP001 		BOOL bIsPageModel = FALSE;
//STRIP001 		eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 		if ( eItemState >= SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			aApplyCollBtn.EnableTriState( FALSE );
//STRIP001 
//STRIP001 			const SvxPageModelItem& rModel =
//STRIP001 				(const SvxPageModelItem&)rSet.Get( nWhich );
//STRIP001 			String aStr( rModel.GetValue() );
//STRIP001 
//STRIP001 			if ( aStr.Len() &&
//STRIP001 				 aApplyCollBox.GetEntryPos( aStr ) != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aApplyCollBox.SelectEntry( aStr );
//STRIP001 				aApplyCollBtn.SetState( STATE_CHECK );
//STRIP001 				bIsPageModel = TRUE;
//STRIP001 
//STRIP001 				aPageBreakBox.Enable();
//STRIP001 				aPageBreakBox.EnableTriState( FALSE );
//STRIP001                 aBreakTypeFT.Enable();
//STRIP001                 aBreakTypeLB.Enable();
//STRIP001                 aBreakPositionFT.Enable();
//STRIP001                 aBreakPositionLB.Enable();
//STRIP001                 aApplyCollBtn.Enable();
//STRIP001 				aPageBreakBox.SetState( STATE_CHECK );
//STRIP001 
//STRIP001                 //select page break
//STRIP001                 aBreakTypeLB.SelectEntryPos(0);
//STRIP001                 //select break before
//STRIP001                 aBreakPositionLB.SelectEntryPos(0);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aApplyCollBox.SetNoSelection();
//STRIP001 				aApplyCollBtn.SetState( STATE_NOCHECK );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( SFX_ITEM_DONTCARE == eItemState )
//STRIP001 		{
//STRIP001 			aApplyCollBtn.EnableTriState( TRUE );
//STRIP001 			aApplyCollBtn.SetState( STATE_DONTKNOW );
//STRIP001 			aApplyCollBox.SetNoSelection();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aApplyCollBtn.Enable(FALSE);
//STRIP001 			aApplyCollBox.Enable(FALSE);
//STRIP001 			aPagenumEdit.Enable(FALSE);
//STRIP001 			aPagenumText.Enable(FALSE);
//STRIP001 		}
//STRIP001 //!!!	ApplyCollClickHdl_Impl( &aApplyCollBtn );
//STRIP001 
//STRIP001 		if ( !bIsPageModel )
//STRIP001 		{
//STRIP001 			nWhich = GetWhich( SID_ATTR_PARA_PAGEBREAK );
//STRIP001 			eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 			if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 			{
//STRIP001 				const SvxFmtBreakItem& rPageBreak =
//STRIP001 					(const SvxFmtBreakItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 				SvxBreak eBreak = (SvxBreak)rPageBreak.GetValue();
//STRIP001 
//STRIP001 				// PageBreak nicht ueber CTRL-RETURN,
//STRIP001 				// dann kann CheckBox frei gegeben werden
//STRIP001 				aPageBreakBox.Enable();
//STRIP001 				aPageBreakBox.EnableTriState( FALSE );
//STRIP001                 aBreakTypeFT.Enable();
//STRIP001                 aBreakTypeLB.Enable();
//STRIP001                 aBreakPositionFT.Enable();
//STRIP001                 aBreakPositionLB.Enable();
//STRIP001 
//STRIP001 				aPageBreakBox.SetState( STATE_CHECK );
//STRIP001 
//STRIP001 				BOOL bEnable = 	eBreak != SVX_BREAK_NONE &&
//STRIP001 								eBreak != SVX_BREAK_COLUMN_BEFORE &&
//STRIP001 								eBreak != SVX_BREAK_COLUMN_AFTER;
//STRIP001 				aApplyCollBtn.Enable(bEnable);
//STRIP001 				if(!bEnable)
//STRIP001 				{
//STRIP001 					aApplyCollBox.Enable(bEnable);
//STRIP001 					aPagenumEdit.Enable(bEnable);
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( eBreak == SVX_BREAK_NONE )
//STRIP001 					aPageBreakBox.SetState( STATE_NOCHECK );
//STRIP001 
//STRIP001                 USHORT nType = 0; // selection position in break type ListBox : Page
//STRIP001                 USHORT nPosition = 0; //  selection position in break position ListBox : Before
//STRIP001                 switch ( eBreak )
//STRIP001 				{
//STRIP001 					case SVX_BREAK_PAGE_BEFORE:
//STRIP001 						break;
//STRIP001 					case SVX_BREAK_PAGE_AFTER:
//STRIP001                         nPosition = 1;
//STRIP001 						break;
//STRIP001 					case SVX_BREAK_COLUMN_BEFORE:
//STRIP001                         nType = 1;
//STRIP001 						break;
//STRIP001 					case SVX_BREAK_COLUMN_AFTER:
//STRIP001                         nType = 1;
//STRIP001                         nPosition = 1;
//STRIP001 						break;
//STRIP001 				}
//STRIP001                 aBreakTypeLB.SelectEntryPos(nType);
//STRIP001                 aBreakPositionLB.SelectEntryPos(nPosition);
//STRIP001             }
//STRIP001 			else if ( SFX_ITEM_DONTCARE == eItemState )
//STRIP001 				aPageBreakBox.SetState( STATE_DONTKNOW );
//STRIP001 			else
//STRIP001 			{
//STRIP001                 aPageBreakBox.Enable(FALSE);
//STRIP001                 aBreakTypeFT.Enable(FALSE);
//STRIP001                 aBreakTypeLB.Enable(FALSE);
//STRIP001                 aBreakPositionFT.Enable(FALSE);
//STRIP001                 aBreakPositionLB.Enable(FALSE);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         PageBreakPosHdl_Impl( &aBreakPositionLB );
//STRIP001 		PageBreakHdl_Impl( &aPageBreakBox );
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_KEEP );
//STRIP001 	eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		aKeepParaBox.EnableTriState( FALSE );
//STRIP001 		const SvxFmtKeepItem& rKeep =
//STRIP001 			(const SvxFmtKeepItem&)rSet.Get( nWhich );
//STRIP001 
//STRIP001 		if ( rKeep.GetValue() )
//STRIP001 			aKeepParaBox.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aKeepParaBox.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DONTCARE == eItemState )
//STRIP001 		aKeepParaBox.SetState( STATE_DONTKNOW );
//STRIP001 	else
//STRIP001 		aKeepParaBox.Enable(FALSE);
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PARA_SPLIT );
//STRIP001 	eItemState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 	if ( eItemState >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SvxFmtSplitItem& rSplit =
//STRIP001 			(const SvxFmtSplitItem&)rSet.Get( nWhich );
//STRIP001 		aKeepTogetherBox.EnableTriState( FALSE );
//STRIP001 
//STRIP001 		if ( !rSplit.GetValue() )
//STRIP001 			aKeepTogetherBox.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aKeepTogetherBox.SetState( STATE_NOCHECK );
//STRIP001 
//STRIP001 			// Witwen und Waisen
//STRIP001 			aWidowBox.Enable();
//STRIP001 			nWhich = GetWhich( SID_ATTR_PARA_WIDOWS );
//STRIP001 			SfxItemState eTmpState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 			if ( eTmpState >= SFX_ITEM_AVAILABLE )
//STRIP001 			{
//STRIP001 				const SvxWidowsItem& rWidow =
//STRIP001 					(const SvxWidowsItem&)rSet.Get( nWhich );
//STRIP001 				aWidowBox.EnableTriState( FALSE );
//STRIP001 				const USHORT nLines = rWidow.GetValue();
//STRIP001 
//STRIP001 				BOOL bEnable = nLines > 0;
//STRIP001 				aWidowRowNo.SetValue( aWidowRowNo.Normalize( nLines ) );
//STRIP001 				aWidowBox.SetState( bEnable ? STATE_CHECK : STATE_NOCHECK);
//STRIP001 				aWidowRowNo.Enable(bEnable);
//STRIP001 				aWidowRowLabel.Enable(bEnable);
//STRIP001 
//STRIP001 			}
//STRIP001 			else if ( SFX_ITEM_DONTCARE == eTmpState )
//STRIP001 				aWidowBox.SetState( STATE_DONTKNOW );
//STRIP001 			else
//STRIP001 				aWidowBox.Enable(FALSE);
//STRIP001 
//STRIP001 			aOrphanBox.Enable();
//STRIP001 			nWhich = GetWhich( SID_ATTR_PARA_ORPHANS );
//STRIP001 			eTmpState = rSet.GetItemState( nWhich );
//STRIP001 
//STRIP001 			if ( eTmpState >= SFX_ITEM_AVAILABLE )
//STRIP001 			{
//STRIP001 				const SvxOrphansItem& rOrphan =
//STRIP001 					(const SvxOrphansItem&)rSet.Get( nWhich );
//STRIP001 				const USHORT nLines = rOrphan.GetValue();
//STRIP001 				aOrphanBox.EnableTriState( FALSE );
//STRIP001 
//STRIP001 				BOOL bEnable = nLines > 0;
//STRIP001 				aOrphanBox.SetState( bEnable ? STATE_CHECK : STATE_NOCHECK);
//STRIP001 				aOrphanRowNo.SetValue( aOrphanRowNo.Normalize( nLines ) );
//STRIP001 				aOrphanRowNo.Enable(bEnable);
//STRIP001 				aOrphanRowLabel.Enable(bEnable);
//STRIP001 
//STRIP001 			}
//STRIP001 			else if ( SFX_ITEM_DONTCARE == eTmpState )
//STRIP001 				aOrphanBox.SetState( STATE_DONTKNOW );
//STRIP001 			else
//STRIP001 				aOrphanBox.Enable(FALSE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DONTCARE == eItemState )
//STRIP001 		aKeepTogetherBox.SetState( STATE_DONTKNOW );
//STRIP001 	else
//STRIP001 		aKeepTogetherBox.Enable(FALSE);
//STRIP001 
//STRIP001 	// damit alles richt enabled wird
//STRIP001 	KeepTogetherHdl_Impl( 0 );
//STRIP001 	WidowHdl_Impl( 0 );
//STRIP001 	OrphanHdl_Impl( 0 );
//STRIP001 
//STRIP001     aHyphenBox.SaveValue();
//STRIP001 	aExtHyphenBeforeBox.SaveValue();
//STRIP001 	aExtHyphenAfterBox.SaveValue();
//STRIP001 	aMaxHyphenEdit.SaveValue();
//STRIP001 	aPageBreakBox.SaveValue();
//STRIP001     aBreakPositionLB.SaveValue();
//STRIP001     aBreakTypeLB.SaveValue();
//STRIP001 	aApplyCollBtn.SaveValue();
//STRIP001 	aApplyCollBox.SaveValue();
//STRIP001 	aPagenumEdit.SaveValue();
//STRIP001 	aKeepTogetherBox.SaveValue();
//STRIP001 	aKeepParaBox.SaveValue();
//STRIP001 	aWidowBox.SaveValue();
//STRIP001 	aOrphanBox.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxExtParagraphTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxExtParagraphTabPage::DisablePageBreak()
//STRIP001 {
//STRIP001 	bPageBreak = FALSE;
//STRIP001 	aPageBreakBox.Enable(FALSE);
//STRIP001     aBreakTypeLB.RemoveEntry(0);
//STRIP001     aBreakPositionFT.Enable(FALSE);
//STRIP001     aBreakPositionLB.Enable(FALSE);
//STRIP001 	aApplyCollBtn.Enable(FALSE);
//STRIP001 	aApplyCollBox.Enable(FALSE);
//STRIP001 	aPagenumEdit.Enable(FALSE);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxExtParagraphTabPage::SvxExtParagraphTabPage( Window* pParent, const SfxItemSet& rAttr ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( RID_SVXPAGE_EXT_PARAGRAPH, DIALOG_MGR() ), rAttr ),
//STRIP001 
//STRIP001 	aHyphenBox    		( this, ResId( BTN_HYPHEN ) ),
//STRIP001 	aBeforeText			( this, ResId( FT_HYPHENBEFORE ) ),
//STRIP001 	aExtHyphenBeforeBox ( this, ResId( ED_HYPHENBEFORE ) ),
//STRIP001 	aAfterText			( this, ResId( FT_HYPHENAFTER ) ),
//STRIP001 	aExtHyphenAfterBox  ( this, ResId( ED_HYPHENAFTER ) ),
//STRIP001 	aMaxHyphenLabel     ( this, ResId( FT_MAXHYPH ) ),
//STRIP001 	aMaxHyphenEdit		( this, ResId( ED_MAXHYPH ) ),
//STRIP001     aExtFL              ( this, ResId( FL_HYPHEN ) ),
//STRIP001 	aPageBreakBox       ( this, ResId( BTN_PAGEBREAK ) ),
//STRIP001     aBreakTypeFT        ( this, ResId( FT_BREAKTYPE     )),
//STRIP001     aBreakTypeLB        ( this, ResId( LB_BREAKTYPE     )),
//STRIP001     aBreakPositionFT    ( this, ResId( FT_BREAKPOSITION )),
//STRIP001     aBreakPositionLB    ( this, ResId( LB_BREAKPOSITION )),
//STRIP001 //    aPageBox            ( this, ResId( BTN_BREAKPAGE ) ),
//STRIP001 //    aColumnBox          ( this, ResId( BTN_BREAKCOLUMN ) ),
//STRIP001 //    aBeforeBox          ( this, ResId( BTN_PAGEBREAKBEFORE ) ),
//STRIP001 //    aAfterBox           ( this, ResId( BTN_PAGEBREAKAFTER ) ),
//STRIP001 	aApplyCollBtn       ( this, ResId( BTN_PAGECOLL ) ),
//STRIP001 	aApplyCollBox       ( this, ResId( LB_PAGECOLL ) ),
//STRIP001 	aPagenumText		( this, ResId( FT_PAGENUM ) ),
//STRIP001 	aPagenumEdit		( this, ResId( ED_PAGENUM ) ),
//STRIP001 	aKeepTogetherBox    ( this, ResId( BTN_KEEPTOGETHER ) ),
//STRIP001 	aKeepParaBox		( this, ResId( CB_KEEPTOGETHER ) ),
//STRIP001 	aOrphanBox          ( this, ResId( BTN_ORPHANS ) ),
//STRIP001 	aOrphanRowNo        ( this, ResId( ED_ORPHANS ) ),
//STRIP001 	aOrphanRowLabel     ( this, ResId( FT_ORPHANS ) ),
//STRIP001 	aWidowBox           ( this, ResId( BTN_WIDOWS ) ),
//STRIP001 	aWidowRowNo         ( this, ResId( ED_WIDOWS ) ),
//STRIP001 	aWidowRowLabel      ( this, ResId( FT_WIDOWS ) ),
//STRIP001 	aExtendFL           ( this, ResId( FL_OPTIONS ) ),
//STRIP001 	aBreaksFL           ( this, ResId( FL_BREAKS ) ),
//STRIP001 	bHtmlMode	( FALSE ),
//STRIP001 	bPageBreak	( TRUE ),
//STRIP001 	nStdPos		( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	aHyphenBox.SetClickHdl( 		LINK( this, SvxExtParagraphTabPage, HyphenClickHdl_Impl ) );
//STRIP001 	aPageBreakBox.SetClickHdl( 		LINK( this, SvxExtParagraphTabPage, PageBreakHdl_Impl ) );
//STRIP001 	aKeepTogetherBox.SetClickHdl( 	LINK( this, SvxExtParagraphTabPage, KeepTogetherHdl_Impl ) );
//STRIP001 	aWidowBox.SetClickHdl( 			LINK( this, SvxExtParagraphTabPage, WidowHdl_Impl ) );
//STRIP001 	aOrphanBox.SetClickHdl( 		LINK( this, SvxExtParagraphTabPage, OrphanHdl_Impl ) );
//STRIP001 	aApplyCollBtn.SetClickHdl( 		LINK( this, SvxExtParagraphTabPage, ApplyCollClickHdl_Impl ) );
//STRIP001     aBreakTypeLB.SetSelectHdl(      LINK( this, SvxExtParagraphTabPage, PageBreakTypeHdl_Impl ) );
//STRIP001     aBreakPositionLB.SetSelectHdl(  LINK( this, SvxExtParagraphTabPage, PageBreakPosHdl_Impl ) );
//STRIP001 
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 	if ( pSh )
//STRIP001 	{
//STRIP001 		SfxStyleSheetBasePool* pPool = pSh->GetStyleSheetPool();
//STRIP001 		pPool->SetSearchMask( SFX_STYLE_FAMILY_PAGE );
//STRIP001 		SfxStyleSheetBase* pStyle = pPool->First();
//STRIP001 		String aStdName;
//STRIP001 
//STRIP001 		while( pStyle )
//STRIP001 		{
//STRIP001 			if ( aStdName.Len() == 0 )
//STRIP001 				// first style == standard style
//STRIP001 				aStdName = pStyle->GetName();
//STRIP001 			aApplyCollBox.InsertEntry( pStyle->GetName() );
//STRIP001 			pStyle = pPool->Next();
//STRIP001 		}
//STRIP001 		nStdPos = aApplyCollBox.GetEntryPos( aStdName );
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nHtmlMode = GetHtmlMode_Impl( rAttr );
//STRIP001 	if ( nHtmlMode & HTMLMODE_ON )
//STRIP001 	{
//STRIP001 		bHtmlMode = TRUE;
//STRIP001 		aHyphenBox    		 .Enable(FALSE);
//STRIP001 		aBeforeText			 .Enable(FALSE);
//STRIP001 		aExtHyphenBeforeBox  .Enable(FALSE);
//STRIP001 		aAfterText			 .Enable(FALSE);
//STRIP001 		aExtHyphenAfterBox   .Enable(FALSE);
//STRIP001 		aMaxHyphenLabel      .Enable(FALSE);
//STRIP001 		aMaxHyphenEdit		 .Enable(FALSE);
//STRIP001         aExtFL               .Enable(FALSE);
//STRIP001 		aPagenumText         .Enable(FALSE);
//STRIP001 		aPagenumEdit         .Enable(FALSE);
//STRIP001         // no column break in HTML
//STRIP001         aBreakTypeLB.RemoveEntry(1);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 __EXPORT SvxExtParagraphTabPage::~SvxExtParagraphTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxExtParagraphTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pExtRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, PageBreakHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	switch ( aPageBreakBox.GetState() )
//STRIP001 	{
//STRIP001 		case STATE_CHECK:
//STRIP001             aBreakTypeFT.Enable();
//STRIP001             aBreakTypeLB.Enable();
//STRIP001             aBreakPositionFT.Enable();
//STRIP001             aBreakPositionLB.Enable();
//STRIP001 
//STRIP001             if ( 0 == aBreakTypeLB.GetSelectEntryPos()&&
//STRIP001                 0 == aBreakPositionLB.GetSelectEntryPos() )
//STRIP001 			{
//STRIP001 				aApplyCollBtn.Enable();
//STRIP001 
//STRIP001 				BOOL bEnable = STATE_CHECK == aApplyCollBtn.GetState() &&
//STRIP001 											aApplyCollBox.GetEntryCount();
//STRIP001 				aApplyCollBox.Enable(bEnable);
//STRIP001 				if(!bHtmlMode)
//STRIP001 				{
//STRIP001 					aPagenumText.Enable(bEnable);
//STRIP001 					aPagenumEdit.Enable(bEnable);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case STATE_NOCHECK:
//STRIP001 		case STATE_DONTKNOW:
//STRIP001 			aApplyCollBtn.SetState( STATE_NOCHECK );
//STRIP001 			aApplyCollBtn.Enable(FALSE);
//STRIP001 			aApplyCollBox.Enable(FALSE);
//STRIP001 			aPagenumText.Enable(FALSE);
//STRIP001 			aPagenumEdit.Enable(FALSE);
//STRIP001             aBreakTypeFT.Enable(FALSE);
//STRIP001             aBreakTypeLB.Enable(FALSE);
//STRIP001             aBreakPositionFT.Enable(FALSE);
//STRIP001             aBreakPositionLB.Enable(FALSE);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, KeepTogetherHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bEnable = aKeepTogetherBox.GetState() == STATE_NOCHECK;
//STRIP001 	aWidowBox.Enable(bEnable);
//STRIP001 	aOrphanBox.Enable(bEnable);
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, WidowHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	switch ( aWidowBox.GetState() )
//STRIP001 	{
//STRIP001 		case STATE_CHECK:
//STRIP001 			aWidowRowNo.Enable();
//STRIP001 			aWidowRowLabel.Enable();
//STRIP001 			aKeepTogetherBox.Enable(FALSE);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case STATE_NOCHECK:
//STRIP001 			if ( aOrphanBox.GetState() == STATE_NOCHECK )
//STRIP001 				aKeepTogetherBox.Enable();
//STRIP001 
//STRIP001 		// kein break
//STRIP001 		case STATE_DONTKNOW:
//STRIP001 			aWidowRowNo.Enable(FALSE);
//STRIP001 			aWidowRowLabel.Enable(FALSE);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, OrphanHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	switch( aOrphanBox.GetState() )
//STRIP001 	{
//STRIP001 		case STATE_CHECK:
//STRIP001 			aOrphanRowNo.Enable();
//STRIP001 			aOrphanRowLabel.Enable();
//STRIP001 			aKeepTogetherBox.Enable(FALSE);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case STATE_NOCHECK:
//STRIP001 			if ( aWidowBox.GetState() == STATE_NOCHECK )
//STRIP001 				aKeepTogetherBox.Enable();
//STRIP001 
//STRIP001 		// kein break
//STRIP001 		case STATE_DONTKNOW:
//STRIP001 			aOrphanRowNo.Enable(FALSE);
//STRIP001 			aOrphanRowLabel.Enable(FALSE);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, HyphenClickHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 
//STRIP001 	BOOL bEnable = aHyphenBox.GetState() == STATE_CHECK;
//STRIP001 	aBeforeText.Enable(bEnable);
//STRIP001 	aExtHyphenBeforeBox.Enable(bEnable);
//STRIP001 	aAfterText.Enable(bEnable);
//STRIP001 	aExtHyphenAfterBox.Enable(bEnable);
//STRIP001 	aMaxHyphenLabel.Enable(bEnable);
//STRIP001 	aMaxHyphenEdit.Enable(bEnable);
//STRIP001 	aHyphenBox.SetState( bEnable ? STATE_CHECK : STATE_NOCHECK);
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, ApplyCollClickHdl_Impl, TriStateBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bEnable = FALSE;
//STRIP001 	if ( aApplyCollBtn.GetState() == STATE_CHECK &&
//STRIP001 		 aApplyCollBox.GetEntryCount() )
//STRIP001 	{
//STRIP001 		bEnable = TRUE;
//STRIP001 		aApplyCollBox.SelectEntryPos( nStdPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aApplyCollBox.SetNoSelection();
//STRIP001 	}
//STRIP001 	aApplyCollBox.Enable(bEnable);
//STRIP001 	if(!bHtmlMode)
//STRIP001 	{
//STRIP001 		aPagenumText.Enable(bEnable);
//STRIP001 		aPagenumEdit.Enable(bEnable);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, PageBreakPosHdl_Impl, ListBox *, pListBox )
//STRIP001 {
//STRIP001     if ( 0 == pListBox->GetSelectEntryPos() )
//STRIP001     {
//STRIP001         aApplyCollBtn.Enable();
//STRIP001 
//STRIP001         BOOL bEnable = aApplyCollBtn.GetState() == STATE_CHECK &&
//STRIP001                                     aApplyCollBox.GetEntryCount();
//STRIP001 
//STRIP001         aApplyCollBox.Enable(bEnable);
//STRIP001         if(!bHtmlMode)
//STRIP001         {
//STRIP001             aPagenumText.Enable(bEnable);
//STRIP001             aPagenumEdit.Enable(bEnable);
//STRIP001         }
//STRIP001     }
//STRIP001     else if ( 1 == pListBox->GetSelectEntryPos() )
//STRIP001     {
//STRIP001         aApplyCollBtn.SetState( STATE_NOCHECK );
//STRIP001         aApplyCollBtn.Enable(FALSE);
//STRIP001         aApplyCollBox.Enable(FALSE);
//STRIP001         aPagenumText.Enable(FALSE);
//STRIP001         aPagenumEdit.Enable(FALSE);
//STRIP001     }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxExtParagraphTabPage, PageBreakTypeHdl_Impl, ListBox *, pListBox )
//STRIP001 {
//STRIP001     //column break or break break after
//STRIP001     USHORT nBreakPos = aBreakPositionLB.GetSelectEntryPos();
//STRIP001     if ( pListBox->GetSelectEntryPos() == 1 || 1 == nBreakPos)
//STRIP001 	{
//STRIP001 		aApplyCollBtn.SetState( STATE_NOCHECK );
//STRIP001 		aApplyCollBtn.Enable(FALSE);
//STRIP001 		aApplyCollBox.Enable(FALSE);
//STRIP001 		aPagenumText.Enable(FALSE);
//STRIP001 		aPagenumEdit.Enable(FALSE);
//STRIP001 	}
//STRIP001     else
//STRIP001         PageBreakPosHdl_Impl( &aBreakPositionLB );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:24---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SvxAsianTabPage::SvxAsianTabPage( Window* pParent, const SfxItemSet& rSet ) :
//STRIP001 	SfxTabPage(pParent, ResId( RID_SVXPAGE_PARA_ASIAN, DIALOG_MGR() ), rSet),
//STRIP001     aOptionsFL(         this, ResId(FL_AS_OPTIONS       )),
//STRIP001 	aHangingPunctCB(    this, ResId(CB_AS_HANG_PUNC		)),
//STRIP001 	aAllowWordBreakCB(	this, ResId(CB_AS_ALLOW_WORD_BREAK)),
//STRIP001 	aForbiddenRulesCB(  this, ResId(CB_AS_FORBIDDEN		)),
//STRIP001     aCharDistFL(        this, ResId(FL_AS_CHAR_DIST     )),
//STRIP001 	aPuntuationCB(     	this, ResId(CB_AS_PUNCTUATION   )),
//STRIP001 	aScriptSpaceCB(     this, ResId(CB_AS_SCRIPT_SPACE	)),
//STRIP001 	aAdjustNumbersCB(	this, ResId(CB_AS_ADJUST_NUMBERS))
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxAsianTabPage, ClickHdl_Impl );
//STRIP001 	aHangingPunctCB.SetClickHdl( aLink );
//STRIP001 	aScriptSpaceCB.SetClickHdl( aLink );
//STRIP001 	aForbiddenRulesCB.SetClickHdl( aLink );
//STRIP001 
//STRIP001 //JP 28.3.2001 - these options currently not available!
//STRIP001 	aAllowWordBreakCB.Hide();
//STRIP001     aCharDistFL.Hide();
//STRIP001 	aPuntuationCB.Hide();
//STRIP001 	aAdjustNumbersCB.Hide();
//STRIP001     aScriptSpaceCB.SetPosPixel( aHangingPunctCB.GetPosPixel() );
//STRIP001     aHangingPunctCB.SetPosPixel( aAllowWordBreakCB.GetPosPixel() );
//STRIP001 //JP 28.3.2001 - these options currently not available!
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:24---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SvxAsianTabPage::~SvxAsianTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:24---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SfxTabPage*	SvxAsianTabPage::Create(	Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxAsianTabPage(pParent, rSet);
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:24---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 USHORT*		SvxAsianTabPage::GetRanges()
//STRIP001 {
//STRIP001 	static USHORT pRanges[] =
//STRIP001 	{
//STRIP001 		SID_ATTR_PARA_SCRIPTSPACE,
//STRIP001 		SID_ATTR_PARA_HANGPUNCTUATION,
//STRIP001 		SID_ATTR_PARA_FORBIDDEN_RULES,
//STRIP001 		0
//STRIP001 	};
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:24---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 BOOL		SvxAsianTabPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	if(aScriptSpaceCB.IsChecked() != aScriptSpaceCB.GetSavedValue())
//STRIP001 	{
//STRIP001 		SfxBoolItem* pNewItem = (SfxBoolItem*)rSet.Get(
//STRIP001 			pPool->GetWhich(SID_ATTR_PARA_SCRIPTSPACE)).Clone();
//STRIP001 		pNewItem->SetValue(aScriptSpaceCB.IsChecked());
//STRIP001 		rSet.Put(*pNewItem);
//STRIP001 		delete pNewItem;
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	if(aHangingPunctCB.IsChecked() != aHangingPunctCB.GetSavedValue())
//STRIP001 	{
//STRIP001 		SfxBoolItem* pNewItem = (SfxBoolItem*)rSet.Get(
//STRIP001 			pPool->GetWhich(SID_ATTR_PARA_HANGPUNCTUATION)).Clone();
//STRIP001 		pNewItem->SetValue(aHangingPunctCB.IsChecked());
//STRIP001 		rSet.Put(*pNewItem);
//STRIP001 		delete pNewItem;
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	if(aForbiddenRulesCB.IsChecked() != aForbiddenRulesCB.GetSavedValue())
//STRIP001 	{
//STRIP001 		SfxBoolItem* pNewItem = (SfxBoolItem*)rSet.Get(
//STRIP001 			pPool->GetWhich(SID_ATTR_PARA_FORBIDDEN_RULES)).Clone();
//STRIP001 		pNewItem->SetValue(aForbiddenRulesCB.IsChecked());
//STRIP001 		rSet.Put(*pNewItem);
//STRIP001 		delete pNewItem;
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 /*-- 29.11.00 11:36:25---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void lcl_SetBox(const SfxItemSet& rSet, USHORT nSlotId, TriStateBox& rBox)
//STRIP001 {
//STRIP001 	USHORT nWhich = rSet.GetPool()->GetWhich(nSlotId);
//STRIP001 	SfxItemState eState = rSet.GetItemState(nWhich, TRUE);
//STRIP001 	if(!eState)
//STRIP001 		rBox.Enable(FALSE);
//STRIP001 	else if(eState >= SFX_ITEM_AVAILABLE)
//STRIP001 	{
//STRIP001 		rBox.EnableTriState( FALSE );
//STRIP001 		rBox.Check(((const SfxBoolItem&)rSet.Get(nWhich)).GetValue());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rBox.SetState( STATE_DONTKNOW );
//STRIP001 	rBox.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxAsianTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	lcl_SetBox(rSet, SID_ATTR_PARA_FORBIDDEN_RULES, aForbiddenRulesCB );
//STRIP001 //	lcl_SetBox(rSet, , aAllowWordBreakCB );
//STRIP001 	lcl_SetBox(rSet, SID_ATTR_PARA_HANGPUNCTUATION, aHangingPunctCB );
//STRIP001 
//STRIP001 
//STRIP001 	//character distance not yet available
//STRIP001 //	lcl_SetBox(rSet, , aPuntuationCB    );
//STRIP001 	lcl_SetBox(rSet, SID_ATTR_PARA_SCRIPTSPACE, aScriptSpaceCB );
//STRIP001 //	lcl_SetBox(rSet, , aAdjustNumbersCB );
//STRIP001 	aAllowWordBreakCB	.Enable(FALSE);
//STRIP001 	aPuntuationCB		.Enable(FALSE);
//STRIP001 	aAdjustNumbersCB	.Enable(FALSE);
//STRIP001 }
//STRIP001 /* -----------------------------19.12.00 12:59--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxAsianTabPage, ClickHdl_Impl, TriStateBox*, pBox )
//STRIP001 {
//STRIP001 	pBox->EnableTriState( FALSE );
//STRIP001 	return 0;
//STRIP001 }
}
