/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ThreadedMatcherEditor
extends AbstractMatcherEditor {
    private final MatcherEditor source;
    private final List matcherEventQueue = new LinkedList();
    private MatcherEditor.Listener queuingMatcherEditorListener = new QueuingMatcherEditorListener();
    private boolean isDrainingQueue = false;
    private Runnable drainMatcherEventQueueRunnable = new DrainMatcherEventQueueRunnable();

    public ThreadedMatcherEditor(MatcherEditor source) {
        if (source == null) {
            throw new NullPointerException("source may not be null");
        }
        this.source = source;
        this.source.addMatcherEditorListener(this.queuingMatcherEditorListener);
    }

    public Matcher getMatcher() {
        return this.source.getMatcher();
    }

    protected MatcherEditor.Event coalesceMatcherEvents(List matcherEvents) {
        boolean changeType = false;
        MatcherEditor.Event lastMatcherEvent = (MatcherEditor.Event)matcherEvents.get(matcherEvents.size() - 1);
        int lastMatcherEventType = lastMatcherEvent.getType();
        if (lastMatcherEventType != 0 && lastMatcherEventType != 1) {
            boolean constrained = false;
            boolean relaxed = false;
            Iterator i = matcherEvents.iterator();
            while (i.hasNext()) {
                switch (((MatcherEditor.Event)i.next()).getType()) {
                    case 0: {
                        relaxed = true;
                        break;
                    }
                    case 1: {
                        constrained = true;
                        break;
                    }
                    case 3: {
                        relaxed = true;
                        break;
                    }
                    case 2: {
                        constrained = true;
                        break;
                    }
                    case 4: {
                        relaxed = true;
                        constrained = true;
                    }
                }
            }
            changeType = constrained && relaxed;
        }
        return new MatcherEditor.Event(this, changeType ? 4 : lastMatcherEventType, lastMatcherEvent.getMatcher());
    }

    protected void executeMatcherEventQueueRunnable(Runnable runnable) {
        new Thread(runnable, "MatcherQueueThread").start();
    }

    private class DrainMatcherEventQueueRunnable
    implements Runnable {
        private DrainMatcherEventQueueRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                MatcherEditor.Event matcherEvent;
                List list = ThreadedMatcherEditor.this.matcherEventQueue;
                synchronized (list) {
                    if (ThreadedMatcherEditor.this.matcherEventQueue.isEmpty()) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                        return;
                    }
                    matcherEvent = ThreadedMatcherEditor.this.coalesceMatcherEvents(ThreadedMatcherEditor.this.matcherEventQueue);
                    ThreadedMatcherEditor.this.matcherEventQueue.clear();
                }
                try {
                    ThreadedMatcherEditor.this.fireChangedMatcher(matcherEvent);
                }
                catch (Error e) {
                    List list2 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list2) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    List list3 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list3) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw e;
                }
            }
        }
    }

    private class QueuingMatcherEditorListener
    implements MatcherEditor.Listener {
        private QueuingMatcherEditorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedMatcher(MatcherEditor.Event matcherEvent) {
            List list = ThreadedMatcherEditor.this.matcherEventQueue;
            synchronized (list) {
                ThreadedMatcherEditor.this.matcherEventQueue.add(matcherEvent);
                if (!ThreadedMatcherEditor.this.isDrainingQueue) {
                    ThreadedMatcherEditor.this.isDrainingQueue = true;
                    ThreadedMatcherEditor.this.executeMatcherEventQueueRunnable(ThreadedMatcherEditor.this.drainMatcherEventQueueRunnable);
                }
            }
        }
    }
}

