.\" This manpage was written by Richard Braakman and is licensed under the
.\" XFree86 license.
.\" $XFree86: xc/programs/x11perf/Xmark.man,v 1.2 2001/01/24 00:06:42 dawes Exp $
.TH Xmark 1 __xorgversion__
.SH NAME
Xmark \- summarize x11perf results
.SH SYNTAX
.B Xmark
datafile
.SH DESCRIPTION
.B Xmark
is a shell script that reads the indicated datafile and compiles a
benchmark which it writes to standard output.  It writes three
numbers:
.PP
.RS
A weighted performance number for the
.I x11perf
results.
.PP
A weighted performance number for a standard SparcStation 1, with
SunOS 4.1.2, X11R5 Xsun, and a CG3 dumb Color Frame Buffer.
.\" I assume the latter is a graphics card.
.PP
The Xmark, which is the ratio of the two numbers above.
.RE
.PP
The datafile must be an ordinary file, produced by x11perf in the
following way:
.PP
.BI "x11perf -display " display " -v1.3 -rop GXcopy GXxor -all > " datafile
.PP
It is possible to run the GXcopy and GXxor tests separately, as long as they
are concatenated to the same output file:
.PP
.BI "x11perf -display " display " -v1.3 -rop GXcopy -all > " datafile 
.br
.BI "x11perf -display " display " -v1.3 -rop GXxor -all >> " datafile 
.PP
or
.PP
.BI "x11perf -display " display " -v1.3 -rop GXxor -all > " datafile 
.br
.BI "x11perf -display " display " -v1.3 -rop GXcopy -all >> " datafile 
.PP
.SH FILES
.TP
.B temp.$$
Temporary file created in the current directory, deleted after use.
.SH DIAGNOSTICS
.TP
.B Usage: Xmark datafile
.I Xmark
was invoked without arguments or with more than one argument, or 
with options.  Xmark takes no options.
.TP
.B "Error: data file does not exist or is not ordinary."
.I Xmark
cannot find the datafile named on its command line, or the datafile
is a special file such as a directory.
.TP
.BR "WARNING: datafile contains " nnn ", not 441 or 447 'trep' results;"
The file named on the command line does not seem to be a file generated
by x11perf in the expected way.
.TP
.BR "Diagnostic: ERROR: sum of weights =" nnn ", not equal to 4566.0;"
There is an internal error in Xmark.
.SH "SEE ALSO"
X(__miscmansuffix__), x11perf(1), x11perfcomp(1)
