/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void day_totalize(const char *tmp, const char *user, int indexonly)
{

   FILE *fp_in, *fp_ou;

   char data[20];
   char hora[20];
   char min[20];
   char elap[20];
   char odata[20];
   char ohora[20];
   char oelap[20];
   char csort[255];
   char wdirname[MAXLEN];
   char sortout[MAXLEN];
   char arqout[MAXLEN];
   int  regs=0;
   long long int telap=0;
   int cstatus;
   struct getwordstruct gwarea;

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   sprintf(wdirname,"%s/%s.htmp",tmp,user);
   sprintf(arqout,"%s/%s.day",tmp,user);
   sprintf(sortout,"%s/%s.sort",tmp,user);

   sprintf(csort,"sort -k 1,1 -k 2,2 -o \"%s\" \"%s\"",sortout,wdirname);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }
   if((fp_in=fopen(sortout,"r"))==NULL) {
      fprintf(stderr, "SARG: (totday) %s: %s\n",text[8],sortout);
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(wdirname);

   if((fp_ou=fopen(arqout,"w"))==NULL) {
     fprintf(stderr, "SARG: (totday) %s: %s\n",text[8],arqout);
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      fixendofline(buf);
      getword_start(&gwarea,buf);
      if (getword(data,sizeof(data),&gwarea,'\t')<0 || getword(hora,sizeof(hora),&gwarea,':')<0 ||
          getword(min,sizeof(min),&gwarea,':')<0 || getword_skip(20,&gwarea,'\t')<0 ||
          getword(elap,sizeof(elap),&gwarea,0)<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",sortout);
         exit(1);
      }

      if(!regs) {
         strcpy(odata,data);
         strcpy(ohora,hora);
         strcpy(oelap,elap);
         regs++;
      }

      if(strcmp(hora,ohora) != 0 || strcmp(data,odata) != 0) {
         my_lltoa(telap,val1,15);
         fprintf(fp_ou,"%s\t%s\t%s\n",odata,ohora,val1);
         strcpy(odata,data);
         strcpy(ohora,hora);
         telap=0;
      }

      telap+=my_atoll(elap);
   }

   my_lltoa(telap,val1,15);
   fprintf(fp_ou,"%s\t%s\t%s\n",data,hora,val1);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(sortout);

   return;

}
