/* Generated by re2c */
#line 1 "parse_date.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 845 "parse_date.re"



#line 743 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	if((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	switch(yych) {
	case 0x00:
	case 0x0A:	goto yy48;
	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':
	case '-':	goto yy41;
	case ',':
	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy25;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy43;
	case 'D':	goto yy31;
	case 'E':	goto yy35;
	case 'F':	goto yy23;
	case 'I':	goto yy18;
	case 'J':	goto yy21;
	case 'L':	goto yy37;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy29;
	case 'P':	goto yy39;
	case 'S':	goto yy27;
	case 'T':	goto yy9;
	case 'V':	goto yy19;
	case 'W':	goto yy33;
	case 'X':	goto yy20;
	case 'Y':	goto yy2;
	case 'a':	goto yy26;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy44;
	case 'd':	goto yy32;
	case 'e':	goto yy36;
	case 'f':	goto yy24;
	case 'j':	goto yy22;
	case 'l':	goto yy38;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy30;
	case 'p':	goto yy40;
	case 's':	goto yy28;
	case 't':	goto yy10;
	case 'w':	goto yy34;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy1302;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy1311;
	default:	goto yy3;
	}
yy3:
#line 1340 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 893 "<stdout>"
yy4:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy1302;
	default:	goto yy3;
	}
yy5:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy1273;
	case 'I':	goto yy1274;
	case 'O':	goto yy1272;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy1289;
	case 'i':	goto yy1290;
	case 'o':	goto yy1288;
	default:	goto yy3;
	}
yy6:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy1273;
	case 'I':
	case 'i':	goto yy1274;
	case 'O':
	case 'o':	goto yy1272;
	default:	goto yy3;
	}
yy7:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':	goto yy1244;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'I':	goto yy1245;
	case 'O':	goto yy1246;
	case 'a':	goto yy1258;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'i':	goto yy1259;
	case 'o':	goto yy1260;
	default:	goto yy3;
	}
yy8:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy1244;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'I':
	case 'i':	goto yy1245;
	case 'O':
	case 'o':	goto yy1246;
	default:	goto yy3;
	}
yy9:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy1180;
	case 'H':	goto yy1181;
	case 'O':	goto yy1182;
	case 'U':	goto yy1183;
	case 'W':	goto yy1184;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy1213;
	case 'h':	goto yy1214;
	case 'o':	goto yy1215;
	case 'u':	goto yy1216;
	case 'w':	goto yy1217;
	default:	goto yy3;
	}
yy10:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy1180;
	case 'H':
	case 'h':	goto yy1181;
	case 'O':
	case 'o':	goto yy1182;
	case 'U':
	case 'u':	goto yy1183;
	case 'W':
	case 'w':	goto yy1184;
	default:	goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy1176;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1177;
	default:	goto yy12;
	}
yy12:
#line 1406 "parse_date.re"
	{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 1323 "<stdout>"
yy13:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1140;
	case '-':	goto yy615;
	case '.':	goto yy1142;
	case '/':	goto yy614;
	case '0':	goto yy1175;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1174;
	case ':':	goto yy1143;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy14:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':	goto yy1174;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1141;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy15:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1141;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1138;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy16:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':	goto yy1138;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy17:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy18:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'Y':
	case 'Z':	goto yy133;
	case 'I':	goto yy602;
	case 'V':
	case 'X':	goto yy601;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	default:	goto yy3;
	}
yy19:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'I':	goto yy599;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	default:	goto yy3;
	}
yy20:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'I':	goto yy597;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	default:	goto yy3;
	}
yy21:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':	goto yy580;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'U':	goto yy579;
	case 'a':	goto yy589;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'u':	goto yy588;
	default:	goto yy3;
	}
yy22:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy580;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'U':
	case 'u':	goto yy579;
	default:	goto yy3;
	}
yy23:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy541;
	case 'I':	goto yy542;
	case 'O':	goto yy543;
	case 'R':	goto yy544;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy560;
	case 'i':	goto yy561;
	case 'o':	goto yy562;
	case 'r':	goto yy563;
	default:	goto yy3;
	}
yy24:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy541;
	case 'I':
	case 'i':	goto yy542;
	case 'O':
	case 'o':	goto yy543;
	case 'R':
	case 'r':	goto yy544;
	default:	goto yy3;
	}
yy25:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'G':	goto yy524;
	case 'P':	goto yy523;
	case 'U':	goto yy522;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'g':	goto yy534;
	case 'p':	goto yy533;
	case 'u':	goto yy532;
	default:	goto yy3;
	}
yy26:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'G':
	case 'g':	goto yy524;
	case 'P':
	case 'p':	goto yy523;
	case 'U':
	case 'u':	goto yy522;
	default:	goto yy3;
	}
yy27:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':	goto yy469;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy468;
	case 'I':	goto yy470;
	case 'U':	goto yy471;
	case 'a':	goto yy496;
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy495;
	case 'i':	goto yy497;
	case 'u':	goto yy498;
	default:	goto yy3;
	}
yy28:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy469;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy468;
	case 'I':
	case 'i':	goto yy470;
	case 'U':
	case 'u':	goto yy471;
	default:	goto yy3;
	}
yy29:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'C':	goto yy458;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'c':	goto yy463;
	default:	goto yy3;
	}
yy30:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'C':
	case 'c':	goto yy458;
	default:	goto yy3;
	}
yy31:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy356;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy451;
	default:	goto yy3;
	}
yy32:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy356;
	default:	goto yy3;
	}
yy33:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy339;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'e':	goto yy348;
	default:	goto yy3;
	}
yy34:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy339;
	default:	goto yy3;
	}
yy35:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'I':	goto yy321;
	case 'L':	goto yy322;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'i':	goto yy330;
	case 'l':	goto yy331;
	default:	goto yy3;
	}
yy36:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'I':
	case 'i':	goto yy321;
	case 'L':
	case 'l':	goto yy322;
	default:	goto yy3;
	}
yy37:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':	goto yy315;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'a':	goto yy318;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	default:	goto yy3;
	}
yy38:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy315;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	default:	goto yy3;
	}
yy39:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'R':	goto yy153;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	case 'r':	goto yy235;
	default:	goto yy3;
	}
yy40:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'R':
	case 'r':	goto yy153;
	default:	goto yy3;
	}
yy41:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy54;
	case '0':
	case '1':	goto yy146;
	case '2':	goto yy147;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy148;
	default:	goto yy12;
	}
yy42:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy12;
	}
yy43:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy136;
	default:	goto yy3;
	}
yy44:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	default:	goto yy3;
	}
yy45:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy54;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy46;
	}
yy46:
#line 1395 "parse_date.re"
	{
		goto std;
	}
#line 3258 "<stdout>"
yy47:
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	++YYCURSOR;
#line 1400 "parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 3269 "<stdout>"
yy50:
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy56;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case 'D':
	case 'd':	goto yy61;
	case 'F':
	case 'f':	goto yy63;
	case 'H':
	case 'h':	goto yy60;
	case 'M':
	case 'm':	goto yy59;
	case 'S':
	case 's':	goto yy58;
	case 'T':
	case 't':	goto yy65;
	case 'W':
	case 'w':	goto yy62;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy53:
	YYCURSOR = YYMARKER;
	switch(yyaccept) {
	case 0: 	goto yy12;
	case 1: 	goto yy3;
	case 2: 	goto yy46;
	case 3: 	goto yy69;
	case 4: 	goto yy172;
	case 5: 	goto yy341;
	case 6: 	goto yy363;
	case 7: 	goto yy385;
	case 8: 	goto yy420;
	case 9: 	goto yy526;
	case 10: 	goto yy620;
	case 11: 	goto yy634;
	case 12: 	goto yy775;
	case 13: 	goto yy784;
	case 14: 	goto yy880;
	case 15: 	goto yy916;
	case 16: 	goto yy943;
	case 17: 	goto yy889;
	case 18: 	goto yy1043;
	case 19: 	goto yy937;
	case 20: 	goto yy1146;
	case 21: 	goto yy1154;
	case 22: 	goto yy1200;
	case 23: 	goto yy1203;
	case 24: 	goto yy1279;
	case 25: 	goto yy1287;
	case 26: 	goto yy1310;
	}
yy54:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy54;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy53;
	}
yy56:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy57:
	switch(yych) {
	case ' ':	goto yy56;
	case 'D':
	case 'd':	goto yy61;
	case 'F':
	case 'f':	goto yy63;
	case 'H':
	case 'h':	goto yy60;
	case 'M':
	case 'm':	goto yy59;
	case 'S':
	case 's':	goto yy58;
	case 'T':
	case 't':	goto yy65;
	case 'W':
	case 'w':	goto yy62;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy58:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy119;
	case 'E':
	case 'e':	goto yy120;
	case 'U':
	case 'u':	goto yy118;
	default:	goto yy53;
	}
yy59:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy110;
	case 'O':
	case 'o':	goto yy109;
	default:	goto yy53;
	}
yy60:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy107;
	default:	goto yy53;
	}
yy61:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy106;
	default:	goto yy53;
	}
yy62:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy98;
	default:	goto yy53;
	}
yy63:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy83;
	case 'R':
	case 'r':	goto yy82;
	default:	goto yy53;
	}
yy64:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy79;
	default:	goto yy53;
	}
yy65:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy66;
	case 'U':
	case 'u':	goto yy67;
	default:	goto yy53;
	}
yy66:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy74;
	default:	goto yy53;
	}
yy67:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy68;
	default:	goto yy53;
	}
yy68:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'S':
	case 's':	goto yy70;
	default:	goto yy69;
	}
yy69:
#line 1379 "parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3485 "<stdout>"
yy70:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy71;
	default:	goto yy53;
	}
yy71:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy72;
	default:	goto yy53;
	}
yy72:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy73:
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'R':
	case 'r':	goto yy75;
	default:	goto yy69;
	}
yy75:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy76;
	default:	goto yy53;
	}
yy76:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy77;
	default:	goto yy53;
	}
yy77:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy78;
	default:	goto yy53;
	}
yy78:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy79:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy80;
	default:	goto yy53;
	}
yy80:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy81;
	default:	goto yy53;
	}
yy81:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy73;
	default:	goto yy69;
	}
yy82:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy95;
	default:	goto yy53;
	}
yy83:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy84;
	default:	goto yy53;
	}
yy84:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy85;
	default:	goto yy53;
	}
yy85:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy87;
	case 'N':
	case 'n':	goto yy86;
	default:	goto yy53;
	}
yy86:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy92;
	default:	goto yy53;
	}
yy87:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy88;
	default:	goto yy53;
	}
yy88:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy89;
	default:	goto yy53;
	}
yy89:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy90;
	default:	goto yy53;
	}
yy90:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy91;
	default:	goto yy53;
	}
yy91:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy81;
	default:	goto yy53;
	}
yy92:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy93;
	default:	goto yy53;
	}
yy93:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy94;
	default:	goto yy53;
	}
yy94:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy81;
	default:	goto yy53;
	}
yy95:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy96;
	default:	goto yy69;
	}
yy96:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy97;
	default:	goto yy53;
	}
yy97:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy98:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy100;
	case 'E':
	case 'e':	goto yy99;
	default:	goto yy53;
	}
yy99:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'K':
	case 'k':	goto yy81;
	default:	goto yy53;
	}
yy100:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'N':
	case 'n':	goto yy101;
	default:	goto yy69;
	}
yy101:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy102;
	default:	goto yy53;
	}
yy102:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy103;
	default:	goto yy53;
	}
yy103:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy104;
	default:	goto yy53;
	}
yy104:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy105;
	default:	goto yy53;
	}
yy105:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy106:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy81;
	default:	goto yy53;
	}
yy107:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy108;
	default:	goto yy53;
	}
yy108:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy81;
	default:	goto yy53;
	}
yy109:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy114;
	default:	goto yy53;
	}
yy110:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy111;
	default:	goto yy53;
	}
yy111:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'S':
	case 's':	goto yy73;
	case 'U':
	case 'u':	goto yy112;
	default:	goto yy69;
	}
yy112:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy113;
	default:	goto yy53;
	}
yy113:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy81;
	default:	goto yy53;
	}
yy114:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy115;
	case 'T':
	case 't':	goto yy116;
	default:	goto yy69;
	}
yy115:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy117;
	default:	goto yy53;
	}
yy116:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy81;
	default:	goto yy53;
	}
yy117:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy118:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy129;
	default:	goto yy53;
	}
yy119:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy124;
	default:	goto yy53;
	}
yy120:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy121;
	default:	goto yy53;
	}
yy121:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'O':
	case 'o':	goto yy122;
	case 'S':
	case 's':	goto yy73;
	default:	goto yy69;
	}
yy122:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy123;
	default:	goto yy53;
	}
yy123:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy81;
	default:	goto yy53;
	}
yy124:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'U':
	case 'u':	goto yy125;
	default:	goto yy69;
	}
yy125:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy126;
	default:	goto yy53;
	}
yy126:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy127;
	default:	goto yy53;
	}
yy127:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy128;
	default:	goto yy53;
	}
yy128:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy129:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy130;
	default:	goto yy69;
	}
yy130:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy131;
	default:	goto yy53;
	}
yy131:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy73;
	default:	goto yy53;
	}
yy132:
	yych = *++YYCURSOR;
	goto yy3;
yy133:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	default:	goto yy3;
	}
yy134:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy3;
	}
yy135:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	default:	goto yy3;
	}
yy136:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	default:	goto yy3;
	}
yy137:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy3;
	}
yy138:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy139;
	default:	goto yy53;
	}
yy139:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	default:	goto yy53;
	}
yy140:
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	default:	goto yy3;
	}
yy142:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy143:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy144:
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy53;
	}
yy145:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	default:	goto yy3;
	}
yy146:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy148;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy147:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy148;
	case '4':
	case '5':	goto yy150;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy148:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy150;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy149:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy152;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy132;
	default:	goto yy3;
	}
yy150:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	default:	goto yy3;
	}
yy151:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy3;
	}
yy152:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy132;
	default:	goto yy3;
	}
yy153:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'E':
	case 'e':	goto yy154;
	default:	goto yy3;
	}
yy154:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'V':
	case 'v':	goto yy155;
	default:	goto yy3;
	}
yy155:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'I':
	case 'i':	goto yy156;
	default:	goto yy3;
	}
yy156:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy157;
	default:	goto yy53;
	}
yy157:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy158;
	default:	goto yy53;
	}
yy158:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy159;
	default:	goto yy53;
	}
yy159:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy160:
	switch(yych) {
	case ' ':	goto yy159;
	case 'D':
	case 'd':	goto yy164;
	case 'F':
	case 'f':	goto yy166;
	case 'H':
	case 'h':	goto yy163;
	case 'M':
	case 'm':	goto yy162;
	case 'S':
	case 's':	goto yy161;
	case 'T':
	case 't':	goto yy168;
	case 'W':
	case 'w':	goto yy165;
	case 'Y':
	case 'y':	goto yy167;
	default:	goto yy53;
	}
yy161:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy222;
	case 'E':
	case 'e':	goto yy223;
	case 'U':
	case 'u':	goto yy221;
	default:	goto yy53;
	}
yy162:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy213;
	case 'O':
	case 'o':	goto yy212;
	default:	goto yy53;
	}
yy163:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy210;
	default:	goto yy53;
	}
yy164:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy209;
	default:	goto yy53;
	}
yy165:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy201;
	default:	goto yy53;
	}
yy166:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy186;
	case 'R':
	case 'r':	goto yy185;
	default:	goto yy53;
	}
yy167:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy182;
	default:	goto yy53;
	}
yy168:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy169;
	case 'U':
	case 'u':	goto yy170;
	default:	goto yy53;
	}
yy169:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy177;
	default:	goto yy53;
	}
yy170:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy171;
	default:	goto yy53;
	}
yy171:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'S':
	case 's':	goto yy173;
	default:	goto yy172;
	}
yy172:
#line 1323 "parse_date.re"
	{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 4886 "<stdout>"
yy173:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy174;
	default:	goto yy53;
	}
yy174:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy175;
	default:	goto yy53;
	}
yy175:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy176:
	yych = *++YYCURSOR;
	goto yy172;
yy177:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'R':
	case 'r':	goto yy178;
	default:	goto yy172;
	}
yy178:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy179;
	default:	goto yy53;
	}
yy179:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy180;
	default:	goto yy53;
	}
yy180:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy181;
	default:	goto yy53;
	}
yy181:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy182:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy183;
	default:	goto yy53;
	}
yy183:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy184;
	default:	goto yy53;
	}
yy184:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy176;
	default:	goto yy172;
	}
yy185:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy198;
	default:	goto yy53;
	}
yy186:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy187;
	default:	goto yy53;
	}
yy187:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy188;
	default:	goto yy53;
	}
yy188:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy190;
	case 'N':
	case 'n':	goto yy189;
	default:	goto yy53;
	}
yy189:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy195;
	default:	goto yy53;
	}
yy190:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy191;
	default:	goto yy53;
	}
yy191:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':
	case 'i':	goto yy192;
	default:	goto yy53;
	}
yy192:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy193;
	default:	goto yy53;
	}
yy193:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy194;
	default:	goto yy53;
	}
yy194:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy184;
	default:	goto yy53;
	}
yy195:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy196;
	default:	goto yy53;
	}
yy196:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy197;
	default:	goto yy53;
	}
yy197:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy184;
	default:	goto yy53;
	}
yy198:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy199;
	default:	goto yy172;
	}
yy199:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy200;
	default:	goto yy53;
	}
yy200:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy201:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy203;
	case 'E':
	case 'e':	goto yy202;
	default:	goto yy53;
	}
yy202:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'K':
	case 'k':	goto yy184;
	default:	goto yy53;
	}
yy203:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'N':
	case 'n':	goto yy204;
	default:	goto yy172;
	}
yy204:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy205;
	default:	goto yy53;
	}
yy205:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy206;
	default:	goto yy53;
	}
yy206:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy207;
	default:	goto yy53;
	}
yy207:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy208;
	default:	goto yy53;
	}
yy208:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy209:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy184;
	default:	goto yy53;
	}
yy210:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy211;
	default:	goto yy53;
	}
yy211:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy184;
	default:	goto yy53;
	}
yy212:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy217;
	default:	goto yy53;
	}
yy213:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy214;
	default:	goto yy53;
	}
yy214:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'S':
	case 's':	goto yy176;
	case 'U':
	case 'u':	goto yy215;
	default:	goto yy172;
	}
yy215:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy216;
	default:	goto yy53;
	}
yy216:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy184;
	default:	goto yy53;
	}
yy217:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy218;
	case 'T':
	case 't':	goto yy219;
	default:	goto yy172;
	}
yy218:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy220;
	default:	goto yy53;
	}
yy219:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy184;
	default:	goto yy53;
	}
yy220:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy221:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy232;
	default:	goto yy53;
	}
yy222:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy227;
	default:	goto yy53;
	}
yy223:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy224;
	default:	goto yy53;
	}
yy224:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'O':
	case 'o':	goto yy225;
	case 'S':
	case 's':	goto yy176;
	default:	goto yy172;
	}
yy225:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy226;
	default:	goto yy53;
	}
yy226:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy184;
	default:	goto yy53;
	}
yy227:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'U':
	case 'u':	goto yy228;
	default:	goto yy172;
	}
yy228:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy229;
	default:	goto yy53;
	}
yy229:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy230;
	default:	goto yy53;
	}
yy230:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy231;
	default:	goto yy53;
	}
yy231:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy232:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'D':
	case 'd':	goto yy233;
	default:	goto yy172;
	}
yy233:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy234;
	default:	goto yy53;
	}
yy234:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy176;
	default:	goto yy53;
	}
yy235:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'E':	goto yy154;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'e':	goto yy236;
	default:	goto yy3;
	}
yy236:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'V':	goto yy155;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'v':	goto yy237;
	default:	goto yy3;
	}
yy237:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'I':	goto yy156;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'i':	goto yy238;
	default:	goto yy3;
	}
yy238:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':	goto yy157;
	case 'o':	goto yy239;
	default:	goto yy144;
	}
yy239:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':	goto yy158;
	case 'u':	goto yy240;
	default:	goto yy144;
	}
yy240:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy241;
	default:	goto yy53;
	}
yy241:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy143;
	case 'd':	goto yy245;
	case 'f':	goto yy247;
	case 'h':	goto yy244;
	case 'm':	goto yy243;
	case 's':	goto yy242;
	case 't':	goto yy249;
	case 'w':	goto yy246;
	case 'y':	goto yy248;
	default:	goto yy160;
	}
yy242:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy222;
	case 'E':	goto yy223;
	case 'U':	goto yy221;
	case 'a':	goto yy301;
	case 'e':	goto yy302;
	case 'u':	goto yy303;
	default:	goto yy144;
	}
yy243:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy213;
	case 'O':	goto yy212;
	case 'i':	goto yy292;
	case 'o':	goto yy293;
	default:	goto yy144;
	}
yy244:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':	goto yy210;
	case 'o':	goto yy290;
	default:	goto yy144;
	}
yy245:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy209;
	case 'a':	goto yy289;
	default:	goto yy144;
	}
yy246:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy201;
	case 'e':	goto yy281;
	default:	goto yy144;
	}
yy247:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':	goto yy186;
	case 'R':	goto yy185;
	case 'o':	goto yy265;
	case 'r':	goto yy266;
	default:	goto yy144;
	}
yy248:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy182;
	case 'e':	goto yy262;
	default:	goto yy144;
	}
yy249:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy169;
	case 'U':	goto yy170;
	case 'h':	goto yy250;
	case 'u':	goto yy251;
	default:	goto yy144;
	}
yy250:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':	goto yy177;
	case 'u':	goto yy257;
	default:	goto yy144;
	}
yy251:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy171;
	case 'e':	goto yy252;
	default:	goto yy144;
	}
yy252:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy173;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy253;
	default:	goto yy172;
	}
yy253:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy174;
	case 'd':	goto yy254;
	default:	goto yy144;
	}
yy254:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy175;
	case 'a':	goto yy255;
	default:	goto yy144;
	}
yy255:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy256:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy172;
	}
yy257:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy178;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy258;
	default:	goto yy172;
	}
yy258:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':	goto yy179;
	case 's':	goto yy259;
	default:	goto yy144;
	}
yy259:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy180;
	case 'd':	goto yy260;
	default:	goto yy144;
	}
yy260:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy181;
	case 'a':	goto yy261;
	default:	goto yy144;
	}
yy261:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy262:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy183;
	case 'a':	goto yy263;
	default:	goto yy144;
	}
yy263:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy184;
	case 'r':	goto yy264;
	default:	goto yy144;
	}
yy264:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy176;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy256;
	default:	goto yy172;
	}
yy265:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy187;
	case 'r':	goto yy270;
	default:	goto yy144;
	}
yy266:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy198;
	case 'i':	goto yy267;
	default:	goto yy144;
	}
yy267:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy199;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy268;
	default:	goto yy172;
	}
yy268:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy200;
	case 'a':	goto yy269;
	default:	goto yy144;
	}
yy269:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy270:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy188;
	case 't':	goto yy271;
	default:	goto yy144;
	}
yy271:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy190;
	case 'N':	goto yy189;
	case 'h':	goto yy273;
	case 'n':	goto yy272;
	default:	goto yy144;
	}
yy272:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy195;
	case 'i':	goto yy278;
	default:	goto yy144;
	}
yy273:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy191;
	case 'n':	goto yy274;
	default:	goto yy144;
	}
yy274:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy192;
	case 'i':	goto yy275;
	default:	goto yy144;
	}
yy275:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':	goto yy193;
	case 'g':	goto yy276;
	default:	goto yy144;
	}
yy276:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy194;
	case 'h':	goto yy277;
	default:	goto yy144;
	}
yy277:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy184;
	case 't':	goto yy264;
	default:	goto yy144;
	}
yy278:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':	goto yy196;
	case 'g':	goto yy279;
	default:	goto yy144;
	}
yy279:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy197;
	case 'h':	goto yy280;
	default:	goto yy144;
	}
yy280:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy184;
	case 't':	goto yy264;
	default:	goto yy144;
	}
yy281:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy203;
	case 'E':	goto yy202;
	case 'd':	goto yy283;
	case 'e':	goto yy282;
	default:	goto yy144;
	}
yy282:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'K':	goto yy184;
	case 'k':	goto yy264;
	default:	goto yy144;
	}
yy283:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'N':	goto yy204;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'n':	goto yy284;
	default:	goto yy172;
	}
yy284:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy205;
	case 'e':	goto yy285;
	default:	goto yy144;
	}
yy285:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':	goto yy206;
	case 's':	goto yy286;
	default:	goto yy144;
	}
yy286:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy207;
	case 'd':	goto yy287;
	default:	goto yy144;
	}
yy287:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy208;
	case 'a':	goto yy288;
	default:	goto yy144;
	}
yy288:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy289:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy184;
	case 'y':	goto yy264;
	default:	goto yy144;
	}
yy290:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':	goto yy211;
	case 'u':	goto yy291;
	default:	goto yy144;
	}
yy291:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy184;
	case 'r':	goto yy264;
	default:	goto yy144;
	}
yy292:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy214;
	case 'n':	goto yy298;
	default:	goto yy144;
	}
yy293:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy217;
	case 'n':	goto yy294;
	default:	goto yy144;
	}
yy294:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy218;
	case 'T':	goto yy219;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy295;
	case 't':	goto yy296;
	default:	goto yy172;
	}
yy295:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy220;
	case 'a':	goto yy297;
	default:	goto yy144;
	}
yy296:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy184;
	case 'h':	goto yy264;
	default:	goto yy144;
	}
yy297:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy298:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy176;
	case 'U':	goto yy215;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy256;
	case 'u':	goto yy299;
	default:	goto yy172;
	}
yy299:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy216;
	case 't':	goto yy300;
	default:	goto yy144;
	}
yy300:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy184;
	case 'e':	goto yy264;
	default:	goto yy144;
	}
yy301:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy227;
	case 't':	goto yy310;
	default:	goto yy144;
	}
yy302:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':	goto yy224;
	case 'c':	goto yy307;
	default:	goto yy144;
	}
yy303:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy232;
	case 'n':	goto yy304;
	default:	goto yy144;
	}
yy304:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy233;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy305;
	default:	goto yy172;
	}
yy305:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy234;
	case 'a':	goto yy306;
	default:	goto yy144;
	}
yy306:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy307:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'O':	goto yy225;
	case 'S':	goto yy176;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'o':	goto yy308;
	case 's':	goto yy256;
	default:	goto yy172;
	}
yy308:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy226;
	case 'n':	goto yy309;
	default:	goto yy144;
	}
yy309:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy184;
	case 'd':	goto yy264;
	default:	goto yy144;
	}
yy310:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'U':	goto yy228;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'u':	goto yy311;
	default:	goto yy172;
	}
yy311:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy229;
	case 'r':	goto yy312;
	default:	goto yy144;
	}
yy312:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy230;
	case 'd':	goto yy313;
	default:	goto yy144;
	}
yy313:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy231;
	case 'a':	goto yy314;
	default:	goto yy144;
	}
yy314:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy176;
	case 'y':	goto yy256;
	default:	goto yy144;
	}
yy315:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'S':
	case 's':	goto yy316;
	default:	goto yy3;
	}
yy316:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy317;
	default:	goto yy3;
	}
yy317:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy160;
	case ')':	goto yy132;
	default:	goto yy3;
	}
yy318:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'S':	goto yy316;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 's':	goto yy319;
	default:	goto yy3;
	}
yy319:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy317;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy320;
	default:	goto yy3;
	}
yy320:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':	goto yy160;
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy143;
	case 'd':	goto yy245;
	case 'f':	goto yy247;
	case 'h':	goto yy244;
	case 'm':	goto yy243;
	case 's':	goto yy242;
	case 't':	goto yy249;
	case 'w':	goto yy246;
	case 'y':	goto yy248;
	default:	goto yy3;
	}
yy321:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'G':
	case 'g':	goto yy328;
	default:	goto yy3;
	}
yy322:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'E':
	case 'e':	goto yy323;
	default:	goto yy3;
	}
yy323:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'V':
	case 'v':	goto yy324;
	default:	goto yy3;
	}
yy324:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'E':
	case 'e':	goto yy325;
	default:	goto yy3;
	}
yy325:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy326;
	default:	goto yy53;
	}
yy326:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy327;
	default:	goto yy53;
	}
yy327:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy53;
	}
yy328:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'H':
	case 'h':	goto yy329;
	default:	goto yy3;
	}
yy329:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'T':
	case 't':	goto yy159;
	default:	goto yy3;
	}
yy330:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'G':	goto yy328;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'g':	goto yy337;
	default:	goto yy3;
	}
yy331:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'E':	goto yy323;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'e':	goto yy332;
	default:	goto yy3;
	}
yy332:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'V':	goto yy324;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'v':	goto yy333;
	default:	goto yy3;
	}
yy333:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'E':	goto yy325;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'e':	goto yy334;
	default:	goto yy3;
	}
yy334:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':	goto yy326;
	case 'n':	goto yy335;
	default:	goto yy144;
	}
yy335:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy327;
	case 't':	goto yy336;
	default:	goto yy144;
	}
yy336:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy53;
	}
yy337:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'H':	goto yy329;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'h':	goto yy338;
	default:	goto yy3;
	}
yy338:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'T':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 't':	goto yy241;
	default:	goto yy3;
	}
yy339:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'D':
	case 'd':	goto yy340;
	default:	goto yy3;
	}
yy340:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'N':
	case 'n':	goto yy342;
	default:	goto yy341;
	}
yy341:
#line 1307 "parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7482 "<stdout>"
yy342:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'E':
	case 'e':	goto yy343;
	default:	goto yy3;
	}
yy343:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy344;
	default:	goto yy53;
	}
yy344:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy345;
	default:	goto yy53;
	}
yy345:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy346;
	default:	goto yy53;
	}
yy346:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy347:
	yych = *++YYCURSOR;
	goto yy341;
yy348:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'D':	goto yy340;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'd':	goto yy349;
	default:	goto yy3;
	}
yy349:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'N':	goto yy342;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'n':	goto yy350;
	default:	goto yy341;
	}
yy350:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'E':	goto yy343;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'e':	goto yy351;
	default:	goto yy3;
	}
yy351:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':	goto yy344;
	case 's':	goto yy352;
	default:	goto yy144;
	}
yy352:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy345;
	case 'd':	goto yy353;
	default:	goto yy144;
	}
yy353:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy346;
	case 'a':	goto yy354;
	default:	goto yy144;
	}
yy354:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy355:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy341;
	}
yy356:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'C':
	case 'c':	goto yy357;
	default:	goto yy3;
	}
yy357:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'E':
	case 'e':	goto yy366;
	default:	goto yy3;
	}
yy358:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy359:
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy358;
	case '0':
	case '1':
	case '2':	goto yy362;
	case '3':	goto yy364;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy365;
	default:	goto yy53;
	}
yy360:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	default:	goto yy3;
	}
yy361:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy440;
	case '1':
	case '2':	goto yy441;
	case '3':	goto yy442;
	default:	goto yy359;
	}
yy362:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy422;
	case '2':	goto yy439;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy363:
#line 1126 "parse_date.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7989 "<stdout>"
yy364:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy422;
	case '2':	goto yy371;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy372;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy365:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy370;
	case '2':	goto yy371;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy372;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy366:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'M':
	case 'm':	goto yy367;
	default:	goto yy3;
	}
yy367:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy368;
	default:	goto yy53;
	}
yy368:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy369;
	default:	goto yy53;
	}
yy369:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy358;
	default:	goto yy53;
	}
yy370:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy421;
	default:	goto yy363;
	}
yy371:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy421;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy418;
	default:	goto yy363;
	}
yy372:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy418;
	default:	goto yy363;
	}
yy373:
	yych = *++YYCURSOR;
	goto yy378;
yy374:
	yych = *++YYCURSOR;
	goto yy378;
yy375:
	yych = *++YYCURSOR;
	goto yy378;
yy376:
	yych = *++YYCURSOR;
	goto yy378;
yy377:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
yy378:
	switch(yych) {
	case ' ':
	case ',':
	case '.':
	case 'd':
	case 'h':
	case 'n':
	case 'r':
	case 's':
	case 't':	goto yy377;
	case '0':
	case '1':	goto yy379;
	case '2':	goto yy380;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy381;
	default:	goto yy363;
	}
yy379:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy417;
	default:	goto yy363;
	}
yy380:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy417;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy382;
	default:	goto yy363;
	}
yy381:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy382;
	default:	goto yy363;
	}
yy382:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy363;
	}
yy383:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy384;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy386;
	default:	goto yy53;
	}
yy384:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy387;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy386;
	default:	goto yy385;
	}
yy385:
#line 1351 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 8281 "<stdout>"
yy386:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy387;
	default:	goto yy385;
	}
yy387:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy388;
	case '6':	goto yy389;
	case '7':
	case '8':
	case '9':	goto yy390;
	default:	goto yy53;
	}
yy388:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy391;
	default:	goto yy385;
	}
yy389:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy391;
	default:	goto yy385;
	}
yy390:
	yych = *++YYCURSOR;
	goto yy385;
yy391:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy392;
	case '(':	goto yy395;
	case '+':
	case '-':	goto yy394;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy396;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy397;
	default:	goto yy385;
	}
yy392:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy392;
	case '(':	goto yy395;
	case '+':
	case '-':	goto yy394;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy396;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy397;
	default:	goto yy53;
	}
yy394:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy410;
	case '2':	goto yy411;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy412;
	default:	goto yy53;
	}
yy395:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy397;
	default:	goto yy53;
	}
yy396:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy390;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy398;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy401;
	default:	goto yy385;
	}
yy397:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy390;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy398;
	default:	goto yy385;
	}
yy398:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy390;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy399;
	default:	goto yy385;
	}
yy399:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy390;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy400;
	default:	goto yy385;
	}
yy400:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy390;
	default:	goto yy385;
	}
yy401:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy390;
	case '/':
	case '_':	goto yy403;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy399;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy402;
	default:	goto yy385;
	}
yy402:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy390;
	case '/':
	case '_':	goto yy403;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy407;
	default:	goto yy385;
	}
yy403:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy404;
	default:	goto yy53;
	}
yy404:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy53;
	}
yy405:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy403;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy405;
	default:	goto yy385;
	}
yy407:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy390;
	case '/':
	case '_':	goto yy403;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy408;
	default:	goto yy385;
	}
yy408:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy403;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy408;
	default:	goto yy53;
	}
yy410:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy412;
	case ':':	goto yy413;
	default:	goto yy385;
	}
yy411:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy412;
	case '4':
	case '5':	goto yy414;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy390;
	case ':':	goto yy413;
	default:	goto yy385;
	}
yy412:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy414;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy390;
	case ':':	goto yy413;
	default:	goto yy385;
	}
yy413:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy414;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy390;
	default:	goto yy385;
	}
yy414:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy390;
	default:	goto yy385;
	}
yy415:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy416;
	default:	goto yy363;
	}
yy416:
	yych = *++YYCURSOR;
	goto yy363;
yy417:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy363;
	}
yy418:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy419;
	default:	goto yy363;
	}
yy419:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy416;
	default:	goto yy420;
	}
yy420:
#line 1100 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 9215 "<stdout>"
yy421:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy419;
	default:	goto yy363;
	}
yy422:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy423;
	case '0':
	case '1':	goto yy424;
	case '2':	goto yy425;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy426;
	case ':':	goto yy383;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy423:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy429;
	case '2':	goto yy430;
	case '3':
	case '4':
	case '5':	goto yy431;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy432;
	default:	goto yy378;
	}
yy424:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy428;
	default:	goto yy363;
	}
yy425:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy428;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy427;
	default:	goto yy363;
	}
yy426:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy427;
	default:	goto yy363;
	}
yy427:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy420;
	}
yy428:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy383;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy420;
	}
yy429:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy433;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy438;
	default:	goto yy363;
	}
yy430:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy433;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy438;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy437;
	default:	goto yy363;
	}
yy431:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy433;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy437;
	default:	goto yy363;
	}
yy432:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy433;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy382;
	default:	goto yy363;
	}
yy433:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy434;
	case '6':	goto yy435;
	case '7':
	case '8':
	case '9':	goto yy386;
	default:	goto yy53;
	}
yy434:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy387;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy436;
	default:	goto yy385;
	}
yy435:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy387;
	case '0':	goto yy391;
	default:	goto yy385;
	}
yy436:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy392;
	case '(':	goto yy395;
	case '+':
	case '-':	goto yy394;
	case '.':
	case ':':	goto yy387;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy396;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy397;
	default:	goto yy385;
	}
yy437:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy387;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy363;
	}
yy438:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy433;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy415;
	default:	goto yy363;
	}
yy439:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy423;
	case '0':
	case '1':	goto yy424;
	case '2':	goto yy425;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy426;
	case ':':	goto yy383;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy440:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy422;
	case '1':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case '2':	goto yy450;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy441:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case '2':	goto yy450;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy442:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy443;
	case '2':	goto yy371;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy372;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy443:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy444;
	case '.':	goto yy423;
	case '0':
	case '1':	goto yy424;
	case '2':	goto yy425;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy426;
	case ':':	goto yy383;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy444:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy445;
	default:	goto yy53;
	}
yy445:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy447;
	default:	goto yy446;
	}
yy446:
#line 1238 "parse_date.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 9717 "<stdout>"
yy447:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy448;
	default:	goto yy446;
	}
yy448:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy449;
	default:	goto yy446;
	}
yy449:
	yych = *++YYCURSOR;
	goto yy446;
yy450:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy444;
	case '.':	goto yy423;
	case '0':
	case '1':	goto yy424;
	case '2':	goto yy425;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy426;
	case ':':	goto yy383;
	case 'n':	goto yy374;
	case 'r':	goto yy375;
	case 's':	goto yy373;
	case 't':	goto yy376;
	default:	goto yy378;
	}
yy451:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'C':	goto yy357;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'c':	goto yy452;
	default:	goto yy3;
	}
yy452:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'E':	goto yy366;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy453;
	default:	goto yy3;
	}
yy453:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'M':	goto yy367;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'm':	goto yy454;
	default:	goto yy3;
	}
yy454:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':	goto yy368;
	case 'b':	goto yy455;
	default:	goto yy144;
	}
yy455:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy369;
	case 'e':	goto yy456;
	default:	goto yy144;
	}
yy456:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy457;
	default:	goto yy53;
	}
yy457:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy359;
	}
yy458:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'T':
	case 't':	goto yy459;
	default:	goto yy3;
	}
yy459:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'O':
	case 'o':	goto yy460;
	default:	goto yy3;
	}
yy460:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'B':
	case 'b':	goto yy461;
	default:	goto yy3;
	}
yy461:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy462;
	default:	goto yy53;
	}
yy462:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy358;
	default:	goto yy53;
	}
yy463:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'T':	goto yy459;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 't':	goto yy464;
	default:	goto yy3;
	}
yy464:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'O':	goto yy460;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'o':	goto yy465;
	default:	goto yy3;
	}
yy465:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'B':	goto yy461;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'b':	goto yy466;
	default:	goto yy3;
	}
yy466:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy462;
	case 'e':	goto yy467;
	default:	goto yy144;
	}
yy467:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy457;
	default:	goto yy53;
	}
yy468:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'C':
	case 'c':	goto yy483;
	case 'P':
	case 'p':	goto yy482;
	case 'V':
	case 'v':	goto yy484;
	default:	goto yy3;
	}
yy469:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'T':
	case 't':	goto yy477;
	default:	goto yy3;
	}
yy470:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy134;
	case 'X':
	case 'x':	goto yy475;
	default:	goto yy3;
	}
yy471:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'N':
	case 'n':	goto yy472;
	default:	goto yy3;
	}
yy472:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'D':
	case 'd':	goto yy473;
	default:	goto yy341;
	}
yy473:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy474;
	default:	goto yy3;
	}
yy474:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy475:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy476;
	default:	goto yy3;
	}
yy476:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy3;
	}
yy477:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'U':
	case 'u':	goto yy478;
	default:	goto yy341;
	}
yy478:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'R':
	case 'r':	goto yy479;
	default:	goto yy3;
	}
yy479:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy480;
	default:	goto yy53;
	}
yy480:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy481;
	default:	goto yy53;
	}
yy481:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy482:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy490;
	default:	goto yy3;
	}
yy483:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'O':
	case 'o':	goto yy488;
	default:	goto yy3;
	}
yy484:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'E':
	case 'e':	goto yy485;
	default:	goto yy3;
	}
yy485:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'N':
	case 'n':	goto yy486;
	default:	goto yy3;
	}
yy486:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy487;
	default:	goto yy53;
	}
yy487:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy53;
	}
yy488:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'N':
	case 'n':	goto yy489;
	default:	goto yy3;
	}
yy489:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy159;
	default:	goto yy53;
	}
yy490:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'E':
	case 'e':	goto yy491;
	default:	goto yy3;
	}
yy491:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy492;
	default:	goto yy53;
	}
yy492:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy493;
	default:	goto yy53;
	}
yy493:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy494;
	default:	goto yy53;
	}
yy494:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy358;
	default:	goto yy53;
	}
yy495:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'C':	goto yy483;
	case 'P':	goto yy482;
	case 'V':	goto yy484;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'c':	goto yy510;
	case 'p':	goto yy509;
	case 'v':	goto yy511;
	default:	goto yy3;
	}
yy496:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'T':	goto yy477;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 't':	goto yy504;
	default:	goto yy3;
	}
yy497:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy134;
	case 'X':	goto yy475;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy137;
	case 'x':	goto yy502;
	default:	goto yy3;
	}
yy498:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'N':	goto yy472;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'n':	goto yy499;
	default:	goto yy3;
	}
yy499:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'D':	goto yy473;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'd':	goto yy500;
	default:	goto yy341;
	}
yy500:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':	goto yy474;
	case 'a':	goto yy501;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy501:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy502:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy476;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy503;
	default:	goto yy3;
	}
yy503:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy3;
	}
yy504:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'U':	goto yy478;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'u':	goto yy505;
	default:	goto yy341;
	}
yy505:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy479;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy506;
	default:	goto yy3;
	}
yy506:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy480;
	case 'd':	goto yy507;
	default:	goto yy144;
	}
yy507:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy481;
	case 'a':	goto yy508;
	default:	goto yy144;
	}
yy508:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy509:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy490;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy517;
	default:	goto yy3;
	}
yy510:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'O':	goto yy488;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'o':	goto yy515;
	default:	goto yy3;
	}
yy511:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'E':	goto yy485;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy512;
	default:	goto yy3;
	}
yy512:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'N':	goto yy486;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'n':	goto yy513;
	default:	goto yy3;
	}
yy513:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy487;
	case 't':	goto yy514;
	default:	goto yy144;
	}
yy514:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy53;
	}
yy515:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'N':	goto yy489;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'n':	goto yy516;
	default:	goto yy3;
	}
yy516:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy241;
	default:	goto yy53;
	}
yy517:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'E':	goto yy491;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'e':	goto yy518;
	default:	goto yy3;
	}
yy518:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':	goto yy492;
	case 'm':	goto yy519;
	default:	goto yy144;
	}
yy519:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':	goto yy493;
	case 'b':	goto yy520;
	default:	goto yy144;
	}
yy520:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy494;
	case 'e':	goto yy521;
	default:	goto yy144;
	}
yy521:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy457;
	default:	goto yy53;
	}
yy522:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'G':
	case 'g':	goto yy529;
	default:	goto yy3;
	}
yy523:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'R':
	case 'r':	goto yy527;
	default:	goto yy3;
	}
yy524:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'O':
	case 'o':	goto yy525;
	default:	goto yy3;
	}
yy525:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy526;
	}
yy526:
#line 1292 "parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 12463 "<stdout>"
yy527:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'I':
	case 'i':	goto yy528;
	default:	goto yy3;
	}
yy528:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'L':
	case 'l':	goto yy358;
	default:	goto yy3;
	}
yy529:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'U':
	case 'u':	goto yy530;
	default:	goto yy3;
	}
yy530:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'S':
	case 's':	goto yy531;
	default:	goto yy3;
	}
yy531:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy358;
	default:	goto yy53;
	}
yy532:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'G':	goto yy529;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'g':	goto yy538;
	default:	goto yy3;
	}
yy533:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'R':	goto yy527;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'r':	goto yy536;
	default:	goto yy3;
	}
yy534:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'O':	goto yy525;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'o':	goto yy535;
	default:	goto yy3;
	}
yy535:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy526;
	}
yy536:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'I':	goto yy528;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'i':	goto yy537;
	default:	goto yy3;
	}
yy537:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'L':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'l':	goto yy457;
	default:	goto yy3;
	}
yy538:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'U':	goto yy530;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'u':	goto yy539;
	default:	goto yy3;
	}
yy539:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy531;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy540;
	default:	goto yy3;
	}
yy540:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'T':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 't':	goto yy457;
	default:	goto yy53;
	}
yy541:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'B':
	case 'b':	goto yy555;
	default:	goto yy3;
	}
yy542:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'F':
	case 'f':	goto yy552;
	case 'R':
	case 'r':	goto yy551;
	default:	goto yy3;
	}
yy543:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'U':
	case 'u':	goto yy548;
	default:	goto yy3;
	}
yy544:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'I':
	case 'i':	goto yy545;
	default:	goto yy3;
	}
yy545:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'D':
	case 'd':	goto yy546;
	default:	goto yy341;
	}
yy546:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy547;
	default:	goto yy3;
	}
yy547:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy548:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'R':
	case 'r':	goto yy549;
	default:	goto yy3;
	}
yy549:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'T':
	case 't':	goto yy550;
	default:	goto yy3;
	}
yy550:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy53;
	}
yy551:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'S':
	case 's':	goto yy554;
	default:	goto yy3;
	}
yy552:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy553;
	default:	goto yy3;
	}
yy553:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy3;
	}
yy554:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'T':
	case 't':	goto yy159;
	default:	goto yy3;
	}
yy555:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'R':
	case 'r':	goto yy556;
	default:	goto yy3;
	}
yy556:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'U':
	case 'u':	goto yy557;
	default:	goto yy3;
	}
yy557:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy558;
	default:	goto yy53;
	}
yy558:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy559;
	default:	goto yy53;
	}
yy559:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy358;
	default:	goto yy53;
	}
yy560:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'B':	goto yy555;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'b':	goto yy574;
	default:	goto yy3;
	}
yy561:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'F':	goto yy552;
	case 'R':	goto yy551;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'f':	goto yy571;
	case 'r':	goto yy570;
	default:	goto yy3;
	}
yy562:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'U':	goto yy548;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'u':	goto yy567;
	default:	goto yy3;
	}
yy563:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'I':	goto yy545;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'i':	goto yy564;
	default:	goto yy3;
	}
yy564:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'D':	goto yy546;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'd':	goto yy565;
	default:	goto yy341;
	}
yy565:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':	goto yy547;
	case 'a':	goto yy566;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy566:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy567:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'R':	goto yy549;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'r':	goto yy568;
	default:	goto yy3;
	}
yy568:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'T':	goto yy550;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 't':	goto yy569;
	default:	goto yy3;
	}
yy569:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy53;
	}
yy570:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'S':	goto yy554;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 's':	goto yy573;
	default:	goto yy3;
	}
yy571:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy553;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy572;
	default:	goto yy3;
	}
yy572:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy3;
	}
yy573:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'T':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 't':	goto yy241;
	default:	goto yy3;
	}
yy574:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'R':	goto yy556;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'r':	goto yy575;
	default:	goto yy3;
	}
yy575:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'U':	goto yy557;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'u':	goto yy576;
	default:	goto yy3;
	}
yy576:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy558;
	case 'a':	goto yy577;
	default:	goto yy144;
	}
yy577:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy559;
	case 'r':	goto yy578;
	default:	goto yy144;
	}
yy578:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'Y':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy143;
	case 'y':	goto yy457;
	default:	goto yy53;
	}
yy579:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'L':
	case 'l':	goto yy586;
	case 'N':
	case 'n':	goto yy585;
	default:	goto yy3;
	}
yy580:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'N':
	case 'n':	goto yy581;
	default:	goto yy3;
	}
yy581:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'U':
	case 'u':	goto yy582;
	default:	goto yy3;
	}
yy582:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy583;
	default:	goto yy3;
	}
yy583:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy584;
	default:	goto yy53;
	}
yy584:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy358;
	default:	goto yy53;
	}
yy585:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'E':
	case 'e':	goto yy587;
	default:	goto yy3;
	}
yy586:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy135;
	case 'Y':
	case 'y':	goto yy587;
	default:	goto yy3;
	}
yy587:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	default:	goto yy3;
	}
yy588:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'L':	goto yy586;
	case 'N':	goto yy585;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'l':	goto yy595;
	case 'n':	goto yy594;
	default:	goto yy3;
	}
yy589:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'N':	goto yy581;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'n':	goto yy590;
	default:	goto yy3;
	}
yy590:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'U':	goto yy582;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'u':	goto yy591;
	default:	goto yy3;
	}
yy591:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':	goto yy583;
	case 'a':	goto yy592;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy592:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy584;
	case 'r':	goto yy593;
	default:	goto yy144;
	}
yy593:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'Y':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy143;
	case 'y':	goto yy457;
	default:	goto yy53;
	}
yy594:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'E':	goto yy587;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy596;
	default:	goto yy3;
	}
yy595:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy135;
	case 'Y':	goto yy587;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy142;
	case 'y':	goto yy596;
	default:	goto yy3;
	}
yy596:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy597:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'I':	goto yy598;
	default:	goto yy3;
	}
yy598:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy3;
	}
yy599:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'I':	goto yy600;
	default:	goto yy3;
	}
yy600:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'I':	goto yy587;
	default:	goto yy3;
	}
yy601:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	default:	goto yy3;
	}
yy602:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'I':	goto yy598;
	default:	goto yy3;
	}
yy603:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy604:
	switch(yych) {
	case ' ':	goto yy603;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':
	case 'a':	goto yy624;
	case 'D':
	case 'd':	goto yy608;
	case 'F':
	case 'f':	goto yy609;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy619;
	case 'J':
	case 'j':	goto yy623;
	case 'M':
	case 'm':	goto yy607;
	case 'N':
	case 'n':	goto yy626;
	case 'O':
	case 'o':	goto yy625;
	case 'P':
	case 'p':	goto yy628;
	case 'S':
	case 's':	goto yy605;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy621;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy622;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy605:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy119;
	case 'E':
	case 'e':	goto yy1137;
	case 'U':
	case 'u':	goto yy118;
	default:	goto yy53;
	}
yy606:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy119;
	case 'E':
	case 'e':	goto yy1137;
	case 'U':
	case 'u':	goto yy118;
	case 't':	goto yy843;
	default:	goto yy53;
	}
yy607:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy715;
	case 'I':
	case 'i':	goto yy110;
	case 'O':
	case 'o':	goto yy109;
	default:	goto yy53;
	}
yy608:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy106;
	case 'E':
	case 'e':	goto yy702;
	default:	goto yy53;
	}
yy609:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy718;
	case 'O':
	case 'o':	goto yy83;
	case 'R':
	case 'r':	goto yy82;
	default:	goto yy53;
	}
yy610:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy66;
	case 'U':
	case 'u':	goto yy67;
	case 'h':	goto yy1136;
	default:	goto yy53;
	}
yy611:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy852;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy851;
	default:	goto yy57;
	}
yy612:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy655;
	case 'd':	goto yy843;
	default:	goto yy53;
	}
yy613:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy843;
	default:	goto yy53;
	}
yy614:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy783;
	case '3':	goto yy785;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy786;
	case 'A':
	case 'a':	goto yy790;
	case 'D':
	case 'd':	goto yy794;
	case 'F':
	case 'f':	goto yy788;
	case 'J':
	case 'j':	goto yy787;
	case 'M':
	case 'm':	goto yy789;
	case 'N':
	case 'n':	goto yy793;
	case 'O':
	case 'o':	goto yy792;
	case 'S':
	case 's':	goto yy791;
	default:	goto yy53;
	}
yy615:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy734;
	case '1':	goto yy735;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy736;
	case 'A':
	case 'a':	goto yy740;
	case 'D':
	case 'd':	goto yy744;
	case 'F':
	case 'f':	goto yy738;
	case 'J':
	case 'j':	goto yy737;
	case 'M':
	case 'm':	goto yy739;
	case 'N':
	case 'n':	goto yy743;
	case 'O':
	case 'o':	goto yy742;
	case 'S':
	case 's':	goto yy741;
	default:	goto yy617;
	}
yy616:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy617:
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':
	case 'a':	goto yy699;
	case 'D':
	case 'd':	goto yy701;
	case 'F':
	case 'f':	goto yy697;
	case 'I':	goto yy619;
	case 'J':
	case 'j':	goto yy623;
	case 'M':
	case 'm':	goto yy698;
	case 'N':
	case 'n':	goto yy626;
	case 'O':
	case 'o':	goto yy625;
	case 'S':
	case 's':	goto yy700;
	case 'V':	goto yy621;
	case 'X':	goto yy622;
	default:	goto yy53;
	}
yy618:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy693;
	case '1':	goto yy694;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy695;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy696;
	default:	goto yy617;
	}
yy619:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy692;
	case 'V':
	case 'X':	goto yy665;
	default:	goto yy620;
	}
yy620:
#line 1139 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 16384 "<stdout>"
yy621:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy690;
	default:	goto yy620;
	}
yy622:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy689;
	default:	goto yy620;
	}
yy623:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy682;
	case 'U':
	case 'u':	goto yy681;
	default:	goto yy53;
	}
yy624:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy629;
	case 'M':
	case 'm':	goto yy630;
	case 'P':
	case 'p':	goto yy675;
	case 'U':
	case 'u':	goto yy674;
	default:	goto yy53;
	}
yy625:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy669;
	default:	goto yy53;
	}
yy626:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy655;
	default:	goto yy53;
	}
yy627:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy633;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy635;
	default:	goto yy53;
	}
yy628:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy629;
	case 'M':
	case 'm':	goto yy630;
	default:	goto yy53;
	}
yy629:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy630;
	default:	goto yy53;
	}
yy630:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '.':	goto yy632;
	default:	goto yy631;
	}
yy631:
#line 929 "parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 16537 "<stdout>"
yy632:
	yych = *++YYCURSOR;
	goto yy631;
yy633:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy636;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy649;
	default:	goto yy634;
	}
yy634:
#line 946 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 16583 "<stdout>"
yy635:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy636;
	default:	goto yy634;
	}
yy636:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy637;
	case '6':	goto yy638;
	case '7':
	case '8':
	case '9':	goto yy639;
	default:	goto yy53;
	}
yy637:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy643;
	default:	goto yy634;
	}
yy638:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':	goto yy643;
	default:	goto yy634;
	}
yy639:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	default:	goto yy634;
	}
yy640:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy641;
	default:	goto yy53;
	}
yy641:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy641;
	default:	goto yy634;
	}
yy643:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy644;
	case '.':	goto yy640;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy646;
	default:	goto yy634;
	}
yy644:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy644;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy646;
	default:	goto yy53;
	}
yy646:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy647;
	case 'M':
	case 'm':	goto yy648;
	default:	goto yy53;
	}
yy647:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy648;
	default:	goto yy53;
	}
yy648:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy632;
	default:	goto yy631;
	}
yy649:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy650;
	case '.':
	case ':':	goto yy636;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy652;
	default:	goto yy634;
	}
yy650:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy650;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy652;
	default:	goto yy53;
	}
yy652:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy653;
	case 'M':
	case 'm':	goto yy654;
	default:	goto yy53;
	}
yy653:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy654;
	default:	goto yy53;
	}
yy654:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy632;
	default:	goto yy631;
	}
yy655:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy656;
	default:	goto yy53;
	}
yy656:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy661;
	default:	goto yy620;
	}
yy657:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy658:
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	default:	goto yy53;
	}
yy659:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy666;
	default:	goto yy660;
	}
yy660:
#line 1073 "parse_date.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 16864 "<stdout>"
yy661:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy662;
	default:	goto yy53;
	}
yy662:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy663;
	default:	goto yy53;
	}
yy663:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy664;
	default:	goto yy53;
	}
yy664:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy665;
	default:	goto yy53;
	}
yy665:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	default:	goto yy620;
	}
yy666:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy667;
	default:	goto yy660;
	}
yy667:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy668;
	default:	goto yy660;
	}
yy668:
	yych = *++YYCURSOR;
	goto yy660;
yy669:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy670;
	default:	goto yy53;
	}
yy670:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'O':
	case 'o':	goto yy671;
	default:	goto yy620;
	}
yy671:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy672;
	default:	goto yy53;
	}
yy672:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy673;
	default:	goto yy53;
	}
yy673:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy665;
	default:	goto yy53;
	}
yy674:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy678;
	default:	goto yy53;
	}
yy675:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy676;
	default:	goto yy53;
	}
yy676:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':
	case 'i':	goto yy677;
	default:	goto yy620;
	}
yy677:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy665;
	default:	goto yy53;
	}
yy678:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'U':
	case 'u':	goto yy679;
	default:	goto yy620;
	}
yy679:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy680;
	default:	goto yy53;
	}
yy680:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy665;
	default:	goto yy53;
	}
yy681:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy688;
	case 'N':
	case 'n':	goto yy687;
	default:	goto yy53;
	}
yy682:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy683;
	default:	goto yy53;
	}
yy683:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'U':
	case 'u':	goto yy684;
	default:	goto yy620;
	}
yy684:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy685;
	default:	goto yy53;
	}
yy685:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy686;
	default:	goto yy53;
	}
yy686:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy665;
	default:	goto yy53;
	}
yy687:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy665;
	default:	goto yy620;
	}
yy688:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'Y':
	case 'y':	goto yy665;
	default:	goto yy620;
	}
yy689:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy665;
	default:	goto yy620;
	}
yy690:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy691;
	default:	goto yy620;
	}
yy691:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy665;
	default:	goto yy620;
	}
yy692:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':	goto yy665;
	default:	goto yy620;
	}
yy693:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy724;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy733;
	case ':':	goto yy636;
	default:	goto yy634;
	}
yy694:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy724;
	case '0':
	case '1':
	case '2':	goto yy733;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy649;
	case ':':	goto yy636;
	default:	goto yy634;
	}
yy695:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy724;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy649;
	case ':':	goto yy636;
	default:	goto yy634;
	}
yy696:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy724;
	case ':':	goto yy636;
	default:	goto yy634;
	}
yy697:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy718;
	default:	goto yy53;
	}
yy698:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy715;
	default:	goto yy53;
	}
yy699:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy675;
	case 'U':
	case 'u':	goto yy674;
	default:	goto yy53;
	}
yy700:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy708;
	default:	goto yy53;
	}
yy701:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy702;
	default:	goto yy53;
	}
yy702:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy703;
	default:	goto yy53;
	}
yy703:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy704;
	default:	goto yy620;
	}
yy704:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy705;
	default:	goto yy53;
	}
yy705:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy706;
	default:	goto yy53;
	}
yy706:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy707;
	default:	goto yy53;
	}
yy707:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy665;
	default:	goto yy53;
	}
yy708:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy709;
	default:	goto yy53;
	}
yy709:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'T':
	case 't':	goto yy710;
	default:	goto yy620;
	}
yy710:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy711;
	default:	goto yy620;
	}
yy711:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy712;
	default:	goto yy53;
	}
yy712:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy713;
	default:	goto yy53;
	}
yy713:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy714;
	default:	goto yy53;
	}
yy714:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy665;
	default:	goto yy53;
	}
yy715:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy716;
	case 'Y':
	case 'y':	goto yy665;
	default:	goto yy53;
	}
yy716:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'C':
	case 'c':	goto yy717;
	default:	goto yy620;
	}
yy717:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy665;
	default:	goto yy53;
	}
yy718:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy719;
	default:	goto yy53;
	}
yy719:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy657;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'R':
	case 'r':	goto yy720;
	default:	goto yy620;
	}
yy720:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy721;
	default:	goto yy53;
	}
yy721:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy722;
	default:	goto yy53;
	}
yy722:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy723;
	default:	goto yy53;
	}
yy723:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy665;
	default:	goto yy53;
	}
yy724:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy725;
	case '6':	goto yy726;
	case '7':
	case '8':
	case '9':	goto yy727;
	default:	goto yy53;
	}
yy725:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy732;
	default:	goto yy634;
	}
yy726:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':	goto yy732;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy728;
	default:	goto yy634;
	}
yy727:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy728;
	default:	goto yy634;
	}
yy728:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy730;
	default:	goto yy729;
	}
yy729:
#line 1087 "parse_date.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 17862 "<stdout>"
yy730:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy731;
	default:	goto yy729;
	}
yy731:
	yych = *++YYCURSOR;
	goto yy729;
yy732:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy644;
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy730;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy646;
	default:	goto yy634;
	}
yy733:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy650;
	case '.':	goto yy724;
	case ':':	goto yy636;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy652;
	default:	goto yy634;
	}
yy734:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy773;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy736;
	default:	goto yy53;
	}
yy735:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy773;
	case '0':
	case '1':
	case '2':	goto yy736;
	default:	goto yy53;
	}
yy736:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy773;
	default:	goto yy53;
	}
yy737:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy769;
	case 'U':
	case 'u':	goto yy768;
	default:	goto yy53;
	}
yy738:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy766;
	default:	goto yy53;
	}
yy739:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy763;
	default:	goto yy53;
	}
yy740:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy760;
	case 'U':
	case 'u':	goto yy759;
	default:	goto yy53;
	}
yy741:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy756;
	default:	goto yy53;
	}
yy742:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy754;
	default:	goto yy53;
	}
yy743:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy752;
	default:	goto yy53;
	}
yy744:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy745;
	default:	goto yy53;
	}
yy745:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy746;
	default:	goto yy53;
	}
yy746:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy704;
	default:	goto yy620;
	}
yy747:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy748;
	case '1':
	case '2':	goto yy749;
	case '3':	goto yy750;
	default:	goto yy658;
	}
yy748:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy666;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy751;
	default:	goto yy660;
	}
yy749:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy751;
	default:	goto yy660;
	}
yy750:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy751;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy666;
	default:	goto yy660;
	}
yy751:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy667;
	default:	goto yy660;
	}
yy752:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy753;
	default:	goto yy53;
	}
yy753:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy661;
	default:	goto yy620;
	}
yy754:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy755;
	default:	goto yy53;
	}
yy755:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'O':
	case 'o':	goto yy671;
	default:	goto yy620;
	}
yy756:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy757;
	default:	goto yy53;
	}
yy757:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'T':
	case 't':	goto yy758;
	default:	goto yy620;
	}
yy758:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy711;
	default:	goto yy620;
	}
yy759:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy762;
	default:	goto yy53;
	}
yy760:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy761;
	default:	goto yy53;
	}
yy761:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'I':
	case 'i':	goto yy677;
	default:	goto yy620;
	}
yy762:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'U':
	case 'u':	goto yy679;
	default:	goto yy620;
	}
yy763:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy764;
	case 'Y':
	case 'y':	goto yy765;
	default:	goto yy53;
	}
yy764:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'C':
	case 'c':	goto yy717;
	default:	goto yy620;
	}
yy765:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	default:	goto yy620;
	}
yy766:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy767;
	default:	goto yy53;
	}
yy767:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'R':
	case 'r':	goto yy720;
	default:	goto yy620;
	}
yy768:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy772;
	case 'N':
	case 'n':	goto yy771;
	default:	goto yy53;
	}
yy769:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy770;
	default:	goto yy53;
	}
yy770:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'U':
	case 'u':	goto yy684;
	default:	goto yy620;
	}
yy771:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'E':
	case 'e':	goto yy665;
	default:	goto yy620;
	}
yy772:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '.':	goto yy657;
	case '-':	goto yy747;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	case 'Y':
	case 'y':	goto yy665;
	default:	goto yy620;
	}
yy773:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy774;
	case '3':	goto yy776;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy777;
	default:	goto yy53;
	}
yy774:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy777;
	case 'n':	goto yy779;
	case 'r':	goto yy780;
	case 's':	goto yy778;
	case 't':	goto yy781;
	default:	goto yy775;
	}
yy775:
#line 1060 "parse_date.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 18625 "<stdout>"
yy776:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':	goto yy777;
	case 'n':	goto yy779;
	case 'r':	goto yy780;
	case 's':	goto yy778;
	case 't':	goto yy781;
	default:	goto yy775;
	}
yy777:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'n':	goto yy779;
	case 'r':	goto yy780;
	case 's':	goto yy778;
	case 't':	goto yy781;
	default:	goto yy775;
	}
yy778:
	yych = *++YYCURSOR;
	switch(yych) {
	case 't':	goto yy782;
	default:	goto yy53;
	}
yy779:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy782;
	default:	goto yy53;
	}
yy780:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy782;
	default:	goto yy53;
	}
yy781:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'h':	goto yy782;
	default:	goto yy53;
	}
yy782:
	yych = *++YYCURSOR;
	goto yy775;
yy783:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':	goto yy837;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy786;
	case 'n':	goto yy834;
	case 'r':	goto yy835;
	case 's':	goto yy833;
	case 't':	goto yy836;
	default:	goto yy784;
	}
yy784:
#line 1033 "parse_date.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 18711 "<stdout>"
yy785:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':	goto yy837;
	case '0':
	case '1':	goto yy786;
	case 'n':	goto yy834;
	case 'r':	goto yy835;
	case 's':	goto yy833;
	case 't':	goto yy836;
	default:	goto yy784;
	}
yy786:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':	goto yy837;
	case 'n':	goto yy834;
	case 'r':	goto yy835;
	case 's':	goto yy833;
	case 't':	goto yy836;
	default:	goto yy784;
	}
yy787:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy832;
	case 'U':
	case 'u':	goto yy831;
	default:	goto yy53;
	}
yy788:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy830;
	default:	goto yy53;
	}
yy789:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy829;
	default:	goto yy53;
	}
yy790:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy828;
	case 'U':
	case 'u':	goto yy827;
	default:	goto yy53;
	}
yy791:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy825;
	default:	goto yy53;
	}
yy792:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy824;
	default:	goto yy53;
	}
yy793:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy823;
	default:	goto yy53;
	}
yy794:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy795;
	default:	goto yy53;
	}
yy795:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy796;
	default:	goto yy53;
	}
yy796:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy797;
	default:	goto yy53;
	}
yy797:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy798;
	default:	goto yy53;
	}
yy798:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy799;
	default:	goto yy53;
	}
yy799:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy800;
	default:	goto yy53;
	}
yy800:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy801;
	default:	goto yy53;
	}
yy801:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy802;
	default:	goto yy53;
	}
yy802:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy803;
	case '2':	goto yy804;
	default:	goto yy53;
	}
yy803:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy805;
	default:	goto yy53;
	}
yy804:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy805;
	default:	goto yy53;
	}
yy805:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy806;
	default:	goto yy53;
	}
yy806:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy807;
	default:	goto yy53;
	}
yy807:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy808;
	default:	goto yy53;
	}
yy808:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy809;
	default:	goto yy53;
	}
yy809:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy810;
	case '6':	goto yy811;
	default:	goto yy53;
	}
yy810:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy812;
	default:	goto yy53;
	}
yy811:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy812;
	default:	goto yy53;
	}
yy812:
	yych = *++YYCURSOR;
	switch(yych) {
	case ' ':	goto yy813;
	default:	goto yy53;
	}
yy813:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch(yych) {
	case ' ':	goto yy813;
	case '+':
	case '-':	goto yy815;
	default:	goto yy53;
	}
yy815:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy816;
	case '2':	goto yy818;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy819;
	default:	goto yy53;
	}
yy816:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy819;
	case ':':	goto yy820;
	default:	goto yy817;
	}
yy817:
#line 1264 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 19044 "<stdout>"
yy818:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy819;
	case '4':
	case '5':	goto yy821;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy822;
	case ':':	goto yy820;
	default:	goto yy817;
	}
yy819:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy821;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy822;
	case ':':	goto yy820;
	default:	goto yy817;
	}
yy820:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy821;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy822;
	default:	goto yy817;
	}
yy821:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy822;
	default:	goto yy817;
	}
yy822:
	yych = *++YYCURSOR;
	goto yy817;
yy823:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy796;
	default:	goto yy53;
	}
yy824:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy796;
	default:	goto yy53;
	}
yy825:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy826;
	default:	goto yy53;
	}
yy826:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy797;
	case 'T':
	case 't':	goto yy796;
	default:	goto yy53;
	}
yy827:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy796;
	default:	goto yy53;
	}
yy828:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy796;
	default:	goto yy53;
	}
yy829:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy796;
	default:	goto yy53;
	}
yy830:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy796;
	default:	goto yy53;
	}
yy831:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy796;
	default:	goto yy53;
	}
yy832:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy796;
	default:	goto yy53;
	}
yy833:
	yych = *++YYCURSOR;
	switch(yych) {
	case 't':	goto yy842;
	default:	goto yy53;
	}
yy834:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy842;
	default:	goto yy53;
	}
yy835:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy842;
	default:	goto yy53;
	}
yy836:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'h':	goto yy842;
	default:	goto yy53;
	}
yy837:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy838;
	default:	goto yy53;
	}
yy838:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy839;
	default:	goto yy784;
	}
yy839:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy840;
	default:	goto yy784;
	}
yy840:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy841;
	default:	goto yy784;
	}
yy841:
	yych = *++YYCURSOR;
	goto yy784;
yy842:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':	goto yy837;
	default:	goto yy784;
	}
yy843:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy845;
	case '/':	goto yy844;
	default:	goto yy617;
	}
yy844:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy790;
	case 'D':
	case 'd':	goto yy794;
	case 'F':
	case 'f':	goto yy788;
	case 'J':
	case 'j':	goto yy787;
	case 'M':
	case 'm':	goto yy789;
	case 'N':
	case 'n':	goto yy793;
	case 'O':
	case 'o':	goto yy792;
	case 'S':
	case 's':	goto yy791;
	default:	goto yy53;
	}
yy845:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy846;
	case '1':	goto yy847;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy848;
	default:	goto yy617;
	}
yy846:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy849;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy848;
	default:	goto yy53;
	}
yy847:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy849;
	case '0':
	case '1':
	case '2':	goto yy848;
	default:	goto yy53;
	}
yy848:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy849;
	default:	goto yy53;
	}
yy849:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy850;
	default:	goto yy53;
	}
yy850:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy728;
	default:	goto yy729;
	}
yy851:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy852;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy879;
	default:	goto yy57;
	}
yy852:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy734;
	case '1':	goto yy735;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy736;
	case 'A':
	case 'a':	goto yy856;
	case 'D':
	case 'd':	goto yy860;
	case 'F':
	case 'f':	goto yy854;
	case 'J':
	case 'j':	goto yy853;
	case 'M':
	case 'm':	goto yy855;
	case 'N':
	case 'n':	goto yy859;
	case 'O':
	case 'o':	goto yy858;
	case 'S':
	case 's':	goto yy857;
	default:	goto yy53;
	}
yy853:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy878;
	case 'U':
	case 'u':	goto yy877;
	default:	goto yy53;
	}
yy854:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy876;
	default:	goto yy53;
	}
yy855:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy875;
	default:	goto yy53;
	}
yy856:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy874;
	case 'U':
	case 'u':	goto yy873;
	default:	goto yy53;
	}
yy857:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy871;
	default:	goto yy53;
	}
yy858:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy870;
	default:	goto yy53;
	}
yy859:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy869;
	default:	goto yy53;
	}
yy860:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy861;
	default:	goto yy53;
	}
yy861:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy862;
	default:	goto yy53;
	}
yy862:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy863;
	default:	goto yy53;
	}
yy863:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy864;
	case '1':
	case '2':	goto yy865;
	case '3':	goto yy866;
	default:	goto yy53;
	}
yy864:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy867;
	default:	goto yy53;
	}
yy865:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy867;
	default:	goto yy53;
	}
yy866:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy867;
	default:	goto yy53;
	}
yy867:
	++YYCURSOR;
#line 1251 "parse_date.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 19562 "<stdout>"
yy869:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy862;
	default:	goto yy53;
	}
yy870:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy862;
	default:	goto yy53;
	}
yy871:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy872;
	default:	goto yy53;
	}
yy872:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy863;
	case 'T':
	case 't':	goto yy862;
	default:	goto yy53;
	}
yy873:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy862;
	default:	goto yy53;
	}
yy874:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy862;
	default:	goto yy53;
	}
yy875:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy862;
	default:	goto yy53;
	}
yy876:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy862;
	default:	goto yy53;
	}
yy877:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy862;
	default:	goto yy53;
	}
yy878:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy862;
	default:	goto yy53;
	}
yy879:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy884;
	case '-':	goto yy881;
	case '.':	goto yy887;
	case '/':	goto yy882;
	case '0':	goto yy900;
	case '1':	goto yy901;
	case '2':	goto yy903;
	case '3':	goto yy904;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy902;
	case 'W':	goto yy905;
	default:	goto yy880;
	}
yy880:
#line 1283 "parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 19707 "<stdout>"
yy881:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1065;
	case '1':	goto yy1066;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1067;
	case 'A':
	case 'a':	goto yy1060;
	case 'D':
	case 'd':	goto yy1064;
	case 'F':
	case 'f':	goto yy1058;
	case 'J':
	case 'j':	goto yy1057;
	case 'M':
	case 'm':	goto yy1059;
	case 'N':
	case 'n':	goto yy1063;
	case 'O':
	case 'o':	goto yy1062;
	case 'S':
	case 's':	goto yy1061;
	default:	goto yy886;
	}
yy882:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1038;
	case '1':	goto yy1039;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1040;
	default:	goto yy53;
	}
yy883:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy884:
	switch(yych) {
	case ' ':	goto yy883;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy885;
	case 'A':
	case 'a':	goto yy895;
	case 'D':
	case 'd':	goto yy899;
	case 'F':
	case 'f':	goto yy893;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy888;
	case 'J':
	case 'j':	goto yy892;
	case 'M':
	case 'm':	goto yy894;
	case 'N':
	case 'n':	goto yy898;
	case 'O':
	case 'o':	goto yy897;
	case 'S':
	case 's':	goto yy896;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy890;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy891;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy885:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy886:
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy885;
	case 'A':
	case 'a':	goto yy895;
	case 'D':
	case 'd':	goto yy1030;
	case 'F':
	case 'f':	goto yy1027;
	case 'I':	goto yy888;
	case 'J':
	case 'j':	goto yy892;
	case 'M':
	case 'm':	goto yy1028;
	case 'N':
	case 'n':	goto yy898;
	case 'O':
	case 'o':	goto yy897;
	case 'S':
	case 's':	goto yy1029;
	case 'V':	goto yy890;
	case 'X':	goto yy891;
	default:	goto yy53;
	}
yy887:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1024;
	case '1':
	case '2':	goto yy1025;
	case '3':	goto yy1026;
	default:	goto yy886;
	}
yy888:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case 'I':	goto yy1023;
	case 'V':
	case 'X':	goto yy977;
	default:	goto yy889;
	}
yy889:
#line 1113 "parse_date.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 19876 "<stdout>"
yy890:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy1021;
	default:	goto yy889;
	}
yy891:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy1020;
	default:	goto yy889;
	}
yy892:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1013;
	case 'U':
	case 'u':	goto yy1012;
	default:	goto yy53;
	}
yy893:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1006;
	case 'O':
	case 'o':	goto yy83;
	case 'R':
	case 'r':	goto yy82;
	default:	goto yy53;
	}
yy894:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1003;
	case 'I':
	case 'i':	goto yy110;
	case 'O':
	case 'o':	goto yy109;
	default:	goto yy53;
	}
yy895:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy997;
	case 'U':
	case 'u':	goto yy996;
	default:	goto yy53;
	}
yy896:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy119;
	case 'E':
	case 'e':	goto yy989;
	case 'U':
	case 'u':	goto yy118;
	default:	goto yy53;
	}
yy897:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy984;
	default:	goto yy53;
	}
yy898:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy978;
	default:	goto yy53;
	}
yy899:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy106;
	case 'E':
	case 'e':	goto yy971;
	default:	goto yy53;
	}
yy900:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy969;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy970;
	default:	goto yy57;
	}
yy901:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy938;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy917;
	default:	goto yy57;
	}
yy902:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy918;
	case '1':	goto yy919;
	default:	goto yy53;
	}
yy903:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy917;
	default:	goto yy57;
	}
yy904:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy913;
	case '6':	goto yy914;
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy57;
	}
yy905:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy906;
	case '1':
	case '2':
	case '3':
	case '4':	goto yy907;
	case '5':	goto yy908;
	case 'E':
	case 'e':	goto yy98;
	default:	goto yy53;
	}
yy906:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy909;
	default:	goto yy53;
	}
yy907:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy909;
	default:	goto yy53;
	}
yy908:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy909;
	default:	goto yy53;
	}
yy909:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy911;
	default:	goto yy910;
	}
yy910:
#line 1219 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 20113 "<stdout>"
yy911:
	++YYCURSOR;
#line 1200 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 20134 "<stdout>"
yy913:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy57;
	}
yy914:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy915;
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy57;
	}
yy915:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy916;
	}
yy916:
#line 1187 "parse_date.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 20211 "<stdout>"
yy917:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy57;
	}
yy918:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy920;
	default:	goto yy53;
	}
yy919:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy920;
	default:	goto yy53;
	}
yy920:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy921;
	default:	goto yy53;
	}
yy921:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy922;
	case '1':
	case '2':	goto yy923;
	case '3':	goto yy924;
	default:	goto yy53;
	}
yy922:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy925;
	default:	goto yy53;
	}
yy923:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy925;
	default:	goto yy53;
	}
yy924:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy925;
	default:	goto yy53;
	}
yy925:
	yych = *++YYCURSOR;
	switch(yych) {
	case ' ':	goto yy926;
	default:	goto yy53;
	}
yy926:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy927;
	case '2':	goto yy928;
	default:	goto yy53;
	}
yy927:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy929;
	default:	goto yy53;
	}
yy928:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy929;
	default:	goto yy53;
	}
yy929:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy930;
	default:	goto yy53;
	}
yy930:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy931;
	default:	goto yy53;
	}
yy931:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy932;
	default:	goto yy53;
	}
yy932:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy933;
	default:	goto yy53;
	}
yy933:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy934;
	case '6':	goto yy935;
	default:	goto yy53;
	}
yy934:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy935:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy936;
	default:	goto yy53;
	}
yy936:
	++YYCURSOR;
yy937:
#line 1163 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 20435 "<stdout>"
yy938:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy939;
	case '1':
	case '2':	goto yy940;
	case '3':	goto yy941;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy57;
	}
yy939:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':	goto yy51;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy942;
	default:	goto yy916;
	}
yy940:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy942;
	default:	goto yy916;
	}
yy941:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':	goto yy942;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy916;
	}
yy942:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':	goto yy56;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case 'D':
	case 'd':	goto yy61;
	case 'F':
	case 'f':	goto yy63;
	case 'H':
	case 'h':	goto yy60;
	case 'M':
	case 'm':	goto yy59;
	case 'S':
	case 's':	goto yy58;
	case 'T':	goto yy944;
	case 'W':
	case 'w':	goto yy62;
	case 'Y':
	case 'y':	goto yy64;
	case 't':	goto yy945;
	default:	goto yy943;
	}
yy943:
#line 1151 "parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 20595 "<stdout>"
yy944:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy959;
	case '2':	goto yy960;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy961;
	case 'H':
	case 'h':	goto yy66;
	case 'U':
	case 'u':	goto yy67;
	default:	goto yy53;
	}
yy945:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy946;
	case '2':	goto yy947;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy948;
	case 'H':
	case 'h':	goto yy66;
	case 'U':
	case 'u':	goto yy67;
	default:	goto yy53;
	}
yy946:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy953;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy948;
	default:	goto yy53;
	}
yy947:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy953;
	case '4':
	case '5':	goto yy949;
	default:	goto yy53;
	}
yy948:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy949;
	default:	goto yy53;
	}
yy949:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy950;
	default:	goto yy53;
	}
yy950:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy951;
	case '6':	goto yy952;
	default:	goto yy53;
	}
yy951:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy952:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy936;
	default:	goto yy53;
	}
yy953:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy954;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy950;
	default:	goto yy53;
	}
yy954:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy955;
	case '6':	goto yy956;
	case '7':
	case '8':
	case '9':	goto yy950;
	default:	goto yy53;
	}
yy955:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy957;
	case '6':	goto yy958;
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy956:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy957;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy951;
	case '6':	goto yy952;
	default:	goto yy53;
	}
yy957:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy937;
	}
yy958:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy936;
	default:	goto yy937;
	}
yy959:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy968;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy961;
	case ':':	goto yy962;
	default:	goto yy53;
	}
yy960:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy968;
	case '4':
	case '5':	goto yy949;
	case ':':	goto yy962;
	default:	goto yy53;
	}
yy961:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy949;
	case ':':	goto yy962;
	default:	goto yy53;
	}
yy962:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy963;
	default:	goto yy53;
	}
yy963:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy964;
	default:	goto yy53;
	}
yy964:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy965;
	default:	goto yy53;
	}
yy965:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy966;
	case '6':	goto yy967;
	default:	goto yy53;
	}
yy966:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy967:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy936;
	default:	goto yy53;
	}
yy968:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy954;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy950;
	case ':':	goto yy962;
	default:	goto yy53;
	}
yy969:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy51;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy57;
	}
yy970:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy939;
	case '1':
	case '2':	goto yy940;
	case '3':	goto yy941;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy57;
	}
yy971:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy972;
	default:	goto yy53;
	}
yy972:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'E':
	case 'e':	goto yy973;
	default:	goto yy889;
	}
yy973:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy974;
	default:	goto yy53;
	}
yy974:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy975;
	default:	goto yy53;
	}
yy975:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy976;
	default:	goto yy53;
	}
yy976:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy977;
	default:	goto yy53;
	}
yy977:
	yych = *++YYCURSOR;
	goto yy889;
yy978:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy979;
	default:	goto yy53;
	}
yy979:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'E':
	case 'e':	goto yy980;
	default:	goto yy889;
	}
yy980:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy981;
	default:	goto yy53;
	}
yy981:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy982;
	default:	goto yy53;
	}
yy982:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy983;
	default:	goto yy53;
	}
yy983:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy977;
	default:	goto yy53;
	}
yy984:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy985;
	default:	goto yy53;
	}
yy985:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'O':
	case 'o':	goto yy986;
	default:	goto yy889;
	}
yy986:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy987;
	default:	goto yy53;
	}
yy987:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy988;
	default:	goto yy53;
	}
yy988:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy977;
	default:	goto yy53;
	}
yy989:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy121;
	case 'P':
	case 'p':	goto yy990;
	default:	goto yy53;
	}
yy990:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy991;
	default:	goto yy889;
	}
yy991:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'E':
	case 'e':	goto yy992;
	default:	goto yy889;
	}
yy992:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'M':
	case 'm':	goto yy993;
	default:	goto yy53;
	}
yy993:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy994;
	default:	goto yy53;
	}
yy994:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy995;
	default:	goto yy53;
	}
yy995:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy977;
	default:	goto yy53;
	}
yy996:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy1000;
	default:	goto yy53;
	}
yy997:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy998;
	default:	goto yy53;
	}
yy998:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'I':
	case 'i':	goto yy999;
	default:	goto yy889;
	}
yy999:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy977;
	default:	goto yy53;
	}
yy1000:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'U':
	case 'u':	goto yy1001;
	default:	goto yy889;
	}
yy1001:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'S':
	case 's':	goto yy1002;
	default:	goto yy53;
	}
yy1002:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy977;
	default:	goto yy53;
	}
yy1003:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1004;
	case 'Y':
	case 'y':	goto yy977;
	default:	goto yy53;
	}
yy1004:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'C':
	case 'c':	goto yy1005;
	default:	goto yy889;
	}
yy1005:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy977;
	default:	goto yy53;
	}
yy1006:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy1007;
	default:	goto yy53;
	}
yy1007:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'R':
	case 'r':	goto yy1008;
	default:	goto yy889;
	}
yy1008:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'U':
	case 'u':	goto yy1009;
	default:	goto yy53;
	}
yy1009:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1010;
	default:	goto yy53;
	}
yy1010:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1011;
	default:	goto yy53;
	}
yy1011:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy977;
	default:	goto yy53;
	}
yy1012:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy1019;
	case 'N':
	case 'n':	goto yy1018;
	default:	goto yy53;
	}
yy1013:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy1014;
	default:	goto yy53;
	}
yy1014:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'U':
	case 'u':	goto yy1015;
	default:	goto yy889;
	}
yy1015:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1016;
	default:	goto yy53;
	}
yy1016:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1017;
	default:	goto yy53;
	}
yy1017:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy977;
	default:	goto yy53;
	}
yy1018:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy977;
	default:	goto yy889;
	}
yy1019:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy977;
	default:	goto yy889;
	}
yy1020:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy977;
	default:	goto yy889;
	}
yy1021:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy1022;
	default:	goto yy889;
	}
yy1022:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy977;
	default:	goto yy889;
	}
yy1023:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'I':	goto yy977;
	default:	goto yy889;
	}
yy1024:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1037;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1036;
	default:	goto yy53;
	}
yy1025:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1035;
	default:	goto yy53;
	}
yy1026:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1033;
	case '6':	goto yy1032;
	default:	goto yy53;
	}
yy1027:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1006;
	default:	goto yy53;
	}
yy1028:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1003;
	default:	goto yy53;
	}
yy1029:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1031;
	default:	goto yy53;
	}
yy1030:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy971;
	default:	goto yy53;
	}
yy1031:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy990;
	default:	goto yy53;
	}
yy1032:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy1034;
	default:	goto yy53;
	}
yy1033:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1034;
	default:	goto yy53;
	}
yy1034:
	yych = *++YYCURSOR;
	goto yy916;
yy1035:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1034;
	default:	goto yy53;
	}
yy1036:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1034;
	default:	goto yy53;
	}
yy1037:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1034;
	default:	goto yy53;
	}
yy1038:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy1041;
	case '0':	goto yy1040;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1051;
	default:	goto yy53;
	}
yy1039:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy1041;
	case '0':
	case '1':
	case '2':	goto yy1051;
	default:	goto yy53;
	}
yy1040:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy1041;
	default:	goto yy53;
	}
yy1041:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy1042;
	case '3':	goto yy1044;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1045;
	default:	goto yy53;
	}
yy1042:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1045;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1043:
#line 1048 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21555 "<stdout>"
yy1044:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':	goto yy1045;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1045:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1046:
	yych = *++YYCURSOR;
	switch(yych) {
	case 't':	goto yy1050;
	default:	goto yy53;
	}
yy1047:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy1050;
	default:	goto yy53;
	}
yy1048:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy1050;
	default:	goto yy53;
	}
yy1049:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'h':	goto yy1050;
	default:	goto yy53;
	}
yy1050:
	yych = *++YYCURSOR;
	goto yy1043;
yy1051:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':	goto yy1052;
	default:	goto yy53;
	}
yy1052:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1053;
	case '1':
	case '2':	goto yy1054;
	case '3':	goto yy1055;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1045;
	default:	goto yy53;
	}
yy1053:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':	goto yy1045;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1056;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1054:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1056;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1055:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':	goto yy1056;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1056:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':	goto yy1050;
	case 'n':	goto yy1047;
	case 'r':	goto yy1048;
	case 's':	goto yy1046;
	case 't':	goto yy1049;
	default:	goto yy1043;
	}
yy1057:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1132;
	case 'U':
	case 'u':	goto yy1131;
	default:	goto yy53;
	}
yy1058:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1129;
	default:	goto yy53;
	}
yy1059:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1126;
	default:	goto yy53;
	}
yy1060:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy1123;
	case 'U':
	case 'u':	goto yy1122;
	default:	goto yy53;
	}
yy1061:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1119;
	default:	goto yy53;
	}
yy1062:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy1117;
	default:	goto yy53;
	}
yy1063:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy1115;
	default:	goto yy53;
	}
yy1064:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1113;
	default:	goto yy53;
	}
yy1065:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy1068;
	case '0':	goto yy1067;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1087;
	default:	goto yy53;
	}
yy1066:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy1068;
	case '0':
	case '1':
	case '2':	goto yy1087;
	default:	goto yy53;
	}
yy1067:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy1068;
	default:	goto yy53;
	}
yy1068:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy1069;
	case '3':	goto yy1070;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1071;
	default:	goto yy53;
	}
yy1069:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1071;
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1070:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':	goto yy1071;
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1071:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1072:
	yych = *++YYCURSOR;
	switch(yych) {
	case 't':	goto yy1086;
	default:	goto yy53;
	}
yy1073:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy1086;
	default:	goto yy53;
	}
yy1074:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'd':	goto yy1086;
	default:	goto yy53;
	}
yy1075:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'h':	goto yy1086;
	default:	goto yy53;
	}
yy1076:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy1077;
	case '2':	goto yy1078;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy53;
	}
yy1077:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	case ':':	goto yy1080;
	default:	goto yy53;
	}
yy1078:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1079;
	case ':':	goto yy1080;
	default:	goto yy53;
	}
yy1079:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy1080;
	default:	goto yy53;
	}
yy1080:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1081;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1082;
	default:	goto yy53;
	}
yy1081:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1082;
	case ':':	goto yy1083;
	default:	goto yy53;
	}
yy1082:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy1083;
	default:	goto yy53;
	}
yy1083:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1084;
	case '6':	goto yy1085;
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy1084:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy937;
	}
yy1085:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy936;
	default:	goto yy937;
	}
yy1086:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'T':	goto yy1076;
	default:	goto yy775;
	}
yy1087:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy1088;
	default:	goto yy53;
	}
yy1088:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1089;
	case '1':
	case '2':	goto yy1090;
	case '3':	goto yy1091;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1071;
	default:	goto yy53;
	}
yy1089:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':	goto yy1071;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1092;
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1090:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1092;
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1091:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '0':
	case '1':	goto yy1092;
	case 'T':	goto yy1076;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy775;
	}
yy1092:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case 'T':	goto yy1093;
	case 'n':	goto yy1073;
	case 'r':	goto yy1074;
	case 's':	goto yy1072;
	case 't':	goto yy1075;
	default:	goto yy1043;
	}
yy1093:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy1094;
	case '2':	goto yy1095;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy53;
	}
yy1094:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1096;
	case ':':	goto yy1080;
	default:	goto yy53;
	}
yy1095:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1096;
	case ':':	goto yy1080;
	default:	goto yy53;
	}
yy1096:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy1097;
	default:	goto yy53;
	}
yy1097:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1098;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1082;
	default:	goto yy53;
	}
yy1098:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1099;
	case ':':	goto yy1083;
	default:	goto yy53;
	}
yy1099:
	yych = *++YYCURSOR;
	switch(yych) {
	case ':':	goto yy1100;
	default:	goto yy53;
	}
yy1100:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1101;
	case '6':	goto yy1102;
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy53;
	}
yy1101:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1103;
	default:	goto yy937;
	}
yy1102:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1103;
	default:	goto yy937;
	}
yy1103:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy1104;
	default:	goto yy937;
	}
yy1104:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1105;
	default:	goto yy53;
	}
yy1105:
	yyaccept = 19;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch(yych) {
	case '+':
	case '-':	goto yy1107;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1105;
	default:	goto yy937;
	}
yy1107:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':	goto yy1108;
	case '2':	goto yy1109;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1110;
	default:	goto yy53;
	}
yy1108:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1110;
	case ':':	goto yy1111;
	default:	goto yy937;
	}
yy1109:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1110;
	case '4':
	case '5':	goto yy1112;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	case ':':	goto yy1111;
	default:	goto yy937;
	}
yy1110:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1112;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	case ':':	goto yy1111;
	default:	goto yy937;
	}
yy1111:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1112;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy937;
	}
yy1112:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	default:	goto yy937;
	}
yy1113:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy1114;
	default:	goto yy53;
	}
yy1114:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'E':
	case 'e':	goto yy973;
	default:	goto yy889;
	}
yy1115:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'V':
	case 'v':	goto yy1116;
	default:	goto yy53;
	}
yy1116:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'E':
	case 'e':	goto yy980;
	default:	goto yy889;
	}
yy1117:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy1118;
	default:	goto yy53;
	}
yy1118:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'O':
	case 'o':	goto yy986;
	default:	goto yy889;
	}
yy1119:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'P':
	case 'p':	goto yy1120;
	default:	goto yy53;
	}
yy1120:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'T':
	case 't':	goto yy1121;
	default:	goto yy889;
	}
yy1121:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'E':
	case 'e':	goto yy992;
	default:	goto yy889;
	}
yy1122:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy1125;
	default:	goto yy53;
	}
yy1123:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1124;
	default:	goto yy53;
	}
yy1124:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'I':
	case 'i':	goto yy999;
	default:	goto yy889;
	}
yy1125:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'U':
	case 'u':	goto yy1001;
	default:	goto yy889;
	}
yy1126:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1127;
	case 'Y':
	case 'y':	goto yy1128;
	default:	goto yy53;
	}
yy1127:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'C':
	case 'c':	goto yy1005;
	default:	goto yy889;
	}
yy1128:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	default:	goto yy889;
	}
yy1129:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy1130;
	default:	goto yy53;
	}
yy1130:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'R':
	case 'r':	goto yy1008;
	default:	goto yy889;
	}
yy1131:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'L':
	case 'l':	goto yy1135;
	case 'N':
	case 'n':	goto yy1134;
	default:	goto yy53;
	}
yy1132:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'N':
	case 'n':	goto yy1133;
	default:	goto yy53;
	}
yy1133:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'U':
	case 'u':	goto yy1015;
	default:	goto yy889;
	}
yy1134:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'E':
	case 'e':	goto yy977;
	default:	goto yy889;
	}
yy1135:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '-':	goto yy863;
	case 'Y':
	case 'y':	goto yy977;
	default:	goto yy889;
	}
yy1136:
	yych = *++YYCURSOR;
	switch(yych) {
	case '.':	goto yy845;
	case '/':	goto yy844;
	case 'U':
	case 'u':	goto yy74;
	default:	goto yy617;
	}
yy1137:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'C':
	case 'c':	goto yy121;
	case 'P':
	case 'p':	goto yy709;
	default:	goto yy53;
	}
yy1138:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy615;
	case '.':	goto yy845;
	case '/':	goto yy844;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy851;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy1140;
	}
yy1139:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1140:
	switch(yych) {
	case ' ':	goto yy1139;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':
	case 'a':	goto yy699;
	case 'D':
	case 'd':	goto yy608;
	case 'F':
	case 'f':	goto yy609;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy619;
	case 'J':
	case 'j':	goto yy623;
	case 'M':
	case 'm':	goto yy607;
	case 'N':
	case 'n':	goto yy626;
	case 'O':
	case 'o':	goto yy625;
	case 'S':
	case 's':	goto yy605;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy621;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy622;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1141:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy615;
	case '.':	goto yy1142;
	case '/':	goto yy844;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1144;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy851;
	case ':':	goto yy1143;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy1140;
	}
yy1142:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1166;
	case '1':	goto yy1167;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1168;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1169;
	default:	goto yy617;
	}
yy1143:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1161;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1162;
	default:	goto yy53;
	}
yy1144:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy852;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1145;
	default:	goto yy57;
	}
yy1145:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy884;
	case '-':	goto yy881;
	case '.':	goto yy887;
	case '/':	goto yy882;
	case '0':	goto yy1147;
	case '1':	goto yy1148;
	case '2':	goto yy1149;
	case '3':	goto yy1150;
	case '4':
	case '5':	goto yy1151;
	case '6':	goto yy1152;
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy902;
	case 'W':	goto yy905;
	default:	goto yy1146;
	}
yy1146:
#line 970 "parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 22763 "<stdout>"
yy1147:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1159;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1160;
	default:	goto yy57;
	}
yy1148:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':	goto yy1158;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1157;
	default:	goto yy57;
	}
yy1149:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1157;
	default:	goto yy57;
	}
yy1150:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1155;
	case '6':	goto yy1156;
	case '7':
	case '8':
	case '9':	goto yy1153;
	default:	goto yy57;
	}
yy1151:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1153;
	default:	goto yy57;
	}
yy1152:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':	goto yy1153;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy57;
	}
yy1153:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy1154;
	}
yy1154:
#line 1015 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 22905 "<stdout>"
yy1155:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy1154;
	}
yy1156:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy915;
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy1154;
	}
yy1157:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy1154;
	}
yy1158:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':	goto yy939;
	case '1':
	case '2':	goto yy940;
	case '3':	goto yy941;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy1154;
	}
yy1159:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':	goto yy51;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy1154;
	}
yy1160:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy57;
	case '0':	goto yy939;
	case '1':
	case '2':	goto yy940;
	case '3':	goto yy941;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	default:	goto yy1154;
	}
yy1161:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy1163;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1162;
	default:	goto yy634;
	}
yy1162:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':
	case ':':	goto yy1163;
	default:	goto yy634;
	}
yy1163:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1164;
	case '6':	goto yy1165;
	case '7':
	case '8':
	case '9':	goto yy639;
	default:	goto yy53;
	}
yy1164:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy639;
	default:	goto yy634;
	}
yy1165:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':	goto yy639;
	default:	goto yy634;
	}
yy1166:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy1170;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1169;
	case ':':	goto yy1163;
	default:	goto yy634;
	}
yy1167:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy1170;
	case '0':
	case '1':
	case '2':	goto yy1169;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1162;
	case ':':	goto yy1163;
	default:	goto yy634;
	}
yy1168:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy1170;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1162;
	case ':':	goto yy1163;
	default:	goto yy634;
	}
yy1169:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy1170;
	case ':':	goto yy1163;
	default:	goto yy634;
	}
yy1170:
	yych = *++YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1171;
	case '6':	goto yy1172;
	case '7':
	case '8':
	case '9':	goto yy727;
	default:	goto yy53;
	}
yy1171:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1173;
	default:	goto yy634;
	}
yy1172:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':	goto yy1173;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy728;
	default:	goto yy634;
	}
yy1173:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '.':	goto yy640;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy730;
	default:	goto yy634;
	}
yy1174:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1144;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy851;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy604;
	}
yy1175:
	yych = *++YYCURSOR;
	switch(yych) {
	case '-':	goto yy615;
	case '.':	goto yy1142;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1144;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy851;
	case ':':	goto yy1143;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy1140;
	}
yy1176:
	yych = *++YYCURSOR;
	switch(yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1177;
	default:	goto yy53;
	}
yy1177:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch(yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1177;
	default:	goto yy1179;
	}
yy1179:
#line 905 "parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 23399 "<stdout>"
yy1180:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'N':
	case 'n':	goto yy1211;
	default:	goto yy3;
	}
yy1181:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'I':
	case 'i':	goto yy1205;
	case 'U':
	case 'u':	goto yy1204;
	default:	goto yy3;
	}
yy1182:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'D':
	case 'd':	goto yy1193;
	case 'M':
	case 'm':	goto yy1194;
	default:	goto yy3;
	}
yy1183:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'E':
	case 'e':	goto yy1189;
	default:	goto yy3;
	}
yy1184:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'E':
	case 'e':	goto yy1185;
	default:	goto yy3;
	}
yy1185:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'L':
	case 'l':	goto yy1186;
	default:	goto yy3;
	}
yy1186:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'F':
	case 'f':	goto yy1187;
	default:	goto yy3;
	}
yy1187:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy1188;
	default:	goto yy53;
	}
yy1188:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy53;
	}
yy1189:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'S':
	case 's':	goto yy1190;
	default:	goto yy341;
	}
yy1190:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'D':
	case 'd':	goto yy1191;
	default:	goto yy3;
	}
yy1191:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1192;
	default:	goto yy53;
	}
yy1192:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy1193:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy1201;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy3;
	}
yy1194:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'O':
	case 'o':	goto yy1195;
	default:	goto yy3;
	}
yy1195:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'R':
	case 'r':	goto yy1196;
	default:	goto yy3;
	}
yy1196:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1197;
	default:	goto yy53;
	}
yy1197:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':
	case 'o':	goto yy1198;
	default:	goto yy53;
	}
yy1198:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'W':
	case 'w':	goto yy1199;
	default:	goto yy53;
	}
yy1199:
	++YYCURSOR;
yy1200:
#line 893 "parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24012 "<stdout>"
yy1201:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'Y':
	case 'y':	goto yy1202;
	default:	goto yy3;
	}
yy1202:
	++YYCURSOR;
yy1203:
#line 883 "parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24033 "<stdout>"
yy1204:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'R':
	case 'r':	goto yy1207;
	default:	goto yy341;
	}
yy1205:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'R':
	case 'r':	goto yy1206;
	case 'S':
	case 's':	goto yy317;
	default:	goto yy3;
	}
yy1206:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'D':
	case 'd':	goto yy159;
	default:	goto yy3;
	}
yy1207:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'S':
	case 's':	goto yy1208;
	default:	goto yy3;
	}
yy1208:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy1209;
	default:	goto yy53;
	}
yy1209:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1210;
	default:	goto yy53;
	}
yy1210:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy1211:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy1212;
	default:	goto yy3;
	}
yy1212:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy3;
	}
yy1213:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'N':	goto yy1211;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'n':	goto yy1242;
	default:	goto yy3;
	}
yy1214:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'I':	goto yy1205;
	case 'U':	goto yy1204;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'i':	goto yy1236;
	case 'u':	goto yy1235;
	default:	goto yy3;
	}
yy1215:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'D':	goto yy1193;
	case 'M':	goto yy1194;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'd':	goto yy1226;
	case 'm':	goto yy1227;
	default:	goto yy3;
	}
yy1216:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'E':	goto yy1189;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'e':	goto yy1222;
	default:	goto yy3;
	}
yy1217:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'E':	goto yy1185;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'e':	goto yy1218;
	default:	goto yy3;
	}
yy1218:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'L':	goto yy1186;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'l':	goto yy1219;
	default:	goto yy3;
	}
yy1219:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'F':	goto yy1187;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'f':	goto yy1220;
	default:	goto yy3;
	}
yy1220:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy1188;
	case 't':	goto yy1221;
	default:	goto yy144;
	}
yy1221:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy53;
	}
yy1222:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'S':	goto yy1190;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 's':	goto yy1223;
	default:	goto yy341;
	}
yy1223:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy1191;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy1224;
	default:	goto yy3;
	}
yy1224:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy1192;
	case 'a':	goto yy1225;
	default:	goto yy144;
	}
yy1225:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy1226:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':	goto yy1201;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'a':	goto yy1233;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy3;
	}
yy1227:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'O':	goto yy1195;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'o':	goto yy1228;
	default:	goto yy3;
	}
yy1228:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy1196;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy1229;
	default:	goto yy3;
	}
yy1229:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy1197;
	case 'r':	goto yy1230;
	default:	goto yy144;
	}
yy1230:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'O':	goto yy1198;
	case 'o':	goto yy1231;
	default:	goto yy144;
	}
yy1231:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'W':	goto yy1199;
	case 'w':	goto yy1232;
	default:	goto yy144;
	}
yy1232:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy1200;
	}
yy1233:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'Y':	goto yy1202;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy143;
	case 'y':	goto yy1234;
	default:	goto yy3;
	}
yy1234:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy1203;
	}
yy1235:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'R':	goto yy1207;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'r':	goto yy1238;
	default:	goto yy341;
	}
yy1236:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'R':	goto yy1206;
	case 'S':	goto yy317;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'r':	goto yy1237;
	case 's':	goto yy320;
	default:	goto yy3;
	}
yy1237:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'D':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'd':	goto yy241;
	default:	goto yy3;
	}
yy1238:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'S':	goto yy1208;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 's':	goto yy1239;
	default:	goto yy3;
	}
yy1239:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy1209;
	case 'd':	goto yy1240;
	default:	goto yy144;
	}
yy1240:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy1210;
	case 'a':	goto yy1241;
	default:	goto yy144;
	}
yy1241:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy1242:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy1212;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy1243;
	default:	goto yy3;
	}
yy1243:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy3;
	}
yy1244:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy134;
	case 'R':
	case 'r':	goto yy1255;
	case 'Y':
	case 'y':	goto yy1256;
	default:	goto yy3;
	}
yy1245:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'D':
	case 'd':	goto yy1250;
	default:	goto yy3;
	}
yy1246:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'N':
	case 'n':	goto yy1247;
	default:	goto yy3;
	}
yy1247:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'D':
	case 'd':	goto yy1248;
	default:	goto yy341;
	}
yy1248:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'a':	goto yy1249;
	default:	goto yy3;
	}
yy1249:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy347;
	default:	goto yy53;
	}
yy1250:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'N':
	case 'n':	goto yy1251;
	default:	goto yy3;
	}
yy1251:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'I':
	case 'i':	goto yy1252;
	default:	goto yy3;
	}
yy1252:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':
	case 'g':	goto yy1253;
	default:	goto yy53;
	}
yy1253:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':
	case 'h':	goto yy1254;
	default:	goto yy53;
	}
yy1254:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':
	case 't':	goto yy1202;
	default:	goto yy53;
	}
yy1255:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'C':
	case 'c':	goto yy1257;
	default:	goto yy3;
	}
yy1256:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy3;
	}
yy1257:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'H':
	case 'h':	goto yy358;
	default:	goto yy3;
	}
yy1258:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy134;
	case 'R':	goto yy1255;
	case 'Y':	goto yy1256;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy137;
	case 'r':	goto yy1269;
	case 'y':	goto yy1270;
	default:	goto yy3;
	}
yy1259:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'D':	goto yy1250;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'd':	goto yy1264;
	default:	goto yy3;
	}
yy1260:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'N':	goto yy1247;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'n':	goto yy1261;
	default:	goto yy3;
	}
yy1261:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'D':	goto yy1248;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'd':	goto yy1262;
	default:	goto yy341;
	}
yy1262:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':	goto yy1249;
	case 'a':	goto yy1263;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy3;
	}
yy1263:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy347;
	case 'y':	goto yy355;
	default:	goto yy144;
	}
yy1264:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'N':	goto yy1251;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'n':	goto yy1265;
	default:	goto yy3;
	}
yy1265:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'I':	goto yy1252;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'i':	goto yy1266;
	default:	goto yy3;
	}
yy1266:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'G':	goto yy1253;
	case 'g':	goto yy1267;
	default:	goto yy144;
	}
yy1267:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'H':	goto yy1254;
	case 'h':	goto yy1268;
	default:	goto yy144;
	}
yy1268:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'T':	goto yy1202;
	case 't':	goto yy1234;
	default:	goto yy144;
	}
yy1269:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'C':	goto yy1257;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'c':	goto yy1271;
	default:	goto yy3;
	}
yy1270:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy3;
	}
yy1271:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy457;
	default:	goto yy3;
	}
yy1272:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'O':
	case 'o':	goto yy1280;
	case 'V':
	case 'v':	goto yy1281;
	case 'W':
	case 'w':	goto yy1278;
	default:	goto yy3;
	}
yy1273:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy134;
	case 'X':
	case 'x':	goto yy1277;
	default:	goto yy3;
	}
yy1274:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'N':
	case 'n':	goto yy1275;
	default:	goto yy3;
	}
yy1275:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy1276;
	default:	goto yy3;
	}
yy1276:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'H':
	case 'h':	goto yy159;
	default:	goto yy3;
	}
yy1277:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy317;
	default:	goto yy3;
	}
yy1278:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	default:	goto yy1279;
	}
yy1279:
#line 862 "parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 26893 "<stdout>"
yy1280:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'N':
	case 'n':	goto yy1286;
	default:	goto yy3;
	}
yy1281:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'E':
	case 'e':	goto yy1282;
	default:	goto yy3;
	}
yy1282:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'M':
	case 'm':	goto yy1283;
	default:	goto yy3;
	}
yy1283:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':
	case 'b':	goto yy1284;
	default:	goto yy53;
	}
yy1284:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':
	case 'e':	goto yy1285;
	default:	goto yy53;
	}
yy1285:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy358;
	default:	goto yy53;
	}
yy1286:
	++YYCURSOR;
	switch((yych = *YYCURSOR)) {
	case ')':	goto yy132;
	default:	goto yy1287;
	}
yy1287:
#line 871 "parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 27083 "<stdout>"
yy1288:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'O':	goto yy1280;
	case 'V':	goto yy1281;
	case 'W':	goto yy1278;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'o':	goto yy1295;
	case 'v':	goto yy1296;
	case 'w':	goto yy1294;
	default:	goto yy3;
	}
yy1289:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy134;
	case 'X':	goto yy1277;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy137;
	case 'x':	goto yy1293;
	default:	goto yy3;
	}
yy1290:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'N':	goto yy1275;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'n':	goto yy1291;
	default:	goto yy3;
	}
yy1291:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy1276;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy1292;
	default:	goto yy3;
	}
yy1292:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'H':	goto yy159;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'h':	goto yy241;
	default:	goto yy3;
	}
yy1293:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy317;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy320;
	default:	goto yy3;
	}
yy1294:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy1279;
	}
yy1295:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'N':	goto yy1286;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'n':	goto yy1301;
	default:	goto yy3;
	}
yy1296:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case '*':
	case '+':
	case ',':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy359;
	case ')':	goto yy360;
	case '-':	goto yy361;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'E':	goto yy1282;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy1297;
	default:	goto yy3;
	}
yy1297:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'M':	goto yy1283;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'm':	goto yy1298;
	default:	goto yy3;
	}
yy1298:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'B':	goto yy1284;
	case 'b':	goto yy1299;
	default:	goto yy144;
	}
yy1299:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'E':	goto yy1285;
	case 'e':	goto yy1300;
	default:	goto yy144;
	}
yy1300:
	yych = *++YYCURSOR;
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'R':	goto yy358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'r':	goto yy457;
	default:	goto yy53;
	}
yy1301:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy1287;
	}
yy1302:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy134;
	case 'S':
	case 's':	goto yy1303;
	default:	goto yy3;
	}
yy1303:
	yych = *++YYCURSOR;
	switch(yych) {
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy135;
	case 'T':
	case 't':	goto yy1304;
	default:	goto yy3;
	}
yy1304:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case 'E':
	case 'e':	goto yy1305;
	default:	goto yy3;
	}
yy1305:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':
	case 'r':	goto yy1306;
	default:	goto yy53;
	}
yy1306:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':
	case 'd':	goto yy1307;
	default:	goto yy53;
	}
yy1307:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':
	case 'a':	goto yy1308;
	default:	goto yy53;
	}
yy1308:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':
	case 'y':	goto yy1309;
	default:	goto yy53;
	}
yy1309:
	++YYCURSOR;
yy1310:
#line 850 "parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 27918 "<stdout>"
yy1311:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy134;
	case 'S':	goto yy1303;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 's':	goto yy1312;
	default:	goto yy3;
	}
yy1312:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy135;
	case 'T':	goto yy1304;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 't':	goto yy1313;
	default:	goto yy3;
	}
yy1313:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy138;
	case 'E':	goto yy1305;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'e':	goto yy1314;
	default:	goto yy3;
	}
yy1314:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'R':	goto yy1306;
	case 'r':	goto yy1315;
	default:	goto yy144;
	}
yy1315:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'D':	goto yy1307;
	case 'd':	goto yy1316;
	default:	goto yy144;
	}
yy1316:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'A':	goto yy1308;
	case 'a':	goto yy1317;
	default:	goto yy144;
	}
yy1317:
	yych = *++YYCURSOR;
	switch(yych) {
	case 'Y':	goto yy1309;
	case 'y':	goto yy1318;
	default:	goto yy144;
	}
yy1318:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch(yych) {
	case '/':
	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy1310;
	}
}
#line 1411 "parse_date.re"

}

#define YYMAXFILL 26

timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
