/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef PATCHVIEW_H
#define PATCHVIEW_H

#include <qobject.h>
#include <qguardedptr.h>
#include <qregexp.h>
#include <qvaluevector.h>

class QTextEdit;
class QLineEdit;
class QRadioButton;
class DiffHighlighter;
class Git;
class MyProcess;
class StateInfo;
class Domain;
class DiffHighlighter;

class PatchView : public QObject {
Q_OBJECT
public:
	PatchView(Domain* d, Git* g, QTextEdit* p, QLineEdit* l, QRadioButton* r);
	~PatchView();
	void update(bool force = false);
	void clear();
	void centerOn(const QString& target);

signals:
	void diffTo(const QString&);
	void diffViewerDocked();

public slots:
	void on_lineEditDiff_returnPressed();
	void on_buttonGroupDiff_clicked(int);
	void on_fileSelected(const QString&);
	void on_procDataReady(const QString& data);
	void on_eof();
	void on_highlightPatch(const QString&, bool);

private:
	friend class DiffHighlighter;

	void centerTarget();
	void saveRestoreSizes(bool startup = false);
	int doSearch(const QString& txt, int pos);
	void computeMatches();
	bool getMatch(int para, int* indexFrom, int* indexTo);
	void centerMatch(uint id = 0);

	Domain* d;
	Git* git;
	QTextEdit* textEditDiff;
	QLineEdit* lineEditDiff;
	QRadioButton* radioButtonSha;
	StateInfo* st;
	DiffHighlighter* diffHighlighter;
	QGuardedPtr<MyProcess> proc;
	QString target;
	QString partialParagraphs;
	QString normalizedSha;
	bool seekTarget;
	bool diffLoaded;
	bool isRegExp;
	QRegExp pickAxeRE;

	struct MatchSelection {
		int paraFrom;
		int indexFrom;
		int paraTo;
		int indexTo;
	};
	typedef QValueVector<MatchSelection> Matches;
	Matches matches;
};

#endif
