/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define TYPECAST 326
#define CSTRING 327
#define CVARIABLE 328
#define CPP_LINE 329
#define IP 330
#define DOLCONST 331
#define ECONST 332
#define NCONST 333
#define UCONST 334
#define UIDENT 335
#define ABORT_P 336
#define ABSOLUTE_P 337
#define ACCESS 338
#define ACTION 339
#define ADD_P 340
#define ADMIN 341
#define AFTER 342
#define AGGREGATE 343
#define ALL 344
#define ALSO 345
#define ALTER 346
#define ALWAYS 347
#define ANALYSE 348
#define ANALYZE 349
#define AND 350
#define ANY 351
#define ARRAY 352
#define AS 353
#define ASC 354
#define ASSERTION 355
#define ASSIGNMENT 356
#define ASYMMETRIC 357
#define AT 358
#define AUTHORIZATION 359
#define BACKWARD 360
#define BEFORE 361
#define BEGIN_P 362
#define BETWEEN 363
#define BIGINT 364
#define BINARY 365
#define BIT 366
#define BOOLEAN_P 367
#define BOTH 368
#define BY 369
#define CACHE 370
#define CALLED 371
#define CASCADE 372
#define CASCADED 373
#define CASE 374
#define CAST 375
#define CATALOG_P 376
#define CHAIN 377
#define CHAR_P 378
#define CHARACTER 379
#define CHARACTERISTICS 380
#define CHECK 381
#define CHECKPOINT 382
#define CLASS 383
#define CLOSE 384
#define CLUSTER 385
#define COALESCE 386
#define COLLATE 387
#define COLUMN 388
#define COMMENT 389
#define COMMIT 390
#define COMMITTED 391
#define CONCURRENTLY 392
#define CONFIGURATION 393
#define CONNECTION 394
#define CONSTRAINT 395
#define CONSTRAINTS 396
#define CONTENT_P 397
#define CONTINUE_P 398
#define CONVERSION_P 399
#define COPY 400
#define COST 401
#define CREATE 402
#define CREATEDB 403
#define CREATEROLE 404
#define CREATEUSER 405
#define CROSS 406
#define CSV 407
#define CURRENT_P 408
#define CURRENT_CATALOG 409
#define CURRENT_DATE 410
#define CURRENT_ROLE 411
#define CURRENT_SCHEMA 412
#define CURRENT_TIME 413
#define CURRENT_TIMESTAMP 414
#define CURRENT_USER 415
#define CURSOR 416
#define CYCLE 417
#define DATA_P 418
#define DATABASE 419
#define DAY_P 420
#define DEALLOCATE 421
#define DEC 422
#define DECIMAL_P 423
#define DECLARE 424
#define DEFAULT 425
#define DEFAULTS 426
#define DEFERRABLE 427
#define DEFERRED 428
#define DEFINER 429
#define DELETE_P 430
#define DELIMITER 431
#define DELIMITERS 432
#define DESC 433
#define DICTIONARY 434
#define DISABLE_P 435
#define DISCARD 436
#define DISTINCT 437
#define DO 438
#define DOCUMENT_P 439
#define DOMAIN_P 440
#define DOUBLE_P 441
#define DROP 442
#define EACH 443
#define ELSE 444
#define ENABLE_P 445
#define ENCODING 446
#define ENCRYPTED 447
#define END_P 448
#define ENUM_P 449
#define ESCAPE 450
#define EXCEPT 451
#define EXCLUDING 452
#define EXCLUSIVE 453
#define EXECUTE 454
#define EXISTS 455
#define EXPLAIN 456
#define EXTERNAL 457
#define EXTRACT 458
#define FALSE_P 459
#define FAMILY 460
#define FETCH 461
#define FIRST_P 462
#define FLOAT_P 463
#define FOLLOWING 464
#define FOR 465
#define FORCE 466
#define FOREIGN 467
#define FORWARD 468
#define FREEZE 469
#define FROM 470
#define FULL 471
#define FUNCTION 472
#define GLOBAL 473
#define GRANT 474
#define GRANTED 475
#define GREATEST 476
#define GROUP_P 477
#define HANDLER 478
#define HAVING 479
#define HEADER_P 480
#define HOLD 481
#define HOUR_P 482
#define IDENTITY_P 483
#define IF_P 484
#define ILIKE 485
#define IMMEDIATE 486
#define IMMUTABLE 487
#define IMPLICIT_P 488
#define IN_P 489
#define INCLUDING 490
#define INCREMENT 491
#define INDEX 492
#define INDEXES 493
#define INHERIT 494
#define INHERITS 495
#define INITIALLY 496
#define INNER_P 497
#define INOUT 498
#define INPUT_P 499
#define INSENSITIVE 500
#define INSERT 501
#define INSTEAD 502
#define INT_P 503
#define INTEGER 504
#define INTERSECT 505
#define INTERVAL 506
#define INTO 507
#define INVOKER 508
#define IS 509
#define ISNULL 510
#define ISOLATION 511
#define JOIN 512
#define KEY 513
#define LANCOMPILER 514
#define LANGUAGE 515
#define LARGE_P 516
#define LAST_P 517
#define LC_COLLATE_P 518
#define LC_CTYPE_P 519
#define LEADING 520
#define LEAST 521
#define LEFT 522
#define LEVEL 523
#define LIKE 524
#define LIMIT 525
#define LISTEN 526
#define LOAD 527
#define LOCAL 528
#define LOCALTIME 529
#define LOCALTIMESTAMP 530
#define LOCATION 531
#define LOCK_P 532
#define LOGIN_P 533
#define MAPPING 534
#define MATCH 535
#define MAXVALUE 536
#define MINUTE_P 537
#define MINVALUE 538
#define MODE 539
#define MONTH_P 540
#define MOVE 541
#define NAME_P 542
#define NAMES 543
#define NATIONAL 544
#define NATURAL 545
#define NCHAR 546
#define NEW 547
#define NEXT 548
#define NO 549
#define NOCREATEDB 550
#define NOCREATEROLE 551
#define NOCREATEUSER 552
#define NOINHERIT 553
#define NOLOGIN_P 554
#define NONE 555
#define NOSUPERUSER 556
#define NOT 557
#define NOTHING 558
#define NOTIFY 559
#define NOTNULL 560
#define NOWAIT 561
#define NULL_P 562
#define NULLIF 563
#define NULLS_P 564
#define NUMERIC 565
#define OBJECT_P 566
#define OF 567
#define OFF 568
#define OFFSET 569
#define OIDS 570
#define OLD 571
#define ON 572
#define ONLY 573
#define OPERATOR 574
#define OPTION 575
#define OPTIONS 576
#define OR 577
#define ORDER 578
#define OUT_P 579
#define OUTER_P 580
#define OVER 581
#define OVERLAPS 582
#define OVERLAY 583
#define OWNED 584
#define OWNER 585
#define PARSER 586
#define PARTIAL 587
#define PARTITION 588
#define PASSWORD 589
#define PLACING 590
#define PLANS 591
#define POSITION 592
#define PRECEDING 593
#define PRECISION 594
#define PRESERVE 595
#define PREPARE 596
#define PREPARED 597
#define PRIMARY 598
#define PRIOR 599
#define PRIVILEGES 600
#define PROCEDURAL 601
#define PROCEDURE 602
#define QUOTE 603
#define RANGE 604
#define READ 605
#define REAL 606
#define REASSIGN 607
#define RECHECK 608
#define RECURSIVE 609
#define REFERENCES 610
#define REINDEX 611
#define RELATIVE_P 612
#define RELEASE 613
#define RENAME 614
#define REPEATABLE 615
#define REPLACE 616
#define REPLICA 617
#define RESET 618
#define RESTART 619
#define RESTRICT 620
#define RETURNING 621
#define RETURNS 622
#define REVOKE 623
#define RIGHT 624
#define ROLE 625
#define ROLLBACK 626
#define ROW 627
#define ROWS 628
#define RULE 629
#define SAVEPOINT 630
#define SCHEMA 631
#define SCROLL 632
#define SEARCH 633
#define SECOND_P 634
#define SECURITY 635
#define SELECT 636
#define SEQUENCE 637
#define SERIALIZABLE 638
#define SERVER 639
#define SESSION 640
#define SESSION_USER 641
#define SET 642
#define SETOF 643
#define SHARE 644
#define SHOW 645
#define SIMILAR 646
#define SIMPLE 647
#define SMALLINT 648
#define SOME 649
#define STABLE 650
#define STANDALONE_P 651
#define START 652
#define STATEMENT 653
#define STATISTICS 654
#define STDIN 655
#define STDOUT 656
#define STORAGE 657
#define STRICT_P 658
#define STRIP_P 659
#define SUBSTRING 660
#define SUPERUSER_P 661
#define SYMMETRIC 662
#define SYSID 663
#define SYSTEM_P 664
#define TABLE 665
#define TABLESPACE 666
#define TEMP 667
#define TEMPLATE 668
#define TEMPORARY 669
#define TEXT_P 670
#define THEN 671
#define TIME 672
#define TIMESTAMP 673
#define TO 674
#define TRAILING 675
#define TRANSACTION 676
#define TREAT 677
#define TRIGGER 678
#define TRIM 679
#define TRUE_P 680
#define TRUNCATE 681
#define TRUSTED 682
#define TYPE_P 683
#define UNBOUNDED 684
#define UNCOMMITTED 685
#define UNENCRYPTED 686
#define UNION 687
#define UNIQUE 688
#define UNKNOWN 689
#define UNLISTEN 690
#define UNTIL 691
#define UPDATE 692
#define USER 693
#define USING 694
#define VACUUM 695
#define VALID 696
#define VALIDATOR 697
#define VALUE_P 698
#define VALUES 699
#define VARCHAR 700
#define VARIADIC 701
#define VARYING 702
#define VERBOSE 703
#define VERSION_P 704
#define VIEW 705
#define VOLATILE 706
#define WHEN 707
#define WHERE 708
#define WHITESPACE_P 709
#define WINDOW 710
#define WITH 711
#define WITHOUT 712
#define WORK 713
#define WRAPPER 714
#define WRITE 715
#define XML_P 716
#define XMLATTRIBUTES 717
#define XMLCONCAT 718
#define XMLELEMENT 719
#define XMLFOREST 720
#define XMLPARSE 721
#define XMLPI 722
#define XMLROOT 723
#define XMLSERIALIZE 724
#define YEAR_P 725
#define YES_P 726
#define ZONE 727
#define NULLS_FIRST 728
#define NULLS_LAST 729
#define WITH_TIME 730
#define IDENT 731
#define FCONST 732
#define SCONST 733
#define BCONST 734
#define XCONST 735
#define Op 736
#define ICONST 737
#define PARAM 738
#define POSTFIXOP 739
#define UMINUS 740




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 383 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1443 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1467 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   85834

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  616
/* YYNRULES -- Number of rules. */
#define YYNRULES  2451
/* YYNRULES -- Number of states. */
#define YYNSTATES  4250

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1612,  1614,  1616,  1618,  1622,  1623,  1625,  1626,  1628,
    1630,  1632,  1636,  1637,  1639,  1641,  1643,  1645,  1647,  1649,
    1652,  1653,  1655,  1658,  1660,  1663,  1664,  1667,  1669,  1672,
    1675,  1682,  1691,  1700,  1705,  1711,  1716,  1721,  1726,  1730,
    1738,  1747,  1754,  1761,  1768,  1775,  1779,  1781,  1785,  1789,
    1791,  1793,  1795,  1797,  1799,  1801,  1805,  1809,  1813,  1815,
    1819,  1823,  1825,  1829,  1843,  1845,  1849,  1854,  1860,  1865,
    1873,  1876,  1878,  1879,  1882,  1883,  1885,  1886,  1893,  1902,
    1911,  1913,  1917,  1923,  1929,  1937,  1947,  1955,  1965,  1971,
    1978,  1985,  1990,  1992,  1994,  1996,  1998,  2000,  2002,  2004,
    2006,  2010,  2014,  2018,  2022,  2024,  2028,  2030,  2033,  2036,
    2040,  2046,  2049,  2052,  2053,  2060,  2068,  2076,  2084,  2093,
    2102,  2109,  2118,  2128,  2138,  2146,  2157,  2165,  2174,  2183,
    2192,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2223,  2225,  2227,  2229,  2234,  2237,  2242,  2245,
    2251,  2256,  2261,  2265,  2269,  2273,  2275,  2277,  2279,  2281,
    2284,  2287,  2289,  2291,  2293,  2296,  2299,  2301,  2304,  2307,
    2309,  2311,  2319,  2327,  2338,  2340,  2342,  2345,  2350,  2356,
    2358,  2362,  2365,  2368,  2371,  2374,  2376,  2379,  2382,  2387,
    2391,  2394,  2397,  2400,  2403,  2406,  2408,  2412,  2414,  2417,
    2421,  2422,  2424,  2428,  2431,  2438,  2445,  2455,  2459,  2460,
    2464,  2465,  2479,  2494,  2496,  2497,  2500,  2501,  2503,  2507,
    2512,  2517,  2524,  2526,  2529,  2530,  2532,  2534,  2535,  2537,
    2539,  2540,  2550,  2563,  2571,  2574,  2575,  2579,  2582,  2584,
    2588,  2592,  2595,  2597,  2601,  2605,  2609,  2612,  2615,  2617,
    2619,  2621,  2623,  2626,  2628,  2630,  2632,  2634,  2639,  2645,
    2647,  2651,  2655,  2657,  2660,  2665,  2671,  2673,  2675,  2677,
    2679,  2683,  2687,  2690,  2693,  2696,  2699,  2701,  2704,  2707,
    2709,  2711,  2713,  2717,  2720,  2721,  2724,  2726,  2730,  2736,
    2738,  2741,  2743,  2744,  2750,  2758,  2764,  2772,  2778,  2786,
    2790,  2796,  2802,  2808,  2810,  2814,  2826,  2837,  2848,  2851,
    2854,  2855,  2865,  2868,  2869,  2874,  2879,  2884,  2886,  2888,
    2890,  2891,  2899,  2906,  2913,  2920,  2927,  2935,  2945,  2955,
    2962,  2969,  2976,  2983,  2990,  2999,  3008,  3015,  3022,  3029,
    3038,  3047,  3056,  3065,  3072,  3074,  3075,  3078,  3079,  3087,
    3094,  3101,  3108,  3115,  3122,  3129,  3137,  3144,  3151,  3158,
    3165,  3173,  3181,  3191,  3201,  3208,  3215,  3222,  3231,  3240,
    3249,  3256,  3258,  3260,  3264,  3268,  3270,  3272,  3274,  3276,
    3278,  3280,  3282,  3283,  3285,  3287,  3289,  3291,  3293,  3295,
    3296,  3303,  3312,  3315,  3318,  3321,  3324,  3327,  3331,  3335,
    3338,  3341,  3344,  3347,  3351,  3354,  3360,  3365,  3369,  3373,
    3377,  3379,  3381,  3382,  3386,  3389,  3392,  3394,  3398,  3401,
    3403,  3404,  3413,  3424,  3428,  3433,  3438,  3439,  3442,  3448,
    3451,  3452,  3456,  3460,  3464,  3468,  3472,  3476,  3480,  3484,
    3488,  3492,  3496,  3500,  3504,  3509,  3513,  3517,  3519,  3520,
    3526,  3533,  3538,  3541,  3542,  3547,  3551,  3557,  3564,  3569,
    3576,  3583,  3589,  3597,  3599,  3600,  3607,  3619,  3631,  3643,
    3657,  3667,  3679,  3690,  3695,  3698,  3704,  3707,  3708,  3713,
    3719,  3725,  3728,  3733,  3735,  3737,  3739,  3740,  3742,  3743,
    3745,  3746,  3750,  3751,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3773,  3779,  3784,  3788,  3789,  3791,  3793,
    3795,  3797,  3802,  3811,  3815,  3816,  3822,  3824,  3829,  3832,
    3834,  3838,  3841,  3844,  3845,  3852,  3855,  3856,  3862,  3866,
    3867,  3870,  3873,  3876,  3880,  3882,  3886,  3888,  3891,  3893,
    3894,  3902,  3904,  3908,  3910,  3912,  3916,  3922,  3925,  3927,
    3931,  3939,  3940,  3944,  3947,  3950,  3953,  3954,  3957,  3960,
    3962,  3964,  3968,  3972,  3974,  3977,  3982,  3987,  3990,  3994,
    4000,  4006,  4008,  4010,  4020,  4022,  4025,  4030,  4035,  4040,
    4043,  4047,  4049,  4053,  4058,  4061,  4063,  4064,  4068,  4072,
    4077,  4082,  4087,  4092,  4095,  4097,  4099,  4100,  4102,  4104,
    4105,  4107,  4113,  4115,  4116,  4118,  4119,  4123,  4125,  4129,
    4134,  4138,  4143,  4148,  4151,  4154,  4159,  4163,  4169,  4178,
    4180,  4181,  4183,  4185,  4187,  4191,  4192,  4194,  4196,  4198,
    4200,  4202,  4204,  4208,  4209,  4212,  4213,  4215,  4219,  4221,
    4222,  4224,  4227,  4232,  4237,  4240,  4241,  4244,  4248,  4251,
    4252,  4254,  4258,  4260,  4263,  4265,  4268,  4274,  4281,  4287,
    4289,  4292,  4294,  4299,  4303,  4308,  4314,  4319,  4325,  4330,
    4336,  4339,  4344,  4346,  4349,  4352,  4355,  4357,  4359,  4360,
    4365,  4368,  4370,  4373,  4376,  4381,  4383,  4387,  4389,  4392,
    4396,  4398,  4401,  4402,  4405,  4410,  4415,  4416,  4418,  4422,
    4425,  4428,  4432,  4438,  4445,  4448,  4452,  4456,  4461,  4462,
    4464,  4466,  4468,  4470,  4472,  4475,  4481,  4483,  4485,  4487,
    4489,  4492,  4496,  4500,  4501,  4503,  4505,  4507,  4509,  4511,
    4514,  4517,  4520,  4523,  4526,  4528,  4532,  4533,  4535,  4537,
    4539,  4541,  4547,  4550,  4552,  4554,  4556,  4558,  4564,  4567,
    4570,  4573,  4575,  4579,  4583,  4586,  4588,  4589,  4593,  4594,
    4600,  4603,  4609,  4612,  4614,  4617,  4621,  4622,  4624,  4626,
    4628,  4630,  4632,  4634,  4638,  4642,  4646,  4650,  4654,  4658,
    4662,  4663,  4665,  4670,  4672,  4676,  4682,  4685,  4688,  4692,
    4696,  4700,  4704,  4708,  4712,  4716,  4720,  4724,  4728,  4731,
    4734,  4738,  4742,  4745,  4749,  4755,  4760,  4767,  4771,  4777,
    4782,  4789,  4794,  4801,  4807,  4815,  4819,  4822,  4827,  4830,
    4834,  4838,  4843,  4847,  4852,  4856,  4861,  4867,  4874,  4881,
    4889,  4896,  4904,  4911,  4919,  4923,  4928,  4933,  4940,  4943,
    4947,  4952,  4954,  4958,  4961,  4964,  4968,  4972,  4976,  4980,
    4984,  4988,  4992,  4996,  5000,  5004,  5007,  5010,  5016,  5023,
    5030,  5038,  5042,  5047,  5049,  5051,  5054,  5059,  5061,  5063,
    5065,  5068,  5071,  5074,  5076,  5081,  5087,  5094,  5103,  5110,
    5117,  5123,  5125,  5127,  5132,  5134,  5139,  5141,  5146,  5148,
    5153,  5155,  5157,  5159,  5161,  5163,  5165,  5172,  5177,  5182,
    5187,  5192,  5199,  5205,  5211,  5217,  5222,  5229,  5234,  5239,
    5244,  5249,  5255,  5263,  5271,  5281,  5286,  5293,  5299,  5307,
    5315,  5323,  5326,  5330,  5334,  5338,  5343,  5344,  5349,  5351,
    5355,  5359,  5361,  5363,  5365,  5368,  5371,  5372,  5375,  5376,
    5378,  5382,  5386,  5389,  5392,  5393,  5400,  5402,  5403,  5407,
    5408,  5411,  5414,  5415,  5417,  5422,  5425,  5428,  5431,  5436,
    5440,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5464,  5466,  5468,  5470,  5472,  5474,  5476,  5481,  5483,  5488,
    5490,  5495,  5497,  5500,  5502,  5505,  5507,  5511,  5513,  5517,
    5521,  5525,  5528,  5530,  5534,  5538,  5539,  5541,  5543,  5545,
    5547,  5549,  5551,  5553,  5555,  5560,  5564,  5567,  5571,  5572,
    5576,  5580,  5583,  5586,  5588,  5589,  5592,  5595,  5599,  5602,
    5604,  5606,  5610,  5616,  5618,  5621,  5626,  5629,  5630,  5632,
    5633,  5635,  5638,  5641,  5644,  5648,  5654,  5656,  5659,  5660,
    5663,  5665,  5666,  5668,  5670,  5672,  5676,  5680,  5682,  5686,
    5690,  5693,  5695,  5697,  5699,  5701,  5703,  5707,  5709,  5712,
    5714,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,  5735,
    5737,  5739,  5741,  5743,  5745,  5748,  5754,  5757,  5761,  5768,
    5770,  5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5789,
    5792,  5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,
    5812,  5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5852,  5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,
    5872,  5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,
    5892,  5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,  5910,
    5912,  5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,  5930,
    5932,  5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,  5950,
    5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,  5970,
    5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,  5990,
    5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,  6010,
    6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,
    6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,  6050,
    6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,  6070,
    6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,  6090,
    6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,  6108,  6110,
    6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,  6128,  6130,
    6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,  6148,  6150,
    6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,  6168,  6170,
    6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,  6188,  6190,
    6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,  6208,  6210,
    6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,  6228,  6230,
    6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,  6248,  6250,
    6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,  6270,
    6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,  6290,
    6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,  6310,
    6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,  6328,  6330,
    6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,  6348,  6350,
    6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366,  6368,  6370,
    6372,  6374,  6376,  6378,  6380,  6382,  6384,  6386,  6388,  6390,
    6392,  6394,  6396,  6398,  6400,  6402,  6404,  6406,  6408,  6410,
    6412,  6414,  6416,  6418,  6420,  6422,  6424,  6426,  6428,  6430,
    6432,  6434,  6436,  6438,  6440,  6442,  6444,  6446,  6448,  6450,
    6452,  6454,  6456,  6458,  6460,  6462,  6464,  6466,  6468,  6470,
    6472,  6474,  6476,  6478,  6480,  6482,  6484,  6486,  6488,  6490,
    6492,  6494,  6496,  6498,  6500,  6502,  6504,  6506,  6508,  6510,
    6512,  6514,  6516,  6518,  6520,  6522,  6524,  6526,  6528,  6530,
    6532,  6534,  6536,  6538,  6540,  6542,  6544,  6546,  6548,  6550,
    6552,  6553,  6556,  6561,  6565,  6568,  6570,  6572,  6574,  6576,
    6578,  6579,  6588,  6589,  6604,  6607,  6613,  6617,  6620,  6623,
    6627,  6635,  6637,  6639,  6641,  6642,  6645,  6648,  6650,  6651,
    6653,  6657,  6659,  6662,  6663,  6666,  6667,  6670,  6671,  6673,
    6677,  6682,  6686,  6688,  6690,  6692,  6694,  6697,  6698,  6701,
    6706,  6707,  6710,  6713,  6716,  6718,  6720,  6728,  6732,  6734,
    6736,  6738,  6740,  6743,  6744,  6746,  6750,  6754,  6758,  6762,
    6763,  6768,  6774,  6780,  6781,  6783,  6785,  6787,  6789,  6792,
    6795,  6798,  6800,  6803,  6804,  6812,  6813,  6819,  6820,  6825,
    6828,  6831,  6832,  6835,  6837,  6839,  6841,  6843,  6845,  6847,
    6849,  6851,  6853,  6855,  6857,  6863,  6866,  6868,  6872,  6875,
    6878,  6882,  6883,  6889,  6891,  6892,  6898,  6901,  6904,  6906,
    6908,  6910,  6913,  6916,  6920,  6922,  6925,  6928,  6932,  6936,
    6941,  6944,  6946,  6949,  6951,  6953,  6956,  6959,  6963,  6965,
    6967,  6969,  6971,  6972,  6974,  6978,  6984,  6985,  6988,  6989,
    6991,  6994,  6998,  7001,  7003,  7005,  7007,  7008,  7010,  7012,
    7014,  7016,  7018,  7021,  7024,  7028,  7029,  7031,  7034,  7036,
    7041,  7046,  7047,  7049,  7051,  7055,  7057,  7059,  7061,  7063,
    7066,  7069,  7071,  7074,  7077,  7079,  7081,  7083,  7088,  7093,
    7098,  7100,  7101,  7105,  7109,  7114,  7116,  7120,  7124,  7129,
    7131,  7135,  7139,  7141,  7143,  7145,  7152,  7154,  7158,  7162,
    7169,  7171,  7175,  7179,  7181,  7183,  7186,  7189,  7191,  7193,
    7195,  7197,  7199,  7201,  7203,  7205,  7207,  7209,  7211,  7213,
    7215,  7217,  7219,  7221,  7226,  7231,  7233,  7235,  7240,  7245,
    7249,  7250,  7258,  7260,  7261,  7262,  7270,  7274,  7279,  7283,
    7285,  7287,  7289,  7292,  7296,  7302,  7305,  7311,  7314,  7316,
    7318,  7320,  7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,
    7338,  7340,  7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,
    7358,  7360,  7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,
    7378,  7380,  7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,
    7398,  7400,  7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,
    7418,  7420,  7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,
    7438,  7440,  7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,
    7458,  7460,  7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,
    7478,  7480,  7482,  7484,  7486,  7488,  7490,  7492,  7494,  7496,
    7498,  7500,  7502,  7504,  7506,  7508,  7510,  7514,  7516,  7517,
    7519,  7522,  7524,  7527,  7529,  7531,  7534,  7537,  7539,  7541,
    7543,  7545,  7547,  7549,  7551,  7553,  7555,  7557,  7559,  7561,
    7563,  7565,  7567,  7569,  7572,  7576,  7578,  7581,  7583,  7587,
    7589,  7593,  7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,
    7611,  7613,  7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,
    7631,  7633,  7635,  7637,  7639,  7641,  7643,  7645,  7647,  7649,
    7651,  7653,  7655,  7657,  7659,  7661,  7663,  7665,  7667,  7669,
    7671,  7673,  7675,  7677,  7679,  7681,  7683,  7685,  7687,  7689,
    7691,  7693,  7695,  7697,  7699,  7701,  7703,  7705,  7707,  7709,
    7711,  7713,  7715,  7718,  7722,  7725,  7729,  7731,  7735,  7739,
    7743,  7747,  7751,  7755,  7757,  7759,  7760,  7763,  7766,  7768,
    7770,  7773
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     506,     0,    -1,   973,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   975,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1117,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   977,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1054,    -1,   980,    -1,   997,
      -1,  1055,    -1,  1037,    -1,  1052,    -1,  1038,    -1,   998,
      -1,  1042,    -1,  1064,    -1,  1056,    -1,  1043,    -1,  1072,
      -1,  1074,    -1,  1067,    -1,  1059,    -1,  1075,    -1,  1078,
      -1,  1080,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1107,    -1,
     334,   307,    -1,   192,   334,  1107,    -1,   431,   334,  1107,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1107,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,  1088,   525,    -1,
    1088,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1107,    -1,   376,  1107,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1087,    -1,   529,
     499,  1088,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1107,    -1,  1109,    -1,   892,  1107,
     894,    -1,   892,   497,   965,   498,  1107,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1107,    -1,   170,    -1,    -1,
    1088,    -1,  1107,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1120,    -1,   390,   417,   472,  1120,    -1,   390,   421,   256,
     268,  1120,    -1,   390,   385,   104,  1120,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
    1088,   548,    -1,    91,   748,  1088,   187,   302,   307,    -1,
      91,   748,  1088,   387,   302,   307,    -1,    91,   748,  1088,
     387,   399,   967,    -1,    91,   748,  1088,   387,   402,  1088,
      -1,   187,   748,  1088,   549,    -1,    91,   748,  1088,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1090,   484,   657,    -1,  1090,    -1,  1090,   499,  1090,
     484,   657,    -1,  1090,   499,  1090,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1107,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1107,    -1,   307,   781,  1107,    -1,   152,    -1,   225,
      -1,   348,   781,  1107,    -1,   195,   781,  1107,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1107,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
    1088,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
    1088,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,  1088,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1106,    -1,   489,  1106,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1107,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1107,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1090,    -1,  1107,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1107,    -1,    -1,   449,  1107,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   639,   322,   640,    -1,
     246,    -1,   175,    -1,   437,    -1,   426,    -1,   210,   642,
     643,    -1,    -1,   188,    -1,    -1,   372,    -1,   398,    -1,
     645,    -1,   644,   500,   645,    -1,    -1,   965,    -1,  1106,
      -1,  1107,    -1,  1105,    -1,   480,    -1,  1088,    -1,   215,
     955,    -1,    -1,   648,    -1,   648,   649,    -1,   649,    -1,
     649,   648,    -1,    -1,   302,   172,    -1,   172,    -1,   241,
     231,    -1,   241,   173,    -1,   187,   423,   957,   317,   955,
     549,    -1,   187,   423,   229,   200,   957,   317,   955,   549,
      -1,   147,   100,   957,   126,   497,   896,   498,   647,    -1,
     187,   100,   957,   549,    -1,   147,    88,   963,   658,   654,
      -1,   147,    88,   963,   659,    -1,   147,   319,   739,   654,
      -1,   147,   428,   680,   654,    -1,   147,   428,   680,    -1,
     147,   428,   680,    98,   497,   870,   498,    -1,   147,   428,
     680,    98,   194,   497,   662,   498,    -1,   147,   415,   378,
     331,   680,   654,    -1,   147,   415,   378,   179,   680,   654,
      -1,   147,   415,   378,   413,   680,   654,    -1,   147,   415,
     378,   138,   680,   654,    -1,   497,   655,   498,    -1,   656,
      -1,   655,   500,   656,    -1,  1090,   484,   657,    -1,  1090,
      -1,   723,    -1,   971,    -1,   922,    -1,   604,    -1,  1107,
      -1,   497,   925,   498,    -1,   497,   490,   498,    -1,   497,
     660,   498,    -1,   661,    -1,   660,   500,   661,    -1,  1109,
     484,   657,    -1,  1107,    -1,   662,   500,  1107,    -1,   147,
     319,   128,   680,   666,   210,   428,   872,   439,   959,   667,
      98,   664,    -1,   665,    -1,   664,   500,   665,    -1,   319,
     965,   739,   668,    -1,   319,   965,   739,   738,   668,    -1,
     217,   965,   963,   715,    -1,   217,   965,   497,   925,   498,
     963,   715,    -1,   402,   872,    -1,   170,    -1,    -1,   205,
     680,    -1,    -1,   353,    -1,    -1,   147,   319,   205,   680,
     439,   959,    -1,    91,   319,   205,   680,   439,   959,    85,
     664,    -1,    91,   319,   205,   680,   439,   959,   187,   671,
      -1,   672,    -1,   671,   500,   672,    -1,   319,   965,   497,
     925,   498,    -1,   217,   965,   497,   925,   498,    -1,   187,
     319,   128,   680,   439,   959,   549,    -1,   187,   319,   128,
     229,   200,   680,   439,   959,   549,    -1,   187,   319,   205,
     680,   439,   959,   549,    -1,   187,   319,   205,   229,   200,
     680,   439,   959,   549,    -1,   187,   329,   114,   956,   549,
      -1,   352,   329,   114,   956,   419,   957,    -1,   187,   678,
     229,   200,   679,   549,    -1,   187,   678,   679,   549,    -1,
     410,    -1,   382,    -1,   450,    -1,   237,    -1,   428,    -1,
     185,    -1,   144,    -1,   376,    -1,   415,   378,   331,    -1,
     415,   378,   179,    -1,   415,   378,   413,    -1,   415,   378,
     138,    -1,   680,    -1,   679,   500,   680,    -1,  1088,    -1,
    1088,   681,    -1,   499,   960,    -1,   681,   499,   960,    -1,
     426,   833,   865,   683,   549,    -1,   143,   228,    -1,   364,
     228,    -1,    -1,   134,   317,   685,   680,   254,   686,    -1,
     134,   317,    88,   963,   658,   254,   686,    -1,   134,   317,
     217,   963,   715,   254,   686,    -1,   134,   317,   319,   739,
     738,   254,   686,    -1,   134,   317,   140,   957,   317,   680,
     254,   686,    -1,   134,   317,   374,   957,   317,   680,   254,
     686,    -1,   134,   317,   374,   957,   254,   686,    -1,   134,
     317,   423,   957,   317,   680,   254,   686,    -1,   134,   317,
     319,   128,   680,   439,   959,   254,   686,    -1,   134,   317,
     319,   205,   680,   439,   959,   254,   686,    -1,   134,   317,
     261,   311,   604,   254,   686,    -1,   134,   317,   120,   497,
     872,    98,   872,   498,   254,   686,    -1,   134,   317,   612,
     260,   680,   254,   686,    -1,   134,   317,   415,   378,   331,
     680,   254,   686,    -1,   134,   317,   415,   378,   179,   680,
     254,   686,    -1,   134,   317,   415,   378,   413,   680,   254,
     686,    -1,   134,   317,   415,   378,   138,   680,   254,   686,
      -1,   133,    -1,   164,    -1,   376,    -1,   237,    -1,   382,
      -1,   410,    -1,   185,    -1,   428,    -1,   450,    -1,   144,
      -1,   411,    -1,   370,    -1,  1107,    -1,   307,    -1,   206,
     688,   689,   957,    -1,   206,   957,    -1,   286,   688,   689,
     957,    -1,   286,   957,    -1,   206,   688,   689,   957,  1120,
      -1,   206,   688,   957,  1120,    -1,   206,   689,   957,  1120,
      -1,   206,   957,  1120,    -1,   206,   688,   957,    -1,   206,
     689,   957,    -1,   293,    -1,   344,    -1,   207,    -1,   262,
      -1,    82,   967,    -1,   357,   967,    -1,   967,    -1,    89,
      -1,   213,    -1,   213,   967,    -1,   213,    89,    -1,   105,
      -1,   105,   967,    -1,   105,    89,    -1,   215,    -1,   234,
      -1,   219,   692,   317,   695,   419,   696,   698,    -1,   368,
     692,   317,   695,   215,   696,   549,    -1,   368,   219,   320,
     210,   692,   317,   695,   215,   696,   549,    -1,   693,    -1,
      89,    -1,    89,   345,    -1,    89,   497,   581,   498,    -1,
      89,   345,   497,   581,   498,    -1,   694,    -1,   693,   500,
     694,    -1,   381,   580,    -1,   355,   580,    -1,   147,   580,
      -1,  1088,   580,    -1,   954,    -1,   410,   954,    -1,   382,
     954,    -1,   212,   163,   459,   956,    -1,   212,   384,   956,
      -1,   217,   699,    -1,   164,   956,    -1,   260,   956,    -1,
     376,   956,    -1,   411,   956,    -1,   697,    -1,   696,   500,
     697,    -1,   966,    -1,   222,   966,    -1,   456,   219,   320,
      -1,    -1,   700,    -1,   699,   500,   700,    -1,   963,   715,
      -1,   219,   693,   419,   956,   703,   704,    -1,   368,   693,
     215,   956,   704,   549,    -1,   368,    86,   320,   210,   693,
     215,   956,   704,   549,    -1,   456,    86,   320,    -1,    -1,
     220,   114,   966,    -1,    -1,   147,   706,   237,   961,   317,
     955,   707,   497,   708,   498,   552,   591,   868,    -1,   147,
     706,   237,   137,   961,   317,   955,   707,   497,   708,   498,
     552,   591,   868,    -1,   433,    -1,    -1,   439,   959,    -1,
      -1,   709,    -1,   708,   500,   709,    -1,  1088,   710,   711,
     712,    -1,   899,   710,   711,   712,    -1,   497,   896,   498,
     710,   711,   712,    -1,   680,    -1,   439,   680,    -1,    -1,
      99,    -1,   178,    -1,    -1,   473,    -1,   474,    -1,    -1,
     147,   714,   217,   963,   717,   367,   722,   725,   729,    -1,
     147,   714,   217,   963,   717,   367,   410,   497,   731,   498,
     725,   729,    -1,   147,   714,   217,   963,   717,   725,   729,
      -1,   322,   361,    -1,    -1,   497,   716,   498,    -1,   497,
     498,    -1,   719,    -1,   716,   500,   719,    -1,   497,   718,
     498,    -1,   497,   498,    -1,   724,    -1,   718,   500,   724,
      -1,   720,   721,   723,    -1,   721,   720,   723,    -1,   721,
     723,    -1,   720,   723,    -1,   723,    -1,   234,    -1,   324,
      -1,   243,    -1,   234,   324,    -1,   446,    -1,  1089,    -1,
     723,    -1,   872,    -1,  1089,   681,   492,   428,    -1,   388,
    1089,   681,   492,   428,    -1,   719,    -1,   719,   170,   896,
      -1,   719,   484,   896,    -1,   727,    -1,   725,   727,    -1,
     116,   317,   307,   244,    -1,   367,   307,   317,   307,   244,
      -1,   403,    -1,   232,    -1,   395,    -1,   451,    -1,   202,
     380,   174,    -1,   202,   380,   253,    -1,   380,   174,    -1,
     380,   253,    -1,   146,   604,    -1,   373,   604,    -1,   538,
      -1,    98,   728,    -1,   260,   536,    -1,   455,    -1,   726,
      -1,  1107,    -1,  1107,   500,  1107,    -1,   456,   654,    -1,
      -1,   721,   723,    -1,   730,    -1,   731,   500,   730,    -1,
      91,   217,   700,   733,   734,    -1,   726,    -1,   733,   726,
      -1,   365,    -1,    -1,   187,   217,   963,   715,   549,    -1,
     187,   217,   229,   200,   963,   715,   549,    -1,   187,    88,
     963,   658,   549,    -1,   187,    88,   229,   200,   963,   658,
     549,    -1,   187,   319,   739,   738,   549,    -1,   187,   319,
     229,   200,   739,   738,   549,    -1,   497,   872,   498,    -1,
     497,   872,   500,   872,   498,    -1,   497,   300,   500,   872,
     498,    -1,   497,   872,   500,   300,   498,    -1,   919,    -1,
    1088,   499,   739,    -1,   147,   120,   497,   872,    98,   872,
     498,   456,   217,   700,   741,    -1,   147,   120,   497,   872,
      98,   872,   498,   457,   217,   741,    -1,   147,   120,   497,
     872,    98,   872,   498,   456,   243,   741,    -1,    98,   233,
      -1,    98,   101,    -1,    -1,   187,   120,   743,   497,   872,
      98,   872,   498,   549,    -1,   229,   200,    -1,    -1,   356,
     745,   955,   746,    -1,   356,   409,   957,   746,    -1,   356,
     164,   957,   746,    -1,   237,    -1,   410,    -1,   211,    -1,
      -1,    91,    88,   963,   658,   359,   419,   957,    -1,    91,
     144,   680,   359,   419,   957,    -1,    91,   164,   958,   359,
     419,   958,    -1,    91,   217,   700,   359,   419,   957,    -1,
      91,   222,   966,   359,   419,   966,    -1,    91,   612,   260,
     957,   359,   419,   957,    -1,    91,   319,   128,   680,   439,
     959,   359,   419,   957,    -1,    91,   319,   205,   680,   439,
     959,   359,   419,   957,    -1,    91,   376,   957,   359,   419,
     957,    -1,    91,   410,   864,   359,   419,   957,    -1,    91,
     382,   955,   359,   419,   957,    -1,    91,   450,   955,   359,
     419,   957,    -1,    91,   237,   955,   359,   419,   957,    -1,
      91,   410,   864,   359,   748,   957,   419,   957,    -1,    91,
     423,   957,   317,   955,   359,   419,   957,    -1,    91,   370,
     966,   359,   419,   966,    -1,    91,   438,   966,   359,   419,
     966,    -1,    91,   411,   957,   359,   419,   957,    -1,    91,
     415,   378,   331,   680,   359,   419,   957,    -1,    91,   415,
     378,   179,   680,   359,   419,   957,    -1,    91,   415,   378,
     413,   680,   359,   419,   957,    -1,    91,   415,   378,   138,
     680,   359,   419,   957,    -1,    91,   428,   680,   359,   419,
     957,    -1,   133,    -1,    -1,   387,   163,    -1,    -1,    91,
      88,   963,   658,   387,   376,   957,    -1,    91,   185,   680,
     387,   376,   957,    -1,    91,   217,   700,   387,   376,   957,
      -1,    91,   410,   864,   387,   376,   957,    -1,    91,   382,
     955,   387,   376,   957,    -1,    91,   450,   955,   387,   376,
     957,    -1,    91,   428,   680,   387,   376,   957,    -1,    91,
      88,   963,   658,   330,   419,   966,    -1,    91,   144,   680,
     330,   419,   966,    -1,    91,   164,   958,   330,   419,   966,
      -1,    91,   185,   680,   330,   419,   966,    -1,    91,   217,
     700,   330,   419,   966,    -1,    91,   612,   260,   957,   330,
     419,   966,    -1,    91,   319,   739,   738,   330,   419,   966,
      -1,    91,   319,   128,   680,   439,   959,   330,   419,   966,
      -1,    91,   319,   205,   680,   439,   959,   330,   419,   966,
      -1,    91,   376,   957,   330,   419,   966,    -1,    91,   428,
     680,   330,   419,   966,    -1,    91,   411,   957,   330,   419,
     966,    -1,    91,   415,   378,   179,   680,   330,   419,   966,
      -1,    91,   415,   378,   138,   680,   330,   419,   966,    -1,
      91,   212,   163,   459,   957,   330,   419,   966,    -1,    91,
     384,   957,   330,   419,   966,    -1,   303,    -1,   754,    -1,
     497,   753,   498,    -1,   753,   501,   755,    -1,   755,    -1,
     823,    -1,   802,    -1,   813,    -1,   807,    -1,   759,    -1,
     754,    -1,    -1,   381,    -1,   437,    -1,   175,    -1,   246,
      -1,   247,    -1,    90,    -1,    -1,   187,   374,   957,   317,
     955,   549,    -1,   187,   374,   229,   200,   957,   317,   955,
     549,    -1,   304,  1088,    -1,   271,  1088,    -1,   435,  1088,
      -1,   435,   490,    -1,    81,   763,    -1,   107,   763,   766,
      -1,   397,   421,   766,    -1,   135,   763,    -1,   193,   763,
      -1,   371,   763,    -1,   375,  1088,    -1,   358,   375,  1088,
      -1,   358,  1088,    -1,   371,   763,   419,   375,  1088,    -1,
     371,   763,   419,  1088,    -1,   341,   421,  1107,    -1,   135,
     342,  1107,    -1,   371,   342,  1107,    -1,   458,    -1,   421,
      -1,    -1,   256,   268,   532,    -1,   350,   318,    -1,   350,
     460,    -1,   764,    -1,   765,   500,   764,    -1,   765,   764,
      -1,   765,    -1,    -1,   147,   566,   450,   955,   580,    98,
     823,   768,    -1,   147,   322,   361,   566,   450,   955,   580,
      98,   823,   768,    -1,   456,   126,   320,    -1,   456,   118,
     126,   320,    -1,   456,   273,   126,   320,    -1,    -1,   272,
     962,    -1,   147,   164,   958,   509,   771,    -1,   771,   772,
      -1,    -1,   411,   773,   957,    -1,   411,   773,   170,    -1,
     276,   773,  1107,    -1,   276,   773,   170,    -1,   413,   773,
     957,    -1,   413,   773,   170,    -1,   191,   773,  1107,    -1,
     191,   773,   965,    -1,   191,   773,   170,    -1,   263,   773,
    1107,    -1,   263,   773,   170,    -1,   264,   773,  1107,    -1,
     264,   773,   170,    -1,   139,   270,   773,   967,    -1,   330,
     773,   957,    -1,   330,   773,   170,    -1,   484,    -1,    -1,
      91,   164,   958,   509,   776,    -1,    91,   164,   958,   387,
     411,   957,    -1,    91,   164,   958,   538,    -1,   776,   777,
      -1,    -1,   139,   270,   773,   967,    -1,   187,   164,   958,
      -1,   187,   164,   229,   200,   958,    -1,   147,   185,   680,
     781,   872,   571,    -1,    91,   185,   680,   548,    -1,    91,
     185,   680,   187,   302,   307,    -1,    91,   185,   680,   387,
     302,   307,    -1,    91,   185,   680,    85,   578,    -1,    91,
     185,   680,   187,   140,   957,   549,    -1,    98,    -1,    -1,
      91,   415,   378,   179,   680,   654,    -1,    91,   415,   378,
     138,   680,    85,   279,   210,   956,   456,   679,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   456,   679,
      -1,    91,   415,   378,   138,   680,    91,   279,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,    91,   279,
     210,   956,   361,   680,   456,   680,    -1,    91,   415,   378,
     138,   680,   187,   279,   210,   956,    -1,    91,   415,   378,
     138,   680,   187,   279,   229,   200,   210,   956,    -1,   147,
     666,   144,   680,   210,  1107,   419,  1107,   215,   680,    -1,
     130,   790,   955,   786,    -1,   130,   790,    -1,   130,   790,
     961,   317,   955,    -1,   439,   961,    -1,    -1,   440,   791,
     792,   790,    -1,   440,   791,   792,   790,   955,    -1,   440,
     791,   792,   790,   788,    -1,   789,   790,    -1,   789,   790,
     955,   793,    -1,    94,    -1,    93,    -1,   448,    -1,    -1,
     216,    -1,    -1,   214,    -1,    -1,   497,   956,   498,    -1,
      -1,   201,   796,   790,   795,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   820,    -1,   975,    -1,   800,    -1,
     789,    -1,    -1,   341,   996,   798,    98,   799,    -1,   341,
     996,   215,  1041,    -1,   497,   925,   498,    -1,    -1,   823,
      -1,   802,    -1,   813,    -1,   807,    -1,   199,   996,   801,
    1119,    -1,   147,   566,   410,   593,    98,   199,   996,   801,
      -1,   497,   924,   498,    -1,    -1,   246,   252,   955,   803,
     806,    -1,   823,    -1,   497,   804,   498,   823,    -1,   170,
     444,    -1,   805,    -1,   804,   500,   805,    -1,  1088,   946,
      -1,   366,   951,    -1,    -1,   175,   215,   866,   808,   869,
     806,    -1,   439,   857,    -1,    -1,   277,   833,   865,   810,
     812,    -1,   234,   811,   284,    -1,    -1,    83,   389,    -1,
     372,   389,    -1,   372,   198,    -1,   389,   437,   198,    -1,
     389,    -1,   389,   372,   198,    -1,   198,    -1,    83,   198,
      -1,   306,    -1,    -1,   437,   866,   387,   814,   856,   869,
     806,    -1,   815,    -1,   814,   500,   815,    -1,   816,    -1,
     817,    -1,   818,   484,   948,    -1,   497,   819,   498,   484,
     950,    -1,  1088,   946,    -1,   818,    -1,   819,   500,   818,
      -1,   169,   957,   821,   161,   822,   210,   823,    -1,    -1,
     821,   294,   377,    -1,   821,   377,    -1,   821,   110,    -1,
     821,   245,    -1,    -1,   456,   226,    -1,   457,   226,    -1,
     825,    -1,   824,    -1,   497,   825,   498,    -1,   497,   824,
     498,    -1,   827,    -1,   826,   837,    -1,   826,   836,   850,
     841,    -1,   826,   836,   840,   851,    -1,   828,   826,    -1,
     828,   826,   837,    -1,   828,   826,   836,   850,   841,    -1,
     828,   826,   836,   840,   851,    -1,   827,    -1,   824,    -1,
     381,   835,   951,   831,   856,   868,   848,   849,   907,    -1,
     855,    -1,   410,   864,    -1,   826,   432,   834,   826,    -1,
     826,   250,   834,   826,    -1,   826,   196,   834,   826,    -1,
     456,   829,    -1,   456,   354,   829,    -1,   830,    -1,   829,
     500,   830,    -1,   957,   793,    98,   824,    -1,   252,   832,
      -1,  1120,    -1,    -1,   414,   833,   955,    -1,   412,   833,
     955,    -1,   273,   414,   833,   955,    -1,   273,   412,   833,
     955,    -1,   218,   414,   833,   955,    -1,   218,   412,   833,
     955,    -1,   410,   955,    -1,   955,    -1,   410,    -1,    -1,
      89,    -1,   182,    -1,    -1,   182,    -1,   182,   317,   497,
     924,   498,    -1,    89,    -1,    -1,   837,    -1,    -1,   323,
     114,   838,    -1,   839,    -1,   838,   500,   839,    -1,   896,
     439,   922,   712,    -1,   896,   711,   712,    -1,   270,   842,
     314,   844,    -1,   314,   844,   270,   842,    -1,   270,   842,
      -1,   314,   844,    -1,   270,   842,   500,   844,    -1,   314,
     845,   846,    -1,   206,   847,   843,   846,   318,    -1,   314,
     845,   846,   206,   847,   843,   846,   318,    -1,   840,    -1,
      -1,   896,    -1,    89,    -1,   967,    -1,   497,   896,   498,
      -1,    -1,   896,    -1,   898,    -1,   372,    -1,   373,    -1,
     207,    -1,   293,    -1,   222,   114,   924,    -1,    -1,   224,
     896,    -1,    -1,   852,    -1,   210,   350,   318,    -1,   850,
      -1,    -1,   853,    -1,   852,   853,    -1,   210,   437,   854,
     812,    -1,   210,   389,   854,   812,    -1,   312,   954,    -1,
      -1,   444,   950,    -1,   855,   500,   950,    -1,   215,   857,
      -1,    -1,   858,    -1,   857,   500,   858,    -1,   864,    -1,
     864,   860,    -1,   867,    -1,   867,   860,    -1,   867,    98,
     497,   870,   498,    -1,   867,    98,  1088,   497,   870,   498,
      -1,   867,  1088,   497,   870,   498,    -1,   824,    -1,   824,
     860,    -1,   859,    -1,   497,   859,   498,   860,    -1,   497,
     859,   498,    -1,   858,   151,   257,   858,    -1,   858,   861,
     257,   858,   863,    -1,   858,   257,   858,   863,    -1,   858,
     290,   861,   257,   858,    -1,   858,   290,   257,   858,    -1,
      98,  1088,   497,   956,   498,    -1,    98,  1088,    -1,  1088,
     497,   956,   498,    -1,  1088,    -1,   216,   862,    -1,   267,
     862,    -1,   369,   862,    -1,   242,    -1,   325,    -1,    -1,
     439,   497,   956,   498,    -1,   317,   896,    -1,   955,    -1,
     955,   490,    -1,   318,   955,    -1,   318,   497,   955,   498,
      -1,   864,    -1,   865,   500,   864,    -1,   864,    -1,   864,
    1088,    -1,   864,    98,  1088,    -1,   899,    -1,   453,   896,
      -1,    -1,   453,   896,    -1,   453,   153,   312,   957,    -1,
     453,   153,   312,  1104,    -1,    -1,   871,    -1,   870,   500,
     871,    -1,  1088,   872,    -1,   874,   873,    -1,   388,   874,
     873,    -1,   874,    97,   495,   965,   496,    -1,   388,   874,
      97,   495,   965,   496,    -1,   874,    97,    -1,   388,   874,
      97,    -1,   873,   495,   496,    -1,   873,   495,  1118,   496,
      -1,    -1,   876,    -1,   878,    -1,   880,    -1,   884,    -1,
     891,    -1,   892,   894,    -1,   892,   497,   965,   498,   894,
      -1,   878,    -1,   881,    -1,   885,    -1,   891,    -1,  1089,
     877,    -1,  1089,   681,   877,    -1,   497,   924,   498,    -1,
      -1,   248,    -1,   249,    -1,   393,    -1,   109,    -1,   351,
      -1,   208,   879,    -1,   186,   339,    -1,   168,   877,    -1,
     167,   877,    -1,   310,   877,    -1,   112,    -1,   497,   965,
     498,    -1,    -1,   882,    -1,   883,    -1,   882,    -1,   883,
      -1,   111,   889,   497,   924,   498,    -1,   111,   889,    -1,
     886,    -1,   887,    -1,   886,    -1,   887,    -1,   888,   497,
     965,   498,   890,    -1,   888,   890,    -1,   124,   889,    -1,
     123,   889,    -1,   445,    -1,   289,   124,   889,    -1,   289,
     123,   889,    -1,   291,   889,    -1,   447,    -1,    -1,   124,
     387,  1088,    -1,    -1,   418,   497,   965,   498,   893,    -1,
     418,   893,    -1,   417,   497,   965,   498,   893,    -1,   417,
     893,    -1,   251,    -1,   475,   472,    -1,   457,   417,   472,
      -1,    -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,
     282,    -1,   895,    -1,   470,   419,   285,    -1,   165,   419,
     227,    -1,   165,   419,   282,    -1,   165,   419,   895,    -1,
     227,   419,   282,    -1,   227,   419,   895,    -1,   282,   419,
     895,    -1,    -1,   379,    -1,   379,   497,   965,   498,    -1,
     898,    -1,   896,    71,   872,    -1,   896,   103,   417,   472,
     896,    -1,   488,   896,    -1,   489,   896,    -1,   896,   488,
     896,    -1,   896,   489,   896,    -1,   896,   490,   896,    -1,
     896,   491,   896,    -1,   896,   492,   896,    -1,   896,   493,
     896,    -1,   896,   485,   896,    -1,   896,   486,   896,    -1,
     896,   484,   896,    -1,   896,   921,   896,    -1,   921,   896,
      -1,   896,   921,    -1,   896,    95,   896,    -1,   896,   322,
     896,    -1,   302,   896,    -1,   896,   269,   896,    -1,   896,
     269,   896,   195,   896,    -1,   896,   302,   269,   896,    -1,
     896,   302,   269,   896,   195,   896,    -1,   896,   230,   896,
      -1,   896,   230,   896,   195,   896,    -1,   896,   302,   230,
     896,    -1,   896,   302,   230,   896,   195,   896,    -1,   896,
     391,   419,   896,    -1,   896,   391,   419,   896,   195,   896,
      -1,   896,   302,   391,   419,   896,    -1,   896,   302,   391,
     419,   896,   195,   896,    -1,   896,   254,   307,    -1,   896,
     255,    -1,   896,   254,   302,   307,    -1,   896,   305,    -1,
     917,   327,   917,    -1,   896,   254,   425,    -1,   896,   254,
     302,   425,    -1,   896,   254,   204,    -1,   896,   254,   302,
     204,    -1,   896,   254,   434,    -1,   896,   254,   302,   434,
      -1,   896,   254,   182,   215,   896,    -1,   896,   254,   302,
     182,   215,   896,    -1,   896,   254,   312,   497,   925,   498,
      -1,   896,   254,   302,   312,   497,   925,   498,    -1,   896,
     108,   947,   897,    95,   897,    -1,   896,   302,   108,   947,
     897,    95,   897,    -1,   896,   108,   407,   897,    95,   897,
      -1,   896,   302,   108,   407,   897,    95,   897,    -1,   896,
     234,   937,    -1,   896,   302,   234,   937,    -1,   896,   923,
     918,   824,    -1,   896,   923,   918,   497,   896,   498,    -1,
     433,   824,    -1,   896,   254,   184,    -1,   896,   254,   302,
     184,    -1,   898,    -1,   897,    71,   872,    -1,   488,   897,
      -1,   489,   897,    -1,   897,   488,   897,    -1,   897,   489,
     897,    -1,   897,   490,   897,    -1,   897,   491,   897,    -1,
     897,   492,   897,    -1,   897,   493,   897,    -1,   897,   485,
     897,    -1,   897,   486,   897,    -1,   897,   484,   897,    -1,
     897,   921,   897,    -1,   921,   897,    -1,   897,   921,    -1,
     897,   254,   182,   215,   897,    -1,   897,   254,   302,   182,
     215,   897,    -1,   897,   254,   312,   497,   925,   498,    -1,
     897,   254,   302,   312,   497,   925,   498,    -1,   897,   254,
     184,    -1,   897,   254,   302,   184,    -1,   943,    -1,   964,
      -1,  1104,   946,    -1,   497,   896,   498,   946,    -1,   938,
      -1,   899,    -1,   824,    -1,   200,   824,    -1,    97,   824,
      -1,    97,   926,    -1,   917,    -1,   963,   497,   498,   910,
      -1,   963,   497,   924,   498,   910,    -1,   963,   497,   446,
     896,   498,   910,    -1,   963,   497,   924,   500,   446,   896,
     498,   910,    -1,   963,   497,    89,   924,   498,   910,    -1,
     963,   497,   182,   924,   498,   910,    -1,   963,   497,   490,
     498,   910,    -1,   155,    -1,   158,    -1,   158,   497,   965,
     498,    -1,   159,    -1,   159,   497,   965,   498,    -1,   274,
      -1,   274,   497,   965,   498,    -1,   275,    -1,   275,   497,
     965,   498,    -1,   156,    -1,   160,    -1,   386,    -1,   438,
      -1,   154,    -1,   157,    -1,   120,   497,   896,    98,   872,
     498,    -1,   203,   497,   928,   498,    -1,   328,   497,   930,
     498,    -1,   337,   497,   932,   498,    -1,   405,   497,   933,
     498,    -1,   422,   497,   896,    98,   872,   498,    -1,   424,
     497,   113,   936,   498,    -1,   424,   497,   265,   936,   498,
      -1,   424,   497,   420,   936,   498,    -1,   424,   497,   936,
     498,    -1,   308,   497,   896,   500,   896,   498,    -1,   131,
     497,   924,   498,    -1,   221,   497,   924,   498,    -1,   266,
     497,   924,   498,    -1,   463,   497,   924,   498,    -1,   464,
     497,   287,  1090,   498,    -1,   464,   497,   287,  1090,   500,
     902,   498,    -1,   464,   497,   287,  1090,   500,   924,   498,
      -1,   464,   497,   287,  1090,   500,   902,   500,   924,   498,
      -1,   465,   497,   903,   498,    -1,   466,   497,   905,   896,
     906,   498,    -1,   467,   497,   287,  1090,   498,    -1,   467,
     497,   287,  1090,   500,   896,   498,    -1,   468,   497,   896,
     500,   900,   901,   498,    -1,   469,   497,   905,   896,    98,
     874,   498,    -1,   449,   896,    -1,   449,   294,   443,    -1,
     500,   396,   471,    -1,   500,   396,   294,    -1,   500,   396,
     294,   443,    -1,    -1,   462,   497,   903,   498,    -1,   904,
      -1,   903,   500,   904,    -1,   896,    98,  1090,    -1,   896,
      -1,   184,    -1,   142,    -1,   340,   454,    -1,   404,   454,
      -1,    -1,   455,   908,    -1,    -1,   909,    -1,   908,   500,
     909,    -1,  1088,    98,   911,    -1,   326,   911,    -1,   326,
    1088,    -1,    -1,   497,   912,   913,   836,   914,   498,    -1,
    1088,    -1,    -1,   333,   114,   924,    -1,    -1,   349,   915,
      -1,   373,   915,    -1,    -1,   916,    -1,   108,   916,    95,
     916,    -1,   429,   338,    -1,   429,   209,    -1,   153,   372,
      -1,   372,   497,   924,   498,    -1,   372,   497,   498,    -1,
     497,   924,   500,   896,   498,    -1,    96,    -1,   394,    -1,
      89,    -1,   481,    -1,   920,    -1,   488,    -1,   489,    -1,
     490,    -1,   491,    -1,   492,    -1,   493,    -1,   485,    -1,
     486,    -1,   484,    -1,   481,    -1,   319,   497,   739,   498,
      -1,   919,    -1,   319,   497,   739,   498,    -1,   919,    -1,
     319,   497,   739,   498,    -1,   269,    -1,   302,   269,    -1,
     230,    -1,   302,   230,    -1,   896,    -1,   924,   500,   896,
      -1,   872,    -1,   925,   500,   872,    -1,   495,   924,   496,
      -1,   495,   927,   496,    -1,   495,   496,    -1,   926,    -1,
     927,   500,   926,    -1,   929,   215,   896,    -1,    -1,  1109,
      -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,   282,
      -1,   379,    -1,  1107,    -1,   896,   931,   934,   935,    -1,
     896,   931,   934,    -1,   335,   896,    -1,   897,   234,   897,
      -1,    -1,   896,   934,   935,    -1,   896,   935,   934,    -1,
     896,   934,    -1,   896,   935,    -1,   924,    -1,    -1,   215,
     896,    -1,   210,   896,    -1,   896,   215,   924,    -1,   215,
     924,    -1,   924,    -1,   824,    -1,   497,   924,   498,    -1,
     119,   942,   939,   941,   193,    -1,   940,    -1,   939,   940,
      -1,   452,   896,   416,   896,    -1,   189,   896,    -1,    -1,
     896,    -1,    -1,   953,    -1,   953,   945,    -1,   499,   960,
      -1,   499,   490,    -1,   495,   896,   496,    -1,   495,   896,
     502,   896,   496,    -1,   944,    -1,   945,   944,    -1,    -1,
     946,   944,    -1,   102,    -1,    -1,   896,    -1,   170,    -1,
     948,    -1,   949,   500,   948,    -1,   497,   949,   498,    -1,
     952,    -1,   951,   500,   952,    -1,   896,    98,  1090,    -1,
     896,  1109,    -1,   896,    -1,   490,    -1,   972,    -1,  1088,
      -1,   955,    -1,   954,   500,   955,    -1,   953,    -1,   953,
     945,    -1,   957,    -1,   956,   500,   957,    -1,  1088,    -1,
    1088,    -1,  1088,    -1,  1090,    -1,  1088,    -1,  1107,    -1,
    1089,    -1,   953,   945,    -1,   965,    -1,  1106,    -1,  1107,
      -1,  1105,    -1,   480,    -1,   963,  1107,    -1,   963,   497,
     924,   498,  1107,    -1,   875,  1107,    -1,   892,  1107,   894,
      -1,   892,   497,   965,   498,  1107,   894,    -1,   425,    -1,
     204,    -1,   307,    -1,  1101,    -1,  1100,    -1,   482,    -1,
    1088,    -1,   965,    -1,  1101,    -1,   488,   965,    -1,   489,
     965,    -1,    81,    -1,    82,    -1,    83,    -1,    84,    -1,
      85,    -1,    86,    -1,    87,    -1,    88,    -1,    90,    -1,
      91,    -1,    92,    -1,   100,    -1,   101,    -1,   103,    -1,
     105,    -1,   106,    -1,   107,    -1,   114,    -1,   115,    -1,
     116,    -1,   117,    -1,   118,    -1,   121,    -1,   122,    -1,
     125,    -1,   127,    -1,   128,    -1,   129,    -1,   130,    -1,
     134,    -1,   135,    -1,   136,    -1,   137,    -1,   138,    -1,
     141,    -1,   142,    -1,   143,    -1,   144,    -1,   145,    -1,
     146,    -1,   148,    -1,   149,    -1,   150,    -1,   152,    -1,
     161,    -1,   162,    -1,   163,    -1,   164,    -1,   166,    -1,
     169,    -1,   171,    -1,   173,    -1,   174,    -1,   175,    -1,
     176,    -1,   177,    -1,   179,    -1,   180,    -1,   181,    -1,
     184,    -1,   185,    -1,   186,    -1,   187,    -1,   188,    -1,
     190,    -1,   191,    -1,   192,    -1,   194,    -1,   195,    -1,
     197,    -1,   198,    -1,   199,    -1,   201,    -1,   202,    -1,
     205,    -1,   207,    -1,   209,    -1,   211,    -1,   213,    -1,
     217,    -1,   218,    -1,   220,    -1,   223,    -1,   225,    -1,
     226,    -1,   228,    -1,   229,    -1,   231,    -1,   232,    -1,
     233,    -1,   235,    -1,   236,    -1,   237,    -1,   238,    -1,
     239,    -1,   240,    -1,   245,    -1,   246,    -1,   247,    -1,
     253,    -1,   256,    -1,   258,    -1,   259,    -1,   260,    -1,
     261,    -1,   262,    -1,   263,    -1,   264,    -1,   268,    -1,
     271,    -1,   272,    -1,   273,    -1,   276,    -1,   277,    -1,
     278,    -1,   279,    -1,   280,    -1,   281,    -1,   283,    -1,
     284,    -1,   286,    -1,   287,    -1,   288,    -1,   293,    -1,
     294,    -1,   295,    -1,   296,    -1,   297,    -1,   298,    -1,
     299,    -1,   301,    -1,   303,    -1,   304,    -1,   306,    -1,
     309,    -1,   311,    -1,   312,    -1,   315,    -1,   319,    -1,
     320,    -1,   321,    -1,   329,    -1,   330,    -1,   331,    -1,
     332,    -1,   333,    -1,   334,    -1,   336,    -1,   338,    -1,
     341,    -1,   342,    -1,   340,    -1,   344,    -1,   345,    -1,
     346,    -1,   347,    -1,   348,    -1,   349,    -1,   350,    -1,
     352,    -1,   353,    -1,   354,    -1,   356,    -1,   357,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,
     363,    -1,   364,    -1,   365,    -1,   367,    -1,   368,    -1,
     370,    -1,   371,    -1,   373,    -1,   374,    -1,   375,    -1,
     376,    -1,   377,    -1,   378,    -1,   380,    -1,   382,    -1,
     383,    -1,   384,    -1,   385,    -1,   387,    -1,   389,    -1,
     390,    -1,   392,    -1,   395,    -1,   396,    -1,   397,    -1,
     398,    -1,   399,    -1,   400,    -1,   401,    -1,   402,    -1,
     403,    -1,   404,    -1,   406,    -1,   408,    -1,   409,    -1,
     411,    -1,   412,    -1,   413,    -1,   414,    -1,   415,    -1,
     421,    -1,   423,    -1,   426,    -1,   427,    -1,   428,    -1,
     429,    -1,   430,    -1,   431,    -1,   434,    -1,   435,    -1,
     436,    -1,   437,    -1,   440,    -1,   441,    -1,   442,    -1,
     443,    -1,   447,    -1,   449,    -1,   450,    -1,   451,    -1,
     454,    -1,   457,    -1,   458,    -1,   459,    -1,   460,    -1,
     461,    -1,   471,    -1,   472,    -1,   109,    -1,   111,    -1,
     112,    -1,   124,    -1,   131,    -1,   167,    -1,   168,    -1,
     200,    -1,   203,    -1,   208,    -1,   221,    -1,   243,    -1,
     249,    -1,   251,    -1,   266,    -1,   289,    -1,   291,    -1,
     300,    -1,   308,    -1,   310,    -1,   324,    -1,   328,    -1,
     337,    -1,   339,    -1,   351,    -1,   372,    -1,   388,    -1,
     393,    -1,   405,    -1,   417,    -1,   418,    -1,   422,    -1,
     424,    -1,   445,    -1,   462,    -1,   463,    -1,   464,    -1,
     465,    -1,   466,    -1,   467,    -1,   468,    -1,   469,    -1,
     104,    -1,   108,    -1,   110,    -1,   151,    -1,   157,    -1,
     214,    -1,   216,    -1,   230,    -1,   242,    -1,   254,    -1,
     255,    -1,   257,    -1,   267,    -1,   269,    -1,   290,    -1,
     305,    -1,   325,    -1,   326,    -1,   327,    -1,   369,    -1,
     391,    -1,   448,    -1,    89,    -1,    93,    -1,    94,    -1,
      95,    -1,    96,    -1,    97,    -1,    98,    -1,    99,    -1,
     102,    -1,   113,    -1,   119,    -1,   120,    -1,   126,    -1,
     132,    -1,   133,    -1,   140,    -1,   147,    -1,   154,    -1,
     155,    -1,   156,    -1,   158,    -1,   159,    -1,   160,    -1,
     170,    -1,   172,    -1,   178,    -1,   182,    -1,   183,    -1,
     189,    -1,   193,    -1,   196,    -1,   204,    -1,   206,    -1,
     210,    -1,   212,    -1,   215,    -1,   219,    -1,   222,    -1,
     224,    -1,   234,    -1,   241,    -1,   250,    -1,   252,    -1,
     265,    -1,   270,    -1,   274,    -1,   275,    -1,   292,    -1,
     302,    -1,   307,    -1,   313,    -1,   314,    -1,   316,    -1,
     317,    -1,   318,    -1,   322,    -1,   323,    -1,   335,    -1,
     343,    -1,   355,    -1,   366,    -1,   381,    -1,   386,    -1,
     394,    -1,   407,    -1,   410,    -1,   416,    -1,   420,    -1,
     425,    -1,   433,    -1,   438,    -1,   439,    -1,   446,    -1,
     452,    -1,   453,    -1,   455,    -1,   456,    -1,   316,    -1,
     292,    -1,    -1,   973,   974,    -1,  1097,   979,   507,   501,
      -1,  1097,   507,   501,    -1,  1097,   999,    -1,  1004,    -1,
    1115,    -1,    74,    -1,   503,    -1,   504,    -1,    -1,   147,
     566,   410,   593,    98,   976,   823,   597,    -1,    -1,   147,
     714,   374,   957,    98,   978,   317,   756,   419,   955,   868,
     183,   757,   752,    -1,   103,  1040,    -1,     9,   419,   981,
     988,   989,    -1,     9,   419,   170,    -1,     9,   990,    -1,
     164,   981,    -1,   982,   985,   987,    -1,   983,   502,   984,
     987,   491,   982,   993,    -1,   992,    -1,  1107,    -1,   958,
      -1,    -1,  1109,  1103,    -1,   481,   986,    -1,   984,    -1,
      -1,  1088,    -1,  1088,   499,   986,    -1,    75,    -1,   502,
     965,    -1,    -1,    98,  1040,    -1,    -1,   438,   990,    -1,
      -1,   991,    -1,   991,   491,   991,    -1,   991,    21,   114,
     991,    -1,   991,   439,   991,    -1,   966,    -1,  1107,    -1,
    1101,    -1,  1103,    -1,   481,   994,    -1,    -1,  1088,   995,
      -1,  1088,   995,   481,   994,    -1,    -1,   484,   965,    -1,
     484,  1109,    -1,   484,  1101,    -1,   957,    -1,   992,    -1,
     169,   957,   821,   161,   822,   210,   996,    -1,   199,   231,
    1041,    -1,  1000,    -1,  1011,    -1,  1013,    -1,   604,    -1,
     500,   604,    -1,    -1,   894,    -1,   470,   419,   282,    -1,
     470,   419,   379,    -1,   165,   419,   165,    -1,   285,   419,
     285,    -1,    -1,  1006,  1005,  1008,  1007,    -1,  1097,   107,
     169,    34,   501,    -1,  1097,   193,   169,    34,   501,    -1,
      -1,  1009,    -1,    74,    -1,  1013,    -1,  1011,    -1,  1009,
    1013,    -1,  1009,  1011,    -1,  1009,    74,    -1,  1013,    -1,
    1010,  1013,    -1,    -1,    70,  1012,  1020,  1036,  1092,   873,
     501,    -1,    -1,  1017,  1020,  1014,  1033,   501,    -1,    -1,
    1020,  1015,  1033,   501,    -1,  1023,   501,    -1,   502,   965,
      -1,    -1,  1018,  1019,    -1,  1018,    -1,  1019,    -1,    56,
      -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,    69,
      -1,  1029,    -1,  1025,    -1,  1021,    -1,  1092,   497,  1001,
    1002,   498,    -1,  1092,  1003,    -1,  1027,    -1,   194,  1086,
    1022,    -1,   194,  1022,    -1,   194,  1086,    -1,   503,  1113,
     504,    -1,    -1,  1027,  1024,   503,  1010,   504,    -1,  1023,
      -1,    -1,  1028,  1026,   503,  1010,   504,    -1,    43,  1086,
      -1,   432,  1086,    -1,    43,    -1,   432,    -1,  1030,    -1,
    1032,  1031,    -1,    44,    35,    -1,    44,    35,   248,    -1,
      44,    -1,    44,   248,    -1,    44,    25,    -1,    44,    25,
     248,    -1,    44,    25,    25,    -1,    44,    25,    25,   248,
      -1,    44,   123,    -1,    35,    -1,    35,   248,    -1,   248,
      -1,    25,    -1,    25,   248,    -1,    25,    25,    -1,    25,
      25,   248,    -1,     5,    -1,   123,    -1,   186,    -1,    36,
      -1,    -1,  1034,    -1,  1033,   500,  1034,    -1,  1036,  1091,
     873,  1016,  1035,    -1,    -1,   484,  1114,    -1,    -1,   490,
      -1,   490,   490,    -1,   169,   398,  1109,    -1,    15,  1039,
      -1,  1040,    -1,   153,    -1,    89,    -1,    -1,   958,    -1,
     170,    -1,   992,    -1,   992,    -1,    72,    -1,    17,   957,
      -1,    17,    89,    -1,    28,   957,  1044,    -1,    -1,  1045,
      -1,   439,  1049,    -1,  1046,    -1,   439,  1048,    14,  1110,
      -1,   252,  1048,    14,  1110,    -1,    -1,    37,    -1,  1050,
      -1,  1050,   500,  1049,    -1,  1051,    -1,  1101,    -1,  1100,
      -1,   965,    -1,   488,   965,    -1,   489,   965,    -1,  1106,
      -1,   488,  1106,    -1,   489,  1106,    -1,  1107,    -1,  1105,
      -1,  1108,    -1,    13,   244,   957,  1046,    -1,    13,  1053,
     957,  1046,    -1,    13,  1053,   957,  1047,    -1,    29,    -1,
      -1,     3,    14,  1110,    -1,   166,    14,  1110,    -1,    18,
      14,  1110,  1057,    -1,  1058,    -1,  1057,   500,  1058,    -1,
    1103,   484,  1063,    -1,   387,    14,  1110,  1060,    -1,  1061,
      -1,  1060,   500,  1061,    -1,  1063,   484,  1062,    -1,   965,
      -1,  1103,    -1,    10,    -1,    18,    14,  1110,   443,  1062,
    1065,    -1,  1066,    -1,  1065,   500,  1066,    -1,  1103,   484,
    1071,    -1,   387,    14,  1110,   443,  1062,  1068,    -1,  1069,
      -1,  1068,   500,  1069,    -1,  1071,   484,  1070,    -1,  1106,
      -1,  1062,    -1,   489,  1106,    -1,   489,   965,    -1,  1107,
      -1,     8,    -1,   163,    -1,    11,    -1,    12,    -1,    22,
      -1,    23,    -1,    24,    -1,   287,    -1,    26,    -1,    27,
      -1,   339,    -1,    31,    -1,    32,    -1,    33,    -1,   428,
      -1,   387,     4,   484,  1073,    -1,   387,     4,   419,  1073,
      -1,   317,    -1,   313,    -1,   387,   139,   419,  1040,    -1,
     387,   139,   484,  1040,    -1,   387,   139,  1040,    -1,    -1,
     428,  1076,  1092,   254,  1020,   873,  1077,    -1,    30,    -1,
      -1,    -1,    45,  1079,  1090,   254,  1020,   873,  1077,    -1,
      46,    38,  1081,    -1,    46,   302,    16,  1081,    -1,    46,
      40,  1081,    -1,   143,    -1,    39,    -1,    42,    -1,    20,
     957,    -1,    19,   419,   957,    -1,   183,   957,   497,  1098,
     498,    -1,   183,     6,    -1,     7,   957,   497,  1098,   498,
      -1,     7,   957,    -1,  1083,    -1,  1084,    -1,     6,    -1,
       7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,
      16,    -1,    19,    -1,    20,    -1,    21,    -1,    22,    -1,
      23,    -1,    24,    -1,    26,    -1,    27,    -1,    31,    -1,
      32,    -1,    33,    -1,    34,    -1,    37,    -1,    38,    -1,
      39,    -1,    40,    -1,    42,    -1,     9,    -1,    13,    -1,
      15,    -1,    28,    -1,    45,    -1,    46,    -1,     5,    -1,
      25,    -1,    29,    -1,    35,    -1,    43,    -1,    36,    -1,
      44,    -1,  1090,    -1,  1109,    -1,   968,    -1,   969,    -1,
    1095,    -1,  1082,    -1,  1093,    -1,   123,    -1,   444,    -1,
    1109,    -1,  1094,    -1,   969,    -1,  1082,    -1,  1093,    -1,
     123,    -1,   444,    -1,  1109,    -1,  1094,    -1,   970,    -1,
    1082,    -1,  1093,    -1,  1085,    -1,  1091,    -1,  1085,    -1,
     123,    -1,   153,    -1,   244,    -1,   248,    -1,   419,    -1,
     432,    -1,   444,    -1,  1093,    -1,  1095,    -1,  1092,    -1,
     968,    -1,   971,    -1,  1084,    -1,   139,    -1,  1109,    -1,
     969,    -1,   970,    -1,  1083,    -1,    50,    -1,    51,    -1,
      56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,
     968,    -1,  1095,    -1,   139,    -1,   165,    -1,   227,    -1,
     282,    -1,   285,    -1,   379,    -1,   470,    -1,  1099,    -1,
    1096,   500,  1099,    -1,    41,    -1,    -1,  1113,    -1,  1103,
    1102,    -1,  1103,    -1,  1103,  1102,    -1,  1103,    -1,  1103,
      -1,    22,  1103,    -1,    22,   957,    -1,    73,    -1,   483,
      -1,   479,    -1,   477,    -1,   478,    -1,    77,    -1,    78,
      -1,    79,    -1,    76,    -1,   480,    -1,   476,    -1,    72,
      -1,    80,    -1,   957,    -1,   992,    -1,  1116,    -1,   497,
     498,    -1,   497,  1112,   498,    -1,  1111,    -1,  1112,  1111,
      -1,  1114,    -1,  1113,   500,  1114,    -1,  1112,    -1,   503,
    1113,   504,    -1,  1116,    -1,   497,    -1,   498,    -1,   500,
      -1,   501,    -1,  1109,    -1,   965,    -1,  1106,    -1,  1107,
      -1,   490,    -1,   488,    -1,   489,    -1,   491,    -1,   492,
      -1,   307,    -1,    47,    -1,    48,    -1,    49,    -1,    50,
      -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,    59,
      -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,
      -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,    69,
      -1,     5,    -1,   194,    -1,   227,    -1,   248,    -1,    25,
      -1,   282,    -1,   285,    -1,   379,    -1,    35,    -1,    36,
      -1,    43,    -1,    44,    -1,   470,    -1,   123,    -1,   208,
      -1,   419,    -1,   432,    -1,   445,    -1,   495,    -1,   496,
      -1,   484,    -1,   502,    -1,   166,   996,    -1,   166,   341,
     996,    -1,   166,    89,    -1,   166,   341,    89,    -1,   965,
      -1,   497,  1118,   498,    -1,  1118,   488,  1118,    -1,  1118,
     489,  1118,    -1,  1118,   490,  1118,    -1,  1118,   491,  1118,
      -1,  1118,   492,  1118,    -1,  1107,    -1,  1088,    -1,    -1,
    1045,  1120,    -1,  1120,  1045,    -1,  1045,    -1,  1120,    -1,
     252,  1096,    -1,  1047,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1188,  1188,  1191,  1193,  1195,  1197,  1199,  1201,  1203,
    1205,  1207,  1209,  1211,  1213,  1215,  1217,  1219,  1221,  1223,
    1225,  1227,  1229,  1231,  1249,  1251,  1253,  1255,  1257,  1259,
    1261,  1263,  1265,  1267,  1269,  1271,  1273,  1275,  1277,  1279,
    1281,  1283,  1285,  1287,  1289,  1291,  1293,  1295,  1297,  1299,
    1301,  1308,  1310,  1312,  1314,  1316,  1318,  1320,  1322,  1324,
    1326,  1328,  1330,  1332,  1334,  1336,  1338,  1340,  1342,  1344,
    1346,  1348,  1350,  1352,  1354,  1356,  1358,  1360,  1362,  1364,
    1366,  1368,  1370,  1372,  1379,  1381,  1383,  1385,  1387,  1389,
    1391,  1393,  1395,  1397,  1399,  1405,  1407,  1409,  1411,  1413,
    1415,  1417,  1419,  1421,  1427,  1437,  1441,  1449,  1453,  1463,
    1473,  1474,  1485,  1492,  1498,  1509,  1515,  1524,  1531,  1537,
    1546,  1553,  1561,  1566,  1574,  1579,  1585,  1590,  1596,  1600,
    1604,  1608,  1612,  1616,  1620,  1624,  1628,  1632,  1636,  1640,
    1644,  1648,  1652,  1656,  1660,  1664,  1668,  1672,  1676,  1680,
    1684,  1688,  1696,  1704,  1712,  1720,  1728,  1736,  1740,  1748,
    1752,  1760,  1768,  1776,  1780,  1788,  1792,  1800,  1804,  1812,
    1817,  1823,  1828,  1834,  1838,  1842,  1846,  1850,  1854,  1862,
    1866,  1870,  1878,  1882,  1886,  1890,  1894,  1898,  1902,  1906,
    1910,  1915,  1919,  1923,  1927,  1931,  1935,  1943,  1947,  1955,
    1959,  1967,  1971,  1975,  1989,  1993,  1997,  2001,  2009,  2013,
    2017,  2021,  2029,  2033,  2037,  2041,  2045,  2049,  2053,  2061,
    2065,  2070,  2076,  2080,  2088,  2092,  2096,  2100,  2104,  2112,
    2116,  2124,  2128,  2132,  2136,  2140,  2149,  2157,  2161,  2169,
    2173,  2181,  2189,  2193,  2197,  2201,  2209,  2213,  2217,  2221,
    2229,  2233,  2241,  2245,  2249,  2253,  2257,  2261,  2265,  2269,
    2273,  2277,  2281,  2285,  2289,  2293,  2297,  2301,  2305,  2309,
    2313,  2317,  2321,  2325,  2329,  2333,  2337,  2341,  2345,  2349,
    2353,  2357,  2361,  2365,  2373,  2377,  2385,  2389,  2394,  2400,
    2405,  2411,  2419,  2424,  2430,  2434,  2442,  2446,  2450,  2454,
    2462,  2466,  2474,  2485,  2496,  2500,  2508,  2512,  2516,  2524,
    2529,  2535,  2539,  2543,  2547,  2551,  2555,  2559,  2563,  2567,
    2571,  2579,  2584,  2590,  2595,  2601,  2606,  2612,  2617,  2623,
    2627,  2635,  2639,  2643,  2647,  2651,  2655,  2660,  2666,  2671,
    2677,  2681,  2689,  2693,  2697,  2705,  2713,  2718,  2724,  2728,
    2732,  2740,  2744,  2748,  2752,  2756,  2760,  2764,  2772,  2776,
    2780,  2784,  2792,  2800,  2805,  2811,  2815,  2819,  2823,  2827,
    2831,  2839,  2843,  2851,  2855,  2859,  2863,  2871,  2876,  2882,
    2886,  2894,  2902,  2906,  2911,  2916,  2922,  2926,  2930,  2934,
    2939,  2945,  2953,  2961,  2965,  2969,  2973,  2977,  2985,  2990,
    2996,  3000,  3004,  3009,  3015,  3019,  3023,  3028,  3034,  3039,
    3045,  3050,  3056,  3064,  3069,  3075,  3079,  3087,  3095,  3099,
    3104,  3110,  3118,  3126,  3131,  3137,  3141,  3149,  3153,  3157,
    3161,  3165,  3169,  3173,  3177,  3181,  3185,  3189,  3193,  3201,
    3206,  3212,  3216,  3220,  3231,  3235,  3243,  3248,  3254,  3258,
    3266,  3270,  3278,  3283,  3289,  3294,  3300,  3304,  3312,  3317,
    3323,  3331,  3336,  3342,  3346,  3354,  3362,  3366,  3374,  3378,
    3382,  3390,  3395,  3401,  3405,  3413,  3421,  3425,  3433,  3437,
    3441,  3445,  3453,  3461,  3469,  3477,  3485,  3490,  3496,  3500,
    3508,  3513,  3519,  3523,  3531,  3535,  3539,  3547,  3555,  3559,
    3563,  3571,  3575,  3583,  3591,  3595,  3603,  3607,  3615,  3619,
    3627,  3631,  3635,  3639,  3647,  3652,  3658,  3663,  3669,  3673,
    3681,  3685,  3690,  3696,  3700,  3704,  3708,  3712,  3716,  3724,
    3729,  3735,  3739,  3746,  3750,  3758,  3764,  3768,  3776,  3780,
    3788,  3792,  3800,  3809,  3818,  3822,  3826,  3830,  3834,  3838,
    3842,  3846,  3850,  3854,  3858,  3866,  3874,  3878,  3886,  3890,
    3898,  3902,  3906,  3910,  3914,  3922,  3926,  3934,  3942,  3946,
    3954,  3962,  3966,  3974,  3982,  3986,  3994,  3998,  4002,  4006,
    4010,  4018,  4023,  4029,  4034,  4040,  4046,  4052,  4060,  4064,
    4072,  4076,  4084,  4088,  4096,  4100,  4108,  4112,  4120,  4128,
    4136,  4140,  4148,  4152,  4156,  4160,  4164,  4168,  4172,  4176,
    4180,  4184,  4188,  4192,  4200,  4204,  4212,  4216,  4224,  4228,
    4236,  4244,  4248,  4253,  4259,  4263,  4267,  4271,  4275,  4279,
    4283,  4287,  4291,  4295,  4299,  4303,  4307,  4311,  4315,  4319,
    4323,  4331,  4335,  4339,  4343,  4347,  4351,  4355,  4359,  4363,
    4367,  4371,  4375,  4383,  4387,  4395,  4400,  4405,  4409,  4413,
    4418,  4423,  4428,  4433,  4438,  4447,  4451,  4455,  4459,  4463,
    4473,  4483,  4493,  4497,  4501,  4511,  4515,  4519,  4529,  4537,
    4541,  4549,  4557,  4561,  4569,  4573,  4577,  4581,  4585,  4593,
    4597,  4605,  4609,  4613,  4617,  4625,  4629,  4633,  4637,  4641,
    4645,  4649,  4653,  4657,  4661,  4669,  4673,  4681,  4685,  4693,
    4698,  4704,  4708,  4716,  4724,  4732,  4736,  4744,  4749,  4755,
    4760,  4766,  4770,  4778,  4783,  4789,  4794,  4800,  4804,  4812,
    4816,  4820,  4828,  4832,  4837,  4843,  4847,  4852,  4858,  4862,
    4867,  4873,  4877,  4881,  4889,  4894,  4900,  4904,  4912,  4916,
    4924,  4928,  4936,  4940,  4948,  4952,  4956,  4960,  4964,  4972,
    4976,  4980,  4984,  4988,  4996,  5004,  5012,  5016,  5020,  5028,
    5032,  5036,  5044,  5048,  5056,  5060,  5064,  5068,  5072,  5076,
    5080,  5084,  5088,  5092,  5096,  5100,  5104,  5112,  5116,  5120,
    5124,  5132,  5136,  5144,  5149,  5155,  5163,  5167,  5175,  5183,
    5187,  5195,  5200,  5206,  5210,  5218,  5222,  5230,  5234,  5242,
    5246,  5250,  5254,  5262,  5266,  5274,  5278,  5282,  5290,  5294,
    5299,  5305,  5313,  5318,  5324,  5328,  5332,  5340,  5344,  5352,
    5357,  5363,  5367,  5371,  5375,  5379,  5383,  5387,  5391,  5395,
    5399,  5403,  5407,  5411,  5415,  5419,  5423,  5427,  5431,  5435,
    5439,  5443,  5447,  5451,  5459,  5464,  5470,  5475,  5481,  5485,
    5489,  5493,  5497,  5501,  5505,  5513,  5517,  5521,  5525,  5529,
    5533,  5537,  5541,  5545,  5549,  5553,  5557,  5561,  5565,  5569,
    5573,  5581,  5585,  5589,  5597,  5601,  5609,  5613,  5617,  5621,
    5625,  5633,  5638,  5644,  5648,  5652,  5656,  5664,  5668,  5673,
    5679,  5683,  5691,  5699,  5707,  5711,  5719,  5723,  5727,  5731,
    5735,  5739,  5743,  5747,  5751,  5755,  5759,  5763,  5767,  5771,
    5779,  5783,  5788,  5794,  5798,  5802,  5810,  5814,  5818,  5826,
    5831,  5837,  5841,  5849,  5854,  5859,  5865,  5871,  5879,  5887,
    5892,  5898,  5902,  5906,  5910,  5914,  5918,  5922,  5926,  5930,
    5934,  5938,  5942,  5946,  5950,  5954,  5958,  5966,  5971,  5977,
    5981,  5989,  5997,  6002,  6008,  6016,  6020,  6028,  6036,  6040,
    6044,  6048,  6052,  6060,  6065,  6071,  6079,  6083,  6087,  6091,
    6095,  6099,  6107,  6115,  6119,  6123,  6131,  6136,  6142,  6146,
    6150,  6158,  6162,  6170,  6174,  6182,  6187,  6193,  6198,  6204,
    6209,  6215,  6220,  6226,  6234,  6238,  6242,  6246,  6250,  6254,
    6258,  6266,  6271,  6277,  6283,  6293,  6298,  6304,  6308,  6312,
    6316,  6324,  6326,  6334,  6339,  6345,  6353,  6357,  6361,  6369,
    6373,  6381,  6389,  6394,  6400,  6408,  6413,  6419,  6427,  6432,
    6438,  6442,  6446,  6450,  6454,  6458,  6462,  6466,  6474,  6479,
    6485,  6493,  6497,  6505,  6509,  6517,  6525,  6533,  6541,  6545,
    6553,  6594,  6596,  6600,  6604,  6608,  6617,  6623,  6627,  6635,
    6639,  6647,  6651,  6659,  6663,  6667,  6671,  6675,  6679,  6683,
    6687,  6695,  6699,  6707,  6711,  6715,  6719,  6723,  6727,  6735,
    6739,  6747,  6751,  6759,  6767,  6772,  6774,  6780,  6784,  6788,
    6792,  6796,  6800,  6804,  6808,  6816,  6821,  6827,  6831,  6836,
    6842,  6846,  6850,  6855,  6861,  6866,  6872,  6880,  6884,  6892,
    6896,  6904,  6908,  6912,  6916,  6920,  6925,  6929,  6933,  6941,
    6946,  6952,  6956,  6964,  6968,  6973,  6979,  6987,  6995,  6999,
    7007,  7011,  7019,  7024,  7030,  7035,  7041,  7045,  7053,  7058,
    7064,  7068,  7076,  7080,  7088,  7093,  7099,  7103,  7111,  7116,
    7122,  7126,  7134,  7138,  7142,  7146,  7150,  7154,  7158,  7162,
    7168,  7172,  7176,  7184,  7188,  7192,  7196,  7200,  7204,  7212,
    7216,  7220,  7224,  7232,  7236,  7240,  7244,  7252,  7257,  7263,
    7267,  7275,  7279,  7283,  7287,  7295,  7299,  7307,  7311,  7315,
    7323,  7331,  7336,  7342,  7346,  7350,  7355,  7361,  7365,  7373,
    7381,  7383,  7385,  7389,  7393,  7397,  7405,  7415,  7426,  7435,
    7439,  7443,  7447,  7451,  7455,  7459,  7467,  7471,  7475,  7479,
    7487,  7491,  7499,  7504,  7510,  7514,  7518,  7522,  7526,  7530,
    7534,  7538,  7542,  7546,  7550,  7558,  7563,  7569,  7573,  7581,
    7585,  7593,  7601,  7609,  7613,  7621,  7625,  7633,  7641,  7649,
    7653,  7657,  7661,  7665,  7669,  7677,  7682,  7688,  7693,  7699,
    7703,  7707,  7711,  7719,  7727,  7731,  7736,  7742,  7746,  7750,
    7754,  7758,  7762,  7766,  7770,  7774,  7778,  7782,  7786,  7790,
    7795,  7801,  7805,  7813,  7817,  7821,  7825,  7829,  7833,  7837,
    7841,  7845,  7849,  7853,  7857,  7861,  7865,  7869,  7873,  7877,
    7881,  7885,  7889,  7893,  7897,  7901,  7905,  7909,  7913,  7917,
    7921,  7925,  7929,  7933,  7937,  7941,  7945,  7949,  7953,  7957,
    7961,  7965,  7969,  7973,  7977,  7981,  7985,  7989,  7993,  7997,
    8001,  8005,  8009,  8013,  8017,  8021,  8025,  8029,  8033,  8038,
    8042,  8050,  8054,  8058,  8062,  8066,  8070,  8074,  8078,  8082,
    8086,  8090,  8094,  8098,  8102,  8106,  8110,  8114,  8118,  8122,
    8126,  8130,  8134,  8142,  8146,  8150,  8154,  8158,  8162,  8166,
    8170,  8174,  8178,  8182,  8190,  8194,  8198,  8202,  8206,  8210,
    8214,  8218,  8222,  8226,  8230,  8234,  8238,  8242,  8246,  8250,
    8254,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,  8290,
    8294,  8298,  8302,  8306,  8310,  8314,  8318,  8322,  8326,  8330,
    8334,  8338,  8342,  8346,  8350,  8354,  8358,  8362,  8366,  8370,
    8374,  8382,  8386,  8394,  8398,  8402,  8407,  8413,  8421,  8425,
    8433,  8437,  8445,  8449,  8457,  8461,  8466,  8472,  8477,  8483,
    8487,  8495,  8503,  8507,  8512,  8518,  8526,  8530,  8537,  8542,
    8548,  8552,  8557,  8563,  8568,  8577,  8581,  8585,  8593,  8597,
    8601,  8609,  8613,  8617,  8625,  8629,  8637,  8641,  8645,  8649,
    8653,  8657,  8661,  8665,  8669,  8677,  8681,  8689,  8693,  8701,
    8705,  8709,  8713,  8717,  8721,  8729,  8733,  8741,  8745,  8753,
    8757,  8761,  8769,  8773,  8781,  8786,  8792,  8796,  8800,  8804,
    8808,  8812,  8816,  8820,  8828,  8832,  8840,  8848,  8853,  8859,
    8863,  8867,  8871,  8875,  8880,  8886,  8894,  8902,  8906,  8910,
    8918,  8922,  8930,  8938,  8942,  8950,  8958,  8963,  8969,  8974,
    8980,  8984,  8992,  8996,  9000,  9004,  9012,  9016,  9025,  9027,
    9035,  9040,  9046,  9050,  9058,  9062,  9070,  9078,  9082,  9090,
    9094,  9098,  9102,  9110,  9114,  9122,  9126,  9134,  9138,  9146,
    9150,  9158,  9166,  9174,  9182,  9190,  9198,  9206,  9210,  9218,
    9222,  9226,  9230,  9234,  9238,  9242,  9246,  9250,  9254,  9258,
    9262,  9266,  9270,  9271,  9276,  9282,  9290,  9294,  9295,  9299,
    9307,  9311,  9315,  9319,  9323,  9327,  9331,  9335,  9339,  9343,
    9347,  9351,  9355,  9359,  9363,  9367,  9371,  9375,  9379,  9383,
    9387,  9391,  9395,  9399,  9403,  9407,  9411,  9415,  9419,  9423,
    9427,  9431,  9435,  9439,  9443,  9447,  9451,  9455,  9459,  9463,
    9467,  9471,  9475,  9479,  9483,  9487,  9491,  9495,  9499,  9503,
    9507,  9511,  9515,  9519,  9523,  9527,  9531,  9535,  9539,  9543,
    9547,  9551,  9555,  9559,  9563,  9567,  9571,  9575,  9579,  9583,
    9587,  9591,  9595,  9599,  9603,  9607,  9611,  9615,  9619,  9623,
    9627,  9631,  9635,  9639,  9643,  9647,  9651,  9655,  9659,  9663,
    9667,  9671,  9675,  9679,  9683,  9687,  9691,  9695,  9699,  9703,
    9707,  9711,  9715,  9719,  9723,  9727,  9731,  9735,  9739,  9743,
    9747,  9751,  9755,  9759,  9763,  9767,  9771,  9775,  9779,  9783,
    9787,  9791,  9795,  9799,  9803,  9807,  9811,  9815,  9819,  9823,
    9827,  9831,  9835,  9839,  9843,  9847,  9851,  9855,  9859,  9863,
    9867,  9871,  9875,  9879,  9883,  9887,  9891,  9895,  9899,  9903,
    9907,  9911,  9915,  9919,  9923,  9927,  9931,  9935,  9939,  9943,
    9947,  9951,  9955,  9959,  9963,  9967,  9971,  9975,  9979,  9983,
    9987,  9991,  9995,  9999, 10003, 10007, 10011, 10015, 10019, 10023,
   10027, 10031, 10035, 10039, 10043, 10047, 10051, 10055, 10059, 10063,
   10067, 10071, 10075, 10079, 10083, 10087, 10091, 10095, 10099, 10103,
   10107, 10111, 10115, 10119, 10123, 10127, 10131, 10135, 10139, 10143,
   10147, 10151, 10155, 10159, 10163, 10167, 10171, 10175, 10179, 10183,
   10187, 10191, 10195, 10199, 10203, 10207, 10211, 10215, 10219, 10223,
   10227, 10231, 10235, 10239, 10243, 10247, 10251, 10259, 10263, 10267,
   10271, 10275, 10279, 10283, 10287, 10291, 10295, 10299, 10303, 10307,
   10311, 10315, 10319, 10323, 10327, 10331, 10335, 10339, 10343, 10347,
   10351, 10355, 10359, 10363, 10367, 10371, 10375, 10379, 10383, 10387,
   10391, 10395, 10399, 10403, 10407, 10411, 10415, 10419, 10423, 10431,
   10435, 10439, 10443, 10447, 10451, 10455, 10459, 10463, 10467, 10471,
   10475, 10479, 10483, 10487, 10491, 10495, 10499, 10503, 10507, 10511,
   10515, 10523, 10527, 10531, 10535, 10539, 10543, 10547, 10551, 10555,
   10559, 10563, 10567, 10571, 10575, 10579, 10583, 10587, 10591, 10595,
   10599, 10603, 10607, 10611, 10615, 10619, 10623, 10627, 10631, 10635,
   10639, 10643, 10647, 10651, 10655, 10659, 10663, 10667, 10671, 10675,
   10679, 10683, 10687, 10691, 10695, 10699, 10703, 10707, 10711, 10715,
   10719, 10723, 10727, 10731, 10735, 10739, 10743, 10747, 10751, 10755,
   10759, 10763, 10767, 10771, 10775, 10779, 10783, 10787, 10791, 10795,
   10799, 10803, 10807, 10811, 10815, 10819, 10823, 10827, 10835, 10842,
   10855, 10856, 10859, 10860, 10861, 10867, 10868, 10869, 10870, 10871,
   10874, 10874, 10884, 10883, 10893, 10909, 10911, 10914, 10916, 10920,
   10932, 10948, 10952, 10963, 10964, 10967, 10979, 10988, 10989, 10992,
   10993, 10994, 10997, 10998, 11001, 11002, 11005, 11006, 11009, 11011,
   11013, 11015, 11019, 11026, 11033, 11049, 11082, 11092, 11095, 11097,
   11110, 11111, 11113, 11115, 11119, 11132, 11139, 11176, 11185, 11187,
   11188, 11191, 11193, 11194, 11197, 11198, 11199, 11200, 11201, 11208,
   11207, 11217, 11219, 11221, 11222, 11223, 11226, 11227, 11228, 11229,
   11230, 11233, 11234, 11238, 11237, 11254, 11252, 11267, 11266, 11279,
   11285, 11286, 11289, 11291, 11292, 11295, 11296, 11297, 11298, 11301,
   11302, 11305, 11313, 11330, 11338, 11361, 11459, 11493, 11495, 11497,
   11501, 11505, 11504, 11555, 11557, 11556, 11571, 11577, 11584, 11589,
   11592, 11593, 11596, 11597, 11598, 11599, 11600, 11601, 11602, 11610,
   11618, 11621, 11622, 11623, 11624, 11625, 11626, 11634, 11642, 11643,
   11644, 11647, 11648, 11651, 11653, 11657, 11743, 11744, 11751, 11752,
   11753, 11759, 11768, 11771, 11772, 11773, 11774, 11777, 11778, 11779,
   11782, 11784, 11792, 11793, 11799, 11801, 11802, 11805, 11806, 11809,
   11816, 11823, 11823, 11825, 11825, 11827, 11834, 11835, 11838, 11839,
   11840, 11841, 11842, 11843, 11844, 11845, 11846, 11852, 11859, 11866,
   11875, 11876, 11888, 11899, 11910, 11914, 11915, 11918, 11923, 11927,
   11928, 11931, 11937, 11945, 11948, 11955, 11959, 11960, 11963, 11966,
   11970, 11971, 11974, 11980, 11988, 11989, 11998, 12007, 12019, 12020,
   12021, 12022, 12023, 12024, 12025, 12026, 12027, 12028, 12029, 12030,
   12031, 12032, 12033, 12040, 12041, 12044, 12045, 12052, 12053, 12054,
   12061, 12060, 12077, 12078, 12085, 12084, 12153, 12159, 12165, 12173,
   12179, 12185, 12191, 12197, 12203, 12209, 12215, 12221, 12232, 12233,
   12236, 12237, 12238, 12239, 12240, 12241, 12242, 12243, 12244, 12245,
   12246, 12247, 12248, 12249, 12250, 12251, 12252, 12253, 12254, 12255,
   12256, 12257, 12258, 12259, 12262, 12263, 12264, 12265, 12266, 12267,
   12271, 12272, 12273, 12274, 12275, 12276, 12277, 12280, 12283, 12284,
   12285, 12286, 12287, 12288, 12289, 12290, 12303, 12304, 12305, 12306,
   12307, 12308, 12309, 12314, 12315, 12316, 12317, 12318, 12319, 12325,
   12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335,
   12338, 12339, 12340, 12341, 12342, 12345, 12346, 12347, 12348, 12351,
   12352, 12353, 12354, 12355, 12356, 12357, 12374, 12375, 12376, 12379,
   12380, 12381, 12382, 12383, 12384, 12388, 12388, 12391, 12397, 12398,
   12401, 12403, 12408, 12418, 12425, 12426, 12427, 12430, 12463, 12465,
   12467, 12470, 12480, 12490, 12500, 12501, 12504, 12506, 12507, 12508,
   12511, 12513, 12521, 12522, 12523, 12527, 12528, 12532, 12533, 12536,
   12537, 12540, 12541, 12542, 12543, 12544, 12547, 12548, 12549, 12550,
   12551, 12552, 12553, 12554, 12555, 12556, 12557, 12558, 12559, 12560,
   12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568, 12569, 12570,
   12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578, 12579, 12580,
   12581, 12582, 12583, 12584, 12585, 12586, 12587, 12588, 12589, 12590,
   12591, 12592, 12593, 12594, 12595, 12596, 12597, 12598, 12599, 12600,
   12601, 12602, 12605, 12606, 12607, 12608, 12611, 12612, 12613, 12614,
   12615, 12616, 12617, 12618, 12619, 12622, 12623, 12624, 12625, 12626,
   12629, 12630
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", 
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONCURRENTLY", 
  "CONFIGURATION", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", 
  "CONTINUE_P", "CONVERSION_P", "COPY", "COST", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", 
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", 
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", 
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", 
  "PARTITION", "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", 
  "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", 
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P", 
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", 
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", 
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", 
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", 
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", 
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op", 
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "','", "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", 
  "CreateRoleStmt", "opt_with", "OptRoleList", "OptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableResetStmt", "SetResetClause", "VariableShowStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "create_as_target", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "opt_with_data", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", 
  "NumericOnly", "CreatePLangStmt", "opt_trusted", "handler_name", 
  "validator_clause", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt", 
  "privileges", "privilege_list", "privilege", "privilege_target", 
  "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "opt_set_data", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList", 
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event", 
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "with_clause", "cte_list", "common_table_expr", 
  "into_clause", "OptTempTableName", "opt_table", "opt_all", 
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list", 
  "sortby", "select_limit", "opt_select_limit", "select_limit_value", 
  "opt_select_fetch_first_value", "select_offset_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "type_list", "array_expr", 
  "array_expr_list", "extract_list", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "RoleId", "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "SpecialRuleRelation", 
  "statements", "statement", "CreateAsStmt", "@1", "RuleStmt", "@2", "at", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@3", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@4", "var_declaration", 
  "@5", "@6", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@9", "opt_reference", "ECPGVar", 
  "@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ecpg_param", "ecpg_bconst", 
  "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident", 
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term", 
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest", 
  "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     640,   640,   640,   640,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   645,   645,   645,   645,   645,   645,   646,
     646,   647,   647,   647,   647,   647,   648,   648,   649,   649,
     650,   650,   651,   652,   653,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   655,   655,   656,   656,
     657,   657,   657,   657,   657,   658,   658,   659,   660,   660,
     661,   662,   662,   663,   664,   664,   665,   665,   665,   665,
     665,   666,   666,   667,   667,   668,   668,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   676,
     677,   677,   678,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   679,   679,   680,   680,   681,   681,
     682,   683,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   687,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   688,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   689,
     689,   690,   691,   691,   692,   692,   692,   692,   692,   693,
     693,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   699,   700,   701,   702,   702,   703,   703,   704,
     704,   705,   705,   706,   706,   707,   707,   708,   708,   709,
     709,   709,   710,   710,   710,   711,   711,   711,   712,   712,
     712,   713,   713,   713,   714,   714,   715,   715,   716,   716,
     717,   717,   718,   718,   719,   719,   719,   719,   719,   720,
     720,   720,   720,   720,   721,   722,   723,   723,   723,   724,
     724,   724,   725,   725,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   727,   727,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   736,   737,   737,   738,
     738,   738,   738,   739,   739,   740,   740,   740,   741,   741,
     741,   742,   743,   743,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   748,   748,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   752,   752,   752,   753,   753,   754,   754,   754,   754,
     754,   755,   755,   756,   756,   756,   756,   757,   757,   757,
     758,   758,   759,   760,   761,   761,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     763,   763,   763,   764,   764,   764,   765,   765,   765,   766,
     766,   767,   767,   768,   768,   768,   768,   769,   770,   771,
     771,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   773,   773,   774,
     774,   775,   776,   776,   777,   778,   778,   779,   780,   780,
     780,   780,   780,   781,   781,   782,   783,   783,   783,   783,
     783,   783,   784,   785,   785,   785,   786,   786,   787,   787,
     787,   788,   788,   789,   789,   790,   790,   791,   791,   792,
     792,   793,   793,   794,   795,   795,   795,   795,   795,   795,
     795,   796,   796,   797,   797,   798,   798,   799,   799,   799,
     799,   800,   800,   801,   801,   802,   803,   803,   803,   804,
     804,   805,   806,   806,   807,   808,   808,   809,   810,   810,
     811,   811,   811,   811,   811,   811,   811,   811,   812,   812,
     813,   814,   814,   815,   815,   816,   817,   818,   819,   819,
     820,   821,   821,   821,   821,   821,   822,   822,   822,   823,
     823,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   826,   827,   827,   827,   827,   827,   827,   828,
     828,   829,   829,   830,   831,   831,   831,   832,   832,   832,
     832,   832,   832,   832,   832,   833,   833,   834,   834,   834,
     835,   835,   835,   835,   836,   836,   837,   838,   838,   839,
     839,   840,   840,   840,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   843,   844,   845,   846,   846,
     847,   847,   848,   848,   849,   849,   850,   850,   851,   851,
     852,   852,   853,   853,   854,   854,   855,   855,   856,   856,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   859,   859,   859,   859,   860,
     860,   860,   860,   861,   861,   861,   861,   862,   862,   863,
     863,   864,   864,   864,   864,   865,   865,   866,   866,   866,
     867,   868,   868,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   875,   875,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   883,   884,   884,   885,   885,   886,   887,   888,
     888,   888,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   891,   891,   892,   893,   893,   893,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   895,   895,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   900,   900,   901,   901,   901,   901,   902,   903,   903,
     904,   904,   905,   905,   906,   906,   906,   907,   907,   908,
     908,   909,   910,   910,   910,   911,   912,   912,   913,   913,
     914,   914,   914,   915,   915,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   919,   919,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   921,   921,   922,   922,   923,
     923,   923,   923,   923,   923,   924,   924,   925,   925,   926,
     926,   926,   927,   927,   928,   928,   929,   929,   929,   929,
     929,   929,   929,   929,   930,   930,   931,   932,   932,   933,
     933,   933,   933,   933,   933,   934,   935,   936,   936,   936,
     937,   937,   938,   939,   939,   940,   941,   941,   942,   942,
     943,   943,   944,   944,   944,   944,   945,   945,   946,   946,
     947,   947,   948,   948,   949,   949,   950,   951,   951,   952,
     952,   952,   952,   953,   953,   954,   954,   955,   955,   956,
     956,   957,   958,   959,   960,   961,   962,   963,   963,   964,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   965,   966,   967,   967,   967,   967,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   972,   972,
     973,   973,   974,   974,   974,   974,   974,   974,   974,   974,
     976,   975,   978,   977,   979,   980,   980,   980,   980,   981,
     981,   981,   981,   982,   982,   983,   984,   985,   985,   986,
     986,   986,   987,   987,   988,   988,   989,   989,   990,   990,
     990,   990,   991,   991,   991,   992,   993,   993,   994,   994,
     995,   995,   995,   995,   996,   996,   997,   998,   999,  1000,
    1000,  1001,  1002,  1002,  1003,  1003,  1003,  1003,  1003,  1005,
    1004,  1006,  1007,  1008,  1008,  1008,  1009,  1009,  1009,  1009,
    1009,  1010,  1010,  1012,  1011,  1014,  1013,  1015,  1013,  1013,
    1016,  1016,  1017,  1017,  1017,  1018,  1018,  1018,  1018,  1019,
    1019,  1020,  1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,
    1022,  1024,  1023,  1025,  1026,  1025,  1027,  1027,  1028,  1028,
    1029,  1029,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,
    1030,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1032,  1032,  1033,  1033,  1034,  1035,  1035,  1036,  1036,
    1036,  1037,  1038,  1039,  1039,  1039,  1039,  1040,  1040,  1040,
    1041,  1041,  1042,  1042,  1043,  1044,  1044,  1045,  1045,  1046,
    1047,  1048,  1048,  1049,  1049,  1050,  1050,  1050,  1051,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1052,  1052,  1052,
    1053,  1053,  1054,  1055,  1056,  1057,  1057,  1058,  1059,  1060,
    1060,  1061,  1062,  1062,  1063,  1064,  1065,  1065,  1066,  1067,
    1068,  1068,  1069,  1070,  1070,  1070,  1070,  1070,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1072,  1072,  1073,  1073,  1074,  1074,  1074,
    1076,  1075,  1077,  1077,  1079,  1078,  1080,  1080,  1080,  1081,
    1081,  1081,  1081,  1081,  1081,  1081,  1081,  1081,  1082,  1082,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1084,  1084,  1084,  1084,  1084,  1084,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1088,  1088,  1088,  1088,
    1088,  1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1090,
    1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,
    1091,  1091,  1091,  1091,  1091,  1092,  1092,  1092,  1092,  1093,
    1093,  1093,  1093,  1093,  1093,  1093,  1094,  1094,  1094,  1095,
    1095,  1095,  1095,  1095,  1095,  1096,  1096,  1097,  1098,  1098,
    1099,  1099,  1100,  1101,  1102,  1102,  1102,  1103,  1104,  1105,
    1106,  1107,  1107,  1107,  1107,  1107,  1108,  1109,  1109,  1109,
    1110,  1110,  1111,  1111,  1111,  1112,  1112,  1113,  1113,  1114,
    1114,  1115,  1115,  1115,  1115,  1115,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1117,  1117,  1117,  1117,  1118,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1119,  1119,  1119,  1119,  1119,
    1120,  1120
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       1,     1,     1,     1,     3,     0,     1,     0,     1,     1,
       1,     3,     0,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     4,     5,     4,     4,     4,     3,     7,
       8,     6,     6,     6,     6,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     2,     4,     2,     5,
       4,     4,     3,     3,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,    13,    14,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,    11,    10,    10,     2,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     6,     6,     8,     8,     6,     6,     6,     8,
       8,     8,     8,     6,     1,     0,     2,     0,     7,     6,
       6,     6,     6,     6,     6,     7,     6,     6,     6,     6,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       6,     8,     2,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     2,     4,     1,     1,     1,     0,     1,     0,     1,
       0,     3,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     3,     5,     8,     1,
       0,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     4,     4,     2,     0,     2,     3,     2,     0,
       1,     3,     1,     2,     1,     2,     5,     6,     5,     1,
       2,     1,     4,     3,     4,     5,     4,     5,     4,     5,
       2,     4,     1,     2,     2,     2,     1,     1,     0,     4,
       2,     1,     2,     2,     4,     1,     3,     1,     2,     3,
       1,     2,     0,     2,     4,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     4,     5,     6,     8,     6,     6,
       5,     1,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     1,     1,     1,     1,     1,     6,     4,     4,     4,
       4,     6,     5,     5,     5,     4,     6,     4,     4,     4,
       4,     5,     7,     7,     9,     4,     6,     5,     7,     7,
       7,     2,     3,     3,     3,     4,     0,     4,     1,     3,
       3,     1,     1,     1,     2,     2,     0,     2,     0,     1,
       3,     3,     2,     2,     0,     6,     1,     0,     3,     0,
       2,     2,     0,     1,     4,     2,     2,     2,     4,     3,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     1,
       4,     1,     2,     1,     2,     1,     3,     1,     3,     3,
       3,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     2,     3,     0,     3,
       3,     2,     2,     1,     0,     2,     2,     3,     2,     1,
       1,     3,     5,     1,     2,     4,     2,     0,     1,     0,
       1,     2,     2,     2,     3,     5,     1,     2,     0,     2,
       1,     0,     1,     1,     1,     3,     3,     1,     3,     3,
       2,     1,     1,     1,     1,     1,     3,     1,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     5,     2,     3,     6,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     2,     1,     1,     1,     1,     1,
       0,     8,     0,    14,     2,     5,     3,     2,     2,     3,
       7,     1,     1,     1,     0,     2,     2,     1,     0,     1,
       3,     1,     2,     0,     2,     0,     2,     0,     1,     3,
       4,     3,     1,     1,     1,     1,     2,     0,     2,     4,
       0,     2,     2,     2,     1,     1,     7,     3,     1,     1,
       1,     1,     2,     0,     1,     3,     3,     3,     3,     0,
       4,     5,     5,     0,     1,     1,     1,     1,     2,     2,
       2,     1,     2,     0,     7,     0,     5,     0,     4,     2,
       2,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     2,     1,     3,     2,     2,
       3,     0,     5,     1,     0,     5,     2,     2,     1,     1,
       1,     2,     2,     3,     1,     2,     2,     3,     3,     4,
       2,     1,     2,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     0,     1,     3,     5,     0,     2,     0,     1,
       2,     3,     2,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     2,     2,     3,     0,     1,     2,     1,     4,
       4,     0,     1,     1,     3,     1,     1,     1,     1,     2,
       2,     1,     2,     2,     1,     1,     1,     4,     4,     4,
       1,     0,     3,     3,     4,     1,     3,     3,     4,     1,
       3,     3,     1,     1,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     3,     1,     3,     3,     3,
       3,     3,     3,     1,     1,     0,     2,     2,     1,     1,
       2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    1980,     0,     2,     1,  2410,  2414,  2418,  2419,  2337,  2420,
    2421,  2386,  2387,  2388,  2389,  2390,  2391,  2392,  2393,  2394,
    2395,  2396,  2397,  2399,  2398,  2400,  2401,  2402,  2403,  2404,
    2405,  2406,  2407,  2409,  2408,  2358,  1987,  2355,  2352,  2353,
    2354,  2359,  2423,  2411,  2424,  2412,  2413,  2415,  2416,  2385,
    2417,  2425,  2426,  2427,  2422,  2357,  2350,  2351,  1594,  2430,
    2381,  2382,  2380,  2383,  2384,  2428,  2429,  2372,  2373,  2374,
    2375,  2431,  1988,  1989,  2377,  1981,  1985,  2049,  2122,  2378,
    2379,  2376,  1986,  2371,  2122,     0,  2240,  2241,  2242,     0,
    2243,  2244,  2245,  2171,  2136,  2246,     0,     0,  2247,  2248,
    2249,  2250,  2251,  2252,  2253,  2254,     0,  2255,  2256,  2257,
    2258,  2121,  2259,  2260,  2261,  2262,  2263,  2098,  2104,  2224,
       0,  2078,  2079,  2075,  2077,  2076,  2080,  2063,   922,   459,
     994,   993,     0,  1879,   922,  1880,  1837,  1881,  1838,  1839,
    1840,   241,     0,   996,  1841,     0,   922,   322,   337,  1882,
    1883,  2004,     0,  1842,  1843,     0,     0,     0,   459,   922,
       0,     0,  1844,  1012,  1845,     0,  1846,  1884,  1885,     0,
    1847,  1886,  1887,  1848,     0,  1849,  1850,  1888,  1889,  1890,
    1851,  1891,  1892,     0,     0,  1106,     0,  1852,  1893,  1853,
    1854,     0,  1894,  1855,  1856,  1857,  1895,  1896,  1897,  1858,
    1859,  1860,     0,  1861,     0,     0,     0,     0,     0,  1898,
     922,  1862,     0,  1113,     0,  1863,     0,  1899,  1864,     0,
    1865,     0,  1866,  1867,  1868,  1869,  1106,  2220,  2099,     0,
       0,   998,     0,  1870,  1900,     0,  1871,  1872,  1873,  1874,
    1875,  1876,  1877,  1878,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   996,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1082,  1069,  1115,  1081,     0,  1084,
    2316,  2317,    28,    92,   122,   104,   105,   110,  1984,  2038,
    2039,  2040,  2122,  2073,  2074,  2067,  2083,  2093,  2082,  2086,
    2094,  2081,  2100,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2318,  1290,  2315,    50,  2055,     0,  2122,  2057,  2056,     0,
    2264,  2265,  2266,  2267,  2268,  2269,  2319,  2320,  2321,  2322,
    2323,  2325,  2324,  2347,  1600,  1601,  1602,  1603,  1604,  1605,
    1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,
    1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  2291,  1624,
    1625,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,  2328,
    1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  2329,  1648,  1649,  1650,  1651,  1652,
    1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,
    1663,  1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,
    1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,
    1683,  1684,  2330,  1685,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1701,
    1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  2331,  1718,  1719,  2332,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1751,
    1749,  1750,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,
    1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,  1769,
    1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,
    1780,  1781,  2333,  1782,  1783,  1784,  1785,  1786,  1787,  1788,
    1789,  1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,
    1799,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
    2004,  1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1823,  1824,  2292,  1825,  1826,
    1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  2334,  1835,
    1836,  2022,  2326,  2288,  1997,  2018,  2289,  2238,  2239,  1595,
    2290,  2287,  2327,  2024,  2343,  2023,  2286,  2170,     0,     0,
    2135,  2134,  2138,  2137,  2139,  2132,  2133,  1572,  2025,  2143,
    2142,  1571,     0,  2145,  2270,  2271,  2272,  2273,  2275,  2274,
    2276,  1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,
    1910,  1911,  1912,  2301,  1913,  1914,  1915,  2314,  1916,  1917,
    2302,  1918,  1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,
    1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,
    1937,  1938,  1939,  1940,  1941,  2303,  2304,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,
    1955,  1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,
    1965,  1966,  1967,  2305,  1968,  1969,  2306,  1970,  1971,  1972,
    2307,  1973,  1974,  1975,  1976,  1977,  2311,  2312,  2313,  2300,
    2096,  2277,  2299,  2310,  2308,  2309,  2106,  2102,  2110,  2105,
       0,     0,     0,     0,  2122,   921,   920,   906,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   458,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1994,     0,   930,   301,   300,   995,   984,   459,     0,   909,
     321,     0,     0,     0,     0,     0,     0,     0,   581,     0,
       0,     0,     0,     0,     0,     0,     0,   170,     0,     0,
     332,   331,     0,     0,   446,     0,   723,     0,     0,   459,
       0,     0,     0,  2003,  1998,  2008,     0,  2001,  2002,  2286,
       0,  2434,  1749,  2034,  2035,  2432,  1794,  1061,     0,   242,
     245,   243,   244,     0,     0,   823,   608,     0,   607,     0,
       0,     0,   605,     0,     0,     0,     0,   609,   603,     0,
     602,     0,     0,     0,   606,     0,   604,     0,     0,   910,
       0,  2088,  2089,  1687,  1024,  1011,   996,  1601,   672,   676,
     667,   673,   679,   680,   668,   665,   666,  1763,     0,     0,
       0,     0,   656,  1596,   671,  1597,   685,   378,   378,   378,
       0,   684,   689,   378,     0,   903,   937,  1576,  1105,     0,
       0,   658,   902,  1809,  1016,     0,     0,   827,     0,   828,
       0,  1778,   914,   228,  2284,  1786,  1866,  1809,  2285,   224,
    2279,  2280,  2282,   197,  2283,  2281,  2278,  1605,     0,     0,
     684,     0,   911,   912,  1112,  1110,     0,     0,     0,  1622,
       0,  1634,  1711,   221,  1774,  1779,  1786,  1866,  1809,  1834,
     179,     0,   235,  1786,  1866,  1809,     0,   930,  1979,  1978,
       0,  1085,  1567,  1191,  1563,  1564,     0,     0,  2097,   905,
     904,  1197,     0,   997,  1000,     0,  1156,  1761,  1089,  1091,
    1002,  1082,     0,  1983,   991,  1109,  1109,     0,  1109,     0,
    1074,  1082,  1077,  1081,     0,   922,     0,  2065,  2093,  2072,
    2128,  2069,     0,     0,  2118,  2114,  2111,  2119,  2120,  2113,
    2101,  1279,  1280,  1281,  1278,  1291,  1277,     0,  2044,  1282,
    2085,  2050,     0,  2060,  2059,  2058,  2360,  2361,  2172,  1996,
    2015,     0,     0,     0,     0,     0,     0,  2151,  2144,  2146,
    2148,  2108,  2107,  2103,     0,     0,     0,     0,  2230,  2231,
    2229,     0,  2226,  2228,     0,  2128,     0,     0,  2295,  2289,
    2298,  1577,  2290,  2287,  2286,     0,   616,   125,     0,     0,
       0,     0,     0,     0,  1626,  1674,  1474,  1484,  1482,  1483,
    1476,  1477,  1478,  1479,  1480,  1481,     0,   813,  1475,     0,
     125,     0,     0,     0,     0,     0,     0,     0,     0,  1715,
     125,     0,     0,     0,     0,     0,   926,   929,   907,   987,
       0,  1564,     0,     0,   641,     0,   650,   642,   647,     0,
     644,     0,     0,   652,     0,   643,   645,   646,   651,     0,
       0,   648,   649,     0,     0,   918,   378,     0,     0,     0,
       0,     0,   125,   974,     0,   336,   335,   125,   334,   333,
    1626,  1674,     0,   744,   125,     0,   172,   487,   462,     0,
       0,   548,  1715,   125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,  2013,     0,  2005,  2173,  2435,  2433,
    2131,     0,  1036,  1686,     0,   288,     0,     0,  1686,   965,
       0,  1686,     0,  1686,   165,  1569,  1626,  1674,  1686,     0,
       0,  1686,   157,  1686,     0,  1686,   288,  1686,   463,     0,
    1686,     0,  1686,  1715,   159,     0,  1686,   288,   614,     0,
       0,  2365,  2369,     0,  2367,  2362,  2087,  2141,  2140,  2037,
       0,  2445,     0,   669,   678,   677,   675,   674,   670,  1598,
    1599,     0,   663,   664,  2151,  2451,   662,   686,     0,     0,
     693,   692,   691,     0,     0,     0,   694,     0,  1195,  1039,
       0,   917,     0,     0,     0,     0,   830,   830,   830,   913,
     227,   225,     0,     0,     0,     0,     0,     0,   919,     0,
       0,     0,  1837,  1838,  1839,  1539,     0,  2291,  1840,  1841,
    1404,  1391,  1400,  1405,  1392,  1394,  1401,  1842,  1843,  1661,
    1844,  1845,  1590,  1846,  1847,  1234,  1849,  1850,  1851,  1396,
    1398,  1852,  1853,     0,  1591,  1855,  1856,  1738,  1858,  1859,
    1861,  1862,  1402,  1864,  1865,  1866,  1867,  1868,  1869,  1589,
       0,  1403,  1870,  1872,  1873,  1874,  1875,  1876,  1877,  1878,
    2349,  1583,  1485,  2348,     0,     0,  1562,     0,  1379,     0,
    1226,  1227,  1249,  1250,  1228,  1255,  1256,  1268,  1229,     0,
    1561,  1293,  1378,  1383,     0,  1377,  1373,  1096,  1557,  1540,
       0,  1374,  1579,  1593,  1592,  2343,  1548,  1582,  1580,  1581,
       0,     0,     0,   190,     0,     0,  2219,   237,     0,   238,
    1565,  1786,   180,   220,   192,   219,   193,   222,   223,   191,
       0,  1624,   181,     0,   188,     0,     0,     0,     0,     0,
       0,     0,   231,   908,     0,  1193,     0,     0,  1546,  1568,
    1192,   623,     0,     0,  1198,     0,   999,   996,  1553,  1552,
    1554,     0,  1090,     0,     0,     0,  1072,  1071,  1002,  1107,
    1108,     0,     0,     0,     0,     0,     0,     0,     0,  1149,
    1130,  1146,  1150,     0,  1078,  1157,  1982,  2128,  2129,     0,
    2123,     0,  2122,  2122,  2116,  2115,  2112,     0,     0,     0,
       0,     0,     0,     0,  2041,   443,  2043,   441,     0,     0,
    2017,     0,  2021,  2019,  2151,  2167,  2151,  2168,  2169,     0,
    2174,  2175,     0,  2152,  2356,     0,     0,  2158,     0,  2147,
    2153,  2155,  2157,  2156,  2165,  2161,  2164,  2166,  2109,  2122,
    2237,     0,  2232,  2235,     0,  2227,     0,  1578,     0,     0,
       0,     0,     0,   617,     0,     0,     0,   124,   963,   230,
     961,     0,     0,     0,     0,   968,     0,     0,     0,     0,
     777,     0,     0,     0,     0,     0,     0,   778,   776,   779,
     786,   799,   802,     0,   713,   163,   164,     0,     0,   855,
     855,     0,     0,   855,     0,     0,     0,     0,     0,     0,
       0,   247,   250,     0,     0,     0,     0,     0,     0,     0,
     127,   154,     0,     0,     0,   428,   440,     0,     0,     0,
       0,     0,   437,     0,   125,   248,   422,   425,     0,     0,
       0,   496,   495,   855,     0,   246,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   127,   156,
       0,     0,   249,     0,  2051,     0,   924,   925,     0,   928,
       0,   983,     0,     0,     0,     0,     0,     0,  1626,  1674,
       0,     0,     0,     0,     0,     0,   324,   307,   308,   125,
     306,     0,     0,   545,     0,  1237,  1266,  1244,  1266,  1266,
    1233,  1233,  1246,  1235,  1273,     0,  1266,  1233,  1238,     0,
    1236,  1276,  1276,  1261,     0,  1218,  1219,  1220,  1221,  1247,
    1248,  1222,  1253,  1254,  1223,  1290,  2296,  1233,  2297,  2294,
    2293,     0,   940,   973,     0,     0,   127,   582,     0,     0,
     546,     0,   127,     0,   168,     0,   491,     0,     0,     0,
       0,     0,     0,   507,   506,     0,     0,   547,     0,   127,
     424,     0,   414,   378,     0,     0,  1632,     0,  1575,     0,
       0,  2011,  2006,  2009,     0,  1999,  2013,  1064,  1066,  1065,
       0,  1063,     0,  1206,     0,   288,   286,   287,   543,   822,
       0,     0,     0,     0,   288,     0,     0,  1686,     0,  1686,
       0,     0,   288,   288,     0,     0,     0,     0,   492,     0,
     613,   611,   610,   612,     0,     0,     0,     0,     0,  1686,
     288,     0,     0,   601,  2363,     0,     0,  2366,     0,  2090,
    1495,     0,  2448,  1021,  2449,   337,     0,     0,  1003,  1010,
    1005,  1007,  1006,  1008,  1004,  1009,   655,   660,   661,     0,
    2450,  2335,  2341,     0,     0,   379,   381,     0,  1647,     0,
    1679,  1703,  1779,  1783,     0,  1804,     0,   695,   718,   690,
       0,     0,  1033,  1026,     0,     0,  1049,   657,  1014,  1497,
       0,     0,     0,   829,   826,   825,   824,   226,   198,     0,
       0,     0,   720,  1778,   916,     0,     0,  1381,  1382,  1265,
    1252,  1538,     0,     0,  1260,  1259,     0,     0,     0,     0,
    1242,  1241,  1240,  1380,  1505,     0,  1239,     0,     0,     0,
       0,  1266,  1266,  1264,  1312,     0,  1243,     0,     0,  1518,
       0,  1524,     0,     0,     0,  1272,     0,  1270,     0,     0,
    1348,     0,     0,     0,     0,     0,     0,     0,  1296,  1297,
    2292,  1379,  1495,     0,  1586,     0,     0,  1258,     0,  1290,
       0,     0,     0,     0,  1551,  1493,     0,     0,  1326,  1491,
       0,  1328,     0,     0,     0,  1485,  1484,  1482,  1483,  1476,
    1477,  1478,  1479,  1480,  1481,  1489,  1309,     0,  1560,     0,
    1308,  2151,     0,  1159,  1095,  1541,     0,  1584,     0,  2342,
    2344,  1375,  2216,  2215,  2214,  2213,  2184,     0,  2178,  2179,
       0,  2217,  2218,   239,   240,   236,     0,     0,   195,   194,
       0,   217,   218,   187,   216,     0,   212,   213,  1443,  1442,
     196,   186,   184,   209,   211,   210,   208,   182,   199,   201,
     202,   203,   185,   183,   234,   232,     0,     0,     0,  1543,
    1542,  1574,  1547,     0,     0,   288,  2122,  1199,     0,  1159,
    1051,  1053,  1054,     0,  1548,   988,  1556,     0,  1092,     0,
       0,   992,  1088,  1087,  1116,  1117,   737,  1086,  1140,  1141,
    1135,     0,  1155,  1155,  1132,  1123,  1131,  1124,     0,  1136,
    1293,  1148,  1076,  1129,  1075,     0,  1151,  1149,  1130,     0,
    2130,  2128,  2068,  1218,  2122,  2061,  2122,  2117,  2047,  1284,
    1285,  1286,  1287,  1288,  1289,  2048,     0,  2045,  1283,  2046,
     442,     0,     0,     0,  2014,     0,  1995,  2020,  2182,     0,
    2183,     0,     0,  2159,  2162,  2160,  2163,     0,     0,  1218,
    2338,  2233,  2338,  1218,     0,     0,     0,     0,     0,     0,
       0,   618,     0,     0,     0,  1804,   229,   959,     0,     0,
       0,     0,     0,   971,   372,     0,   285,     0,     0,     0,
       0,     0,     0,     0,   784,     0,     0,     0,     0,   785,
     782,   783,  1779,   801,   800,   798,   759,   761,   760,     0,
     763,   747,     0,   748,     0,     0,   758,   766,   764,     0,
       0,   854,   260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   278,     0,     0,     0,     0,   283,
       0,     0,     0,   282,     0,     0,     0,     0,     0,     0,
     814,     0,   153,     0,     0,   427,   439,     0,   431,   432,
     429,   433,   434,     0,     0,     0,     0,     0,     0,   426,
       0,     0,   489,   488,   494,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   498,   499,
       0,   500,     0,   155,     0,     0,     0,     0,     0,     0,
     207,   923,   927,   986,   985,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   310,     0,   568,  2293,   544,     0,
    1218,     0,  1214,  1210,  1279,  1278,  1277,     0,  1224,  1233,
    1230,     0,   938,   347,   453,   161,     0,     0,     0,   556,
     559,     0,   123,   172,   337,     0,   171,   173,   175,   176,
     177,   174,   178,   486,   490,     0,   461,     0,     0,     0,
       0,     0,   511,   510,   513,   512,     0,   508,     0,     0,
       0,   152,   421,   423,  1990,     0,   339,   403,     0,   444,
       0,     0,     0,     0,     0,  1992,     0,  2012,     0,     0,
       0,     0,  1062,     0,  1169,  1035,  1160,  1171,  1162,  1164,
    1200,  1567,     0,     0,  1033,     0,   805,     0,   966,  1686,
     288,     0,   803,   166,  1570,     0,     0,     0,     0,     0,
     807,   598,   158,     0,   288,   288,   464,     0,   288,   160,
       0,     0,     0,   456,   288,   615,  2364,  2370,  2368,  1023,
       0,  2446,  2447,     0,  1061,   659,     0,     0,  2340,     0,
     687,     0,   377,   701,     0,     0,   700,   711,   702,   703,
     697,   696,   704,     0,     0,   720,  1028,     0,  1029,  1548,
       0,  1025,     0,  1046,     0,  1044,     0,  1196,  1048,  1037,
    1015,     0,  1013,  1018,  1020,  1019,  1017,     0,     0,     0,
     684,     0,     0,   288,   915,     0,  1501,     0,  1502,     0,
       0,     0,  1537,  1533,     0,     0,     0,     0,     0,  1509,
    1510,  1511,  1508,  1512,  1507,     0,     0,  1513,  1506,     0,
       0,     0,     0,     0,  1263,  1262,     0,     0,     0,     0,
       0,     0,     0,  1351,  1383,     0,     0,  1469,     0,  1495,
    1523,     0,     0,  1274,     0,     0,     0,     0,     0,     0,
       0,  1495,  1529,     0,     0,     0,  1441,     0,  1438,     0,
       0,     0,     0,  1548,     0,     0,     0,     0,  1587,  1294,
    1310,  1559,     0,  1550,     0,     0,  1317,     0,  1530,  1344,
       0,  1349,  1332,     0,  1325,     0,  1330,  1334,  1313,  1551,
    1494,     0,  1492,     0,     0,  1311,     0,  1306,  1304,  1305,
    1298,  1299,  1300,  1301,  1302,  1303,  1307,  1473,  1471,  1472,
       0,     0,     0,  1329,  2259,  1680,  1711,     0,  1106,  1106,
    1094,  1104,  1558,     0,  1202,     0,     0,     0,     0,  1454,
       0,  2346,  2345,  1549,     0,     0,     0,  1566,     0,     0,
    1290,     0,   233,  1194,  1544,     0,   621,   622,   620,  1218,
    1058,     0,     0,  1206,     0,  1057,   990,   989,  1555,  1001,
    1093,     0,   735,   736,     0,   740,     0,     0,  1133,  1147,
       0,  1049,  1049,     0,     0,     0,  1138,  1139,  1126,  1080,
    1079,  2066,  2124,  2071,  2092,  2062,  2095,  1292,  2042,  2084,
       0,  2016,  2185,  2186,     0,  2176,  2177,  2149,  2154,  2223,
       0,  2339,     0,     0,   566,   565,     0,     0,     0,   866,
     832,   619,   867,   833,   960,     0,   962,     0,     0,     0,
       0,     0,   288,   969,   868,   284,   970,   859,     0,     0,
       0,   469,   470,     0,   780,   781,   869,   834,     0,   860,
     762,  1233,   746,     0,     0,   757,     0,   756,  1233,  1233,
     835,   162,   252,     0,   857,   264,   277,   272,   273,   271,
     288,   288,     0,     0,     0,     0,   274,   269,   270,   266,
     279,   280,   843,     0,   294,   297,   281,   262,   265,   263,
     251,     0,  1573,     0,     0,   809,     0,     0,   846,     0,
       0,   136,   138,   140,     0,     0,   134,   142,   137,   139,
     141,   135,   143,   133,     0,     0,   132,     0,     0,     0,
       0,   126,   874,   839,   430,   435,   841,   438,   862,   436,
    1604,  1662,  1787,     0,   476,   478,     0,   483,   880,   840,
       0,   861,   876,   848,     0,     0,     0,     0,     0,     0,
       0,   975,     0,     0,     0,   875,   853,   864,     0,   847,
     842,   863,     0,     0,   205,   204,   206,     0,     0,     0,
       0,     0,     0,     0,     0,   654,   630,   653,     0,     0,
       0,     0,     0,     0,     0,   624,   323,   304,   305,     0,
     303,   567,     0,     0,     0,  1215,  1211,     0,     0,     0,
       0,     0,     0,  1231,     0,     0,   958,   958,   958,   958,
     958,   958,   958,   939,   967,   452,   472,     0,   587,   555,
       0,     0,   378,   167,     0,     0,     0,   460,   554,   552,
     551,   553,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,     0,     0,   338,   340,   342,   343,   344,     0,
     415,   417,     0,     0,   407,     0,     0,     0,     0,   726,
     751,     0,   769,   752,     0,     0,     0,   789,   794,   790,
     772,     0,  2010,  2004,  1067,  1068,     0,  1082,     0,  1171,
       0,  1170,  1182,     0,     0,  1188,  1186,     0,  1188,     0,
    1188,     0,  1163,     0,  1165,  1182,  1568,     0,     0,  1203,
    1034,   288,     0,     0,   466,   288,     0,   288,     0,   288,
     288,     0,   900,   493,     0,   540,     0,     0,   288,   600,
    1496,     0,     0,  2150,  2336,   688,   380,     0,   699,     0,
       0,   710,   705,   707,     0,   714,     0,     0,  1031,  1032,
    1047,  1040,  1042,  1041,     0,     0,  1038,  1498,   599,     0,
       0,   288,     0,   715,  1111,  1499,  1500,     0,     0,     0,
       0,  1534,     0,     0,  1417,  1393,  1395,  1232,  1407,     0,
    1245,  1418,  1419,  1397,  1399,     0,  1486,     0,     0,  1408,
    1353,  1354,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1366,  1365,  1409,  1468,     0,
       0,  1521,  1522,  1410,  1275,  1276,  1276,     0,     0,  1528,
       0,     0,     0,  1415,  1420,     0,     0,  1425,     0,  1446,
       0,     0,     0,  1376,  1496,  1267,  1268,     0,     0,     0,
       0,     0,     0,     0,     0,  1350,  1333,  1327,     0,  1331,
    1335,     0,     0,     0,     0,  1319,  1345,  1315,     0,     0,
    1321,     0,  1346,  1106,  1106,  1106,  1106,  1103,     0,     0,
    1158,     0,  1143,     0,     0,     0,  1454,     0,  1384,  1454,
       0,  2198,  2200,  2201,  2202,  2203,  2204,  2206,  2207,  2209,
    2210,  2211,  2199,  2205,  2208,  2212,  2189,  2190,     0,  2180,
    2181,   189,     0,   214,   200,     0,  2223,     0,     0,  1052,
    1033,  1055,  1118,     0,  1487,   740,   738,   739,  1120,     0,
       0,  1154,  1153,  1152,  1121,  1125,  1122,     0,     0,  2126,
    2052,     0,     0,  2222,  2225,  2236,  2234,  2064,   865,   831,
     858,   958,     0,   371,     0,     0,     0,   972,   451,     0,
     450,   448,   468,   774,     0,  1233,   749,   754,   755,     0,
     347,     0,     0,   253,     0,   261,   258,   275,   267,   276,
     268,   291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   871,   148,     0,     0,     0,     0,
     129,   128,   149,   147,     0,   146,     0,   480,   481,   479,
     475,     0,   482,   484,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   870,   836,   625,     0,
       0,   626,   634,     0,     0,   627,     0,     0,     0,     0,
       0,     0,   636,   326,   311,   315,   974,   974,     0,   316,
     974,   312,   974,   309,   569,     0,  1738,  1476,  1477,   563,
     570,   560,   562,   561,   564,   535,     0,     0,     0,  1216,
       0,  2436,  2444,  2443,     0,  1290,     0,   958,   957,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   358,
       0,     0,   352,     0,     0,   794,   346,   349,   350,     0,
     465,     0,   557,   558,     0,   337,     0,     0,   515,   509,
       0,   571,   549,     0,  1209,   472,  1024,   420,   339,   364,
     399,     0,   413,     0,   401,   400,   402,     0,   409,   936,
     453,     0,   726,     0,     0,   750,     0,     0,     0,   787,
     791,   788,     0,     0,   765,     0,   773,   743,     0,  2027,
    1060,  2036,  1173,  1180,     0,  1161,     0,  1187,  1183,     0,
    1184,     0,     0,  1185,     0,     0,  1180,     0,     0,     0,
     806,     0,   288,   804,     0,   594,     0,   596,   808,   288,
     288,   501,     0,   457,   414,  1066,   698,   712,   708,     0,
       0,   681,   717,  1027,  1030,  1045,  1043,   720,     0,   682,
     719,  1503,  1251,     0,  1536,  1532,     0,  1504,     0,  1516,
    1515,  1352,  1517,     0,  1371,     0,     0,  1363,  1361,  1362,
    1355,  1356,  1357,  1358,  1359,  1360,  1364,  1526,  1525,  1519,
    1520,  1271,  1269,     0,  1412,  1413,  1414,  1527,  1421,     0,
    1440,  1439,     0,     0,     0,  1427,     0,     0,  1436,     0,
    1470,  1257,  1290,  1295,     0,     0,  1318,  1531,  1336,     0,
       0,     0,  1314,     0,     0,     0,     0,  1323,  1486,     0,
       0,     0,     0,     0,     0,  1098,  1097,  1201,     0,  1145,
    1454,  1454,  1454,  1390,  1457,  1452,  1453,  1385,  1585,     0,
       0,     0,     0,  1545,  2221,     0,  1059,  1050,     0,  1119,
    1134,  1127,  1135,  2070,     0,  2125,  2187,  2188,     0,   373,
       0,     0,   794,   879,   449,   775,     0,   767,   345,     0,
     856,     0,     0,     0,     0,   295,   296,   299,     0,     0,
       0,     0,     0,   588,   574,     0,     0,   589,   590,     0,
       0,   811,   812,   810,   144,   130,   151,   150,   131,   145,
     477,   844,     0,     0,     0,     0,     0,   878,   852,   877,
     850,   849,   851,   845,   503,     0,   628,     0,     0,   629,
     640,   638,   637,   639,   631,   327,   125,     0,     0,     0,
       0,     0,     0,     0,   537,     0,     0,   542,   531,   533,
       0,     0,     0,  1212,     0,     0,     0,     0,     0,     0,
    1217,  1225,   530,     0,   949,   948,   947,   951,   950,   953,
     952,   944,   943,   956,   955,   942,   941,   946,   945,     0,
       0,   356,   360,   361,   359,   351,   794,   378,   411,     0,
       0,     0,     0,     0,   517,     0,   550,     0,  1208,   497,
    1022,     0,  1991,     0,   362,     0,   403,   341,   416,   417,
       0,     0,   412,     0,   931,   455,     0,     0,   725,     0,
     753,   770,   771,     0,     0,   794,   793,   895,   896,   893,
     894,     0,     0,  2000,  1172,     0,     0,  1174,     0,     0,
    1176,  1178,     0,     0,     0,     0,     0,  1571,  1454,  1204,
    1205,   288,   467,   288,   288,   901,   541,     0,     0,     0,
       0,   706,   288,     0,  1535,  1406,  1416,  1514,     0,     0,
    1372,     0,     0,  1411,  1871,     0,     0,  1444,  1445,  1426,
       0,  1724,  1431,     0,     0,     0,  1588,  1342,  1340,  1337,
       0,  1338,     0,     0,  1320,  1316,     0,  1322,  1347,  1102,
    1101,  1100,  1099,     0,     0,  1448,  1388,  1389,  1386,  1459,
    1456,     0,  2191,     0,  2194,  2192,  2193,  2197,  1290,  1056,
       0,     0,  2127,   964,     0,   794,   411,   768,   254,   255,
     256,   257,   290,     0,   872,   837,     0,     0,   580,     0,
       0,     0,     0,   873,   838,     0,     0,     0,   980,     0,
       0,   632,   633,   310,     0,   313,   318,     0,   319,   314,
     317,   539,   538,   536,   532,   534,  1213,     0,   820,   820,
    2437,  2438,  2439,  2440,  2441,  2442,     0,   535,   954,     0,
       0,   348,   411,   385,     0,   353,     0,   473,     0,   936,
     339,   472,   516,     0,     0,   572,   418,     0,   403,     0,
       0,   363,     0,   407,     0,   404,     0,   408,     0,     0,
       0,     0,   445,     0,     0,     0,     0,   727,   734,   734,
     792,     0,   796,     0,   764,   741,     0,  2026,  2030,     0,
    1181,  1190,     0,  1177,  1175,  1166,     0,  1168,   821,   595,
     597,   502,     0,   709,   716,   288,  1367,     0,     0,     0,
       0,  1422,     0,  1423,  1428,  1432,     0,  1429,  1430,  1339,
    1343,  1341,  1324,  1142,  1144,     0,  1083,     0,  1115,  1454,
    2196,  2195,   215,  1488,     0,     0,   411,   374,     0,   259,
     298,     0,     0,   586,   575,     0,     0,   591,     0,     0,
       0,     0,     0,   635,   302,   325,   320,   820,     0,   817,
     816,   529,     0,   355,   354,     0,   390,     0,   471,     0,
     584,   932,   485,   518,   519,   514,     0,   419,   407,   368,
     366,   370,   367,   365,   369,     0,   409,   405,   406,     0,
     933,     0,   454,   982,     0,     0,   293,     0,     0,   732,
     737,   737,   795,     0,     0,  1202,     0,  2028,  1179,     0,
    1167,   683,  1368,     0,  1369,     0,     0,  1434,  1433,  1447,
    1449,     0,     0,  1462,  1114,  1387,  1128,   378,   375,   289,
       0,   578,   585,   576,   586,     0,     0,   976,     0,   977,
     978,   981,   815,   819,   818,     0,   382,   383,   384,     0,
     357,   386,   387,     0,   474,     0,     0,     0,   409,   398,
     329,   934,   935,   293,   734,     0,   409,   728,   733,   740,
     740,   794,   797,     0,  2031,  2033,  2032,     0,  1189,  1370,
    1437,  1424,  1435,     0,     0,  1458,     0,     0,     0,   385,
       0,   577,   593,   592,     0,     0,     0,     0,     0,   388,
       0,   389,   410,   583,     0,   522,   330,   409,   737,   292,
    1202,   730,   729,   742,   899,  2029,  1450,  1451,     0,     0,
       0,  1460,  1463,  1461,  1455,   390,     0,   979,     0,   395,
       0,   394,     0,   392,   391,   573,   527,     0,   520,   523,
     528,   526,   524,   525,  1202,   740,   721,   898,   897,     0,
       0,  1467,  1466,  1465,   535,   579,     0,   393,   397,   396,
     504,     0,   722,   731,   881,   892,  1993,   882,   890,   887,
     889,   888,   886,     0,   376,     0,   521,     0,   891,   885,
    1082,  1069,  1464,     0,   883,   892,   522,   884,     0,   505
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   245,   246,  1588,  2252,  2821,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1618,   256,   257,  1215,
    1764,  2356,   258,  2176,  1011,  2057,  2058,  2301,  2059,  2043,
    1454,  2060,  1589,  1610,   260,   261,  1448,  2035,   262,   263,
     264,  1631,  1632,  1595,  1808,  3999,  2243,  4126,  2783,  2784,
     265,   266,  2889,  1709,  2890,  3333,   841,  2323,  3656,  3657,
     267,  1761,  2943,  2944,  2945,  2946,  2914,  3376,  3377,  3378,
    2947,  3724,  3921,  2948,  2184,  1310,  1874,  1875,  4026,  4110,
    4111,  4112,  4193,  3726,  2954,  3408,  3732,  3905,  1781,  2387,
    2949,  2950,  3722,   268,   269,  2382,  1656,  1657,  2257,  3339,
     270,   869,  3240,  2915,  2916,  3932,   271,   829,   272,  1768,
     273,   274,   275,   276,  3380,  3906,  1661,  2833,  2834,  2835,
    2836,  3292,   277,  1766,  1662,  2365,   278,   279,   280,  2290,
     281,   282,   283,  1775,  2376,  2377,  3715,  3913,  4035,  4197,
    4198,  3897,  3667,  3668,  3669,   284,   285,   286,   287,  1760,
    2348,  2349,  3340,  1579,  1713,  2325,  2326,  3390,   288,  3613,
    3614,   870,  4116,  4093,   289,   290,  3617,  3618,   291,   292,
     293,   294,   295,   918,  1277,  1278,  2759,   296,  2075,   297,
    1194,  2876,   298,   940,   941,   299,   300,   950,  2500,   952,
    1886,  3031,  3032,  3471,  2466,  1130,   301,   302,  2475,  2503,
     303,   871,  3414,  3936,  3937,  4060,  2675,  3208,   304,   872,
    1614,  2212,  2394,  2961,  2962,  2214,  2215,  3423,  2216,  2963,
    2968,  2969,  2970,  3419,  3427,  3942,  3943,   305,  1612,  2205,
     306,   307,   308,  1636,  1146,   309,  4019,   310,  1247,   311,
     970,  1904,   312,  2223,  3254,   313,   314,  4226,  4237,  4238,
    4239,  3751,  4209,   315,  4228,   317,   318,   319,   832,  1166,
    1167,  1168,   320,  3734,   321,   322,  2342,  2913,  3359,   323,
     324,  2177,  2726,   325,   326,   327,  1754,   328,   329,   330,
     331,  1691,   332,   333,   334,   836,  1034,  1487,  1495,   335,
    1858,   926,   336,  1324,  2492,   337,  1291,  4229,  1892,  2477,
    2478,  2481,  4230,  1803,   340,  1896,  2486,  2489,  4231,  2079,
    2080,  2081,  2082,  2083,  2661,   342,  1241,  2401,  4232,  1408,
     345,   346,   347,   348,  1038,  1039,  2013,  2630,   959,  1501,
     996,  1049,  1050,  2094,  2095,  2113,  2114,  2105,  2677,  2107,
    2108,  2688,  2100,  3559,  3825,  2111,  2112,  1511,  1512,  2681,
     349,  2634,  2405,  2406,  2407,  2981,  2991,  3438,  3760,  2408,
    1319,  1032,  2409,  3162,  2414,  2935,  2936,  2217,  2333,  1735,
    1409,  1736,  2340,  1410,  1936,  1738,  1411,  1412,  1413,  1741,
    1414,  1415,  1416,  1417,  1920,  1977,  1418,  1419,  1955,  1078,
    1079,  1850,  2542,  1421,  1422,  3528,  3804,  3795,  2567,  2568,
    2050,  3524,  3986,  4079,  4080,  3567,  3565,  3829,  3988,  4148,
    4181,  4182,  1423,  2620,  2005,  1148,  1424,  3342,  2007,  2562,
    2165,  1918,  2509,  2525,  2526,  2539,  3078,  2546,  2551,  3101,
    3102,  2563,  2589,  1425,  2512,  2513,  3062,  1922,  1426,  1478,
    1479,  2021,  2585,  1490,  1491,  1036,  1427,  1428,  1429,  1887,
    1023,  3756,  1255,   683,  2791,  2070,  1170,   956,  1430,  1431,
    1432,   661,  1535,   662,   663,  1118,   787,  1024,     2,    75,
     352,  2940,   353,  2971,   354,   355,   874,   875,   876,  1233,
    1234,  1792,  1795,  1540,  2146,   664,   665,   884,  3753,  3947,
    4067,   924,   356,   357,   358,   359,  1536,  2142,  1080,    76,
      84,    77,  1081,   395,   396,  2124,   360,   804,  2125,  1517,
    1060,  3219,   362,   363,   364,   365,   366,   921,   367,  1062,
     368,  1063,   369,   370,   371,   372,  1070,   373,  1519,  1520,
    3585,  1521,   374,   375,   685,   686,  1289,   376,   377,  1098,
    1099,  1100,  1305,  1869,  1559,  1560,  1561,   378,   679,   379,
     380,   381,  1550,  1551,   382,  2028,  2029,  2149,  2030,   383,
    2702,  2703,   384,  3186,  3187,  3835,  3188,   385,  2024,   386,
     387,  1027,  3224,   388,   800,   389,  1112,   666,   667,   668,
    1120,   790,   983,  1025,  1121,  2837,   792,   793,   670,   671,
     672,  1870,    78,  2710,  1871,  1433,  1434,  2019,  1435,  1436,
    1437,  1438,  1439,  1567,   676,  1088,  1281,  1282,  2711,  1284,
      82,  1285,   393,  3354,  1853,  1306
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3832
static const int yypact[] =
{
   -3832,   763,  7003, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, 19133, -3832,
   -3832, -3832, -3832, -3832, 83490,   795, -3832, -3832, -3832, 45318,
   -3832, -3832, -3832,   664, 56176, -3832, 63712,   846, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, 69835, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, 48628,  1371, -3832,
     400, -3832, -3832, -3832, -3832, -3832, -3832, -3832,   352,  9185,
   -3832, -3832, 60415, -3832,    -7, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, 64183,   682, -3832,   595,   961,    57, 10570, -3832,
   -3832, 46264, 58531, -3832, -3832, 70306,   905,    79,  9869,   352,
   18659, 64654, -3832,  1226, -3832, 42916, -3832, -3832, -3832, 56647,
   -3832, -3832, -3832, -3832,   952, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, 69835,   355,   875, 43400, -3832, -3832, -3832,
   -3832, 69835, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, 65125, -3832,  1128,   746, 70777, 71248, 55705, -3832,
    1014, -3832, 69835,   648, 48156, -3832, 71719, -3832, -3832,  1052,
   -3832, 59002, -3832, -3832, -3832, -3832,   875, -3832, 48628, 40992,
   59002,  1268,  1021, -3832, -3832, 72190, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832,  1635,  1029, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832,   682, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832,   695, -3832,    13,   711,  1079,  1051,
   -3832, -3832, -3832, -3832,  9378, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, 84891,  1791, -3832, -3832, -3832,  1097, -3832,  1118,
   -3832, -3832, -3832,  2012, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832,  1041, -3832, -3832, -3832,  1569, 83957, -3832, -3832, 65596,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   45791, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832,   106, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, 69835, 69835,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, 65596,  1303, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,   200,  1449, -3832, -3832,
   48628,  1675,  1675,  1769, 84891, -3832, -3832, -3832, 49572, 69835,
   69835, 69835,  1636, 49572, 69835, 60886, 37607, -3832, 69835, 69835,
   60886, 69835, 59002, 69835,  1427, 69835, 69835, 72661, 60886,  1568,
   -3832,  1869,  1084, -3832, -3832, -3832, 60886, 10273,   355, -3832,
   -3832, 60886,  1465, 49572, 69835,  1414,  1505, 69835, -3832, 69835,
    1759,   -73, 69835,  1584, 38095,  1589, 69835, 69835, 69835, 69835,
   -3832, -3832,  1567, 69835, -3832, 69835, -3832, 73132,  1356,  1631,
    1840,  1753,   542, -3832, -3832,  1534,  1491, -3832, -3832,  1945,
   65596, -3832, 61357, -3832, -3832, -3832,    84, -3832, 59002, -3832,
   -3832, -3832, -3832, 50044, 69835,  1822, -3832, 73603, -3832,  1906,
   50516, 74074, -3832, 38583,  1970, 74545, 75016, -3832, -3832, 75487,
   -3832, 75958,  1715, 76429, -3832, 76900, -3832,  1838, 77371, -3832,
   12534, -3832,  1621,  1591,  1648, -3832,   682,   187, -3832,   135,
     -58,   143, -3832, -3832,   -38,   210,   457,   187,  1645,  1645,
   61828, 69835,  1882, -3832, -3832, -3832,   -92,  1658,  1658,  1658,
    1820,  -138, -3832,  1658, 60886, -3832, -3832, -3832, -3832, 59002,
    1004, -3832, -3832,   355,   -13,  2050, 69835, -3832, 69835, -3832,
   60886, 69835, -3832, -3832, -3832,  2067,  1707,  1941, -3832,  1705,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832,  1888,  1905,  1895,
     -22,   355,  1809, -3832, -3832,  1919, 25024,   613, 65596,   355,
   43884, 59473, 81610,   159, 47210,   355, 77842,  1760,  1084,  1931,
   -3832,   617, -3832,  2135,  1784,  2006,   -33,  1084, -3832, -3832,
   35224, -3832,  1418,  1777, -3832, -3832, 59002, 85358, -3832, -3832,
   -3832, 78313,  1921, -3832,  2056, 25517, -3832, 69835,  1775, -3832,
    1783,  1834,  1862, -3832, 60886,   928,   928,  2222,   928,  1431,
    1578, -3832,  2236, -3832,  1021,   352,  1885, -3832, -3832, -3832,
    1900, -3832,  1891,  1904, -3832,   205,  2162, -3832, -3832, -3832,
   -3832,  2003,  2010,  2030,  2035,  1951,  2047,   158, -3832, -3832,
   -3832, -3832,  2283, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
    2385,  2379, 46264, 46264,  2077,    20,    85,   334, -3832, -3832,
   -3832,  2249, -3832, -3832,  2274, 69835,  2119, 69835, -3832, -3832,
   -3832, 78784, -3832, -3832,  1675,  1900,  1418,  2071, -3832,   429,
   -3832, -3832,   470,   526,   640,     1,  2070,  1205,   701,  2096,
    2910,  2073,   235,  2321, 69835, 69835, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,  2074, -3832, -3832,  2075,
    1227,  1213,  7280,  1063,  2670,  1230,   765,  2256,  1225,  2367,
    1538,  3061, 69835,  2080,  2310,   -31, -3832,   -35, -3832,  2143,
    2267,  2272, 49572,  2097, -3832, 69835, -3832, -3832, -3832, 49572,
   -3832,  2282, 39071, -3832, 69835, -3832, -3832, -3832, -3832,  2219,
   69835, -3832, -3832,  2339, 69835, -3832,  1658,   109,  2105,  2477,
   52876, 69835,  2148,  2507,  2151, -3832, -3832,  2148, -3832, -3832,
   69835, 69835,  2110,   747,  2148,  2508,  2510,  2183,  2286,   815,
    1025,    56,  2407,  2148, 60886, 60886, 60886,  2358, 69835, 79255,
   49572, 69835, 66067, -3832,  2117,  1534, -3832, -3832, -3832, -3832,
   -3832,  1105,  2181,  2421,  2071,   217,  2422,  2126,  2424, -3832,
    2167,  2429,  2073,  2430,  2131, -3832, 79726, 80197,  2433,  2074,
   69835,  2434,  2131,  2435,  2319,  2437,   217,  2440, -3832,  1236,
    2441,  2325,  2443,  1467,  2131, 47683,  2444,   112, -3832, 18161,
   12534, -3832, 20625,  1312, -3832, -3832, -3832, -3832, -3832, -3832,
   27982,   483,  2300, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, 69835,  1882,  1882,  1076, -3832, -3832,  2149, 69835, 69835,
   -3832, -3832, -3832, 57118, 69835, 59944, -3832,   469, -3832,   167,
   69835, -3832,  1591, 52876,  2547, 69835,  2436,  2436,  2436, -3832,
   -3832, -3832,  2380, 69835,  2442,  2445, 57118, 69835, -3832, 80668,
    2153,  1531,   459,   347,   464, 27982,  2156,   230,   230,  2159,
   -3832, -3832, -3832,   672,  2163,  2165, -3832,   720,   720,  2320,
    2168,  2169, -3832,   908,  2170, -3832,  1293,   967,  2175,  2176,
    2182,  1628,   230, 27982, -3832,  2188,   720,  2191,  2192,  2193,
    1455,  2194, -3832,  1471,  2195,   226,   397,  2196,  2198, -3832,
    2168, -3832,   392,  2200,  2201,  2202,  2205,  2207,  2208,  2210,
   -3832, -3832, -3832, -3832, 27982, 27982, -3832, 24038, -3832,   355,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832,    35, -3832,   989,
    5659, -3832, -3832,  2351, 27982, -3832, -3832,   118, -3832,  1418,
    1003, -3832, -3832, -3832, -3832,   294, -3832, -3832, -3832, -3832,
    1595,  1595,   134, -3832, 60415, 60415, -3832, -3832,   852,  2209,
   -3832,  1088, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   46737,  2615, -3832,  2244,   -35,   636,  2562, 41464, 41948,  1882,
    1882,  2446, -3832, -3832, 60886, -3832, 27982, 40048, -3832,  1418,
   -3832,    64,  2463, 69835, -3832, 35696, -3832,   682, -3832,  9721,
   -3832,  1540,  1775, 69835, 69835,  2620, -3832, -3832,  1783, -3832,
   -3832,  1079,  1079, 27982,  1079,   111,   -62, 26010, 27982,  2509,
    1478,  2513, -3832,  1431,  1578, -3832, -3832,  1900,  2234,  1435,
   -3832, 54763, 84424, 84424,  2479, -3832, -3832,  1162,    -6,  2346,
    2453,  1645,  1544,   899, -3832, -3832,  2228, -3832,  2560, 60415,
    2293, 46264, -3832, -3832,  2704, -3832,  2704, -3832, -3832,    74,
    2242, -3832,  2259, -3832, -3832,   899,   899, -3832,  2732, -3832,
    2247, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, 84891,
    2251, 69835, -3832,  2252,  2253, -3832, 85358,  1418, 40520,  1316,
    2332,  2334, 48628,  2255,  2343,  2345, 82081, -3832, -3832, -3832,
   -3832,    66,  1151,  2348,   806, -3832, 69835,  2452,   158,  2378,
   -3832,  2352,  2353,  2466,   158,   119, 82552, -3832, -3832, -3832,
   -3832, -3832,  3369, 22111, -3832, -3832, -3832,  2356,  2338,   140,
    2637,  2460,   761,   209,   149, 60886,  2539,  2360,  2362,  2285,
    1577,  2284, -3832,  2344,  2347, 51932,  2455, 39559,  2370, 81610,
   -3832, -3832,  2371,  2373,   158, -3832,  2679,   158,   158,  1409,
    2680,  2377,   145,  1354,  2148,  2284,  1897, -3832,  2302,  2382,
     218, -3832,  2481,   138,  1526,  2284,  2389,  2390, 69835, 69835,
   69835, 69835, 60886,  2392,  2394,  2428, 62299,  2395, -3832, -3832,
    2398,  1565,  2284,  1263, -3832,  1186, -3832, -3832,  1084, -3832,
   69835, -3832, 60886,  2071, 52876,  2502,  2073,   158, 69835, 69835,
    2074,   819,  1254,  2503, 69835,  2567,  2366, -3832, -3832,  2148,
   -3832, 40520,  2110, -3832,  2326, -3832,  2381, -3832,  2381,  2381,
    2330,  2330,  2335, -3832, -3832,  1628,  2381,  2330, -3832, 53820,
   -3832,  1292,  1384, -3832,  2731,  2734, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832,  1174, -3832,  1532, -3832, -3832,
   -3832,  2748, -3832, -3832, 52876, 69835, -3832,  2666,  2406, 48628,
   -3832,  2387, -3832, 69835,   629,   355,  2391, 69835,  2570, 69835,
   69835, 69835, 69835, -3832, -3832,  1170,     6, -3832, 62299, -3832,
    1897,  2750,   481,  1658, 47210,  2639, 69835,  2534, -3832,  2355,
    2755, -3832, -3832,  2359,  1645, -3832,  2117, -3832,  1499, -3832,
    2482, -3832, 31419,  2411, 49572,   217, -3832, -3832, -3832, -3832,
   52876, 69835, 81139, 49572,   217, 69835, 69835,  2654,  2431,  2667,
    2439, 39559,   217,   174, 69835, 69835, 60886, 69835, -3832, 69835,
   -3832, -3832, -3832, -3832, 69835, 60886, 69835, 62299,  2674,  2675,
     217, 69835, 69835, -3832, -3832, 20544,  1447, -3832, 12534, -3832,
    9721,  1548,  1882, -3832,  1303,  1015, 69835, 65596, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,  1882, -3832, -3832,  2862,
    2383, -3832,   294, 69835,  1563, -3832, -3832,  1585, 69835,   395,
   49572, 69835, 69835, 60886, 60886, 69835,  2462,  2209,   946, -3832,
    2448, 34752,  2519, -3832,   752, 59002,  2582, -3832, -3832, -3832,
    1606,   446,  -120, -3832, -3832, -3832, -3832, -3832, -3832, 59944,
   56647,  2678,    59, 69835, -3832, 27982, 24531, -3832, -3832, -3832,
    2397,  9721,  2449, 27982, -3832, -3832, 27982,  1645,  1645, 27982,
   -3832, -3832, -3832, -3832,  2401,  1645, -3832, 27982, 27982,  1645,
    1645,  2381,  2381, -3832,  9571, 27982, -3832, 39559, 27982, 29461,
   21617, 27982,  2472,  2426,  1645, -3832,  1645, -3832, 27982, 23545,
   -3832, 27982,  2616, 27982,   636,  2617, 27982,   636,  2831,  2831,
    1021,  1607,  4770,  2405, -3832,  2520,  1645, -3832,  1645,  1360,
   52876, 27982, 48628,  2489,   108, 27982,  2414,  1484, -3832, 27982,
     650, -3832,  2415, 27982,  2494,   186, 27982, 27982, 27982, 27982,
   27982, 27982, 27982, 27982, 27982, -3832, 29954,   248, -3832,   655,
     314, 57589, 25024,  2693, -3832,   379, 21123, -3832, 65596, -3832,
   -3832,  1418, -3832, -3832, -3832, -3832, -3832,    74,  2416, -3832,
    2438, -3832, -3832, -3832, -3832, -3832, 60886,  2615, -3832, -3832,
    2496, -3832, -3832, -3832, -3832,  1123, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832,  2425, -3832, -3832,
   -3832, -3832, -3832,  2425, -3832, -3832,  1882,  2417,  4169, -3832,
   -3832, -3832, -3832,  2698,  2699,   217, 84891, -3832, 69835,   150,
   -3832, -3832, -3832,  2450, -3832, 58060, -3832, 25517, -3832,  1640,
    2168, -3832,  2671, -3832,  2459, -3832,  7841,  2671, -3832, -3832,
      73,  2611,  2618,  2618, -3832,   406,  9721,  2663,  1735,  9721,
    1739, -3832, -3832, -3832, -3832,   641, -3832,  2509,  1478,  1630,
   -3832,  1900, -3832, -3832, 19605, -3832, 20079, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,  2467, -3832, -3832, -3832,
   -3832,   158,  2468,  2904, -3832, 46264, -3832, -3832, -3832,  1945,
   -3832,  1945,  2929, -3832, -3832, -3832, -3832, 65596,  1345, -3832,
   12534, -3832, 12534, -3832,  2469,  1644,  2522,  2523,  2577, 69835,
   69835, -3832, 48628, 69835, 69835, 69835, -3832,  2804,  2464, 69835,
    2710,  2711,  2473, -3832, -3832, 69835, -3832,  2668, 69835, 27982,
    2669, 69835,  1119,  2672, -3832,   590, 69835, 69835,  2660, -3832,
   -3832, -3832, 47210, -3832, -3832, -3832,  2659, -3832, -3832, 53820,
   -3832, -3832,  1653, -3832, 53348, 50988, -3832, -3832,   854, 69835,
   69835, -3832, -3832, 69835, 69835, 69835, 69835, 62770, 69835, 69835,
     988,  1094, 69835, 63241, -3832, 60886, 69835, 69835, 48628, -3832,
   69835,  2684,   558, -3832,  2400, 69835, 69835,  2478,  1654,  2565,
   -3832, 69835,  7727, 69835, 69835, -3832, -3832,   158, -3832, -3832,
   -3832, -3832, -3832, 69835, 69835,   158, 69835,   158,    95, -3832,
   49100, 69835, -3832, -3832, -3832, 69835, 69835, 69835, 69835, 69835,
    1095,   897,  2626,  2628,  2642, 69835, 69835, 69835, -3832, -3832,
    2619, -3832, 69835,  7727, 69835, 69835,  2585,  2589,   114,  2661,
   -3832, -3832, -3832, -3832, -3832,  2756,  2911, 69835,  2758,  2759,
    2578,  2579,  2765,   993, 69835, 69835, 69835, 69835, 69835, 69835,
    2766,   993,  2706,    -3, -3832,  1672, -3832,  2538, -3832, 27982,
    2926, 52876,  2529,  2532,  2609, -3832,  2612,  1645, -3832,  1579,
   -3832,  1170,  1865, -3832,   -24,  7727,  2820, 69835,  1676, -3832,
    2548, 60886,  7727, -3832,  1787, 56647, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832,  2822, -3832,   355,  2110,  2110,
    2110,  2110, -3832, -3832, -3832, -3832,  1552, -3832,  2541, 69835,
    2651,  7727, -3832,  1897,  2837, 60886, 55234,  1790,  2941,  2821,
     355,  2726, 60886, 22591,  3231, -3832, 66067, -3832,  2554,  2829,
    2832,  2838, -3832, 30940, 66538,  2566,  2258, -3832, 66538, 67009,
   -3832,  1418,  2563, 26503,  2519,  2071, -3832,  2964, -3832,  2867,
     217,  2073, -3832,  2131, -3832, 69835, 69835, 69835, 69835,  2074,
   -3832, -3832,  2131,  2751,   217,   217, -3832,  2752,   217,  2131,
    2687,  2868, 47210, -3832,   112, -3832, -3832, -3832, -3832, -3832,
   27982, -3832, -3832,  2662, -3832, -3832, 65596,  1945, -3832,  1677,
   -3832, 69835, -3832,  2131,  2631, 69835,  2574, -3832,  2131,  2131,
    2209,  2209,  2131, 67480,  2991,  2872, -3832,  1684, -3832, -3832,
   25024, -3832,    50, -3832,   610,   731,  2809, -3832, -3832, -3832,
   -3832, 52876, -3832, -3832, -3832, -3832, -3832, 69835,   179,  2779,
    2598, 67480,  2985,   217, -3832,  1688, -3832,  1489, -3832,  1554,
   27982, 27982,    34, -3832,  8207,  1696,  2602,  2603,  1709, -3832,
   -3832, -3832, -3832, -3832, -3832,  2604,  2888, -3832, -3832,  2606,
    1718,  1723,  2607,  2608, -3832, -3832,  4221,  2613,  8252,  2621,
   29461, 29461,   567, -3832, -3832, 29461,  2622, -3832,  1724,  8134,
    2614,  2625,  2635, -3832,  2629,  2630,  8715, 26996, 27982, 26996,
   26996,  8659,  2614,  2632,  1768, 48628,  9375,  1773, -3832, 27982,
   48628,  4344, 27982, -3832, 27982, 69835,  2633,  2634, -3832, -3832,
    9571, -3832,  2641, -3832, 29461, 29461,   820, 24038, -3832, -3832,
    2894, -3832, -3832,  1413, -3832,  2627, -3832, -3832,  3627,   126,
   27982,  2414, 27982,  2714, 39559,  4498, 27982,  2505,  2561,  2561,
     171,   171,    70,    70,    70,   686,   314, -3832, -3832, -3832,
    2638,  2194, 27982, -3832,  3103,  1867,  1883, 60886,  4358,  6502,
   -3832, -3832, -3832, 31419,  2676, 27982, 27982, 27982,  2636,  2811,
    1798, -3832, -3832, -3832,  2226,  2929,    74, -3832,  1084,  1645,
    1360, 42432, -3832, -3832, -3832, 27982, -3832, -3832, -3832, -3832,
   -3832,  1802, 35696,  2411, 25517,  1418, -3832, -3832, -3832, -3832,
   -3832, 27982, -3832, -3832,  2595,  1871, 27982,  1735, -3832, -3832,
   60886,  2582,  2582, 27982, 27982, 26010, -3832, -3832,  2935, -3832,
   -3832, -3832, -3832,   708, -3832, -3832, -3832, -3832, -3832, -3832,
    2643, -3832,  2649, -3832,  2673, -3832, -3832, -3832, -3832,   104,
    2652,  2655,  2656,   942, -3832, -3832, 69835, 69835, 69835, -3832,
   -3832, -3832, -3832, -3832, -3832,  2889, -3832, 27982,   101,  2664,
    2677, 69835,   217, -3832, -3832,  9721, -3832, -3832,  2716,  2744,
   69835,  2481, -3832,  2922, -3832, -3832, -3832, -3832,  2861, -3832,
   -3832,  1532, -3832, 50988, 53348, -3832, 53348, -3832,  1532,  1462,
   -3832,  2131, -3832, 52876,    65, -3832, -3832, -3832, -3832, -3832,
     217,   217, 69835, 69835, 69835, 69835, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832,  1805, -3832,  1369, -3832, -3832, -3832, -3832,
   -3832,  1317, -3832,   647, 52876, -3832, 52404, 69835, -3832, 69835,
    2900, -3832, -3832, -3832,  2839,    18, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832,  1238, 69835, -3832,  1645,  2841, 69835,
    2741, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   48628, 48628, 48628,  1806, -3832, -3832,   355, -3832, -3832, -3832,
    2762, -3832, -3832, -3832,  2899,  2903,  2905,  2764,  2767,  2768,
    2769, -3832,  2771,  2773,  2775, -3832, -3832, -3832, 69835, -3832,
   -3832, -3832, 69835, 69835, -3832, -3832, -3832,   993, 52876,  2942,
     993,   993, 69835, 69835,   993, -3832, -3832, -3832,  2943,  2944,
    2945,  2946,  2947,  2949,   993, -3832, -3832, -3832, -3832,   109,
    2864, -3832,    84, 37119,  5257,  2700,  2532,  2707,  1645, 33322,
      41,  2919,  2709, -3832,  1582,  2938,  2725,  2725,  2725,  2725,
    2725,  2725,  2725, -3832,  1603, -3832,  2890,  2782, -3832, -3832,
   48628, 37119,  1658,   629,  2852,  1457,  3051, -3832, -3832, -3832,
   -3832, -3832, 60886,  1170,   355,  1814, -3832, 52876, 69835, 65596,
    1635,  2719, 60886,  2720,  2722, -3832, -3832, -3832, -3832,  1827,
   -3832, 52876,   388,  2908,  2902,  1635, 69835,  2805, 60886,  2786,
   -3832,  1831,    43, -3832,   355, 47210, 51460, -3832,  3388, -3832,
   -3832,  2909, -3832, 69835, -3832, -3832, 34280, 32849,  2258,  2730,
   69835, -3832,  2733, 31419,  2972,  2906, -3832, 31419,  2906,  1349,
    2906,  2975, -3832, 36168, -3832,  2737,  1512, 21123,  2924,  9721,
   -3832,   217, 52876, 69835, -3832,   217,  2799,   217,  2803,   217,
     217, 60886, -3832, -3832, 60886, -3832, 69835, 62299,   217, -3832,
    9721, 60886,  1359, -3832, -3832, -3832, -3832, 69835,  2131, 49572,
   69835,  1027, -3832, -3832,  2925, -3832,  1635, 69835,  1418,  2746,
   -3832, -3832, -3832, -3832,  3046,  3049, -3832, -3832, -3832, 69835,
   57118,   280, 69835, -3832, -3832, -3832, -3832,  2754,  1850,  8311,
   27982, -3832,  3057, 52876, -3832, -3832, -3832, -3832, -3832, 27982,
   -3832, -3832, -3832, -3832, -3832, 27982, -3832, 27982,  3037, -3832,
    3182,  3182, 52876, 29461,  1313,  2191, 29461, 29461, 29461, 29461,
   29461, 29461, 29461, 29461, 29461, 30447,   376, -3832, -3832, 27982,
   27982,  3044,  3037, -3832, -3832,  -119,  -119, 52876,  2757,  2614,
    2761,  2770, 27982, -3832, -3832,  1851, 48628, -3832, 27982,  8178,
    1854,  2814,  9403,  1418,  5373, -3832,  3136,   355, 27982,   844,
    1849, 27982,  1858, 27982,  3052, -3832, -3832, -3832,  2774, -3832,
   -3832, 52876, 27982, 29461, 29461,  4615, -3832,  5048, 27982,  2776,
    6485, 24038, -3832,   875,   875,   875,   875, -3832, 60886, 60886,
    2566, 27982,  3042,  1863,  1866,  5529,  2811, 36640, -3832,   442,
   27489, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,  2778, -3832,  2795, -3832,
   -3832,   -35,  2783, -3832, -3832,  7663,   104,  2796, 69835, -3832,
    2519, -3832, -3832,  2788, -3832,  1871, -3832, -3832, -3832,  5551,
    2968,  2209, -3832, -3832, -3832, -3832, -3832,   111,  1645,  2810,
   -3832,  1945,  2226, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832,  2725,  6007, -3832, 69835, 69835,  1870, -3832, -3832, 69835,
   -3832,  2070, -3832, -3832,  3043,  1528, -3832, -3832, -3832,  2870,
   -3832,   691,  1396, -3832,  2871, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, 48628, 37119, 48628,  2877,  2883,    47,   544,  2884,
    2885,  2791,  2808,  2812, -3832,  2131,   187,   355, 69835, 69835,
   -3832, -3832,  2131, -3832,   355,  2131,   355, -3832, -3832, -3832,
   -3832, 49100, -3832, -3832, 69835,  3097,    29,  1550, 69835, 69835,
   69835, 69835, 69835, 69835, 69835,  2481, -3832, -3832, -3832,  2813,
     993, -3832, -3832,  3055,  3066, -3832,   993,   993,   993,   993,
     993,   993, -3832,   287, -3832, -3832,  2507,  2507,    44, -3832,
    2507, -3832,  2507, -3832, -3832,  2538,  2788,  1645,   899, -3832,
   -3832, -3832, -3832, -3832, -3832,  1201,  1645,  1915,  2825, -3832,
   33801, -3832, -3832, -3832,  1576,  1360, 60886,  2725, -3832,   207,
     120,   667,  1281, 67951, 68422, 68893,  2826, 69835, 29461, -3832,
     903,   580, -3832,  3067, 60886,  2874, -3832, -3832, -3832,  2830,
   -3832, 52876, -3832, -3832,  3228,  1015, 60886,  2869,  3121, -3832,
    1893, -3832, -3832, 69835, -3832,  2890,  1648,  2876, 55234, -3832,
    3093, 55234, -3832, 69835, -3832, -3832, -3832,  3199,  2927,  2879,
     -24,   355,  2786, 69835,  2842, -3832, 50988, 27982, 27982, -3832,
    2836, -3832,  2843,  4849, -3832,  2110, -3832, -3832,   911,  2860,
   -3832, -3832, 66538,  2845, 69835,  2258, 31419, -3832, -3832,  1998,
   -3832, 31419,  3086, -3832, 31419, 69835,  2847, 69835,  1936, 44363,
   -3832,  2848,   217, -3832, 69835, -3832, 69835, -3832, -3832,   217,
     217, -3832,  2966, -3832,  2854,  1499,  2131, -3832, -3832,  3133,
   67480, -3832, -3832, -3832, -3832, -3832, -3832,    59,  3138, -3832,
   -3832, -3832, -3832, 27982,  9721, -3832,  2856,  9721,  6345,  9721,
    3044, -3832,  1629,  3141, -3832,   935,  2873,  1629,  1481,  1481,
     162,   162,    82,    82,    82,  3182,   376,  9721,  9721, -3832,
   -3832, -3832, -3832,  2875, -3832, -3832, -3832,  2614, -3832, 28475,
   -3832, -3832,  2912,  2918,  2878, -3832, 27982, 28968,  2880, 53820,
   -3832, -3832,  1360,  2831, 29461, 29461,  1143, -3832,   480, 27982,
   52876,  1957,  1143,  1892,  1935, 27982, 27982,  9841,   272, 27982,
    6364, 60886, 60886, 60886, 60886, -3832, -3832,  9721,  3268,  3159,
    2811,  2811,  2811, -3832, 83023, -3832, -3832, -3832, -3832, 27982,
    2226,  1437,   355, -3832, -3832,  1021, -3832, -3832, 39559, -3832,
   -3832, -3832,    73, -3832, 12534, -3832, -3832, -3832,   187, -3832,
    1960,  1961,  2874, -3832,  2255, -3832,  2957, -3832,  1603,  3079,
   -3832,  3080,   187, 69835, 52876, -3832, -3832,  2913, 69835, 69835,
    1645,  1645, 52876,  2892, -3832,  1645,  1645,  2893, -3832, 69835,
   69835, -3832, -3832, -3832, -3832, -3832,  2131,  2131, -3832, -3832,
   -3832, -3832, 69835, 69835, 69835, 69835,  3188, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832,  3135, -3832,   993,   993, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832,  2148,  3213,   355,   355,
    3087, 69835,   355,   355, -3832,  1133,  3223, -3832,  3157,   892,
    2914,   638,  3183, -3832,  1795, 33801, 33801, 33801, 33801, 33801,
   -3832, -3832,  3186,   187, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, 27982,
     785,  1629, -3832, -3832, -3832, -3832,  2874,  1658,  2963, 48628,
    2965,  1635,   503, 69835,  3218,  3212, -3832,   355, -3832, -3832,
   -3832,    92, -3832,  2916,  1191,  2915,  1790, -3832, -3832, -3832,
     555, 69835, -3832,  1090, -3832,  3156,  3201,  2920, -3832, 31898,
   -3832,  9721,  9721,   355, 54292,  3388, -3832, -3832, -3832, -3832,
   -3832,  2999, 69835, -3832, -3832, 69835,  1964, -3832, 27982,  2928,
   -3832, -3832, 31419,  1998,  1967, 69835,  1972, 52876,  2811, -3832,
   -3832,   217, -3832,   217,   217, -3832, -3832, 69835, 69835,  3209,
    3101, -3832,   217, 67480,  9721, -3832, -3832, -3832, 29461,  3208,
   -3832,  2930, 52876, -3832,  2932,  1984,  1990, -3832, -3832, -3832,
    6710,  2983,  9721,  3034,  2933,  2936, -3832,   443,   443,   480,
    1994, -3832, 29461, 29461,  1143,  1143, 27982,  1143, -3832, -3832,
   -3832, -3832, -3832, 27982, 27982,  2988, -3832, -3832, -3832,  3105,
   -3832,  7042, -3832,   899, -3832, -3832, -3832, -3832,  1360, -3832,
    2952,  1735, -3832, -3832,  3085,  2874,  2963, -3832, -3832, -3832,
   -3832, -3832,  3005, 37119, -3832, -3832, 32377, 39559, -3832,    47,
    2948,  2950,   544, -3832, -3832,  1070,   868,  2995,  2131,  3242,
     993, -3832, -3832, -3832,   355, -3832, -3832, 69835,  2954, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, 49572,  3357,  3357,
   -3832,  1590,  1590, -3832, -3832, -3832, 60886,  1201, -3832,  7360,
    3149, -3832,  2963,  3177,  3221, -3832,  2004, -3832, 69835,  2879,
   55234,  2890, -3832,  1107,  3112, -3832, -3832,  3297,  1790,  1432,
    1637, -3832, 60886,  2902,  3088, -3832,  3089, -3832,  3338,  3145,
    3343,   355, -3832, 69835, 31898, 27982,  2007, -3832, 69364, 23064,
   -3832, 53348, -3832,  2014, -3832, -3832, 60886, -3832,  2986,  2021,
   -3832,  9721, 69835, -3832, -3832, -3832,  2024, -3832, -3832, -3832,
   -3832, -3832,  1635, -3832, -3832,   280,   520, 29461, 52876,  2029,
   27982, -3832, 27982, -3832, -3832, -3832,   428, -3832, -3832, -3832,
     443,   443,  1143,  2614,  9721, 69835, -3832,  3358,  3150,  2811,
   -3832, -3832, -3832, -3832,  3158, 60886,  2963, -3832, 27982, -3832,
   -3832, 52876,  2073,   380, -3832, 52876, 52876, -3832, 69835, 69835,
   69835, 69835, 69835, -3832,  2864, -3832,  2954,  3357,   915, -3832,
   -3832, -3832,  3264, -3832, -3832,   568,  3162,  3064, -3832, 48628,
    3275, -3832, -3832, -3832, -3832, -3832, 49572, -3832,  2902, -3832,
   -3832, -3832, -3832, -3832, -3832,  2033,  2927, -3832, -3832,  3161,
   -3832,  3163, -3832, -3832,  2036,  7505,  3026, 31898, 69835, -3832,
     671,   671, -3832,  4849, 54292,  2676,   189,  3003, -3832,  2039,
   -3832, -3832,   520,  2043, -3832,  2044,  2049,  3045, -3832,  2987,
   -3832,  3391, 27982,   926, -3832, -3832, -3832,  1658, -3832,  9721,
    2053, -3832, -3832, -3832,  3137,  2054,  2058,  2992,  3038,  2992,
   -3832,  2131, -3832, -3832, -3832,  3305, -3832, -3832, -3832,   147,
   -3832,  3179,  3181, 69835, -3832, 69835,  3401,  3004,  2927, -3832,
   -3832, -3832, -3832,  3026, 69364,  2285,  2927, -3832, -3832,  1871,
    1871,  3388, -3832,  3317, -3832, -3832, -3832, 69835, -3832, -3832,
   -3832, -3832, -3832, 69835,  3006,  2614,    52,    52,  3008,  3177,
   49572, -3832, -3832, -3832, 69835,  3130,   728,   728,  3332, -3832,
    3071, -3832, -3832, -3832,    47, 44841, -3832,  2927,   671, -3832,
    2676, -3832, -3832, -3832,   161, -3832, -3832, -3832,    51,  3140,
     609, -3832, -3832, -3832, -3832,  3162,  2073, -3832,  3310, -3832,
    3429, -3832,   689, -3832, -3832,  2892, -3832,  2063, -3832, -3832,
   -3832, -3832, -3832, -3832,  2676,  1871, -3832, -3832, -3832,  1275,
    3419, -3832, -3832, -3832,  1201, -3832,  3169, -3832, -3832, -3832,
   -3832, 44841, -3832, -3832, -3832,  1558, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832,    51, -3832, 49572, -3832,  1339, -3832, -3832,
    1477,  1862, -3832,  3020, -3832,  1558, 44841, -3832,  2064, -3832
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3832, -3832,  3164, -3832, -1130,  -179, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
    1166, -3832, -3832,  -105,  1392,  2052,   870, -3832, -3832, -3832,
   -3832,  -965,   211,   637, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832,   777,  1278,   762,  1033, -3832, -1605,  -598, -3832,   265,
   -3832, -3832, -3832,   639,  -344, -3832, -3832, -3832, -3832, -3832,
   -1678,  -127,   133, -3832,   131,  1310,   285, -3832,  -163, -3832,
   -3832, -3832, -3832,  -584,   810,  -942, -1292,  1078,  -609,  -644,
    -570,  -568,  -612, -3832, -3483, -3187, -2663, -2817, -3832, -3832,
   -3832,   144, -3832, -1674, -3832, -3832,  1766, -1545, -3832,  -857,
   -3832, -3832,   592,  1357,   142, -3832, -3832,   -45, -3832, -3832,
   -3832, -3832, -3832, -3832, -3270, -3832, -1599, -3832,   259, -2735,
     722, -3832, -3832, -3832,  1788, -3832, -3832, -3832, -3832, -1699,
   -3832, -3832, -1670, -3832,  1214,   623, -3832, -3832, -3832,  -689,
    -663, -3832, -3726,  -110,  -108, -3832, -3832, -3832, -3832, -1181,
   -3832,   643, -2813, -1122, -3832, -3832,   673, -3832, -3832,  -600,
    -293,  1810, -3832,  -526, -3832, -3832, -3832,  -289, -3832, -3832,
   -3832, -3832, -3832, -3832, -1818,  -428, -1091, -3832, -3832, -3832,
   -3832, -2146, -3832,  3389,   427, -1668, -3832,  -164,  -126,  2261,
   -1282, -2428,   107, -3832, -3832, -1838, -3832, -3832, -3832, -2368,
   -1659, -3832,   172,  -360,  -478, -3184, -3321, -3091, -3832, -3832,
   -1236, -3832, -3832, -3832, -1514,  1370, -2169, -3832, -2140,   170,
   -3307,  -997, -2883, -3832, -3260,  -477, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -1246,  -842, -3832, -3633, -3832, -3832, -3832,
   -3832,  1111, -3832,   130, -3832, -3832, -3832, -3832, -3832,  -621,
    -656, -3832, -3832, -3832,   222, -3832, -3832, -3832,  1929, -1138,
    -941,  2576, -1658,  -314, -3832, -3832, -3832, -3832, -2731, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -1230, -3832, -3832, -3832,
   -3832, -3832, -3832,  1514,  3434,  -197, -3832, -3832,  2102, -3832,
   -3832, -3832, -3832, -3832, -3832,  2311,   214,   -40, -3832, -3832,
     569, -2302,   -30, -3832, -3832, -3832, -3832,  -264,   -29, -3832,
     943, -3832, -3832, -1978, -3832,  2322,  1158,   151,   -56,     5,
    -241,  -267,  -206, -3832,  2580,  2122, -3832, -3832,  -198,  1387,
   -3832, -1048, -1044, -3832,   948,  -917,  1503,   937,    42,  -240,
   -3832, -2597,   408, -3832, -3832,  -913,  1506, -3832,  2118,  1525,
   -3832,  1553,   998, -2315,  1234, -2305,   644,  -492,  -125,  -174,
    2640,  2777, -3832, -3416,   976, -3273,   251,  2112, -2002, -1697,
   -3832, -3832, -1321, 12547, -3832, -3832, -3832, 13046, 13502, -3832,
   -3832, 13976, 14058, -3832, -1229,   527, 14097, 11303, -1336, -1712,
   -1459, 12609,  1375,  -691, -1704, -3832, -3832, -3832,  -312,   541,
     -82, -3832, -3832, -3832,  -479, -2580,  -476, -3832, -3832, -3832,
    -480, -3831,  1253, -3832,  -688, -3832, 14645,   995, -3832, -1256,
   -1305, -1827, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -1400,
   -2938,  -694,  1069, -3832, -3832,  1159, -3832, -3832, -3832, -1408,
   -1050, -1953,  1073, -1964, -3832, -1040,  1198,  1667,   206,  -991,
    3195,  1258, 11374,  -132, -2182, -1462, -1100, -3832,  -326, -3832,
      25,  3125,  -160,   141,   105,   117, -2791, -3832, -3832, -3832,
    2388, -3832, -3832, -3832, -3832, -3832,  3053,   712, -3832,  2454,
   -3832,  1285,  1896, -3832, -3832,  1543,  -953,   -41, -3832,  -446,
   -3832,  -151, -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832, -3832, -3832,  2171,   100, -3832,   -53, -3832,
   -3832, -3832, -3832, -3832,  3330,  -302, -3832,  2784,  -300, -3832,
   -3832, -3832, -3832, -3832, -3832, -3832, -3832, -3832,  2180,  1586,
   -3832,  2584, -3832, -3832, -3832,   -54,  2396, -3832, -3832, -3832,
   -1174,  1415,  2610,  -952,  1551, -3832, -3832, -3832, -3832, -3832,
   -3832, -3832, -3832,  1560, -3832, -3832,  1067, -1962,  1561, -3832,
   -3832,   493, -3832, -3832,   152, -3832,   497, -3832,  2279, -3832,
   -3832, -3832,   525, -3832, -3832, -3832,  -585,  9308,   233,   -25,
      31,   191, -3832,  5478,  5646,  -102,  2203,   -32,  7361, 12476,
     175, -3832,  3333,  1571,  1270,  -996,    61,  1853, 11619,   288,
   -1095,     7,    -2, -3832,  2372,  -635, -1158,  2471,  -750, -1807,
   -3832,  3727, -3832, -2454, -3832,  -861
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2298
static const short yytable[] =
{
      80,   885,  1564,  1042,  1513,   944,  1311,  1312,  1514,    79,
    1449,  1316,  1212,  1822,  1515,   791,  1814,  1877,  1900,   873,
    1640,   868,   343,  2444,  2239,   361,   944,    74,  1026,  1689,
    1678,   398,  2330,  2338,  1851,  1583,  1930,  1931,   338,  1456,
    1777,  2448,  2467,   951,   989,  2754,   391,  1021,   339,   341,
    1957,   964,   391,   684,  1911,  1946,  1031,  1096,   791,  3168,
    1057,  1259,  1058,  2274,  2793,  2644,  1577,  1464,  2131,  2133,
    2134,  2072,  1752,  3051,  2755,  2757,  1712,  1756,   830,  2380,
    3210,  1052,   990,   344,  1762,  3426,  2357,   675,  2978,  2508,
    2358,   684,   788,  1779,  2359,  3287,  2360,  3289,  2410,  2213,
    2660,  1562,  3343,  2992,  2994,  2361,  2362,  3035,  3383,  1010,
     877,  2269,  3000,   917,  3579,  3708,  3745,  1852,  1924,  1925,
    2171,  2693,  1805,  2668,  1847,  3719,   791,  1091,  1147,  1787,
    3343,  2665,  1509,  1611,  3223,   788,  1510,  1044,  2440,  1542,
    1543,  1980,  1053,  1943,  2026,  1558,   413,   413,   789,   878,
     673,  1973,   842,  3082,  1776,  1472,    35,  2709,   413,  1975,
    4178,  2713,   831,  3509,    41,  2918,  1147,   840,   889,  2072,
    1283,  4022,  3764,  1983,  3766,  2885,  3360,  3361,  3362,  3363,
    3364,  3365,   957,   350,   397,    37,    38,    39,    40,   350,
     943,   789,  2178,  1337, -1675,   351,    37,    38,    39,    40,
    2378,   351,  1322,   788,  4179,  4179,  2179,  2073,   413,  1045,
    2583,   943,  2887,  3417, -1705,  1147,   413,  1113,  -125,  1304,
    1534,  1164,   350,  3060,  1294,  1101,   945,  2178,  2583,  1806,
    1524,   413,  1296,  3082,   351,    37,    38,    39,    40,  3633,
    3278,  2230,  1980,  3923,  3007,  1237,  3009,   945,  3040,  1041,
    2864,  4207,  3251,  1307,  1706,  3916,  4020,  2260,   786,   789,
     413,    35,   413,  1046,  3610,   350,  2178,  2578,  2129,    41,
    2738,  2221,  1546,  2221,  1983, -1474,  2132,   351,  2180,  2502,
    2179,  1314, -1474,    37,    38,    39,    40,  1686,  2101,   259,
    3687,  1806,   795,  2200,    37,    38,    39,    40,   343,  2497,
     316,   786, -1276, -1276, -1276, -1276, -1266, -1266, -1266, -1266,
    1840,   390,   981,  2180,   338,  1165,  2018,   390,  2098,   981,
    1615,   981,  4156,  2130,   339,   341,  1689,  2102,  2896,  1453,
     391,  1580,  3846,   350,  1806,   795,  1047,  2617,  1952,  1205,
    1700,  1206,  2221,  1085,  2618,   351,  3660,  4210,   980,  2228,
     390,   922,  2180,  1051, -1266,   980,  1953,   980,  1087,   344,
    1581, -1490,  1315,  1442,   391,  2633,  3611,   413, -1490,   786,
    2011,  1553,  2201,  1075, -1722,  2103,  2261,  3684,  2262,  2015,
    1816,  1125,   985,  1128,  4102,  1980,  3917, -1614,  3279,   985,
    3634,   985,  3661,   390,  3049, -1678,  1957,  1806,  1158,  1930,
    1931,  1894,  4242,   795,  2099,  1308,  1946,   413,  4208,  2181,
      37,    38,    39,    40,   805,   890,  2888,  1983,  2740,  1028,
    1075,  1203,  1616, -1266, -1266, -1266, -1266,  1022,  2074,  1687,
    1854,    37,    38,    39,    40,  4038,  1022,  1221,   801,  3041,
     802,  1867,  1868, -1675,  2181,  1048,  3902,  3082,  1102,  3612,
    3606,   806,  3252,  1525,  2312, -1578, -1578, -1578, -1578,  1544,
    2308,   390, -1723, -1705,  -328,  1688,  1333,   350, -1261, -1261,
   -1261, -1261,  3343, -1276, -1276, -1276, -1276,  1807,  1315,   351,
    4180,  4180,  1117,  2181,  1323,  3945,  2511,  1131,  4234,  1924,
    1925,   891,  3956,   892,  1147,  2039,  1084,  1943,   873,  2182,
    3588,   350,  1115,  2379,  1058, -2296, -2296, -2296, -2296,  1707,
    1708,  2231,  2330,   351,  3082,  2584, -1261,  1198,    37,    38,
      39,    40,  2265,  2232,  2267,  2272,  3038,  3418,  1549,  1575,
    1846,  2328,  1976,  3143,  2182, -1237, -1237, -1237, -1237,  1807,
   -1244, -1244, -1244, -1244,  2865,  1092, -2297, -2297, -2297, -2297,
    2302,  1980,  3787,  1759,   244,    58,    58,  2275,  2464,  1816,
      55,   938,   939,  2004,  1895,   259,  2014,  1244,  1987,  1988,
    2676,  2305,  2233,  2182,  1252,  3094,   316,  2027, -1722,  2324,
   -1474,  2459,  1807,  1983,  4157,  3996,  3563,    57,  2147,   877,
    2303,  3082,  1558,  2742,  1617,   390,  2117,  1093,    57,  2899,
    2118,  1587, -2294, -2294, -2294, -2294,  2044,  2072,  2064,  2065,
    2061,  2061,  1842,  2643,  3247,  2204,  3248,    58,  2012,  1991,
    3123,   156,  -125,   938,   939,    58,  3683,  -125,   878,   390,
    3084,   938,   939,  -125,  -125,    56, -1614,    57,  3082,  1890,
      58,  4032,  2619, -1722, -1678,  1807,   938,  1533,  1154,  4133,
    2662,  1087,  3091,  3092,  3093,  3094,  2339,  3196, -1722,  2505,
    2507,  2001,  2002,  2003,  2004,    55, -1490,  1895,  3435,    58,
    2515,    58,  3439,  2518,  1816,   938,   939,  1919,  1127,  1315,
    2452,  2530,  2531,  1952,  3190,    57,  2391,  1847,  2788,    58,
    3313,  3314,   174,   677,  2548,  2550,    57,  3084,  1104,  2410,
    3201,  1953,   803,  3404, -1276,  2564,  1633,  1634, -1266, -1752,
    2721, -1723,  2534,  2535,  1031,  1202, -2293, -2293, -2293, -2293,
    2683,  3308,  4077,  1954,  3311,  3312,  3655, -1266,  3315,  1292,
    3924,  1239,  3267,  4092, -2298,  1304,  4046,   994,  3322,  4129,
    4130,  2194,  3925,    37,    38,    39,    40,  2199, -1883, -1883,
   -1883, -1883,  3704,  3341,  4206,  4061,  4131,  1980,  2599,  1230,
    2640,  3615,  3085,     3,  2744,  1249,  1705,  1293,  3167,  1295,
    2672,  1297,   391,   805, -2298,   788,  2354,  1298,  2048,  2465,
    3470,  3341,  1757,  1758,  4106,  1318,  1591,  2255,  4222,  1983,
    2258,  2259,  1193,  2385,  1919,  2250, -1233, -1233, -1233, -1233,
    1785,  3083,  1999,  2000,  2001,  2002,  2003,  2004,  3042,   399,
     806,    56,    57,  1400,  1554,  2385,    58,  2110,  4212,  2389,
    2049,  3084,  1555,  1556,  1227, -1266,  3424,   213,  1818,  1820,
     995,   789,  1466,    57,  3268,  2482,  1195,  3689,  2269,  1087,
    2309,  2388, -1070,  2745, -1266,  4189,  1693,  4205,  2355,  2673,
     213,  4118,  1318,  1696,  1952,  3887,   221, -1578, -1073,  4218,
     692,  2186,  3426,  3616,  3089,  3090,  3091,  3092,  3093,  3094,
   -1261,  4173,  1953,  2789,  1476, -1276, -1578,  1635,  1477,   221,
    2600,  3888,  1288,   230,  2601,  2238,  3085,  3705,  1592, -1261,
     232,  1980,  2470,  2471,  1956,  3926,  3674,  1452,  3577,  4078,
    4107,  1462,   235,  1668,  1789,   350,  2684, -2296,   678,   350,
     966,  3366,   837,   232, -1070,  3082,  1231,   351,    80,  2602,
      57,   351,  1097,  1983,  1402,   235, -2296,    79,  1984,  2410,
   -1073,  3089,  3090,  3091,  3092,  3093,  3094, -1237,  3193,  3534,
    4168,   786, -1244,   244,  1669,    74,  1446,  4213, -2297,  1147,
    2483, -1233,   943,  1769,   943,  3368,   943,  1087, -1752,   684,
    4108,  1321,   943,  1299,  1300,   851,  1891, -2297,  1999,  2000,
    2001,  2002,  2003,  2004,  3907,   795,  2189,  3269,  2386,  2429,
    3826,  3827,  3828,   967, -1246, -1246, -1246, -1246,   945,  1338,
     945,  2451,   945,  3599,  1770,  1482,  4219,  1443,   945,  3043,
    3910,  1455,  1458,  1459, -2294,  2455,  3270,  2183,  3089,  3090,
    3091,  3092,  3093,  3094,  1116,  3131,  4103,  1499,  2903,  1116,
     853,  1022,  4190, -2294, -1233,  2033,  1022,  2621,  1022,  3997,
    2102,  1593,  1440,   390,  1022,  2222,  1467,   390,  4171,  4172,
    4000,  2603,  1022, -1273, -1273, -1273, -1273,  1022,  1402,  1116,
   -2298,  3086,  3087,  3088,  1986,  3089,  3090,  3091,  3092,  3093,
    3094, -1070,  3343,  1564,  3664,    37,    38,    39,    40,    37,
      38,    39,    40,  2313,  1987,  1988,  3702, -1073,  2103,    37,
      38,    39,    40,  2034,  1537,  4024,  3747,  3900,  1594, -2298,
     675,   675,  3372,  4191,  1022,  1566,  1670,  1441,  3084,  1116,
    2851,  1468,   943,  3044,  1565,  2537,  1116,   981,  2190,  3782,
    1500,   981,  1773,  1553,  4223,  4192,  1333,  3789, -2293,  3790,
     888,  3757,  1557,  3341,  2484,  1991,  3761,  3754,  3373,  3763,
     835,  1774,   350,  1147,  3703,  2226,  2314, -2293,   945,  1992,
    3374,  2485,  3242,   980,   351,    57,  1771,   980,  4104,   413,
   -1883, -1070,  2622,   673,   673,   968,   969,  3748,  1563,   860,
    1022,   861,  1562,  3085,  3646,  1022,  1042, -1073,  3045, -1883,
    3649,  3650,  3651,  3652,  3653,  3654,  1022,   985,  1671,  4088,
    2844,   985,  2191,  3010,  2227,  3005,  2845,  2928,  2929,  2930,
    2931,  3467,  1460, -1070,  3666,  1710, -1070,  -337, -1233,    37,
      38,    39,    40,  2899,   954,  2652,  1071,  1022,  3928, -1073,
    3218, -2298, -1073,  2037,  1980,  1797,  3929,  1929,  3375,   932,
    3576,  3891,  3892,  3893,  3894,  3895,  1022,  2849,  1772,  4009,
    3481,  3738,  1022,   851,  2092,  2093,  1864,  2097,   933,  3246,
    2280,  2281,  2282,  2283,  3994,  2357,  1983,  3791,  3426,  2358,
    1022,  1984,  1860,  2359,  3058,  2360,  2850,  2643,  2543,  1147,
     390,  1893,  1861,  1862,  2361,  2362,  1798,  2159,  1072,  1058,
    2310,  2311,  3773,  1458,  3774,  4146,  2320,    80,    80,  2410,
      80,  1288,  2846,  2410,  2698,   958,    79,    79,   853,    79,
    2085,  2185,  3749,  3001,  4114,  1053,  1053,   344,  1053,  4147,
    2875,  1995,  3109,   838,    74,    74,  3881,    74,  1999,  2000,
    2001,  2002,  2003,  2004,    37,    38,    39,    40,  3462,   130,
     131,  2186,   344,  1073,  4010,  1402,  1074,  2128,  3086,  3087,
    3088,  3132,  3089,  3090,  3091,  3092,  3093,  3094, -1233,  2334,
    1164,  2368,  2369,  2370,  2371,  2372,  1917,  3405,  3750, -1233,
    1799,  1929, -1233,  1582, -1233,  3965,   991,    37,    38,    39,
      40,  2996,  2772,  3930,  3882,  1933,  1973,  1301,  1816, -1235,
   -1235, -1235, -1235,  3664,  1830,  2071,    56,  1986,  1116,  3163,
    3164,    58,   805,  4120,  1658,  1116, -1246,  1320,  3919,  2129,
    2031,  2032,  2315,  1659,  1759,  1960,   796,  1987,  1988,  1800,
    2824,  1072,  2474,   684,   684,  1935,   797,  1974,  2827,  4085,
    2829,  2773,  1971,  2738,  2445,  1831,  2373,  1979,   413,   806,
    1075,    37,    38,    39,    40,  2847,  3920,   860,  2017,   861,
    1022,  1022,  1022,  2316,  1165,   805,  1116,  2899,  2903,  3236,
    1658,  2131,  3665,  3227,  2130, -1273,  1816,  3953,  1991,  2739,
     156,  3691,   788,  2187,  2848,  4166,  1073,   965,  1458,  2335,
     213,  2046,  1992,  4170, -1273,  1458,  1458,    57,  2774,  1797,
    1537,    57,   806,  1017,  1537,  1537,  2412,  3018,  2415,  4033,
    2071,    57,  1801,  3469,  1033,  2144,  1978,  2421,   943,   221,
     391,   391,   943,   943,   798,  3493,   788,  3494,   684,  2293,
    2016,  3871,  3872,  3666,  4204,  4034,  1051,  1051,   789,  1051,
     413,  1076,  1660,    37,    38,    39,    40,  2775,  1035,  1022,
    3465,   174,  2707,   232,   945,  2334,  4008,  3470,   945,   945,
    1043, -1238, -1238, -1238, -1238,  1584,  2298,   391,  1077,   675,
    2140,  1075,  1022,  1642,  2163,  3280,  2299, -1236, -1236, -1236,
   -1236,  1054,  3082,  1075,  1131,  1673,  2136,   788,  1300,  3600,
    1666,  2740,  2154,  2156,  1585,  2985,  2189,  1832,   207,  2300,
    1816,  2260,  1643,  4039,  2148,  3941,   244,  2345,  4224,   191,
    2153,  2155,   350,  2352,  1674,  2317,  1638,  1072,  2072,  1667,
     207,  2986,  1586,  2296,   351,  3134,  2374,  3135,  1061,   979,
    2381,    57,   673,  4040,  1799,  1537,  3441,  2375,  1016,  3834,
       8,  1537,  1675,   789,  1639,  3495,  2988,  3136,   786,   799,
    2649, -2091,  2297,   943,  1995,  3496,   350,   350,   350,   943,
    2643,  1999,  2000,  2001,  2002,  2003,  2004,  1505,   351,   351,
     351,  1506,  1073,  3681,  2336,  2335,  2166,  3265,  2235,  1833,
    1042,  1537,   795,  1800,  1537,  1537,   213,  2350,  2273,   945,
    3245,  1587,   786,  1287,   413,   945,  2590,  2318,  2591,   943,
    4041,  2337,   943,   943,   350,  2167,  3266,  1837,  3490,  2418,
    1022,   350,  1105,  1587,  1505,   221,   351,   350,  2592,  3211,
    2261,   981,  2262,   351,  1106,  1107,  1838,  1103,  3601,   351,
    3082,  1507,  3510,  2168,  1537,   945,  3644,  3191,   945,   945,
     390,   981,   230,  3341,  1108,  2643,    57,  1109,  2990,   232,
    3137,  2487,   943,   786,  4013,  3138,  4030,   980,  2453,  3366,
    2266,   235,  2410,   156,   788,  3084,  1801,  2410,  1224,  1075,
    2410,  3448,  1097,  3367,   981,  1508,  2499,   980,  1507,  1952,
    2224,  1941,  1942,  2229,   390,   390,   390,   795,   945,    57,
    3635,   985,  3149,  2363,  1590,  2240,  1225,  1953,  3478,  3511,
    3512, -1235,  4225,  3368,  2659,  3369,  1058,  3842,  4042,  3636,
     980,   985,  1458,  2498, -1114,  1114,  2593,  1641, -1114,  1954,
     789,  2594,  1508,  2276,  2061,  3602,  2595,  1679,  3603,  1129,
    3085,  4062,   390, -1082,   174,  1156,  1226,  2404,  4043,   390,
    2241,  2242,  1848, -1082,   985,   390,  1849, -1082,  1110,  2397,
    3806,  3023,    56,    57,  1400,  1554,  2137,    58,  1162,  2138,
    2336,  1022,  3805,  1555,  1556,  2825,  3541,  4244,  3139,  1224,
    4245,  1952,   122,    80,  3370,  2496,    80,  3140, -1114,  2543,
    2543,  2238,    79,  3263,  2543,    79,  3517, -1082,  1111,  1953,
     126,  2493,   191,  3108,   350,  3110,  3111,  3386,  3264,  2932,
      74,  2494,  2495,    74,  2933,  4044,   351, -1082,  1022,  2869,
    2581,  1956,  2569,  3084,  1197,  2572,  2878,  2879,  2880,  2881,
    2882,  2883, -1114,  2543,  2543,  3941,  1041,  1677,  1022,  3356,
     786,   207,  2277,  1163,  2933,  3371,   344,  1226,  2022,  2596,
    3372,  1200,  2023,  1476,    56,    57,  1147,  1477,  2597,    58,
    3082, -1082,  1204,  2139,  2903,  1639,  3833,   846,  1201,  1655,
   -1082,  1665,  2527, -1238,   795,  2121,  2122,  2240,  1682,   213,
    2678,  2295,  3590,  3591,  3535,  1219,  3373,  1848,  3085, -1236,
    1213,  2447,  2516,  2517,  3249,  2399,  2400,   788,  3374,  1929,
    2529,  2172,  1402,  3082,  2532,  2533, -2298, -2298,   221,  3089,
    3090,  3091,  3092,  3093,  3094,  1496,  2240,   817, -1070,  2554,
    3384,  2555,  2241,  2242,  1228,  3055,  3204,  3812,  2240,  2450,
    1229,  2588,   390,  1235,  1587,   230,  1208,  3006,  1209,  3008,
    3421,  2576,   232,  2577,  2905,   851,  3082,  1476,  2411, -1578,
    1116,  1477,  1644,   789,   235,  1232,   213,  1064,   413,  1116,
    3596,  2241,  2242,  2238,  -724,  1929,  1916,  2172,   244,  1929,
    3813,  1582,  1022,  2241,  2242,  3938,  3375,  1065,  2086, -1082,
    2087,  1022,  2723,  2650,   391,   221,  2449,  1066,  2450,  4017,
    3056,  1246,  2148,  1689,  3057,   244,  2906,   807,  2410,  1645,
     853,  2460,  2238,  2461,  3675,  3676,  3677,  3678,  3679,  1250,
    2071,  2695,  3680,  2695,  2238,   839,  1929,  2412,  2172,   232,
    3677,  3678,  3679,  2462,  1260,  2461,  1116,   350,   919,  1022,
    1022,   235,   391,  1269,   391,  2670,  3658,  3659,  1275,   351,
    3662,  1022,  3663,  3084,  2490,  1496,  2491,  2686,  2687,  2924,
    1402, -1137, -1137,  3086,  3087,  3088,  1087,  3089,  3090,  3091,
    3092,  3093,  3094,   786,   920,   943,  3992,    58,  2907,  2908,
    2121,  2691,   244,  1646,  1304,  1067,  2785,  1313,  2669,   992,
    1816,  2909,  2715,   675,  2491,  1290,  3084,   788,  1537,  2984,
    3594,  2752,  2795,  2753,  2796,  1309,  1566,   795,    80,  1254,
      80,   945,  1042,  1262,  1325,  1565,   943,    79,  3085,    79,
    2891,  1330,  2892,  1274,  2919,  3025,  2920,  2461,  1647,  1331,
    1648,   350,  3036,  1557,  3037,    74,  3054,    74,  2450,  3084,
    4097,  2268,  4099,   351,  3064,  2910,  2450,  1332,  1068,   860,
    1459,   861,   945,   789,  1333,  3204,   673,  3067,  1334,  2450,
     863,  3085,  1336,   788,  2985,   390,  3071,  1022,  2450,  1563,
     866,  3072,  3098,  2450,  2450,  1335,  1650,  2925,  1339,   350,
    3938,   350,  1463,  3204,  3171,  3810,  1340,  3172,  3173,  1469,
    2986,   351,  1022,   351,  3746,   788,  2952,  2953,  3174,  3175,
    3176,  1465,  3177,  3178,  3085,  2987,  1470,  3179,  3180,  3181,
    1069,  1652,  1471,  3796,  1537,  2988,  3114,  1480,  2450,   789,
    1486,  3117,  1537,  3118,  1537,  1493,  2911,   350,  2912,  3153,
    1494,  3154,   943,  3675,  3676,  3677,  3678,  3679,  2989,   351,
     943,  1022,   943,  3890,  1654,  3155,  3169,  3156,  3170,  1828,
    3197,   789,  3198,  3261,  3290,  3262,  3291,  2412,  1485,   390,
    1843,  2877,  3392,   786,  3393,  3758,    35,   413,   945,  2877,
      37,    38,    39,    40,    41,  3402,   945,  3403,   945,  3415,
    1402,  3416,  1496,  3086,  3087,  3088,  1503,  3089,  3090,  3091,
    3092,  3093,  3094,   350,  3206,  3207,  1042,   795,  3482,  3518,
    2450,  3519,  3525,  3938,  3526,   351,  3537,   390,  2450,   390,
    1497,  3560,  2902,  2450,  3561,  2927,  2450,  2990,  3592,  3878,
    2461,  3671,  3672,  1402,    81,   350,  3086,  3087,  3088,   786,
    3089,  3090,  3091,  3092,  3093,  3094,  1516,   351,  2957,  3182,
    1518,  3716,  2543,  3717,  1522,  2543,  2543,  2543,  2543,  2543,
    2543,  2543,  2543,  2543,  2543,   390,  1619,  1523,  2977,  2984,
    1526,   786,  1620,   795,  2041,  1087,  1402,  3212,  3213,  3086,
    3087,  3088,  1527,  3089,  3090,  3091,  3092,  3093,  3094,  1528,
    3158,  3159,  1045,  1502,  3768,  1504,  3170,  3759,  1905,  1906,
    1458,  1022, -1115,  3214,  3215,   795, -1115,  1855,  1531,  1529,
     392,  1621,  2543,  2543,  1530,  3811,   392,  2491,  3844,  3845,
    2461,  2461,  3950,  3115,  1816,  3955,  1532,  3393,  3120,  1856,
    3957,   390,  3393,    35,  2985,   156,  1538,    37,    38,    39,
      40,    41,  3971,  1539,  3972,  1619,  1046,  3969,  3973,   392,
    2450,  1620,  3979,  1541,  2491,  1724,  3440,  1568,  3443,  1857,
    2986,  1622,  4028,   390,  4029,  4056, -1115,  4057,  1623,  1545,
    1547,  1624,  4063,  3183,  4064,  2987,  1544,  2042,  1823,  4068,
    4169,  1816,  4070,   879,  3393,  2988,  3873,  4074,  1569,  2491,
    1621,  4119,   392,  2036,  4123,  3839,  4057,  4138,  1571,  1816,
     788,  4139,  4140,  2491,  3118,   788,   174,  4141,  2989,  2450,
   -1115,  4150,  4152,  2491,  2491,  1596,  4153,  1022,  2491,  1047,
    1625,  4220,  4249,  4221,  4221,  3184,  2519,  3983,  1578,  1582,
    1613,  1635,  1888,  1672,  1637,  3204,  1980,  1676,  1685,   986,
    1622,  1684,  1690,  1902,  1692,  4016,   986,  1623,   986, -1575,
    1624,  1022,  1971,  1697,  1694,  1912,   789,  1702,  1022,  1704,
     392,   789,  1711,  1714,  1587,  1753,  2588,  1759,  1983,  2411,
    1755,  1765,  1763,  1984,  -169,  1626,  1767,  1778,  1784,  1794,
    1802,  1804,  1809,  1810,  1811,  3152,  1812,  2990,  2520,  1813,
    1815,  1816,  1980,  1821,  1824,  1825,  1826,  1827,  2404,  1625,
    1829,  1834,  1835,  1836,  1841,  1901,  1873,  1903,  1907,  1458,
    1915,  1627,  1909,  1923,  3185,  1910,  1926,  2412,  1537,  1932,
    1927,  2412,  1928,  4073,  1983,   244,  1934,  1937,  1048,  1984,
     350,  2148,  1938,  1939,  3192,   350,   943,  2543,  2009,  1940,
    1628,   213,   351,  2521,  1629,  1945,  2522,   351,  1947,  1948,
    1949,  1950,  1951,  1958,  1626,  1959,  4090,  1961,  1962,  1963,
    4095,  4096,  1964,  1131,  1965,  1966,   786,  1967,  1630,  2036,
     221,   786,   945,  2040,  2066,  2051,  4076,  2076,  2090,  1506,
      55,    56,    57,  2115,  2120,  1075,    58,  2127,  2141,  2143,
    1627,  2145,   938,  1533,   392,  1985,  3840,   230,  2135,  1986,
     795,  1553,  2151,  2152,   232,   795,  2157,  2158,  2160, -2240,
    2162,  2169,  2089,  2170,  2172,  1619,   235,  4094,  2195,  1987,
    1988,  1620,  2173,  1629,  2174,  3903,  4091,  2188,   392,  2193,
    2221,  2196,  2197,  2198,  1989,  2219,  2220,  2225,  2235,  2236,
    2523,  2237,  2238,  2245,  2244,  2249,  2246,  1630,  3396,  2251,
    2253,  1985,  2254,  2256,  2263,  1986,  2264,   244,   390,  2270,
    1621,  2271,  1658,   390,  2287,   788,   788,   788,  2278,  2279,
    1991,  2285,  3281,  2286,  2292,  1987,  1988,  2294,  2350,  2307,
    2319,  2321,  2322,  2329,  1992,  3431,  4145,  1929,  1919,  2331,
    1989,  2332,  1935,  1022,  3293,  2341,   848,  2351,  2416,  2411,
    1660,   873,  3283,  2543,  2543,  2347,  2367,  2422,  2384,  2390,
    1622,  2392,  2393,  2395,  2425,  2430,  2431,  1623,  2396,  2402,
    1624,   789,   789,   789,  2413,  2877,  1991,  2427,  2877,  2877,
    2426,  2524,  2877,  2443,  2441,  2442,  2456,    55,  2428,    57,
    1992,  2473,  2877,  2457,  3397,  2480,  1022,  1710,  2488,  2552,
    1147,  3344,  2476,  2501,  2510,   788,  1994,  3353,  2553,  3409,
    1537,  2511,  1980,  2565,  2570,  2574,  2582,  2575,  2633,  1625,
    1042,  2587,  2604,  2606,  3203,  2653,  2645,  2648,   943,  3344,
    3430,  1046,  2646,  3348,  3351,  2651,  2656,  2657,  1537,  2679,
    2680,  4045,  3391,  2685,  2664,   350,   350,   350,  2700,  2026,
    4083,  2716,  2717,  2725,  4084,   344,   943,   351,   351,   351,
    4215,   789,  1994,  2718,   945,  3551,  3552,  3553,  3554,  2671,
     344,  2727,  3420,  1458,  1626,  2697,  2699,  2714,  2729,  2730,
    2731,   786,   786,   786,  3324,  2733,  2736,  2748,  2794,  2743,
    3473,   344,   945,  2750,  2797,  2852,  1995,  2853,  2404,  1996,
    1997,  1998,  2404,  1999,  2000,  2001,  2002,  2003,  2004,  2787,
    1627,  2854,   879,  2858,  2862,   795,   795,   795,  2863,  2868,
    2867,  2866,  2870,  2871,  3520,  4003,  3325,  2872,  2873,  2874,
    2884,  2886,  2893,  2895,  2898,   350,  1597,  2899,  2900,  1663,
    2917,  2901,  2921,  1629,  2926,  2938,  2939,   351,  2934,  2955,
    3326,   344,  1995,  2958,  2956,  2973, -2298, -2298,  2976,  1999,
    2000,  2001,  2002,  2003,  2004,  2974,  1598,  1664,  2975,  3327,
    2997,   786,  3002,   390,   390,   390,  2983,  3003,  3011,  3014,
    4201,  3016,  3021,  2423,  3029,  3328,  1136,  3034,  3017,  1137,
    1138,  1139,  2432,  1140,  1141,  1142,  1143,  1144,  1145,  3329,
    3027,   788,  2502,  3046,  2439,   795,  3050,  2543,  1315,  3052,
    3065,  3066,  3068,  3069,  3070,  3073,  3074,  3104,  2658,  3133,
    2412,  3076,  1599,  3128,  2450,  2412,  3624, -2152,  2412,  3079,
    3097,  2543,  2543,  3103,  3141,  3532,  4201,  3105,  3106,  3161,
    3113,  3126,  3127,  3148,  3166,  3151,  2463,  3167,  1022,  2468,
    2469,  3217,  1600,  2472,  3220,  4149,  1619,   789,  1022,  3221,
    3225,  4201,  1620,   390,  3226,  1848,  1971,  3222,  3238,  3231,
    2785,  3234,  3607,  3239,  1022,  3204,  3243,  3568,  3244,  1147,
    3276,  3330,   392,  3277,  3235,  3284,   392,  3286,  3295,  3331,
    1124,  3294,  3296,  3298,  3297,  1124,  3299,  3300,  3301,  2411,
    3302,  1621,  3303,  2411,  3304,  3346,  3310,  3316,  3317,  3318,
    3319,  3320,  2544,  3321,  2138,  3347,  3867,  3355,  3357,  3358,
    3381,  3379,  3332,  3385,  3387,  1124,  3398,  1022,  3400,  3407,
    1022,   350,  3401,  3406,  3411,  3413,  3428,  1022,  3432,  3436,
    3434,  3437,  3444,   351,  3447,  1116,  3449,   788,  3454,   788,
    1601,  1622,  3456,  3583,  3475,  3472,  2012,  3476,  1623,  1916,
    3485,  1624,  3100,  3082,  3099,  3514,  1022,   786,  1240,  3515,
    1975,  3344,  2623,  3527,  3558,  1124,   788,  3539,  3516,  1602,
    1537,  3540,  1124,   207,  3548,  3625,  2543,  1603,  3570,  3571,
    3575,  3572,  3628,  1604,  3629,  3578,  3581,  3595,   943,  3621,
    1605,   795,    81,   789,  3584,   789,  3608,  1606,  3597,  3604,
    1625,   943,  3609,  3619,  3620,  1607,  3622,  3632,  2877,  3647,
    3623,  3645,  1734,  1608,  2877,  2877,  2877,  2877,  2877,  2877,
    3648,  3673,   789,  3699,   945,  3706,  3711,  3709,  3713,  2964,
    3425,  3714,  3721,  3725,  3730,  3733,  3743,   945,  3731,  3739,
    3744,  3752,  3755,  3762,  3765,  2140,  3771,  1597,  3353,   390,
    3777,  3778,  3780,  3783,  3785,  1626,  3788,  3686,  3688,  3690,
    3692,  1609,  1299,  1300,  1022,  1022,  3797,   350,  1124,   350,
    3792,  3670,  3798,  3793,   986,  3351,  3799,  1598,   986,   351,
    3803,   351,  3823,  3824,  3685,  3847,  3848,  3849,  3869,  3870,
    3874,  1627,  3859,  3862,  3877,  3883,   350,  3853,  3665,   392,
    3889,  3896,  3904,   786,  3908,   786,  3912,  1124,   351,  3736,
    3886,  3914,  3922,  2412,  3918,  3931,  3933,  3934,  3946,  3962,
    1680,  3963,  2678,  3967,  1629,  3952,  3975,  3968,  3843,  3970,
    3976,  3977,   786,  1599,  3978,  1899,  2412,   795,  3987,   795,
    3995,  2404,  3850,  3985,  3998,  4005,  2404,  4006,  1681,  2404,
    3993,  4011,  4012,  3004,  2461,  4018,  3705,  4025,  4027,  4036,
    4037,  4047,  4048,  1600,  4049,  4050,   795,  3012,  3013,  4051,
    4066,  3015,  4082,  1047,  4105,  4113,  4086,  3019,  2761,  4109,
    4115,  4121,  4125,  4122,  4137,  1597,  2964,  4143,  4142,  4144,
    4092,  2965,  1842,  4155,  4154,   390,  4158,   390,  4160,  4164,
    4174,  4165,  4188,  3564,  1597,  4053,  4184,  4156,  4157,  4216,
    4059,  4059,  4211,  4217,  4233,  1598,  4235,  4246,  1056,  2923,
    2063,  3194,  2790,  3898,   390,  4167,  3253,  3605,  3323,  4014,
    4002,  3723,  3727,  2762,  1598,  3598,  3053,  3901,  3233,  3026,
    4185,  4214,  4161,  4159,  1124,  4194,  2383,  3728,  3410,  2741,
    3630,  1124,  3735,  3288,  2364,  2904,  3389,  4248,  4236,  3885,
    3884,  1131,  1022,  3382,  4195,  3334,  4004,  2346,  4151,  3837,
    3838,  1599,  1750,  4007,  4054,   960,  1889,  3781,  3836,  4127,
    1022,  4098,    80,  4100,  3737,  2756,  3740,  4132,  4227,  4247,
    1599,    79,  1022,  1473,   207,  4031,  2148,   925,  2966,  2666,
    2091,  1600,  1124,  1859,  1604,  3199,  3474,   943,  2412,    74,
    3720,  1605,  3022,   943,  1863,  2088,  3779,  1492,  1639,  3202,
    1600,  2690,  3216,  2689,  3841,  3582,  1607,   943,  2682,  2116,
    4128,  3160,  2663,  3442,  1608,  3856,  3857,  2979,  3954,  3200,
    3860,  3861,  2411,   945,  3718,  2877,  2877,  2411,  2965,   945,
    2411,    81,    81,  3531,    81,  3909,  3875,  3876,  4075,  3521,
    3879,  3880,  1124,   945,  4176,  1242,  1481,  4183,  4177,  3205,
    3146,  3061,  3144,  3353,  3353,  3353,  3353,  3353,  3039,  2632,
    1865,  2972,  1609,  1090,   788,  3429,  2967,  4163,  2701,  1796,
    1899,  4175,  2398,  1059,  2126,  1750,  4059,  2119,  1980,  1576,
    3351,  3351,  3351,  3351,  3351,  1548,  1286,  2692,   943,  2708,
    4117,  2705,  3189,  2706,  3586,  3915,   344,  1124,  1898,  3587,
    2025,  3574,  3832,  3028,  2123,  2458,  4187,  3024,  1082,    83,
    1983,  2412,   207,  2712,  2203,  1984,  1603,  3770,     0,     0,
     789,  3940,  1604,     0,   945,  1124,     0,  2248,     0,  1605,
    1845,   207,     0,     0,     0,  1603,  1639,  1022,  1022,  1022,
    1022,  1604,     0,     0,  1607,  3237,     0,  2404,  1605,     0,
       0,     0,  1608,     0,     0,  1639,  1124,  1124,     0,  1124,
       0,     0,     0,  1607,     0,     0,     0,     0,     0,     0,
       0,  1608,  2008,  2544,  2544,     0,  1124,     0,  2544,     0,
       0,     0,     0,  3255,  3256,     0,  2306,     0,     0,     0,
       0,     0,     0,     0,   350,     0,     0,     0,     0,     0,
    1609,     0,  3142,  1899,  4186,     0,   351,     0,     0,     0,
       0,     0,     0,     0,     0,  2047,     0,  2544,  2544,  1609,
    3991,     0,     0,  2967,  3425,     0,     0,     0,  1124,   392,
     786,  3344,     0,     0,     0,     0,     0, -2298,  3990,     0,
    1537,  1986,     0,     0,     0,     0,  2343,     0,  2877,     0,
       0,     0,  4015,     0,     0,  1124,     0,     0,   943,  1124,
    1124,  1987,  1988,     0,   795,     0,     0,     0,     0,     0,
       0,     0,     0,   392,   392,   392, -2298,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3430,     0,     0,  4243,
       0,     0,     0,     0,   945,  3080,  3081,     0,     0,     0,
    3096,     0,  2417,     0,     0,     0,     0,     0,     0,  4052,
       0,     0,  1991,     0,     0,     0,     0,     0,     0,  1132,
       0,   392,   390,  1150,     0,  1116,  1992,     0,   392,     0,
    1750,     0,  1160,     0,   392,     0,     0,     0,   986,  3129,
    3130,     0,     0,     0,     0,     0,     0,   344,  2411,     0,
       0,     0,     0,     0,     0,     0,     0,  1207,   986,     0,
       0,  1214,     0,     0,  4241,  1750,     0,     0,     0,     0,
       0,     0,  1223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   788,     0,     0,  1750,     0,     0,
    1133,   986,     0,     0,     0,  1152,     0,     0, -2298,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,  1169,     0,     0,  3450,     0,  1196,     0,  3453,     0,
    3455,     0,  3457,  3458,     0,     0,     0,     0,     0,     0,
       0,  3463,     0,     0,     0,     0,     0,  3275,     0,     0,
     789,     0,  1116,     0,     0,     0,  1750,     0,     0,     0,
       0,     0,     0,  3282,     0,     0,     0,  3285,     0,     0,
       0,     0,     0,  2327,  3479,     0,     0,     0,     0,     0,
       0,  4134,  2579,  1116,     0,     0,     0,     0,     0,     0,
       0,  1750,  1022,     0,     0,     0,     0,     0,  1995,     0,
       0,     0,     0,     0,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,     0,     0,     0,  1750,  4135,  1022,     0,
       0,   392,     0,     0,   350,     0,     0,     0,     0,     0,
    1116,     0,     0,     0,     0,     0,   351,     0,     0,  1317,
       0,     0,  1022,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4203,     0,  1328,     0,     0,     0,     0,
     786,     0,  4202,     0,  1124,     0,  1124,     0,     0,     0,
       0,     0,  1750,     0,     0,  1124,     0,     0,     0,     0,
    4199,     0,     0,     0,     0,     0,  1450,     0,     0,     0,
       0,  1022,     0,     0,   795,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,  1475,     0,    81,     0,  4203,
      81,     0,     0,     0,     0,     0,     0,     0,  4202,     0,
    4240,     0,     0,     0,     0,     0,     0,     0,     0,  1498,
    1980,     0,  1116,     0,  4203,     0,  4199,     0,     0,     0,
     344,     0,  1124,  4202,     0,     0,     0,     0,     0,     0,
       0,     0,   390,  1116,  1981,     0,     0,     0,     0,     0,
       0,  4199,  1983,     0,     0,     0,     0,  1984,     0,     0,
       0,     0,     0,     0,     0,  3466,     0,  1124,  1124,     0,
       0,     0,  1980,     0,     0,  1124,     0,     0,  1124,     0,
       0,  1124,     0,     0,     0,     0,  2528,  3477,     0,  1124,
    1124,     0,     0,     0,     0,     0,  1981,  1124,     0,     0,
    1124,  1124,  1124,  1124,  1983,     0,     0,     0,     0,  1984,
    1124,  1124,     0,  1124,     0,  1124,  2544,     0,  1124,  2544,
    2544,  2544,  2544,  2544,  2544,  2544,  2544,  2544,  2544,     0,
       0,     0,  1750,  1124,   392,     0,  1116,  1124,     0,     0,
       0,  1124,     0,     0,     0,  1124,     0,     0,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,     0,  1124,     0,
       0,     0,     0,     0,  1124,     0,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,     0,  2544,  2544,     0,  1985,
       0,     0,     0,  1986,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1980,     0,     0,     0,  1780,
    1782,  1783,     0,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1989,  1981,
       0,  1116,     0,  2897,     0,     0,     0,  1983,   392,     0,
       0,  1985,  1984,     0,     0,  1986,     0,     0,  3492,  1124,
       0,  3497,  3498,  3499,  3500,  3501,  3502,  3503,  3504,  3505,
    3506,  1990,     0,     0,  1991,  1987,  1988,     0,     0,     0,
       0,     0,     0,     0,     0,  3772,     0,     0,  1992,     0,
    1989,  1993,  3775,  3776,     0,     0,   392,     0,   392,     0,
       0,     0,     0,     0,     0, -1805,     0,     0,  1450,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3543,  3544,
       0,     0,     0,  1990,     0,     0,  1991,     0,     0,     0,
       0,  1450,    81,     0,    81,     0,  3626,  3627,     0,     0,
    1992,     0,     0,  1993,   392,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1805,     0,     0,     0,     0,     0,
    1994,  1124,     0,     0, -1805,     0,     0,     0, -1805,  1980,
       0,     0,     0, -1805,  1985,     0,     0, -1805,  1986,     0,
   -1805,  1750, -1805,     0,     0,     0,  1750,  1750,     0,     0,
       0,     0,     0,  1981,     0,     0,     0,     0,  1987,  1988,
       0,  1983,     0,  3047,     0,     0,  1984,     0, -1805,     0,
     392,     0,  1994,  1989,     0,     0,     0,     0,     0,     0,
       0,  2544,     0,     0,     0,     0,     0,     0, -1805,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   392,     0,     0,     0,  1990,     0,     0,  1991,
    1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,  1992,     0,  2654,  1993,     0,     0,  2067,
       0,  2655, -1805,     0,     0,     0,     0,     0,     0,     0,
       0, -1805,     0,     0,     0,     0,  1980,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1124,  1995,  1750,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,  1983,     0,
       0,  3075,     0,  1984, -1805,     0,     0,     0,  1985,     0,
       0,     0,  1986,     0,     0,  1994,     0,     0,     0,     0,
       0,     0,     0,  3701,     0,     0,     0,     0,     0,     0,
       0,     0,  1987,  1988,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1750,     0,  1989,   958,     0,
       0,     0,     0,     0,     0,  1124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1124,     0,  2544,  2544,     0,
   -1805,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,  2291,     0,  1991,  3958,     0,  3959,  3960,     0,     0,
    3545, -1805,     0, -1805, -1805,  3964,     0,  1992,     0,     0,
    2234,     0,  1124,     0,     0,  1995,     0,     0,  1996,  1997,
    1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
       0,  1980,     0,     0,  3121, -2298,     0,     0,     0,  1986,
       0,     0,  1124, -1805,     0,     0, -1805, -1805,     0, -1805,
       0,     0,     0,  1750,     0,  1981,     0,  2284,     0,  1987,
    1988,     0,     0,  1983,     0,  3250,     0,     0,  1984,     0,
       0,     0,  1124,  1124, -2298,     0,     0,  2304,  2353,  1994,
    3865,  3866,     0,  3868,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2291,     0,     0,  3271,     0,  3273,  3807,
    3808,     0,  1124,  1124,     0,     0,     0,  1124,     0,     0,
    1991,     0,     0,     0,     0,     0,     0,     0,     0,  1124,
    1124,  1124,  1124,     0,  1992,     0,     0,   392,     0,     0,
       0,  1124,   392,     0,  1124,     0,  1124,  2964,     0,     0,
       0,     0,     0,     0,     0,     0,  1124,  1124,     0,  1124,
       0,     0,  2291,     0,     0,  1597,     0,     0,     0,     0,
       0,     0,  1124,     0,  1124,     0,     0,     0,  1124,  1995,
    3309,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,     0,     0,  1124,  1598,     0,     0,  4071,     0,
    1985,     0,     0,     0,  1986,  1124, -2298,  1124,  1124,  1124,
       0,     0,     0,  3949,     0,     0,     0,     0,     0,     0,
       0,  2434,     0,  3949,  1987,  1988,     0,  1124,     0,     0,
    2438,     0,     0,     0,     0,     0,  1124,     0,     0,  1989,
       0,  2544,     0,  1124,     0,     0,     0,     0,  1124,  3394,
       0,  1599,     0,     0,     0,  1124,  1124,  1124,     0,     0,
       0,     0,     0,  3250,     0,  2544,  2544,     0,     0,     0,
       0,     0,  1990,     0,     0,  1991,     0,     0,  1450,  1450,
       0,  1600,     0,     0,     0,     0,     0,     0,     0,  1992,
       0,     0,  1993,     0,     0,     0,  1995,     0,     0,  1124,
       0,     0,     0,  1999,  2000,  2001,  2002,  2003,  2004,  2965,
       0,     0,     0,     0,  3451,     0,     0,     0,     0,  1980,
       0,     0,     0,     0,     0,  1750,  1750,     0,  1750,     0,
       0,     0,     0,     0,     0,  1750,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1983,     0,     0,     0,     0,  1984,     0,     0,     0,
       0,  1994,     0,  3966,     0,     0,  1750,     0,  1750,     0,
       0,     0,     0,     0,     0,  3486,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3980,  3981,     0,
       0,     0,     0,     0,  3491,     0,     0,     0,     0,     0,
       0,     0,   392,   392,   392,     0,  2631,     0,     0,     0,
    4069,     0,   207,     0,     0,     0,  1603,     0,     0,  3513,
    2544,     0,  1604,     0,     0,     0,     0,     0,     0,  1605,
       0,  2647,     0,     0,     0,     0,  1639,     0,     0,     0,
    1750,     0,     0,  3546,  1607,     0,     0,     0,     0,     0,
       0,  1995,  1608,  1899,  1996,  1997,  1998,     0,  1999,  2000,
    2001,  2002,  2003,  2004,  3335,  1750,     0,     0,  2573,     0,
    4101,     0,     0,     0,     0,     0,     0,     0, -2298,     0,
    2667,     0,  1986,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   392,  1750,  2719,     0,     0,     0,  2722,     0,
    1609,     0,  1987,  1988,  2967,     0,     0,     0,     0,  1750,
       0,     0,     0,  2734,     0,     0,     0, -2298,     0,     0,
       0,  2746,     0,  1750,     0,     0,     0,     0,  1980,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1750,     0,
       0,     0,  4072,     0,  2760,     0,     0,     0,     0,     0,
       0,     0,  1981,  1991,     0,  1124,     0,     0,     0,  1124,
    1983,  2781,     0,     0,     0,  1984,     0,  1992,     0,  1124,
       0,     0,     0,     0,  1750,     0,  2798,     0,  2822,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2838,     0,     0,     0,
       0,  1124,     0,  2842,     0,     0,     0,     0,     0,     0,
    2855,     0,     0,     0,     0,     0,     0,  2859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2780,     0,  1124,     0,     0,  1750,     0,     0,     0, -2298,
       0,  1124,     0,     0,  1980,     0,     0,  1124,     0,  1124,
       0,     0,     0,     0,  1750,  1124,     0,     0,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1124,  1981,     0,
       0,  1124,  1124,     0,     0,     0,  1983,     0,     0,  1750,
       0,  1984,     0,     0,  1124,     0,     0,  1985,   392,     0,
    1124,  1986,     0,  3710,     0,     0,     0,     0,     0,     0,
    1124,     0,     0,  1124,     0,  1124,     0,     0,     0,     0,
       0,  1987,  1988,  1750,  1124,  1124,  1124,     0,     0,     0,
    1124,     0,     0,  1124,     0,     0,  1989,     0,     0,  1995,
       0,     0,     0,  1124,     0,     0,  1999,  2000,  2001,  2002,
    2003,  2004,  1124,     0,     0,     0,  2922,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,  1991,     0,     0,     0,     0,   669,     0,     0,
       0,     0,   687,     0,   691,     0,  1992,     0,     0,  1993,
    2941,     0,     0,     0,   691,     0,     0,  2959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3033,     0,
    1980,     0,     0,  1985,     0,     0,     0,  1986,     0,     0,
     687,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     691,     0,  1980,     0,  1981,     0,  3033,  1987,  1988,   687,
     691,     0,  1983,   691,   392,  1750,   392,  1984,     0,   691,
       0,     0,  1989,   691,     0,     0,  1981,   953,  1994,     0,
       0,     0,  1899,     0,  1983,     0,     0,     0,     0,  1984,
       0,   955,     0,   392,   691,     0,     0,     0,     0,   962,
       0,     0,     0,     0,     0,  1990,     0,     0,  1991,     0,
     691,     0,     0,     0,   972,     0,   953,     0,     0,     0,
     993,     0,  1992,     0,     0,  1993,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1030,     0,     0,
       0,     0,     0,   691,     0,     0,  3852,     0,     0,     0,
       0,     0,     0,     0,  3858,     0,     0,     0,     0,     0,
    1980,    35,     0,     0,     0,     0,     0,     0,  1995,    41,
    1124,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,  1750,  1981,  3345,     0,  1982,     0,  1985,
       0,     0,  1983,  1986,  1994,     0,     0,  1984,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1985,     0,  1987,  1988,  1986,     0,     0,  1750,  1124,
    1124,     0,     0,     0,     0,     0,     0,     0,  1989,     0,
       0,     0,     0,     0,     0,  1987,  1988,     0,  1124,     0,
       0,     0,     0,  1124,     0,     0,  1124,     0,     0,     0,
    1989,     0,  3157,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,  1991,     0,     0,     0,     0,     0,
       0,  3228,     0,     0,     0,     0,     0,     0,  1992,     0,
       0,  1993,     0,  1990,  1995,  1124,  1991,  1996,  1997,  1998,
       0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,
    1992,  3530,     0,  1993,     0,  1450,     0,   691,     0,  3394,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1985,
       0,  1124,     0,  1986,     0,     0,     0,     0,  1124,  1124,
       0,  1750,     0,     0,  1899,     0,  1124,  1124,     0,     0,
       0,  1124,  1750,  1987,  1988,     0,     0,  1124,  1124,     0,
    1994,  1124,  3274,     0,     0,     0,     0,     0,  1989,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1124,  1994,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,     0,     0,     0,
       0,  1990,     0,     0,  1991,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,     0,  1992,     0,
       0,  1993,     0,     0,  1750,     0,     0,  3306,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,     0,     0,     0,     0,  3562,     0,     0,
       0,     0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,  3580,
    1994,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1124,     0,     0,     0,     0,     0,     0,  1980,     0,
    1899,   392,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1981,     0,     0,     0,     0,     0,   687,     0,
    1983,  1124,     0,  1899,     0,  1984,  1750,  1899,  1899,     0,
       0,     0,     0,     0,     0,     0,     0,  3388,     0,     0,
    1124,     0,     0,     0,  1124,    55,     0,  3399,     0,  1750,
    1995,     0,  2291,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,  3412,     0,  3468,   691,   691,     0,     0,
    1124,     0,     0,     0,  1750,     0,     0,     0,     0,     0,
     691,     0,     0,     0,     0,     0,     0,  3480,     0,     0,
       0,     0,     0,     0,  1124,  1124,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,  1124,  1124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3459,     0,     0,  3460,
       0,     0,     0,     0,     0,     0,  3464,     0,     0,     0,
       0,     0,     0,     0,     0,  1750,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,     0,     0,  1985,     0,     0,
       0,  1986,     0,     0,     0,  1450,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1124,
       0,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1989,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1126,   687,  1126,
       0,     0,   669,     0,  1149,     0,   669,   691,     0,   691,
       0,   691,     0,   691,  1126,   669,  1124,  1124,     0,  1990,
       0,     0,  1991,  1750,  1171,     0,     0,     0,     0,     0,
       0,     0,   691,     0,     0,   687,  1992,  1126,     0,  1993,
     669,     0,  1149,     0,   669,  1216,   691,   691,     0,  1124,
    1750,   691,  1124,  1126,  1124,   669,     0,     0,     0,     0,
       0,     0,     0,  3555,  3556,     0,     0,     0,   691,     0,
     691,     0,     0,     0,  3593,     0,     0,     0,     0,     0,
    1124,     0,   691,  1750,     0,   687,     0,  1750,  1750,   691,
       0,  1149,     0,   691,   691,     0,     0,   691,     0,   691,
       0,   691,     0,   691,     0,     0,  1126,     0,  1994,     0,
       0,   392,     0,     0,     0,     0,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,     0,  1980,     0,   691,   691,
       0,     0,     0,  3637,     0,  3639,     0,     0,     0,  1124,
       0,     0,     0,     0,     0,  1980,  1750,     0,  4136,     0,
    1981,     0,     0,     0,   691,     0,   691,     0,  1983,  1329,
       0,     0,     0,  1984,  1124,     0,     0,     0,     0,  1981,
       0,     0,     0,     0,     0,     0,     0,  1983,     0,     0,
       0,     0,  1984,     0,     0,     0,   691,     0,   687,     0,
       0,     0,  1457,     0,     0,     0,     0,     0,  1995,     0,
       0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,     0,     0,  3589,     0,     0,     0,  1484,
       0,     0,     0,     0,     0,   691,     0,     0,     0,     0,
       0,     0,  1124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3682,     0,     0,     0,     0,  1980,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3707,
     669,   669,     0,     0,     0,  1985,     0,     0,     0,  1986,
       0,  3712,     0,   691,     0,   691,     0,     0,  1983,   691,
       0,     0,     0,  1984,  1985,  3033,     0,     0,  1986,  1987,
    1988,     0,     0,     0,     0,     0,     0,  1124,     0,     0,
       0,     0,  1126,  1126,  1989,     0,     0,     0,  1987,  1988,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1989,     0,     0,     0,     0,     0,     0,
     691,     0,     0,     0,     0,     0,     0,  1990,     0, -1807,
    1991,     0,     0,   691,     0,     0,     0,     0,     0,     0,
    1149,     0,   691,     0,  1992,     0,  1990,  1993,   691,  1991,
       0,     0,  1126,     0,     0,     0,     0,     0,     0,   691,
    3549,     0,     0,  1992,     0,     0,  1993,     0,  1126,  1126,
       0,     0,     0,     0,     0,     0,     0,     0, -1807,     0,
       0,     0,     0,     0,     0,     0,  1126,  1788, -1807,   691,
    1793,     0, -1807,     0,     0, -2298,     0, -1807,     0,  1986,
       0, -1807,     0,     0, -1807,     0, -1807,     0,     0,     0,
       0,     0,     0,  3854,  1126,  1126,  1994,     0,   691,  1987,
    1988,     0,     0,     0,  3863,     0,  3819,  3820,  3821,  3822,
       0,     0, -1807,  1457, -2298,  1994,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1807,     0,     0,     0,     0,     0,     0,   691,
       0,  1980,     0,     0,     0,     0,  1876,  1876,     0,     0,
    1991,     0,   691,   953,     0,     0,     0,     0,   691,     0,
       0,     0,     0,   691,  1992,  1981,     0,     0,     0,     0,
       0,  1908,     0,  1983,     0,   691, -1807,  1914,  1984,     0,
       0,     0,     0,     0,     0, -1807,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,     0,     0,  3786,     0,  1995,  1747,     0,  1996,  1997,
    1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
       0,     0,  3818,     0,     0,     0,     0,     0, -1807,     0,
       0,     0,     0,     0,     0,     0, -2298,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3033,     0,
       0,     0,   958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   687,   687,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1807,     0,     0,     0,  1457,     0,
    1985,     0,     0,     0,  1986,  1457,  1457,     0,     0,     0,
       0,     0,     0,     0,     0, -1807,     0, -1807, -1807,     0,
       0,  2077,     0,  2084,  1987,  1988,  1995,     0,     0,  1747,
       0,   691,   691,  1999,  2000,  2001,  2002,  2003,  2004,  1989,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1807,     0,     0,
   -1807, -1807,     0, -1807,     0,     0,     0,     0,     4,     0,
       0,     0,  1990,     0,     0,  1991,     0,   687,     0,   669,
       0,     0,     0,     0,     0,     0,     0,     0,     5,  1992,
       0,     0,  1993,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     9,    10,     0,   691,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,   691,    35,     0,    36,     0,    37,
      38,    39,    40,    41,     0,     0,     0,     0,     0,     0,
       0,  4021,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1994,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1980,     0,  1149,     0,  1450,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1981,     0,     0,
       0,  4065,     0,     0,     0,  1983,  1126,  1126,  1126,  1126,
    1984,     0,     0,     0,   669,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1788,     0,
       0,     0,     0,     0,     0,     0,  1126,  1126,     0,     0,
       0,     0,  1126,     0,     0,     0,     0,     0,     0,     0,
    4087,  1995,     0,     0,  1996,  1997,  1998,    43,  1999,  2000,
    2001,  2002,  2003,  2004,     0,     0,     0,     0,  3974,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1747,     0,     0,     0,     0,     0,
      45,     0,     0,   691,     0,     0,     0,     0,     0,     0,
       0,   669,     0,     0,     0,   691,     0,  1126,  1126,  1126,
    1126,    46,     0,     0,     0,     0,   669,     0,     0,  2218,
       0,     0,  1457,     0,  1788,     0,     0,     0,     0,     0,
       0,     0,  1985,     0,     0,     0,  1986,     0,     0,     0,
       0,  1747,     0,     0,     0,    47,     0,     0,    48,   687,
     691,     0,     0,   691,   691,     0,  1987,  1988,     0,  1149,
       0,     0,   691,   691,     0,   691,     0,   691,     0,     0,
      49,  1989,   691,     0,   691,   669,     0,     0,     0,  1126,
    1126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   691,   691,     0,     0,     0,     0,
    1747,     0,     0,     0,  1990,     0,     0,  1991,     0,     0,
       0,  1876,     0,     0,     0,     0,   691,  1747,     0,   691,
     691,  1992,     0,   691,  1993,  1619,     0,     0,     0,  2479,
       0,  1620,     0,     0,     0,  1747,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,   953,   953,     0,
       0,  2504,     0,     0,     0,  1644,     0,     0,     0,     0,
    1747,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1621,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    51,     0,     0,  1149,     0,     0,     0,     0,
       0,  1980,     0,  1994,     0,    52,     0,     0,     0,     0,
       0,     0,  1645,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,  1981,  1747,     0,     0,     0,
    1622,     0,     0,  1983,     0,     0,     0,  1623,  1984,     0,
    1624,     0,     0,    54,     0,     0,     0,     0,   794,    55,
      56,    57,     0,     0,     0,    58,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,   691,     0,    65,    66,
      67,    68,     0,    69,    70,    71,    72,    73,     0,     0,
       0,     0,     0,     0,     0,     0,  1646,     0,     0,  1625,
       0,   794,     0,  1995,     0,     0,  1996,  1997,  1998,     0,
    1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,
    3989,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2084,     0,     0,     0,
       0,  1647,     0,  1648,     0,     0,     0,     0,   984,     0,
       0,     0,     0,     0,  1649,   984,  1980,   984,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   794,
    1985,     0,     0,     0,  1986,     0,     0,     0,     0,     0,
    1981,     0,     0,     0,     0,     0,     0,     0,  1983,  1650,
    1627,     0,     0,  1984,  1987,  1988,     0,     0,     0,     0,
       0,     0,     0,   669,     0,     0,  1747,     0,     0,  1989,
       0,     0,     0,     0,     0,   691,     0,     0,     0,  1651,
       0,     0,     0,  1629,  1652,     0,     0,   669,   691,     0,
       0,   669,   687,   691,     0,     0,     0,   691,     0,     0,
       0,     0,  1990,   691,     0,  1991,   669,  1653,     0,   691,
       0,     0,     0,     0,   669,   691,     0,  1654,     0,  1992,
     691,     0,  1993,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   669,   691,     0,
       0,  2763,  2764,   691,   691,   691,   691,  2771,     0,     0,
     691,   691,     0,     0,   669,   691,     0,     0,   691,     0,
       0,     0,     0,  2792,  2792,     0,     0,     0,     0,   669,
       0,   669,   691,     0,  1980,  1985,     0,     0,     0,  1986,
       0,  1126,   691,     0,   691,     0,     0,     0,     0,   669,
       0,  1994,     0,   691,   691,   691,   669,   691,  1981,  1987,
    1988,     0,     0,   669,   691,   691,  1983,     0,     0,     0,
     669,  1984,   691,   691,  1989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1126,     0,     0,     0,     0,
       0,     0,  1126,  1126,  1126,  1126,  1126,  1126,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,     0,
    1991,     0,     0,  2799,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1992,  2792,     0,  1993,     0,     0,
       0,     0,     0,   953,     0,     0,     0,     0,     0,     0,
       0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,
    2001,  2002,  2003,  2004,     0,  2751,     0,  2937,  4023,     0,
    2218,  2758,     0,     0,  2951,     0,  2800,     0,     0,     0,
       0,     0,     0,     0,  1793,  2801,  2802,  2803,     0,     0,
       0,     0,  2982,     0,     0,     0,  2982,  2995,     0,     0,
       0,     0,     0,  1985,     0,     0,  1994,  1986,     0,     0,
       0,     0,     0,  1126,  2792,  1126,  2792,     0,     0,     0,
       0,     0,  1980,     0,     0,     0,     0,  1987,  1988,  2804,
    1457,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1989,     0,   691,     0,  1981,     0,     0,  1876,
    2672,     0,     0,   691,  1983,     0,     0,     0,     0,  1984,
       0,   669,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2805,     0,     0,     0,  1990,  2806,     0,  1991,     0,
       0,     0,     0,     0,     0,   691,     0,  1747,     0,   669,
       0,     0,  1992,     0,     0,  1993,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,     0,     0,  4124,     0,  2807,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2673,
       0,     0,  2808,  2809,  2810,  2811,  2812,     0,  2813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3125,  1994,     0,     0,     0,     0,     0,
       0,  2814,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1985,     0,     0,     0,  1986,     0,     0,     0,     0,
       0,     0,  1149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1987,  1988,  2815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1989,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1457,
       0,     0,     0,  2816,     0,  2817,     0,  1747,     0,     0,
    2084,     0,     0,  1990,  1995,     0,  1991,  1996,  1997,  1998,
       0,  1999,  2000,  2001,  2002,  2003,  2004,     0,  2818,  3573,
    1992,   794,     0,  1993,     0,  2819,     0,     0,  2820,  1122,
       0,     0,     0,     0,  1122,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   669,   691,   691,     0,     0,     0,
       0,     0,     0,     0,  1122,  1980,     0,     0,     0,  1876,
       0,     0,     0,     0,     0,     0,     0,     0,   691,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1981,
       0,     0,  1994,     0,     0,     0,     0,  1983,     0,     0,
       0,     0,  1984,     0,     0,     0,     0,     0,     0,  1980,
     691,   691,   691,   691,  1122,     0,     0,     0,     0,     0,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1981,     0,   669,     0,   691,  1980,     0,
    2674,  1983,     0,     0,     0,     0,  1984,     0,     0,     0,
       0,     0,     0,   691,     0,     0,     0,   691,     0,     0,
       0,     0,  1981,     0,     0,  3063,     0,     0,     0,     0,
    1983,     0,     0,     0,     0,  1984,     0,     0,     0,     0,
       0,     0,  1995,  1980,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,   691,     0,     0,     0,
     669,   691,     0,     0,  3099,     0,     0,  1981,     0,  3100,
    2792,  2792,     0,     0,     0,  1983,     0,  1122,     0,     0,
    1984,     0,     0,   984,  1985,     0,     0,   984,  1986,     0,
       0,     0,     0,     0,     0,     0,     0,  3352,     0,     0,
       0,     0,  1980,     0,     0,     0,     0,     0,  1987,  1988,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,  2218,
    2758,     0,  2758,  1989,     0,     0,  1981,     0,  1985,  1747,
       0,     0,  1986,     0,  1983,     0,   691,   691,     0,  1984,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1987,  1988,   691,     0,  1990,  1985,     0,  1991,
    1747,  1986,  1747,  1457,     0,     0,     0,  1989,     0,     0,
       0,   687,     0,  1992,   691,  2982,  1993,     0,  3433,     0,
       0,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,  3446,     0,     0,     0,     0,  1989,     0,     0,     0,
    1990,   691,  1985,  1991,     0,     0,  1986,     0,     0,     0,
       0,     0,     0,     0,   691,   669,     0,  1992,     0,     0,
    1993,     0,     0,     0,     0,   691,  1987,  1988,   669,  1990,
       0,     0,  1991,     0,  1747,  2479,     0,     0,  3522,     0,
       0,  1989,     0,     0,     0,  1994,  1992,   691,     0,  1993,
     669,     0,     0,  1122,     0,     0,     0,     0,     0,  2758,
    1122,  1985,     0,     0,     0,  1986,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,  1991,     0,     0,
       0,  1748,     0,     0,     0,  1987,  1988,  2758,     0,  1994,
       0,  1992,     0,     0,  1993,     0,     0,     0,     0,     0,
    1989,     0,  3523,  1747,     0,     0,     0,  3077,     0,     0,
       0,  1122,     0,     0,     0,     0,     0,  1747,  1994,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2758,  1990,     0,  1995,  1991,     0,  1996,  1997,
    1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
    1992,     0,     0,  1993,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1994,     0,  3566,     0,     0,  1747,     0,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,  1995,
       0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,     0,     0,     0,     0,  2084,     0,     0,     0,
       0,     0,     0,     0,  1748,     0,     0,     0,  1995,     0,
       0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,  1994,     0,     0,     0,  1122,     0,     0,  1747,
       0,     0,  1876,  1876,     0,     0,     0,   669,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3483,  1747,     0,
    1980,     0,     0,  1995,  1122,     0,  1996,  1997,  1998,     0,
    1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,
       0,     0,     0,  1747,  1981,     0,   691,   691,     0,     0,
       0,     0,  1983,     0,     0,  1122,  1122,  1984,  1122,     0,
       0,     0,   691,     0,     0,     0,   669,   691,   669,   691,
     691,   691,   691,     0,     0,  1122,  1980,  1747,     0,     0,
       0,     0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,     0,
    1981,     0,     0,  3107,     0,     0,     0,     0,  1983,     0,
       0,     0,     0,  1984,     0,     0,     0,     0,  3352,     0,
       0,     0,     0,     0,     0,     0,     0,  1122,   794,     0,
       0,   691,   691,   691,     0,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1122,     0,     0,     0,  1122,  1122,
       0,  2937,     0,     0,  3112,     0,  2763,     0,     0,  2763,
       0,  3729,     0,     0,     0,     0,     0,     0,     0,  1985,
       0,  2792,     0,  1986,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2758,
    2982,     0,   691,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,  2937,     0,  3767,     0,   691,  1989,     0,
       0,     0,  2792,     0,  2792,     0,     0,     0,     0,  1748,
       0,     0,     0,   794,     0,  1985,     0,   984,   669,  1986,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,  1991,     0,     0,   984,     0,  1987,
    1988,     0,     0,     0,  1748,     0,     0,     0,  1992,     0,
       0,  1993,     0,     0,  1989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1748,     0,     0,     0,
     984,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,     0,
    1991,     0,     0,     0,     0,     0,     0,  1747,     0,     0,
       0,     0,     0,     0,  1992,     0,     0,  1993,     0,     0,
       0,     0,  3830,     0,     0,     0,     0,     0,     0,     0,
    1994,     0,     0,     0,     0,  1748,  1149,     0,     0,     0,
       0,     0,  2218,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1748,     0,     0,     0,     0,     0,     0,     0,
       0,  3851,     0,     0,     0,     0,   669,   691,     0,     0,
    1748,     0,     0,     0,     0,     0,     0,   669,   691,     0,
       0,     0,     0,     0,     0,     0,  1994,     0,     0,     0,
     691,   691,  1126,   691,     0,  1748,     0,     0,     0,     0,
     794,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1876,
    1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,  3352,  3352,  3352,  3352,  3352,     0,     0,
       0,     0,     0,  1122,     0,  1122,     0,     0,     0,     0,
       0,  1748,     0,     0,  1122,  1747,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1747,     0,     0,     0,
       0,   691,     0,     0,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,   691,
       0,     0,     0,     0,     0,     0,     0,  3939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3948,     0,     0,   691,     0,     0,     0,     0,     0,     0,
       0,  1122,     0,  3767,     0,     0,     0,     0,     0,     0,
    1747,     0,     0,     0,     0,   691,  3729,     0,  1747,     0,
       0,   669,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   808,     0,     0,  1122,  1122,     0,     0,
       0,     0,     0,     0,  1122,     0,     0,  1122,     0,     0,
    1122,     0,     0,     0,     0,     0,     0,     0,  1122,  1122,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,  1122,
    1122,  1122,  1122,     0,     0,     0,     0,     0,     0,  1122,
    1122,     0,  1122,     0,  1122,     0,     0,  1122,     0,   809,
       0,     0,     0,     0,     0,  1149,     0,     0,     0,     0,
       0,  1748,  1122,   794,     0,     0,  1122,     0,     0,   810,
    1122,     0,     0,     0,  1122,  1876,     0,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,     0,  1122,     0,     0,
     811,     0,     0,  1122,     0,     0,     0,  1122,     0,     0,
       0,    85,     0,     0,     0,     0,  2792,    89,  2763,     0,
    3944,    93,     0,    94,     0,    96,    97,   812,     0,     0,
       0,     0,   813,     0,     0,     0,   106,   814,     0,     0,
       0,  1126,  3939,  1747,     0,     0,  1126,  1126,     0,     0,
       0,     0,   815,   119,   120,     0,     0,     0,     0,     0,
     691,     0,     0,     0,     0,     0,     0,     0,  1747,     0,
       0,     0,     0,     0,     0,     0,  1980,     0,  1122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   128,
       0,     0,     0,  4081,     0,     0,     0,     0,     0,   129,
    1981,   130,   131,  3116,  1980,     0,     0,     0,  1983,     0,
       0,     0,     0,  1984,     0,  1055,  1126,  1126,  1126,  1126,
     691,     0,     0,     0,     0,     0,     0,     0,  1981,  2758,
       0,  3529,     0,     0,   816,   141,  1983,   142,   143,     0,
       0,  1984,   145,   146,     0,   982,     0,     0,     0,     0,
       0,     0,   982,   147,   982,   148,     0,     0,     0,     0,
       0,   817,     0,   794,     0,  3939,  1126,     0,     0,     0,
       0,     0,   151,     0,   152,     0,     0,   155,     0,     0,
    1122,     0,     0,   156,     0,   818,     0,     0,     0,   157,
       0,   819,     0,     0,     0,   158,     0,   820,     0,   821,
    1748,   159,     0,     0,     0,  1748,  1748,   161,     0,   163,
       0,     0,     0,     0,   165,     0,     0,  2758,     0,     0,
       0,   691,     0,  1126,     0,   822,   823,   169,     0,   794,
     824,     0,  1126,     0,     0,  1985,     0,     0,   825,  1986,
       0,     0,     0,   826,  1747,  3948,     0,     0,     0,     0,
       0,  4081,     0,   827,   174,     0,     0,     0,     0,  1987,
    1988,   794,  1126,  1985,     0,   828,     0,  1986,     0,     0,
       0,     0,  1980,  4200,  1989,     0,     0,  1747,     0,   183,
     184,  1747,  1747,     0,     0,   185,     0,  1987,  1988,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,  1989,     0,  1983,     0,     0,  1990,     0,  1984,
    1991,     0,   191,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,  1748,     0,  1992,     0,     0,  1993,     0,  4200,
       0,     0,     0,     0,     0,  1990,     0,     0,  1991,     0,
    3944,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       0,     0,  1992,     0,  4200,  1993,     0,     0,     0,     0,
     204,     0,     0,     0,   205,     0,   206,     0,     0,     0,
       0,   207,     0,     0,     0,     0,   208,     0,     0,   210,
       0,     0,     0,   212,  1748,     0,     0,     0,     0,   213,
       0,     0,     0,     0,  1122,   214,  1994,     0,   216,     0,
       0,     0,     0,     0,  1122,   219,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   221,     0,
       0,     0,  1980,     0,  1994,     0,     0,     0,     0,     0,
       0,  1985,     0,     0,   226,  1986,   227,     0,     0,     0,
       0,  1122,     0,   229,     0,   230,  1981,     0,   231,     0,
       0,     0,   232,     0,  1983,  1987,  1988,     0,     0,  1984,
       0,     0,     0,     0,   235,     0,     0,     0,     0,     0,
    1989,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1748,     0,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,  1122,  1122,  1990,     0,   244,  1991,     0,     0,     0,
       0,     0,     0,     0,  1995,     0,     0,  1996,  1997,  1998,
    1992,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,
       0,  1122,  1122,     0,     0,     0,  1122,     0,     0,     0,
       0,     0,  1980,     0,     0,     0,     0,     0,  1122,  1122,
    1122,  1122,     0,     0,     0,     0,   794,     0,     0,     0,
    1122,   794,     0,  1122,     0,  1122,     0,     0,     0,     0,
       0,     0,     0,     0,  1983,  1122,  1122,     0,  1122,  1984,
       0,  1985,     0,     0,     0,  1986,     0,   893,     0,     0,
       0,  1122,  1994,  1122,     0,     0,     0,  1122,     0,   894,
       0,     0,     0,     0,     0,  1987,  1988,     0,     0,     0,
       0,     0,     0,  1122,     0,     0,     0,     0,     0,   895,
    1989,     0,     0,     0,  1122,     0,  1122,  1122,  1122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   896,     0,     0,  1122,     0,     0,     0,
       0,     0,     0,  1990,     0,  1122,  1991,     0,     0,     0,
       0,     0,  1122,   897,     0,     0,  3816,  1122,     0,     0,
    1992,     0,     0,  1993,  1122,  1122,  1122,     0,     0,     0,
       0,     0,  1995,     0,   898,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,     0,
       0, -2298,     0,     0,     0,  1986,     0,     0,     0,     0,
       0,   899,     0,     0,     0,     0,   900,     0,  1122,     0,
       0,   901,     0,     0,     0,  1987,  1988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   902,     0,     0,     0,
   -2298,     0,  1994,     0,  1748,  1748,  1119,  1748,     0,     0,
       0,  1119,     0,     0,  1748,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1991,     0,     0,     0,
       0,  1119,     0,     0,     0,  1748,     0,  1748,     0,     0,
    1992,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   903,     0,
       0,   794,   794,   794,     0,     0,     0,     0,   904,     0,
       0,  1119,  1995,     0,     0,  1996,  1997,  1998,  1119,  1999,
    2000,  2001,  2002,  2003,  2004,   817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1748,
       0,     0, -2298,     0,     0,     0,     0,     0,     0,   905,
       0,     0,     0,   906,     0,   907,     0,     0,     0,     0,
       0,   908,     0,   909,  1748,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   910,
     911,   794,  1748,     0,   912,     0,     0,     0,     0,     0,
       0,     0,   913,     0,     0,     0,     0,   914,  1748,     0,
       0,     0,     0,     0,  1119,     0,     0,   915,     0,     0,
     982,     0,  1748,     0,   982,     0,     0,     0,     0,   916,
       0,     0,  1995,     0,     0,     0,     0,  1748,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,  1122,     0,     0,     0,  1122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1122,     0,
       0,  1172,     0,  1748,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,  1173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1174,     0,     0,     0,
       0,     0,     0,  1175,     0,     0,     0,  1176,     0,     0,
       0,  1122,     0,     0,  1748,     0,     0,     0,     0,     0,
    1122,     0,     0,     0,     0,     0,  1122,  1177,  1122,     0,
       0,     0,     0,  1748,  1122,     0,     0,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,     0,  1178,     0,
    1122,  1122,     0,     0,     0,     0,     0,     0,  1748,     0,
       0,     0,     0,  1122,     0,     0,     0,   794,     0,  1122,
    1119,     0,     0,     0,     0,     0,     0,  1119,     0,  1122,
    1179,     0,  1122,     0,  1122,     0,     0,     0,     0,     0,
       0,     0,  1748,  1122,  1122,  1122,     0,     0,  1746,  1122,
    1180,     0,  1122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1122,     0,     0,     0,     0,     0,     0,     0,
       0,  1122,     0,     0,  1181,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1182,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   817,
       0,     0,     0,   794,  1748,   794,     0,     0,     0,     0,
       0,  1746,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1183,     0,     0,     0,  1184,     0,  1185,
       0,     0,   794,  1119,     0,  1186,     0,     0,   843,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     844,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,  1187,  1188,     0,     0,     0,  1189,     0,
     845,     0,     0,     0,     0,     0,  1190,     0,     0,     0,
       0,  1191,     0,     0,     0,     0,     0,     0,     0,     0,
     846,     0,  1119,  1119,  -582,  1119,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1122,
       0,     0,  1119,     0,   847,     0,     0,     0,     0,     0,
     848,     0,  1748,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   849,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1748,  1122,  1122,
       0,     0,   850,     0,  1119,     0,     0,  -745,   851,     0,
       0,     0,   852,     0,     0,     0,     0,  1122,     0,     0,
       0,     0,  1122,     0,     0,  1122,     0,  -724,     0,     0,
       0,  1119,     0,     0,     0,  1119,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -447,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   853,  1122,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,     0,     0,     0,  1746,  1122,  1122,   854,
    1748,     0,   855,     0,   982,  1122,  1122,     0,     0,     0,
    1122,  1748,     0,     0,     0,     0,  1122,  1122,     0,     0,
    1122,     0,     0,     0,   982,     0,  -447,     0,     0,     0,
       0,  1746,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     856,     0,     0,  1746,  -745,     0,   857,   982,     0,     0,
       0,     0,     0,     0,   858,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,     0,     0,  1748,     0,     0,     0,     0,     0,     0,
       0,   859,   860,     0,   861,   862,     0,     0,     0,     0,
       0,     0,     0,   863,     0,     0,     0,   864,   865,     0,
       0,     0,  1746,   866,     0,     0,     0,     0,   867,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1746,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,  1746,     0,     0,     0,     0,     0,     0,     0,
     794,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
    1119,     0,  1119,     0,     0,     0,     0,     0,  1746,  1122,
       0,  1119,     0,  1122,     0,     0,     0,     0,  1748,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1122,
       0,     0,     0,  1748,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1122,  1122,     0,     0,  1122,     0,     0,
       0,     0,     0,     0,  1122,  1122,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1748,     0,     0,  1122,     0,     0,
       0,     0,     0,  1119,  1119,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,  1119,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,  1119,  1119,     0,  1122,     0,
       0,     0,     0,  1119,     0,     0,  1119,  1119,  1119,  1119,
       0,     0,     0,     0,     0,     0,  1119,  1119,     0,  1119,
       0,  1119,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1746,  1119,
       0,     0,     0,  1119,     0,  1122,  1122,  1119,     0,     0,
       0,  1119,  1748,     0,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,     0,  1119,     0,     0,     0,     0,     0,
    1119,     0,     0,     0,  1119,     0,     0,     0,  1122,  1748,
       0,  1122,     0,  1122,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1122,
       0,     0,  1748,     0,     0,     0,  1748,  1748,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     794,     0,     0,     0,     0,  1119,     0,  1122,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1122,     0,
       0,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1122,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     690,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1122,     0,     0,     0,     0,   834,  1746,     0,     0,
       0,     0,  1746,  1746,     0,     0,   883,     0,     0,   887,
       0,     0,     0,     0,     0,   883,     0,     0,     0,   942,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     961,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1040,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1746,     0,     0,     0,     0,     0,     0,   674,     0,
       0,  1119,     0,   688,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   688,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     688,   688,     0,  1086,     0,     0,     0,     0,     0,     0,
     688,     0,     0,     0,   674,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,  1119,
       0,   688,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,  1119,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1119,  1119,  1119,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
    1119,     0,  1119,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,  1119,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
    1119,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,  1119,  1119,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,     0,  1119,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,  1119,  1119,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   688,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1094,  1095,     0,     0,     0,     0,     0,     0,
       0,  1746,  1746,     0,  1746,     0,  1086,     0,     0,     0,
       0,  1746,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1746,     0,  1746,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1151,     0,  1153,     0,  1155,     0,  1157,
       0,  1746,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,  1217,  1218,     0,     0,     0,  1220,     0,     0,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,   688,
       0,     0,     0,     0,  1086,     0,   883,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,  1245,     0,
       0,     0,     0,     0,  1746,     0,     0,     0,     0,     0,
    1264,     0,     0,  1266,     0,  1268,     0,  1271,     0,     0,
       0,  1119,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
    1746,   688,     0,     0,  1302,  1303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
    1326,     0,  1327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,  1746,  1086,     0,     0,     0,     0,  1119,     0,     0,
       0,     0,     0,  1119,     0,  1119,     0,     0,     0,     0,
    1746,  1119,     0,     0,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,     0,     0,     0,  1119,  1119,     0,
       0,  1040,     0,     0,     0,  1746,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,  1119,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,  1746,
    1119,  1119,  1119,     0,     0,     0,  1119,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,  1570,
       0,  1572,     0,     0,     0,  1574,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1236,   688,
       0,   688,     0,  1745,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1683,     0,     0,     4,
       0,     0,   688,     0,     0,     0,   674,     0,   674,  1695,
     674,     0,     0,     0,     0,     0,   674,     0,  1701,     5,
       0,     0,     0,     0,  1703,     0,     0,     0,     0,     6,
       7,  1746,     0,     0,     0,  1751,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,  1790,    35,     0,     0,     0,
      37,    38,    39,    40,    41,     0,     0,   688,     0,   688,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,  1897,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   674,   674,     0,     0,  1552,     0,     0,     0,     0,
       0,     0,     0,     0,  1746,  1119,  1119,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,  1119,     0,     0,     0,     0,  1119,
       0,     0,  1119,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,  2045,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,  1119,  1119,     0,  1746,     0,     0,
       0,    49,  1119,  1119,     0,     0,     0,  1119,  1746,     0,
       0,     0,     0,  1119,  1119,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1040,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,  1745,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1746,    50,     0,     0,  1745,     0,     0,     0,
    1746,     0,     0,  1872,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1745,     0,
       0,   688,     0,     0,     0,  2161,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,     0,     0,     0,
    2192,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1745,     0,     0,
       0,     0,     0,     0,    54,     0,     0,  1119,     0,     0,
      55,    56,    57,     0,  1745,     0,    58,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1279,  1745,     0,     0,     0,    71,  1280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,     0,  1746,     0,  2020,     0,     0,  1745,     0,     0,
       0,     0,     0,   688,   688,     0,  1119,     0,     0,     0,
    1119,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,   674,     0,     0,     0,   674,   674,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
    1746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1745,     0,     0,     0,     0,     0,     0,
    1119,  1119,     0,     0,  1119,     0,     0,     0,     0,  2344,
       0,  1119,  1119,     0,     0,     0,     0,     0,     0,     0,
       0,  2366,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   688,     0,
     674,  1746,     0,     0,  1119,     0,     0,     0,  2150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2420,     0,     0,     0,
    2424,     0,     0,     0,     0,  1119,     0,     0,     0,  2433,
       0,  2435,     0,  2436,     0,     0,     0,     0,  2437,     0,
       0,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
    2454,   883,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,  1119,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   674,     0,     0,   674,   674,     0,     0,
       0,     0,     0,     0,     0,  1119,  1746,     0,  1119,     0,
    1119,     0,     0,  1745,  1123,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,  1746,
       0,     0,     0,  1746,  1746,     0,   674,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,  1123,
       0,     0,  1746,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1119,     0,  2641,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,     0,     0,   688,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2020,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,  1745,     0,     0,     0,     0,  1745,  1745,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,  2720,     0,     0,     0,     0,  2724,
       0,     0,     0,  2728,     0,     0,     0,     0,     0,  2732,
       0,     0,     0,     0,     0,  2737,     0,     0,     0,     0,
       0,  2747,     0,     0,     0,     0,  2749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2765,
    2766,  2769,  2770,     0,     0,  1420,  2776,  2779,     0,     0,
       0,  2782,     0,     0,  2786,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2823,     0,
    1872,     0,     0,     0,  1745,     0,     0,  2642,  2826,     0,
    2828,     0,     0,     0,  1489,     0,  2150,     0,  1123,  2839,
    2840,  2841,     0,  2843,     0,  1123,     0,     0,     0,     0,
    2856,  2857,     0,     0,     0,     0,     0,     0,  2860,  2861,
       0,     0,     0,     0,     0,     0,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,     0,   674,     0,  1123,     0,  2704,     0,
    1552,     0,     0,     0,     0,     0,   688,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1745,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,     0,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1737,  3048,     0,     0,     0,     0,   674,     0,     0,     0,
    1123,  1123,     0,  1123,   674,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,  1921,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,  1944,  1123,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1968,  1969,     0,  1972,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2010,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1749,     0,  1745,  1745,     0,  1745,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,   688,  1872,     0,     0,     0,
       0,     0,     0,     0,     0,  2068,     0,     0,     0,  1749,
       0,  3229,  3230,     0,     0,     0,     0,  1745,     0,  1745,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1749,  2096,     0,  3241,     0,  2106,  2109,     0,     0,
       0,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3257,  3258,  3259,  3260,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1737,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1749,  1745,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1737,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,  1749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1745,     0,     0,     0,     0,     0,
    1749,     0,  3305,     0,     0,     0,     0,  3307,     0,     0,
    1745,  1737,     0,     0,     0,     0,  1739,     0,     0,     0,
       0,     0,     0,     0,  1745,     0,     0,     0,  1737,     0,
       0,     0,     0,     0,     0,  2150,     0,     0,     0,  1745,
     674,     0,     0,     0,     0,     0,  1737,     0,  1123,     0,
    1123,     0,     0,     0,     0,     0,  1749,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1737,     0,     0,     0,  1745,     0,     0,     0,     0,
       0,     0,  3395,   883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3241,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     883,     0,     0,     0,     0,     0,  1123,  1737,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,  3452,     0,     0,
       0,     0,     0,     0,     0,  1745,     0,     0,     0,     0,
    3461,  1123,  1123,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,  1123,     0,     0,  1123,     0,     0,     0,     0,
    1745,     0,     0,  1123,  1123,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,  1123,  1123,  1123,  1123,     0,     0,
       0,     0,     0,     0,  1123,  1123,     0,  1123,     0,  1123,
       0,     0,  1123,     0,  1745,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1749,  1123,     0,     0,
       0,  1123,     0,     0,     0,  1123,     0,     0,     0,  1123,
       0,     0,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
    1123,     0,  1123,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,  2514,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2536,     0,     0,  2538,   688,     0,
    2549,     0,     0,  1123,     0,     0,  1745,  2556,  2561,     0,
       0,     0,  2566,     0,     0,  2571,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2580,     0,     0,     0,  2586,   688,     0,     0,  2598,     0,
       0,     0,  2605,     0,     0,  2607,  2608,  2609,  2610,  2611,
    2612,  2613,  2614,  2615,     0,  2616,     0,     0,     0,     0,
       0,  1420,     0,     0,  1739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,     0,  1123,     0,     0,  3631,     0,
       0,     0,     0,  3638,     0,  3640,  3641,  3642,  3643,     0,
       0,  1739,     0,     0,  1745,  1749,     0,     0,     0,     0,
    1749,  1749,     0,     0,     0,     0,  1489,     0,     0,     0,
       0,     0,  1740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1745,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3694,  3696,  3698,
    1739,  3700,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,  1739,     0,     0,
       0,  1737,  1737,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2735,     0,
    1739,     0,     0,     0,     0,  1123,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3769,     0,  1740,     0,     0,     0,     0,
       0,     0,  1745,     0,     0,     0,     0,     0,     0,     0,
    2704,     0,     0,  1745,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,     0,     0,  1737,  1123,
       0,     0,   674,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1745,     0,     0,
       0,     0,     0,     0,     0,  1745,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2894,     0,
    1737,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3855,     0,     0,  1123,  1123,     0,     0,
       0,     0,     0,     0,  3864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,  1123,     0,     0,
       0,  1123,  2999,     0,     0,     0,  1739,     0,     0,     0,
       0,     0,     0,  1123,  1123,  1123,  1123,     0,  1737,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,  1123,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,  3020,
    1123,  1123,     0,  1123,     0,     0,     0,     0,     0,     0,
    1745,     0,     0,     0,     0,     0,  1123,     0,  1123,     0,
    1740,     0,  1123,     0,     0,     0,     0,  3911,     0,  1420,
       0,     0,     0,     0,     0,  1745,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,  3927,     0,     0,     0,  1123,
       0,  1123,  1123,  1123,     0,  1740,     0,     0,     0,     0,
    3059,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,  1740,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,  3961,  1123,     0,     0,     0,  1745,     0,     0,  1123,
    1123,  1123,     0,     0,     0,     0,  2561,     0,  2561,  2561,
       0,     0,     0,     0,     0,     0,  1742,     0,  3119,     0,
       0,  3122,     0,  3124,     0,     0,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,   674,     0,  1123,     0,     0,     0,   674,     0,  3145,
       0,  3147,     0,  1740,     0,  3150,     0,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,  1749,
    1749,  1740,  1749,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,  1745,     0,  3165,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,  1740,     0,  1743,     0,
    1739,  1739,     0,     0,  3195,     0,     0,     0,     0,     0,
    1749,  1745,  1749,  1489,     0,     0,     0,     0,     0,     0,
    2096,     0,     0,     0,     0,  3209,     0,     0,     0,     0,
       0,     0,  2109,  2109,  2106,     0,     0,  1744,     0,  1742,
    1737,  1737,   674,  1737,  1745,     0,     0,     0,  1745,  1745,
    1737,     0,  1740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3232,     0,     0,     0,
       0,  1737,     0,  1737,  1749,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,     0,  1739,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1749,     0,  1737,     0,     0,     0,     0,
    1744,     0,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
    1737,     0,  1749,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,     0,  1123,     0,     0,     0,     0,  1737,     0,
       0,     0,   674,  1123,     0,     0,     0,     0,  1749,     0,
       0,     0,  1740,     0,  1737,     0,     0,  4162,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1737,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,  1737,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,  1739,     0,  1749,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,  1737,
       0,  1123,     0,  1123,  1742,     0,     0,     0,  1749,  1123,
       0,     0,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
    1123,  1123,     0,     0,     0,  1123,  1123,     0,     0,     0,
       0,     0,     0,  1749,     0,     0,     0,     0,  1123,  1742,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,  1123,     0,  1123,
    1737,  1742,     0,     0,     0,     0,     0,  1749,  1123,  1123,
    1123,     0,     0,     0,  1123,     0,     0,  1123,     0,  1737,
       0,     0,     0,     0,     0,     0,  1743,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,  1737,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3484,
    1742,  1743,     0,     0,     0,  1744,     0,     0,  3487,     0,
       0,     0,     0,     0,  3488,   674,  3489,  1742,  1737,     0,
       0,     0,     0,  1743,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1742,     0,     0,  3507,  3508,
    1744,  1740,     0,     0,     0,     0,  1740,  1740,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2566,     0,     0,
    1742,     0,  1744,     0,     0,     0,     0,  3533,     0,  1749,
    3536,     0,  3538,     0,     0,     0,     0,     0,     0,     0,
       0,  3542,  1743,     0,     0,     0,     0,  3547,     0,     0,
    3550,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
    3557,     0,     0,     0,     0,     0,     0,     0,     0,  3020,
       0,     0,     0,     0,     0,     0,  1742,  1743,     0,     0,
       0,  1744,     0,     0,     0,     0,     0,     0,     0,  1739,
    1739,     0,  1739,     0,     0,     0,     0,     0,  1744,  1739,
    1737,     0,  1743,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,  1740,     0,     0,     0,     0,     0,     0,
    1739,     0,  1739,     0,  1123,     0,     0,     0,     0,     0,
       0,  1744,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1749,  1123,  1123,  1740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,  1123,     0,  1739,     0,     0,  1123,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,  1737,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1742,     0,     0,  1123,
       0,     0,     0,  1737,     0,     0,     0,  1739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1739,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1740,     0,  1123,     0,  1739,     0,     0,
       0,     0,  1123,  1123,     0,  1749,     0,     0,     0,     0,
    1123,  1123,  1739,     0,     0,  1123,  1749,     0,     0,     0,
       0,  1123,  1123,     0,     0,  1123,  3741,  3742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2006,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,  1744,     0,     0,
    1749,     0,     0,     0,     0,     0,     0,  1737,  1749,     0,
       0,     0,  3784,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,  2006,  3800,  3802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3809,     0,
       0,  1737,     0,  1739,  3814,  3815,     0,     0,  3817,  1737,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,  3831,     0,
       0,     0,     0,     0,     0,  1742,     0,  1739,     0,     0,
    1742,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
    1749,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,  1123,     0,
       0,     0,     0,  1749,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,  1740,     0,  1740,     0,
       0,     0,     0,     0,  1123,  1740,     0,  1743,  1749,     0,
       0,     0,  1743,  1743,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,  1123,
       0,     0,  1123,     0,     0,     0,  1740,     0,  1740,  1123,
    1123,     0,     0,     0,     0,     0,  1744,  1742,  3899,  1739,
       0,  1744,  1744,     0,  1737,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,  1123,     0,     0,     0,     0,     0,     0,  1737,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,     0,  3951,     0,  1742,
    1740,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
    1737,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,  1123,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,  1740,     0,  3982,     0,  1739,  1744,     0,
       0,     0,     0,  3984,     0,     0,     0,     0,     0,  1740,
       0,     0,     0,  1123,  1749,     0,  1123,     0,  1123,     0,
       0,  1743,     0,  1740,     0,     0,     0,     0,     0,     0,
       0,     0,  1739,     0,     0,     0,     0,  1742,  1740,     0,
       0,     0,     0,     0,  1123,     0,     0,  1749,     0,     0,
       0,  1749,  1749,     0,     0,     0,     0,     0,  1737,     0,
    1744,     0,     0,     0,     0,  2006,     0,     0,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,     0,     0,     0,     0,
    1749,     0,     0,     0,  4055,     0,     0,     0,  1737,  1743,
       0,     0,  1737,  1737,     0,     0,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,  1740,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,  2566,
       0,     0,     0,     0,  1740,     0,  1739,     0,  1744,  2006,
       0,     0,     0,     0,  2545,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4089,     0,  1740,
       0,     0,     0,  2006,  2006,     0,     0,  2006,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1740,     0,     0,     0,     0,     0,     0,
    1739,     0,     0,     0,     0,  2006,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,  2006,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
    1742,     0,  1742,     0,     0,     0,     0,     0,     0,  1742,
       0,  2006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2006,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
    1742,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,  1743,  1739,  1743,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,  1742,     0,     0,     0,     0,     0,
    1744,  1744,  1743,  1744,  1743,     0,     0,     0,     0,     0,
    1744,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1740,     0,     0,     0,     0,     0,     0,
       0,  1744,     0,  1744,     0,     0,     0,  1742,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1742,     0,     0,     0,     0,  1740,     0,
       0,     0,     0,     0,     0,     0,  1743,  1742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1744,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1742,  1743,
       0,     0,     0,     0,     0,     0,     0,  1739,     0,     0,
    1744,     0,     0,     0,     0,  1743,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,  1739,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,  1743,     0,     0,     0,     0,     0,
       0,  1740,     0,     0,  1744,     0,     0,     0,     0,  1742,
       0,     0,  1740,     0,     0,     0,     0,  1739,  1744,     0,
       0,  1739,  1739,     0,     0,     0,     0,     0,  1742,     0,
    1743,     0,     0,  1744,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1742,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,  1742,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1743,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2006,
    1744,     0,     0,     0,     0,  1743,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,  2006,     0,  2006,     0,  2545,  2545,  3095,     0,     0,
    2545,     0,     0,     0,  2006,     0,     0,     0,     0,  1743,
       0,  2006,     0,     0,  1744,     0,  2006,     0,     0,     0,
       0,  2006,     0,     0,     0,     0,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,  2006,     0,     0,     0,  2545,
    2545,  2006,     0,     0,     0,     0,     0,     0,  1744,  1742,
       0,     0,     0,  2006,     0,     0,     0,     0,     0,     0,
    2006,     0,  2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,
    2006,  2006,     0,     0,     0,     0,     0,     0,     0,  1740,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,  1742,     0,     0,
    1744,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,  1740,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1740,     0,     0,     0,  1743,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1740,     0,  1742,     0,  1740,  1740,     0,
       0,     0,     0,  1744,     0,     0,  1742,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2006,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1742,     0,     0,     0,     0,     0,     0,  1743,  1742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1743,     0,     0,  2006,     0,     0,     0,     0,
    1743,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1744,     0,     0,  2006,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3095,  3095,     0,  2545,     0,
       0,  2545,  2545,  2545,  2545,  2545,  2545,  2545,  2545,  2545,
    2545,  3095,     0,  1742,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2006,     0,     0,  2006,  1742,  2006,
       0,     0,     0,     0,  3095,  3095,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2545,  2545,
    2006,     0,  2006,     0,     0,  2006,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1743,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1743,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1744,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2006,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,  1742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1742,     0,     0,     0,     0,     0,
    1744,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1742,     0,     0,
       0,  1742,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1743,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,  1743,  1743,  1744,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,  1744,  1744,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2006,
       0,     0,  2006,  2006,  2006,     0,     0,  3095,     0,     0,
       0,     0,  3095,  3095,  3095,  3095,  3095,  3095,  3095,  3095,
    3095,  3095,  2006,  2006,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2006,  2545,
    2545,  2006,     0,  2006,     0,     0,     5,  2006,  3095,  3095,
       0,     0,  2006,     0,     0,  2006,     6,     7,     0,     0,
       0,     0,  2006,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3095,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2006,  2006,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2006,
       0,     0,     0,  2545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,  2006,    48,  2006,     0,     0,
       0,     0,  3095,  3095,  2006,     0,     0,  2545,  2545,  2006,
    2006,     0,  2006,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    52,     0,     0,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,  3095,  2545,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3095,  3095,  2006,     0,  2006,
       0,    54,     0,     0,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1279,  1844,
       0,     0,     0,    71,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
    2006,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,  3095,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,  2006,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   701,   422,
     423,   424,   702,   703,   704,   705,   706,   707,   708,   425,
     426,   709,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,   710,   431,   432,   433,   434,   435,   711,   712,
     436,   437,   713,   140,   439,   714,   440,   441,   442,   443,
     144,   715,   716,   444,   445,   446,   447,   448,   717,   718,
     450,   451,   452,   453,   454,   455,   719,   456,   457,   458,
     149,   459,   720,   721,   722,   723,   150,   724,   725,   726,
     460,   461,   462,   463,   464,   465,   153,   154,   466,   727,
     467,   728,   468,   469,   470,   471,   472,   729,   473,   474,
     475,   730,   731,   476,   477,   478,   479,   480,   732,   481,
     482,   483,   733,   484,   485,   734,   486,   487,   488,   162,
     489,   490,   164,   735,   491,   736,   492,   166,   493,   737,
     494,   738,   495,   167,   739,   168,   496,   497,   740,   498,
     170,   741,   499,   742,   500,   501,   502,   503,   504,   171,
     505,   506,   507,   743,   508,   509,   510,   511,   512,   513,
     744,   172,   173,   745,   514,   515,   516,   746,   175,   747,
     176,   748,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,   749,   180,   181,   526,   182,   750,
     527,   528,   529,   751,   752,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,   188,
     189,   753,   543,   544,   545,   546,   547,   548,   549,   190,
     550,   754,   551,   552,   192,   553,   755,   193,   554,   194,
     555,   556,   756,   757,   557,   758,   759,   760,   558,   559,
     560,   761,   762,   195,   196,   197,   198,   199,   561,   562,
     563,   564,   565,   566,   763,   567,   200,   568,   201,   569,
     570,   571,   764,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,   765,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   766,   592,   593,   209,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
     767,   604,   605,   606,   607,   768,   608,   215,   609,   610,
     217,   611,   218,   769,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,   770,   623,   624,   771,
     625,   626,   627,   628,   629,   772,   222,   223,   773,   774,
     631,   224,   632,   225,   775,   633,   634,   635,   636,   637,
     638,   776,   777,   639,   640,   641,   642,   778,   779,   643,
     644,   645,   646,   780,   233,   781,   648,   234,   649,   650,
     651,   782,   783,   652,   784,   785,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    85,     0,     0,    86,
      87,    88,    89,    90,    91,    92,    93,     0,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   106,   920,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,   119,   120,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   128,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   129,     0,   130,   131,     0,     0,
       0,     0,     0,     0,     0,     0,   132,   133,     0,     0,
     134,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
     141,     0,   142,   143,   144,     0,     0,   145,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   147,     0,
     148,     0,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,   151,     0,   152,
     153,   154,   155,     0,     0,     0,     0,     0,   156,     0,
       0,     0,     0,     0,   157,     0,     0,     0,     0,     0,
     158,     0,     0,     0,     0,     0,   159,   160,     0,     0,
       0,     0,   161,   162,   163,     0,   164,     0,     0,   165,
       0,   166,     0,     0,     0,     0,     0,   167,     0,   168,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   172,   173,     0,     0,   174,
       0,     0,   175,     0,   176,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,     0,   182,     0,   183,   184,     0,     0,     0,     0,
     185,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,   187,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,   191,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   195,   196,   197,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,     0,   205,
       0,   206,     0,     0,     0,     0,   207,     0,     0,     0,
       0,   208,   209,     0,   210,   211,     0,     0,   212,     0,
       0,     0,     0,     0,   213,     0,     0,     0,     0,     0,
     214,   215,     0,   216,   217,     0,   218,     0,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,   221,     0,     0,     0,     0,     0,     0,
     222,   223,     0,     0,     0,   224,     0,   225,     0,   226,
       0,   227,     0,     0,     0,   228,     0,     0,   229,     0,
     230,     0,     0,   231,     0,     0,     0,   232,   233,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,   235,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,     0,     0,     0,     0,     0,     0,    55,
       0,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     244,   104,   105,     0,  -122,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,     0,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,   154,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   160,
       0,     0,     0,     0,     0,   162,     0,     0,   164,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   167,
       0,   168,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,     0,     0,   171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,   173,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,   180,   181,     0,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,   190,     0,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   209,     0,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,     0,   217,     0,   218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,   223,     0,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,  2694,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,   154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   160,     0,     0,     0,     0,     0,   162,
       0,     0,   164,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,   168,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   172,   173,     0,     0,     0,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,   190,
       0,     0,     0,     0,   192,     0,     0,   193,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   195,   196,   197,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   209,     0,
       0,   211,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
     217,     0,   218,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   223,     0,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,     0,     0,   234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   236,   237,   238,   239,   240,   241,   242,   243,     4,
       0,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,  2696,     0,     0,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,    35,     0,     0,     0,
      37,    38,    39,    40,    41,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,    42,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,    35,     0,     0,
       0,    37,    38,    39,    40,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1279,  2446,     0,    51,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
       0,    55,    56,    57,     0,     0,     0,    58,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1279,     0,     0,     0,     0,    71,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,  2635,   422,   423,   424,     0,     0,     0,     0,
    1341,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1342,   137,  1343,  1344,     0,   431,   432,   433,
     434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,
     440,   441,   442,   443,  1349,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,     0,  1350,  1351,  1352,
    1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,   465,
    1357,  1358,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,  2636,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,  1360,   489,   490,  1361,  1362,   491,     0,
     492,  1363,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,  1364,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,  1365,  1366,     0,  1367,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,  1368,
     181,   526,   182,     0,   527,   528,   529,  1369,  1370,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1371,   188,  1372,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,  1373,   551,   552,   192,   553,
    1374,  1375,   554,  1376,   555,   556,     0,     0,   557,  1019,
       0,     0,  1377,   559,   560,     0,     0,   195,   196,   197,
     198,  1378,   561,   562,   563,   564,   565,   566,     0,   567,
    1379,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1380,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,  1381,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,  1382,
     608,   215,   609,   610,   217,   611,  1383,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,  1384,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,
     634,   635,   636,   637,   638,     0,  1390,   639,   640,   641,
     642,  1391,     0,   643,   644,   645,   646,   647,  1392,  2637,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,
    1397,  1398,  1399,   658,   659,   660,     0,     0,     0,    55,
      56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,
       0,  1404,  1405,  2638,     0,     0,     0,     0,     0,     0,
    1407,  2639,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,  1373,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
    1390,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  1404,  1405,     0,     0,     0,
       0,     0,     0,     0,  1407,  2547,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1715,   137,  1716,  1717,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1718,  1719,   439,     0,   440,   441,
     442,   443,     0,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,  1720,  1721,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,     0,   489,   490,     0,     0,   491,     0,   492,  1722,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,     0,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,  2206,   508,   509,   510,   511,
     512,   513,     0,   172,  2207,     0,   514,   515,   516,  1365,
    1723,     0,  1724,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,     0,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1725,   188,  1726,     0,   543,   544,   545,   546,   547,   548,
     549,     0,   550,     0,   551,   552,   192,   553,     0,     0,
     554,  1727,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,  2208,   196,   197,   198,     0,
     561,   562,   563,   564,   565,   566,     0,   567,     0,   568,
       0,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1728,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,     0,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,  2209,
     609,   610,   217,   611,  1730,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,     0,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1731,  1732,
       0,     0,   631,     0,   632,     0,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,     0,  1733,  2210,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,     0,     0,     0,     0,     0,     0,     0,
       0,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  2211,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1715,   137,  1716,  1717,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1718,  1719,   439,     0,   440,   441,
     442,   443,     0,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,  1720,  1721,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,     0,   489,   490,     0,     0,   491,     0,   492,  1722,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,     0,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,  2206,   508,   509,   510,   511,
     512,   513,     0,   172,  2207,     0,   514,   515,   516,  1365,
    1723,     0,  1724,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,     0,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1725,   188,  1726,     0,   543,   544,   545,   546,   547,   548,
     549,     0,   550,     0,   551,   552,   192,   553,     0,     0,
     554,  1727,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,  2208,   196,   197,   198,     0,
     561,   562,   563,   564,   565,   566,     0,   567,     0,   568,
       0,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1728,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,     0,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,  2209,
     609,   610,   217,   611,  1730,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,     0,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1731,  1732,
       0,     0,   631,     0,   632,     0,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,     0,  1733,  2210,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,     0,     0,     0,     0,     0,     0,     0,
       0,   658,   659,   660,     0,     0,     0,    55,     0,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,  2960,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,  4058,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     694,    86,    87,    88,   400,    90,    91,    92,   401, -1564,
     402,    95,     0, -1564,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,  2557,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
    2558,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
    2559,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,  2560,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
    1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,   213,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,   221,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,  1390,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,  1970,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,   235,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  1404,  1405,     0,     0,
       0,     0,     0,     0,     0,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
     182,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,  1373,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,   217,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,  1390,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,
    1405,     0,     0,     0,     0,     0,  1916,  2506,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,   182,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,  1373,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,   217,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,  1406,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,  1488,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,  1373,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
    1390,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  1404,  1405,     0,     0,     0,
       0,     0,     0,     0,  1407,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2104,
     422,   423,   424,     0,     0,     0,     0,  1341,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1342,
     137,  1343,  1344,     0,   431,   432,   433,   434,   435,  1345,
    1346,   436,   437,  1347,  1348,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,  1357,  1358,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
    1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,  1365,  1366,
       0,  1367,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1371,
     188,  1372,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,  1373,   551,   552,   192,   553,  1374,  1375,   554,
    1376,   555,   556,     0,     0,   557,  1019,     0,     0,  1377,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1380,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,  1381,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,  1383,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1385,  1386,     0,
       0,   631,  1387,   632,  1388,  1389,   633,   634,   635,   636,
     637,   638,     0,  1390,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,   647,  1392,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,    56,    57,  1400,
    1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,
       0,     0,     0,     0,     0,     0,     0,  1407,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1341,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1342,   137,  1343,  1344,     0,   431,   432,   433,
     434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,
     440,   441,   442,   443,  1349,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,  2998,  1350,  1351,  1352,
    1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,   465,
    1357,  1358,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,  1360,   489,   490,  1361,  1362,   491,     0,
     492,  1363,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,  1364,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,  1365,  1366,     0,  1367,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,  1368,
     181,   526,   182,     0,   527,   528,   529,  1369,  1370,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1371,   188,  1372,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,  1373,   551,   552,   192,   553,
    1374,  1375,   554,  1376,   555,   556,     0,     0,   557,  1019,
       0,     0,  1377,   559,   560,     0,     0,   195,   196,   197,
     198,  1378,   561,   562,   563,   564,   565,   566,     0,   567,
    1379,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1380,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,  1381,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,  1382,
     608,   215,   609,   610,   217,   611,  1383,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,  1384,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,
     634,   635,   636,   637,   638,     0,  1390,   639,   640,   641,
     642,  1391,     0,   643,   644,   645,   646,   647,  1392,     0,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,
    1397,  1398,  1399,   658,   659,   660,     0,     0,     0,    55,
      56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,
       0,  1404,  1405,     0,     0,     0,     0,     0,     0,     0,
    1407,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1341,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1342,   137,  1343,  1344,     0,
     431,   432,   433,   434,   435,  1345,  1346,   436,   437,  1347,
    1348,   439,     0,   440,   441,   442,   443,  1349,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
    1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,
     463,   464,   465,  1357,  1358,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1359,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,  1360,   489,   490,  1361,
    1362,   491,     0,   492,  1363,   493,     0,   494,     0,   495,
     167,  2558,   168,   496,   497,     0,   498,  1364,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,  1365,  1366,     0,  1367,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,  1368,   181,   526,   182,     0,   527,   528,   529,
    1369,  1370,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1371,   188,  1372,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,  1373,   551,
     552,   192,   553,  1374,  1375,   554,  1376,   555,   556,     0,
       0,   557,  1019,     0,     0,  1377,   559,   560,     0,     0,
     195,   196,   197,   198,  1378,   561,   562,   563,   564,   565,
     566,     0,   567,  1379,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,  1380,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,  1381,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,  1382,   608,   215,   609,   610,   217,   611,  1383,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,  1384,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1385,  1386,     0,     0,   631,  1387,   632,
    1388,  1389,   633,   634,   635,   636,   637,   638,     0,  1390,
     639,   640,   641,   642,  1391,     0,   643,   644,   645,   646,
     647,  1392,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,  1393,
    1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,
       0,     0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,
       0,     0,     0,     0,  1404,  1405,     0,     0,     0,     0,
       0,     0,     0,  1407,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,  1341,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1342,   137,
    1343,  1344,     0,   431,   432,   433,   434,   435,  1345,  1346,
     436,   437,  1347,  1348,   439,     0,   440,   441,   442,   443,
    1349,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,
     460,   461,   462,   463,   464,   465,  1357,  1358,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1359,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,  1360,
     489,   490,  1361,  1362,   491,     0,   492,  1363,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
    1364,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,  1365,  1366,     0,
    1367,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,  1368,   181,   526,   182,     0,
     527,   528,   529,  1369,  1370,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1371,   188,
    1372,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,  1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,
     555,   556,     0,     0,   557,  1019,     0,     0,  1377,   559,
     560,     0,     0,   195,   196,   197,   198,  1378,   561,   562,
     563,   564,   565,   566,     0,   567,  1379,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
    1380,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,  1381,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,  1382,   608,   215,   609,   610,
     217,   611,  1383,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,  1384,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1385,  1386,     0,     0,
     631,  1387,   632,  1388,  1389,   633,   634,   635,   636,   637,
     638,     0,  1390,   639,   640,   641,   642,  1391,     0,   643,
     644,   645,   646,   647,  1392,  3569,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,
     659,   660,     0,     0,     0,    55,    56,    57,  1400,  1401,
    1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,     0,
       0,     0,     0,     0,     0,     0,  1407,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1341,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1342,   137,  1343,  1344,     0,   431,   432,   433,   434,
     435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,
     441,   442,   443,  1349,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,
    1354,  1355,  1356,   460,   461,   462,   463,   464,   465,  1357,
    1358,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,  1360,   489,   490,  1361,  1362,   491,     0,   492,
    1363,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,  1364,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
    1365,  1366,     0,  1367,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,  1368,   181,
     526,   182,     0,   527,   528,   529,  1369,  1370,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1371,   188,  1372,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,  1373,   551,   552,   192,   553,  1374,
    1375,   554,  1376,   555,   556,     0,     0,   557,  1019,     0,
       0,  1377,   559,   560,     0,     0,   195,   196,   197,   198,
    1378,   561,   562,   563,   564,   565,   566,     0,   567,  1379,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1380,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,  1381,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,  1382,   608,
     215,   609,   610,   217,   611,  1383,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,  1384,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1385,
    1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,   634,
     635,   636,   637,   638,     0,  1390,   639,   640,   641,   642,
    1391,     0,   643,   644,   645,   646,   647,  1392,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,
    1398,  1399,   658,   659,   660,     0,     0,     0,    55,    56,
      57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,
    1404,  1405,     0,     0,     0,     0,     0,     0,     0,  1407,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,     0,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,  3794,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,  3801,   545,   546,   547,   548,   549,   190,   550,
    1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,  1390,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  1404,  1405,     0,     0,
       0,     0,     0,     0,     0,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
     182,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,   217,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  2540,
    2541,     0,     0,     0,     0,     0,     0,     0,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,     0,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,     0,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,     0,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,     0,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,     0,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,     0,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,     0,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,     0,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,     0,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  2540,  2541,     0,     0,     0,
       0,     0,     0,     0,  1407,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
    1346,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,  1361,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
     188,   189,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,   192,   553,     0,  1375,   554,
     194,   555,   556,     0,     0,   557,  1019,     0,  1020,   558,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   213,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
     221,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,  1387,   632,  1388,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,  1970,   233,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,   235,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  2403,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,  1346,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
    1349,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,  1361,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
    1364,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,  1368,   181,   526,   182,     0,
     527,   528,   529,  1369,  1370,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,   188,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,   192,   553,     0,  1375,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,  1020,   558,   559,
     560,     0,     0,   195,   196,   197,   198,  1378,   561,   562,
     563,   564,   565,   566,     0,   567,  1379,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,  1382,   608,   215,   609,   610,
     217,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,  1384,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,  1387,   632,  1388,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,  1391,     0,   643,
     644,   645,   646,   647,   233,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,
     659,   660,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  2403,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,  1346,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,  1361,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,   192,   553,     0,  1375,   554,   194,   555,
     556,     0,     0,   557,  1019,     0,     0,   558,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
    1387,   632,  1388,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,   233,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  3935,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,     0,     0,     0,   150,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,   180,   181,   526,   182,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,   188,   189,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,   192,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,  1019,     0,     0,   558,   559,   560,     0,
       0,   195,   196,   197,   198,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,   217,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,  4001,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2980,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
   -1169,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0, -1169,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0, -1169,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518, -1169,   519,   520,   521,
     522,   523,   524,   525,     0,   180, -1169,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187, -1169,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593, -1169,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,  1496,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      57,     0,     0,     0,    58,     0,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,  3349,  3350,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    57,
       0,     0,     0,    58,     0,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  3350,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   213,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
     221,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,  1970,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,   235,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   244,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,   213,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,   221,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,  1970,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,   235,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   244,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
    1019,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,  1474,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,  2078,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,  3445,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  3564,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   701,   422,
     423,   424,   702,   703,   704,   705,   706,   707,   708,   425,
     426,   709,   427,   133,   428,   429,   430,   135,  1715,   137,
    1716,  1717,   710,   431,   432,   433,   434,   435,   711,   712,
     436,   437,  1718,  1719,   439,   714,   440,   441,   442,   443,
       0,   715,   716,   444,   445,   446,   447,   448,   449,   718,
     450,   451,   452,   453,   454,   455,   719,   456,   457,   458,
     149,   459,     0,   721,   722,   723,   150,   724,   725,   726,
     460,   461,   462,   463,   464,   465,  1720,  1721,   466,   727,
     467,   728,   468,   469,   470,   471,   472,   729,   473,   474,
     475,   730,   731,   476,   477,  1359,   479,   480,   732,   481,
     482,   483,   733,   484,   485,   734,   486,   487,   488,     0,
     489,   490,     0,   735,   491,   736,   492,  1722,   493,   737,
     494,   738,   495,   167,   739,   168,   496,   497,   740,   498,
       0,   741,   499,   742,   500,   501,   502,   503,   504,   171,
     505,   506,   507,   743,   508,   509,   510,   511,   512,   513,
     744,   172,     0,     0,   514,   515,   516,  1365,  1723,   747,
    1724,   748,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,   749,     0,   181,   526,   182,   750,
     527,   528,   529,   751,   752,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1725,   188,
    1726,   753,   543,   544,   545,   546,   547,   548,   549,     0,
     550,   754,   551,   552,   192,   553,   755,     0,   554,  1727,
     555,   556,   756,   757,   557,   758,   759,   760,  3336,   559,
     560,   761,   762,     0,   196,   197,   198,     0,   561,   562,
     563,   564,   565,   566,   763,   567,     0,   568,     0,   569,
     570,   571,   764,   572,   573,   574,   575,   576,   577,   578,
    1728,   579,   580,   581,   765,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   766,   592,   593,   209,   594,
     595,     0,   596,   597,   598,   599,   600,   601,   602,   603,
     767,   604,   605,   606,   607,   768,   608,  2209,   609,   610,
     217,   611,  1730,   769,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,     0,   622,   770,   623,   624,   771,
     625,   626,   627,   628,   629,   772,  1731,  1732,     0,   774,
     631,     0,   632,     0,   775,   633,   634,   635,   636,   637,
     638,     0,   777,   639,   640,   641,   642,   778,   779,   643,
     644,   645,   646,     0,  1733,   781,   648,   234,   649,   650,
     651,   782,   783,   652,   784,   785,   653,   654,   655,   656,
     657,     0,     0,     0,     0,     0,     0,     0,     0,   658,
     659,   660,     0,     0,     0,    55,    56,    57,     0,     0,
    1136,    58,     0,  1137,  1138,  1139,     0,  3337,  3338,  1142,
    1143,  1144,  1145,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,  1134,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,  1135,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,     0,     0,     0,  1136,     0,
       0,  1137,  1138,  1139,     0,  1140,  1141,  1142,  1143,  1144,
    1145,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,  1210,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
    1211,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,     0,     0,     0,     0,  1136,     0,     0,  1137,
    1138,  1139,     0,  1140,  1141,  1142,  1143,  1144,  1145,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,  1256,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,  1257,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1258,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,     0,     0,     0,  1136,     0,     0,  1137,  1138,  1139,
       0,  1140,  1141,  1142,  1143,  1144,  1145,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,  1698,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,  1699,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,  1136,     0,     0,  1137,  1138,  1139,     0,  1140,
    1141,  1142,  1143,  1144,  1145,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,     0,     0,     0,
    1136,     0,     0,  1137,  1138,  1139,     0,  1140,  1141,  1142,
    1143,  1144,  1145,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   701,   422,   423,
     424,   702,   703,   704,   705,   706,   707,   708,   425,   426,
     709,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   710,   431,   432,   433,   434,   435,   711,   712,   436,
     437,   713,   140,   439,   714,   440,   441,   442,   443,   144,
     715,   716,   444,   445,   446,   447,   448,   717,   718,   450,
     451,   452,   453,   454,   455,   719,   456,   457,   458,   149,
     459,   720,   721,   722,   723,   150,   724,   725,   726,   460,
     461,   462,   463,   464,   465,   153,   154,   466,   727,   467,
     728,   468,   469,   470,   471,   472,   729,   473,   474,   475,
     730,   731,   476,   477,   478,   479,   480,   732,   481,   482,
     483,   733,   484,   485,   734,   486,   487,   488,   162,   489,
     490,   164,   735,   491,   736,   492,   166,   493,   737,   494,
     738,   495,   167,   739,   168,   496,   497,   740,   498,   170,
     741,   499,   742,   500,   501,   502,   503,   504,   171,   505,
     506,   507,   743,   508,   509,   510,   511,   512,   513,   744,
     172,   173,   745,   514,   515,   516,   746,   175,   747,   176,
     748,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,   749,   180,   181,   526,   182,   750,   527,
     528,   529,   751,   752,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
     753,   543,   544,   545,   546,   547,   548,   549,   190,   550,
     754,   551,   552,   192,   553,   755,   193,   554,   194,   555,
     556,   756,   757,   557,   758,   759,   760,   558,   559,   560,
     761,   762,   195,   196,   197,   198,   199,   561,   562,   563,
     564,   565,   566,   763,   567,   200,   568,   201,   569,   570,
     571,   764,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,   765,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   766,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,   767,
     604,   605,   606,   607,   768,   608,   215,   609,   610,   217,
     611,   218,   769,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,   770,   623,   624,   771,   625,
     626,   627,   628,   629,   772,   222,   223,   773,   774,   631,
     224,   632,   225,   775,   633,   634,   635,   636,   637,   638,
     776,   777,   639,   640,   641,   642,   778,   779,   643,   644,
     645,   646,   780,   233,   781,   648,   234,   649,   650,   651,
     782,   783,   652,   784,   785,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  2069,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,     0,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,  1729,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
    2164,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,  1029,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,  2052,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,  2053,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,  2054,     0,   557,
       0,  2055,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,  2056,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,     0,     0,
       0,     0,   938,  1533,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,  2062,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,  2053,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,  2054,     0,   557,     0,  2055,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,  2056,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    56,    57,     0,     0,     0,
      58,     0,     0,     0,     0,     0,   938,  1533,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,  2053,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,  2054,     0,   557,     0,  2055,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,  2056,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    56,
      57,     0,     0,     0,    58,     0,     0,     0,     0,     0,
     938,  1533,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   927,   416,
     417,   418,   419,   420,   421,   928,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   929,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   930,   166,   493,     0,   494,     0,   931,
       0,   932,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
     933,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   934,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   935,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     936,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   937,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,   938,   939,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   927,   416,   417,   418,   419,   420,   421,   928,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   929,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   930,   166,   493,
       0,   494,     0,   931,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   934,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   935,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   936,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   937,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,   938,   939,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,   682,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,  1444,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,  1445,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,  1403,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  4196,     0,    58,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,   630,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    57,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,  1089,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    57,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    57,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,  2038,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    57,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,    57,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1839,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
     997,    57,    86,    87,    88,   400,    90,    91,    92,   401,
     998,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   999,   437,   974,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,  1000,     0,  1001,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,  1002,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,  1003,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,  1004,   595,   211,   596,
     597,   598,  1005,   600,   601,   602,   603,     0,   604,   605,
     606,  1006,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1007,   223,     0,     0,  1008,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     978,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,  1009,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   701,   422,   423,
     424,   702,   703,   704,   705,   706,   707,   708,   425,   426,
     709,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   710,   431,   432,   433,   434,   435,   711,   712,   436,
     437,   713,   140,   439,   714,   440,   441,   442,   443,   144,
     715,   716,   444,   445,   446,   447,   448,   717,   718,   450,
     451,   452,   453,   454,   455,   719,   456,   457,   458,   149,
     459,   720,   721,   722,   723,   150,   724,   725,   726,   460,
     461,   462,   463,   464,   465,   153,   154,   466,   727,   467,
     728,   468,   469,   470,   471,   472,   729,   473,   474,   475,
     730,   731,   476,   477,   478,   479,   480,   732,   481,   482,
     483,   733,   484,   485,   734,   486,   487,   488,   162,   489,
     490,   164,   735,   491,   736,   492,   166,   493,   737,   494,
     738,   495,   167,   739,   168,   496,   497,   740,   498,   170,
     741,   499,   742,   500,   501,   502,   503,   504,   171,   505,
     506,   507,   743,   508,   509,   510,   511,   512,   513,   744,
     172,   173,   745,   514,   515,   516,   746,   175,   747,   176,
     748,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,   749,   180,   181,   526,   182,   750,   527,
     528,   529,   751,   752,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
     753,   543,   544,   545,   546,   547,   548,   549,   190,   550,
     754,   551,   552,   192,   553,   755,   193,   554,   194,   555,
     556,   756,   757,   557,   758,   759,   760,   558,   559,   560,
     761,   762,   195,   196,   197,   198,   199,   561,   562,   563,
     564,   565,   566,   763,   567,   200,   568,   201,   569,   570,
     571,   764,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,   765,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   766,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,   767,
     604,   605,   606,   607,   768,   608,   215,   609,   610,   217,
     611,   218,   769,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,   770,   623,   624,   771,   625,
     626,   627,   628,   629,   772,   222,   223,   773,   774,   631,
     224,   632,   225,   775,   633,   634,   635,   636,   637,   638,
     776,   777,   639,   640,   641,   642,   778,   779,   643,   644,
     645,   646,   780,   233,   781,   648,   234,   649,   650,   651,
     782,   783,   652,   784,   785,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,  2830,   419,   420,   421,   701,
     422,   423,   424,   702,   703,   704,   705,   706,   707,   708,
     425,   426,   709,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,   710,   431,   432,   433,   434,   435,   711,
     712,   436,   437,   713,   140,   439,   714,   440,   441,   442,
     443,   144,   715,   716,   444,   445,   446,   447,   448,   717,
     718,   450,   451,   452,   453,   454,   455,   719,   456,   457,
     458,   149,   459,   720,   721,   722,   723,   150,   724,   725,
     726,   460,   461,   462,   463,   464,   465,   153,   154,   466,
     727,   467,   728,   468,   469,   470,   471,   472,   729,   473,
     474,   475,   730,   731,   476,   477,   478,  2831,   480,   732,
     481,   482,   483,   733,   484,   485,   734,   486,   487,   488,
     162,   489,   490,   164,   735,   491,   736,   492,   166,   493,
     737,   494,   738,   495,   167,   739,   168,   496,   497,   740,
     498,   170,   741,   499,   742,   500,   501,   502,   503,   504,
     171,   505,   506,   507,   743,   508,   509,   510,   511,   512,
     513,   744,   172,   173,   745,   514,   515,   516,   746,   175,
     747,   176,   748,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,   749,   180,   181,   526,   182,
     750,   527,   528,   529,   751,   752,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
     188,   189,   753,   543,   544,   545,   546,   547,   548,   549,
     190,   550,   754,   551,   552,   192,   553,   755,   193,   554,
     194,   555,   556,   756,   757,   557,   758,   759,   760,   558,
     559,   560,   761,   762,   195,   196,   197,   198,   199,   561,
     562,   563,   564,   565,   566,   763,   567,   200,   568,   201,
     569,   570,   571,   764,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,   765,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   766,   592,   593,   209,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   767,   604,   605,   606,   607,   768,  2832,   215,   609,
     610,   217,   611,   218,   769,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,   770,   623,   624,
     771,   625,   626,   627,   628,   629,   772,   222,   223,   773,
     774,   631,   224,   632,   225,   775,   633,   634,   635,   636,
     637,   638,   776,   777,   639,   640,   641,   642,   778,   779,
     643,   644,   645,   646,   780,   233,   781,   648,   234,   649,
     650,   651,   782,   783,   652,   784,   785,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,   180,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,   188,   189,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,   192,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,  1019,     0,
       0,   558,   559,   560,     0,     0,   195,   196,   197,   198,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,   217,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,     0,     0,
       0,   150,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1243,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
     180,   181,   526,   182,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,   188,   189,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
    1019,     0,     0,   558,   559,   560,     0,     0,   195,   196,
     197,   198,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,   217,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
       0,     0,     0,   150,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1251,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,   180,   181,   526,   182,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,   188,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,   192,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,     0,   558,   559,   560,     0,     0,
     195,   196,   197,   198,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,   217,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,  2206,   508,   509,   510,   511,   512,   513,     0,
     172,  2207,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,  2208,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2209,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,  2210,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,  2198,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,  2209,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
    3422,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1715,   137,  1716,  1717,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,  1718,  1719,   439,     0,   440,
     441,   442,   443,     0,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,  1720,
    1721,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,     0,   489,   490,     0,     0,   491,     0,   492,
    1722,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,     0,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,     0,     0,   514,   515,   516,
    1365,  1723,     0,  1724,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,     0,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1725,   188,  1726,     0,   543,   544,   545,   546,   547,
     548,   549,  2247,   550,     0,   551,   552,   192,   553,     0,
       0,   554,  1727,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,     0,   196,   197,   198,
       0,   561,   562,   563,   564,   565,   566,     0,   567,     0,
     568,     0,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1728,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,     0,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
    1729,   609,   610,   217,   611,  1730,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,     0,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1731,
    1732,     0,     0,   631,     0,   632,     0,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,     0,  1733,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,     0,     0,     0,     0,     0,     0,
       0,     0,   658,   659,   660,     0,     0,     0,    55,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1715,   137,  1716,  1717,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,  1718,  1719,   439,
       0,   440,   441,   442,   443,     0,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,     0,     0,
       0,   150,     0,     0,     0,   460,   461,   462,   463,   464,
     465,  1720,  1721,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,     0,   489,   490,     0,     0,   491,
       0,   492,  1722,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,     0,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,     0,     0,   514,
     515,   516,  1365,  1723,     0,  1724,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
       0,   181,   526,   182,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1725,   188,  1726,     0,   543,   544,   545,
     546,   547,   548,   549,  3272,   550,     0,   551,   552,   192,
     553,     0,     0,   554,  1727,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,     0,   196,
     197,   198,     0,   561,   562,   563,   564,   565,   566,     0,
     567,     0,   568,     0,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1728,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,     0,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,  1729,   609,   610,   217,   611,  1730,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,     0,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1731,  1732,     0,     0,   631,     0,   632,     0,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,     0,  1733,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,     0,     0,     0,     0,
       0,     0,     0,     0,   658,   659,   660,     0,     0,     0,
      55,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1715,   137,  1716,  1717,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,  1718,
    1719,   439,     0,   440,   441,   442,   443,     0,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
       0,     0,     0,   150,     0,     0,     0,   460,   461,   462,
     463,   464,   465,  1720,  1721,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1359,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,     0,   489,   490,     0,
       0,   491,     0,   492,  1722,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,     0,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,     0,
       0,   514,   515,   516,  1365,  1723,     0,  1724,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,     0,   181,   526,   182,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1725,   188,  1726,     0,   543,
     544,   545,   546,   547,   548,   549,     0,   550,     0,   551,
     552,   192,   553,     0,     0,   554,  1727,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
       0,   196,   197,   198,     0,   561,   562,   563,   564,   565,
     566,     0,   567,     0,   568,     0,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,  1728,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,     0,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,  1729,   609,   610,   217,   611,  1730,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,     0,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1731,  1732,     0,     0,   631,     0,   632,
       0,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
       0,  1733,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,     0,     0,
       0,     0,     0,     0,     0,     0,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,     0,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,     0,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2209,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,     0,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,     0,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,     0,   137,     0,     0,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,     0,   439,     0,   440,
     441,   442,   443,     0,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,     0,
       0,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,     0,   489,   490,     0,     0,   491,     0,   492,
       0,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,     0,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,     0,     0,   514,   515,   516,
       0,     0,     0,     0,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,     0,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,     0,   188,     0,     0,   543,   544,   545,   546,   547,
     548,   549,     0,   550,     0,   551,   552,   192,   553,     0,
       0,   554,     0,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,     0,   196,   197,   198,
       0,   561,   562,   563,   564,   565,   566,     0,   567,     0,
     568,     0,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,     0,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,     0,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
       0,   609,   610,   217,   611,     0,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,     0,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,     0,
       0,     0,     0,   631,     0,   632,     0,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,     0,     0,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,     0,     0,     0,     0,     0,     0,
       0,     0,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   701,   422,   423,   424,   702,   703,   704,   705,
     706,   707,   708,   425,   426,   709,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,   710,   431,   432,   433,
     434,   435,   711,   712,   436,   437,     0,   140,   439,   714,
     440,   441,   442,   443,   144,   715,   716,   444,   445,   446,
     447,   448,   717,   718,   450,   451,   452,   453,   454,   455,
     719,   456,   457,   458,   149,   459,     0,   721,   722,   723,
     150,   724,   725,   726,   460,   461,   462,   463,     0,   465,
     153,   154,   466,   727,   467,   728,   468,   469,   470,   471,
     472,   729,   473,   474,   475,   730,   731,   476,   477,   478,
     479,   480,   732,   481,   482,   483,   733,   484,   485,   734,
     486,   487,   488,   162,   489,   490,   164,   735,   491,   736,
     492,   166,   493,   737,   494,   738,   495,   167,   739,   168,
     496,   497,   740,   498,   170,   741,   499,   742,   500,   501,
       0,   503,   504,   171,   505,   506,   507,   743,   508,   509,
     510,   511,   512,   513,   744,   172,   173,     0,   514,   515,
     516,     0,   175,   747,   176,   748,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,   749,   180,
     181,   526,   182,   750,   527,   528,   529,   751,   752,   530,
     531,   532,   533,   534,   535,     0,   537,   538,     0,   540,
     541,   542,   187,   188,   189,   753,   543,   544,   545,   546,
     547,   548,   549,   190,   550,   754,   551,   552,   192,   553,
     755,   193,   554,   194,   555,   556,   756,   757,   557,   758,
     759,   760,   558,   559,   560,   761,   762,   195,   196,   197,
     198,   199,   561,   562,   563,   564,   565,   566,   763,   567,
     200,   568,   201,   569,   570,   571,   764,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,   765,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   766,
     592,   593,   209,   594,   595,   211,   596,   597,   598,   599,
     600,   601,     0,   603,   767,   604,   605,   606,   607,   768,
     608,   215,   609,   610,   217,   611,   218,   769,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
     770,   623,   624,   771,   625,   626,   627,   628,   629,   772,
     222,   223,     0,   774,   631,   224,   632,   225,   775,   633,
     634,   635,   636,   637,   638,     0,   777,   639,   640,   641,
     642,   778,   779,   643,   644,   645,   646,     0,   233,   781,
     648,   234,   649,   650,   651,   782,   783,   652,   784,   785,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,     0,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
    2178,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,  2179,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,  2180,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,  2942,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,  2181,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,  2182,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   987,   420,   421,   946,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,   947,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,   988,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
     948,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,   949,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   680,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,   681,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,   682,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   946,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,   947,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,   948,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   949,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,  1878,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
    1879,   495,     0,     0,     0,  1880,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,  1881,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,  1019,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,  1882,   600,   601,   602,   603,     0,
    1883,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,  1884,  1885,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,  2624,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,  2625,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,  2626,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,  2627,
     625,  2628,   627,  2629,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,   130,   131,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,  1019,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,   880,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
     881,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   882,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,  1019,     0,
    1020,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,  1447,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,  1019,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,   947,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,   948,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,   949,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,   682,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  1238,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,   932,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,   933,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,  2288,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,  2289,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2767,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,  2768,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
    2777,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,  2778,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   689,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   833,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   923,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   963,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,  1791,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2980,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2993,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,  3030,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,  3693,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,  3695,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,  3697,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,  4058,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   886,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   971,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   973,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   974,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,     0,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   975,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   976,   223,     0,     0,   977,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   978,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  1012,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   974,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,     0,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,  1013,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1014,   223,     0,     0,
    1015,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   978,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,  1037,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
    1159,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,  1222,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1248,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1253,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,  1261,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1263,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,  1265,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,  1267,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,  1270,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,  1272,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,  1273,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
    1276,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,  1460,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   999,   437,   974,   140,  1461,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,     0,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
    1003,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,  1004,   595,   211,   596,   597,   598,  1005,   600,
     601,   602,   603,     0,   604,   605,   606,  1451,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1007,
     223,     0,     0,  1008,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   978,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,  1009,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  1483,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
       0,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
    1573,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,  1786,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1817,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,  1819,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,  1913,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,  2419,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   999,   437,   974,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,     0,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,  1003,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
    1004,   595,   211,   596,   597,   598,  1005,   600,   601,   602,
     603,     0,   604,   605,   606,  1451,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1007,   223,     0,
       0,  1008,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   978,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,  1009,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   999,   437,   974,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
       0,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,  1003,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,  1004,   595,   211,   596,   597,   598,  1005,   600,   601,
     602,   603,     0,   604,   605,   606,  1451,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,  2175,   626,   627,   628,   629,     0,  1007,   223,
       0,     0,  1008,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   978,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,  1009,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   999,   437,   974,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,     0,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
    1003,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,  1004,   595,   211,   596,   597,   598,  2202,   600,
     601,   602,   603,     0,   604,   605,   606,  1451,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1007,
     223,     0,     0,  1008,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   978,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,  1009,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,     0,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,     0,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,     0,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,    86,    87,    88,    55,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2053,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,     0,    35,     0,   394,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,   154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     162,     0,     0,   164,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,   167,     0,   168,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   172,   173,     0,     0,     0,     0,     0,   175,
       0,   176,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,   180,   181,     0,   182,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
     190,     0,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   209,
       0,     0,   211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,   217,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,    86,    87,    88,    55,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2054,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,     0,    35,
       0,  1083,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
      86,    87,    88,    55,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,   154,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   162,     0,     0,   164,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   172,   173,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,   196,
     197,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,   217,     0,   218,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,   223,     0,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
       0,     0,   234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,    86,    87,    88,
      55,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   154,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   160,     0,     0,     0,     0,
       0,   162,     0,     0,   164,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   167,     0,   168,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   172,   173,     0,     0,     0,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,   190,     0,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   195,   196,   197,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     209,     0,     0,   211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,   217,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,   223,
       0,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,     0,     0,     0,    86,    87,    88,    55,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     0,     0,
       0,     0,     0,     0,    55
};

static const short yycheck[] =
{
       2,   152,  1097,   244,  1052,   165,   948,   949,  1052,     2,
    1001,   953,   854,  1259,  1054,   117,  1252,  1309,  1323,   151,
    1150,   148,    78,  1841,  1629,    78,   186,     2,   226,  1167,
    1160,    84,  1729,  1745,  1290,  1126,  1357,  1358,    78,  1004,
    1221,  1848,  1880,   169,   208,  2214,    78,   221,    78,    78,
    1386,   202,    84,    94,  1336,  1376,   230,   692,   160,  2639,
     362,   903,   362,  1662,  2246,  2027,  1116,  1008,  1527,  1528,
    1529,  1479,  1202,  2501,  2214,  2215,  1198,  1207,   132,  1778,
    2677,   348,   208,    78,  1214,  2968,  1764,    89,  2403,  1916,
    1764,   132,   117,  1223,  1764,  2830,  1764,  2832,  1802,  1613,
    2078,  1097,  2893,  2408,  2409,  1764,  1764,  2475,  2921,   214,
     151,  1656,  2414,   158,  3205,  3375,  3423,  1291,  1347,  1348,
    1582,  2123,  1244,  2087,  1282,  3395,   228,    21,   816,  1229,
    2921,  2084,  1049,  1130,    30,   160,  1049,   334,  1837,  1092,
    1093,    71,   348,  1372,    10,  1097,    73,    73,   117,   151,
      89,  1407,   147,    71,    98,  1016,    72,  2159,    73,   124,
     108,  2163,   169,  3101,    80,  2347,   854,   110,    89,  1577,
     920,  3897,  3445,   103,  3447,  2321,  2907,  2908,  2909,  2910,
    2911,  2912,   184,    78,    84,    76,    77,    78,    79,    84,
     165,   160,   126,   215,   252,    78,    76,    77,    78,    79,
     194,    84,   215,   228,   153,   153,   140,   143,    73,   196,
     102,   186,   215,   170,   252,   903,    73,   802,    73,   252,
    1077,   256,   117,   189,    89,    25,   165,   126,   102,   117,
      25,    73,    89,    71,   117,    76,    77,    78,    79,   210,
     222,    92,    71,  3726,  2426,   880,  2428,   186,   198,   244,
     136,    90,   187,   345,  1196,   163,  3889,   162,   117,   228,
      73,    72,    73,   250,   217,   160,   126,  1979,   227,    80,
     294,   133,   252,   133,   103,    89,   282,   160,   212,   220,
     140,   419,    96,    76,    77,    78,    79,   318,   350,    78,
     170,   117,   117,   174,    76,    77,    78,    79,   354,   419,
      78,   160,    76,    77,    78,    79,    76,    77,    78,    79,
    1275,    78,   207,   212,   354,   350,    22,    84,   207,   214,
      85,   216,   175,   282,   354,   354,  1464,   389,  2330,   170,
     362,   330,  3592,   228,   117,   160,   323,    89,   457,   412,
    1182,   414,   133,   396,    96,   228,   302,  4178,   207,   140,
     117,   160,   212,   348,   124,   214,   475,   216,   399,   354,
     359,    89,   500,   998,   396,   215,   319,    73,    96,   228,
     252,    37,   253,   379,   215,   437,   281,   170,   283,  1429,
     500,   809,   207,   811,  4017,    71,   294,   252,   370,   214,
     361,   216,   348,   160,   215,   252,  1732,   117,   826,  1720,
    1721,   234,  4233,   228,   293,   497,  1727,    73,   247,   343,
      76,    77,    78,    79,   421,   336,   419,   103,   442,   228,
     379,   849,   187,    76,    77,    78,    79,   221,   364,   460,
    1291,    76,    77,    78,    79,  3918,   230,   865,    38,   389,
      40,  1302,  1303,   501,   343,   432,  3706,    71,   248,   402,
    3263,   458,   387,   248,  1700,    76,    77,    78,    79,   439,
    1696,   228,   252,   501,   177,   500,   499,   362,    76,    77,
      78,    79,  3263,    76,    77,    78,    79,   365,   500,   362,
     429,   429,   808,   343,   497,  3745,   452,   813,  4214,  1718,
    1719,   412,  3765,   414,  1182,  1460,   396,  1726,   630,   433,
    3231,   396,   804,   497,   804,    76,    77,    78,    79,   400,
     401,   362,  2209,   396,    71,   407,   124,   843,    76,    77,
      78,    79,  1652,   374,  1654,   307,  2479,   484,   443,  1114,
    1280,  1712,   497,   407,   433,    76,    77,    78,    79,   365,
      76,    77,    78,    79,   430,   439,    76,    77,    78,    79,
    1688,    71,  3490,   497,   497,   482,   482,   419,   163,   500,
     476,   488,   489,   493,   500,   354,  1427,   893,   254,   255,
     497,  1693,   423,   433,   900,   493,   354,   443,   419,  1709,
     394,  1873,   365,   103,   437,  3845,  3166,   478,  1541,   630,
    1690,    71,  1544,  2192,   359,   362,  1513,   491,   478,   495,
    1513,   456,    76,    77,    78,    79,  1463,  2015,  1469,  1470,
    1467,  1468,   500,  2021,  2754,  1612,  2756,   482,   500,   305,
    2573,   175,   477,   488,   489,   482,  3357,   482,   630,   396,
     254,   488,   489,   488,   489,   477,   501,   478,    71,   170,
     482,  3911,   394,   484,   501,   365,   488,   489,   822,  4065,
     500,   692,   490,   491,   492,   493,  1747,  2659,   499,  1915,
    1916,   490,   491,   492,   493,   476,   394,   500,  2983,   482,
    1926,   482,  2987,  1929,   500,   488,   489,   447,   810,   500,
    1854,  1937,  1938,   457,  2646,   478,  1786,  1845,   130,   482,
    2872,  2873,   246,    29,  1950,  1951,   478,   254,   800,  2403,
    2664,   475,   302,   315,   478,  1961,  1134,  1135,   478,   252,
    2172,   501,  1941,  1942,   888,   847,    76,    77,    78,    79,
     314,  2867,   294,   497,  2870,  2871,   439,   497,  2874,   926,
     175,   882,    85,   353,   254,   252,  3923,    89,  2884,  4060,
    4061,  1598,   187,    76,    77,    78,    79,  1604,    76,    77,
      78,    79,   172,  2893,  4170,  3939,  4063,    71,   108,   217,
    2016,   217,   319,     0,   174,   897,  1194,   927,   326,   929,
      99,   931,   804,   421,   254,   800,   147,   937,   142,   384,
     500,  2921,  1210,  1211,   216,   959,    85,  1644,  4204,   103,
    1647,  1648,   837,   312,   447,  1637,    76,    77,    78,    79,
    1228,   234,   488,   489,   490,   491,   492,   493,   198,    14,
     458,   477,   478,   479,   480,   312,   482,  1508,   209,  1784,
     184,   254,   488,   489,   869,   478,  2966,   381,  1256,  1257,
     182,   800,   215,   478,   187,    83,   838,   170,  2383,   880,
    1697,  1783,   147,   253,   497,   117,  1172,  4168,   219,   178,
     381,  4038,  1026,  1179,   457,   217,   410,   478,   147,   170,
      14,   170,  3745,   319,   488,   489,   490,   491,   492,   493,
     478,  4131,   475,   315,   495,   478,   497,   497,   499,   410,
     230,   243,   923,   437,   234,   497,   319,   307,   187,   497,
     444,    71,  1883,  1884,   497,   340,  3350,  1002,  3200,   471,
     332,  1006,   456,   138,  1230,   800,   500,   478,   244,   804,
     164,   126,   317,   444,   219,    71,   374,   800,   920,   269,
     478,   804,   439,   103,   481,   456,   497,   920,   108,  2633,
     219,   488,   489,   490,   491,   492,   493,   478,  2650,    95,
    4124,   800,   478,   497,   179,   920,  1000,   338,   478,  1637,
     198,    97,   927,   138,   929,   170,   931,   998,   501,  1000,
     392,   963,   937,   938,   939,   218,   497,   497,   488,   489,
     490,   491,   492,   493,  3709,   800,   170,   330,   497,  1821,
    3560,  3561,  3562,   237,    76,    77,    78,    79,   927,   991,
     929,  1852,   931,   302,   179,  1027,   307,   999,   937,   389,
     497,  1003,  1004,  1005,   478,  1866,   359,  1591,   488,   489,
     490,   491,   492,   493,   808,   195,   101,    89,  2339,   813,
     273,   815,   294,   497,   170,   173,   820,   372,   822,  3846,
     389,   330,   419,   800,   828,  1619,   419,   804,  4129,  4130,
    3853,   391,   836,    76,    77,    78,    79,   841,   481,   843,
     230,   484,   485,   486,   234,   488,   489,   490,   491,   492,
     493,   366,  3853,  2158,   172,    76,    77,    78,    79,    76,
      77,    78,    79,   254,   254,   255,   173,   366,   437,    76,
      77,    78,    79,   231,  1077,  3902,   175,   302,   387,   269,
    1092,  1093,   307,   365,   888,  1097,   331,   484,   254,   893,
    2281,   484,  1077,   372,  1097,  1947,   900,  1002,   302,  3477,
     182,  1006,    87,    37,  4205,   387,   499,   182,   478,   184,
     215,  3436,  1097,  3263,   372,   305,  3441,  3432,   343,  3444,
     448,   106,  1027,  1821,   231,   374,   317,   497,  1077,   319,
     355,   389,  2741,  1002,  1027,   478,   331,  1006,   233,    73,
     478,   456,   497,  1092,  1093,   409,   410,   246,  1097,   412,
     954,   414,  2158,   319,  3310,   959,  1407,   456,   437,   497,
    3316,  3317,  3318,  3319,  3320,  3321,   970,  1002,   413,  3996,
      85,  1006,   376,  2429,   423,  2421,    91,  2368,  2369,  2370,
    2371,  3029,   104,   498,   302,  1197,   501,   450,   478,    76,
      77,    78,    79,   495,   252,  2066,   165,  1001,   118,   498,
     502,   391,   501,   125,    71,   110,   126,   497,   433,   215,
    3198,  3675,  3676,  3677,  3678,  3679,  1020,   330,   413,   361,
    3057,  3413,  1026,   218,  1501,  1502,  1292,  1504,   234,  2753,
    1668,  1669,  1670,  1671,  3841,  2923,   103,   312,  4131,  2923,
    1044,   108,  1292,  2923,  2510,  2923,   359,  2665,  1949,  1947,
    1027,  1317,  1292,  1292,  2923,  2923,   161,  1569,   227,  1569,
    1698,  1699,  3454,  1275,  3456,   349,  1704,  1279,  1280,  2983,
    1282,  1322,   187,  2987,  2141,   410,  1279,  1280,   273,  1282,
    1487,   140,   381,  2415,  4029,  1501,  1502,  1292,  1504,   373,
     307,   481,  2558,   342,  1279,  1280,   173,  1282,   488,   489,
     490,   491,   492,   493,    76,    77,    78,    79,  3017,    93,
      94,   170,  1317,   282,   456,   481,   285,   165,   484,   485,
     486,  2587,   488,   489,   490,   491,   492,   493,   484,   165,
     256,  1769,  1770,  1771,  1772,   175,  1341,  2952,   437,   495,
     245,   497,   498,   499,   500,  3783,   342,    76,    77,    78,
      79,  2411,   374,   273,   231,  1360,  2622,   940,   500,    76,
      77,    78,    79,   172,   138,  1477,   477,   234,  1172,  2635,
    2636,   482,   421,  4046,   321,  1179,   478,   960,   197,   227,
    1444,  1445,   138,   330,   497,  1390,    25,   254,   255,   294,
    2257,   227,   456,  1444,  1445,   497,    35,  1409,  2265,  3989,
    2267,   423,  1407,   294,  1842,   179,   246,  1419,    73,   458,
     379,    76,    77,    78,    79,   330,   235,   412,  1430,   414,
    1224,  1225,  1226,   179,   350,   421,  1230,   495,  2759,  2731,
     321,  2900,   241,   501,   282,   478,   500,  3762,   305,   330,
     175,   170,  1477,   302,   359,  4118,   282,   329,  1460,   285,
     381,  1463,   319,  4126,   497,  1467,  1468,   478,   374,   110,
    1463,   478,   458,   421,  1467,  1468,  1802,  2442,  1804,   372,
    1582,   478,   377,   456,   216,  1539,   497,  1813,  1463,   410,
    1522,  1523,  1467,  1468,   123,   182,  1521,   184,  1539,  1678,
     497,  3647,  3648,   302,  4167,   398,  1501,  1502,  1477,  1504,
      73,   470,   449,    76,    77,    78,    79,   423,   497,  1313,
     161,   246,  2157,   444,  1463,   165,   456,   500,  1467,  1468,
     501,    76,    77,    78,    79,   330,   350,  1569,   497,  1541,
    1533,   379,  1336,   330,  1576,   307,   360,    76,    77,    78,
      79,   500,    71,   379,  1880,   330,  1531,  1582,  1533,   163,
     330,   442,  1555,  1556,   359,   216,   170,   331,   363,   383,
     500,   162,   359,   141,  1549,  3744,   497,  1756,   303,   304,
    1555,  1556,  1477,  1762,   359,   331,   359,   227,  2996,   359,
     363,   242,   387,   330,  1477,   182,   426,   184,   501,   207,
    1779,   478,  1541,   171,   245,  1598,   257,   437,   216,  3571,
      41,  1604,   387,  1582,   387,   302,   267,   204,  1477,   248,
     497,   503,   359,  1598,   481,   312,  1521,  1522,  1523,  1604,
    3038,   488,   489,   490,   491,   492,   493,   206,  1521,  1522,
    1523,   210,   282,  3355,   470,   285,   330,   330,   239,   413,
    1891,  1644,  1477,   294,  1647,  1648,   381,  1759,  1660,  1598,
    2751,   456,  1521,    72,    73,  1604,   182,   413,   184,  1644,
     238,   497,  1647,  1648,  1569,   359,   359,   210,  3078,  1811,
    1474,  1576,     7,   456,   206,   410,  1569,  1582,   204,  2680,
     281,  1586,   283,  1576,    19,    20,   229,   248,   302,  1582,
      71,   270,  3102,   387,  1697,  1644,  3305,  2648,  1647,  1648,
    1477,  1606,   437,  3853,    39,  3123,   478,    42,   369,   444,
     307,  1895,  1697,  1582,  3870,   312,  3908,  1586,  1855,   126,
     376,   456,  3436,   175,  1759,   254,   377,  3441,   382,   379,
    3444,  2997,   439,   140,  1639,   314,  1910,  1606,   270,   457,
    1620,   123,   124,  1623,  1521,  1522,  1523,  1582,  1697,   478,
     210,  1586,  2604,  1765,  1127,   411,   410,   475,  3050,  3105,
    3106,   478,   497,   170,  2076,   172,  2076,  3584,   141,   229,
    1639,  1606,  1784,  1909,   206,    16,   302,  1150,   210,   497,
    1759,   307,   314,  1663,  2651,   399,   312,  1160,   402,   163,
     319,  3941,  1569,   196,   246,   378,   450,  1802,   171,  1576,
     456,   457,   500,   206,  1639,  1582,   504,   210,   143,  1794,
    3532,  2456,   477,   478,   479,   480,   282,   482,   260,   285,
     470,  1625,  3529,   488,   489,  2263,  3141,   498,   425,   382,
     501,   457,    51,  1845,   241,  1901,  1848,   434,   270,  2540,
    2541,   497,  1845,   484,  2545,  1848,  3112,   250,   183,   475,
      69,  1901,   304,  2557,  1759,  2559,  2560,   410,   499,   317,
    1845,  1901,  1901,  1848,   322,   238,  1759,   270,  1672,  2307,
    1982,   497,  1964,   254,   419,  1967,  2314,  2315,  2316,  2317,
    2318,  2319,   314,  2584,  2585,  4064,  1891,   359,  1692,   317,
    1759,   363,   376,    34,   322,   302,  1901,   450,   313,   425,
     307,   497,   317,   495,   477,   478,  2604,   499,   434,   482,
      71,   314,   163,   379,  3245,   387,   489,   140,   423,  1152,
     323,  1154,  1934,   478,  1759,   500,   501,   411,  1161,   381,
    2100,   376,  3234,  3235,    95,   378,   343,   500,   319,   478,
     361,   504,  1927,  1928,   492,   456,   457,  1982,   355,   497,
    1935,   499,   481,    71,  1939,  1940,   485,   486,   410,   488,
     489,   490,   491,   492,   493,   498,   411,   346,   501,  1954,
    2922,  1956,   456,   457,   144,   496,  2674,    95,   411,   500,
     237,  1986,  1759,   502,   456,   437,   412,  2425,   414,  2427,
    2965,  1976,   444,  1978,   139,   218,    71,   495,  1802,   497,
    1804,   499,   115,  1982,   456,   481,   381,     5,    73,  1813,
     492,   456,   457,   497,   237,   497,   495,   499,   497,   497,
      95,   499,  1826,   456,   457,  3739,   433,    25,   498,   432,
     500,  1835,  2174,  2045,  2076,   410,   498,    35,   500,  3887,
     496,   229,  2027,  3191,   500,   497,   191,   128,  3762,   162,
     273,   498,   497,   500,   488,   489,   490,   491,   492,   163,
    2172,  2124,   496,  2126,   497,   146,   497,  2403,   499,   444,
     490,   491,   492,   498,   114,   500,  1880,  1982,   159,  1883,
    1884,   456,  2124,   378,  2126,  2090,  3326,  3327,   260,  1982,
    3330,  1895,  3332,   254,   498,   498,   500,   372,   373,   322,
     481,   372,   373,   484,   485,   486,  2157,   488,   489,   490,
     491,   492,   493,  1982,   503,  2100,  3838,   482,   263,   264,
     500,   501,   497,   236,   252,   123,  2238,   317,   498,   210,
     500,   276,   498,  2145,   500,   497,   254,  2172,  2141,   151,
    3241,   498,   498,   500,   500,   497,  2158,  1982,  2160,   901,
    2162,  2100,  2403,   905,   114,  2158,  2141,  2160,   319,  2162,
     498,   104,   500,   915,   498,   498,   500,   500,   281,   472,
     283,  2076,   498,  2158,   500,  2160,   498,  2162,   500,   254,
    4008,   294,  4010,  2076,   498,   330,   500,   256,   186,   412,
    2202,   414,  2141,  2172,   499,  2893,  2145,   498,   320,   500,
     423,   319,   317,  2238,   216,  1982,   498,  2011,   500,  2158,
     433,   498,   498,   500,   500,   320,   329,  2354,   419,  2124,
    3934,  2126,   472,  2921,     8,  3540,   317,    11,    12,   104,
     242,  2124,  2036,  2126,  3425,  2270,   456,   457,    22,    23,
      24,   320,    26,    27,   319,   257,   472,    31,    32,    33,
     248,   364,   256,  3519,  2257,   267,   498,   490,   500,  2238,
     214,   498,  2265,   500,  2267,   500,   411,  2172,   413,   412,
     497,   414,  2257,   488,   489,   490,   491,   492,   290,  2172,
    2265,  2085,  2267,   498,   397,   412,   498,   414,   500,  1266,
     498,  2270,   500,   498,   498,   500,   500,  2633,   387,  2076,
    1277,  2313,   498,  2172,   500,   317,    72,    73,  2257,  2321,
      76,    77,    78,    79,    80,   498,  2265,   500,  2267,   498,
     481,   500,   498,   484,   485,   486,   114,   488,   489,   490,
     491,   492,   493,  2238,   473,   474,  2587,  2172,   498,   498,
     500,   500,   498,  4057,   500,  2238,   498,  2124,   500,  2126,
     498,   498,  2337,   500,   498,  2367,   500,   369,   498,  3661,
     500,   456,   457,   481,     2,  2270,   484,   485,   486,  2238,
     488,   489,   490,   491,   492,   493,   501,  2270,  2390,   163,
     490,   498,  3083,   500,   503,  3086,  3087,  3088,  3089,  3090,
    3091,  3092,  3093,  3094,  3095,  2172,    85,   503,  2403,   151,
     248,  2270,    91,  2238,   170,  2456,   481,  2681,  2682,   484,
     485,   486,   419,   488,   489,   490,   491,   492,   493,   419,
    2628,  2629,   196,  1046,   498,  1048,   500,   439,  1327,  1328,
    2442,  2235,   206,  2683,  2684,  2270,   210,   147,   497,   419,
      78,   130,  3143,  3144,   419,   498,    84,   500,   498,   498,
     500,   500,   498,  2565,   500,   498,   419,   500,  2570,   169,
     498,  2238,   500,    72,   216,   175,   193,    76,    77,    78,
      79,    80,   498,    98,   500,    85,   250,  3792,   498,   117,
     500,    91,   498,   114,   500,   251,  2988,   248,  2990,   199,
     242,   180,   498,  2270,   500,   498,   270,   500,   187,  1094,
    1095,   190,   498,   287,   500,   257,   439,   273,  1260,   498,
    4125,   500,   498,   151,   500,   267,  3656,   498,   254,   500,
     130,   498,   160,   500,   498,  3575,   500,   498,   419,   500,
    2565,   498,   498,   500,   500,  2570,   246,   498,   290,   500,
     314,   498,   498,   500,   500,   459,   498,  2351,   500,   323,
     239,   498,   498,   500,   500,   339,   165,  3823,   497,   499,
     497,   497,  1314,   317,   499,  3263,    71,   210,   268,   207,
     180,   501,   439,  1325,   317,  3877,   214,   187,   216,   317,
     190,  2385,  2587,   311,   497,  1337,  2565,   378,  2392,   260,
     228,  2570,   497,   126,   456,    98,  2601,   497,   103,  2403,
     459,   428,   104,   108,   104,   294,   330,   210,   260,   502,
     439,   200,   200,   497,   200,  2620,   459,   369,   227,   200,
     200,   500,    71,   200,   200,   200,   317,   200,  2633,   239,
     200,   200,   317,   200,   200,    98,   497,   211,   268,  2651,
     497,   330,   210,   497,   428,   210,   497,  2983,  2651,   339,
     497,  2987,   497,  3968,   103,   497,   497,   497,   432,   108,
    2565,  2646,   497,   497,  2649,  2570,  2651,  3368,   327,   497,
     359,   381,  2565,   282,   363,   497,   285,  2570,   497,   497,
     497,   497,   497,   497,   294,   497,  4001,   497,   497,   497,
    4005,  4006,   497,  3029,   497,   497,  2565,   497,   387,   500,
     410,  2570,  2651,    98,   268,   153,  3972,   254,    98,   210,
     476,   477,   478,   210,   490,   379,   482,   248,   500,   169,
     330,   438,   488,   489,   362,   230,  3578,   437,   285,   234,
    2565,    37,   500,   484,   444,  2570,    14,   500,   497,   497,
     497,   419,  1494,   419,   499,    85,   456,  4003,   380,   254,
     255,    91,   419,   363,   419,  3707,  4002,   419,   396,   317,
     133,   419,   419,   307,   269,   419,   438,   317,   239,   419,
     379,   419,   497,   439,   500,   330,   439,   387,  2939,   419,
     419,   230,   419,   114,   114,   234,   419,   497,  2565,   497,
     130,   419,   321,  2570,   376,  2830,  2831,  2832,   419,   419,
     305,   419,  2814,   419,   419,   254,   255,   419,  2920,   317,
     317,   254,   456,   497,   319,  2976,  4082,   497,   447,    98,
     269,    97,   497,  2627,  2836,    87,   170,   450,  1805,  2633,
     449,  2973,  2817,  3534,  3535,   439,   276,  1814,    98,   210,
     180,   317,   497,    98,   200,  1822,  1823,   187,   499,   377,
     190,  2830,  2831,  2832,   453,  2867,   305,   200,  2870,  2871,
     439,   470,  2874,  1840,   200,   200,    14,   476,   439,   478,
     319,   419,  2884,   500,  2940,   366,  2680,  2889,   306,   417,
    3578,  2893,   444,   215,   497,  2920,   391,  2899,   472,  2955,
    2893,   452,    71,   287,   287,   500,   417,   387,   215,   239,
    3151,   497,   497,   419,   319,   498,   500,   421,  2893,  2921,
    2976,   250,   484,  2898,  2899,   500,   228,   228,  2921,   318,
     312,  3922,  2934,   270,   484,  2830,  2831,  2832,    34,    10,
    3988,   419,   419,   139,  3988,  2940,  2921,  2830,  2831,  2832,
    4186,  2920,   391,   376,  2893,  3153,  3154,  3155,  3156,   500,
    2955,   497,  2964,  2965,   294,   498,   498,   498,   258,   258,
     497,  2830,  2831,  2832,   110,   307,   307,   317,   500,   307,
    3036,  2976,  2921,   324,   419,   359,   481,   359,  2983,   484,
     485,   486,  2987,   488,   489,   490,   491,   492,   493,   315,
     330,   359,   630,   384,   419,  2830,  2831,  2832,   419,    98,
     254,   350,   254,   254,  3116,  3857,   152,   439,   439,   254,
     254,   315,   484,    97,   495,  2920,   116,   495,   419,   359,
     210,   419,   484,   363,   212,   384,   199,  2920,   497,    98,
     176,  3036,   481,   317,   223,   491,   485,   486,   210,   488,
     489,   490,   491,   492,   493,   226,   146,   387,   226,   195,
     497,  2920,    98,  2830,  2831,  2832,   500,   200,   317,   317,
    4165,   384,   410,  1815,   500,   211,   481,    86,   210,   484,
     485,   486,  1824,   488,   489,   490,   491,   492,   493,   225,
     459,  3116,   220,   284,  1836,  2920,   317,  3788,   500,   114,
     498,   498,   498,   215,   498,   498,   498,   472,  2075,   215,
    3436,   498,   202,   472,   500,  3441,  3276,    14,  3444,   498,
     498,  3812,  3813,   498,   497,  3127,  4221,   498,   498,   453,
     498,   498,   498,   419,   498,   497,  1878,   326,  2932,  1881,
    1882,   206,   232,  1885,   501,  4087,    85,  3116,  2942,   500,
     498,  4246,    91,  2920,   498,   500,  3151,   484,   442,   270,
    3262,   497,  3264,   419,  2958,  3853,   244,  3169,   307,  3857,
     270,   307,   800,   334,   497,   334,   804,   436,   279,   315,
     808,   419,   279,   419,   279,   813,   419,   419,   419,  2983,
     419,   130,   419,  2987,   419,   495,   254,   254,   254,   254,
     254,   254,  1949,   254,   285,   498,  3634,   498,   270,   484,
     428,   321,   348,   361,   163,   843,   497,  3011,   498,   317,
    3014,  3116,   500,   315,   419,   439,   317,  3021,   498,   257,
     497,   325,   257,  3116,   497,  3029,   312,  3262,   439,  3264,
     330,   180,   439,  3218,   198,   320,   500,   198,   187,   495,
     193,   190,   215,    71,   210,   498,  3050,  3116,   886,   498,
     124,  3263,  2009,   449,   222,   893,  3291,   215,   498,   359,
    3263,   497,   900,   363,   498,  3277,  3967,   367,   500,   484,
     484,   498,  3284,   373,  3286,   497,   318,   244,  3263,   498,
     380,  3116,   920,  3262,   484,  3264,   419,   387,   428,   428,
     239,  3276,   419,   419,   419,   395,   498,   210,  3310,   254,
     498,   498,  1200,   403,  3316,  3317,  3318,  3319,  3320,  3321,
     254,   496,  3291,   497,  3263,   258,    98,   497,   459,    98,
     456,   210,   456,   240,   135,   456,   500,  3276,   411,   497,
     497,   481,   497,   257,   497,  3338,   498,   116,  3350,  3116,
     384,   497,   219,   215,   498,   294,   215,  3359,  3360,  3361,
    3362,   451,  3337,  3338,  3158,  3159,   454,  3262,   996,  3264,
     497,  3346,   454,   498,  1002,  3350,   498,   146,  1006,  3262,
     500,  3264,   114,   224,  3359,   428,   307,   307,   200,   254,
     177,   330,   500,   500,   307,   172,  3291,   484,   241,  1027,
     217,   215,   439,  3262,   439,  3264,   188,  1035,  3291,  3411,
     496,   199,   497,  3739,   498,   259,   215,   497,   419,   210,
     359,   320,  3582,   215,   363,   497,   443,   497,  3588,   497,
     396,   498,  3291,   202,   498,  1323,  3762,  3262,   333,  3264,
     355,  3436,  3602,   455,   439,   497,  3441,   497,   387,  3444,
     498,   456,   210,  2420,   500,    98,   307,   280,   237,   347,
     163,   373,   373,   232,   126,   320,  3291,  2434,  2435,   126,
     484,  2438,   114,   323,   210,   411,   318,  2444,  2220,   317,
     205,   320,   456,   320,   481,   116,    98,   500,   443,    98,
     353,   260,   500,   188,   456,  3262,   317,  3264,   317,    98,
     183,   497,   372,   497,   116,  3933,   498,   175,   437,   199,
    3938,  3939,   372,    84,    95,   146,   347,   497,   354,  2353,
    1468,  2651,  2244,  3683,  3291,  4123,  2764,  3262,  2889,  3873,
    3856,  3398,  3401,  2223,   146,  3250,  2503,  3700,  2728,  2461,
    4149,  4185,  4112,  4111,  1172,  4157,  1780,  3403,  2956,  2192,
    3291,  1179,  3410,  2831,  1766,  2341,  2933,  4246,  4221,  3669,
    3668,  3887,  3356,  2920,  4164,  2892,  3859,  1757,  4094,  3571,
    3572,   202,  1200,  3862,  3934,   186,  1315,  3470,  3571,  4057,
    3374,  4009,  3584,  4011,  3412,  2215,  3416,  4064,  4209,  4245,
     202,  3584,  3386,  1017,   363,  3909,  3571,   163,   367,  2085,
    1498,   232,  1230,  1292,   373,  2662,  3037,  3582,  3934,  3584,
    3396,   380,  2454,  3588,  1292,  1493,  3465,  1037,   387,  2671,
     232,  2118,  2685,  2117,  3582,  3217,   395,  3602,  2103,  1511,
    4058,  2633,  2079,  2989,   403,  3610,  3611,  2403,  3763,  2663,
    3615,  3616,  3436,  3582,  3393,  3647,  3648,  3441,   260,  3588,
    3444,  1279,  1280,  3126,  1282,  3711,  3658,  3659,  3970,  3118,
    3662,  3663,  1290,  3602,  4143,   888,  1026,  4147,  4144,  2674,
    2601,  2512,  2599,  3675,  3676,  3677,  3678,  3679,  2480,  2012,
    1292,  2396,   451,   630,  3709,  2973,   455,  4115,  2145,  1235,
    1578,  4137,  1796,   363,  1523,  1323,  4124,  1517,    71,  1115,
    3675,  3676,  3677,  3678,  3679,  1095,   922,  2121,  3683,  2158,
    4036,  2151,  2645,  2152,  3221,  3717,  3711,  1345,  1322,  3222,
    1441,  3196,  3570,  2465,  1521,  1872,  4154,  2457,   395,     2,
     103,  4057,   363,  2162,   365,   108,   367,  3449,    -1,    -1,
    3709,  3743,   373,    -1,  3683,  1373,    -1,  1635,    -1,   380,
    1279,   363,    -1,    -1,    -1,   367,   387,  3551,  3552,  3553,
    3554,   373,    -1,    -1,   395,  2732,    -1,  3762,   380,    -1,
      -1,    -1,   403,    -1,    -1,   387,  1404,  1405,    -1,  1407,
      -1,    -1,    -1,   395,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   403,  1420,  2540,  2541,    -1,  1424,    -1,  2545,    -1,
      -1,    -1,    -1,  2770,  2771,    -1,  1694,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3709,    -1,    -1,    -1,    -1,    -1,
     451,    -1,   195,  1711,  4150,    -1,  3709,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1463,    -1,  2584,  2585,   451,
    3833,    -1,    -1,   455,   456,    -1,    -1,    -1,  1476,  1477,
    3709,  3853,    -1,    -1,    -1,    -1,    -1,   230,  3833,    -1,
    3853,   234,    -1,    -1,    -1,    -1,  1754,    -1,  3870,    -1,
      -1,    -1,  3874,    -1,    -1,  1503,    -1,    -1,  3853,  1507,
    1508,   254,   255,    -1,  3709,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1521,  1522,  1523,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3962,    -1,    -1,  4235,
      -1,    -1,    -1,    -1,  3853,  2540,  2541,    -1,    -1,    -1,
    2545,    -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,  3931,
      -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,   814,
      -1,  1569,  3709,   818,    -1,  3739,   319,    -1,  1576,    -1,
    1578,    -1,   827,    -1,  1582,    -1,    -1,    -1,  1586,  2584,
    2585,    -1,    -1,    -1,    -1,    -1,    -1,  3962,  3762,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   852,  1606,    -1,
      -1,   856,    -1,    -1,  4225,  1613,    -1,    -1,    -1,    -1,
      -1,    -1,   867,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4029,    -1,    -1,  1635,    -1,    -1,
     815,  1639,    -1,    -1,    -1,   820,    -1,    -1,   391,    -1,
      -1,    -1,    -1,   828,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   836,    -1,    -1,  3001,    -1,   841,    -1,  3005,    -1,
    3007,    -1,  3009,  3010,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3018,    -1,    -1,    -1,    -1,    -1,  2799,    -1,    -1,
    4029,    -1,  3856,    -1,    -1,    -1,  1694,    -1,    -1,    -1,
      -1,    -1,    -1,  2815,    -1,    -1,    -1,  2819,    -1,    -1,
      -1,    -1,    -1,  1711,  3051,    -1,    -1,    -1,    -1,    -1,
      -1,  4066,  1980,  3887,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1729,  3896,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,    -1,    -1,    -1,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,  1754,  4066,  3922,    -1,
      -1,  1759,    -1,    -1,  4029,    -1,    -1,    -1,    -1,    -1,
    3934,    -1,    -1,    -1,    -1,    -1,  4029,    -1,    -1,   954,
      -1,    -1,  3946,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4165,    -1,   970,    -1,    -1,    -1,    -1,
    4029,    -1,  4165,    -1,  1802,    -1,  1804,    -1,    -1,    -1,
      -1,    -1,  1810,    -1,    -1,  1813,    -1,    -1,    -1,    -1,
    4165,    -1,    -1,    -1,    -1,    -1,  1001,    -1,    -1,    -1,
      -1,  3995,    -1,    -1,  4029,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4209,  1020,    -1,  1845,    -1,  4221,
    1848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4221,    -1,
    4225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1044,
      71,    -1,  4036,    -1,  4246,    -1,  4221,    -1,    -1,    -1,
    4245,    -1,  1880,  4246,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4029,  4057,    95,    -1,    -1,    -1,    -1,    -1,
      -1,  4246,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3027,    -1,  1915,  1916,    -1,
      -1,    -1,    71,    -1,    -1,  1923,    -1,    -1,  1926,    -1,
      -1,  1929,    -1,    -1,    -1,    -1,  1934,  3049,    -1,  1937,
    1938,    -1,    -1,    -1,    -1,    -1,    95,  1945,    -1,    -1,
    1948,  1949,  1950,  1951,   103,    -1,    -1,    -1,    -1,   108,
    1958,  1959,    -1,  1961,    -1,  1963,  3083,    -1,  1966,  3086,
    3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,    -1,
      -1,    -1,  1980,  1981,  1982,    -1,  4150,  1985,    -1,    -1,
      -1,  1989,    -1,    -1,    -1,  1993,    -1,    -1,  1996,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,    -1,  2006,    -1,
      -1,    -1,    -1,    -1,  2012,    -1,    -1,    -1,  2016,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3143,  3144,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    -1,    -1,  1224,
    1225,  1226,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    95,
      -1,  4235,    -1,  2331,    -1,    -1,    -1,   103,  2076,    -1,
      -1,   230,   108,    -1,    -1,   234,    -1,    -1,  3083,  2087,
      -1,  3086,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,
    3095,   302,    -1,    -1,   305,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3452,    -1,    -1,   319,    -1,
     269,   322,  3459,  3460,    -1,    -1,  2124,    -1,  2126,    -1,
      -1,    -1,    -1,    -1,    -1,   147,    -1,    -1,  1313,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3143,  3144,
      -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,
      -1,  1336,  2160,    -1,  2162,    -1,  3278,  3279,    -1,    -1,
     319,    -1,    -1,   322,  2172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,    -1,
     391,  2189,    -1,    -1,   206,    -1,    -1,    -1,   210,    71,
      -1,    -1,    -1,   215,   230,    -1,    -1,   219,   234,    -1,
     222,  2209,   224,    -1,    -1,    -1,  2214,  2215,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   254,   255,
      -1,   103,    -1,  2491,    -1,    -1,   108,    -1,   250,    -1,
    2238,    -1,   391,   269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3368,    -1,    -1,    -1,    -1,    -1,    -1,   270,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2270,    -1,    -1,    -1,   302,    -1,    -1,   305,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,   319,    -1,   496,   322,    -1,    -1,  1474,
      -1,   502,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,    -1,    -1,    -1,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2329,   481,  2331,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,   103,    -1,
      -1,   500,    -1,   108,   366,    -1,    -1,    -1,   230,    -1,
      -1,    -1,   234,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2393,    -1,   269,   410,    -1,
      -1,    -1,    -1,    -1,    -1,  2403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2413,    -1,  3534,  3535,    -1,
     432,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     302,  1676,    -1,   305,  3771,    -1,  3773,  3774,    -1,    -1,
     195,   453,    -1,   455,   456,  3782,    -1,   319,    -1,    -1,
    1625,    -1,  2450,    -1,    -1,   481,    -1,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    71,    -1,    -1,   500,   230,    -1,    -1,    -1,   234,
      -1,    -1,  2480,   495,    -1,    -1,   498,   499,    -1,   501,
      -1,    -1,    -1,  2491,    -1,    95,    -1,  1672,    -1,   254,
     255,    -1,    -1,   103,    -1,  2763,    -1,    -1,   108,    -1,
      -1,    -1,  2510,  2511,   269,    -1,    -1,  1692,  1763,   391,
    3632,  3633,    -1,  3635,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1778,    -1,    -1,  2794,    -1,  2796,  3534,
    3535,    -1,  2540,  2541,    -1,    -1,    -1,  2545,    -1,    -1,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2557,
    2558,  2559,  2560,    -1,   319,    -1,    -1,  2565,    -1,    -1,
      -1,  2569,  2570,    -1,  2572,    -1,  2574,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2584,  2585,    -1,  2587,
      -1,    -1,  1837,    -1,    -1,   116,    -1,    -1,    -1,    -1,
      -1,    -1,  2600,    -1,  2602,    -1,    -1,    -1,  2606,   481,
    2868,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,  2622,   146,    -1,    -1,  3965,    -1,
     230,    -1,    -1,    -1,   234,  2633,   391,  2635,  2636,  2637,
      -1,    -1,    -1,  3755,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1826,    -1,  3765,   254,   255,    -1,  2655,    -1,    -1,
    1835,    -1,    -1,    -1,    -1,    -1,  2664,    -1,    -1,   269,
      -1,  3788,    -1,  2671,    -1,    -1,    -1,    -1,  2676,  2937,
      -1,   202,    -1,    -1,    -1,  2683,  2684,  2685,    -1,    -1,
      -1,    -1,    -1,  2951,    -1,  3812,  3813,    -1,    -1,    -1,
      -1,    -1,   302,    -1,    -1,   305,    -1,    -1,  1883,  1884,
      -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,   481,    -1,    -1,  2727,
      -1,    -1,    -1,   488,   489,   490,   491,   492,   493,   260,
      -1,    -1,    -1,    -1,  3002,    -1,    -1,    -1,    -1,    71,
      -1,    -1,    -1,    -1,    -1,  2753,  2754,    -1,  2756,    -1,
      -1,    -1,    -1,    -1,    -1,  2763,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,
      -1,   391,    -1,  3788,    -1,    -1,  2794,    -1,  2796,    -1,
      -1,    -1,    -1,    -1,    -1,  3063,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3812,  3813,    -1,
      -1,    -1,    -1,    -1,  3082,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2830,  2831,  2832,    -1,  2011,    -1,    -1,    -1,
    3952,    -1,   363,    -1,    -1,    -1,   367,    -1,    -1,  3107,
    3967,    -1,   373,    -1,    -1,    -1,    -1,    -1,    -1,   380,
      -1,  2036,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,
    2868,    -1,    -1,   195,   395,    -1,    -1,    -1,    -1,    -1,
      -1,   481,   403,  3141,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,  2892,  2893,    -1,    -1,   498,    -1,
    4012,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,
    2085,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2920,  2921,  2169,    -1,    -1,    -1,  2173,    -1,
     451,    -1,   254,   255,   455,    -1,    -1,    -1,    -1,  2937,
      -1,    -1,    -1,  2188,    -1,    -1,    -1,   269,    -1,    -1,
      -1,  2196,    -1,  2951,    -1,    -1,    -1,    -1,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2966,    -1,
      -1,    -1,  3967,    -1,  2219,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,   305,    -1,  2983,    -1,    -1,    -1,  2987,
     103,  2236,    -1,    -1,    -1,   108,    -1,   319,    -1,  2997,
      -1,    -1,    -1,    -1,  3002,    -1,  2251,    -1,  2253,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2271,    -1,    -1,    -1,
      -1,  3029,    -1,  2278,    -1,    -1,    -1,    -1,    -1,    -1,
    2285,    -1,    -1,    -1,    -1,    -1,    -1,  2292,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2235,    -1,  3060,    -1,    -1,  3063,    -1,    -1,    -1,   391,
      -1,  3069,    -1,    -1,    71,    -1,    -1,  3075,    -1,  3077,
      -1,    -1,    -1,    -1,  3082,  3083,    -1,    -1,  3086,  3087,
    3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,    95,    -1,
      -1,  3099,  3100,    -1,    -1,    -1,   103,    -1,    -1,  3107,
      -1,   108,    -1,    -1,  3112,    -1,    -1,   230,  3116,    -1,
    3118,   234,    -1,  3381,    -1,    -1,    -1,    -1,    -1,    -1,
    3128,    -1,    -1,  3131,    -1,  3133,    -1,    -1,    -1,    -1,
      -1,   254,   255,  3141,  3142,  3143,  3144,    -1,    -1,    -1,
    3148,    -1,    -1,  3151,    -1,    -1,   269,    -1,    -1,   481,
      -1,    -1,    -1,  3161,    -1,    -1,   488,   489,   490,   491,
     492,   493,  3170,    -1,    -1,    -1,  2351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,
      -1,    -1,   305,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    94,    -1,    96,    -1,   319,    -1,    -1,   322,
    2385,    -1,    -1,    -1,   106,    -1,    -1,  2392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2473,    -1,
      71,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,    -1,    71,    -1,    95,    -1,  2501,   254,   255,   151,
     152,    -1,   103,   155,  3262,  3263,  3264,   108,    -1,   161,
      -1,    -1,   269,   165,    -1,    -1,    95,   169,   391,    -1,
      -1,    -1,  3540,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,   183,    -1,  3291,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
     202,    -1,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,    -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,
      -1,    -1,    -1,   235,    -1,    -1,  3604,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3612,    -1,    -1,    -1,    -1,    -1,
      71,    72,    -1,    -1,    -1,    -1,    -1,    -1,   481,    80,
    3368,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,  3381,    95,   498,    -1,    98,    -1,   230,
      -1,    -1,   103,   234,   391,    -1,    -1,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,   254,   255,   234,    -1,    -1,  3416,  3417,
    3418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   255,    -1,  3436,    -1,
      -1,    -1,    -1,  3441,    -1,    -1,  3444,    -1,    -1,    -1,
     269,    -1,  2627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,  2716,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,   322,    -1,   302,   481,  3483,   305,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
     319,   498,    -1,   322,    -1,  2680,    -1,   399,    -1,  3767,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
      -1,  3519,    -1,   234,    -1,    -1,    -1,    -1,  3526,  3527,
      -1,  3529,    -1,    -1,  3792,    -1,  3534,  3535,    -1,    -1,
      -1,  3539,  3540,   254,   255,    -1,    -1,  3545,  3546,    -1,
     391,  3549,  2797,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3569,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3584,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3604,    -1,   319,    -1,
      -1,   322,    -1,    -1,  3612,    -1,    -1,  2862,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,   498,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3699,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
    3968,  3709,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,   630,    -1,
     103,  3739,    -1,  4001,    -1,   108,  3744,  4005,  4006,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2932,    -1,    -1,
    3758,    -1,    -1,    -1,  3762,   476,    -1,  2942,    -1,  3767,
     481,    -1,  3017,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,  2958,    -1,  3030,   678,   679,    -1,    -1,
    3788,    -1,    -1,    -1,  3792,    -1,    -1,    -1,    -1,    -1,
     692,    -1,    -1,    -1,    -1,    -1,    -1,  3052,    -1,    -1,
      -1,    -1,    -1,    -1,  3812,  3813,    -1,    -1,  3816,    -1,
      -1,    -1,    -1,    -1,    -1,  3823,  3824,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3011,    -1,    -1,  3014,
      -1,    -1,    -1,    -1,    -1,    -1,  3021,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3853,    -1,    -1,  3856,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,
      -1,   234,    -1,    -1,    -1,  3050,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3887,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   809,   810,   811,
      -1,    -1,   814,    -1,   816,    -1,   818,   819,    -1,   821,
      -1,   823,    -1,   825,   826,   827,  3934,  3935,    -1,   302,
      -1,    -1,   305,  3941,   836,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   844,    -1,    -1,   847,   319,   849,    -1,   322,
     852,    -1,   854,    -1,   856,   857,   858,   859,    -1,  3967,
    3968,   863,  3970,   865,  3972,   867,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3158,  3159,    -1,    -1,    -1,   880,    -1,
     882,    -1,    -1,    -1,  3239,    -1,    -1,    -1,    -1,    -1,
    3998,    -1,   894,  4001,    -1,   897,    -1,  4005,  4006,   901,
      -1,   903,    -1,   905,   906,    -1,    -1,   909,    -1,   911,
      -1,   913,    -1,   915,    -1,    -1,   918,    -1,   391,    -1,
      -1,  4029,    -1,    -1,    -1,    -1,    -1,    -1,  4036,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,   940,   941,
      -1,    -1,    -1,  3298,    -1,  3300,    -1,    -1,    -1,  4057,
      -1,    -1,    -1,    -1,    -1,    71,  4064,    -1,  4066,    -1,
      95,    -1,    -1,    -1,   966,    -1,   968,    -1,   103,   971,
      -1,    -1,    -1,   108,  4082,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,   108,    -1,    -1,    -1,   998,    -1,  1000,    -1,
      -1,    -1,  1004,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,  1031,
      -1,    -1,    -1,    -1,    -1,  1037,    -1,    -1,    -1,    -1,
      -1,    -1,  4150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3356,    -1,    -1,    -1,    -1,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3374,
    1092,  1093,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,  3386,    -1,  1105,    -1,  1107,    -1,    -1,   103,  1111,
      -1,    -1,    -1,   108,   230,  3470,    -1,    -1,   234,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,  4235,    -1,    -1,
      -1,    -1,  1134,  1135,   269,    -1,    -1,    -1,   254,   255,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,
    1162,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,   147,
     305,    -1,    -1,  1175,    -1,    -1,    -1,    -1,    -1,    -1,
    1182,    -1,  1184,    -1,   319,    -1,   302,   322,  1190,   305,
      -1,    -1,  1194,    -1,    -1,    -1,    -1,    -1,    -1,  1201,
     195,    -1,    -1,   319,    -1,    -1,   322,    -1,  1210,  1211,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1228,  1229,   206,  1231,
    1232,    -1,   210,    -1,    -1,   230,    -1,   215,    -1,   234,
      -1,   219,    -1,    -1,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,  3608,  1256,  1257,   391,    -1,  1260,   254,
     255,    -1,    -1,    -1,  3619,    -1,  3551,  3552,  3553,  3554,
      -1,    -1,   250,  1275,   269,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   270,    -1,    -1,    -1,    -1,    -1,    -1,  1301,
      -1,    71,    -1,    -1,    -1,    -1,  1308,  1309,    -1,    -1,
     305,    -1,  1314,  1315,    -1,    -1,    -1,    -1,  1320,    -1,
      -1,    -1,    -1,  1325,   319,    95,    -1,    -1,    -1,    -1,
      -1,  1333,    -1,   103,    -1,  1337,   314,  1339,   108,    -1,
      -1,    -1,    -1,    -1,    -1,   323,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,   498,    -1,   481,  1200,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,   498,    -1,    -1,    -1,    -1,    -1,   366,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3783,    -1,
      -1,    -1,   410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1444,  1445,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   432,    -1,    -1,    -1,  1460,    -1,
     230,    -1,    -1,    -1,   234,  1467,  1468,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   453,    -1,   455,   456,    -1,
      -1,  1483,    -1,  1485,   254,   255,   481,    -1,    -1,  1323,
      -1,  1493,  1494,   488,   489,   490,   491,   492,   493,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,    -1,    -1,
     498,   499,    -1,   501,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,   302,    -1,    -1,   305,    -1,  1539,    -1,  1541,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,   319,
      -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,    35,    36,
      -1,    -1,    -1,    -1,    41,    -1,    43,    44,    -1,  1571,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,  1596,    72,    -1,    74,    -1,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3896,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,  1637,    -1,  3922,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
      -1,  3946,    -1,    -1,    -1,   103,  1668,  1669,  1670,  1671,
     108,    -1,    -1,    -1,  1676,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1690,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1698,  1699,    -1,    -1,
      -1,    -1,  1704,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3995,   481,    -1,    -1,   484,   485,   486,   194,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,    -1,
     227,    -1,    -1,  1755,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1763,    -1,    -1,    -1,  1767,    -1,  1769,  1770,  1771,
    1772,   248,    -1,    -1,    -1,    -1,  1778,    -1,    -1,  1613,
      -1,    -1,  1784,    -1,  1786,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,  1635,    -1,    -1,    -1,   282,    -1,    -1,   285,  1811,
    1812,    -1,    -1,  1815,  1816,    -1,   254,   255,    -1,  1821,
      -1,    -1,  1824,  1825,    -1,  1827,    -1,  1829,    -1,    -1,
     307,   269,  1834,    -1,  1836,  1837,    -1,    -1,    -1,  1841,
    1842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1856,  1857,    -1,    -1,    -1,    -1,
    1694,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,  1873,    -1,    -1,    -1,    -1,  1878,  1711,    -1,  1881,
    1882,   319,    -1,  1885,   322,    85,    -1,    -1,    -1,  1891,
      -1,    91,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,
      -1,    -1,   379,    -1,    -1,    -1,    -1,  1909,  1910,    -1,
      -1,  1913,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
    1754,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   419,    -1,    -1,  1947,    -1,    -1,    -1,    -1,
      -1,    71,    -1,   391,    -1,   432,    -1,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   445,    -1,
      -1,    -1,    -1,    -1,    -1,    95,  1810,    -1,    -1,    -1,
     180,    -1,    -1,   103,    -1,    -1,    -1,   187,   108,    -1,
     190,    -1,    -1,   470,    -1,    -1,    -1,    -1,   117,   476,
     477,   478,    -1,    -1,    -1,   482,    -1,   484,    -1,    -1,
      -1,   488,   489,   490,   491,   492,  2018,    -1,   495,   496,
     497,   498,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   236,    -1,    -1,   239,
      -1,   160,    -1,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
     498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2078,    -1,    -1,    -1,
      -1,   281,    -1,   283,    -1,    -1,    -1,    -1,   207,    -1,
      -1,    -1,    -1,    -1,   294,   214,    71,   216,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,   329,
     330,    -1,    -1,   108,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2145,    -1,    -1,  1980,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,    -1,   359,
      -1,    -1,    -1,   363,   364,    -1,    -1,  2169,  2170,    -1,
      -1,  2173,  2174,  2175,    -1,    -1,    -1,  2179,    -1,    -1,
      -1,    -1,   302,  2185,    -1,   305,  2188,   387,    -1,  2191,
      -1,    -1,    -1,    -1,  2196,  2197,    -1,   397,    -1,   319,
    2202,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2219,  2220,    -1,
      -1,  2223,  2224,  2225,  2226,  2227,  2228,  2229,    -1,    -1,
    2232,  2233,    -1,    -1,  2236,  2237,    -1,    -1,  2240,    -1,
      -1,    -1,    -1,  2245,  2246,    -1,    -1,    -1,    -1,  2251,
      -1,  2253,  2254,    -1,    71,   230,    -1,    -1,    -1,   234,
      -1,  2263,  2264,    -1,  2266,    -1,    -1,    -1,    -1,  2271,
      -1,   391,    -1,  2275,  2276,  2277,  2278,  2279,    95,   254,
     255,    -1,    -1,  2285,  2286,  2287,   103,    -1,    -1,    -1,
    2292,   108,  2294,  2295,   269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2307,    -1,    -1,    -1,    -1,
      -1,    -1,  2314,  2315,  2316,  2317,  2318,  2319,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,  2347,    -1,   322,    -1,    -1,
      -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,  2209,    -1,  2379,   498,    -1,
    2214,  2215,    -1,    -1,  2386,    -1,   139,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2396,   148,   149,   150,    -1,    -1,
      -1,    -1,  2404,    -1,    -1,    -1,  2408,  2409,    -1,    -1,
      -1,    -1,    -1,   230,    -1,    -1,   391,   234,    -1,    -1,
      -1,    -1,    -1,  2425,  2426,  2427,  2428,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,   254,   255,   192,
    2442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,  2456,    -1,    95,    -1,    -1,  2461,
      99,    -1,    -1,  2465,   103,    -1,    -1,    -1,    -1,   108,
      -1,  2473,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   234,    -1,    -1,    -1,   302,   239,    -1,   305,    -1,
      -1,    -1,    -1,    -1,    -1,  2497,    -1,  2331,    -1,  2501,
      -1,    -1,   319,    -1,    -1,   322,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,   498,    -1,   278,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   178,
      -1,    -1,   295,   296,   297,   298,   299,    -1,   301,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2393,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2575,   391,    -1,    -1,    -1,    -1,    -1,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,  2604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   255,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2651,
      -1,    -1,    -1,   406,    -1,   408,    -1,  2491,    -1,    -1,
    2662,    -1,    -1,   302,   481,    -1,   305,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,   431,   496,
     319,   800,    -1,   322,    -1,   438,    -1,    -1,   441,   808,
      -1,    -1,    -1,    -1,   813,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2716,  2717,  2718,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   843,    71,    -1,    -1,    -1,  2731,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2740,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,   391,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    71,
    2772,  2773,  2774,  2775,   893,    -1,    -1,    -1,    -1,    -1,
      -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,  2797,    -1,  2799,    71,    -1,
     439,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,
      -1,    -1,    -1,  2815,    -1,    -1,    -1,  2819,    -1,    -1,
      -1,    -1,    95,    -1,    -1,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    71,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,  2858,    -1,    -1,    -1,
    2862,  2863,    -1,    -1,   210,    -1,    -1,    95,    -1,   215,
    2872,  2873,    -1,    -1,    -1,   103,    -1,   996,    -1,    -1,
     108,    -1,    -1,  1002,   230,    -1,    -1,  1006,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2899,    -1,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,   254,   255,
      -1,    -1,    -1,    -1,    -1,    -1,  1035,    -1,    -1,  2753,
    2754,    -1,  2756,   269,    -1,    -1,    95,    -1,   230,  2763,
      -1,    -1,   234,    -1,   103,    -1,  2938,  2939,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   254,   255,  2956,    -1,   302,   230,    -1,   305,
    2794,   234,  2796,  2965,    -1,    -1,    -1,   269,    -1,    -1,
      -1,  2973,    -1,   319,  2976,  2977,   322,    -1,  2980,    -1,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2993,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
     302,  3003,   230,   305,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3016,  3017,    -1,   319,    -1,    -1,
     322,    -1,    -1,    -1,    -1,  3027,   254,   255,  3030,   302,
      -1,    -1,   305,    -1,  2868,  3037,    -1,    -1,   340,    -1,
      -1,   269,    -1,    -1,    -1,   391,   319,  3049,    -1,   322,
    3052,    -1,    -1,  1172,    -1,    -1,    -1,    -1,    -1,  2893,
    1179,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,  1200,    -1,    -1,    -1,   254,   255,  2921,    -1,   391,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
     269,    -1,   404,  2937,    -1,    -1,    -1,   335,    -1,    -1,
      -1,  1230,    -1,    -1,    -1,    -1,    -1,  2951,   391,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2966,   302,    -1,   481,   305,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
     319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   391,    -1,  3167,    -1,    -1,  3002,    -1,
      -1,  1290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,  3198,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1323,    -1,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,   391,    -1,    -1,    -1,  1345,    -1,    -1,  3063,
      -1,    -1,  3234,  3235,    -1,    -1,    -1,  3239,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,  3082,    -1,
      71,    -1,    -1,   481,  1373,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3107,    95,    -1,  3278,  3279,    -1,    -1,
      -1,    -1,   103,    -1,    -1,  1404,  1405,   108,  1407,    -1,
      -1,    -1,  3294,    -1,    -1,    -1,  3298,  3299,  3300,  3301,
    3302,  3303,  3304,    -1,    -1,  1424,    71,  3141,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,  3350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1476,  1477,    -1,
      -1,  3363,  3364,  3365,    -1,  3367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1503,    -1,    -1,    -1,  1507,  1508,
      -1,  3393,    -1,    -1,   215,    -1,  3398,    -1,    -1,  3401,
      -1,  3403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
      -1,  3413,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3263,
    3432,    -1,  3434,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3445,    -1,  3447,    -1,  3449,   269,    -1,
      -1,    -1,  3454,    -1,  3456,    -1,    -1,    -1,    -1,  1578,
      -1,    -1,    -1,  1582,    -1,   230,    -1,  1586,  3470,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,    -1,  1606,    -1,   254,
     255,    -1,    -1,    -1,  1613,    -1,    -1,    -1,   319,    -1,
      -1,   322,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1635,    -1,    -1,    -1,
    1639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,    -1,    -1,    -1,    -1,    -1,    -1,  3381,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,  3564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,  1694,  3578,    -1,    -1,    -1,
      -1,    -1,  3416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3603,    -1,    -1,    -1,    -1,  3608,  3609,    -1,    -1,
    1729,    -1,    -1,    -1,    -1,    -1,    -1,  3619,  3620,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
    3632,  3633,  3634,  3635,    -1,  1754,    -1,    -1,    -1,    -1,
    1759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3661,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,  3675,  3676,  3677,  3678,  3679,    -1,    -1,
      -1,    -1,    -1,  1802,    -1,  1804,    -1,    -1,    -1,    -1,
      -1,  1810,    -1,    -1,  1813,  3529,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3540,    -1,    -1,    -1,
      -1,  3713,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,  3731,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3739,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3752,    -1,    -1,  3755,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1880,    -1,  3765,    -1,    -1,    -1,    -1,    -1,    -1,
    3604,    -1,    -1,    -1,    -1,  3777,  3778,    -1,  3612,    -1,
      -1,  3783,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    88,    -1,    -1,  1915,  1916,    -1,    -1,
      -1,    -1,    -1,    -1,  1923,    -1,    -1,  1926,    -1,    -1,
    1929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1937,  1938,
      -1,    -1,    -1,    -1,    -1,    -1,  1945,    -1,    -1,  1948,
    1949,  1950,  1951,    -1,    -1,    -1,    -1,    -1,    -1,  1958,
    1959,    -1,  1961,    -1,  1963,    -1,    -1,  1966,    -1,   144,
      -1,    -1,    -1,    -1,    -1,  3857,    -1,    -1,    -1,    -1,
      -1,  1980,  1981,  1982,    -1,    -1,  1985,    -1,    -1,   164,
    1989,    -1,    -1,    -1,  1993,  3877,    -1,  1996,  1997,  1998,
    1999,  2000,  2001,  2002,  2003,  2004,    -1,  2006,    -1,    -1,
     185,    -1,    -1,  2012,    -1,    -1,    -1,  2016,    -1,    -1,
      -1,     3,    -1,    -1,    -1,    -1,  3908,     9,  3910,    -1,
    3744,    13,    -1,    15,    -1,    17,    18,   212,    -1,    -1,
      -1,    -1,   217,    -1,    -1,    -1,    28,   222,    -1,    -1,
      -1,  3933,  3934,  3767,    -1,    -1,  3938,  3939,    -1,    -1,
      -1,    -1,   237,    45,    46,    -1,    -1,    -1,    -1,    -1,
    3952,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3792,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,  2087,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,
      -1,    -1,    -1,  3985,    -1,    -1,    -1,    -1,    -1,    91,
      95,    93,    94,    98,    71,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,   107,  4008,  4009,  4010,  4011,
    4012,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,  3853,
      -1,    98,    -1,    -1,   319,   127,   103,   129,   130,    -1,
      -1,   108,   134,   135,    -1,   207,    -1,    -1,    -1,    -1,
      -1,    -1,   214,   145,   216,   147,    -1,    -1,    -1,    -1,
      -1,   346,    -1,  2172,    -1,  4057,  4058,    -1,    -1,    -1,
      -1,    -1,   164,    -1,   166,    -1,    -1,   169,    -1,    -1,
    2189,    -1,    -1,   175,    -1,   370,    -1,    -1,    -1,   181,
      -1,   376,    -1,    -1,    -1,   187,    -1,   382,    -1,   384,
    2209,   193,    -1,    -1,    -1,  2214,  2215,   199,    -1,   201,
      -1,    -1,    -1,    -1,   206,    -1,    -1,  3941,    -1,    -1,
      -1,  4113,    -1,  4115,    -1,   410,   411,   219,    -1,  2238,
     415,    -1,  4124,    -1,    -1,   230,    -1,    -1,   423,   234,
      -1,    -1,    -1,   428,  3968,  4137,    -1,    -1,    -1,    -1,
      -1,  4143,    -1,   438,   246,    -1,    -1,    -1,    -1,   254,
     255,  2270,  4154,   230,    -1,   450,    -1,   234,    -1,    -1,
      -1,    -1,    71,  4165,   269,    -1,    -1,  4001,    -1,   271,
     272,  4005,  4006,    -1,    -1,   277,    -1,   254,   255,    -1,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,   103,    -1,    -1,   302,    -1,   108,
     305,    -1,   304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2329,    -1,  2331,    -1,   319,    -1,    -1,   322,    -1,  4221,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
    4064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
      -1,    -1,   319,    -1,  4246,   322,    -1,    -1,    -1,    -1,
     352,    -1,    -1,    -1,   356,    -1,   358,    -1,    -1,    -1,
      -1,   363,    -1,    -1,    -1,    -1,   368,    -1,    -1,   371,
      -1,    -1,    -1,   375,  2393,    -1,    -1,    -1,    -1,   381,
      -1,    -1,    -1,    -1,  2403,   387,   391,    -1,   390,    -1,
      -1,    -1,    -1,    -1,  2413,   397,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,
      -1,    -1,    71,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,   426,   234,   428,    -1,    -1,    -1,
      -1,  2450,    -1,   435,    -1,   437,    95,    -1,   440,    -1,
      -1,    -1,   444,    -1,   103,   254,   255,    -1,    -1,   108,
      -1,    -1,    -1,    -1,   456,    -1,    -1,    -1,    -1,    -1,
     269,  2480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2491,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,  2510,  2511,   302,    -1,   497,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,
     319,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,  2540,  2541,    -1,    -1,    -1,  2545,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,  2557,  2558,
    2559,  2560,    -1,    -1,    -1,    -1,  2565,    -1,    -1,    -1,
    2569,  2570,    -1,  2572,    -1,  2574,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,  2584,  2585,    -1,  2587,   108,
      -1,   230,    -1,    -1,    -1,   234,    -1,    88,    -1,    -1,
      -1,  2600,   391,  2602,    -1,    -1,    -1,  2606,    -1,   100,
      -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,  2622,    -1,    -1,    -1,    -1,    -1,   120,
     269,    -1,    -1,    -1,  2633,    -1,  2635,  2636,  2637,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,    -1,    -1,  2655,    -1,    -1,    -1,
      -1,    -1,    -1,   302,    -1,  2664,   305,    -1,    -1,    -1,
      -1,    -1,  2671,   164,    -1,    -1,   195,  2676,    -1,    -1,
     319,    -1,    -1,   322,  2683,  2684,  2685,    -1,    -1,    -1,
      -1,    -1,   481,    -1,   185,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,   212,    -1,    -1,    -1,    -1,   217,    -1,  2727,    -1,
      -1,   222,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     269,    -1,   391,    -1,  2753,  2754,   808,  2756,    -1,    -1,
      -1,   813,    -1,    -1,  2763,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   305,    -1,    -1,    -1,
      -1,   843,    -1,    -1,    -1,  2794,    -1,  2796,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,  2830,  2831,  2832,    -1,    -1,    -1,    -1,   329,    -1,
      -1,   893,   481,    -1,    -1,   484,   485,   486,   900,   488,
     489,   490,   491,   492,   493,   346,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2868,
      -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,   370,
      -1,    -1,    -1,   374,    -1,   376,    -1,    -1,    -1,    -1,
      -1,   382,    -1,   384,  2893,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,
     411,  2920,  2921,    -1,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   423,    -1,    -1,    -1,    -1,   428,  2937,    -1,
      -1,    -1,    -1,    -1,   996,    -1,    -1,   438,    -1,    -1,
    1002,    -1,  2951,    -1,  1006,    -1,    -1,    -1,    -1,   450,
      -1,    -1,   481,    -1,    -1,    -1,    -1,  2966,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1035,  2983,    -1,    -1,    -1,  2987,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2997,    -1,
      -1,    88,    -1,  3002,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3029,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,
      -1,    -1,    -1,   140,    -1,    -1,    -1,   144,    -1,    -1,
      -1,  3060,    -1,    -1,  3063,    -1,    -1,    -1,    -1,    -1,
    3069,    -1,    -1,    -1,    -1,    -1,  3075,   164,  3077,    -1,
      -1,    -1,    -1,  3082,  3083,    -1,    -1,  3086,  3087,  3088,
    3089,  3090,  3091,  3092,  3093,  3094,  3095,    -1,   185,    -1,
    3099,  3100,    -1,    -1,    -1,    -1,    -1,    -1,  3107,    -1,
      -1,    -1,    -1,  3112,    -1,    -1,    -1,  3116,    -1,  3118,
    1172,    -1,    -1,    -1,    -1,    -1,    -1,  1179,    -1,  3128,
     217,    -1,  3131,    -1,  3133,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3141,  3142,  3143,  3144,    -1,    -1,  1200,  3148,
     237,    -1,  3151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3170,    -1,    -1,   261,    -1,    -1,    -1,  1230,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   319,    -1,    -1,    -1,    -1,    -1,  1290,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,
      -1,    -1,    -1,  3262,  3263,  3264,    -1,    -1,    -1,    -1,
      -1,  1323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   370,    -1,    -1,    -1,   374,    -1,   376,
      -1,    -1,  3291,  1345,    -1,   382,    -1,    -1,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1373,    -1,   410,   411,    -1,    -1,    -1,   415,    -1,
     120,    -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,
      -1,   428,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,    -1,  1404,  1405,   144,  1407,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   450,    -1,    -1,    -1,    -1,    -1,  3368,
      -1,    -1,  1424,    -1,   164,    -1,    -1,    -1,    -1,    -1,
     170,    -1,  3381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3416,  3417,  3418,
      -1,    -1,   212,    -1,  1476,    -1,    -1,   217,   218,    -1,
      -1,    -1,   222,    -1,    -1,    -1,    -1,  3436,    -1,    -1,
      -1,    -1,  3441,    -1,    -1,  3444,    -1,   237,    -1,    -1,
      -1,  1503,    -1,    -1,    -1,  1507,  1508,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,  3483,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3519,    -1,    -1,    -1,    -1,    -1,  1578,  3526,  3527,   319,
    3529,    -1,   322,    -1,  1586,  3534,  3535,    -1,    -1,    -1,
    3539,  3540,    -1,    -1,    -1,    -1,  3545,  3546,    -1,    -1,
    3549,    -1,    -1,    -1,  1606,    -1,   346,    -1,    -1,    -1,
      -1,  1613,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3569,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     370,    -1,    -1,  1635,   374,    -1,   376,  1639,    -1,    -1,
      -1,    -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3604,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3612,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   411,   412,    -1,   414,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   423,    -1,    -1,    -1,   427,   428,    -1,
      -1,    -1,  1694,   433,    -1,    -1,    -1,    -1,   438,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1711,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1729,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3699,    -1,  1754,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3709,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3739,    -1,    -1,    -1,    -1,  3744,    -1,    -1,    -1,    -1,
    1802,    -1,  1804,    -1,    -1,    -1,    -1,    -1,  1810,  3758,
      -1,  1813,    -1,  3762,    -1,    -1,    -1,    -1,  3767,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3788,
      -1,    -1,    -1,  3792,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3812,  3813,    -1,    -1,  3816,    -1,    -1,
      -1,    -1,    -1,    -1,  3823,  3824,    -1,    -1,  1880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3853,    -1,    -1,  3856,    -1,    -1,
      -1,    -1,    -1,  1915,  1916,    -1,    -1,    -1,    -1,    -1,
      -1,  1923,    -1,    -1,  1926,    -1,    -1,  1929,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1937,  1938,    -1,  3887,    -1,
      -1,    -1,    -1,  1945,    -1,    -1,  1948,  1949,  1950,  1951,
      -1,    -1,    -1,    -1,    -1,    -1,  1958,  1959,    -1,  1961,
      -1,  1963,    -1,    -1,  1966,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1980,  1981,
      -1,    -1,    -1,  1985,    -1,  3934,  3935,  1989,    -1,    -1,
      -1,  1993,  3941,    -1,  1996,  1997,  1998,  1999,  2000,  2001,
    2002,  2003,  2004,    -1,  2006,    -1,    -1,    -1,    -1,    -1,
    2012,    -1,    -1,    -1,  2016,    -1,    -1,    -1,  3967,  3968,
      -1,  3970,    -1,  3972,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3998,
      -1,    -1,  4001,    -1,    -1,    -1,  4005,  4006,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4029,    -1,    -1,    -1,    -1,  2087,    -1,  4036,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4057,    -1,
      -1,    -1,    -1,    -1,    -1,  4064,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4082,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4150,    -1,    -1,    -1,    -1,   142,  2209,    -1,    -1,
      -1,    -1,  2214,  2215,    -1,    -1,   152,    -1,    -1,   155,
      -1,    -1,    -1,    -1,    -1,   161,    -1,    -1,    -1,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     186,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   202,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2329,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2393,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,  2403,    -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,    -1,    -1,    -1,    -1,  2450,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,
     161,    -1,    -1,    -1,   165,    -1,    -1,    -1,  2480,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2491,
      -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2510,  2511,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2540,  2541,
      -1,    -1,    -1,  2545,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2557,  2558,  2559,  2560,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2569,    -1,    -1,
    2572,    -1,  2574,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2584,  2585,    -1,  2587,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2600,    -1,
    2602,    -1,    -1,    -1,  2606,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2633,    -1,  2635,  2636,  2637,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2655,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2664,    -1,    -1,    -1,    -1,    -1,    -1,  2671,
      -1,    -1,    -1,    -1,  2676,    -1,    -1,    -1,    -1,    -1,
      -1,  2683,  2684,  2685,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2727,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   678,   679,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2753,  2754,    -1,  2756,    -1,   692,    -1,    -1,    -1,
      -1,  2763,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2794,    -1,  2796,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2868,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   819,    -1,   821,    -1,   823,    -1,   825,
      -1,  2893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   844,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2921,
      -1,    -1,   858,   859,    -1,    -1,    -1,   863,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2937,    -1,    -1,    -1,   630,
      -1,    -1,    -1,    -1,   880,    -1,   882,    -1,    -1,  2951,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   894,    -1,
      -1,    -1,    -1,    -1,  2966,    -1,    -1,    -1,    -1,    -1,
     906,    -1,    -1,   909,    -1,   911,    -1,   913,    -1,    -1,
      -1,  2983,    -1,    -1,    -1,  2987,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2997,    -1,    -1,    -1,    -1,
    3002,   692,    -1,    -1,   940,   941,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3029,    -1,    -1,
     966,    -1,   968,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3060,    -1,
      -1,  3063,   998,    -1,    -1,    -1,    -1,  3069,    -1,    -1,
      -1,    -1,    -1,  3075,    -1,  3077,    -1,    -1,    -1,    -1,
    3082,  3083,    -1,    -1,  3086,  3087,  3088,  3089,  3090,  3091,
    3092,  3093,  3094,  3095,    -1,    -1,    -1,  3099,  3100,    -1,
      -1,  1037,    -1,    -1,    -1,  3107,    -1,    -1,    -1,    -1,
    3112,    -1,    -1,    -1,    -1,    -1,  3118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3128,    -1,    -1,  3131,
      -1,  3133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3141,
    3142,  3143,  3144,    -1,    -1,    -1,  3148,    -1,    -1,  3151,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3170,  1105,
      -1,  1107,    -1,    -1,    -1,  1111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   879,   880,
      -1,   882,    -1,  1200,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1162,    -1,    -1,     5,
      -1,    -1,   923,    -1,    -1,    -1,   927,    -1,   929,  1175,
     931,    -1,    -1,    -1,    -1,    -1,   937,    -1,  1184,    25,
      -1,    -1,    -1,    -1,  1190,    -1,    -1,    -1,    -1,    35,
      36,  3263,    -1,    -1,    -1,  1201,    -1,    43,    44,    -1,
      -1,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,  1231,    72,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    -1,    -1,   998,    -1,  1000,
      -1,    -1,    -1,    -1,    -1,    -1,  1323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1301,  3368,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3381,
      -1,    -1,    -1,    -1,  1320,    -1,  1077,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1092,  1093,    -1,    -1,  1096,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3416,  3417,  3418,    -1,   194,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   208,    -1,  3436,    -1,    -1,    -1,    -1,  3441,
      -1,    -1,  3444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   227,    -1,    -1,    -1,    -1,  1463,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3483,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,   285,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3519,    -1,    -1,
      -1,    -1,    -1,    -1,  3526,  3527,    -1,  3529,    -1,    -1,
      -1,   307,  3534,  3535,    -1,    -1,    -1,  3539,  3540,    -1,
      -1,    -1,    -1,  3545,  3546,    -1,    -1,  3549,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1493,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3569,    -1,    -1,
      -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3604,   379,    -1,    -1,  1613,    -1,    -1,    -1,
    3612,    -1,    -1,  1304,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,    -1,
      -1,  1322,    -1,    -1,    -1,  1571,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   419,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   432,    -1,    -1,    -1,
    1596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   445,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,    -1,
      -1,    -1,    -1,    -1,   470,    -1,    -1,  3699,    -1,    -1,
     476,   477,   478,    -1,  1711,    -1,   482,    -1,   484,    -1,
      -1,    -1,   488,   489,   490,   491,   492,    -1,    -1,   495,
     496,   497,  1729,    -1,    -1,    -1,   502,   503,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3739,    -1,    -1,
      -1,    -1,  3744,    -1,  1435,    -1,    -1,  1754,    -1,    -1,
      -1,    -1,    -1,  1444,  1445,    -1,  3758,    -1,    -1,    -1,
    3762,    -1,    -1,    -1,    -1,  3767,    -1,    -1,    -1,    -1,
      -1,    -1,  1463,    -1,    -1,    -1,  1467,  1468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3788,    -1,    -1,    -1,
    3792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,
    3812,  3813,    -1,    -1,  3816,    -1,    -1,    -1,    -1,  1755,
      -1,  3823,  3824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1767,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1539,    -1,
    1541,  3853,    -1,    -1,  3856,    -1,    -1,    -1,  1549,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1812,    -1,    -1,    -1,
    1816,    -1,    -1,    -1,    -1,  3887,    -1,    -1,    -1,  1825,
      -1,  1827,    -1,  1829,    -1,    -1,    -1,    -1,  1834,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1598,    -1,    -1,
      -1,    -1,    -1,  1604,    -1,    -1,    -1,    -1,    -1,    -1,
    1856,  1857,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3934,  3935,    -1,    -1,    -1,    -1,    -1,  3941,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1644,    -1,    -1,  1647,  1648,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3967,  3968,    -1,  3970,    -1,
    3972,    -1,    -1,  1980,   808,    -1,    -1,    -1,    -1,   813,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3998,    -1,    -1,  4001,
      -1,    -1,    -1,  4005,  4006,    -1,  1697,    -1,    -1,   843,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4036,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4057,    -1,    -1,    -1,   893,
      -1,    -1,  4064,    -1,    -1,    -1,   900,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4082,    -1,  2018,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   996,    -1,    -1,    -1,  1857,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1035,  2209,    -1,    -1,    -1,    -1,  2214,  2215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4235,  2170,    -1,    -1,    -1,    -1,  2175,
      -1,    -1,    -1,  2179,    -1,    -1,    -1,    -1,    -1,  2185,
      -1,    -1,    -1,    -1,    -1,  2191,    -1,    -1,    -1,    -1,
      -1,  2197,    -1,    -1,    -1,    -1,  2202,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2225,
    2226,  2227,  2228,    -1,    -1,   996,  2232,  2233,    -1,    -1,
      -1,  2237,    -1,    -1,  2240,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2254,    -1,
    2011,    -1,    -1,    -1,  2331,    -1,    -1,  2018,  2264,    -1,
    2266,    -1,    -1,    -1,  1035,    -1,  2027,    -1,  1172,  2275,
    2276,  2277,    -1,  2279,    -1,  1179,    -1,    -1,    -1,    -1,
    2286,  2287,    -1,    -1,    -1,    -1,    -1,    -1,  2294,  2295,
      -1,    -1,    -1,    -1,    -1,    -1,  1200,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1230,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1200,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2141,    -1,    -1,    -1,  2145,    -1,  1290,    -1,  2149,    -1,
    2151,    -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2491,    -1,    -1,    -1,    -1,  1323,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1373,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1323,  2497,    -1,    -1,    -1,    -1,  2257,    -1,    -1,    -1,
    1404,  1405,    -1,  1407,  2265,    -1,  2267,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1476,    -1,  1345,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1503,
      -1,    -1,  1373,  1507,  1508,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1404,  1405,    -1,  1407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1424,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1578,    -1,  2753,  2754,    -1,  2756,
      -1,    -1,    -1,    -1,    -1,    -1,  2763,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2456,  2457,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1476,    -1,    -1,    -1,  1613,
      -1,  2717,  2718,    -1,    -1,    -1,    -1,  2794,    -1,  2796,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1635,  1503,    -1,  2740,    -1,  1507,  1508,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2772,  2773,  2774,  2775,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1613,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1694,  2868,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1635,    -1,    -1,    -1,    -1,  1711,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2921,    -1,    -1,    -1,    -1,    -1,
    1754,    -1,  2858,    -1,    -1,    -1,    -1,  2863,    -1,    -1,
    2937,  1694,    -1,    -1,    -1,    -1,  1200,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,  1711,    -1,
      -1,    -1,    -1,    -1,    -1,  2646,    -1,    -1,    -1,  2966,
    2651,    -1,    -1,    -1,    -1,    -1,  1729,    -1,  1802,    -1,
    1804,    -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,  1813,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1754,    -1,    -1,    -1,  3002,    -1,    -1,    -1,    -1,
      -1,    -1,  2938,  2939,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2976,    -1,    -1,    -1,    -1,    -1,  1880,  1810,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3063,    -1,    -1,  1323,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3003,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3082,    -1,    -1,    -1,    -1,
    3016,  1915,  1916,    -1,    -1,    -1,    -1,    -1,    -1,  1923,
      -1,    -1,  1926,    -1,    -1,  1929,    -1,    -1,    -1,    -1,
    3107,    -1,    -1,  1937,  1938,    -1,    -1,    -1,    -1,    -1,
      -1,  1945,    -1,    -1,  1948,  1949,  1950,  1951,    -1,    -1,
      -1,    -1,    -1,    -1,  1958,  1959,    -1,  1961,    -1,  1963,
      -1,    -1,  1966,    -1,  3141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1980,  1981,    -1,    -1,
      -1,  1985,    -1,    -1,    -1,  1989,    -1,    -1,    -1,  1993,
      -1,    -1,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,
    2004,    -1,  2006,    -1,    -1,    -1,    -1,    -1,  2012,    -1,
      -1,    -1,  2016,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1980,    -1,    -1,
      -1,    -1,  1923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1945,    -1,    -1,  1948,  2939,    -1,
    1951,    -1,    -1,  2087,    -1,    -1,  3263,  1958,  1959,    -1,
      -1,    -1,  1963,    -1,    -1,  1966,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1981,    -1,    -1,    -1,  1985,  2976,    -1,    -1,  1989,    -1,
      -1,    -1,  1993,    -1,    -1,  1996,  1997,  1998,  1999,  2000,
    2001,  2002,  2003,  2004,    -1,  2006,    -1,    -1,    -1,    -1,
      -1,  2012,    -1,    -1,  1578,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,
      -1,    -1,    -1,    -1,    -1,  2189,    -1,    -1,  3294,    -1,
      -1,    -1,    -1,  3299,    -1,  3301,  3302,  3303,  3304,    -1,
      -1,  1635,    -1,    -1,  3381,  2209,    -1,    -1,    -1,    -1,
    2214,  2215,    -1,    -1,    -1,    -1,  2087,    -1,    -1,    -1,
      -1,    -1,  1200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3363,  3364,  3365,
    1694,  3367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2209,  1711,    -1,    -1,
      -1,  2214,  2215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2189,    -1,
    1754,    -1,    -1,    -1,    -1,  2329,    -1,  2331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3449,    -1,  1323,    -1,    -1,    -1,    -1,
      -1,    -1,  3529,    -1,    -1,    -1,    