/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: SelectionHelper.hxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _CHART2_SELECTIONHELPER_HXX
#define _CHART2_SELECTIONHELPER_HXX

#include "DrawViewWrapper.hxx"

class SdrObject;
// header for enum SdrDragMode
#include <svx/svdtypes.hxx>
#include <com/sun/star/drawing/XShape.hpp>

//.............................................................................
namespace chart
{
//.............................................................................

//-----------------------------------------------------------------------------
/**
*/
class Selection
{
public: //methods
    bool hasSelection();

    rtl::OUString getSelectedCID();
    ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape > getSelectedAdditionalShape();

    bool isResizeableObjectSelected();
    bool isRotateableObjectSelected( const ::com::sun::star::uno::Reference<
                        ::com::sun::star::frame::XModel >& xChartModel );
    bool isDragableObjectSelected();

    //returns true if selection has changed
    bool setSelection( const ::rtl::OUString& rCID );
    bool setSelection( const ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape >& xShape );

    void clearSelection();

    //returns true if the selection has changed
    bool maybeSwitchSelectionAfterSingleClickWasEnsured();
    void resetPossibleSelectionAfterSingleClickWasEnsured();

    void remindSelectionBeforeMouseDown();
    bool isSelectionDifferentFromBeforeMouseDown();

    void adaptSelectionToNewPos( const Point& rMousePos, DrawViewWrapper* pDrawViewWrapper
                                       , bool bIsRightMouse, bool bWaitingForDoubleClick );

    void applySelection( DrawViewWrapper* pDrawViewWrapper );

private: //member
    //the selection could be given by a CID or by a shape
    //if m_aSelectedObjectCID is not empty this indicates the selection
    //the content of m_xSelectedShape is ignored in that case
    //the strings are used for autogenerated chart specific objects
    //the shape reference is used for additional shapes
    ::rtl::OUString     m_aSelectedObjectCID;//only single object selection so far
    ::rtl::OUString     m_aSelectedObjectCID_beforeMouseDown;
    ::rtl::OUString     m_aSelectedObjectCID_selectOnlyIfNoDoubleClickIsFollowing;

    ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape > m_xSelectAdditionalShape;
};

class SelectionHelper : public MarkHandleProvider
{
public:
    static bool             findNamedParent( SdrObject*& pInOutObject
                                , rtl::OUString& rOutName
                                , bool bGivenObjectMayBeResult );
    static SdrObject*       getMarkHandlesObject( SdrObject* pObj );
    static E3dScene*        getSceneToRotate( SdrObject* pObj );
    static bool             isDragableObjectHitTwice( const Point& rMPos
                                , const rtl::OUString& rNameOfSelectedObject
                                , const DrawViewWrapper& rDrawViewWrapper );

    static ::rtl::OUString getHitObjectCID(
        const Point& rMPos,
        DrawViewWrapper& rDrawViewWrapper,
        bool bGetDiagramInsteadOf_Wall=false );

    static bool isRotateableObject( const ::rtl::OUString& rCID
                    , const ::com::sun::star::uno::Reference<
                        ::com::sun::star::frame::XModel >& xChartModel );


    SelectionHelper( SdrObject* pSelectedObj );
    virtual ~SelectionHelper();


    //MarkHandleProvider:
    virtual bool getMarkHandles( SdrHdlList& rHdlList );
    virtual bool getFrameDragSingles();

    SdrObject*   getObjectToMark();//sets also internally the mark object
    //-> getMarkHandles will behave different if this method has found a Mark Object different from m_pSelectedObj

private:
    SdrObject*      m_pSelectedObj;//hit and logically selected object
    SdrObject*      m_pMarkObj;//object that is marked instead to have more pretty handles
};

//.............................................................................
} //namespace chart
//.............................................................................
#endif
