/*
 * Copyright (C), 2000-2006 by the monit project group.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <config.h>

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "protocol.h"

/**
 *  Simple Monit test.
 *
 *  In the case that the anonymous login is possible,
 *  we will perform Monit ping. If athentication failed
 *  we suppose the anonymous login is denied and we will
 *  return success, because the server at least performed
 *  authentication => it seems it works.
 *
 *  @author Martin Pala, <martinp@tildeslash.com>
 *
 *  @version \$Id$
 *
 *  @file
 */
int check_monit(Socket_T s) {

  int status;
  char buf[STRLEN];
  char proto[STRLEN];

  ASSERT(s);

  if(socket_print(s,
       "GET / HTTP/1.1\r\n"
       "User-Agent: %s/%s\r\n"
       "Connection: close\r\n\r\n",
       prog, VERSION) < 0)
  {
    log("MONIT: error sending data -- %s\n", STRERROR);
    return FALSE;
  }

  if(! socket_readln(s, buf, sizeof(buf)))
  {
    log("MONIT: error receiving data -- %s\n", STRERROR);
    return FALSE;
  }

  Util_chomp(buf);

  if(sscanf(buf, "%s %d", proto, &status) != 2)
  {
    log("MONIT error: %s\n", buf);
    return FALSE;
  }

  /* If OK, we can compare the ping response */
  if(status == 200)
  {
    log("MONIT: BUBU DATA -- %s\n", buf);
  }
  /* If Authentication Failed, return success immediately */
  else if(status == 401)
  {
    return TRUE;
  }

  log("MONIT: invalid response -- %d\n", status);

  return FALSE;

}

