// -*- C++ -*-
/**
 * \file forkedcallqueue.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Alfredo Braunstein (based on an idea from Angus Leeming)
 *
 * Full author contact details are available in file CREDITS.
 *
 * This class implements a queue of forked processes. In order not to
 * hose the system with multiple processes running simultaneously, you can
 * request the addition of your process to this queue and it will be
 * executed when its turn comes.
 *
 */

#ifndef FORKEDCALLQUEUE_H
#define FORKEDCALLQUEUE_H

#include "support/forkedcall.h"

#include <queue>
#include <utility>


namespace lyx {
namespace support {

class ForkedCallQueue {
public:
	/// A process in the queue
	typedef std::pair<std::string, Forkedcall::SignalTypePtr> Process;
        /**Addaprocesstothequeue.Processesareforkedsequentially
	 *onlyoneisrunningatatime.
*Connecttothereturnedsignalandyou'llbeinformedwhen
*theprocesshasended.
*/
	Forkedcall::SignalTypePtr add(std::string const & process);
	///Querywhetherthequeueisrunningaforkedprocessnow.
	bool running() const;
	/// Get the and only instance of the class
	static ForkedCallQueue & get();

private:

	/** this class is a singleton class... use
	 *  ForkedCallQueue::get() instead
	 */
	ForkedCallQueue();
	/// in-progress queue
	std::queue<Process> callQueue_;
	///
	bool running_;
	///
	void callNext();
	///
	void startCaller();
	///
	void stopCaller();
	///
	void callback(pid_t, int);
};

} // namespace support
} // namespace lyx

#endif // FORKEDCALLQUEUE_H
