/***************************************************************************
                          chatinformation.cpp  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chatinformation.h"

#include "../contact/contactlist.h"

// The constructor for a user-started chat
ChatInformation::ChatInformation(MsnNotificationConnection *parent, const QString& handle, ContactList *contactList)
 : contactHandle_(handle),
   contactList_(contactList),
   notificationConnection_(parent),
   port_(0),
   userStartedChat_(true)
{
}



// The constructor for a contact-started chat
ChatInformation::ChatInformation(MsnNotificationConnection *parent, const QString &handle, ContactList *contactList,
                                 const QString &ip, int port, const QString &authorization, const QString &chatId)
 : authorization_(authorization),
   chatId_(chatId),
   contactHandle_(handle),
   contactList_(contactList),
   ip_(ip),
   notificationConnection_(parent),
   port_(port),
   userStartedChat_(false)
{
}


// The destructor
ChatInformation::~ChatInformation()
{
}



// Return the switchboard authorization
const QString& ChatInformation::getAuthorization() const
{
  return authorization_;
}



// Return the contact-started chat verification id
const QString& ChatInformation::getChatId() const
{
  return chatId_;
}



// Return the handle of the contact this is a chat with
const QString& ChatInformation::getContactHandle() const
{
  return contactHandle_;
}



// Return the pointer to the list of contacts
ContactList* ChatInformation::getContactList()
{
  return contactList_;
}



// Return the switchboard server ip
const QString& ChatInformation::getIp() const
{
  return ip_;
}



// Return the notification connection that spawned this object
MsnNotificationConnection * ChatInformation::getNotificationConnection() const
{
  return notificationConnection_;
}



// Return the switchboard server port
const int& ChatInformation::getPort() const
{
  return port_;
}



// Return whether the user started the chat
bool ChatInformation::getUserStartedChat() const
{
  return userStartedChat_;
}



// Set server information
void ChatInformation::setServerInformation( const QString& ip, const int& port, const QString& authorization )
{
  ip_ = ip;
  port_ = port;
  authorization_ = authorization;
}
