/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "show_forecast_dialog.h"
#include "weather_global.h"
#include "getcitydialog.h"
#include "textprogress.h"

#include <qframe.h>
#include <qtabwidget.h>

ShowForecastDialog::ShowForecastDialog( const CitySearchResult& city )
:
	city_( city )
{
	tabs_ = new QTabWidget( this );
	
	QVBoxLayout* layout = new QVBoxLayout( this );
	layout->insertWidget( 0, tabs_ );
	layout->setResizeMode( QLayout::Fixed );
	
	setCaption(  tr("%1 - Forecast").arg( city_.cityName_)  );
}

void ShowForecastDialog::show()
{
	QString serverName;
	weather_global->getServerName( city_.server_, &serverName );
	
	ShowForecastFrame* page = new ShowForecastFrame1( this, city_ );
	tabs_->addTab( page, serverName );
	
	connect( page, SIGNAL(changeCity()), this, SLOT(changeCity()) );
	connect( tabs_, SIGNAL(currentChanged( QWidget* )), this, SLOT(tabChanged( QWidget* )) );
	
	WeatherGlobal::SERVERITERATOR serverIt = weather_global->beginServer();
	while( serverIt != weather_global->endServer() )
	{
		if( (*serverIt).configFile_ != city_.server_ )
		{
			ShowForecastFrame* newpage = new ShowForecastFrame2(this, city_.cityName_, (*serverIt).configFile_);
			tabs_->addTab( newpage, (*serverIt).name_ );
			connect( newpage, SIGNAL(changeCity()), this, SLOT(changeCity()) );
		}
		serverIt = weather_global->nextServer( serverIt );
	}
	
	QDialog::show();
}

void ShowForecastDialog::tabChanged( QWidget* page )
{
	ShowForecastFrame* frame = reinterpret_cast<ShowForecastFrame*>( page );
	frame->start();
}

void ShowForecastDialog::changeCity()
{
	GetCityDialog* gcd = new GetCityDialog;
	gcd->show();
	close();
}

void ShowUserForecastDialog::changeCity()
{
	GetCityDialog* gcd = new GetUserCityDialog( user_ );
	gcd->show();
	close();
}

void ShowMyForecastDialog::changeCity()
{
	GetCityDialog* gcd = new GetMyCityDialog;
	gcd->show();
	close();
}
