#ifndef __KADU_OSDHINTS_NOTIFY_H
#define __KADU_OSDHINTS_NOTIFY_H

#include "osd_manager.h"

class OSDProperties
{
	public:
		QFont font;
		QColor fgcolor;
		QColor bgcolor;
		QColor bordercolor;
		unsigned int timeout;
		QString syntax;
		int mask_effect;
};

class OSD_Notify : public QObject
{
	Q_OBJECT
	
	public:
		OSD_Notify();
		~OSD_Notify();
		
	private:
		OSDManager *osd_manager;
		OSDPreviewWidget *preview;
		
		QStringList config_opts_prefixes;
		QString currentOptionPrefix;
		QMap<QString, OSDProperties> config_hint_properties;
	
		void createGUI(void);
		void destroyGUI(void);
		
	private slots:
		void onCreateTab(void);
		void onApplyConfigDialog(void);
		void tabIn(void);
		void tabOut(void);
		
		void preview_positionChanged(int, int);
		
		void clicked_HintType(int id);
		void toggled_SetAll(bool val);
		void clicked_ShowEffect(int);
		void clicked_ChangeFont(const char *, const QFont&);
		void clicked_ChangeBgColor(const char *, const QColor &);
		void clicked_ChangeFgColor(const char *, const QColor &);
		void clicked_ChangeBorderColor(const char *, const QColor &);
		void changed_Timeout(int);
		void changed_syntax();
		void toggled_UseTrans(bool);
};
#endif
