/***************************************************************************
 *   Copyright (C) 2006 by bysk                                           *
 *   buysk@pf.pl                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LED_NOTIFY_H
#define LED_NOTIFY_H

#include <qobject.h>
#include <qtimer.h>

#include "config_dialog.h"
#include "config_file.h"
#include "debug.h"
#include "chat.h"
#include "pending_msgs.h"
#include "modules/notify/notify.h"

class LedNotify : public Notifier
{
	Q_OBJECT
	
	public:
		LedNotify(QObject* parent = 0, const char* name = 0);
		~LedNotify();
		
		void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules) {}
	
	public slots:
		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);

	private:
		QTimer* timer;
		bool ledHighlight_;
		bool blinking_;
		bool msgOrChat_;
		UserListElements newMsgSenders;
		
		static void setLed( int led, bool highlight );
		
		static int NUMLOCK_LED;
		static int CAPSLOCK_LED;
		static int SCROLLLOCK_LED;
		
	private slots:
		void blink(void);

};

#endif // LED_NOTIFY_H
