/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smsmiastoplusagatewayslots.h"
#include "smsmiastoplusagateway.h"

#include <qmessagebox.h>

#include "config_dialog.h"
#include "config_file.h"
#include "debug.h"
#include "modules.h"

SmsMiastoplusaGatewaySlots::SmsMiastoplusaGatewaySlots(QObject *parent, const char *name) : QObject(parent, name)
{
	kdebugf();
	
	ConfigDialog::addVGroupBox("SMS", "SMS",
			QT_TRANSLATE_NOOP("@default", "SMS Miasto Plusa Gateway"));
	ConfigDialog::addLineEdit2("SMS", "SMS Miasto Plusa Gateway",
			QT_TRANSLATE_NOOP("@default", "User"));
	ConfigDialog::addLineEdit2("SMS", "SMS Miasto Plusa Gateway",
			QT_TRANSLATE_NOOP("@default", "Pass"));
	ConfigDialog::addCheckBox("SMS", "SMS Miasto Plusa Gateway", 
			QT_TRANSLATE_NOOP("@default", "Request confirmatoin"), "miastoplusa_sms_request_confirmation",
			true);
	ConfigDialog::addCheckBox("SMS", "SMS Miasto Plusa Gateway",
			QT_TRANSLATE_NOOP("@default", "Display infos about sent SMSes"), 
			"miastoplusa_sms_display_infos",
			false);
	sendHandleTypes = toStringList(tr("Always"),
			tr("Never"));
	sendHandleValues = toStringList("always", "never");
	
	ConfigDialog::addComboBox("SMS", "SMS Miasto Plusa Gateway", QT_TRANSLATE_NOOP("@default", "Send messages to networks other "
			"than PlusGSM using Miasto Plusa gateway: "), "HandleType", sendHandleTypes, sendHandleValues, "HandleType", 
			QT_TRANSLATE_NOOP("@default", "Always try to send message through Miasto Plusa SMS gateway - If you choose "
			"this option, module will each\ntime try to send message, even if you don't have any free SMSes to send on "
			"your account. Good choice for\npeople, that often send messages to other networks.\n\nNever send messages "
			"to other networks that PlusGSM through Miasto Plusa gateway - If you choose this option,\nmodule will "
			"alaways refuse to send message to network other than PlusGSM , so the next gateway in the\n\"Gateways "
			"priority\" will be asked to send SMS. Choice good for people, that never use Miasto Plusa gateway\nto send "
			"messages to nesworks other than PlusGSM using Miasto Plusa."));
					
	config_file.addVariable("SMS", "HandleType", "always");
	ConfigDialog::registerSlotOnCreateTab("SMS", this, SLOT(onCreateConfigDialog()));
	ConfigDialog::registerSlotOnCloseTab("SMS", this, SLOT(onCloseConfigDialog()));
	ConfigDialog::registerSlotOnApplyTab("SMS", this, SLOT(onApplyConfigDialog()));
	kdebugf2();
}

SmsMiastoplusaGatewaySlots::~SmsMiastoplusaGatewaySlots()
{
	kdebugf();
	ConfigDialog::unregisterSlotOnCreateTab("SMS", this, SLOT(onCreateConfigDialog()));
	ConfigDialog::unregisterSlotOnCloseTab("SMS", this, SLOT(onCloseConfigDialog()));
	ConfigDialog::unregisterSlotOnApplyTab("SMS", this, SLOT(onApplyConfigDialog()));
	
	ConfigDialog::removeControl("SMS", "Send messages to networks other than PlusGSM using Miasto Plusa gateway: ");
	ConfigDialog::removeControl("SMS", "Display infos about sent SMSes");
	ConfigDialog::removeControl("SMS", "Request confirmatoin");
	ConfigDialog::removeControl("SMS", "User");
	ConfigDialog::removeControl("SMS", "Pass");
	ConfigDialog::removeControl("SMS", "SMS Miasto Plusa Gateway");
	kdebugf2();
}

void SmsMiastoplusaGatewaySlots::onApplyConfigDialog()
{
	kdebugf();
	QLineEdit *e_miastoplusa_sms_user = ConfigDialog::getLineEdit("SMS", "User");
	QLineEdit *e_miastoplusa_sms_pass = ConfigDialog::getLineEdit("SMS", "Pass");
	config_file.writeEntry("SMS", "MiastoplusaGateway_User", e_miastoplusa_sms_user->text());
	config_file.writeEntry("SMS", "MiastoplusaGateway_Pass", e_miastoplusa_sms_pass->text());
	kdebugf2();
}

void SmsMiastoplusaGatewaySlots::onCloseConfigDialog()
{
	kdebugf();
	modules_manager->moduleDecUsageCount("miastoplusa_sms");
}

void SmsMiastoplusaGatewaySlots::onCreateConfigDialog()
{
	kdebugf();
	QLineEdit *e_miastoplusauser= ConfigDialog::getLineEdit("SMS", "User");
	QLineEdit *e_miastoplusapass= ConfigDialog::getLineEdit("SMS", "Pass");
	e_miastoplusapass->setEchoMode(QLineEdit::Password);
	e_miastoplusauser->setText(config_file.readEntry("SMS", "MiastoplusaGateway_User"));
	e_miastoplusapass->setText(config_file.readEntry("SMS", "MiastoplusaGateway_Pass"));
	modules_manager->moduleIncUsageCount("miastoplusa_sms");
	kdebugf2();
}

SmsGateway* SmsMiastoplusaGatewaySlots::isValidMiastoplusa(const QString& number, QObject* parent)
{
	if(SmsMiastoplusaGateway::isNumberCorrect(number))
		return new SmsMiastoplusaGateway(parent, "sms_miastoplusa_gateway");
	else
		return NULL;
}

SmsMiastoplusaGatewaySlots* sms_miastoplusa_gateway_slots;
