/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "debug.h"
#include "modules.h"
#include "../sms/sms.h"
#include "smsmiastoplusagatewayslots.h"

extern "C" int miastoplusa_sms_init()
{
	kdebugf();
	smsslots->registerGateway("miastoplusa", &SmsMiastoplusaGatewaySlots::isValidMiastoplusa);
	sms_miastoplusa_gateway_slots=new SmsMiastoplusaGatewaySlots(NULL, "sms_miastoplusa_gateway_slots");
	kdebugf2();
	return 0;
}

extern "C" void miastoplusa_sms_close()
{
	kdebugf();
	smsslots->unregisterGateway("miastoplusa");
	delete sms_miastoplusa_gateway_slots;
	kdebugf2();
}

