#ifndef SCREENSHOT_H
#define SCREENSHOT_H

#include <qobject.h>
#include <qwidget.h>
#include <qmap.h>
#include <qpixmap.h>
#include <qrect.h>

class QMouseEvent;
class QKeyEvent;
class QPaintEvent;
class Chat;
class ChatButton;
class UserGroup;
class QTimer;
class QLabel;
class ConfigFile;
class QPopupMenu;

class ShotSizeHint : public QWidget
{
	friend class ScreenShot;

	private:
		QLabel *geom;
		QLabel *fileSize;

	public:
		ShotSizeHint();
};

class ScreenShot : public QWidget
{
	Q_OBJECT

	private:
		bool buttonPressed;
		QRect region;
		QMap<Chat*,ChatButton*> chatButtons;
		Chat* tempChat;
		QPixmap pixmap;
		ShotSizeHint* sizeHint;
		QTimer* hintTimer;
		ConfigFile* config;
		QPopupMenu* menu;
		int popups[2];
		int shotType;
		bool wasMaximized;
		bool warnedAboutSize;

		void drawRegionRect();
		void checkShotsSize();

	public:
		ScreenShot(QWidget * parent = 0, const char * name = 0, WFlags f = 0);
		~ScreenShot();
		void mousePressEvent(QMouseEvent* e);
		void mouseReleaseEvent(QMouseEvent* e);
		void mouseMoveEvent(QMouseEvent* e);
		void keyPressEvent(QKeyEvent* e);
		void handleShot(QPixmap p, QString path);

	public slots:
//		void assignChat(Chat* chat);
//		void chatCreated(const UserGroup*);
//		void chatDestroying(const UserGroup*);
		void onCreateConfig();
		void onDestroyConfig();
		void onApplyConfig();

	private slots:
//		void handleCreatedChat(Chat* chat);
//		void handleDestroyingChat(Chat* chat);
		void updateHint();
		void takeShot_Step2();
		void takeShot(int ident);
		void grabMouseSlot();
		void screenshotActionActivated(const UserGroup* grp, const QWidget* source);
};

extern ScreenShot* screenShot;

#endif
