#ifndef TEX_FORMULA_DIALOG_H
#define TEX_FORMULA_DIALOG_H

#include <qdialog.h>
#include <qstring.h>
#include <qtimer.h>
#include <qprocess.h>

class Chat;
class QTextEdit;
class QIconViewItem;
class FormulaView;

/*!
 * This is TeX formula editor class. An object of this class is created
 * each time, user presses "TeX formula" action button.
 * \brief TeX formula dialog class
 */
class TeXFormulaDialog : public QDialog
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor
		 * \param *parent parent widget (chat window)
		 * \param *name object's name
		 * \param f dialog's flags. The WDestructiveClose and WType_TopLevel
		 * are always automaticly set.
		 */
		TeXFormulaDialog(Chat *parent = 0, const char *name = 0, WFlags f = 0);
		
		//!	Default destructor
		~TeXFormulaDialog();
		
		//! Returns temporary gif file name.
		/*!
		 * \returns file's name
		 */
		QString getTmpFileName() const { return tmpFileName; }
	
	private slots:
		//! This slot is called each time, the "TeX formula" action button is pressed
		void okClickedSlot();
		
		//! Called periodicly to update formula's widget. It runs mimetex process
		void timeoutSlot();
		
		//! Called each time, component icon is clicked
		void insertComponentSlot(QIconViewItem *);
	
	private:
		FormulaView *formulaView;
		QString formula;
		Chat *chat;
		int paragraph, index;
		QTextEdit *formulaTextEdit;
		QTimer timer;
		QProcess mimeTeXProcess;
		QString tmpFileName;
		static int tmpFileNumber;
};

#endif
