/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qiconview.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qspinbox.h>

#include "tex_formula_dialog.h"
#include "formula_view.h"

#include "chat.h"
#include "misc.h"
#include "config_file.h"
#include "debug.h"

const int formulaMargin = 5;
const int formulaViewMinWidth = 300;
const int formulaViewMinHeight = 250;
const int componentsViewMinWidht = 400;
const int formulaTextEditMinimunHeight = 200;

TeXFormulaDialog::TeXFormulaDialog(Chat *parent, const char *name, WFlags f)
	: QDialog(parent, name, false, f | WDestructiveClose | WType_TopLevel)
{
	kdebugf();
	
	chat = parent;
	
	// Check if .kadu/tex directory exists. Create one if not.
	QDir TeXDir(ggPath("tex"));
	if(!TeXDir.exists())
		if(TeXDir.mkdir(ggPath("tex")))
			kdebugm(KDEBUG_INFO, "Error creating directory %s\n", ggPath("tex").latin1());
	// Remember the cursor's position. The formula will be inserted at this position
	chat->edit()->getCursorPosition(&paragraph, &index);
	
	QDateTime curTime = QDateTime::currentDateTime();
	tmpFileName = ggPath("tex/formula_%1.gif").arg(curTime.toString("yyyy-MM-dd_hh-mm"));
	if(QFile(tmpFileName).exists())
	{
		kdebugm(KDEBUG_INFO, "File %s already exists!!\n", tmpFileName.latin1());
		int i = 1;
		QString tmpStr;
		do
		{
			tmpStr = ggPath("tex/formula_%1_%2.gif").arg(curTime.toString("yyyy-MM-dd_hh:mm")).arg(i++);
			kdebugm(KDEBUG_INFO, "tmpStr: %s\n", tmpStr.latin1());
		}
		while(QFile(tmpStr).exists());
		tmpFileName = tmpStr;
	}
	kdebugm(KDEBUG_INFO, "tmpFileName: %s\n", tmpFileName.latin1());
	QVBoxLayout *mainLayout = new QVBoxLayout(this, 3, 3, "main_layout");
	QHBoxLayout *upperLayout = new QHBoxLayout(mainLayout, 3, "upper_layout");
	QVBoxLayout *formulaLayout = new QVBoxLayout(upperLayout, 3, "formula_layout");
	QVBoxLayout *componentsLayout = new QVBoxLayout(upperLayout, 3, "formula_layout");
	
	QLabel *formulaLabel = new QLabel(tr("Formula image"), this, "formula_label");
	formulaLayout->addWidget(formulaLabel);
	QLabel *componentsLabel = new QLabel(tr("Components"), this, "components_label");
	componentsLayout->addWidget(componentsLabel);
	formulaView = new FormulaView(tmpFileName, this, "formula_view");
	formulaView->setMinimumSize(formulaViewMinWidth, formulaViewMinHeight);
	formulaView->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding));
	formulaLayout->addWidget(formulaView);
	formulaLayout->addStretch();
	
	QTabWidget *componentsView = new QTabWidget(this, "components");
	componentsLayout->addWidget(componentsView);
	QIconView *relationsView = new QIconView(componentsView, "relations_icon_view");
	QIconView *greekLettersView = new QIconView(componentsView, "greek_letters_icon_view");
	QIconView *arrowsView = new QIconView(componentsView, "arrows_view");
	QIconView *delimitersView = new QIconView(componentsView, "delimiters_view");
	QIconView *symbolsView = new QIconView(componentsView, "symbols_view");
	
	relationsView->setMinimumWidth(componentsViewMinWidht);
	greekLettersView->setMinimumWidth(componentsViewMinWidht);
	arrowsView->setMinimumWidth(componentsViewMinWidht);
	delimitersView->setMinimumWidth(componentsViewMinWidht);
	symbolsView->setMinimumWidth(componentsViewMinWidht);
	
	componentsView->addTab(relationsView, 
			       QPixmap(dataPath("kadu/modules/data/powerkadu/mime_tex_icons/relations_tab_icon.png")),
			       tr("&Relations"));
	componentsView->addTab(greekLettersView,
			       QPixmap(dataPath("kadu/modules/data/powerkadu/mime_tex_icons/greek_letters_tab_icon.png")),
			       tr("&Greek Letters"));
	componentsView->addTab(arrowsView,
			       QPixmap(dataPath("kadu/modules/data/powerkadu/mime_tex_icons/arrows_tab_icon.png")),
			       tr("&Arrows"));
	componentsView->addTab(delimitersView,
			       QPixmap(dataPath("kadu/modules/data/powerkadu/mime_tex_icons/delimiters_tab_icon.png")),
			       tr("&Delimiters"));
	componentsView->addTab(symbolsView,
			       QPixmap(dataPath("kadu/modules/data/powerkadu/mime_tex_icons/symbols_tab_icon.png")),
			       tr("&Symbols"));
	
	connect(relationsView, SIGNAL(clicked(QIconViewItem *)), this, SLOT(insertComponentSlot(QIconViewItem *)));
	connect(greekLettersView, SIGNAL(clicked(QIconViewItem *)), this, SLOT(insertComponentSlot(QIconViewItem *)));
	connect(arrowsView, SIGNAL(clicked(QIconViewItem *)), this, SLOT(insertComponentSlot(QIconViewItem *)));
	connect(delimitersView, SIGNAL(clicked(QIconViewItem *)), this, SLOT(insertComponentSlot(QIconViewItem *)));
	connect(symbolsView, SIGNAL(clicked(QIconViewItem *)), this, SLOT(insertComponentSlot(QIconViewItem *)));
	
	// Filling Relations tab
	(void) new QIconViewItem(relationsView, "\\frac{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_frac.png")));
	(void) new QIconViewItem(relationsView, "^{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_index_upper.png")));
	(void) new QIconViewItem(relationsView, "_{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_index_lower.png")));
	(void) new QIconViewItem(relationsView, "\\sqrt{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sqrt.png")));
	(void) new QIconViewItem(relationsView, "\\sqrt[]{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sqrt_n.png")));
	(void) new QIconViewItem(relationsView, "\\geq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_geq.png")));
	(void) new QIconViewItem(relationsView, "\\leq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_leq.png")));
	(void) new QIconViewItem(relationsView, "\\sim",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sim.png")));
	(void) new QIconViewItem(relationsView, "\\neq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_neq.png")));
	(void) new QIconViewItem(relationsView, "\\equiv",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_equiv.png")));
	(void) new QIconViewItem(relationsView, "\\approx",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_approx.png")));
	(void) new QIconViewItem(relationsView, "\\simeq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_simeq.png")));
	(void) new QIconViewItem(relationsView, "\\ll",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_ll.png")));
	(void) new QIconViewItem(relationsView, "\\gg",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_gg.png")));
	(void) new QIconViewItem(relationsView, "\\pm",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_pm.png")));
	(void) new QIconViewItem(relationsView, "\\in",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_in.png")));
	(void) new QIconViewItem(relationsView, "\\ni",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_ni.png")));
	(void) new QIconViewItem(relationsView, "\\cap",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_cap.png")));
	(void) new QIconViewItem(relationsView, "\\cup",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_cup.png")));
	(void) new QIconViewItem(relationsView, "\\bigcap",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_bigcap.png")));
	(void) new QIconViewItem(relationsView, "\\bigcup",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_bigcup.png")));
	(void) new QIconViewItem(relationsView, "\\subset",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_subset.png")));
	(void) new QIconViewItem(relationsView, "\\supset",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_supset.png")));
	(void) new QIconViewItem(relationsView, "\\subseteq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_subseteq.png")));
	(void) new QIconViewItem(relationsView, "\\supseteq",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_supseteq.png")));
	(void) new QIconViewItem(relationsView, "\\sum{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sum.png")));
	(void) new QIconViewItem(relationsView, "\\sum\\limits_{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sum_from.png")));
	(void) new QIconViewItem(relationsView, "\\sum\\limits_{}^{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_sum_from_to.png")));
	(void) new QIconViewItem(relationsView, "\\prod{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_prod.png")));
	(void) new QIconViewItem(relationsView, "\\prod\\limits_{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_prod_from.png")));
	(void) new QIconViewItem(relationsView, "\\prod\\limits_{}^{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_prod_from_to.png")));
	(void) new QIconViewItem(relationsView, "\\int{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_int.png")));
	(void) new QIconViewItem(relationsView, "\\int\\limits_{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_int_from.png")));
	(void) new QIconViewItem(relationsView, "\\int\\limits_{}^{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_int_from_to.png")));
	(void) new QIconViewItem(relationsView, "\\oint{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_oint.png")));
	(void) new QIconViewItem(relationsView, "\\oint\\limits_{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_oint_from.png")));
	(void) new QIconViewItem(relationsView, "\\oint\\limits_{}^{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_oint_from_to.png")));
	(void) new QIconViewItem(relationsView, "\\lim_{}{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/relations_tab_lim.png")));
	
	// Filling Greek Letters tab
	(void) new QIconViewItem(greekLettersView, "\\alpha",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_alpha.png")));
	(void) new QIconViewItem(greekLettersView, "\\beta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_beta.png")));
	(void) new QIconViewItem(greekLettersView, "\\gamma",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_gamma.png")));
	(void) new QIconViewItem(greekLettersView, "\\Gamma",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Gamma.png")));
	(void) new QIconViewItem(greekLettersView, "\\delta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_delta.png")));
	(void) new QIconViewItem(greekLettersView, "\\Delta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Delta.png")));
	(void) new QIconViewItem(greekLettersView, "\\epsilon",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_epsilon.png")));
	(void) new QIconViewItem(greekLettersView, "\\varepsilon",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_varepsilon.png")));
	(void) new QIconViewItem(greekLettersView, "\\zeta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_zeta.png")));
	(void) new QIconViewItem(greekLettersView, "\\eta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_eta.png")));
	(void) new QIconViewItem(greekLettersView, "\\theta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_theta.png")));
	(void) new QIconViewItem(greekLettersView, "\\vartheta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_vartheta.png")));
	(void) new QIconViewItem(greekLettersView, "\\Theta",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Theta.png")));
	(void) new QIconViewItem(greekLettersView, "\\iota",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_iota.png")));
	(void) new QIconViewItem(greekLettersView, "\\kappa",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_kappa.png")));
	(void) new QIconViewItem(greekLettersView, "\\lambda",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_lambda.png")));
	(void) new QIconViewItem(greekLettersView, "\\Lambda",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Lambda.png")));
	(void) new QIconViewItem(greekLettersView, "\\mu",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_mu.png")));
	(void) new QIconViewItem(greekLettersView, "\\nu",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_nu.png")));
	(void) new QIconViewItem(greekLettersView, "\\xi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_xi.png")));
	(void) new QIconViewItem(greekLettersView, "\\Xi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Xi.png")));
	(void) new QIconViewItem(greekLettersView, "\\pi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_pi.png")));
	(void) new QIconViewItem(greekLettersView, "\\varpi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_varpi.png")));
	(void) new QIconViewItem(greekLettersView, "\\Pi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Pi.png")));
	(void) new QIconViewItem(greekLettersView, "\\rho",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_rho.png")));
	(void) new QIconViewItem(greekLettersView, "\\varrho",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_varrho.png")));
	(void) new QIconViewItem(greekLettersView, "\\sigma",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_sigma.png")));
	(void) new QIconViewItem(greekLettersView, "\\varsigma",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_varsigma.png")));
	(void) new QIconViewItem(greekLettersView, "\\Sigma",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Sigma.png")));
	(void) new QIconViewItem(greekLettersView, "\\tau",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_tau.png")));
	(void) new QIconViewItem(greekLettersView, "\\upsilon",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_upsilon.png")));
	(void) new QIconViewItem(greekLettersView, "\\phi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_phi.png")));
	(void) new QIconViewItem(greekLettersView, "\\varphi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_varphi.png")));
	(void) new QIconViewItem(greekLettersView, "\\Phi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Phi.png")));
	(void) new QIconViewItem(greekLettersView, "\\chi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_chi.png")));
	(void) new QIconViewItem(greekLettersView, "\\psi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_psi.png")));
	(void) new QIconViewItem(greekLettersView, "\\Psi",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Psi.png")));
	(void) new QIconViewItem(greekLettersView, "\\omega",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_omega.png")));
	(void) new QIconViewItem(greekLettersView, "\\Omega",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/greek_letters_tab_Omega.png")));
	
	// Filling arrows tab
	(void) new QIconViewItem(arrowsView, "\\vec{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_vec.png")));
	(void) new QIconViewItem(arrowsView, "\\swarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_swarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\leftarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_leftarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\nwarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_nwarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\uparrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_uparrow.png")));
	(void) new QIconViewItem(arrowsView, "\\nearrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_nearrow.png")));
	(void) new QIconViewItem(arrowsView, "\\rightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_rightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\searrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_searrow.png")));
	(void) new QIconViewItem(arrowsView, "\\leftrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_leftrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\updownarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_updownarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\longleftarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_longleftarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\longrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_longrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\longleftrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_longleftrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Leftarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Leftarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Rightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Rightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Uparrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Uparrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Downarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Downarrow.png")));	
	(void) new QIconViewItem(arrowsView, "\\Leftrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Leftrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Longleftarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Longleftarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Longrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Longrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\Longleftrightarrow",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_Longleftrightarrow.png")));
	(void) new QIconViewItem(arrowsView, "\\leftharpoonup",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_leftharpoonup.png")));
	(void) new QIconViewItem(arrowsView, "\\leftharpoondown",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_leftharpoondown.png")));
	(void) new QIconViewItem(arrowsView, "\\rightharpoonup",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_rightharpoonup.png")));
	(void) new QIconViewItem(arrowsView, "\\rightharpoondown",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_rightharpoondown.png")));
	(void) new QIconViewItem(arrowsView, "\\rightleftharpoons",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/arrows_tab_rightleftharpoons.png")));
	
	// Filling Delimiters tab
	(void) new QIconViewItem(delimitersView, "\\lbrace",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_lbrace.png")));
	(void) new QIconViewItem(delimitersView, "\\rbrace",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_rbrace.png")));
	(void) new QIconViewItem(delimitersView, "\\langle",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_langle.png")));
	(void) new QIconViewItem(delimitersView, "\\rangle",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_rangle.png")));
	(void) new QIconViewItem(delimitersView, "\\hat",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_hat.png")));
	(void) new QIconViewItem(delimitersView, "\\overbrace{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_overbrace.png")));
	(void) new QIconViewItem(delimitersView, "\\overbrace{}^{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_overbrace_desc.png")));
	(void) new QIconViewItem(delimitersView, "\\underbrace{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_underbrace.png")));
	(void) new QIconViewItem(delimitersView, "\\underbrace{}_{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_underbrace_desc.png")));
	(void) new QIconViewItem(delimitersView, "\\overline{}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_overline.png")));
	(void) new QIconViewItem(delimitersView, "\\underline{}",
		QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_underline.png")));
	(void) new QIconViewItem(delimitersView, "\\left(",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_left_bracket.png")));
	(void) new QIconViewItem(delimitersView, "\\right)",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_right_bracket.png")));
	(void) new QIconViewItem(delimitersView, "\\left[",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_left_square_bracket.png")));
	(void) new QIconViewItem(delimitersView, "\\right]",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_right_square_bracket.png")));
	(void) new QIconViewItem(delimitersView, "\\left{",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_left_lbrace.png")));
	(void) new QIconViewItem(delimitersView, "\\right}",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/delimiters_tab_right_rbrace.png")));
	
	// Filling Symbols tab
	(void) new QIconViewItem(symbolsView, "\\infty",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_infty.png")));
	(void) new QIconViewItem(symbolsView, "\\cdot",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_cdot.png")));
	(void) new QIconViewItem(symbolsView, "\\cdots",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_cdots.png")));
	(void) new QIconViewItem(symbolsView, "\\ldots",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_ldots.png")));
	(void) new QIconViewItem(symbolsView, "\\ddots",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_ddots.png")));
	(void) new QIconViewItem(symbolsView, "\\hbar",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_hbar.png")));
	(void) new QIconViewItem(symbolsView, "\\nabla",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_nabla.png")));
	(void) new QIconViewItem(symbolsView, "\\partial",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_partial.png")));
	(void) new QIconViewItem(symbolsView, "\\aleph",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_aleph.png")));
	(void) new QIconViewItem(symbolsView, "\\Re",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_Re.png")));
	(void) new QIconViewItem(symbolsView, "\\Im",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_Im.png")));
	(void) new QIconViewItem(symbolsView, "\\bot",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_bot.png")));
	(void) new QIconViewItem(symbolsView, "\\emptyset",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_emptyset.png")));
	(void) new QIconViewItem(symbolsView, "\\prime",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_prime.png")));
	(void) new QIconViewItem(symbolsView, "\\surd",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_surd.png")));
	(void) new QIconViewItem(symbolsView, "\\angle",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_angle.png")));
	(void) new QIconViewItem(symbolsView, "\\forall",
			QPixmap(dataPath("kadu/modules/data/powerkadu//mime_tex_icons/symbols_tab_forall.png")));
	
	
	QPushButton *okButton = new QPushButton(tr("&Ok"), this, "ok_button");
	QPushButton *cancelButton = new QPushButton(tr("&Cancel"), this, "cancel_button");
	
	formulaTextEdit = new QTextEdit(this, "formula_text_edit");
	formulaTextEdit->setTextFormat(PlainText);
	formulaTextEdit->setMinimumHeight(formulaTextEditMinimunHeight);
	mainLayout->addWidget(formulaTextEdit);
	connect(&timer, SIGNAL(timeout()), this, SLOT(timeoutSlot()));
	
	QHBoxLayout *buttonsLayout = new QHBoxLayout(mainLayout, 3, "buttons_layout");
	buttonsLayout->addStretch();
	buttonsLayout->addWidget(okButton);
	buttonsLayout->addWidget(cancelButton);
	
	connect(okButton, SIGNAL(clicked()), this, SLOT(okClickedSlot()));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
	connect(&mimeTeXProcess, SIGNAL(processExited()), formulaView, SLOT(fillView()));
	
	timer.start(config_file.readNumEntry("PowerKadu", "mimetex_refreshment_interval", 2000));
	formulaTextEdit->setFocus();
	
	kdebugf2();
}
TeXFormulaDialog::~TeXFormulaDialog()
{
	kdebugf();
	kdebugf2();
}

void TeXFormulaDialog::okClickedSlot()
{
	kdebugf();
	timer.stop();
	
	QFile file(tmpFileName);
	if(file.exists())
		chat->edit()->insertAt(QString("[IMAGE %1]").arg(tmpFileName), paragraph, index, false);
	
	accept();
	kdebugf2();
}

void TeXFormulaDialog::timeoutSlot()
{
	kdebugf();
	if(!mimeTeXProcess.isRunning())
	{
		QFile file(tmpFileName);
		if(file.exists())
			file.remove();
		QString formulaStr = formulaTextEdit->text();
		formulaStr.replace(QChar('\n'), QChar(' '));
		mimeTeXProcess.clearArguments();
		mimeTeXProcess.addArgument(libPath("kadu/modules/bin/powerkadu/mimetex"));
		mimeTeXProcess.addArgument("-o");
		mimeTeXProcess.addArgument("-e");
		mimeTeXProcess.addArgument(tmpFileName);
		mimeTeXProcess.addArgument(formulaStr);
		if(!mimeTeXProcess.start())
			QMessageBox::critical(this, tr("TeX formula creator"), tr("Unable to run mimetex binary!"),
					      QMessageBox::Ok, 0);
	}
	kdebugf2();
}

void TeXFormulaDialog::insertComponentSlot(QIconViewItem *item)
{
	kdebugf();
	if(item)
		formulaTextEdit->insert(item->text());
	formulaTextEdit->setFocus();
	kdebugf2();
}

int TeXFormulaDialog::tmpFileNumber = 0;
