#ifndef CENZOR_H
#define CENZOR_H

#include <qobject.h>
#include "usergroup.h"
#include <qmap.h>

class Chat;
class PowerKadu;
class Protocol;

class Cenzor : public QObject
{
	Q_OBJECT;
    
	private:
		QStringList listWords;
		QStringList okList;

		/*!
			\fn int check(QCString& msg)
			\param msg the message to receive
		*/
		int check(QCString& msg);
		
		/*!
			\fn void admonition(UserListElements senders)
			\param senders list of adminition receivers
		*/
		void admonition(UserListElements senders);
		
		void words_read();
		void words_save();

		int checkOkWords(QString txt);
		void AddListbox();
		void create_gui();
		void kill_gui();

	public:
		//! Default constructor
		/*! 
			\param pk pointer to PowerKadu object
		*/
		Cenzor(PowerKadu *pk);

		//! Default destructor
		~Cenzor();


	private slots:
		//! This slot is called when the "PowerKadu" tab is selected in config dialog
		void onCreateTab();
		void swearwordSelected(int);
		void changeSwearword();
		void addNew();
		void deleteSwear();


	public slots:
		void messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop);
};

#endif
