#ifndef EXEC_NOTIFY_H
#define EXEC_NOTIFY_H

#include <qobject.h>
#include <qstringlist.h>

#include "../notify/notify.h"

class ExecNotify : public Notifier
{
	Q_OBJECT
//	private:
//	private slots:

	public:
		ExecNotify(QObject *parent = 0, const char *name = 0);
		~ExecNotify();

	public slots:
		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);
		void connectionError(Protocol *protocol, const QString &message);
		void userChangedStatusToAvailable(const QString &protocolName, UserListElement);
		void userChangedStatusToBusy(const QString &protocolName, UserListElement);
		void userChangedStatusToInvisible(const QString &protocolName, UserListElement);
		void userChangedStatusToNotAvailable(const QString &protocolName, UserListElement);

		void userStatusChanged(UserListElement ule, QString protocolName, const UserStatus &oldStatus);

		void run(const QStringList &args, const QString &stdin);

		virtual void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules);

/*	private slots:
		void onCreateConfigDialog();
		void onApplyConfigDialog();
		void onCloseConfigDialog();*/
};

extern ExecNotify *exec_notify;
#endif
