#if HAVE_CONFIG_H
#  include <config.h>
#endif

#if USE_XCURSES
#  define XCURSES 1
#  if HAVE_XCURSES_H
#    include <xcurses.h>
#  elif HAVE_CURSES_H
#    include <curses.h>
#  endif
#elif USE_NCURSES
#  if HAVE_NCURSES_H
#    include <ncurses.h>
#  elif HAVE_NCURSES_NCURSES_H
#    include <ncurses/ncurses.h>
#  elif HAVE_NCURSES_CURSES_H
#    include <ncurses/curses.h>
#  elif HAVE_CURSES_H
#    include <curses.h>
#  endif
#elif USE_PDCURSES
#  if HAVE_PDCURSES_H
#    include <pdcurses.h>
#  elif HAVE_CURSES_H
#    include <curses.h>
#  endif
#elif USE_SLANG
#  if HAVE_SLCURSES_H
#    include <slcurses.h>
#  elif HAVE_SLANG_SLCURSES_H
#    include <slang/slcurses.h>
#  elif HAVE_CURSES_H
#    include <curses.h>
#  endif
#else
#  if HAVE_CURSES_H
#    include <curses.h>
#  endif
#endif

#if HAVE_CONFIG_H /* Do not define these replacements during ./configure */

#  if !HAVE_VW_PRINTW
#    include <stdarg.h>
int vw_printw(WINDOW *win, const char *fmt, va_list ap);
#  endif

#  if !HAVE_MVWVLINE
int mvwvline(WINDOW *wnd, int y, int x, int ch, int n);
#  endif

#  if !HAVE_WVLINE
int wvline(WINDOW *wnd, chtype ch, int n);
#  endif

#  if !HAVE_GETCURX
int getcurx(WINDOW *wnd);
int getcury(WINDOW *wnd);
#  endif

#  if !HAVE_GETBEGX
int getbegx(WINDOW *wnd);
int getbegy(WINDOW *wnd);
#  endif

#  if !HAVE_GETBEGYX
#    if USE_SLANG
#      define getbegyx(wnd, y, x) ((y) = (wnd)->_begy, (x) = (wnd)->_begx)
#    endif
#  endif

#  if !HAVE_WGETNSTR
int wgetnstr(WINDOW *wnd, char *str, int n);
#  endif

#  if !HAVE_DERWIN
WINDOW *derwin(WINDOW *wnd, int h, int w, int rel_y, int rel_x);
#  endif

#  if !HAVE_INTRFLUSH
int intrflush(WINDOW *wnd, bool bf);
#  endif

#  if !HAVE_GETMAXX
int getmaxx(WINDOW *wnd);
int getmaxy(WINDOW *wnd);
#  endif

#endif
