package GCPlugins::GCDicschop;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginDicshop;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            return if $self->{parsingEnded};
            if (($tagname eq 'a')
             && ($attr->{href} =~ /ds\.php\?red=ds_produkt/))
            {
                $self->{isMovie} = 1;
                $self->{movieIdx}++;
                $self->{movieList}[$self->{movieIdx}]->{url} = $attr->{href};
                my $info = $attr->{title};
                if ($info =~ /.*?fr.n ([0-9]{4}) med (.*?) och (.*)\.$/)
                {
                    $self->{movieList}[$self->{movieIdx}]->{year} = $1;
                    $self->{movieList}[$self->{movieIdx}]->{actors} = "$2,$3";
                }
            }
            elsif (($tagname eq 'font')
                && ($attr->{style} eq 'font-size:14px;'))
            {
                $self->{insideCategoryTitle} = 1;
            }
        }
        else
        {
            if ($tagname eq 'font')
            {
                if ($attr->{class} eq 'dsrubrik3')
                {
                    $self->{isInfo} = 1;
                }
                elsif ($attr->{class} eq 'dsrubrik5')
                {
                    $self->{isTitle} = 1;
                }
                elsif ($attr->{color} eq '#909090')
                {
                    print "Detected 1\n";
                    $self->{isPotentialSynopsis} = 1;
                }
            }
            elsif ($tagname eq 'img')
            {
                if ($attr->{src} =~ m{http://www.discshop.se/LIVE/shop/img/omslag/front_normal/})
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
            elsif ($tagname eq 'table')
            {
                $self->{isSynopsis} = 0;
                $self->{curInfo}->{synopsis} =~ s/\n*$//;
            }
            elsif ($tagname eq 'br')
            {
                $self->{curInfo}->{synopsis} .= "\n"
                    if ($self->{isSynopsis} && $self->{curInfo}->{synopsis});
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        $origtext =~ s/^\s*//;
        $origtext =~ s/\s*$//;
        return if !$origtext;

        if ($self->{parsingList})
        {
            if ($self->{insideCategoryTitle})
            {
                $self->{parsingEnded} = 1 if $origtext eq 'Spel';
                $self->{insideCategoryTitle} = 0;
            }
            elsif (($self->{isMovie})
                && (!$self->{movieList}[$self->{movieIdx}]->{title}))
            {
                $self->{movieList}[$self->{movieIdx}]->{title} = $origtext;
                $self->{isMovie} = 1;
            }
        }
        else
        {
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isInfo})
            {
                $origtext =~ /(.*?) fr.n ([0-9]{4}) av (.*?) med (.*?) och (.*)\.$/;
                $self->{curInfo}->{type} = $1;
                $self->{curInfo}->{date} = $2;
                $self->{curInfo}->{director} = $3;
                $self->{curInfo}->{actors} = "$4,$5";
                $self->{isInfo} = 0;
            }
            elsif ($self->{isSynopsis})
            {
                $self->{isPotentialSynopsis} = 0;
                print "Adding $origtext\n";
                $self->{curInfo}->{synopsis} .= $origtext;
            }
            elsif ($self->{isPotentialSynopsis})
            {
                if ($origtext eq 'Handling:')
                {
                    $self->{isSynopsis} = 1;
                    print "Detected 2\n";
                    $self->{curInfo}->{synopsis} = '';
                }
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $self->{parsingEnded} = 0;
            $self->{insideCategoryTitle} = 0;
        }
        else
        {
            $self->{isInfo} = 0;
            $self->{isTitle} = 0;
            $self->{isPotentialSynopsis} = 0;
            $self->{isSynopsis} = 0;
            $html =~ s/<A.*?ds_kategori.*?>(.*?)<\/A>/$1/g;
            $html =~ s/<A.*?ds_person.*?>(.*?)<\/A>/$1/g;
            $html =~ s/<FONT COLOR="white">i<\/font>//g;
            $html =~ s/<IMG SRC="img\/design\/pix.gif" WIDTH=2 HEIGHT=5>//g;
        }

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.discshop.se/LIVE/shop/sokresultat.php?ref=&lang=&soktext=$word&sok_typ=titel";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.discshop.se/LIVE/shop/'.$url;
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "Dicshop.se";
    }
    
    sub getImageFile
    {
        return "dicshop.se.png";
    }

    sub getCharset
    {
        my $self = shift;
    
        return "Windows-1252";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'SE';
    }
    
    sub hasSearchDirector
    {
        return 0;
    }
    
}

1;
