# -*- coding: utf-8 -*-

#  Copyright © 2008 Reinout van Schouwen <reinouts@gnome.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

import epiphany;
import gtk;

_ui_str = """
<ui>
	<menubar name="menubar">
		<menu name="FileMenu" action="File">
			<separator/>
			<menuitem name="Quit" action="Quit"/>
			<separator/>
		</menu>
	</menubar>
</ui>
"""

def quit_cb(action, window):
	for tab in window.get_notebook():
		tab.close()
	
_actions = [
	('Quit', "gtk-quit", None, None, None, quit_cb)]
	
def attach_window(window):
	ui_manager = window.get_ui_manager()
	group = gtk.ActionGroup('Quit')
	group.add_actions(_actions, window)
	window._quit_group = group
	ui_manager.insert_action_group(group, 0)
	window._quit_ui = ui_manager.add_ui_from_string(_ui_str)

def detach_window(window):
	ui_manager = window.get_ui_manager()
	ui_manager.remove_ui (window._quit_ui)
	del window._quit_ui
	ui_manager.remove_action_group (window._quit_group)
	del window._quit_group
