#   Less Tab Label Border - Epiphany Extension
#   Copyright (C) 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany

tab_label_hborder = 1
tab_label_vborder = 1

def attach_window(window):
	notebook = window.get_notebook()

	borders = (notebook.get_property("tab-hborder"), notebook.get_property("tab-vborder"))
	window._tlb_tab_label_borders = borders

	notebook.set_property("tab-hborder", tab_label_hborder)
	notebook.set_property("tab-vborder", tab_label_vborder)

def detach_window(window):
	if not hasattr(window, "_tlb_tab_label_borders"):
		return

	notebook = window.get_notebook()
	hborder, vborder = window._tlb_tab_label_borders

	notebook.set_property("tab-hborder", hborder)
	notebook.set_property("tab-vborder", vborder)

	delattr(window, "_tlb_tab_label_borders")
