#!/usr/bin/python
# -*- encoding: utf-8; py-indent-offset: 4 -*-
# +------------------------------------------------------------------+
# |             ____ _               _        __  __ _  __           |
# |            / ___| |__   ___  ___| | __   |  \/  | |/ /           |
# |           | |   | '_ \ / _ \/ __| |/ /   | |\/| | ' /            |
# |           | |___| | | |  __/ (__|   <    | |  | | . \            |
# |            \____|_| |_|\___|\___|_|\_\___|_|  |_|_|\_\           |
# |                                                                  |
# | Copyright Mathias Kettner 2010             mk@mathias-kettner.de |
# +------------------------------------------------------------------+
#
# This file is part of Check_MK.
# The official homepage is at http://mathias-kettner.de/check_mk.
#
# check_mk is free software;  you can redistribute it and/or modify it
# under the  terms of the  GNU General Public License  as published by
# the Free Software Foundation in version 2.  check_mk is  distributed
# in the hope that it will be useful, but WITHOUT ANY WARRANTY;  with-
# out even the implied warranty of  MERCHANTABILITY  or  FITNESS FOR A
# PARTICULAR PURPOSE. See the  GNU General Public License for more de-
# ails.  You should have  received  a copy of the  GNU  General Public
# License along with GNU Make; see the file  COPYING.  If  not,  write
# to the Free Software Foundation, Inc., 51 Franklin St,  Fifth Floor,
# Boston, MA 02110-1301 USA.

multisite_builtin_views.update({
 'allhosts': {'browser_reload': 30,
              'column_headers': 'pergroup',
              'datasource': 'hosts',
              'description': 'Overall state of allhosts, with counts of services in the various states.',
              'group_painters': [('sitealias', None)],
              'hard_filters': ['summary_host'],
              'hard_filtervars': [('site', ''),
                                  ('is_summary_host', '0'),
                                  ('host', ''),
                                  ('opthostgroup', '')],
              'hidden': False,
              'hide_filters': [],
              'layout': 'table',
              'mustsearch': False,
              'name': 'allhosts',
              'num_columns': 3,
              'owner': '',
              'painters': [('host_state', None),
                           ('host', 'host'),
                           ('host_icons', None),
                           ('num_services_ok', 'host_ok'),
                           ('num_services_warn', 'host_warn'),
                           ('num_services_unknown', 'host_unknown'),
                           ('num_services_crit', 'host_crit'),
                           ('num_services_pending', 'host_pending')],
              'play_sounds': False,
              'public': True,
              'show_filters': ['siteopt', 'hostregex', 'opthostgroup'],
              'sorters': [('site', False), ('site_host', False)],
              'title': _('All hosts'),
              'topic': _('Hosts')},
 'allhosts_mini': {'browser_reload': 30,
                   'column_headers': 'pergroup',
                   'datasource': 'hosts',
                   'description': '',
                   'group_painters': [('sitealias', None)],
                   'hard_filters': ['summary_host',],
                   'hard_filtervars': [('site', ''),
                                       ('host', ''),
                                       ('is_summary_host', '0'),
                                       ('opthostgroup', '')],
                   'hidden': False,
                   'hide_filters': [],
                   'layout': 'table',
                   'mustsearch': False,
                   'name': 'allhosts_mini',
                   'num_columns': 6,
                   'owner': '',
                   'painters': [('host_state', None),
                                ('host', 'host'),
                                ('num_problems', 'problemsofhost')],
                   'play_sounds': False,
                   'public': True,
                   'show_filters': ['siteopt', 'hostregex', 'opthostgroup'],
                   'sorters': [('site', False), ('site_host', False)],
                   'title': _('All hosts (Mini)'),
              'topic': _('Hosts')},
 'allservices': {'browser_reload': 90,
                 'column_headers': 'pergroup',
                 'datasource': 'services',
                 'description': 'All services grouped\r\nby hosts.',
                 'group_painters': [('sitealias', 'sitehosts'),
                                    ('host_with_state', 'host')],
                 'hard_filters': ['summary_host'],
                 'hard_filtervars': [('is_service_in_notification_period',
                                      '-1'),
                                     ('optservicegroup', ''),
                                     ('is_service_notifications_enabled',
                                      '-1'),
                                     ('is_host_in_notification_period',
                                      '-1'),
                                     ('is_in_downtime', '-1'),
                                     ('is_service_scheduled_downtime_depth',
                                      '-1'),
                                     ('is_service_acknowledged', '-1'),
                                     ('host', ''),
                                     ('is_service_active_checks_enabled',
                                      '-1'),
                                     ('is_summary_host', '0'),
                                     ('service', ''),
                                     ('check_command', ''),
                                     ('st0', 'on'),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', 'on'),
                                     ('opthostgroup', ''),
                                     ('service_output', ''),
                                     ('is_service_is_flapping', '-1')],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'allservices',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('service_state', None),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('service_icons', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('perfometer', None)],
                 'play_sounds': False,
                 'public': True,
                 'show_filters': ['service_in_notification_period',
                                  'optservicegroup',
                                  'service_notifications_enabled',
                                  'host_in_notification_period',
                                  'in_downtime',
                                  'service_scheduled_downtime_depth',
                                  'service_acknowledged',
                                  'hostregex',
                                  'service_active_checks_enabled',
                                  'summary_host',
                                  'serviceregex',
                                  'check_command',
                                  'svcstate',
                                  'opthostgroup',
                                  'output',
                                  'service_is_flapping'],
                 'sorters': [('site', False),
                             ('site_host', False),
                             ('svcdescr', False)],
                 'title': _('All services'),
              'topic': _('Services')},
 'comments': {'column_headers': 'pergroup',
              'datasource': 'comments',
              'description': 'All host- and service comments',
              'group_painters': [('comment_what', None)],
              'hard_filters': [],
              'hard_filtervars': [('host', ''), ('service', '')],
              'hidden': False,
              'hide_filters': [],
              'icon' : 'comment',
              'layout': 'table',
              'mustsearch': False,
              'name': 'comments',
              'num_columns': 1,
              'owner': '',
              'painters': [('comment_author', None),
                           ('comment_time', None),
                           ('comment_expires', None),
                           ('comment_entry_type', None),
                           ('comment_comment', None),
                           ('host', None),
                           ('service_description', 'service'),
                           ('comment_id', None)],
              'public': True,
              'show_filters': ['hostregex', 'serviceregex'],
              'sorters': [('comment_type', False), ('comment_author', False)],
              'title': _('Comments')
 },
 'comments_of_host': {'column_headers': 'pergroup',
                      'datasource': 'comments',
                      'description': 'Linkable view showing\r\nall comments of a specific host',
                      'group_painters': [],
                      'hard_filters': ['service'],
                      'hard_filtervars': [('service', '')],
                      'hidden': True,
                      'hide_filters': ['site', 'host'],
                      'icon' : 'comment',
                      'layout': 'table',
                      'mustsearch': False,
                      'name': 'comments_of_host',
                      'num_columns': 1,
                      'owner': '',
                      'painters': [('comment_author', None),
                                   ('comment_comment', None),
                                   ('comment_time', None),
                                   ('comment_entry_type', None)],
                      'public': True,
                      'show_filters': [],
                      'sorters': [],
                      'linktitle': _('Host comments'),
                      'title': _('Comments of host'),
                      },

 'comments_of_service': {'column_headers': 'pergroup',
                         'datasource': 'comments',
                         'description': 'Linkable view showing\r\nall comments of a specific service',
                         'group_painters': [],
                         'hard_filters': [],
                         'hard_filtervars': [],
                         'hidden': True,
                         'hide_filters': ['site', 'host', 'service'],
                         'icon' : 'comment',
                         'layout': 'table',
                         'mustsearch': False,
                         'name': 'comments_of_service',
                         'num_columns': 1,
                         'owner': '',
                         'painters': [('comment_author', None),
                                      ('comment_comment', None),
                                      ('comment_time', None),
                                      ('comment_entry_type', None)],
                         'public': True,
                         'show_filters': [],
                         'sorters': [],
                         'linktitle': _('Comments'),
                         'title': _('Comments of service'),
                        },
 'downtimes': {'column_headers': 'pergroup',
               'datasource': 'downtimes',
               'description': 'All host- und service-downtimes',
               'group_painters': [('downtime_what', None)],
               'hard_filters': [],
               'hard_filtervars': [('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('host', ''),
                                   ('service', '')],
               'hidden': False,
               'hide_filters': [],
               'icon' : 'downtime',
               'layout': 'table',
               'mustsearch': False,
               'name': 'downtimes',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'host'),
                            ('service_description', 'service'),
                            ('downtime_author', None),
                            ('downtime_entry_time', None),
                            ('downtime_start_time', None),
                            ('downtime_end_time', None),
                            ('downtime_fixed', None),
                            ('downtime_duration', None),
                            ('downtime_comment', None)],

               'public': True,
               'show_filters': ['service_scheduled_downtime_depth',
                                'hostregex',
                                'serviceregex'],
               'sorters': [('downtime_what', False),
                           ('downtime_start_time', False)],
               'title': _('Downtimes')},
 'downtimes_of_host': {'column_headers': 'pergroup',
                       'datasource': 'downtimes',
                       'description': '',
                       'group_painters': [],
                       'hard_filters': [],
                       'hard_filtervars': [],
                       'hidden': True,
                       'hide_filters': ['site', 'host'],
                       'icon' : 'downtime',
                       'layout': 'table',
                       'mustsearch': False,
                       'name': 'downtimes_of_host',
                       'num_columns': 1,
                       'owner': '',
                       'painters': [('downtime_author', None),
                            ('downtime_entry_time', None),
                            ('downtime_start_time', None),
                            ('downtime_end_time', None),
                            ('downtime_fixed', None),
                            ('downtime_duration', None),
                            ('downtime_comment', None)],
                       'public': True,
                       'show_filters': [],
                       'sorters': [],
                       'linktitle': _('Host downtimes'),
                       'title': _('Downtimes of host')},
 'downtimes_of_service': {'column_headers': 'pergroup',
                          'datasource': 'downtimes',
                          'description': '',
                          'group_painters': [],
                          'hard_filters': [],
                          'hard_filtervars': [],
                          'hidden': True,
                          'hide_filters': ['site', 'service', 'host'],
                          'icon' : 'downtime',
                          'layout': 'table',
                          'mustsearch': False,
                          'name': 'downtimes_of_service',
                          'num_columns': 1,
                          'owner': '',
                          'painters': [('downtime_author', None),
                                    ('downtime_entry_time', None),
                                    ('downtime_start_time', None),
                                    ('downtime_end_time', None),
                                    ('downtime_fixed', None),
                                    ('downtime_duration', None),
                                    ('downtime_comment', None)],
                          'public': True,
                          'show_filters': [],
                          'sorters': [],
                          'linktitle': _('Downtimes'),
                          'title': _('Downtimes of service')},
 'host': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host. The host and site must be set via HTML variables.',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': [],
          'hard_filtervars': [('st0', 'on'),
                              ('st1', 'on'),
                              ('st2', 'on'),
                              ('st3', 'on'),
                              ('stp', 'on')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('service_icons', None),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate', 'serviceregex'],
          'sorters': [('svcdescr', False)],
          'linktitle': _('Services'),
          'title': _('Services of Host')},
'hosts': {'browser_reload': 30,
           'column_headers': 'off',
           'datasource': 'services',
           'description': 'All services of of hosts which match a name',
           'group_painters': [('sitealias', 'sitehosts'), ('host', 'host')],
           'hard_filters': [],
           'hard_filtervars': [('host', ''),
                               ('st0', 'on'),
                               ('st1', 'on'),
                               ('st2', 'on'),
                               ('st3', 'on'),
                               ('stp', 'on')],
           'hidden': True,
           'hide_filters': [],
           'layout': 'boxed',
           'linktitle': _('Services of Hosts'),
           'mustsearch': False,
           'name': 'hosts',
           'num_columns': 1,
           'owner': '',
           'painters': [('service_state', None),
                        ('service_description', 'service'),
                        ('svc_plugin_output', None),
                        ('svc_state_age', None),
                        ('svc_check_age', None),
                        ('service_icons', None),
                        ('perfometer', None)],
           'play_sounds': False,
           'public': True,
           'show_filters': ['hostregex', 'svcstate'],
           'sorters': [('site', False),
                       ('site_host', False),
                       ('svcdescr', False)],
           'title': _('Services of Hosts'),
           'topic': _('Other')},
'host_ok': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host that are in state OK',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', 'on'),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_lk',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Services: OK'),
          'title': _('OK Services of host')},
'host_warn': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host that are in state WARN',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', 'on'),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_warn',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Services: WARN'),
          'title': _('WARN Services of host')},
'host_crit': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host that are in state CRIT',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', 'on'),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_crit',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Services: CRIT'),
          'title': _('CRIT Services of host')},
'host_unknown': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host that are in state UNKNOWN',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', 'on'),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_unknown',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Services: UNKNOWN'),
          'title': _('UNKNOWN Services of host')},
'host_pending': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All services of a given host that are PENDING',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', 'on')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_pending',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Services: PENDING'),
          'title': _('PENDING Services of host')},
'problemsofhost': {'browser_reload': 30,
          'column_headers': 'pergroup',
          'datasource': 'services',
          'description': 'All problem services of a given host. The host and site must be set via HTML variables.',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', 'on'),
                              ('st2', 'on'),
                              ('st3', 'on'),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'problemsofhost',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : _('Host Problems'),
          'title': _('Problems of host')},
 'hostgroup': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hosts',
               'description': '',
               'group_painters': [('site_icon', None),
                                  ('sitealias', 'sitehosts')],
               'hard_filters': [],
               'hard_filtervars': [],
               'hidden': True,
               'hide_filters': ['hostgroup'],
               'layout': 'boxed',
               'linktitle': _('Hostgroup Overview'),
               'mustsearch': False,
               'name': 'hostgroup',
               'num_columns': 2,
               'owner': 'admin',
               'painters': [('host_state', None),
                            ('host', 'host'),
                            ('host_icons', None),
                            ('alias', None),
                            ('num_services_ok', 'host_ok'),
                            ('num_services_warn', 'host_warn'),
                            ('num_services_unknown', 'host_unknown'),
                            ('num_services_crit', 'host_crit'),
                            ('num_services_pending', 'host_pending')],
               'play_sounds': False,
               'public': True,
               'show_filters': [],
               'sorters': [('site', False), ('site_host', False)],
               'title': _('Hostgroup'),
               'topic': _('hidden')},
 'hostgroupservices': {'browser_reload': 90,
                       'column_headers': 'off',
                       'datasource': 'services',
                       'description': 'All services of a certain hostgroup',
                       'group_painters': [('sitealias', 'sitehosts'),
                                          ('host_with_state', 'host')],
                       'hard_filters': [],
                       'hard_filtervars': [('is_service_in_notification_period',
                                            '-1'),
                                           ('optservicegroup', ''),
                                           ('neg_optservicegroup', ''),
                                           ('is_service_notifications_enabled',
                                            '-1'),
                                           ('is_host_in_notification_period',
                                            '-1'),
                                           ('is_service_scheduled_downtime_depth',
                                            '-1'),
                                           ('is_service_acknowledged', '-1'),
                                           ('host', ''),
                                           ('is_service_active_checks_enabled',
                                            '-1'),
                                           ('service', ''),
                                           ('check_command', ''),
                                           ('st0', 'on'),
                                           ('st1', 'on'),
                                           ('st2', 'on'),
                                           ('st3', 'on'),
                                           ('stp', 'on'),
                                           ('is_in_downtime', '-1'),
                                           ('service_output', ''),
                                           ('is_service_is_flapping', '-1')],
                       'hidden': True,
                       'hide_filters': ['hostgroup'],
                       'layout': 'table',
                       'linktitle': _('Services'),
                       'mustsearch': False,
                       'name': 'hostgroupservices',
                       'num_columns': 2,
                       'owner': 'admin',
                       'painters': [('service_state', None),
                                    ('service_description', 'service'),
                                    ('svc_plugin_output', None),
                                    ('service_icons', None),
                                    ('svc_state_age', None),
                                    ('svc_check_age', None)],
                       'play_sounds': False,
                       'public': True,
                       'show_filters': ['service_in_notification_period',
                                        'optservicegroup',
                                        'service_notifications_enabled',
                                        'host_in_notification_period',
                                        'service_scheduled_downtime_depth',
                                        'service_acknowledged',
                                        'hostregex',
                                        'service_active_checks_enabled',
                                        'serviceregex',
                                        'check_command',
                                        'svcstate',
                                        'in_downtime',
                                        'output',
                                        'service_is_flapping'],
                       'sorters': [('site', False),
                                   ('site_host', False),
                                   ('svcdescr', False)],
                       'title': _('Services of Hostgroup'),
                       'topic': _('hidden')},
 'hostgroupgrid': {'browser_reload': 30,
               'column_headers': 'pergroup',
                   'datasource': 'hostsbygroup',
                   'description': 'Hosts grouped by hostgroups, with a brief list of all services',
                   'group_painters': [('sitealias', 'sitehosts'),
                                      ('hg_alias', 'hostgroup')],
                   'hard_filters': [],
                   'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                        '-1'),
                                       ('is_host_in_notification_period',
                                        '-1'),
                                       ('site', ''),
                                       ('is_summary_host', '-1'),],
                   'hidden': False,
                   'hide_filters': [],
                   'layout': 'boxed',
                   'mustsearch': False,
                   'name': 'hostgroupgrid',
                   'num_columns': 2,
                   'owner': '',
                   'painters': [('host', 'host'),
                                ('host_services', None),
                                ('host_icons', None)],
                   'public': True,
                   'show_filters': ['host_scheduled_downtime_depth',
                                    'host_in_notification_period',
                                    'siteopt',
                                    'summary_host',
                                    ],
                   'sorters': [('site', False),
                               ('hostgroup', False),
                               ('site_host', False)],
                   'title': _('Hostgroups (Grid)'),
                   'topic': _('Hostgroups')},
 'hostgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                'datasource': 'hostgroups',
                'description': 'A short overview over all host groups, without an explicity listing of the actual hosts',
                'group_painters': [('sitealias', 'sitehosts')],
                'hard_filters': [],
                'hard_filtervars': [],
                'hidden': False,
                'hide_filters': [],
                'layout': 'boxed',
                'mustsearch': False,
                'name': 'hostgroups',
                'num_columns': 3,
                'owner': '',
                'painters': [('hg_name', 'hostgroup'),
                             ('hg_alias', None),
                             ('hg_num_hosts_up', None),
                             ('hg_num_hosts_down', None),
                             ('hg_num_hosts_unreach', None),
                             ('hg_num_hosts_pending', None),
                             ('hg_num_services_ok', None),
                             ('hg_num_services_warn', None),
                             ('hg_num_services_crit', None),
                             ('hg_num_services_unknown', None),
                             ('hg_num_services_pending', None)],
                'public': True,
                'show_filters': [],
                'sorters': [],
                'title': _('Hostgroups (Summary)'),
                'topic': _('Hostgroups') },

 'hostproblems': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'hosts',
                  'description': 'A complete list of all host problems with a search form for selecting handled and unhandled',
                  'group_painters': [('host_state', None)],
                  'hard_filters': ['host_scheduled_downtime_depth', 'summary_host'],
                  'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                       '0'),
                                      ('is_host_in_notification_period',
                                       '-1'),
                                      ('hst0', ''),
                                      ('hst1', 'on'),
                                      ('hst2', 'on'),
                                      ('hstp', ''),
                                      ('is_host_acknowledged', '-1'),
                                      ('host', ''),
                                      ('is_summary_host', '0'),
                                      ('opthostgroup', '')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'hostproblems',
                  'num_columns': 3,
                  'owner': '',
                  'painters': [('host', 'host'),
                               ('host_icons', None),
                               ('host_state', None),
                               ('host_plugin_output', None),
                               ('num_services_ok', 'host_ok'),
                               ('num_services_warn', 'host_warn'),
                               ('num_services_crit', 'host_crit'),
                               ('num_services_unknown', 'host_unknown'),
                               ('num_services_pending', 'host_pending')],
                  'play_sounds' : True,
                  'public': True,
                  'show_filters': ['host_in_notification_period',
                                   'hoststate',
                                   'hostregex',
                                   'opthostgroup',
                                   'host_acknowledged'],
                  'sorters': [],
                  'title': _('Host problems'),
                  'topic': _('Problems')},



 'hostsbygroup': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'hostsbygroup',
                  'description': 'A complete listing of\r\nall host groups and each of their hosts',
                  'group_painters': [('sitealias', 'sitehosts'),
                                     ('hg_alias', 'hostgroup')],
                  'hard_filters': [],
                  'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                       '-1'),
                                      ('is_host_in_notification_period',
                                       '-1'),
                                      ('site', ''),
                                      ('is_summary_host', '-1')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'hostsbygroup',
                  'num_columns': 2,
                  'owner': '',
                  'painters': [('host_state', None),
                               ('host', 'host'),
                               ('host_icons', None),
                               ('alias', 'hoststatus'),
                               ('num_services_ok', 'host_ok'),
                               ('num_services_warn', 'host_warn'),
                               ('num_services_unknown', 'host_unknown'),
                               ('num_services_crit', 'host_crit'),
                               ('num_services_pending', 'host_pending')],
                  'public': True,
                  'show_filters': ['host_scheduled_downtime_depth',
                                   'host_in_notification_period',
                                   'siteopt',
                                   'summary_host'],
                  'sorters': [('site', False),
                              ('hostgroup', False),
                              ('site_host', False)],
                  'title': _('Hostgroups'),
                  'topic': _('Hostgroups')},
 'hoststatus': {'browser_reload': 30,
               'column_headers': 'pergroup',
                'datasource': 'hosts',
                'description': '',
                'group_painters': [],
                'hard_filters': [],
                'hard_filtervars': [],
                'hidden': True,
                'hide_filters': ['site', 'host'],
                'layout': 'dataset',
                'mustsearch': False,
                'name': 'hoststatus',
                'owner': '',
                'painters': [('sitealias', None),
                             ('host', 'host'),
                             ('alias', None),
                             ('host_icons', None),
                             ('host_state', None),
                             ('host_address', None),
                             ('host_group_memberlist', None),
                             ('host_parents', None),
                             ('host_childs', None),
                             ('host_contact_groups', None),
                             ('host_contacts', None),
                             ('host_plugin_output', None),
                             ('host_perf_data', None),
                             ('host_attempt', None),
                             ('host_check_type', None),
                             ('host_state_age', None),
                             ('host_check_age', None),
                             ('host_next_check', None),
                             ('host_next_notification', None),
                             ('host_last_notification', None),
                             ('host_check_latency', None),
                             ('host_check_duration', None),
                             ('host_in_downtime', None),
                             ('host_in_notifper', None),
                             ('host_notifper', None),
                             ('num_services', None),
                             ('num_services_ok', 'host_ok'),
                             ('num_services_warn', 'host_warn'),
                             ('num_services_crit', 'host_crit'),
                             ('num_services_unknown', 'host_unknown'),
                             ('num_services_pending', 'host_pending'),
                             ('host_custom_notes', None),
                             ('host_pnpgraph', None),
                             ],
                'public': True,
                'show_filters': [],
                'sorters': [],
                'linktitle': _('Host status'),
                'title': _('Status of Host')},
'pendingsvc': {'browser_reload': 30,
                'column_headers': 'off',
                'datasource': 'services',
                'description': '',
                'group_painters': [('host', 'host')],
                'hard_filters': ['summary_host', 'svcstate'],
                'hard_filtervars': [('is_summary_host', '0'),
                                    ('st0', ''),
                                    ('st1', ''),
                                    ('st2', ''),
                                    ('st3', ''),
                                    ('stp', 'on')],
                'hidden': False,
                'hide_filters': [],
                'layout': 'boxed',
                'linktitle': _('Pending Services'),
                'mustsearch': False,
                'name': 'pendingsvc',
                'num_columns': 5,
                'owner': '',
                'painters': [('service_description', 'service')],
                'play_sounds': False,
                'public': True,
                'show_filters': [],
                'sorters': [],
                'title': _('Pending Services'),
                'topic': _('Problems')},
 'searchhost': {'browser_reload': 60,
                'column_headers': 'pergroup',
                'datasource': 'hosts',
                'description': 'A form for search hosts after a couple of criteria.',
                'group_painters': [('sitealias', None)],
                'hard_filters': [],
                'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                     '-1'),
                                    ('is_host_in_notification_period', '-1'),
                                    ('hst0', 'on'),
                                    ('hst1', 'on'),
                                    ('hst2', 'on'),
                                    ('hstp', 'on'),
                                    ('site', ''),
                                    ('host', ''),
                                    ('is_summary_host', '-1'),
                                    ('opthostgroup', ''),
                                    ('host_check_command', ''),
                                    ],
                'hidden': False,
                'hide_filters': [],
                'layout': 'table',
                'mustsearch': True,
                'name': 'searchhost',
                'num_columns': 3,
                'owner': '',
                'painters': [('host_state', None),
                             ('host', 'host'),
                             ('host_icons', None),
                             ('num_services_ok', 'host_ok'),
                             ('num_services_warn', 'host_warn'),
                             ('num_services_crit', 'host_crit'),
                             ('num_services_unknown', 'host_unknown'),
                             ('num_services_pending', 'host_pending')],
                'play_sounds': False,
                'public': True,
                'show_filters': ['host_scheduled_downtime_depth',
                                 'host_in_notification_period',
                                 'hoststate',
                                 'siteopt',
                                 'hostregex',
                                 'summary_host',
                                 'opthostgroup',
                                 'opthost_contactgroup',
                                 'host_check_command',
                                 ],
                'sorters': [],
                'title': _('Host search'),
                'topic': _('Hosts')},
 'searchsvc': {'browser_reload': 60,
               'column_headers': 'pergroup',
               'datasource': 'services',
               'description': 'Almost all available filters, used for searching services and maybe doing actions',
               'group_painters': [('sitealias', 'sitehosts'),
                                  ('host', 'host')],
               'hard_filters': [],
               'hard_filtervars': [('is_service_in_notification_period',
                                    '-1'),
                                   ('optservicegroup', ''),
                                   ('is_service_notifications_enabled',
                                    '-1'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('is_in_downtime', '-1'),
                                   ('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('is_service_acknowledged', '-1'),
                                   ('host', ''),
                                   ('is_service_active_checks_enabled',
                                    '-1'),
                                   ('is_summary_host', '-1'),
                                   ('service', ''),
                                   ('check_command', ''),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', 'on'),
                                   ('opthostgroup', ''),
                                   ('service_output', ''),
                                   ('is_service_is_flapping', '-1')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'table',
               'mustsearch': True,
               'name': 'searchsvc',
               'num_columns': 1,
               'owner': '',
               'painters': [('service_state', None),
                            ('service_description', 'service'),
                            ('svc_plugin_output', None),
                            ('service_icons', None),
                            ('svc_state_age', None),
                            ('svc_check_age', None),
                            ('perfometer', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': ['service_in_notification_period',
                                'optservicegroup',
                                'optservice_contactgroup',
                                'service_notifications_enabled',
                                'host_in_notification_period',
                                'in_downtime',
                                'service_scheduled_downtime_depth',
                                'service_acknowledged',
                                'hostregex',
                                'service_active_checks_enabled',
                                'summary_host',
                                'serviceregex',
                                'check_command',
                                'hoststate',
                                'svcstate',
                                'svchardstate',
                                'opthostgroup',
                                'opthost_contactgroup',
                                'output',
                                'service_is_flapping',
                                'svc_last_state_change',
                                'svc_last_check'],
               'sorters': [('site', False),
                           ('site_host', False),
                           ('svcdescr', False)],
               'title': _('Service search'),
               'topic': _('Services')},
 'service': {'browser_reload': 30,
               'column_headers': 'pergroup',
             'datasource': 'services',
             'description': 'Status of a single service, to be used for linking',
             'group_painters': [],
             'hard_filters': [],
             'hard_filtervars': [],
             'hidden': True,
             'hide_filters': ['site', 'service', 'host'],
             'layout': 'dataset',
             'mustsearch': False,
             'name': 'service',
             'num_columns': 1,
             'owner': '',
             'painters': [('sitealias', None),
                          ('host', 'hoststatus'),
                          ('service_description', 'servicedesc'),
                          ('service_icons', None),
                          ('service_state', None),
                          ('svc_group_memberlist', None),
                          ('svc_contact_groups', None),
                          ('svc_contacts', None),
                          ('svc_plugin_output', None),
                          ('svc_long_plugin_output', None),
                          ('svc_perf_data', None),
                          ('svc_check_command', None),
                          ('svc_attempt', None),
                          ('svc_check_type', None),
                          ('svc_state_age', None),
                          ('svc_check_age', None),
                          ('svc_next_check', None),
                          ('svc_next_notification', None),
                          ('svc_last_notification', None),
                          ('svc_check_latency', None),
                          ('svc_check_duration', None),
                          ('svc_in_downtime', None),
                          ('svc_in_notifper', None),
                          ('svc_notifper', None),
			  ('check_manpage', None),
                          ('svc_custom_notes', None),
                          ('svc_pnpgraph', None),
                          ],
             'public': True,
             'show_filters': [],
             'sorters': [],
             'linktitle': _('Details'),
             'title': _('Service')},
 'servicedesc': {'browser_reload': 30,
               'column_headers': 'off',
                 'datasource': 'services',
                 'description': 'All Services with\r\na certain description\r\n',
                 'group_painters': [('service_description', 'servicedesc')],
                 'hard_filters': [],
                 'hard_filtervars': [('host', ''),
                                     ('st0', 'on'),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', 'on'),
                                     ('opthostgroup', '')],
                 'hidden': True,
                 'hide_filters': ['service'],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'servicedesc',
                 'num_columns': 2,
                 'owner': '',
                 'painters': [('service_state', None),
                              ('host', 'host'),
                              ('svc_plugin_output', None),
                              ('perfometer', None)],
                 'public': True,
                 'show_filters': ['hostregex', 'svcstate', 'opthostgroup'],
                 'sorters': [('site', False),
                             ('site_host', False)],
                 'linktitle': _('Same serv. on all hosts'),
                 'title': _('All Services with this description:')},
'servicedescpnp': {'browser_reload': 90,
                    'column_headers': 'off',
                    'datasource': 'services',
                    'description': 'PNP graphs for all Services with\r\na certain description\r\n',
                    'group_painters': [('host', 'hostpnp')],
                    'hard_filters': [],
                    'hard_filtervars': [('host', ''),
                                        ('st0', 'on'),
                                        ('st1', 'on'),
                                        ('st2', 'on'),
                                        ('st3', 'on'),
                                        ('stp', 'on'),
                                        ('opthostgroup', ''),
                                        ('neg_opthostgroup', '')],
                    'hidden': True,
                    'hide_filters': ['service'],
                    'icon' : 'pnp',
                    'layout': 'boxed',
                    'linktitle': _('Same serv. PNP Graph'),
                    'mustsearch': False,
                    'name': 'servicedescpnp',
                    'num_columns': 2,
                    'owner': 'admin',
                    'painters': [('svc_pnpgraph', None)],
                    'play_sounds': False,
                    'public': True,
                    'show_filters': ['hostregex', 'svcstate', 'opthostgroup'],
                    'sorters': [('svcstate', False),
                                ('site', False),
                                ('site_host', False)],
                    'title': _('PNP Graphs of services with description:'),
                    'topic': _('Other')},
 'servicegroup': {'browser_reload': 30,
                  'column_headers': 'pergroup',
                  'datasource': 'services',
                  'description': '',
                  'group_painters': [('sitealias', 'sitehosts'),
                                     ('host', 'host')],
                  'hard_filters': [],
                  'hard_filtervars': [],
                  'hidden': True,
                  'hide_filters': ['servicegroup'],
                  'layout': 'table',
                  'linktitle': _('Servicegroup'),
                  'mustsearch': False,
                  'name': 'servicegroup',
                  'num_columns': 1,
                  'owner': '',
                  'painters': [('service_state', None),
                               ('svc_state_age', None),
                               ('service_description', 'service'),
                               ('svc_plugin_output', None),
                               ('perfometer', None)],
                  'play_sounds': False,
                  'public': True,
                  'show_filters': [],
                  'sorters': [],
                  'title': _('Servicegroup'),
                  'topic': _('Other')},
 'sitehosts': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hosts',
               'description': 'Link view showing all\r\nhosts of one site',
               'group_painters': [('site_icon', None), ('sitealias', 'sitesvcs')],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [
                                    ('is_summary_host', '0'),],
               'hidden': True,
               'hide_filters': ['site'],
               'layout': 'boxed',
               'mustsearch': False,
               'name': 'sitehosts',
               'num_columns': 2,
               'owner': '',
               'painters': [('host_state', None),
                            ('host', 'host'),
                            ('host_icons', None),
                            ('alias', 'hoststatus'),
                            ('num_services_ok', 'host_ok'),
                            ('num_services_warn', 'host_warn'),
                            ('num_services_unknown', 'host_unknown'),
                            ('num_services_crit', 'host_crit'),
                            ('num_services_pending', 'host_pending')],
               'public': True,
               'show_filters': [],
               'sorters': [('site', False), ('site_host', False)],
               'linktitle': _('Complete site'),
               'title': _('All hosts of site')},
 'svcbygroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                 'datasource': 'servicesbygroup',
                 'description': 'Service grouped by service groups. Services not member of a group are not displayed. Services being in more groups, are displayed once for each group',
                 'group_painters': [('sg_alias', 'servicegroup')],
                 'hard_filters': [],
                 'hard_filtervars': [],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'svcbygroups',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('host', 'host'),
                              ('service_state', None),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('service_icons', None)],
                 'public': True,
                 'show_filters': [],
                 'sorters': [('servicegroup', False),
                             ('site_host', False),
                             ('svcdescr', False)],
                 'title': _('Services by group'),
                 'topic': _('Servicegroups')},
 'svcbyhgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'servicesbyhostgroup',
                  'description': 'Service grouped by host groups. Services not member of a host group are not displayed. Services being in more groups, are displayed once for each group',
                  'group_painters': [('hg_alias', 'hostgroup')],
                  'hard_filters': [],
                  'hard_filtervars': [],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'svcbyhgroups',
                  'num_columns': 2,
                  'owner': '',
                  'painters': [('host', 'host'),
                               ('service_state', None),
                               ('svc_state_age', None),
                               ('service_description', None),
                               ('service_icons', None),
                               ('svc_plugin_output', None)],
                  'public': True,
                  'show_filters': [],
                  'sorters': [('hostgroup', False),
                              ('site_host', False),
                              ('svcdescr', False)],
                  'title': _('Serv. by host groups'),
                  'topic': _('Services')},
 'svcgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
               'datasource': 'servicegroups',
               'description': 'A short overview over all servicegroups, without explicity listing of the actual hosts and services',
               'group_painters': [('sitealias', 'sitehosts')],
               'hard_filters': [],
               'hard_filtervars': [],
               'hidden': False,
               'hide_filters': [],
               'layout': 'boxed',
               'mustsearch': False,
               'name': 'svcgroups',
               'num_columns': 3,
               'owner': '',
               'painters': [('sg_name', 'servicegroup'),
                            ('sg_alias', None),
                            ('sg_num_services_ok', None),
                            ('sg_num_services_warn', None),
                            ('sg_num_services_crit', None),
                            ('sg_num_services_unknown', None),
                            ('sg_num_services_pending', None)],
               'public': True,
               'show_filters': [],
               'sorters': [],
               'title': _('Servicegroups (Summary)'),
                  'topic': _('Servicegroups')},
 'svcgroups_grid': {'browser_reload': 30,
               'column_headers': 'pergroup',
                    'datasource': 'servicegroups',
                    'description': 'A short overview over all servicegroups, without explicity listing of the actual hosts and services',
                    'group_painters': [('sitealias', 'sitehosts')],
                    'hard_filters': [],
                    'hard_filtervars': [],
                    'hidden': False,
                    'hide_filters': [],
                    'layout': 'boxed',
                    'mustsearch': False,
                    'name': 'svcgroups_grid',
                    'num_columns': 3,
                    'owner': '',
                    'painters': [('sg_name', 'servicegroup'),
                                 ('sg_alias', None),
                                 ('sg_services', None)],
                    'public': True,
                    'show_filters': [],
                    'sorters': [],
                    'title': _('Servicegroups (Grid)'),
                    'topic': _('Servicegroups'),
                    },
 'svcproblems': {
                 'browser_reload': 30,
                 'column_headers': 'pergroup',
                 'datasource': 'services',
                 'description': 'All problems of services not currently in a downtime.',
                 'group_painters': [('service_state', None)],
                 'hard_filters': ['summary_host', 'in_downtime'],
                 'hard_filtervars': [('is_service_in_notification_period', '-1'),
                                     ('is_in_downtime', '0'),
                                     ('is_service_acknowledged', '-1'),
                                     ('st0', ''),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', ''),
                                     ('hst0', 'on'),
                                     ('hst1', ''),
                                     ('hst2', ''),
                                     ('hstp', 'on'),
                                     ('is_summary_host', '0')],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'svcproblems',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('host', 'host'),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('service_icons', None),
                              ('perfometer', None)],
                 'play_sounds': True,
                 'public': True,
                 'show_filters': ['service_in_notification_period',
                                  'service_acknowledged',
                                  'svcstate',
                                  'svchardstate',
                                  'hoststate'],
                 'sorters': [('svcstate', True),
                             ('stateage', False),
                             ('svcdescr', False)],
                 'title': _('Service problems'),
                  'topic': _('Problems')},

 'hosttiles': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hostsbygroup',
               'description': '',
               'group_painters': [('hg_name', 'hostgroup'),
                                  ('hg_alias', None)],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('is_summary_host', '0')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'tiled',
               'mustsearch': False,
               'name': 'hosttiles',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'hoststatus'),
                            ('host_address', None),
                            ('host_icons', None),
                            ('num_services', 'host'),
                            ('num_problems', 'problemsofhost'),
                            ('host_state', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': [],
               'sorters': [],
               'title': _('All hosts (tiled)'),
               'topic': _('Hosts')},
 'searchpnp': {'browser_reload': 90,
               'column_headers': 'off',
               'datasource': 'services',
               'description': 'Search for services and display PNP graphs',
               'group_painters': [('sitealias', 'sitehosts'),
                                  ('host', 'host'),
                                  ('service_description', 'service'),
                                  ('svc_plugin_output', None)],
               'hard_filters': ['service_process_performance_data',
                                'has_performance_data',
                                'summary_host'],
               'hard_filtervars': [('is_service_in_notification_period',
                                    '-1'),
                                   ('is_service_process_performance_data',
                                    '1'),
                                   ('optservicegroup', ''),
                                   ('is_service_notifications_enabled',
                                    '-1'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('is_has_performance_data', '1'),
                                   ('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('is_service_acknowledged', '-1'),
                                   ('host', ''),
                                   ('is_service_active_checks_enabled',
                                    '-1'),
                                   ('is_summary_host', '0'),
                                   ('service', ''),
                                   ('check_command', ''),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', ''),
                                   ('opthostgroup', ''),
                                   ('is_in_downtime', '-1'),
                                   ('service_output', ''),
                                   ('is_service_is_flapping', '-1')],
               'hidden': False,
               'hide_filters': [],
               'icon' : 'pnp',
               'layout': 'boxed',
               'mustsearch': True,
               'name': 'searchpnp',
               'num_columns': 2,
               'owner': '',
               'painters': [('svc_pnpgraph', None)],
               'play_sounds': False,
               'public': False,
               'show_filters': ['service_in_notification_period',
                                'optservicegroup',
                                'service_notifications_enabled',
                                'host_in_notification_period',
                                'service_scheduled_downtime_depth',
                                'service_acknowledged',
                                'hostregex',
                                'service_active_checks_enabled',
                                'serviceregex',
                                'check_command',
                                'svcstate',
                                'opthostgroup',
                                'in_downtime',
                                'output',
                                'service_is_flapping'],
               'sorters': [('site', False),
                           ('site_host', False),
                           ('svcdescr', False)],
               'title': _('Search PNP graphs'),
               'topic': _('Addons')},
 'hostpnp': {'browser_reload': 90,
             'column_headers': 'off',
             'datasource': 'services',
             'description': 'All PNP performance graphs for a certain host.',
             'group_painters': [('sitealias', 'sitehosts'),
                                ('host', 'host'),
                                ('service_description', 'service'),
                                ('svc_plugin_output', None)],
             'hard_filters': ['service_process_performance_data',
                              'has_performance_data',
                              'svcstate'],
             'hard_filtervars': [('is_service_process_performance_data',
                                  '1'),
                                 ('is_has_performance_data', '1'),
                                 ('service', ''),
                                 ('check_command', ''),
                                 ('st0', 'on'),
                                 ('st1', 'on'),
                                 ('st2', 'on'),
                                 ('st3', 'on'),
                                 ('stp', '')],
             'hidden': True,
             'icon' : 'pnp',
             'hide_filters': ['site', 'host'],
             'layout': 'boxed',
             'mustsearch': False,
             'name': 'hostpnp',
             'num_columns': 2,
             'owner': '',
             'painters': [('svc_pnpgraph', None)],
             'play_sounds': False,
             'public': False,
             'show_filters': ['serviceregex', 'check_command'],
             'sorters': [('site', False),
                         ('site_host', False),
                         ('svcdescr', False)],
             'linktitle': _('PNP graphs'),
             'title': _('PNP graphs for host'),
               'topic': _('PNP4Nagios')},
'recentsvc': {'browser_reload': 30,
               'column_headers': 'pergroup',
               'datasource': 'services',
               'description': 'Service whose state changed in the last\r\n60 minutes',
               'group_painters': [],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('svc_last_state_change', 'since'),
                                   ('svc_last_state_change_sec', '0'),
                                   ('svc_last_state_change_min', '60'),
                                   ('svc_last_state_change_hours', '0'),
                                   ('svc_last_state_change_days', '0'),
                                   ('is_summary_host', '0'),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', '')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'table',
               'linktitle': _('Change ago:'),
               'mustsearch': False,
               'name': 'svcrecent',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'host'),
                            ('service_state', None),
                            ('service_description', 'service'),
                            ('svc_plugin_output', None),
                            ('service_icons', None),
                            ('svc_state_age', None),
                            ('svc_check_age', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': ['svc_last_state_change', 'svcstate'],
               'sorters': [('stateage', True)],
               'title': _('Recently changed services'),
               'topic': _('Services')},
 'uncheckedsvc': {'browser_reload': 30,
                  'column_headers': 'pergroup',
                  'datasource': 'services',
                  'description': 'Services that have not been checked within the last 24 hours (pending services excluded).',
                  'group_painters': [('host', 'host')],
                  'hard_filters': ['summary_host'],
                  'hard_filtervars': [('svc_last_check', 'before'),
                                      ('svc_last_check_sec', '0'),
                                      ('svc_last_check_min', '0'),
                                      ('svc_last_check_hours', '0'),
                                      ('svc_last_check_days', '1'),
                                      ('is_summary_host', '0'),
                                      ('st0', 'on'),
                                      ('st1', 'on'),
                                      ('st2', 'on'),
                                      ('st3', 'on'),
                                      ('stp', '')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'table',
                  'linktitle': _('Unchecked services'),
                  'mustsearch': False,
                  'name': 'uncheckedsvc',
                  'num_columns': 1,
                  'owner': '',
                  'painters': [('service_state', None),
                               ('service_description', 'service'),
                               ('svc_plugin_output', None),
                               ('service_icons', None),
                               ('svc_state_age', None),
                               ('svc_check_age', None)],
                  'play_sounds': False,
                  'public': True,
                  'show_filters': ['svc_last_check', 'svcstate'],
                  'sorters': [('site_host', False), ('svcdescr', False)],
                  'title': _('Unchecked services'),
                  'topic': _('Problems')},
'events': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events of hosts or services (alerts, downtimes, etc.)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('host', ''),
                                ('service', ''),
                                ('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '7'),
                                ('log_plugin_output', '')],
            'hidden': False,
            'hide_filters': [],
            'icon' : 'history',
            'layout': 'table',
            'linktitle': _('Events'),
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': 'admin',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('host', 'hostsvcevents'),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None)],
            'play_sounds': False,
            'public': True,
            'show_filters': ['hostregex',
                             'serviceregex',
                             'logtime',
                             'log_plugin_output'],
            'sorters': [('log_time', False), ('log_lineno', False)],
            'title': _('Host- and Service events'),
            'topic': _('Other')},


'hostevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_host_events',
            'description': 'All historic events concerning the state of a certain host (without services)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host'],
            'icon' : 'history',
            'layout': 'table',
            'linktitle': _('Host history'),
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [('log_time', False), ('log_lineno', False)],
            'title': _('Events of host')},
'svcevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events concerning the state of a certain service',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host', 'service'],
            'icon' : 'history',
            'layout': 'table',
            'linktitle': _('History'),
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [('log_time', False), ('log_lineno', False)],
            'title': _('Events of service')},
'hostsvcevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events concerning the state of a certain host (including services)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host'],
            'icon' : 'history',
            'layout': 'table',
            'linktitle': _('Host & service history'),
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('host', None),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [('log_time', False), ('log_lineno', False)],
            'title': _('Events of host & services')},
  'logfile': {'browser_reload': 0,
             'column_headers': 'off',
             'datasource': 'log',
             'description': '',
             'group_painters': [('log_date', None)],
             'hard_filters': [],
             'hard_filtervars': [('optservicegroup', ''),
                                 ('neg_optservicegroup', ''),
                                 ('site', ''),
                                 ('logclass0', 'on'),
                                 ('logclass1', 'on'),
                                 ('logclass2', 'on'),
                                 ('logclass3', 'on'),
                                 ('logclass4', ''),
                                 ('logclass5', 'on'),
                                 ('logclass6', ''),
                                 ('host', ''),
                                 ('service', ''),
                                 ('opthostgroup', ''),
                                 ('neg_opthostgroup', ''),
                                 ('logtime', 'since'),
                                 ('logtime_sec', '0'),
                                 ('logtime_min', '0'),
                                 ('logtime_hours', '0'),
                                 ('logtime_days', '7')],
             'hidden': False,
             'hide_filters': [],
             'icon' : 'history',
             'layout': 'table',
             'linktitle': _('Search Global Logfile'),
             'mustsearch': True,
             'name': 'logfile',
             'num_columns': 1,
             'owner': '',
             'painters': [('log_icon', None),
                          ('log_time', None),
                          ('log_type', None),
                          ('host', 'hostsvcevents'),
                          ('service_description', 'svcevents'),
                          ('log_state_type', None),
                          ('log_plugin_output', None)],
             'play_sounds': False,
             'public': True,
             'show_filters': ['optservicegroup',
                              'siteopt',
                              'log_class',
                              'hostregex',
                              'serviceregex',
                              'opthostgroup',
                              'logtime'],
             'sorters': [('log_time', False), ('log_lineno', False)],
             'title': _('Search Global Logfile'),
             'topic': _('Other')},

 'sitesvcs': {'browser_reload': 60,
              'column_headers': 'pergroup',
              'datasource': 'services',
              'description': 'All services of a given site.',
              'group_painters': [('host_with_state', 'hoststatus')],
              'hard_filters': [],
              'hard_filtervars': [('optservicegroup', ''),
                                  ('neg_optservicegroup', ''),
                                  ('host', ''),
                                  ('service', ''),
                                  ('st0', 'on'),
                                  ('st1', 'on'),
                                  ('st2', 'on'),
                                  ('st3', 'on'),
                                  ('stp', 'on'),
                                  ('opthostgroup', ''),
                                  ('neg_opthostgroup', ''),
                                  ('host_check_command', ''),
                                  ('service_output', '')],
              'hidden': True,
              'hide_filters': ['site'],
              'layout': 'boxed',
              'linktitle': _('Services of Site'),
              'mustsearch': False,
              'name': 'sitesvcs',
              'num_columns': 2,
              'owner': 'maintenance',
              'painters': [('service_state', None),
                           ('service_description', 'service'),
                           ('svc_plugin_output', None),
                           ('svc_state_age', None),
                           ('svc_check_age', None),
                           ('service_icons', None),
                           ('perfometer', None)],
              'play_sounds': False,
              'public': True,
              'show_filters': ['optservicegroup',
                               'hostregex',
                               'serviceregex',
                               'svcstate',
                               'opthostgroup',
                               'host_check_command',
                               'output'],
              'sorters': [('site_host', False), ('svcdescr', False)],
              'title': _('Services of Site'),
              'topic': _('Services')},

'alertstats': {'browser_reload': 0,
                'column_headers': 'pergroup',
                'datasource': 'alert_stats',
                'description': '',
                'group_painters': [],
                'hard_filters': [],
                'hard_filtervars': [('optservicegroup', ''),
                                    ('neg_optservicegroup', ''),
                                    ('site', ''),
                                    ('host', ''),
                                    ('is_summary_host', '-1'),
                                    ('service', ''),
                                    ('check_command', ''),
                                    ('log_plugin_output', ''),
                                    ('opthostgroup', ''),
                                    ('neg_opthostgroup', ''),
                                    ('host_check_command', ''),
                                    ('logtime', 'since'),
                                    ('logtime_sec', '0'),
                                    ('logtime_min', '0'),
                                    ('logtime_hours', '0'),
                                    ('logtime_days', '30')],
                'hidden': False,
                'hide_filters': [],
                'hidebutton': False,
                'layout': 'boxed',
                'linktitle': _('Alerts'),
                'mustsearch': False,
                'name': 'alertstats',
                'num_columns': 1,
                'owner': 'omdadmin',
                'painters': [('host', 'hostsvcevents'),
                             ('service_description', 'svcevents'),
                             ('alert_stats_crit', None),
                             ('alert_stats_unknown', None),
                             ('alert_stats_warn', None),
                             ('alert_stats_problem', None)],
                'play_sounds': False,
                'public': False,
                'show_filters': ['optservicegroup',
                                 'siteopt',
                                 'hostregex',
                                 'summary_host',
                                 'serviceregex',
                                 'check_command',
                                 'log_plugin_output',
                                 'opthostgroup',
                                 'host_check_command',
                                 'logtime'],
                'sorters': [('alerts_crit', True),
                            ('alerts_unknown', True),
                            ('alerts_warn', True),
                            ('site_host', False),
                            ('svcdescr', False)],
                'title': _('Alert Statistics'),
                'topic': _('Problems')},

# Special views for NagStaMon
'nagstamon_hosts': {'browser_reload': 30,
                     'column_headers': 'pergroup',
                     'datasource': 'hosts',
                     'description': 'The view is intended for NagStaMon as web service.',
                     'group_painters': [('host_state', None)],
                     'hard_filters': ['summary_host'],
                     'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                          '-1'),
                                         ('is_host_active_checks_enabled',
                                          '-1'),
                                         ('hst0', 'on'),
                                         ('hst1', 'on'),
                                         ('hst2', 'on'),
                                         ('hstp', 'on'),
                                         ('is_host_acknowledged', '-1'),
                                         ('is_host_notifications_enabled',
                                          '-1'),
                                         ('is_summary_host', '0')],
                     'hidden': False,
                     'hide_filters': [],
                     'hidebutton': True,
                     'layout': 'table',
                     'linktitle': _('Host problems for NagStaMon'),
                     'mustsearch': False,
                     'name': 'nagstamon_hosts',
                     'num_columns': 1,
                     'owner': 'omdadmin',
                     'painters': [('host', 'hoststatus', ''),
                                  ('host_icons', None, ''),
                                  ('host_check_age', None, ''),
                                  ('host_state_age', None, ''),
                                  ('host_attempt', None, ''),
                                  ('host_state', None, ''),
                                  ('host_plugin_output', None, ''),
                                  ('host_in_downtime', None, ''),
                                  ('host_acknowledged', None, ''),
                                  ('host_address', None, ''),
                                  ('host_in_downtime', None, ''),
                                  ('host_acknowledged', None, ''),
                                  ('sitename_plain', None, ''),
                                  ('host_flapping', None, ''),
                                  ('host_is_active', None, ''),],
                     'play_sounds': False,
                     'public': True,
                     'show_filters': ['host_scheduled_downtime_depth',
                                      'host_active_checks_enabled',
                                      'hoststate',
                                      'host_acknowledged',
                                      'host_notifications_enabled'],
                     'sorters': [],
                     'title': _('Host problems for NagStaMon'),
                     'topic': None
                     },
 'nagstamon_svc': {'browser_reload': 30,
                   'column_headers': 'pergroup',
                   'datasource': 'services',
                   'description': 'This view is intended for usage as web service for NagStaMon.',
                   'group_painters': [('service_state', None)],
                   'hard_filters': ['summary_host'],
                   'hard_filtervars': [('is_service_in_notification_period',
                                        '-1'),
                                       ('is_service_notifications_enabled',
                                        '-1'),
                                       ('hst0', 'on'),
                                       ('hst1', 'on'),
                                       ('hst2', 'on'),
                                       ('hstp', 'on'),
                                       ('is_service_acknowledged', '-1'),
                                       ('is_service_active_checks_enabled',
                                        '-1'),
                                       ('is_host_notifications_enabled',
                                        '-1'),
                                       ('is_summary_host', '0'),
                                       ('st0', ''),
                                       ('st1', 'on'),
                                       ('st2', 'on'),
                                       ('st3', 'on'),
                                       ('stp', ''),
                                       ('is_in_downtime', '-1')],
                   'hidden': False,
                   'hide_filters': [],
                   'hidebutton': True,
                   'layout': 'table',
                   'linktitle': _('Service problems for NagStaMon'),
                   'mustsearch': False,
                   'name': 'nagstamon_svc',
                   'num_columns': 1,
                   'owner': 'omdadmin',
                   'painters': [('host', 'hoststatus', ''),
                                ('service_description', 'service', ''),
                                ('service_icons', None, ''),
                                ('service_state', None, ''),
                                ('svc_check_age', None, ''),
                                ('svc_state_age', None, ''),
                                ('svc_attempt', None, ''),
                                ('svc_plugin_output', None, ''),
                                ('svc_flapping', None, ''),
                                ('svc_notifications_enabled', None, ''),
                                ('svc_is_active', None, ''),
                                ('svc_in_downtime', None, ''),
                                ('svc_acknowledged', None, ''),
                                ('sitename_plain', None, ''),
                                ('host_address', None, ''),
                                ('svc_check_command', None, '')],
                   'play_sounds': False,
                   'public': True,
                   'show_filters': ['service_in_notification_period',
                                    'service_notifications_enabled',
                                    'hoststate',
                                    'service_acknowledged',
                                    'service_active_checks_enabled',
                                    'host_notifications_enabled',
                                    'svcstate',
                                    'in_downtime'],
                   'sorters': [('svcstate', True),
                               ('stateage', False),
                               ('svcdescr', False)],
                   'title': _('Service problems for NagStaMon'),
                   'topic': None,
                   },

#   
#    ____            _                     
#   | __ ) _   _ ___(_)_ __   ___  ___ ___ 
#   |  _ \| | | / __| | '_ \ / _ \/ __/ __|
#   | |_) | |_| \__ \ | | | |  __/\__ \__ \
#   |____/ \__,_|___/_|_| |_|\___||___/___/
#                                          
#    ___       _       _ _ _                           
#   |_ _|_ __ | |_ ___| | (_) __ _  ___ _ __   ___ ___ 
#    | || '_ \| __/ _ \ | | |/ _` |/ _ \ '_ \ / __/ _ \
#    | || | | | ||  __/ | | | (_| |  __/ | | | (_|  __/
#   |___|_| |_|\__\___|_|_|_|\__, |\___|_| |_|\___\___|
#                            |___/                     
#   

# All Aggregations
 'aggr_all': {
            'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'bi_aggregations',
            'description': '',
            'group_painters': [('aggr_group', 'aggr_group')],
            'hard_filters': [],
            'hard_filtervars': [('host', ''),
                                ('aggr_name', ''),
                                ('aggr_output', ''),
                                ('birs0', 'on'),
                                ('birs1', 'on'),
                                ('birs2', 'on'),
                                ('birs3', 'on'),
                                ('birs-1', 'on'),
                                ('bias0', 'on'),
                                ('bias1', 'on'),
                                ('bias2', 'on'),
                                ('bias3', 'on'),
                                ('birs-1', 'on'),
                                ('biasn', 'on'),
                                ('bies0', 'on'),
                                ('bies1', 'on'),
                                ('bies2', 'on'),
                                ('bies3', 'on'),
                                ('bies-1', 'on'),
                                ],
            'hidden': False,
            'hide_filters': [],
            'hidebutton': False,
            'icon' : 'aggr',
            'layout': 'table',
            'linktitle': _('All Aggregations'),
            'mustsearch': False,
            'name': 'aggr_all',
            'num_columns': 1,
            'owner': 'omdadmin',
            'painters': [('aggr_state', None, ''),
                         ('aggr_treestate', None, ''),
                         ('aggr_hosts', None, '')],
            'play_sounds': False,
            'public': False,
            'show_filters': ['aggr_hosts',
                             'aggr_name',
                             'aggr_state',
                             'aggr_output',
                             'aggr_assumed_state',
                             'aggr_effective_state'],
            'sorters': [],
            'title': _('All Aggregations'),
            'topic': _('Business Intelligence')},

# All aggregations of a certain group
 'aggr_group': {
            'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'bi_aggregations',
            'description': '',
            'group_painters': [],
            'hard_filters': [],
            'hard_filtervars': [('host', ''),
                                ('aggr_name', ''),
                                ('aggr_output', ''),
                                ('birs0', 'on'),
                                ('birs1', 'on'),
                                ('birs2', 'on'),
                                ('birs3', 'on'),
                                ('birs-1', 'on'),
                                ('bias0', 'on'),
                                ('bias1', 'on'),
                                ('bias2', 'on'),
                                ('bias3', 'on'),
                                ('birs-1', 'on'),
                                ('biasn', 'on'),
                                ('bies0', 'on'),
                                ('bies1', 'on'),
                                ('bies2', 'on'),
                                ('bies3', 'on'),
                                ('bies-1', 'on'),
                                ],
            'hidden': True,
            'hide_filters': [ 'aggr_group' ],
            'hidebutton': False,
            'icon' : 'aggr',
            'layout': 'table',
            'linktitle': _('Aggregation group'),
            'mustsearch': False,
            'name': 'aggr_group',
            'num_columns': 1,
            'owner': 'omdadmin',
            'painters': [('aggr_state', None, ''),
                         ('aggr_treestate', None, ''),
                         ('aggr_hosts', None, '')],
            'play_sounds': False,
            'public': False,
            'show_filters': ['aggr_hosts',
                             'aggr_name',
                             'aggr_state',
                             'aggr_output',
                             'aggr_assumed_state',
                             'aggr_effective_state'],
            'sorters': [],
            'title': _('Aggregation group'),
            'topic': _('Business Intelligence')},

# All host-only aggregations
 'aggr_singlehosts': {
               'browser_reload': 0,
               'column_headers': 'off',
               'datasource': 'bi_host_aggregations',
               'description': '',
               'group_painters': [('aggr_group', 'biaggr_group')],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('is_host_scheduled_downtime_depth', '-1'),
                                   ('aggr_name', ''),
                                   ('aggr_group', 'Hosts'),
                                   ('birs0', 'on'),
                                   ('birs1', 'on'),
                                   ('birs2', 'on'),
                                   ('birs3', 'on'),
                                   ('birs-1', 'on'),
                                   ('bias0', 'on'),
                                   ('bias1', 'on'),
                                   ('bias2', 'on'),
                                   ('bias3', 'on'),
                                   ('birs-1', 'on'),
                                   ('biasn', 'on'),
                                   ('bies0', 'on'),
                                   ('bies1', 'on'),
                                   ('bies2', 'on'),
                                   ('bies3', 'on'),
                                   ('bies-1', 'on'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('aggr_output', ''),
                                   ('site', ''),
                                   ('host', ''),
                                   ('is_summary_host', '0'),
                                   ('opthostgroup', ''),
                                   ('neg_opthostgroup', ''),
                                ],
               'hidden': False,
               'hide_filters': [],
               'hidebutton': True,
               'icon' : 'aggr',
               'layout': 'table',
               'linktitle': _('Host Aggregations'),
               'mustsearch': False,
               'name': 'aggr_singlehosts',
               'num_columns': 1,
               'owner': 'omdadmin',
               'painters': [('host', 'aggrhost', ''),
                            ('aggr_state', None, ''),
                            ('aggr_treestate', None, ''),
                            ('host_icons', None, '')],
               'play_sounds': False,
               'public': True,
               'show_filters': ['host_scheduled_downtime_depth',
                                'aggr_name',
                                'aggr_group',
                                'aggr_state',
                                'host_in_notification_period',
                                'aggr_output',
                                'hoststate',
                                'siteopt',
                                'aggr_assumed_state',
                                'hostregex',
                                'opthostgroup',
                                'aggr_effective_state'],
               'sorters': [('site_host', False)],
               'title': _('Single-Host Aggregations'),
               'topic': _('Business Intelligence')},

# Single-Host Aggregations of a host
'aggr_singlehost': {'browser_reload': 0,
              'column_headers': 'pergroup',
              'datasource': 'bi_host_aggregations',
              'description': '',
              'group_painters': [('aggr_name', None)],
              'hard_filters': [],
              'hard_filtervars': [],
              'hidden': True,
              'hide_filters': ['site', 'host'],
              'hidebutton': False,
              'icon' : 'aggr',
              'layout': 'table',
              'linktitle': _('Host Aggregations'),
              'mustsearch': False,
              'name': 'aggrhost',
              'num_columns': 1,
              'owner': 'omdadmin',
              'painters': [('aggr_state', None, ''),
                           ('aggr_treestate', None, '')],
              'play_sounds': False,
              'public': True,
              'show_filters': [],
              'sorters': [],
              'title': _('Single-Host Aggregations of Host'),
              'topic': _('Other')},

# All aggregations affected by a certain host
 'aggr_host': {
            'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'bi_aggregations',
            'description': '',
            'group_painters': [('aggr_group', 'aggr_group')],
            'hard_filters': [],
            'hard_filtervars': [('aggr_name', ''),
                                ('aggr_output', ''),
                                ('birs0', 'on'),
                                ('birs1', 'on'),
                                ('birs2', 'on'),
                                ('birs3', 'on'),
                                ('birs-1', 'on'),
                                ('bias0', 'on'),
                                ('bias1', 'on'),
                                ('bias2', 'on'),
                                ('bias3', 'on'),
                                ('bias-1', 'on'),
                                ('biasn', 'on'),
                                ('bies0', 'on'),
                                ('bies1', 'on'),
                                ('bies2', 'on'),
                                ('bies3', 'on'),
                                ('bies-1', 'on'),
                                ],
            'hidden': True,
            'hide_filters': ["aggr_hosts"],
            'hidebutton': False,
            'icon' : 'aggr',
            'layout': 'table',
            'linktitle': _('Aggregations'),
            'mustsearch': False,
            'name': 'aggr_host',
            'num_columns': 1,
            'owner': 'omdadmin',
            'painters': [('aggr_state', None, ''),
                         ('aggr_treestate', None, '')],
            'play_sounds': False,
            'public': False,
            'show_filters': ['aggr_name',
                             'aggr_state',
                             'aggr_output',
                             'aggr_assumed_state',
                             'aggr_effective_state'],
            'sorters': [],
            'title': _('Aggregations Affected by Host'),
            'topic': _('Business Intelligence')},

# All aggregations affected by a certain service (one one site/host!)
 'aggr_service': {
            'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'bi_aggregations',
            'description': '',
            'group_painters': [('aggr_group', 'aggr_group')],
            'hard_filters': [],
            'hard_filtervars': [('aggr_name', ''),
                                ('aggr_output', ''),
                                ('birs0', 'on'),
                                ('birs1', 'on'),
                                ('birs2', 'on'),
                                ('birs3', 'on'),
                                ('birs-1', 'on'),
                                ('bias0', 'on'),
                                ('bias1', 'on'),
                                ('bias2', 'on'),
                                ('bias3', 'on'),
                                ('bias-1', 'on'),
                                ('biasn', 'on'),
                                ('bies0', 'on'),
                                ('bies1', 'on'),
                                ('bies2', 'on'),
                                ('bies3', 'on'),
                                ('bies-1', 'on'),
                                ],
            'hidden': True,
            'hide_filters': ["aggr_service"],
            'hidebutton': False,
            'icon' : 'aggr',
            'layout': 'table',
            'linktitle': _('Aggr. aff by Service'),
            'mustsearch': False,
            'name': 'aggr_service',
            'num_columns': 1,
            'owner': 'omdadmin',
            'painters': [('aggr_state', None, ''),
                         ('aggr_treestate', None, '')],
            'play_sounds': False,
            'public': False,
            'show_filters': ['aggr_name',
                             'aggr_state',
                             'aggr_output',
                             'aggr_assumed_state',
                             'aggr_effective_state'],
            'sorters': [],
            'title': _('Aggregations Affected by Service'),
            'topic': _('Business Intelligence')},

# All Aggregations that have (real) problems
 'aggr_problems': {
            'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'bi_aggregations',
            'description': 'All aggregations that have a non-OK state (honoring state assumptions)',
            'group_painters': [('aggr_group', 'aggr_group')],
            'hard_filters': [],
            'hard_filtervars': [('host', ''),
                                ('aggr_name', ''),
                                ('aggr_output', ''),
                                ('birs0', ''),
                                ('birs1', 'on'),
                                ('birs2', 'on'),
                                ('birs3', 'on'),
                                ('birs-1', 'on'),
                                ('bias0', 'on'),
                                ('bias1', 'on'),
                                ('bias2', 'on'),
                                ('bias3', 'on'),
                                ('bias-1', 'on'),
                                ('biasn', 'on'),
                                ('bies0', 'on'),
                                ('bies1', 'on'),
                                ('bies2', 'on'),
                                ('bies3', 'on'),
                                ('bies-1', 'on'),
                                ],
            'hidden': False,
            'hide_filters': [],
            'hidebutton': False,
            'icon' : 'aggr',
            'layout': 'table',
            'linktitle': _('Problem Aggregations'),
            'mustsearch': False,
            'name': 'aggr_all',
            'num_columns': 1,
            'owner': 'omdadmin',
            'painters': [('aggr_state', None, ''),
                         ('aggr_treestate', None, ''),
                         ('aggr_hosts', None, '')],
            'play_sounds': True,
            'public': False,
            'show_filters': ['aggr_hosts',
                             'aggr_name',
                             'aggr_state',
                             'aggr_output',
                             'aggr_assumed_state',
                             'aggr_effective_state'],
            'sorters': [],
            'title': _('Problem Aggregations'),
            'topic': _('Business Intelligence')},

# All single-host aggregations with problems
 'aggr_hostproblems': {
               'browser_reload': 0,
               'column_headers': 'off',
               'datasource': 'bi_host_aggregations',
               'description': 'All single-host aggregations that are in non-OK state (honoring state assumptions)',
               'group_painters': [('aggr_group', 'biaggr_group')],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('is_host_scheduled_downtime_depth', '-1'),
                                   ('aggr_name', ''),
                                   ('aggr_group', 'Hosts'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('aggr_output', ''),
                                   ('birs0', 'on'),
                                   ('birs1', 'on'),
                                   ('birs2', 'on'),
                                   ('birs3', 'on'),
                                   ('birs-1', 'on'),
                                   ('bias0', 'on'),
                                   ('bias1', 'on'),
                                   ('bias2', 'on'),
                                   ('bias3', 'on'),
                                   ('bias-1', 'on'),
                                   ('biasn', 'on'),
                                   ('bies0', 'on'),
                                   ('bies1', 'on'),
                                   ('bies2', 'on'),
                                   ('bies3', 'on'),
                                   ('bies-1', 'on'),
                                   ('site', ''),
                                   ('host', ''),
                                   ('is_summary_host', '0'),
                                   ('opthostgroup', ''),
                                   ('neg_opthostgroup', ''),
                                   ],
               'hidden': False,
               'hide_filters': [],
               'hidebutton': True,
               'icon' : 'aggr',
               'layout': 'table',
               'linktitle': 'Single-Host Problems',
               'mustsearch': False,
               'name': 'aggr_hostproblems',
               'num_columns': 1,
               'owner': 'omdadmin',
               'painters': [('host', 'aggrhost', ''),
                            ('aggr_state', None, ''),
                            ('aggr_treestate', None, ''),
                            ('host_icons', None, '')],
               'play_sounds': False,
               'public': True,
               'show_filters': ['host_scheduled_downtime_depth',
                                'aggr_name',
                                'aggr_group',
                                'aggr_state',
                                'host_in_notification_period',
                                'aggr_output',
                                'hoststate',
                                'siteopt',
                                'aggr_assumed_state',
                                'hostregex',
                                'opthostgroup',
                                'aggr_effective_state'],
               'sorters': [('site_host', False)],
               'title': 'Single-Host Problems',
               'topic': _('Business Intelligence')},

#   +----------------------------------------------------------------------+
#   |       _   _       _   _  __ _           _   _                        |
#   |      | \ | | ___ | |_(_)/ _(_) ___ __ _| |_(_) ___  _ __  ___        |
#   |      |  \| |/ _ \| __| | |_| |/ __/ _` | __| |/ _ \| '_ \/ __|       |
#   |      | |\  | (_) | |_| |  _| | (_| (_| | |_| | (_) | | | \__ \       |
#   |      |_| \_|\___/ \__|_|_| |_|\___\__,_|\__|_|\___/|_| |_|___/       |
#   |                                                                      |
#   +----------------------------------------------------------------------+

'hostnotifications': {'browser_reload': 0,
                       'column_headers': 'pergroup',
                       'datasource': 'log',
                       'description': _('Notification events of hosts.'),
                       'group_painters': [('log_date', None, '')],
                       'hard_filters': ['log_class'],
                       'hard_filtervars': [('logclass0', ''),
                                           ('logclass1', ''),
                                           ('logclass2', ''),
                                           ('logclass3', 'on'),
                                           ('logclass4', ''),
                                           ('logclass5', ''),
                                           ('logclass6', ''),
                                           ('service', ''),
                                           ('log_plugin_output', ''),
                                           ('logtime', 'since'),
                                           ('logtime_sec', '0'),
                                           ('logtime_min', '0'),
                                           ('logtime_hours', '0'),
                                           ('logtime_days', '0')],
                       'hidden': True,
                       'hide_filters': ['site', 'host'],
                       'hidebutton': False,
                       'icon': 'notification',
                       'layout': 'table',
                       'linktitle': _('Host notifications'),
                       'mustsearch': False,
                       'name': 'hostnotifications',
                       'num_columns': 1,
                       'owner': 'omdadmin',
                       'painters': [('log_time', None, ''),
                                    ('log_contact_name', 'contactnotifications', ''),
                                    ('log_state', None, ''),
                                    ('log_plugin_output', None, '')],
                       'play_sounds': False,
                       'public': True,
                       'show_filters': ['serviceregex',
                                        'log_plugin_output',
                                        'logtime'],
                       'sorters': [('log_time', False), ('log_lineno', False)],
                       'title': _('Notifications of host'),
                       'topic': _('Other')},
 'hostsvcnotifications': {'browser_reload': 0,
                          'column_headers': 'pergroup',
                          'datasource': 'log',
                          'description': _('All notification events concerning the state of a certain host (including services)'),
                          'group_painters': [('log_date', None, '')],
                          'hard_filters': ['log_class'],
                          'hard_filtervars': [('logclass0', ''),
                                              ('logclass1', ''),
                                              ('logclass2', ''),
                                              ('logclass3', 'on'),
                                              ('logclass4', ''),
                                              ('logclass5', ''),
                                              ('logclass6', ''),
                                              ('service', ''),
                                              ('log_plugin_output', ''),
                                              ('logtime', 'since'),
                                              ('logtime_sec', '0'),
                                              ('logtime_min', '0'),
                                              ('logtime_hours', '0'),
                                              ('logtime_days', '0')],
                          'hidden': True,
                          'hide_filters': ['site', 'host'],
                          'hidebutton': False,
                          'icon': 'notification',
                          'layout': 'table',
                          'linktitle': _('Host/Service notifi.'),
                          'mustsearch': False,
                          'name': 'hostsvcnotifications',
                          'num_columns': 1,
                          'owner': 'omdadmin',
                          'painters': [('log_time', None, ''),
                                       ('log_contact_name', 'contactnotifications', ''),
                                       ('log_type', None, ''),
                                       ('host', 'hostsvcnotifications', ''),
                                       ('service_description',
                                        'svcnotifications',
                                        ''),
                                       ('log_state', None, ''),
                                       ('log_plugin_output', None, '')],
                          'play_sounds': False,
                          'public': True,
                          'show_filters': ['serviceregex',
                                           'log_plugin_output',
                                           'logtime'],
                          'sorters': [('log_time', False), ('log_lineno', False)],
                          'title': _('Notifications of host & services'),
                          'topic': _('Other')},
 'notifications': {'browser_reload': 0,
                   'column_headers': 'pergroup',
                   'datasource': 'log',
                   'description': _('All notification events of hosts or services.'),
                   'group_painters': [('log_date', None, '')],
                   'hard_filters': ['log_class'],
                   'hard_filtervars': [('logclass0', ''),
                                       ('logclass1', ''),
                                       ('logclass2', ''),
                                       ('logclass3', 'on'),
                                       ('logclass4', ''),
                                       ('logclass5', ''),
                                       ('logclass6', ''),
                                       ('host', ''),
                                       ('service', ''),
                                       ('log_plugin_output', ''),
                                       ('logtime', 'since'),
                                       ('logtime_sec', '0'),
                                       ('logtime_min', '0'),
                                       ('logtime_hours', '0'),
                                       ('logtime_days', '0')],
                   'hidden': False,
                   'hide_filters': [],
                   'hidebutton': False,
                   'icon': 'notification',
                   'layout': 'table',
                   'linktitle': _('Notifications'),
                   'mustsearch': False,
                   'name': 'notifications',
                   'num_columns': 1,
                   'owner': 'omdadmin',
                   'painters': [('log_time', None, ''),
                                ('log_contact_name', 'contactnotifications', ''),
                                ('log_type', None, ''),
                                ('host', 'hostsvcnotifications', ''),
                                ('service_description',
                                 'svcnotifications',
                                 ''),
                                ('log_state', None, ''),
                                ('log_plugin_output', None, '')],
                   'play_sounds': False,
                   'public': True,
                   'show_filters': ['hostregex',
                                    'serviceregex',
                                    'log_plugin_output',
                                    'logtime'],
                   'sorters': [('log_time', False), ('log_lineno', False)],
                   'title': _('Host- and Service notifications'),
                   'topic': _('Other')},
 'svcnotifications': {'browser_reload': 0,
                      'column_headers': 'pergroup',
                      'datasource': 'log',
                      'description': _('All notification events concerning the state of a certain service.'),
                      'group_painters': [('log_date', None, '')],
                      'hard_filters': ['log_class'],
                      'hard_filtervars': [('logclass0', ''),
                                          ('logclass1', ''),
                                          ('logclass2', ''),
                                          ('logclass3', 'on'),
                                          ('logclass4', ''),
                                          ('logclass5', ''),
                                          ('logclass6', ''),
                                          ('log_plugin_output', ''),
                                          ('logtime', 'since'),
                                          ('logtime_sec', '0'),
                                          ('logtime_min', '0'),
                                          ('logtime_hours', '0'),
                                          ('logtime_days', '0')],
                      'hidden': True,
                      'hide_filters': ['site', 'service', 'host'],
                      'hidebutton': False,
                      'icon': 'notification',
                      'layout': 'table',
                      'linktitle': _('Notifications'),
                      'mustsearch': False,
                      'name': 'svcnotifications',
                      'num_columns': 1,
                      'owner': 'omdadmin',
                      'painters': [('log_time', None, ''),
                                   ('log_contact_name', 'contactnotifications', ''),
                                   ('host', None, ''),
                                   ('log_state', None, ''),
                                   ('log_plugin_output', None, '')],
                      'play_sounds': False,
                      'public': True,
                      'show_filters': ['log_plugin_output', 'logtime'],
                      'sorters': [('log_time', False), ('log_lineno', False)],
                      'title': _('Service Notifications'),
                      'topic': _('Other')},
'contactnotifications': {'browser_reload': 0,
                          'column_headers': 'pergroup',
                          'datasource': 'log',
                          'description': _('All notification events sent to'),
                          'group_painters': [('log_date', None, '')],
                          'hard_filters': ['log_class'],
                          'hard_filtervars': [('logclass0', ''),
                                              ('logclass1', ''),
                                              ('logclass2', ''),
                                              ('logclass3', 'on'),
                                              ('logclass4', ''),
                                              ('logclass5', ''),
                                              ('logclass6', ''),
                                              ('host', ''),
                                              ('service', ''),
                                              ('log_plugin_output', ''),
                                              ('logtime', 'since'),
                                              ('logtime_sec', '0'),
                                              ('logtime_min', '0'),
                                              ('logtime_hours', '0'),
                                              ('logtime_days', '0')],
                          'hidden': True,
                          'hide_filters': ['log_contact_name'],
                          'hidebutton': False,
                          'icon': 'notification',
                          'layout': 'table',
                          'linktitle': _('Contact notification'),
                          'mustsearch': False,
                          'name': 'contactnotifications',
                          'num_columns': 1,
                          'owner': 'omdadmin',
                          'painters': [('log_time', None, ''),
                                       ('log_type', None, ''),
                                       ('host', 'hostsvcnotifications', ''),
                                       ('service_description',
                                        'svcnotifications',
                                        ''),
                                       ('log_state', None, ''),
                                       ('log_plugin_output', None, '')],
                          'play_sounds': False,
                          'public': True,
                          'show_filters': ['host',
                                           'serviceregex',
                                           'log_plugin_output',
                                           'logtime'],
                          'sorters': [('log_time', False), ('log_lineno', False)],
                          'title': _('Notifications of contact'),
                          'topic': _('Other')},
})
