/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schopt.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:37:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_SCHOPT_HXX
#define _SCH_SCHOPT_HXX

// header for TYPEINFO
#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif
// header for ConfigItem
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
// header for SfxPoolItem
#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
// header for XColorEntry
#ifndef _XTABLE_HXX
#include <xtable.hxx>
#endif

#include <vector>

class SchColorTable
{
public:
    SchColorTable();
    explicit SchColorTable( const SchColorTable & _rSource );

    // accessors
    size_t size() const;
    const XColorEntry & operator[]( size_t _nIndex ) const;
    ColorData getColorData( size_t _nIndex ) const;

    // mutators
    void clear();
    void append( const XColorEntry & _rEntry );
    void replace( size_t _nIndex, const XColorEntry & _rEntry );
    void useDefault();

    // comparison
    bool operator==( const SchColorTable & _rOther ) const;

private:
    ::std::vector< XColorEntry >     m_aColorEntries;
};

// ====================
// all options
// ====================
class SchOptions : public ::utl::ConfigItem
{
private:
	SchColorTable		maDefColors;
	BOOL				mbIsInitialized;
	::com::sun::star::uno::Sequence< ::rtl::OUString > maPropertyNames;

	::com::sun::star::uno::Sequence< ::rtl::OUString > GetPropertyNames() const
		{ return maPropertyNames; }
	BOOL RetrieveOptions();

public:
	SchOptions();
	virtual ~SchOptions();

	const SchColorTable& GetDefaultColors();
	void				SetDefaultColors( const SchColorTable& aCol );

	virtual void		Commit();
};

// ====================
// items
// ====================
class SchColorTableItem : public SfxPoolItem, public SchColorTable
{
public:
	TYPEINFO();
	SchColorTableItem( USHORT nWhich, const SchColorTable& );
	SchColorTableItem( const SchColorTableItem& );

	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual int 			operator==( const SfxPoolItem& ) const;
	void					SetOptions( SchOptions* pOpts ) const;
};

#endif	// _SCH_SCHOPT_HXX

