/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: indexentrysupplier_ja_phonetic.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/31 18:34:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _I18N_INDEXENTRYSUPPLIER_JA_PHONETIC_HXX_
#define _I18N_INDEXENTRYSUPPLIER_JA_PHONETIC_HXX_

#include <indexentrysupplier_common.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

//	----------------------------------------------------
//	class IndexEntrySupplier_ja_phonetic
//	----------------------------------------------------

class IndexEntrySupplier_ja_phonetic : public IndexEntrySupplier_Common {
public:
	IndexEntrySupplier_ja_phonetic( const com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory >& rxMSF ) : IndexEntrySupplier_Common(rxMSF) {
		implementationName = "com.sun.star.i18n.IndexEntrySupplier_ja_phonetic";
	};
	virtual rtl::OUString SAL_CALL getIndexCharacter( const rtl::OUString& rIndexEntry,\
		const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) \
		throw (com::sun::star::uno::RuntimeException);\
	virtual rtl::OUString SAL_CALL getIndexKey( const rtl::OUString& IndexEntry, \
		const rtl::OUString& PhoneticEntry, const com::sun::star::lang::Locale& rLocale )\
		throw (com::sun::star::uno::RuntimeException);\
	virtual sal_Int16 SAL_CALL compareIndexEntry( const rtl::OUString& IndexEntry1,\
		const rtl::OUString& PhoneticEntry1, const com::sun::star::lang::Locale& rLocale1,\
		const rtl::OUString& IndexEntry2, const ::rtl::OUString& PhoneticEntry2,\
		const com::sun::star::lang::Locale& rLocale2 )\
		throw (com::sun::star::uno::RuntimeException);\
};

#define INDEXENTRYSUPPLIER_JA_PHONETIC( algorithm ) \
class IndexEntrySupplier_##algorithm : public IndexEntrySupplier_ja_phonetic {\
public:\
	IndexEntrySupplier_##algorithm (const com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory >& rxMSF) : IndexEntrySupplier_ja_phonetic (rxMSF) {\
		implementationName = "com.sun.star.i18n.IndexEntrySupplier_"#algorithm;\
	};\
	virtual sal_Bool SAL_CALL loadAlgorithm(\
		const com::sun::star::lang::Locale& rLocale,\
		const rtl::OUString& SortAlgorithm, sal_Int32 collatorOptions ) \
		throw (com::sun::star::uno::RuntimeException);\
};

INDEXENTRYSUPPLIER_JA_PHONETIC( ja_phonetic_alphanumeric_first_by_syllable )
INDEXENTRYSUPPLIER_JA_PHONETIC( ja_phonetic_alphanumeric_first_by_consonant )
INDEXENTRYSUPPLIER_JA_PHONETIC( ja_phonetic_alphanumeric_last_by_syllable )
INDEXENTRYSUPPLIER_JA_PHONETIC( ja_phonetic_alphanumeric_last_by_consonant )

} } } } 
#endif
