/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ScaleAutomatism.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:36:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_SCALEAUTOMATISM_HXX
#define _CHART2_SCALEAUTOMATISM_HXX

#ifndef _COM_SUN_STAR_CHART2_EXPLICITINCREMENTDATA_HPP_
#include <com/sun/star/chart2/ExplicitIncrementData.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_EXPLICITSCALEDATA_HPP_
#include <com/sun/star/chart2/ExplicitScaleData.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_INCREMENTDATA_HPP_
#include <com/sun/star/chart2/IncrementData.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_SCALEDATA_HPP_
#include <com/sun/star/chart2/ScaleData.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_SUBINCREMENT_HPP_
#include <com/sun/star/chart2/SubIncrement.hpp>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

//-----------------------------------------------------------------------------
/**
*/

class ScaleAutomatism
{
public:
    double    m_fValueMinimum;
    double    m_fValueMaximum;
    sal_Int32 m_nMaximumAutomaticMainIncrementCount;
    ::com::sun::star::chart2::ScaleData     m_aSourceScale;
    ::com::sun::star::chart2::IncrementData m_aSourceIncrement;
    ::com::sun::star::uno::Sequence<
        ::com::sun::star::chart2::SubIncrement > m_aSourceSubIncrementList;

    ScaleAutomatism( const ::com::sun::star::chart2::ScaleData& rSourceScale );
    ScaleAutomatism( const ::com::sun::star::chart2::ScaleData& rSourceScale
        , const ::com::sun::star::chart2::IncrementData& rSourceIncrement
        , const ::com::sun::star::uno::Sequence<
            ::com::sun::star::chart2::SubIncrement >& rSourceSubIncrementList );
    virtual ~ScaleAutomatism();

    void calculateExplicitScaleAndIncrement(
          ::com::sun::star::chart2::ExplicitScaleData& rExplicitScale
        , ::com::sun::star::chart2::ExplicitIncrementData& rExplicitIncrement );
private:
    ScaleAutomatism();//no default constructor
};

//.............................................................................
} //namespace chart
//.............................................................................
#endif
