/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: id_gener.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:58:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_ID_GENER_HXX
#define ARY_ID_GENER_HXX



// USED SERVICES
	// BASE CLASSES
#include <ary/idg.hxx>
	// COMPONENTS
	// PARAMETERS


namespace ary
{


class Std_IdGenerator : public IdGenerator
{
  public:
    // LIFECYCLE
						Std_IdGenerator();
						~Std_IdGenerator();

  private:
    // Interface IdGenerator:
    virtual Cid         do_NewCid();
    virtual Tid         do_NewTid();
    virtual cpp::Did    do_NewDid();
    virtual Gid         do_NewGid();
    virtual Lid         do_NewLid();
    virtual OSid        do_NewOSid();

    virtual udmstri     do_NewAnonymousName(
                            char                i_cStart );

    virtual Gid         inq_Id_TopProject() const;
    virtual Cid         inq_Id_GlobalNamespace_Cpp() const;
    virtual Tid         inq_FirstId_BuiltInTypes() const;
    virtual Tid         inq_IdEllipse() const;
	// DATA
    UINT32              nIds;
    Tid                 nTids;
    Lid                 nLids;
    OSid                nOSids;
    cpp::Did            nDids;

    uintt               nAnonymous;
};



// IMPLEMENTATION


}   // namespace ary


#endif





