/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DocTypeCatalog.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:45:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.io.File;
import java.util.Hashtable;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.parser.Resolver;

public final class DocTypeCatalog {
    private final Hashtable _types = new Hashtable();
    
    public DocTypeCatalog(URL configURL) throws IOException, SAXException { 
	parseCfg(configURL);
    }

    public String getDocTypeResourceValue(String doctype, String resourceName){
	final Element docTypeEl = (Element)_types.get(doctype);
	return docTypeEl != null
	    ? docTypeEl.getAttribute(resourceName)
	    : null;
    } 

    public String getTocTransformUrlString(String type){
	return getDocTypeResourceValue(type, "tocXForm");
    }
    
    public String getToHtmlTransformUrlString(String type){
	return getDocTypeResourceValue(type, "toHtmlXForm");
    }
    
    public String getModel(String type){
	return getDocTypeResourceValue(type, "model");
    }
    
    private void parseCfg(URL cfgFileLocation)
	throws IOException, SAXException {
	InputSource input = Resolver.createInputSource(cfgFileLocation, true);
	XmlDocument document = XmlDocument.createXmlDocument(input, false);
	Element catalog = document.getDocumentElement();
	NodeList list = catalog.getElementsByTagName("DocType");
	final int listLength = list.getLength();
	for(int i = 0; i < listLength; i++){
	    Element docTypeEl = (Element)list.item(i);
	    _types.put(docTypeEl.getAttribute("type"), docTypeEl);
	}
    }
}
