/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_crsrsh1.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:24:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <bf_svx/svdobj.hxx>
#endif

#include "crsrsh.hxx"
#include "rootfrm.hxx"
#include "viewimp.hxx"
#include "pam.hxx"
#include "errhdl.hxx"			// fuer ASSERT
#include "dview.hxx"
#include "viscrs.hxx"
#include "swregion.hxx"
namespace binfilter {


// erfrage die selektierte "Region" aller Cursor (fuer D&D auf Mac)
Region SwCrsrShell::GetCrsrRegion() const
{
	SwShellCrsr* pTmp = (SwShellCrsr*)pCurCrsr;
	PolyPolygon aPP;

	// sind Flys selektiert ??
	BOOL bSelFly = Imp()->GetDrawView() && Imp()->GetDrawView()->HasMarkedObj();

	if( bSelFly )
	{
		Rectangle aRect( VisArea().SVRect() );
		// hole den zuletzt selk. Fly
		const SdrMarkList &rMrkList = Imp()->GetDrawView()->GetMarkList();
		SdrObject *pObj = rMrkList.GetMark( rMrkList.GetMarkCount()-1 )->GetObj();
		ASSERT( pObj && pObj->IsVirtualObj(), "UUPs, kein oder kein virtuales Obj" );

		aRect.Intersection( pObj->GetSnapRect() );
		aPP.Insert( Polygon( aRect ) );
	}
	else if( pTblCrsr )
	{
		pTblCrsr->FillRects();
		for( USHORT n = pTblCrsr->Count(); n; )
		{
			Polygon aTmpPoly( (*pTblCrsr)[ --n ].SVRect() );
			aPP.Insert( aTmpPoly );
		}
	}
	else
	{
		SwRootFrm* pTmpFrm = GetLayout();
		BOOL bIsTblMode = IsTableMode();
		do {
			if( pTmp->HasMark() )
			{
				SwShellCrsr aTmp( *(SwCrsrShell*)this, *pTmp->GetPoint(),
									pTmp->GetPtPos() );
				aTmp.SetMark();
				*aTmp.GetMark() = *pTmp->GetMark();
				aTmp.GetMkPos() = pTmp->GetMkPos();

				pTmpFrm->CalcFrmRects( aTmp, bIsTblMode );
				for( USHORT n = 0; n < aTmp.Count(); ++n )
				{
					Polygon aTmpPoly( aTmp[ n ].SVRect() );
					aPP.Insert( aTmpPoly );
				}
				aTmp.Remove( 0, aTmp.Count() );
			}
		} while( pCurCrsr != ( pTmp = (SwShellCrsr*)*((SwCursor*)pTmp->GetNext() )));
	}
	return aPP;
}



}
