/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sbaexpl2.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:30:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _OFA_SBAEXPL2_HXX
#define _OFA_SBAEXPL2_HXX

#ifndef _OFA_SBAEXPL_HXX
#include "sbaexpl.hxx"
#endif

#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif

#ifndef _EXPCONT_HXX //autogen
#include <bf_sfx2/expcont.hxx>
#endif

#ifndef _EXPLMENU_HXX //autogen
#include <bf_sfx2/explmenu.hxx>
#endif

#ifndef _ICON_HXX //autogen
#include <vcl/icon.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
namespace binfilter {


class SbaDatabase;
class SbaDatabaseContainer;

//-------------------------------------------------------------------------
// Container von Queries(Explorer)

class SbaQueryContainer: public SbaDBFolder
{
	friend class SbaQueryContent;

public:
	TYPEINFO();
	SbaQueryContainer();

protected:
	virtual Image GetImage( SfxExplorerContentImage eImage );
	virtual void Load(BOOL);
	virtual Icon GetIcon();
	virtual String ToURL() const;
	virtual String GetUniqueName();
	virtual void CallWizardImpl();
};

//-------------------------------------------------------------------------
// eine Tabelle

class SbaQueryContent: public SbaDBContent
{
protected:
	SbaQueryContent():SbaDBContent(dbQuery,CONTENT_URLTOOPEN |
								   CONTENT_INPLACECONSTRUCTION |
								   CONTENT_BROWSERVIEWAVAILABLE, TRUE){}

	SbaQueryContent(SfxExplorerContentStyle nStyle);

public:
	TYPEINFO();
	SbaQueryContent(const String& rTitle, SbaDatabase* pDatabase);
	SbaQueryContent(SbaDBDef& rObj);

protected:
	virtual Image GetImage( SfxExplorerContentImage eImage );
	virtual void Destroy();

	virtual BOOL Initialize(const String&);
	virtual BOOL Initialize(SfxExplorerContent* pParent);
	virtual void Open(const String& rTargetFrame);
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual BOOL TitleEdited(SfxExplorerContentView*, const String& rNewTitel);
	virtual BOOL Save();

private:
	DECL_LINK(OnDesignView, void* );
	DECL_LINK(OnSQLView,void*);
};

// Content der nur ueber URL erzeugt wird
class SbaStatementContent: public SbaQueryContent
{
	SbaStatementContent();
	String aStatement;

public:
	TYPEINFO();
	virtual BOOL Initialize(const String&);
	virtual String ToURL() const;
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);

protected:
	virtual SbaDBDef* GetDBObj() const;
};

} //namespace binfilter
#endif


