/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.io;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.io.ListEventToBytes;
import ca.odell.glazedlists.impl.rbp.Resource;
import ca.odell.glazedlists.impl.rbp.ResourceListener;
import ca.odell.glazedlists.impl.rbp.ResourceStatus;
import ca.odell.glazedlists.impl.rbp.ResourceStatusListener;
import ca.odell.glazedlists.io.ByteCoder;
import ca.odell.glazedlists.io.NetworkListStatusListener;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NetworkList
extends TransformedList {
    private List resourceListeners = new ArrayList();
    private List statusListeners = new ArrayList();
    private ByteCoder byteCoder;
    private ResourceStatus resourceStatus = null;
    private boolean writable = false;
    private PrivateInterfaces privateInterfaces = new PrivateInterfaces();

    NetworkList(EventList source, ByteCoder byteCoder) {
        super(source);
        this.byteCoder = byteCoder;
        source.addListEventListener(this);
    }

    void setResourceStatus(ResourceStatus resourceStatus) {
        if (this.resourceStatus != null) {
            throw new IllegalStateException();
        }
        this.resourceStatus = resourceStatus;
        resourceStatus.addResourceStatusListener(this.privateInterfaces);
    }

    void setWritable(boolean writable) {
        this.writable = writable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    Resource getResource() {
        return this.privateInterfaces;
    }

    public void listChanged(ListEvent listChanges) {
        try {
            ListEvent listChangesCopy = new ListEvent(listChanges);
            Bufferlo listChangesBytes = ListEventToBytes.toBytes(listChangesCopy, this.byteCoder);
            for (int r = 0; r < this.resourceListeners.size(); ++r) {
                ResourceListener listener = (ResourceListener)this.resourceListeners.get(r);
                listener.resourceUpdated(this.privateInterfaces, listChangesBytes.duplicate());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.updates.forwardEvent(listChanges);
    }

    public boolean isConnected() {
        return this.resourceStatus.isConnected();
    }

    public void connect() {
        this.resourceStatus.connect();
    }

    public void disconnect() {
        this.resourceStatus.disconnect();
    }

    public void addStatusListener(NetworkListStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(NetworkListStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public void dispose() {
        this.resourceStatus.removeResourceStatusListener(this.privateInterfaces);
        this.disconnect();
        super.dispose();
    }

    private class PrivateInterfaces
    implements Resource,
    ResourceStatusListener {
        private PrivateInterfaces() {
        }

        public void resourceConnected(ResourceStatus resource) {
            Iterator i = NetworkList.this.statusListeners.iterator();
            while (i.hasNext()) {
                NetworkListStatusListener listener = (NetworkListStatusListener)i.next();
                listener.connected(NetworkList.this);
            }
        }

        public void resourceDisconnected(ResourceStatus resource, Exception cause) {
            Iterator i = NetworkList.this.statusListeners.iterator();
            while (i.hasNext()) {
                NetworkListStatusListener listener = (NetworkListStatusListener)i.next();
                listener.disconnected(NetworkList.this, cause);
            }
        }

        public Bufferlo toSnapshot() {
            this.getReadWriteLock().writeLock().lock();
            try {
                Bufferlo bufferlo = ListEventToBytes.toBytes(NetworkList.this, NetworkList.this.byteCoder);
                return bufferlo;
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }

        public void fromSnapshot(Bufferlo snapshot) {
            this.applyCodedEvent(snapshot);
        }

        private void applyCodedEvent(Bufferlo data) {
            this.getReadWriteLock().writeLock().lock();
            try {
                NetworkList.this.updates.beginEvent(true);
                ListEventToBytes.toListEvent(data, NetworkList.this.source, NetworkList.this.byteCoder);
                NetworkList.this.updates.commitEvent();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }

        public void update(Bufferlo delta) {
            this.applyCodedEvent(delta);
        }

        public void addResourceListener(ResourceListener listener) {
            NetworkList.this.resourceListeners.add(listener);
        }

        public void removeResourceListener(ResourceListener listener) {
            for (int r = 0; r < NetworkList.this.resourceListeners.size(); ++r) {
                if (NetworkList.this.resourceListeners.get(r) != listener) continue;
                NetworkList.this.resourceListeners.remove(r);
                return;
            }
        }

        public ReadWriteLock getReadWriteLock() {
            return NetworkList.this.getReadWriteLock();
        }

        public String toString() {
            return NetworkList.this.toString();
        }
    }
}

